/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models.remotefileselector2;

import com.sas.codepolicy.SASScope;
import com.sas.swing.models.remotefileselector2.Location;
import com.sas.swing.models.remotefileselector2.LocationNode;
import java.util.List;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

@SASScope
public class MultipleLocationsToTreeModelAdapter
implements TreeModel {
    private static final String LOCATION_ROOT = null;
    private List locations;
    private int numberOfLocations;
    private LocationNode rootNode;

    public MultipleLocationsToTreeModelAdapter(List listOfLocations) {
        this.refresh(listOfLocations);
        this.rootNode = new LocationNode("InformationServices", LOCATION_ROOT);
    }

    public void refresh(List listOfLocations) {
        if (listOfLocations != null) {
            this.locations = listOfLocations;
            this.numberOfLocations = listOfLocations.size();
        }
    }

    @Override
    public Object getRoot() {
        return this.rootNode;
    }

    @Override
    public int getChildCount(Object folderNode) {
        int childCount = 0;
        if (folderNode instanceof LocationNode) {
            if (folderNode == this.rootNode) {
                return this.numberOfLocations;
            }
            boolean childCountNotSet = true;
            for (int count = 0; childCountNotSet && count < this.numberOfLocations; ++count) {
                Location location = (Location)this.locations.get(count);
                List nodes = location.getLocationNodes();
                int numberOfLocationNodes = nodes.size();
                if (numberOfLocationNodes == 1 && nodes.contains(folderNode)) {
                    childCountNotSet = false;
                }
                int nodesProcessed = 0;
                while (childCountNotSet && nodesProcessed < numberOfLocationNodes) {
                    LocationNode node = (LocationNode)nodes.get(nodesProcessed);
                    ++nodesProcessed;
                    if (folderNode != node) continue;
                    if (nodesProcessed < numberOfLocationNodes) {
                        childCount = 1;
                    }
                    childCountNotSet = false;
                }
            }
        }
        return childCount;
    }

    @Override
    public boolean isLeaf(Object folderNode) {
        if (folderNode instanceof LocationNode) {
            boolean childNotFound = true;
            for (int count = 0; childNotFound && count < this.numberOfLocations; ++count) {
                Location location = (Location)this.locations.get(count);
                List nodes = location.getLocationNodes();
                int numberOfLocationNodes = nodes.size();
                if (numberOfLocationNodes == 1 && nodes.contains(folderNode)) {
                    childNotFound = false;
                    return true;
                }
                for (int nodesProcessed = 0; childNotFound && nodesProcessed < numberOfLocationNodes; ++nodesProcessed) {
                    LocationNode node = (LocationNode)nodes.get(nodesProcessed);
                    if (folderNode != node) continue;
                    if (nodesProcessed < numberOfLocationNodes) {
                        return false;
                    }
                    childNotFound = false;
                }
            }
        }
        return true;
    }

    @Override
    public void addTreeModelListener(TreeModelListener arg0) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener arg0) {
    }

    @Override
    public Object getChild(Object folderNode, int index) {
        Object child = null;
        if (folderNode instanceof LocationNode) {
            if (folderNode == this.rootNode) {
                Location itemLocations = (Location)this.locations.get(index);
                List nodes = itemLocations.getLocationNodes();
                return nodes.get(0);
            }
            boolean childNotFound = true;
            for (int count = 0; childNotFound && count < this.numberOfLocations; ++count) {
                Location location = (Location)this.locations.get(count);
                List nodes = location.getLocationNodes();
                int numberOfLocationNodes = nodes.size();
                int nodesProcessed = 0;
                while (childNotFound && nodesProcessed < numberOfLocationNodes) {
                    LocationNode node = (LocationNode)nodes.get(nodesProcessed);
                    ++nodesProcessed;
                    if (folderNode != node) continue;
                    if (nodesProcessed < numberOfLocationNodes) {
                        child = nodes.get(nodesProcessed);
                    }
                    childNotFound = false;
                }
            }
        }
        return child;
    }

    @Override
    public int getIndexOfChild(Object folder, Object subFolder) {
        if (folder == null || subFolder == null) {
            return -1;
        }
        return 0;
    }

    @Override
    public void valueForPathChanged(TreePath arg0, Object arg1) {
    }
}

