/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models.remotefileselector2;

import com.sas.codepolicy.SASScope;
import com.sas.swing.models.remotefileselector2.BaseRemoteFileModelInterface;
import com.sas.util.ValueItem;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

@SASScope
public class LocationToTreeModelAdapter
implements TreeModel {
    private String[][] locationsAndFolders;
    private int numberOfFolders;
    private BaseRemoteFileModelInterface model;

    public LocationToTreeModelAdapter(String location, BaseRemoteFileModelInterface fileModel) {
        if (fileModel != null) {
            this.model = fileModel;
            this.locationsAndFolders = this.model.parseIntoFoldersAndLocations(location);
            this.numberOfFolders = this.locationsAndFolders.length;
        }
    }

    public LocationToTreeModelAdapter(String[][] pathsAndFileNames) {
        if (pathsAndFileNames == null) {
            throw new IllegalArgumentException();
        }
        this.locationsAndFolders = pathsAndFileNames;
        this.numberOfFolders = this.locationsAndFolders.length;
    }

    public void refresh(String location) {
        if (this.model != null) {
            this.locationsAndFolders = this.model.parseIntoFoldersAndLocations(location);
            this.numberOfFolders = this.locationsAndFolders.length;
        }
    }

    public void refresh(String[][] pathsAndFileNames) {
        if (pathsAndFileNames != null) {
            this.locationsAndFolders = pathsAndFileNames;
            this.numberOfFolders = this.locationsAndFolders.length;
        }
    }

    public void refresh() {
        if (this.model != null) {
            this.locationsAndFolders = this.model.parseIntoFoldersAndLocations(this.model.getLocation());
            this.numberOfFolders = this.locationsAndFolders.length;
        }
    }

    public void setModel(BaseRemoteFileModelInterface fileModel) {
        if (fileModel != null && fileModel != this.model) {
            this.model = fileModel;
        }
    }

    public BaseRemoteFileModelInterface getModel() {
        return this.model;
    }

    @Override
    public Object getRoot() {
        int rootIndex = this.numberOfFolders - 1;
        return new ValueItem((Object)this.locationsAndFolders[rootIndex][1], (Object)this.locationsAndFolders[rootIndex][0]);
    }

    @Override
    public int getChildCount(Object folderNode) {
        ValueItem itemNode;
        String itemValue;
        if (folderNode instanceof ValueItem && (itemValue = (String)(itemNode = (ValueItem)folderNode).getValue()).equals(this.locationsAndFolders[0][0])) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean isLeaf(Object arg0) {
        return false;
    }

    @Override
    public void addTreeModelListener(TreeModelListener arg0) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener arg0) {
    }

    @Override
    public Object getChild(Object folder, int index) {
        int parentFolderIndex = -1;
        if (folder instanceof ValueItem) {
            boolean folderNotFound = true;
            ValueItem itemNode = (ValueItem)folder;
            String itemValue = (String)itemNode.getValue();
            int i = 0;
            while (folderNotFound) {
                String testValue = this.locationsAndFolders[i][0];
                if (testValue.equals(itemValue)) {
                    folderNotFound = false;
                    parentFolderIndex = i;
                }
                ++i;
            }
            if (parentFolderIndex == 0) {
                return null;
            }
            return new ValueItem((Object)this.locationsAndFolders[parentFolderIndex - 1][1], (Object)this.locationsAndFolders[parentFolderIndex - 1][0]);
        }
        return null;
    }

    @Override
    public int getIndexOfChild(Object folder, Object subFolder) {
        if (folder == null || subFolder == null) {
            return -1;
        }
        return 0;
    }

    @Override
    public void valueForPathChanged(TreePath arg0, Object arg1) {
    }
}

