/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models.remotefileselector.informationservices;

import com.sas.actionprovider.BaseActionProvider;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.FilteredFolderInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.util.ISUtility;
import com.sas.services.user.UserContextInterface;
import com.sas.swing.models.remotefileselector.RemoteFileServerModelInterface;
import com.sas.swing.models.remotefileselector.RemoteFileServiceModelInterface;
import com.sas.swing.models.remotefileselector.informationservices.InformationServicesFileMetadata;
import com.sas.swing.models.remotefileselector.informationservices.InformationServicesSearchModel2;
import com.sas.swing.visuals.remotefileselector.RB;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.event.SwingPropertyChangeSupport;

public class InformationServicesModel2
implements RemoteFileServiceModelInterface {
    public static final String RB_KEY = "RemoteFileSelector.";
    public static final String REPORTS = "Report";
    public static final String INFOMAP = "InformationMap";
    public static final String STPROC = "StoredProcess";
    protected RepositoryInterface repository;
    protected List filterValues;
    protected FilterInterface searchFilter;
    protected FilteredFolderInterface filteredFolder;
    protected List allFileList;
    protected FilterComponent filterComp;
    protected FolderInterface startFolder;
    protected RemoteFileServerModelInterface remoteFileServerModel;
    protected BaseActionProvider actionProvider;
    protected Date startDate;
    protected Date endDate;
    private SwingPropertyChangeSupport spcs;
    private List reposList;
    private UserContextInterface user;
    private String path;

    public InformationServicesModel2(RepositoryInterface repository) {
        this.repository = repository;
        this.reposList = new ArrayList(1);
        this.reposList.add(repository);
        this.spcs = new SwingPropertyChangeSupport(this);
    }

    public InformationServicesModel2(UserContextInterface user) {
        this.user = user;
        try {
            this.reposList = user.getRepositories();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (this.reposList.size() < 1) {
            throw new IllegalArgumentException();
        }
        this.spcs = new SwingPropertyChangeSupport(this);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.removePropertyChangeListener(listener);
    }

    @Override
    public List getFiles(String path) {
        ArrayList returnList = new ArrayList();
        ArrayList<String> piecesList = new ArrayList<String>();
        if (path == null) {
            path = "";
        }
        this.path = path = this.removeEndingSlash(path);
        for (RepositoryInterface repository : this.reposList) {
            this.allFileList = new ArrayList();
            if (path.equals("")) {
                if (this.searchFilter == null) {
                    if (this instanceof InformationServicesSearchModel2) continue;
                    try {
                        List tempList = repository.getRootFolders();
                        for (int i = tempList.size() - 1; i >= 0; --i) {
                            FolderInterface addFolder = (FolderInterface)tempList.get(i);
                            for (InformationServicesFileMetadata returnFolder : returnList) {
                                if (!addFolder.getName().equals(returnFolder.getName())) continue;
                                tempList.remove(i);
                            }
                        }
                        for (FolderInterface folder : tempList) {
                            String key = folder.getEntityKey();
                            this.allFileList.add(repository.browseFetch(key, null));
                        }
                        returnList.addAll(this.buildMetadata());
                    }
                    catch (ServiceException e) {
                        LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                    }
                    catch (RemoteException e) {
                        LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                ((InformationServicesSearchModel2)this).setRecursive(true);
                try {
                    List rootFolders = repository.getRootFolders();
                    int size = rootFolders.size();
                    for (int i = 0; i < size; ++i) {
                        this.repository = repository;
                        FolderInterface rootFolder = (FolderInterface)rootFolders.get(i);
                        returnList.addAll(this.getFolderInterfaceFiles(rootFolder));
                        this.repository = null;
                    }
                    continue;
                }
                catch (ServiceException e) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                    continue;
                }
                catch (RemoteException e) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                    continue;
                }
            }
            if (path.equals("")) continue;
            FolderInterface folder = null;
            this.startFolder = null;
            String tempPath = path;
            piecesList.clear();
            String fileName = null;
            while (tempPath != null && !tempPath.equals("")) {
                String[] stringArray = this.splitDirectoryPathAndFileName(tempPath);
                tempPath = stringArray[1];
                fileName = stringArray[0];
                if (fileName.equals("")) {
                    if (!tempPath.equals("")) {
                        piecesList.add(tempPath);
                    }
                    tempPath = null;
                    continue;
                }
                piecesList.add(fileName);
            }
            for (int i = piecesList.size() - 1; i >= 0; --i) {
                if (i == piecesList.size() - 1) {
                    try {
                        folder = repository.getRootFolder((String)piecesList.get(piecesList.size() - 1));
                    }
                    catch (ServiceException e) {
                        LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                    }
                    catch (RemoteException e) {
                        LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                    }
                } else {
                    try {
                        if (this.startFolder != null) {
                            folder = this.startFolder.getSubfolder((String)piecesList.get(i));
                        }
                    }
                    catch (ServiceException e) {
                        LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                    }
                    catch (RemoteException e) {
                        LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                    }
                }
                this.startFolder = folder != null ? folder : null;
            }
            if (this.startFolder != null) {
                this.repository = repository;
                returnList.addAll(this.getFolderInterfaceFiles(this.startFolder));
                this.repository = null;
                continue;
            }
            if (this.reposList.size() != 1) continue;
            try {
                List tempList = repository.getRootFolders();
                for (FolderInterface tempfolder : tempList) {
                    String key = tempfolder.getEntityKey();
                    this.allFileList.add(repository.browseFetch(key, null));
                }
                returnList.addAll(this.buildMetadata());
            }
            catch (ServiceException e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
            }
            catch (RemoteException e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
            }
        }
        return returnList;
    }

    public List getFolderInterfaceFiles(FolderInterface folder) {
        block11: {
            if (folder == null) {
                throw new IllegalArgumentException();
            }
            this.startFolder = folder;
            this.allFileList = new ArrayList();
            Object itemFilter = null;
            itemFilter = this.searchFilter != null ? this.searchFilter : new Filter();
            itemFilter.setOMRRepository(this.getTopLevelNameForRepository(this.repository));
            itemFilter.setOMRFlags(16);
            if (this.searchFilter != null) {
                try {
                    boolean searchLevels = false;
                    itemFilter.setType("Cube");
                    if (!(this instanceof InformationServicesSearchModel2)) break block11;
                    if (((InformationServicesSearchModel2)this).getRecursive()) {
                        this.allFileList = this.repository.browseFolderRecursive(folder.getEntityKey(), itemFilter);
                        break block11;
                    }
                    this.allFileList = this.repository.browseFolder(folder.getEntityKey(), itemFilter);
                }
                catch (ServiceException e) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                }
                catch (RemoteException e) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                }
            } else {
                try {
                    String folderKey = folder.getEntityKey();
                    this.allFileList.addAll(this.repository.browseFolder(folderKey, itemFilter));
                }
                catch (IllegalStateException e) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                }
                catch (ServiceException e) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                }
                catch (RemoteException e) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return this.buildMetadata();
    }

    private List buildMetadata() {
        String name = null;
        Object realFolder = null;
        Object itemsFileList = null;
        ArrayList<InformationServicesFileMetadata> returnList = new ArrayList<InformationServicesFileMetadata>();
        String folderImage = RB.getStringResource(RB_KEY, "folderImage.image");
        String fileImage = RB.getStringResource(RB_KEY, "fileImage.image");
        int numberOfFiles = this.allFileList.size();
        List keywords = new ArrayList();
        for (int i = 0; i < numberOfFiles; ++i) {
            boolean drillable;
            String icon;
            String author = "";
            String description = "";
            Date modifiedDateTime = null;
            Date createdDateTime = null;
            Object serviceObject = null;
            BrowseMetadataInterface item = (BrowseMetadataInterface)this.allFileList.get(i);
            if (!this.filterData(item)) continue;
            name = item.getName();
            if (item.isAFolder()) {
                icon = folderImage;
                drillable = true;
            } else {
                icon = fileImage;
                drillable = false;
            }
            description = item.getDescription();
            modifiedDateTime = new Date(item.getModifyDate());
            createdDateTime = new Date(item.getCreateDate());
            BrowseMetadataInterface entity = item;
            if (!item.isAFolder()) {
                keywords = item.getKeywords();
                List rps = (List)item.get("ResponsibleParties");
                if (rps != null) {
                    for (BrowseMetadataInterface rpBmi : rps) {
                        List ownerList;
                        String role = (String)rpBmi.get("Role");
                        if (!role.equalsIgnoreCase("Owner") || (ownerList = (List)rpBmi.get("Persons")) == null) continue;
                        for (BrowseMetadataInterface ownBmi : ownerList) {
                            author = ownBmi.getName();
                        }
                    }
                }
            }
            String filePath = "";
            try {
                PathUrl pathUrl = null;
                if (this instanceof InformationServicesSearchModel2 && ((InformationServicesSearchModel2)this).getRecursive()) {
                    if (this.user == null) {
                        this.user = this.repository.getUserContext();
                    }
                    pathUrl = ISUtility.getPathFromEntityKey((UserContextInterface)this.user, (String)item.getISEntityKey());
                } else {
                    String topLevelName = this.getTopLevelNameForRepository(this.repository);
                    String itemType = item.getSmartType();
                    StringBuffer pathUrlSB = new StringBuffer(11 + topLevelName.length() + this.path.length() + name.length() + itemType.length());
                    pathUrlSB.append("SBIP://");
                    pathUrlSB.append(topLevelName);
                    pathUrlSB.append("/");
                    pathUrlSB.append(this.path);
                    pathUrlSB.append("/");
                    pathUrlSB.append(name);
                    pathUrlSB.append("(");
                    pathUrlSB.append(itemType);
                    pathUrlSB.append(")");
                    pathUrl = new PathUrl(pathUrlSB.toString());
                }
                filePath = pathUrl != null ? ((filePath = pathUrl.getPath()) == null ? (item.getName().equals(pathUrl.getRootTree()) ? "/" : pathUrl.getRootTree() + "/") : pathUrl.getRootTree() + "/" + filePath + "/") : null;
                if (filePath == null) continue;
                InformationServicesFileMetadata metadataNode = new InformationServicesFileMetadata(name, icon, drillable, author, modifiedDateTime, createdDateTime, keywords, description, filePath, item, pathUrl);
                returnList.add(metadataNode);
                continue;
            }
            catch (RemoteException e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                continue;
            }
            catch (ServiceException e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
            }
        }
        return returnList;
    }

    protected boolean filterData(BrowseMetadataInterface item) {
        boolean value = false;
        if (this.filterValues != null) {
            if (this.filterValues.get(0).equals("*")) {
                value = true;
            } else if (!item.isAFolder()) {
                String type;
                if (item.getNativeType().equals("Transformation")) {
                    type = (String)item.get("TransformRole");
                    if (this.filterValues.contains(type)) {
                        value = true;
                    }
                } else {
                    type = item.getSmartType();
                    if (this.filterValues.contains(type)) {
                        value = true;
                    }
                }
            } else {
                value = true;
            }
        } else {
            value = true;
        }
        if (this.startDate != null && this.endDate != null && this.searchFilter != null) {
            Date dateTime = null;
            dateTime = ((InformationServicesSearchModel2)this).getDateSearchType() == 0 ? new Date(item.getModifyDate()) : new Date(item.getCreateDate());
            value = this.startDate.before(dateTime) && this.endDate.after(dateTime);
        }
        return value;
    }

    @Override
    public String[] splitDirectoryPathAndFileName(String path) {
        String shortName = null;
        String returnedPath = null;
        String[] stringArray = new String[2];
        int index = path.lastIndexOf("/");
        if (index != -1) {
            shortName = path.substring(index + 1);
            returnedPath = path.substring(0, index);
        } else {
            shortName = path;
            returnedPath = "";
        }
        stringArray[0] = shortName;
        stringArray[1] = returnedPath;
        return stringArray;
    }

    @Override
    public String combineDirectoryPathAndFileName(String path, String name) {
        path = this.removeEndingSlash(path);
        String fullName = null;
        fullName = path.equals("") ? name : (path.endsWith("/") ? path + name : path + "/" + name);
        return fullName;
    }

    @Override
    public String getTopLevelName() {
        String name = null;
        try {
            if (this.repository != null) {
                name = this.repository.getISName();
            } else if (this.reposList.size() == 1) {
                if (this.repository == null) {
                    this.repository = (RepositoryInterface)this.reposList.get(0);
                }
                this.repository = (RepositoryInterface)this.reposList.get(0);
                name = this.repository.getISName();
            } else {
                name = RB.getStringResource(RB_KEY, "infoservice.txt");
            }
        }
        catch (RemoteException e) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        return name;
    }

    private String getTopLevelName(RepositoryInterface repository) {
        String name = null;
        try {
            if (repository != null) {
                name = repository.getISName();
            }
        }
        catch (RemoteException e) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        return name;
    }

    private String getTopLevelNameForRepository(RepositoryInterface repository) {
        String name = "";
        try {
            if (repository != null) {
                name = repository.getISName();
            }
        }
        catch (RemoteException e) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        return name;
    }

    @Override
    public String getFullyQualifiedPath(String currentPath, String fileName) {
        String SBIPPath = "SBIP://" + this.getTopLevelNameForRepository(this.repository) + "/" + currentPath;
        String fullName = this.combineDirectoryPathAndFileName(SBIPPath, fileName);
        return fullName;
    }

    @Override
    public String getDirectoryPath(String path) {
        String returnPath = path = this.removeEndingSlash(path);
        int index = path.indexOf("//");
        if (index >= 0) {
            returnPath = path.substring(index + 1);
            String name = null;
            for (RepositoryInterface repository : this.reposList) {
                name = this.getTopLevelName(repository);
                index = returnPath.indexOf(name);
                if (index < 0) continue;
                returnPath = returnPath.substring(index + name.length() + 1);
            }
        }
        FolderInterface folder = null;
        FolderInterface lastFolder = null;
        ArrayList<String> piecesList = new ArrayList<String>();
        String fileName = null;
        String folderName = null;
        String tempPath = returnPath;
        returnPath = "";
        while (tempPath != null && !tempPath.equals("")) {
            String[] stringArray = this.splitDirectoryPathAndFileName(tempPath);
            tempPath = stringArray[1];
            fileName = stringArray[0];
            if (fileName.equals("")) {
                if (!tempPath.equals("")) {
                    piecesList.add(tempPath);
                }
                tempPath = null;
                continue;
            }
            piecesList.add(fileName);
        }
        for (int i = piecesList.size() - 1; i >= 0; --i) {
            if (i == piecesList.size() - 1) {
                try {
                    folderName = (String)piecesList.get(piecesList.size() - 1);
                    for (RepositoryInterface repository : this.reposList) {
                        folder = repository.getRootFolder(folderName);
                        if (folder == null) continue;
                    }
                }
                catch (ServiceException e) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                }
                catch (RemoteException e) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                }
            } else {
                try {
                    folderName = (String)piecesList.get(i);
                    folder = lastFolder.getSubfolder(folderName);
                }
                catch (ServiceException e) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                }
                catch (RemoteException e) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                }
            }
            if (folder == null) break;
            lastFolder = folder;
            returnPath = this.combineDirectoryPathAndFileName(returnPath, folderName);
        }
        return returnPath;
    }

    private String removeEndingSlash(String path) {
        if (path.endsWith("/")) {
            int index = path.lastIndexOf("/");
            path = path.substring(0, index);
        }
        return path;
    }

    @Override
    public void setFilterValues(List filterValues) {
        this.filterValues = filterValues;
    }

    @Override
    public List getFilterValues() {
        return this.filterValues;
    }

    public void setRepository(RepositoryInterface repository) {
        this.repository = repository;
    }

    public RepositoryInterface getRepository() {
        return this.repository;
    }

    public List getRepositoryList() {
        return Collections.unmodifiableList(this.reposList);
    }
}

