/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models.remotefileselector.informationservices;

import com.sas.actionprovider.BaseActionProvider;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.impl.PersonImpl;
import com.sas.metadata.remote.impl.ResponsiblePartyImpl;
import com.sas.metadata.remote.impl.RootImpl;
import com.sas.metadata.remote.impl.TransformationImpl;
import com.sas.metadata.remote.impl.TreeImpl;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.PartialFolderResultsException;
import com.sas.services.information.PartialListResultsException;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.FilteredFolderInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.user.UserContextInterface;
import com.sas.swing.models.remotefileselector.RemoteFileServerModelInterface;
import com.sas.swing.models.remotefileselector.RemoteFileServiceModelInterface;
import com.sas.swing.models.remotefileselector.informationservices.InformationServicesFileMetadata;
import com.sas.swing.models.remotefileselector.informationservices.InformationServicesSearchModel;
import com.sas.swing.visuals.remotefileselector.RB;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.swing.event.SwingPropertyChangeSupport;

public class InformationServicesModel
implements RemoteFileServiceModelInterface {
    public static final String RB_KEY = "RemoteFileSelector.";
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    public static final String REPORTS = "Report";
    public static final String INFOMAP = "InformationMap";
    public static final String STPROC = "StoredProcess";
    protected RepositoryInterface repository;
    protected List filterValues;
    protected FilterInterface searchFilter;
    protected FilteredFolderInterface filteredFolder;
    protected List allFileList;
    protected FilterComponent filterComp;
    protected FolderInterface startFolder;
    protected String currentPath;
    protected RemoteFileServerModelInterface remoteFileServerModel;
    protected BaseActionProvider actionProvider;
    protected Date startDate;
    protected Date endDate;
    private SwingPropertyChangeSupport spcs;
    private List reposList;

    public InformationServicesModel(RepositoryInterface repository) {
        this.repository = repository;
        this.reposList = new ArrayList(1);
        this.reposList.add(repository);
        this.spcs = new SwingPropertyChangeSupport(this);
        this.currentPath = null;
    }

    public InformationServicesModel(UserContextInterface user) {
        try {
            this.reposList = user.getRepositories();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (this.reposList.size() < 1) {
            throw new IllegalArgumentException();
        }
        this.spcs = new SwingPropertyChangeSupport(this);
        this.currentPath = null;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.removePropertyChangeListener(listener);
    }

    @Override
    public List getFiles(String path) {
        ArrayList returnList = new ArrayList();
        ArrayList<String> piecesList = new ArrayList<String>();
        if (path == null) {
            path = "";
        }
        if (path.endsWith("/")) {
            int index = path.lastIndexOf("/");
            path = path.substring(0, index);
        }
        for (RepositoryInterface repository : this.reposList) {
            this.currentPath = path;
            if (path.equals("")) {
                if (this.searchFilter == null) {
                    try {
                        this.allFileList = repository.getRootFolders();
                        for (int i = this.allFileList.size() - 1; i >= 0; --i) {
                            FolderInterface addFolder = (FolderInterface)this.allFileList.get(i);
                            for (InformationServicesFileMetadata returnFolder : returnList) {
                                if (!addFolder.getName().equals(returnFolder.getName())) continue;
                                this.allFileList.remove(i);
                            }
                        }
                        returnList.addAll(this.buildMetadata(this.currentPath));
                    }
                    catch (ServiceException e) {
                        LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                    }
                    catch (RemoteException e) {
                        LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                ((InformationServicesSearchModel)this).setRecursive(true);
                try {
                    List rootFolders = repository.getRootFolders();
                    int size = rootFolders.size();
                    for (int i = 0; i < size; ++i) {
                        this.repository = repository;
                        FolderInterface rootFolder = (FolderInterface)rootFolders.get(i);
                        returnList.addAll(this.getFolderInterfaceFiles(rootFolder));
                        this.repository = null;
                    }
                    continue;
                }
                catch (ServiceException e) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                    continue;
                }
                catch (RemoteException e) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                    continue;
                }
            }
            if (path.equals("")) continue;
            FolderInterface folder = null;
            this.startFolder = null;
            String tempPath = path;
            piecesList.clear();
            String fileName = null;
            while (tempPath != null && !tempPath.equals("")) {
                String[] stringArray = this.splitDirectoryPathAndFileName(tempPath);
                tempPath = stringArray[1];
                fileName = stringArray[0];
                if (fileName.equals("")) {
                    if (!tempPath.equals("")) {
                        piecesList.add(tempPath);
                    }
                    tempPath = null;
                    continue;
                }
                piecesList.add(fileName);
            }
            for (int i = piecesList.size() - 1; i >= 0; --i) {
                if (i == piecesList.size() - 1) {
                    try {
                        folder = repository.getRootFolder((String)piecesList.get(piecesList.size() - 1));
                    }
                    catch (ServiceException e) {
                        LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                    }
                    catch (RemoteException e) {
                        LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                    }
                } else {
                    try {
                        if (this.startFolder != null) {
                            folder = this.startFolder.getSubfolder((String)piecesList.get(i));
                        }
                    }
                    catch (ServiceException e) {
                        LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                    }
                    catch (RemoteException e) {
                        LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                    }
                }
                this.startFolder = folder != null ? folder : null;
            }
            if (this.startFolder != null) {
                this.repository = repository;
                returnList.addAll(this.getFolderInterfaceFiles(this.startFolder));
                this.repository = null;
                continue;
            }
            if (this.reposList.size() != 1) continue;
            try {
                this.allFileList = repository.getRootFolders();
                returnList.addAll(this.buildMetadata(this.currentPath));
            }
            catch (ServiceException e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
            }
            catch (RemoteException e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
            }
        }
        return returnList;
    }

    public List getFolderInterfaceFiles(FolderInterface folder) {
        if (folder == null) {
            throw new IllegalArgumentException();
        }
        this.startFolder = folder;
        this.allFileList = new ArrayList();
        Object itemFilter = null;
        this.currentPath = this.getFilePath(folder);
        itemFilter = this.searchFilter != null ? this.searchFilter : new Filter();
        if (this.searchFilter != null) {
            itemFilter.setOMRRepository(this.getTopLevelNameForRepository(this.repository));
            itemFilter.setOMRFlags(16);
        }
        this.prepopulateOMRCache(folder);
        if (this.searchFilter != null) {
            try {
                int searchLevels = 0;
                if (this instanceof InformationServicesSearchModel && ((InformationServicesSearchModel)this).getRecursive()) {
                    searchLevels = 99;
                }
                this.filteredFolder = this.repository.searchTreeFromBaseWithScope(folder, itemFilter, searchLevels);
            }
            catch (ServiceException se) {
                if (se instanceof PartialFolderResultsException) {
                    this.filteredFolder = (FilteredFolderInterface)((PartialFolderResultsException)se).getResults();
                }
            }
            catch (RemoteException e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
            }
        }
        return this.buildMetadata(this.currentPath);
    }

    private void prepopulateOMRCache(FolderInterface folder) {
        if (this.repository instanceof OMIRepositoryInterface) {
            try {
                String reposID = folder.getReposId();
                Filter tempFilter = new Filter("ID", 0, reposID);
                tempFilter.setOMRRepository(this.getTopLevelNameForRepository(this.repository));
                tempFilter.setOMRTemplate("<TEMPLATES><Transformation><Keywords/><ResponsibleParties search=\"@Role='owner'\"/><Timestamps/></Transformation><ResponsibleParty Role=\"\"><Persons/></ResponsibleParty><TimeStamp DateandTime=\"\"  TimeStampRole=\"\"/><Person Id=\"\" Name=\"\"/><Tree><Members/></Tree></TEMPLATES>");
                tempFilter.setType("Tree");
                this.repository.search((FilterInterface)tempFilter);
            }
            catch (ServiceException e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
            }
            catch (RemoteException e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private String getFilePath(FolderInterface folder) {
        PathUrl pathUrl = null;
        String filePath = "";
        try {
            pathUrl = folder.getPathUrl();
            if (pathUrl != null) {
                String name;
                String type = pathUrl.getType();
                type = "(" + type + ")";
                String pathString = pathUrl.toString();
                filePath = pathString.substring(0, pathString.indexOf(type));
                int index = filePath.indexOf("//");
                if (index >= 0 && (index = (filePath = filePath.substring(index + 1)).indexOf(name = this.getTopLevelName(this.repository))) >= 0) {
                    filePath = filePath.substring(index + name.length() + 1);
                }
                filePath = filePath + "/";
            } else {
                filePath = "";
            }
        }
        catch (RemoteException e) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        return filePath;
    }

    private List traverseFilteredResults(FolderInterface folder) {
        List fileList = new ArrayList();
        try {
            List folderList = folder.getSubfolders();
            int folderListSize = folderList.size();
            if (folderListSize > 0) {
                for (int i = 0; i < folderListSize; ++i) {
                    List folderFileList = this.traverseFilteredResults((FolderInterface)folderList.get(i));
                    fileList.addAll(folderFileList);
                }
                fileList.addAll(folder.getItems());
            } else {
                fileList = folder.getItems();
            }
        }
        catch (ServiceException e) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        return fileList;
    }

    private List buildMetadata(String metadataPath) {
        String name = null;
        Object realFolder = null;
        List itemsFileList = null;
        ArrayList<InformationServicesFileMetadata> returnList = new ArrayList<InformationServicesFileMetadata>();
        String folderImage = RB.getStringResource(RB_KEY, "folderImage.image");
        String fileImage = RB.getStringResource(RB_KEY, "fileImage.image");
        if (!metadataPath.equals("")) {
            if (this.filteredFolder != null) {
                itemsFileList = new ArrayList();
                if (this.searchFilter != null) {
                    itemsFileList = this.traverseFilteredResults((FolderInterface)this.filteredFolder);
                } else {
                    try {
                        itemsFileList = this.filteredFolder.getItems();
                    }
                    catch (ServiceException se) {
                        if (se instanceof PartialListResultsException) {
                            itemsFileList = ((PartialListResultsException)se).getResults();
                        }
                    }
                    catch (RemoteException e) {
                        LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                    }
                }
            } else if (!(this instanceof InformationServicesSearchModel)) {
                try {
                    itemsFileList = this.startFolder.getItems();
                }
                catch (ServiceException se) {
                    if (se instanceof PartialListResultsException) {
                        itemsFileList = ((PartialListResultsException)se).getResults();
                    }
                }
                catch (RemoteException e) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                }
            }
            if (!(this instanceof InformationServicesSearchModel)) {
                List folderFileList = null;
                try {
                    folderFileList = this.startFolder.getSubfolders();
                }
                catch (ServiceException se) {
                    if (se instanceof PartialListResultsException) {
                        folderFileList = ((PartialListResultsException)se).getResults();
                    }
                }
                catch (RemoteException e) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                }
                this.allFileList = folderFileList != null ? folderFileList : new ArrayList();
            }
            if (itemsFileList != null) {
                this.allFileList.addAll(itemsFileList);
            }
        }
        int numberOfFiles = this.allFileList.size();
        List keywords = new ArrayList();
        for (int i = 0; i < numberOfFiles; ++i) {
            boolean drillable;
            String icon;
            MetadataInterface item;
            Date createdDateTime;
            Date modifiedDateTime;
            String description;
            String author;
            block39: {
                author = "";
                description = "";
                modifiedDateTime = null;
                createdDateTime = null;
                Object serviceObject = null;
                item = (MetadataInterface)this.allFileList.get(i);
                boolean fileOK = false;
                if (this.filterData(item)) {
                    fileOK = true;
                }
                if (!fileOK) continue;
                try {
                    name = item.getName();
                }
                catch (RemoteException e) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                }
                if (item instanceof FolderInterface) {
                    icon = folderImage;
                    drillable = true;
                } else {
                    icon = fileImage;
                    drillable = false;
                }
                try {
                    description = item.getDescription();
                    modifiedDateTime = item.getModifyDate();
                    createdDateTime = item.getCreateDate();
                    Object entity = item.getRepositoryEntity();
                    if (item instanceof FolderInterface) break block39;
                    keywords = item.getKeywords();
                    if (!(entity instanceof RootImpl)) break block39;
                    try {
                        AssociationList list = ((RootImpl)entity).getResponsibleParties();
                        for (int j = 0; j < list.size(); ++j) {
                            ResponsiblePartyImpl listItem = (ResponsiblePartyImpl)list.get(j);
                            author = "";
                            AssociationList persons = listItem.getPersons();
                            for (int k = 0; k < persons.size(); ++k) {
                                PersonImpl personItem = (PersonImpl)persons.get(k);
                                author = author.equals("") ? personItem.toString() : author + ", " + personItem.toString();
                            }
                        }
                    }
                    catch (MdException e) {
                        LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                    }
                }
                catch (RemoteException e) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                }
                catch (ServiceException e) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                }
            }
            String filePath = "";
            try {
                PathUrl pathUrl = item.getPathUrl();
                if (pathUrl != null) {
                    String rootFolderName = pathUrl.getRootTree();
                    filePath = item.getParentPath(rootFolderName);
                } else {
                    filePath = null;
                }
                if (filePath == null) continue;
                InformationServicesFileMetadata metadataNode = new InformationServicesFileMetadata(name, icon, drillable, author, modifiedDateTime, createdDateTime, keywords, description, filePath, item, pathUrl);
                returnList.add(metadataNode);
                continue;
            }
            catch (RemoteException e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                continue;
            }
            catch (ServiceException e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
            }
        }
        return returnList;
    }

    protected boolean filterData(MetadataInterface item) {
        boolean value = false;
        try {
            Object entity = item.getRepositoryEntity();
            if (this.filterValues != null) {
                if (this.filterValues.get(0).equals("*")) {
                    value = true;
                } else if (entity instanceof TransformationImpl) {
                    int size = this.filterValues.size();
                    String role = ((TransformationImpl)entity).getTransformRole();
                    for (int i = 0; i < size; ++i) {
                        if (!role.equals(this.filterValues.get(i))) continue;
                        value = true;
                    }
                } else if (entity instanceof TreeImpl) {
                    value = true;
                }
            } else {
                value = true;
            }
            if (this.startDate != null && this.endDate != null && this.searchFilter != null) {
                Date dateTime = null;
                dateTime = ((InformationServicesSearchModel)this).getDateSearchType() == 0 ? item.getModifyDate() : item.getCreateDate();
                value = this.startDate.before(dateTime) && this.endDate.after(dateTime);
            }
        }
        catch (RemoteException e) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        return value;
    }

    @Override
    public String[] splitDirectoryPathAndFileName(String path) {
        String shortName = null;
        String returnedPath = null;
        String[] stringArray = new String[2];
        int index = path.lastIndexOf("/");
        if (index != -1) {
            shortName = path.substring(index + 1);
            returnedPath = path.substring(0, index);
        } else {
            shortName = path;
            returnedPath = "";
        }
        stringArray[0] = shortName;
        stringArray[1] = returnedPath;
        return stringArray;
    }

    @Override
    public String combineDirectoryPathAndFileName(String path, String name) {
        if (path.endsWith("/")) {
            int index = path.lastIndexOf("/");
            path = path.substring(0, index);
        }
        String fullName = null;
        fullName = path.equals("") ? name : (path.endsWith("/") ? path + name : path + "/" + name);
        return fullName;
    }

    @Override
    public String getTopLevelName() {
        String name = null;
        try {
            if (this.repository != null) {
                name = this.repository.getISName();
            } else if (this.reposList.size() == 1) {
                if (this.repository == null) {
                    this.repository = (RepositoryInterface)this.reposList.get(0);
                }
                this.repository = (RepositoryInterface)this.reposList.get(0);
                name = this.repository.getISName();
            } else {
                name = RB.getStringResource(RB_KEY, "infoservice.txt");
            }
        }
        catch (RemoteException e) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        return name;
    }

    private String getTopLevelName(RepositoryInterface repository) {
        String name = null;
        try {
            if (repository != null) {
                name = repository.getISName();
            }
        }
        catch (RemoteException e) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        return name;
    }

    private String getTopLevelNameForRepository(RepositoryInterface repository) {
        String name = null;
        try {
            if (repository != null) {
                name = repository.getISName();
            }
        }
        catch (RemoteException e) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        return name;
    }

    @Override
    public String getFullyQualifiedPath(String currentPath, String fileName) {
        String SBIPPath = "SBIP://" + this.getTopLevelNameForRepository(this.repository) + "/" + currentPath;
        String fullName = this.combineDirectoryPathAndFileName(SBIPPath, fileName);
        return fullName;
    }

    @Override
    public String getDirectoryPath(String path) {
        String returnPath = path;
        int index = path.indexOf("//");
        if (index >= 0) {
            returnPath = path.substring(index + 1);
            String name = null;
            for (RepositoryInterface repository : this.reposList) {
                name = this.getTopLevelName(repository);
                index = returnPath.indexOf(name);
                if (index < 0) continue;
                returnPath = returnPath.substring(index + name.length() + 1);
            }
        }
        FolderInterface folder = null;
        FolderInterface lastFolder = null;
        ArrayList<String> piecesList = new ArrayList<String>();
        String fileName = null;
        String folderName = null;
        String tempPath = returnPath;
        returnPath = "";
        while (tempPath != null && !tempPath.equals("")) {
            String[] stringArray = this.splitDirectoryPathAndFileName(tempPath);
            tempPath = stringArray[1];
            fileName = stringArray[0];
            if (fileName.equals("")) {
                if (!tempPath.equals("")) {
                    piecesList.add(tempPath);
                }
                tempPath = null;
                continue;
            }
            piecesList.add(fileName);
        }
        for (int i = piecesList.size() - 1; i >= 0; --i) {
            if (i == piecesList.size() - 1) {
                try {
                    folderName = (String)piecesList.get(piecesList.size() - 1);
                    for (RepositoryInterface repository : this.reposList) {
                        folder = repository.getRootFolder(folderName);
                        if (folder == null) continue;
                    }
                }
                catch (ServiceException e) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                }
                catch (RemoteException e) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                }
            } else {
                try {
                    folderName = (String)piecesList.get(i);
                    folder = lastFolder.getSubfolder(folderName);
                }
                catch (ServiceException e) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                }
                catch (RemoteException e) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                }
            }
            if (folder == null) break;
            lastFolder = folder;
            returnPath = this.combineDirectoryPathAndFileName(returnPath, folderName);
        }
        return returnPath;
    }

    @Override
    public void setFilterValues(List filterValues) {
        this.filterValues = filterValues;
    }

    @Override
    public List getFilterValues() {
        return this.filterValues;
    }

    public void setRepository(RepositoryInterface repository) {
        this.repository = repository;
    }

    public RepositoryInterface getRepository() {
        return this.repository;
    }

    public List getRepositoryList() {
        return Collections.unmodifiableList(this.reposList);
    }
}

