/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models.remotefileselector.ifileservice;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SAS.IFileServicePackage.ListFilesMode;
import com.sas.iom.SAS.IFileServicePackage.TypeCategory;
import com.sas.iom.SAS.IFileServicePackage.TypeCategorySeqHolder;
import com.sas.iom.SAS.IFileService_1_1;
import com.sas.iom.SAS.IFileService_1_1Helper;
import com.sas.iom.SAS.IFileService_1_1Package.DeviceNotMounted;
import com.sas.iom.SAS.IHostSystem;
import com.sas.iom.SAS.IUtilities;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.InvalidFieldMask;
import com.sas.iom.SASIOMDefs.DateTimeSeqHolder;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.net.util.DateConverter;
import com.sas.swing.models.remotefileselector.RemoteFileServiceModelInterface;
import com.sas.swing.models.remotefileselector.ifileservice.IFileServiceFileMetadata;
import com.sas.swing.visuals.remotefileselector.RB;
import com.sas.util.connection.WorkspacePropertyInterface;
import com.sas.util.log.LoggerRepository2;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.swing.event.SwingPropertyChangeSupport;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;

@SASScope(value="ALL")
public class IFileServiceModel
implements RemoteFileServiceModelInterface,
WorkspacePropertyInterface {
    public static final String RB_KEY = "RemoteFileSelector.";
    public static int MVS_OS_FILESYSTEM = 1;
    public static int MVS_HFS_FILESYSTEM = 2;
    private IWorkspace workspace;
    private StringHolder listedPath;
    private StringSeqHolder names;
    private StringSeqHolder typeNames;
    private TypeCategorySeqHolder typeCategories;
    private LongSeqHolder sizes;
    private DateTimeSeqHolder modtimes;
    private StringSeqHolder engines;
    private ListFilesMode mode;
    private boolean[] fieldMask = new boolean[0];
    private List filterValues;
    private SwingPropertyChangeSupport spcs;
    private String hostFamily;
    private ListFilesMode pathMode;

    public IFileServiceModel() {
        this(null, MVS_HFS_FILESYSTEM);
    }

    public IFileServiceModel(IWorkspace workspace) {
        this(workspace, MVS_HFS_FILESYSTEM);
    }

    public IFileServiceModel(IWorkspace workspace, int fileSystem) {
        this.workspace = workspace;
        try {
            IUtilities utilities = workspace.Utilities();
            IHostSystem hostSystem = utilities.HostSystem();
            StringSeqHolder softwareInfo = new StringSeqHolder();
            VariableArray2dOfStringHolder hardwareInfo = new VariableArray2dOfStringHolder();
            hostSystem.GetInfo(softwareInfo, hardwareInfo);
            this.hostFamily = softwareInfo.value[3];
            if (this.hostFamily.equals("OS") && fileSystem == MVS_HFS_FILESYSTEM) {
                workspace.LanguageService().Submit("OPTIONS FILESYSTEM=HFS;");
            } else {
                workspace.LanguageService().Submit("OPTIONS FILESYSTEM=MVS;");
            }
        }
        catch (GenericError e) {
            LoggerRepository2.getLogger((String)IFileServiceModel.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        this.spcs = new SwingPropertyChangeSupport(this);
    }

    @SASScope
    public void setPathMode(ListFilesMode mode) {
        this.pathMode = mode;
    }

    @SASScope
    public ListFilesMode getPathMode() {
        return this.pathMode;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.removePropertyChangeListener(listener);
    }

    @Override
    public List getFiles(String path) throws IllegalArgumentException {
        ArrayList<IFileServiceFileMetadata> allFileList = null;
        if (this.workspace != null) {
            String folderImage = RB.getStringResource(RB_KEY, "folderImage.image");
            String fileImage = RB.getStringResource(RB_KEY, "fileImage.image");
            this.names = new StringSeqHolder();
            this.typeNames = new StringSeqHolder();
            this.typeCategories = new TypeCategorySeqHolder();
            this.sizes = new LongSeqHolder();
            this.modtimes = new DateTimeSeqHolder();
            this.engines = new StringSeqHolder();
            this.listedPath = new StringHolder();
            if ((path == null || "".equals(path)) && (this.hostFamily.equals("WIN") || this.hostFamily.equals("DNTHOST")) || this.getPathMode() == ListFilesMode.ListFilesModeRoot && "".equals(path)) {
                path = "";
                this.mode = ListFilesMode.ListFilesModeRoot;
            } else {
                this.mode = (path == null || "".equals(path)) && !this.hostFamily.equals("WIN") && !this.hostFamily.equals("DNTHOST") ? ListFilesMode.ListFilesModeUser : ListFilesMode.ListFilesModePath;
            }
            this.setPathMode(null);
            try {
                if (this.workspace.FileService() instanceof IFileService_1_1) {
                    IFileService_1_1 fileService = IFileService_1_1Helper.narrow((Object)this.workspace.FileService());
                    fileService.ListFiles_2(path, this.mode, this.fieldMask, this.listedPath, this.names, this.typeNames, this.typeCategories, this.sizes, this.modtimes, this.engines);
                } else {
                    this.workspace.FileService().ListFiles(path, this.mode, this.fieldMask, this.listedPath, this.names, this.typeNames, this.typeCategories, this.sizes, this.modtimes, this.engines);
                }
                allFileList = new ArrayList<IFileServiceFileMetadata>();
                int numberOfFiles = this.names.value.length;
                for (int i = 0; i < numberOfFiles; ++i) {
                    boolean drillable;
                    String icon;
                    String extension = this.typeNames.value[i];
                    TypeCategory typeCategory = this.typeCategories.value[i];
                    if (!this.filterValues.get(0).equals("*") && !this.filterData(extension, typeCategory)) continue;
                    String name = this.names.value[i];
                    if (typeCategory == TypeCategory.TypeCategoryDirectory && (name.equals(".") || name.equals(".."))) continue;
                    int size = this.sizes.value[i];
                    long modTime = this.modtimes.value[i];
                    Calendar calendar = Calendar.getInstance();
                    DateConverter.corbaToJava((long)modTime, (Calendar)calendar);
                    String engine = this.engines.value[i];
                    if (typeCategory == TypeCategory.TypeCategoryDirectory) {
                        icon = folderImage;
                        drillable = true;
                    } else {
                        icon = fileImage;
                        drillable = false;
                    }
                    IFileServiceFileMetadata metadataNode = new IFileServiceFileMetadata(name, icon, drillable, extension, typeCategory, size, calendar.getTime(), engine);
                    metadataNode.setPath(this.listedPath.value);
                    allFileList.add(metadataNode);
                }
            }
            catch (InvalidFieldMask e) {
                LoggerRepository2.getLogger((String)IFileServiceModel.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
            }
            catch (GenericError e) {
                LoggerRepository2.getLogger((String)IFileServiceModel.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
            }
            catch (DeviceNotMounted dnm) {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "devicenotonline.txt"));
            }
        }
        return allFileList;
    }

    @Override
    public String[] splitDirectoryPathAndFileName(String path) {
        StringHolder shortName = new StringHolder();
        StringHolder returnedPath = new StringHolder();
        String[] stringArray = new String[2];
        if (path.equals("") && (this.hostFamily.equals("WIN") || this.hostFamily.equals("DNTHOST"))) {
            stringArray[0] = "";
            stringArray[1] = "";
        } else if (path.equals("/") && !this.hostFamily.equals("WIN") && !this.hostFamily.equals("DNTHOST")) {
            stringArray[0] = "";
            stringArray[1] = "";
        } else {
            try {
                this.workspace.FileService().SplitName(path, shortName, returnedPath);
                stringArray[0] = (this.hostFamily.equals("WIN") || this.hostFamily.equals("DNTHOST")) && "\\".equals(returnedPath.value) ? "\\\\" + shortName.value : shortName.value;
                stringArray[1] = !this.hostFamily.equals("WIN") && !this.hostFamily.equals("DNTHOST") && returnedPath.value.equals(".") ? "/" : returnedPath.value;
            }
            catch (GenericError e) {
                LoggerRepository2.getLogger((String)IFileServiceModel.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
        return stringArray;
    }

    @Override
    public String combineDirectoryPathAndFileName(String path, String name) {
        if (!this.hostFamily.equals("WIN") && !this.hostFamily.equals("DNTHOST") && path.equals("")) {
            path = "/";
        }
        String fullName = null;
        if (!"".equals(name)) {
            try {
                fullName = this.workspace.FileService().FullName(name, path);
            }
            catch (GenericError e) {
                LoggerRepository2.getLogger((String)IFileServiceModel.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
        return fullName;
    }

    @Override
    public String getTopLevelName() {
        String hostName = "";
        if (this.workspace != null) {
            IUtilities utility = this.workspace.Utilities();
            IHostSystem host = utility.HostSystem();
            hostName = host.DNSName();
        }
        return hostName;
    }

    @Override
    public String getFullyQualifiedPath(String currentPath, String fileName) {
        return this.combineDirectoryPathAndFileName(currentPath, fileName);
    }

    @Override
    public String getDirectoryPath(String path) {
        if (!this.hostFamily.equals("WIN") && !this.hostFamily.equals("DNTHOST")) {
            this.names = new StringSeqHolder();
            this.typeNames = new StringSeqHolder();
            this.typeCategories = new TypeCategorySeqHolder();
            this.sizes = new LongSeqHolder();
            this.modtimes = new DateTimeSeqHolder();
            this.engines = new StringSeqHolder();
            this.listedPath = new StringHolder();
            this.mode = path.equals("") ? ListFilesMode.ListFilesModeUser : ListFilesMode.ListFilesModePath;
            try {
                if (this.workspace.FileService() instanceof IFileService_1_1) {
                    IFileService_1_1 fileService = IFileService_1_1Helper.narrow((Object)this.workspace.FileService());
                    fileService.ListFiles_2(path, this.mode, this.fieldMask, this.listedPath, this.names, this.typeNames, this.typeCategories, this.sizes, this.modtimes, this.engines);
                } else {
                    this.workspace.FileService().ListFiles(path, this.mode, this.fieldMask, this.listedPath, this.names, this.typeNames, this.typeCategories, this.sizes, this.modtimes, this.engines);
                }
            }
            catch (InvalidFieldMask e) {
                LoggerRepository2.getLogger((String)IFileServiceModel.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
            }
            catch (GenericError e) {
                LoggerRepository2.getLogger((String)IFileServiceModel.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
            }
            catch (DeviceNotMounted dnm) {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "devicenotonline.txt"));
            }
            if (!path.equals(this.listedPath.value)) {
                path = this.listedPath.value;
            }
        }
        return path;
    }

    @Override
    public void setFilterValues(List filterValues) {
        this.filterValues = filterValues;
    }

    @Override
    public List getFilterValues() {
        return this.filterValues;
    }

    private boolean filterData(String extension, TypeCategory typeCategory) {
        boolean value = false;
        if (typeCategory != TypeCategory.TypeCategoryDirectory) {
            for (int i = 0; i < this.filterValues.size(); ++i) {
                if (!extension.toUpperCase().equals(((String)this.filterValues.get(i)).toUpperCase())) continue;
                value = true;
            }
        } else {
            value = true;
        }
        return value;
    }

    @Override
    public IWorkspace getWorkspace() {
        return this.workspace;
    }

    @Override
    public void setWorkspace(IWorkspace workspace) {
        IWorkspace oldWorkspace = this.workspace;
        this.workspace = workspace;
        this.spcs.firePropertyChange("serviceModel", oldWorkspace, this.workspace);
    }
}

