/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models.remotefileselector;

import com.sas.swing.models.remotefileselector.CacheModel;
import com.sas.swing.models.remotefileselector.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector.RemoteFileServerModelInterface;
import com.sas.swing.models.remotefileselector.RemoteFileServiceModelInterface;
import com.sas.swing.visuals.remotefileselector.RB;
import com.sas.util.Util;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;

public class RemoteFileServerModel
extends AbstractTableModel
implements RemoteFileServerModelInterface,
PropertyChangeListener {
    public static final String RB_KEY = "RemoteFileSelector.";
    private RemoteFileServiceModelInterface serviceModel;
    private boolean showDirectoriesOnly;
    private List cacheList;
    private CacheModel cacheModel;
    private int originalPathSize;
    private String currentPath;
    private boolean readingFromCache;
    private SwingPropertyChangeSupport spcs;
    private boolean tableEditable;
    private String[] columnNames;
    private TransformInterface[] transforms;
    private boolean cacheEnabled;
    private String basePath;
    private List pasteBuffer;
    private int pasteBufferCommandType;

    public RemoteFileServerModel(String path, RemoteFileServiceModelInterface serviceModel) {
        this(path, serviceModel, false, null, null);
    }

    public RemoteFileServerModel(String path, RemoteFileServiceModelInterface serviceModel, boolean showDirectoriesOnly) {
        this(path, serviceModel, showDirectoriesOnly, null, null);
    }

    public RemoteFileServerModel(String path, RemoteFileServiceModelInterface serviceModel, TransformInterface[] transforms, String[] columnNames) {
        this(path, serviceModel, false, transforms, columnNames);
    }

    public RemoteFileServerModel(String path, RemoteFileServiceModelInterface serviceModel, boolean showDirectoriesOnly, TransformInterface[] transforms, String[] columnNames) {
        this.showDirectoriesOnly = showDirectoriesOnly;
        this.cacheEnabled = true;
        this.readingFromCache = false;
        this.currentPath = path;
        this.serviceModel = serviceModel;
        this.basePath = " ";
        List originalPath = this.parseIntoPathElements(path);
        this.originalPathSize = originalPath.size();
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(RB.getStringResource(RB_KEY, "availableservers.txt"));
        this.cacheModel = new CacheModel(rootNode, true, this, this.showDirectoriesOnly);
        this.cacheModel.initialize(path);
        this.cacheModel.addToCacheModel(this.serviceModel.getFiles(path), path);
        this.spcs = new SwingPropertyChangeSupport(this);
        serviceModel.addPropertyChangeListener(this);
        this.addPropertyChangeListener(this);
        this.tableEditable = false;
        this.columnNames = columnNames;
        this.transforms = transforms;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.removePropertyChangeListener(listener);
    }

    private List getFiles() {
        this.cacheList = this.cacheModel.readFromCacheModel(this.currentPath);
        this.readingFromCache = true;
        return this.cacheList;
    }

    @Override
    public boolean isUpwardPathRestricted() {
        if (this.currentPath.equals("")) {
            return true;
        }
        String[] testArray = this.splitDirectoryPathAndFileName(this.currentPath);
        return !(testArray[0] != null && !testArray[0].equals("") || testArray[1] != null && !testArray[1].equals(""));
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    @Override
    public void setPath(String path) throws IllegalArgumentException {
        this.setPath(path, false);
    }

    @Override
    public void setPath(String path, boolean search) throws IllegalArgumentException {
        List oldCacheList = this.cacheList;
        this.currentPath = path;
        this.cacheList = null;
        if (this.isCacheEnabled()) {
            List currentPathPieces = this.parseIntoPathElements(path);
            int currentPathSize = currentPathPieces.size();
            if (currentPathSize < this.originalPathSize || search) {
                this.cacheModel.initialize(path);
                this.originalPathSize = currentPathSize;
                if (this.cacheList != null) {
                    this.cacheList.clear();
                }
            } else {
                this.cacheList = this.cacheModel.readFromCacheModel(path);
                this.readingFromCache = true;
            }
        }
        if (this.cacheList == null || this.cacheList.size() == 0) {
            this.readingFromCache = false;
            try {
                this.cacheList = this.serviceModel.getFiles(path);
                if (this.cacheList != null) {
                    if (this.showDirectoriesOnly) {
                        for (int i = this.cacheList.size() - 1; i >= 0; --i) {
                            if (((RemoteFileMetadataInterface)this.cacheList.get(i)).isDrillable()) continue;
                            this.cacheList.remove(i);
                        }
                    }
                    this.cacheModel.addToCacheModel(this.cacheList, path);
                }
            }
            catch (IllegalArgumentException iae) {
                this.currentPath = path;
                this.cacheList = oldCacheList;
                throw iae;
            }
        }
        this.fireTableDataChanged();
    }

    @Override
    public String combineDirectoryPathAndFileName(String path, String name) {
        return this.serviceModel.combineDirectoryPathAndFileName(path, name);
    }

    @Override
    public String[] splitDirectoryPathAndFileName(String path) {
        return this.serviceModel.splitDirectoryPathAndFileName(path);
    }

    @Override
    public String getServerName() {
        return this.serviceModel.getTopLevelName();
    }

    @Override
    public void setModel(RemoteFileServiceModelInterface newServiceModel) {
        RemoteFileServiceModelInterface oldServiceModel = this.serviceModel;
        this.serviceModel = newServiceModel;
        this.spcs.firePropertyChange("serviceModel", oldServiceModel, this.serviceModel);
    }

    @Override
    public RemoteFileServiceModelInterface getModel() {
        return this.serviceModel;
    }

    @Override
    public String getPath() {
        return this.currentPath;
    }

    @Override
    public List parseIntoPathElements(String path) {
        ArrayList<String> piecesList = new ArrayList<String>();
        String fileName = null;
        while (path != null && !path.equals("")) {
            String[] stringArray = this.splitDirectoryPathAndFileName(path);
            path = stringArray[1];
            fileName = stringArray[0];
            if (fileName.equals("")) {
                if (!path.equals("")) {
                    piecesList.add(path);
                }
                path = null;
                continue;
            }
            piecesList.add(fileName);
            if (!path.equals(".")) continue;
            path = null;
        }
        return piecesList;
    }

    @Override
    public String createPathFromArray(Object[] namesArray) {
        String temp = "";
        String parent = "";
        for (int i = 0; i < namesArray.length; ++i) {
            temp = namesArray[i].toString();
            parent = this.serviceModel.combineDirectoryPathAndFileName(parent, temp);
        }
        return parent;
    }

    @Override
    public void updateFilteredValues(List newFilterValues) {
        this.serviceModel.setFilterValues(newFilterValues);
        this.cacheModel.initialize(this.currentPath);
        this.cacheModel.addToCacheModel(this.serviceModel.getFiles(this.currentPath), this.currentPath);
        List tempPath = this.parseIntoPathElements(this.currentPath);
        this.originalPathSize = tempPath.size();
    }

    @Override
    public void refresh() {
        this.cacheModel.initialize(this.currentPath);
        this.cacheModel.addToCacheModel(this.serviceModel.getFiles(this.currentPath), this.currentPath);
        List tempPath = this.parseIntoPathElements(this.currentPath);
        this.originalPathSize = tempPath.size();
        this.cacheList = null;
        this.fireTableDataChanged();
    }

    @Override
    public void setCacheEnabled(boolean enabled) {
        this.cacheEnabled = enabled;
    }

    @Override
    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    @Override
    public CacheModel getCacheModel() {
        return this.cacheModel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("serviceModel")) {
            this.cacheModel.initialize(this.currentPath);
            this.cacheModel.addToCacheModel(this.serviceModel.getFiles(this.currentPath), this.currentPath);
            List tempPath = this.parseIntoPathElements(this.currentPath);
            this.originalPathSize = tempPath.size();
            this.spcs.firePropertyChange("path", null, this.currentPath);
        }
    }

    @Override
    public int getRowCount() {
        if (this.cacheList == null || this.cacheList.size() == 0) {
            this.cacheList = this.cacheModel.readFromCacheModel(this.currentPath);
        }
        int tempSize = this.cacheList.size();
        this.readingFromCache = true;
        return tempSize;
    }

    @Override
    public int getColumnCount() {
        return this.getColumnNames().length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object returnObject = null;
        try {
            int transformsLength = this.transforms.length;
            if (transformsLength > 0 && columnIndex < transformsLength) {
                if (this.cacheList == null || this.cacheList.size() == 0) {
                    this.cacheList = this.cacheModel.readFromCacheModel(this.currentPath);
                }
                RemoteFileMetadataInterface item = (RemoteFileMetadataInterface)this.cacheList.get(rowIndex);
                if (!this.showDirectoriesOnly || this.showDirectoriesOnly && item.isDrillable()) {
                    returnObject = this.transforms[columnIndex].transform((Object)item);
                    this.readingFromCache = true;
                }
            } else {
                if (this.cacheList == null || this.cacheList.size() == 0) {
                    this.cacheList = this.cacheModel.readFromCacheModel(this.currentPath);
                }
                RemoteFileMetadataInterface item = (RemoteFileMetadataInterface)this.cacheList.get(rowIndex);
                if (!this.showDirectoriesOnly || this.showDirectoriesOnly && item.isDrillable()) {
                    returnObject = this.cacheList.get(rowIndex);
                    this.readingFromCache = true;
                }
            }
        }
        catch (TransformException transformException) {
            // empty catch block
        }
        return returnObject;
    }

    @Override
    public RemoteFileMetadataInterface getNodeAt(int rowIndex) {
        RemoteFileMetadataInterface tempMeta = null;
        if (rowIndex > -1) {
            if (this.cacheList == null || this.cacheList.size() == 0) {
                this.cacheList = this.cacheModel.readFromCacheModel(this.currentPath);
            }
            tempMeta = (RemoteFileMetadataInterface)this.cacheList.get(rowIndex);
            this.readingFromCache = true;
        }
        return tempMeta;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex != 0 || columnIndex == 0 && !aValue.equals("")) {
            RemoteFileMetadataInterface fileNode = (RemoteFileMetadataInterface)this.cacheModel.readFromCacheModel(this.currentPath).get(rowIndex);
            this.readingFromCache = true;
            fileNode.setName((String)aValue);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.isTableEditable() && columnIndex == 0;
    }

    @Override
    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
        this.fireTableDataChanged();
    }

    @Override
    public String[] getColumnNames() {
        return this.columnNames != null ? this.columnNames : new String[]{};
    }

    @Override
    public void setColumnName(String columnName, int columnIndex) {
        String oldColumnName;
        String[] columnNameArray = this.getColumnNames();
        if (columnIndex < columnNameArray.length && Util.unequal((Object)(oldColumnName = columnNameArray[columnIndex]), (Object)columnName)) {
            columnNameArray[columnIndex] = columnName;
            this.fireTableDataChanged();
        }
    }

    @Override
    public String getColumnName(int columnIndex) {
        String columnName = null;
        String[] columnNameArray = this.getColumnNames();
        if (columnIndex < columnNameArray.length) {
            columnName = columnNameArray[columnIndex];
        }
        if (columnName == null) {
            columnName = super.getColumnName(columnIndex);
        }
        return columnName;
    }

    @Override
    public void setTransforms(TransformInterface[] transforms) {
        this.transforms = transforms;
        this.fireTableDataChanged();
    }

    @Override
    public TransformInterface[] getTransforms() {
        return this.transforms != null ? this.transforms : new TransformInterface[]{};
    }

    @Override
    public void setTransform(TransformInterface transform, int columnIndex) {
        TransformInterface oldTransform;
        TransformInterface[] transformArray = this.getTransforms();
        if (columnIndex < transformArray.length && Util.unequal((Object)(oldTransform = transformArray[columnIndex]), (Object)transform)) {
            transformArray[columnIndex] = transform;
            this.fireTableDataChanged();
        }
    }

    @Override
    public boolean isTableEditable() {
        return this.tableEditable;
    }

    @Override
    public void setTableEditable(boolean editable) {
        if (this.tableEditable != editable) {
            this.tableEditable = editable;
            this.spcs.firePropertyChange("tableEditable", !editable, editable);
        }
    }

    @Override
    public void addToPasteBuffer(RemoteFileMetadataInterface node) {
        if (this.pasteBuffer == null) {
            this.pasteBuffer = new ArrayList();
        }
        this.pasteBuffer.add(node);
    }

    @Override
    public void clearPasteBuffer() {
        if (this.pasteBuffer != null && this.pasteBuffer.size() > 0) {
            this.pasteBuffer.clear();
        } else {
            this.pasteBuffer = new ArrayList();
        }
    }

    @Override
    public List getPasteBuffer() {
        return this.pasteBuffer;
    }

    @Override
    public void setPasteBufferCommandType(int commandType) {
        this.pasteBufferCommandType = commandType;
    }

    @Override
    public int getPasteBufferCommandType() {
        return this.pasteBufferCommandType;
    }
}

