/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.util.transforms.TransformInterface;

@SASScope
public class WRSAppliedFiltersTransform
implements TransformInterface {
    public static final int HTML = 0;
    public static final int TEXT = 1;
    private String[][] key_pairs;
    private String FUNCTION_CALL;
    private BusinessModel businessModel;

    public WRSAppliedFiltersTransform() {
        this(0);
    }

    public WRSAppliedFiltersTransform(int type) {
        if (type == 0) {
            this.FUNCTION_CALL = "&lt;FunctionCall&gt;";
            String[][] web_pairs = new String[][]{{"STRIP(UPCASE(", ")) &lt;FunctionCall&gt;"}, {"STRIP(", ") &lt;FunctionCall&gt;"}, {"UPCASE(", ") &lt;FunctionCall&gt;"}, {"TRIM(LEFT(&lt;&lt;", "&gt;&gt;)) &lt;FunctionCall&gt;"}};
            this.key_pairs = web_pairs;
        } else if (type == 1) {
            this.FUNCTION_CALL = "<FunctionCall>";
            String[][] text_pairs = new String[][]{{"STRIP(UPCASE(", ")) <FunctionCall>"}, {"STRIP(", ") <FunctionCall>"}, {"UPCASE(", ") <FunctionCall>"}, {"TRIM(LEFT(<<", ">>)) <FunctionCall>"}, {">>)) <FunctionCall>", ">>)) <FunctionCall>"}};
            this.key_pairs = text_pairs;
        } else {
            throw new IllegalStateException("Unknown transform type");
        }
    }

    public void setBusinessModel(BusinessModel businessModel) {
        this.businessModel = businessModel;
    }

    public Object transform(Object value) {
        String filterString = (String)value;
        StringBuffer output = new StringBuffer();
        int baseIndex = 0;
        int functionCallIndex = filterString.indexOf(this.FUNCTION_CALL);
        while (functionCallIndex != -1) {
            String part = filterString.substring(baseIndex, functionCallIndex + this.FUNCTION_CALL.length());
            for (int i = 0; i < this.key_pairs.length; ++i) {
                String result = this.processFilterPart(part, this.key_pairs[i][0], this.key_pairs[i][1]);
                if (part.equals(result)) continue;
                part = result;
                break;
            }
            output.append(part);
            baseIndex = functionCallIndex + this.FUNCTION_CALL.length();
            functionCallIndex = filterString.indexOf(this.FUNCTION_CALL, baseIndex);
        }
        output.append(filterString.substring(baseIndex));
        return output.toString();
    }

    private String processFilterPart(String input, String start, String end) {
        StringBuffer output = new StringBuffer();
        int trimLeftIndex = input.indexOf(start);
        if (trimLeftIndex != -1) {
            int closePartIndex;
            if (trimLeftIndex != 0) {
                output.append(input.substring(0, trimLeftIndex));
            }
            if ((closePartIndex = input.indexOf(end, trimLeftIndex)) == -1) {
                throw new IllegalStateException("Malformed filter string");
            }
            String dataItemID = input.substring(trimLeftIndex + start.length(), closePartIndex);
            dataItemID = this.processDataItemID(dataItemID);
            output.append(dataItemID);
            output.append(input.substring(closePartIndex + end.length()));
        } else {
            output.append(input);
        }
        return output.toString();
    }

    private String processDataItemID(String id) {
        String transformedId = id;
        try {
            BusinessItem item;
            if (this.businessModel != null && (item = this.businessModel.getBusinessItemByID(id)) != null) {
                transformedId = item.getLabel();
            }
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        return transformedId;
    }
}

