/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.IntegerDefinition;
import com.sas.prompts.definitions.IntegerDefinitionInterface;
import com.sas.prompts.definitions.MutablePromptDefinitionInterface;
import com.sas.prompts.definitions.MutableSelectableDefinitionInterface;
import com.sas.prompts.definitions.MutableTextDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.TextDefinition;
import com.sas.prompts.definitions.TextDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.prompts.groups.TransparentGroupInterface;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BaseMultipleValuesPanel;
import com.sas.prompts.visuals.swing.designtime.PromptGroupUtility;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.swing.visuals.ComboBox;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;

class TextMultipleValuesPanel
extends BaseMultipleValuesPanel
implements PromptValueChangeListener {
    private PromptValues promptValuesMinMaxLength;
    private PromptValues promptValuesHint;
    private PromptPropertiesPanel promptPropertiesPanelMinMaxLength;
    private PromptPropertiesPanel promptPropertiesPanelHint;
    private TextDefinition textPrompt;
    private TextDefinition promptHint;
    private IntegerDefinition promptMinLength;
    private IntegerDefinition promptMaxLength;
    private ComboBox textTypeCombo;
    private JPanel textTypePanel;
    private static final long serialVersionUID = 3257563988660598326L;

    public TextMultipleValuesPanel(String selectionType, PropertiesCommunicator communicator) {
        this((TextDefinitionInterface)null, selectionType, communicator);
    }

    public TextMultipleValuesPanel(TextDefinitionInterface prompt, String selectionType, PropertiesCommunicator communicator) {
        super((PromptDefinitionInterface)prompt, selectionType, communicator);
        this.createPromptPanel();
    }

    @Override
    protected void createPromptPanel() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 5, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        TransparentGroupInterface promptGroupMinMaxLength = PromptGroupUtility.newGroupForMinMaxLength(this.getLocale(), this.getLoggerFactory());
        this.promptMinLength = (IntegerDefinition)promptGroupMinMaxLength.getPromptDefinition(PromptGroupUtility.MIN_LENGTH, true);
        this.promptMaxLength = (IntegerDefinition)promptGroupMinMaxLength.getPromptDefinition(PromptGroupUtility.MAX_LENGTH, true);
        this.promptValuesMinMaxLength = new PromptValues((PromptGroupInterface)promptGroupMinMaxLength, null);
        PromptUtility.configurePromptValuesForMinMaxLength(this.promptValuesMinMaxLength, this.prompt, (IntegerDefinitionInterface)this.promptMinLength, (IntegerDefinitionInterface)this.promptMaxLength, this.communicator);
        this.promptValuesMinMaxLength.addPromptValueChangeListener((PromptValueChangeListener)this);
        this.promptPropertiesPanelMinMaxLength = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesMinMaxLength, this.locale);
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelMinMaxLength);
        this.createListEditor("Text");
        TransparentGroup promptGroupHint = new TransparentGroup();
        this.promptHint = new TextDefinition("");
        this.promptHint.setPromptLabel(RB.getStringResource("hint.txt"), this.locale);
        promptGroupHint.addPromptDefinition((PromptDefinitionInterface)this.promptHint);
        this.promptValuesHint = new PromptValues((PromptGroupInterface)promptGroupHint, null);
        PromptUtility.configurePromptValuesForHint(this.promptValuesHint, this.prompt, (TextDefinitionInterface)this.promptHint, this.communicator, this.locale);
        this.promptPropertiesPanelHint = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesHint, this.locale);
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelHint);
        if (this.listEditor != null) {
            try {
                if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesMinMaxLength, (PromptDefinitionInterface)this.promptMinLength)) {
                    Integer minLength = (Integer)this.promptValuesMinMaxLength.getPromptValue((PromptDefinitionInterface)this.promptMinLength);
                    this.listEditor.setMinLength(minLength);
                }
                if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesMinMaxLength, (PromptDefinitionInterface)this.promptMaxLength)) {
                    Integer maxLength = (Integer)this.promptValuesMinMaxLength.getPromptValue((PromptDefinitionInterface)this.promptMaxLength);
                    this.listEditor.setMaxLength(maxLength);
                }
            }
            catch (PromptValueNotFoundException pvnf) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
            }
        }
        this.textTypePanel = new JPanel();
        AutoSizingGridLayout textTypeLayout = new AutoSizingGridLayout(2, 1, 10, 5, true, false, true);
        this.textTypePanel.setLayout((LayoutManager)textTypeLayout);
        JLabel textTypeLabel = new JLabel(RB.getStringResource("textType.txt"));
        this.textTypeCombo = new ComboBox();
        DefaultComboBoxModel<String> textTypeModel = new DefaultComboBoxModel<String>();
        textTypeModel.addElement(RB.getStringResource("standardSingleLine.txt"));
        this.textTypeCombo.setModel(textTypeModel);
        this.textTypeCombo.setEnabled(false);
        textTypeLabel.setLabelFor((Component)this.textTypeCombo);
        this.textTypePanel.add(textTypeLabel);
        this.textTypePanel.add((Component)this.textTypeCombo);
        if (!this.communicator.isCurrentMapSelectorEnabled()) {
            this.add(this.textTypePanel);
        }
        this.add(this.promptPropertiesPanelValueCount);
        this.add(this.promptPropertiesPanelMinMaxLength);
        this.add(this.createSpecialValuesFields());
        this.add((Component)((Object)this.listEditor));
        this.add(this.promptPropertiesPanelHint);
        this.communicator.addPropertyChangeListener(this);
        this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
        this.setSpecialValuesOnListEditor();
        this.addSpecialValuesListeners();
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        this.setContentsValid(true);
        this.promptValuesMinMaxLength.removePromptValueChangeListener((PromptValueChangeListener)this);
        this.promptValuesValueCount.removePromptValueChangeListener((PromptValueChangeListener)this);
        this.textPrompt = (TextDefinition)PromptUtility.newConfiguredPrompt(this.communicator, "TextDefinition");
        this.textPrompt.setMaximumValueCount(Integer.MAX_VALUE);
        if (this.selectionType.equals("Multiple ordered values")) {
            this.textPrompt.setSelectionOrdered(true);
        }
        try {
            PromptGroupUtility.setMinLengthFromPromptValue((PromptValuesInterface)this.promptValuesMinMaxLength, (PromptDefinitionInterface)this.promptMinLength, (MutableTextDefinitionInterface)this.textPrompt);
            PromptGroupUtility.setMaxLengthFromPromptValue((PromptValuesInterface)this.promptValuesMinMaxLength, (PromptDefinitionInterface)this.promptMaxLength, (MutableTextDefinitionInterface)this.textPrompt);
            SupportedSpecialValues supportedSpecialValues = new SupportedSpecialValues();
            supportedSpecialValues.setMissingValuesSupported(this.missingCheckBox.isSelected());
            supportedSpecialValues.setAllSupported(this.allCheckBox.isSelected());
            supportedSpecialValues.setOtherSupported(this.noneCheckBox.isSelected());
            this.textPrompt.setSupportedSpecialValues(supportedSpecialValues);
            PromptGroupUtility.setDefaultValueForMultiValuedPrompt((MutablePromptDefinitionInterface)this.textPrompt, this.listEditor);
            if (this.textPrompt.isDefaultValueSet()) {
                Object o = this.textPrompt.getDefaultValue();
                Collection errors = Collections.EMPTY_LIST;
                Object invalidValue = o;
                if (o == null) {
                    errors = PromptUtil.addError((Collection)errors, (long)1L, (String)RB.getStringResource("nullNotAllowed.txt", this.locale));
                } else if (o instanceof List) {
                    List l = (List)o;
                    for (int i = 0; i < l.size(); ++i) {
                        if (l.get(i) != null) continue;
                        errors = PromptUtil.addError((Collection)errors, (long)1L, (String)RB.getStringResource("nullNotAllowed.txt", this.locale));
                        invalidValue = l.get(i);
                        break;
                    }
                }
                if (errors.size() > 0 && !suppressErrors) {
                    String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
                    String errorString = Message.format((String)RB.getStringResource("invalidMultipleValue.fmt.txt", this.locale), (Object)invalidValue, (Object)errorMessage);
                    this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                    if (this.getGenericErrorHandler() != null) {
                        this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorString)), null);
                    }
                    this.setContentsValid(false);
                    this.listEditor.getModel().addTableModelListener(this);
                    this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
                }
            }
            PromptGroupUtility.setMinValueCountFromPromptValue((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMinValueCount, (MutableSelectableDefinitionInterface)this.textPrompt);
            PromptGroupUtility.setMaxValueCountFromPromptValue((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMaxValueCount, (MutableSelectableDefinitionInterface)this.textPrompt);
            if (this.promptValuesHint.isPromptValueAvailable((PromptDefinitionInterface)this.promptHint)) {
                String promptHintString = (String)this.promptValuesHint.getPromptValue((PromptDefinitionInterface)this.promptHint);
                this.textPrompt.setHint(promptHintString, this.locale);
            }
        }
        catch (PromptValueNotFoundException pvnf) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
        }
        catch (IllegalArgumentException exception) {
            if (!suppressErrors) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(exception.getMessage());
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)exception.getMessage())), null);
                }
                this.setContentsValid(false);
                this.listEditor.getModel().addTableModelListener(this);
                this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
            }
            return this.textPrompt;
        }
        Collection errors = this.textPrompt.validateDefinition(this.locale);
        if (errors.size() > 0 && !suppressErrors) {
            String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
            }
            this.setContentsValid(false);
            this.promptValuesMinMaxLength.addPromptValueChangeListener((PromptValueChangeListener)this);
            this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
        }
        if (this.isContentsValid()) {
            this.removeAllListeners();
        }
        return this.textPrompt;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.getPromptDefinition(false);
    }

    @Override
    protected void verifyContentsValid() {
        boolean isValid = false;
        isValid = this.promptValuesValueCount != null ? this.promptPropertiesPanelMinMaxLength.isContentsValid() && this.promptPropertiesPanelValueCount.isContentsValid() : this.promptPropertiesPanelMinMaxLength.isContentsValid();
        this.setContentsValid(isValid);
    }

    @Override
    public void promptValueChanged(PromptValueChangeEventInterface event) {
        block10: {
            PromptDefinitionInterface promptDefinition = event.getPromptDefinition();
            if (promptDefinition.getPromptName().equals(PromptGroupUtility.MIN_LENGTH)) {
                try {
                    if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesMinMaxLength, (PromptDefinitionInterface)this.promptMinLength)) {
                        Integer minLength = (Integer)this.promptValuesMinMaxLength.getPromptValue((PromptDefinitionInterface)this.promptMinLength);
                        this.listEditor.setMinLength(minLength);
                        break block10;
                    }
                    this.listEditor.setMinLength(0);
                }
                catch (PromptValueNotFoundException pvnf) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
                }
            } else if (promptDefinition.getPromptName().equals(PromptGroupUtility.MAX_LENGTH)) {
                try {
                    if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesMinMaxLength, (PromptDefinitionInterface)this.promptMaxLength)) {
                        Integer maxLength = (Integer)this.promptValuesMinMaxLength.getPromptValue((PromptDefinitionInterface)this.promptMaxLength);
                        this.listEditor.setMaxLength(maxLength);
                    } else {
                        this.listEditor.setMaxLength(Integer.MAX_VALUE);
                    }
                }
                catch (PromptValueNotFoundException pvnf) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
                }
            }
        }
        this.verifyContentsValid();
        super.promptValueChanged(event);
    }
}

