/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.IntegerDefinition;
import com.sas.prompts.definitions.IntegerDefinitionInterface;
import com.sas.prompts.definitions.MutableSelectableDefinitionInterface;
import com.sas.prompts.definitions.MutableTextDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.TextDefinition;
import com.sas.prompts.definitions.TextDefinitionInterface;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroupInterface;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BaseDynamicListPanel;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionInterface;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionWithErrorSuppressionOptionInterface;
import com.sas.prompts.visuals.swing.designtime.PromptGroupUtility;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.swing.visuals.ComboBox;
import com.sas.text.Message;
import com.sas.util.MutableSupportedSpecialValuesInterface;
import com.sas.util.Strings;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;

class TextDynamicListPanel
extends BaseDynamicListPanel {
    private PromptValues promptValuesMinMaxLength;
    private PromptPropertiesPanel promptPropertiesPanelMinMaxLength;
    private IntegerDefinition promptMinLength;
    private IntegerDefinition promptMaxLength;
    private TextDefinition textPrompt;
    private ComboBox textTypeCombo;
    private JPanel textTypePanel;
    private static final long serialVersionUID = 3257563988660598326L;

    public TextDynamicListPanel(String selectionType, PropertiesCommunicator communicator) {
        this((TextDefinitionInterface)null, selectionType, communicator);
    }

    public TextDynamicListPanel(TextDefinitionInterface prompt, String selectionType, PropertiesCommunicator communicator) {
        super((PromptDefinitionInterface)prompt, selectionType, communicator);
        this.createPromptPanel();
    }

    @Override
    protected void createPromptPanel() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 0, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        TransparentGroupInterface promptGroupMinMaxLength = PromptGroupUtility.newGroupForMinMaxLength(this.getLocale(), this.getLoggerFactory());
        this.promptMinLength = (IntegerDefinition)promptGroupMinMaxLength.getPromptDefinition(PromptGroupUtility.MIN_LENGTH, true);
        this.promptMaxLength = (IntegerDefinition)promptGroupMinMaxLength.getPromptDefinition(PromptGroupUtility.MAX_LENGTH, true);
        this.promptValuesMinMaxLength = new PromptValues((PromptGroupInterface)promptGroupMinMaxLength, null);
        PromptUtility.configurePromptValuesForMinMaxLength(this.promptValuesMinMaxLength, this.prompt, (IntegerDefinitionInterface)this.promptMinLength, (IntegerDefinitionInterface)this.promptMaxLength, this.communicator);
        this.promptValuesMinMaxLength.addPromptValueChangeListener((PromptValueChangeListener)this);
        this.promptPropertiesPanelMinMaxLength = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesMinMaxLength, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelMinMaxLength);
        JPanel outerDatasourcePanel = this.createDatasourcePanel();
        this.createCustomPanel();
        this.customPanel.addPropertyChangeListener(this);
        this.communicator.addPropertyChangeListener(this);
        if (this.promptValuesValueCount != null) {
            this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
        }
        this.textTypePanel = new JPanel();
        AutoSizingGridLayout textTypeLayout = new AutoSizingGridLayout(2, 1, 10, 5, true, false, true);
        this.textTypePanel.setLayout((LayoutManager)textTypeLayout);
        JLabel textTypeLabel = new JLabel(RB.getStringResource("textType.txt"));
        this.textTypeCombo = new ComboBox();
        DefaultComboBoxModel<String> textTypeModel = new DefaultComboBoxModel<String>();
        textTypeModel.addElement(RB.getStringResource("standardSingleLine.txt"));
        this.textTypeCombo.setModel(textTypeModel);
        this.textTypeCombo.setEnabled(false);
        textTypeLabel.setLabelFor((Component)this.textTypeCombo);
        this.textTypePanel.add(textTypeLabel);
        this.textTypePanel.add((Component)this.textTypeCombo);
        if (!this.communicator.isCurrentMapSelectorEnabled()) {
            this.add(this.textTypePanel);
        }
        if (this.selectionType != "Single value") {
            this.add(this.promptPropertiesPanelValueCount);
        }
        this.add(this.promptPropertiesPanelMinMaxLength);
        this.add(this.createMaximumDisplayValues());
        this.add(outerDatasourcePanel);
        this.createHolderPanel().add(this.customPanel);
        this.add(this.holderPanel);
        this.add(this.createAllowCustomValuesCheckBox());
    }

    @Override
    protected PromptDefinitionInterface intializePrompt() {
        if (this.prompt == null) {
            TextDefinition textDefinitionPrompt = new TextDefinition();
            textDefinitionPrompt.setAllowUserValues(false);
            if (this.selectionType != "Single value") {
                textDefinitionPrompt.setMaximumValueCount(Integer.MAX_VALUE);
            }
            if (this.selectionType.equals("Multiple ordered values")) {
                textDefinitionPrompt.setSelectionOrdered(true);
            }
            return textDefinitionPrompt;
        }
        if (this.prompt instanceof MutableTextDefinitionInterface) {
            return (MutableTextDefinitionInterface)this.prompt;
        }
        return (TextDefinitionInterface)this.prompt;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        this.setContentsValid(true);
        this.promptValuesMinMaxLength.removePromptValueChangeListener((PromptValueChangeListener)this);
        if (this.promptValuesValueCount != null) {
            this.promptValuesValueCount.removePromptValueChangeListener((PromptValueChangeListener)this);
        }
        ValueProviderDefinitionInterface selectablePrompt = null;
        selectablePrompt = this.customPanel instanceof GetPromptDefinitionWithErrorSuppressionOptionInterface ? (ValueProviderDefinitionInterface)((GetPromptDefinitionWithErrorSuppressionOptionInterface)((Object)this.customPanel)).getPromptDefinition(suppressErrors) : (ValueProviderDefinitionInterface)((GetPromptDefinitionInterface)((Object)this.customPanel)).getPromptDefinition();
        ValueProviderInterface valueProvider = null;
        this.textPrompt = (TextDefinition)PromptUtility.newConfiguredPrompt(this.communicator, "TextDefinition");
        if (this.customPanel != null) {
            valueProvider = selectablePrompt.getValueProvider();
            try {
                Integer pageSize;
                if (this.promptValuesMaxDisplay != null && this.promptValuesMaxDisplay.isPromptValueAvailable((PromptDefinitionInterface)this.promptMaxDisplay) && (pageSize = (Integer)this.promptValuesMaxDisplay.getPromptValue((PromptDefinitionInterface)this.promptMaxDisplay)) != null) {
                    this.textPrompt.setPageSize(pageSize.intValue());
                }
            }
            catch (PromptValueNotFoundException pvnf) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).debug(pvnf.getMessage());
            }
        }
        if (this.selectionType != "Single value") {
            this.textPrompt.setMaximumValueCount(Integer.MAX_VALUE);
        }
        if (this.selectionType.equals("Multiple ordered values")) {
            this.textPrompt.setSelectionOrdered(true);
        }
        if (valueProvider != null) {
            this.textPrompt.setValueProvider(valueProvider);
        }
        this.textPrompt.setAllowUserValues(selectablePrompt.isAllowUserValues());
        try {
            PromptGroupUtility.setMinLengthFromPromptValue((PromptValuesInterface)this.promptValuesMinMaxLength, (PromptDefinitionInterface)this.promptMinLength, (MutableTextDefinitionInterface)this.textPrompt);
            PromptGroupUtility.setMaxLengthFromPromptValue((PromptValuesInterface)this.promptValuesMinMaxLength, (PromptDefinitionInterface)this.promptMaxLength, (MutableTextDefinitionInterface)this.textPrompt);
            if (this.selectionType != "Single value") {
                PromptGroupUtility.setMinValueCountFromPromptValue((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMinValueCount, (MutableSelectableDefinitionInterface)this.textPrompt);
                PromptGroupUtility.setMaxValueCountFromPromptValue((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMaxValueCount, (MutableSelectableDefinitionInterface)this.textPrompt);
            }
            if (selectablePrompt instanceof MutableSupportedSpecialValuesInterface) {
                SupportedSpecialValues supportedSpecialValues = ((MutableSupportedSpecialValuesInterface)selectablePrompt).getSupportedSpecialValues();
                this.textPrompt.setSupportedSpecialValues(supportedSpecialValues);
            }
            if (((PromptDefinitionInterface)selectablePrompt).isDefaultValueSet()) {
                this.textPrompt.setDefaultValue(((PromptDefinitionInterface)selectablePrompt).getDefaultValue());
            } else {
                this.textPrompt.clearDefaultValue();
            }
            this.textPrompt.setAllowUserValues(this.allowCustomValuesCheckBox.isSelected());
        }
        catch (IllegalArgumentException exception) {
            if (!suppressErrors) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).debug(exception.getMessage());
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)exception.getMessage())), null);
                }
                this.setContentsValid(false);
                this.promptValuesMinMaxLength.addPromptValueChangeListener((PromptValueChangeListener)this);
                if (this.promptValuesValueCount != null) {
                    this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
                }
            }
            try {
                if (!this.isUserDefinedDataProvider()) {
                    ((DataProvider)this.dataProvider).close();
                }
            }
            catch (ServerConnectionException sce) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(sce.getMessage());
            }
            return this.textPrompt;
        }
        catch (PromptValueNotFoundException pvnf) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
        }
        Collection errors = this.textPrompt.validateDefinition(this.getLocale());
        if (errors.size() > 0 && !suppressErrors) {
            String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
            }
            this.setContentsValid(false);
            if (this.promptValuesValueCount != null) {
                this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
            }
            this.promptValuesMinMaxLength.addPromptValueChangeListener((PromptValueChangeListener)this);
        }
        try {
            if (!this.isUserDefinedDataProvider()) {
                ((DataProvider)this.dataProvider).close();
            }
        }
        catch (ServerConnectionException sce) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).debug(sce.getMessage());
        }
        return this.textPrompt;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.getPromptDefinition(false);
    }

    @Override
    protected void verifyContentsValid() {
        boolean isValid = false;
        isValid = this.promptValuesValueCount != null ? this.promptPropertiesPanelMinMaxLength.isContentsValid() && this.promptPropertiesPanelValueCount.isContentsValid() : this.promptPropertiesPanelMinMaxLength.isContentsValid();
        this.setContentsValid(isValid);
    }
}

