/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.definitions.shared.SharedPromptDefinitionInterface;
import com.sas.prompts.groups.shared.SharedPromptGroupInterface;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.prompts.visuals.swing.designtime.SharedObjectMetadataPanel;
import com.sas.prompts.visuals.swing.designtime.ValidatePromptNameInterface;
import com.sas.swing.visuals.OptionsDialog;
import com.sas.text.Message;
import java.awt.Frame;
import java.util.Locale;

public class SharedObjectMetadataDialog
extends OptionsDialog {
    private static final String RB_KEY = "SharedObjectMetadataDialog.";
    private SharedObjectMetadataPanel metadataNamePanel;

    public SharedObjectMetadataDialog(Frame parent, Object sharedObject, ValidatePromptNameInterface nameValidator, Locale locale) {
        super(parent, "", true, 3, 4);
        String title = Message.format((String)RB.getStringResource(RB_KEY, "title.fmt.txt"), (Object)this.getMetadataName(sharedObject));
        this.setTitle(title);
        this.metadataNamePanel = new SharedObjectMetadataPanel(sharedObject, nameValidator, locale);
        this.setPanel(this.metadataNamePanel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public SharedObjectMetadataDialog(Frame parent, Object sharedObject, PropertiesCommunicator communicator, Locale locale) {
        super(parent, "", true, 3, 4);
        String title = Message.format((String)RB.getStringResource(RB_KEY, "title.fmt.txt"), (Object)this.getMetadataName(sharedObject));
        this.setTitle(title);
        this.metadataNamePanel = new SharedObjectMetadataPanel(sharedObject, communicator, locale);
        this.setPanel(this.metadataNamePanel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    protected String getMetadataName(Object obj) {
        String metadataName = "";
        String locationNameString = null;
        if (obj instanceof SharedPromptDefinitionInterface) {
            SharedPromptDefinitionInterface sharedPrompt = (SharedPromptDefinitionInterface)obj;
            locationNameString = sharedPrompt.getSharedPromptLocation();
        } else if (obj instanceof SharedPromptGroupInterface) {
            SharedPromptGroupInterface sharedGroup = (SharedPromptGroupInterface)obj;
            locationNameString = sharedGroup.getSharedPromptGroupLocation();
        }
        if (locationNameString != null) {
            int slashIndex = locationNameString.lastIndexOf(47);
            metadataName = locationNameString.substring(slashIndex + 1);
            int parenIndex = metadataName.indexOf(40);
            metadataName = metadataName.substring(0, parenIndex);
        }
        return metadataName;
    }
}

