/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.SASLibraryDefinition;
import com.sas.prompts.definitions.SASLibraryDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.PromptDataProviderInterface;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BasePromptTypesAndValuesPanel;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionWithErrorSuppressionOptionInterface;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

class SASLibraryPanel
extends BasePromptTypesAndValuesPanel
implements GetPromptDefinitionWithErrorSuppressionOptionInterface {
    private boolean userDefinedDataProvider = false;
    private PromptValues promptValuesDefaultValue;
    private PromptPropertiesPanel promptPropertiesPanelDefaultValue;
    private SASLibraryDefinition promptDefaultValue;
    private SASLibraryDefinitionInterface prompt;
    private PromptDataProviderInterface dataProvider;
    private SASLibraryDefinition libraryPrompt;

    public SASLibraryPanel(SASLibraryDefinitionInterface prompt, PropertiesCommunicator communicator) {
        this(prompt, null, communicator);
    }

    public SASLibraryPanel(String selectionType, PropertiesCommunicator communicator) {
        this(null, selectionType, communicator);
    }

    SASLibraryPanel(SASLibraryDefinitionInterface prompt, String selectionType, PropertiesCommunicator communicator) {
        super(communicator);
        this.prompt = prompt;
        this.initializePanel();
    }

    private void initializePanel() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 0, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        TransparentGroup promptGroup = new TransparentGroup();
        this.promptDefaultValue = new SASLibraryDefinition();
        promptGroup.addPromptDefinition((PromptDefinitionInterface)this.promptDefaultValue);
        PromptDataProviderInterface userDataProvider = this.communicator.getDataProvider();
        if (userDataProvider != null) {
            this.dataProvider = userDataProvider;
            this.userDefinedDataProvider = true;
        } else {
            this.dataProvider = new DataProvider(this.communicator.getUserContext());
        }
        this.promptValuesDefaultValue = new PromptValues((PromptGroupInterface)promptGroup, null);
        if (this.prompt != null) {
            try {
                boolean defaultValueSet = this.prompt.isDefaultValueSet();
                if (defaultValueSet) {
                    this.promptValuesDefaultValue.setPromptValue((PromptDefinitionInterface)this.promptDefaultValue, this.prompt.getDefaultValue());
                }
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
            }
        }
        this.promptPropertiesPanelDefaultValue = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesDefaultValue, (DataProviderInterface)this.dataProvider, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelDefaultValue);
        Border emptyBorder = BorderFactory.createEmptyBorder(5, 10, 10, 10);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(RB.getStringResource("defaultValueBorder.txt"));
        this.promptPropertiesPanelDefaultValue.setBorder(BorderFactory.createCompoundBorder(titledBorder, emptyBorder));
        this.add(this.promptPropertiesPanelDefaultValue);
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.getPromptDefinition(false);
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        this.setContentsValid(true);
        this.libraryPrompt = (SASLibraryDefinition)PromptUtility.newConfiguredPrompt(this.communicator, "SASLibraryDefinition");
        try {
            if (this.promptValuesDefaultValue.isPromptValueAvailable((PromptDefinitionInterface)this.promptDefaultValue)) {
                Object defaultValue = this.promptValuesDefaultValue.getPromptValue((PromptDefinitionInterface)this.promptDefaultValue);
                this.libraryPrompt.setDefaultValue(defaultValue);
            }
        }
        catch (IllegalArgumentException exception) {
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)exception.getMessage())), null);
            }
            this.setContentsValid(false);
            return this.libraryPrompt;
        }
        catch (PromptValueNotFoundException pvnf) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage(), (Throwable)pvnf);
        }
        Collection errors = this.libraryPrompt.validateDefinition(this.getLocale());
        if (errors.size() > 0 && !suppressErrors) {
            String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
            }
            this.setContentsValid(false);
        }
        return this.libraryPrompt;
    }
}

