/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.datatypes.CollectionType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DateType;
import com.sas.datatypes.DoubleType;
import com.sas.datatypes.IntegerType;
import com.sas.datatypes.MonthType;
import com.sas.datatypes.QuarterType;
import com.sas.datatypes.StringType;
import com.sas.datatypes.TimeStampType;
import com.sas.datatypes.TimeType;
import com.sas.datatypes.WeekType;
import com.sas.datatypes.WeekdayType;
import com.sas.datatypes.YearType;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.Lookup;
import com.sas.iquery.metadata.business.LookupByDataItem;
import com.sas.models.OLAPMemberNameInterface;
import com.sas.models.datasources.BaseDataSource;
import com.sas.models.datasources.DataSourceColumnInterface;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.prompts.DynamicPromptValueContext;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.DynamicValueProviderInterface;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValues;
import com.sas.prompts.definitions.ColorDefinitionInterface;
import com.sas.prompts.definitions.DataSourceColumnDefinitionInterface;
import com.sas.prompts.definitions.DataSourceDefinitionInterface;
import com.sas.prompts.definitions.DateDefinition;
import com.sas.prompts.definitions.DateDefinitionInterface;
import com.sas.prompts.definitions.DateRangeDefinitionInterface;
import com.sas.prompts.definitions.DoubleDefinitionInterface;
import com.sas.prompts.definitions.DoubleRangeDefinitionInterface;
import com.sas.prompts.definitions.FileSelectionInterface;
import com.sas.prompts.definitions.InputFileDefinitionInterface;
import com.sas.prompts.definitions.IntegerDefinitionInterface;
import com.sas.prompts.definitions.IntegerRangeDefinitionInterface;
import com.sas.prompts.definitions.MutableDataSourceColumnDefinitionInterface;
import com.sas.prompts.definitions.MutableDataSourceDefinitionInterface;
import com.sas.prompts.definitions.MutableDateDefinitionInterface;
import com.sas.prompts.definitions.MutableDateRangeDefinitionInterface;
import com.sas.prompts.definitions.MutableDoubleDefinitionInterface;
import com.sas.prompts.definitions.MutableDoubleRangeDefinitionInterface;
import com.sas.prompts.definitions.MutableFileSelectionInterface;
import com.sas.prompts.definitions.MutableIntegerDefinitionInterface;
import com.sas.prompts.definitions.MutableIntegerRangeDefinitionInterface;
import com.sas.prompts.definitions.MutableOLAPMemberNameDefinitionInterface;
import com.sas.prompts.definitions.MutablePromptDefinitionInterface;
import com.sas.prompts.definitions.MutableRequiredDefinitionInterface;
import com.sas.prompts.definitions.MutableSelectableDefinitionInterface;
import com.sas.prompts.definitions.MutableStringRangeDefinitionInterface;
import com.sas.prompts.definitions.MutableTextDefinitionInterface;
import com.sas.prompts.definitions.MutableValueProviderDefinitionInterface;
import com.sas.prompts.definitions.OLAPMemberNameDefinitionInterface;
import com.sas.prompts.definitions.OutputFileDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.SASLibraryDefinitionInterface;
import com.sas.prompts.definitions.SelectableDefinitionInterface;
import com.sas.prompts.definitions.StringRangeDefinitionInterface;
import com.sas.prompts.definitions.TextDefinitionInterface;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.prompts.groups.ModalChoiceGroupInterface;
import com.sas.prompts.groups.ModalGroupInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroupInterface;
import com.sas.prompts.groups.shared.SharedPromptGroup;
import com.sas.prompts.groups.shared.SharedPromptGroupInterface;
import com.sas.prompts.simplesqlmodel.PromptValueOperand;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.PromptDataProviderInterface;
import com.sas.prompts.valueprovider.dynamic.iq.DataItemValueProvider;
import com.sas.prompts.valueprovider.dynamic.iq.OLAPDataItemValueProvider;
import com.sas.prompts.valueprovider.dynamic.iq.RelationalDataItemValueProvider;
import com.sas.prompts.valueprovider.dynamic.workspace.PromptColumnValueProvider;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BaseCustomListPanel;
import com.sas.prompts.visuals.swing.designtime.BasePanel;
import com.sas.prompts.visuals.swing.designtime.GeneralPromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.MultipleValuesDateEditor;
import com.sas.prompts.visuals.swing.designtime.PromptPanelConstantsInterface;
import com.sas.prompts.visuals.swing.designtime.PromptTypeInfoInterface;
import com.sas.prompts.visuals.swing.designtime.PromptTypesProviderInterface;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.prompts.visuals.swing.designtime.SingleValidatePromptInterface;
import com.sas.prompts.visuals.swing.designtime.ValidatePromptInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.PhysicalTableInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.simplesqlmodel.Expression;
import com.sas.storage.simplesqlmodel.MultiValueFormattedOperator;
import com.sas.storage.simplesqlmodel.OperandInterface;
import com.sas.storage.simplesqlmodel.OperatorInterface;
import com.sas.storage.simplesqlmodel.WhereClause;
import com.sas.storage.valueprovider.StaticValueProvider;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.swing.visuals.DataSourceUtil;
import com.sas.swing.visuals.itemlistmanager.AbstractItemListManagerPanel;
import com.sas.swing.visuals.tableview.DefaultTableCellRenderer;
import com.sas.swing.visuals.tableview.editors.DateEditor;
import com.sas.swing.visuals.treetable.TreeTableRow;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.util.DatePeriod;
import com.sas.util.DateTypes;
import com.sas.util.MutableSupportedSpecialValuesInterface;
import com.sas.util.Strings;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.SupportedSpecialValuesInterface;
import com.sas.util.UserInfoInterface;
import com.sas.util.ValueItem;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.errorhandlers.JOptionPaneErrorHandler;
import com.sas.util.log.ComponentLogFactoryInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.macrovar.MacroVariableListOptionInterface;
import com.sas.util.macrovar.MutableMacroVariableListOptionInterface;
import com.sas.util.macrovar.MutableMacroVariableOptionInterface;
import com.sas.util.transforms.DataTypeToDisplayStringTransform;
import com.sas.util.transforms.TransformInterface;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.impl.PromptObjectFactory;
import java.awt.Component;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public final class PromptUtility
implements PromptPanelConstantsInterface {
    private static final String BRIEF_INFORMATION_MAP = "BriefInformationMap";
    private static final String PHYSICAL_TABLE = "PhysicalTable";

    private PromptUtility() {
    }

    public static String getGroupType(PromptGroupInterface promptGroupObject) {
        if (promptGroupObject instanceof ModalGroupInterface) {
            return MODAL_GROUP;
        }
        if (promptGroupObject instanceof ModalChoiceGroupInterface) {
            return MODAL_CHOICE_GROUP;
        }
        if (promptGroupObject instanceof TransparentGroupInterface) {
            return TRANSPARENT_GROUP;
        }
        return STANDARD_GROUP;
    }

    static String getGroupTypeID(PromptGroupInterface promptGroupObject) {
        if (promptGroupObject instanceof ModalGroupInterface) {
            return "ModalGroup";
        }
        if (promptGroupObject instanceof ModalChoiceGroupInterface) {
            return "ModalChoiceGroup";
        }
        if (promptGroupObject instanceof TransparentGroupInterface) {
            return "TransparentGroup";
        }
        return "PromptGroup";
    }

    public static String getTypeLabelForPromptObject(Object promptObject) {
        if (promptObject instanceof PromptGroupInterface) {
            if (promptObject instanceof ModalGroupInterface) {
                return MODAL_GROUP;
            }
            if (promptObject instanceof ModalChoiceGroupInterface) {
                return MODAL_CHOICE_GROUP;
            }
            if (promptObject instanceof TransparentGroupInterface) {
                return TRANSPARENT_GROUP;
            }
            return STANDARD_GROUP;
        }
        if (promptObject instanceof PromptDefinitionInterface) {
            if (promptObject instanceof TextDefinitionInterface) {
                return RB.getStringResource("text.txt");
            }
            if (promptObject instanceof DoubleDefinitionInterface) {
                return RB.getStringResource("numericDouble.txt");
            }
            if (promptObject instanceof IntegerDefinitionInterface) {
                return RB.getStringResource("numericInteger.txt");
            }
            if (promptObject instanceof ColorDefinitionInterface) {
                return RB.getStringResource("color.txt");
            }
            if (promptObject instanceof DoubleRangeDefinitionInterface) {
                return RB.getStringResource("numericRangeDouble.txt");
            }
            if (promptObject instanceof IntegerRangeDefinitionInterface) {
                return RB.getStringResource("numericRangeInteger.txt");
            }
            if (promptObject instanceof DateDefinitionInterface) {
                DateTypes dateType = ((DateDefinitionInterface)promptObject).getDateType();
                if (dateType.equals(DateTypes.TIME)) {
                    return RB.getStringResource("time.txt");
                }
                if (dateType.equals(DateTypes.TIMESTAMP)) {
                    return RB.getStringResource("timestamp.txt");
                }
                return RB.getStringResource("date.txt");
            }
            if (promptObject instanceof DateRangeDefinitionInterface) {
                DateTypes dateType = ((DateRangeDefinitionInterface)promptObject).getDateType();
                if (dateType.equals(DateTypes.TIME)) {
                    return RB.getStringResource("timeRange.txt");
                }
                if (dateType.equals(DateTypes.TIMESTAMP)) {
                    return RB.getStringResource("timestampRange.txt");
                }
                return RB.getStringResource("dateRange.txt");
            }
            if (promptObject instanceof DataSourceDefinitionInterface) {
                return RB.getStringResource("dataSource.txt");
            }
            if (promptObject instanceof DataSourceColumnDefinitionInterface) {
                return RB.getStringResource("dataSourceColumn.txt");
            }
            if (promptObject instanceof InputFileDefinitionInterface) {
                return RB.getStringResource("fileNameInput.txt");
            }
            if (promptObject instanceof OutputFileDefinitionInterface) {
                return RB.getStringResource("fileNameOutput.txt");
            }
            if (promptObject instanceof StringRangeDefinitionInterface) {
                return RB.getStringResource("textRange.txt");
            }
            if (promptObject instanceof SASLibraryDefinitionInterface) {
                return RB.getStringResource("SASLibrary.txt");
            }
            if (promptObject instanceof OLAPMemberNameDefinitionInterface) {
                return RB.getStringResource("OLAPMemberName.txt");
            }
            return RB.getStringResource("unknownPromptType.txt");
        }
        return "";
    }

    public static String getTypeLabelForPromptObject(Object promptObject, PropertiesCommunicator communicator, Locale locale) {
        if (communicator == null) {
            return PromptUtility.getTypeLabelForPromptObject(promptObject);
        }
        if (communicator.getPromptTypesProvider() != null) {
            PromptTypesProviderInterface promptTypesProvider = communicator.getPromptTypesProvider();
            PromptTypeInfoInterface promptTypeInfo = promptTypesProvider.getPromptType((PromptDefinitionInterface)promptObject);
            if (promptTypeInfo != null) {
                return promptTypeInfo.getLabel(locale);
            }
            return PromptUtility.getTypeLabelForPromptObject(promptObject);
        }
        return PromptUtility.getTypeLabelForPromptObject(promptObject);
    }

    static String getSelectionTypeForPrompt(SelectableDefinitionInterface prompt) {
        int selectionType = prompt.getSelectionType();
        if (selectionType == 301) {
            return "Multiple values";
        }
        if (selectionType == 302) {
            return "Multiple ordered values";
        }
        return "Single value";
    }

    public static boolean isNonRangeDateType(String promptType) {
        return promptType.equals("Date") || promptType.equals("Time") || promptType.equals("Timestamp");
    }

    public static boolean promptSupportsMultipleValues(String promptType) {
        if (promptType.equals("Text")) {
            return true;
        }
        if (promptType.equals("Numeric")) {
            return true;
        }
        if (promptType.equals("Date")) {
            return true;
        }
        if (promptType.equals("Data Source Column")) {
            return true;
        }
        return promptType.equals("OLAP member");
    }

    static boolean promptSupportsDynamicValues(PromptDefinitionInterface prompt) {
        if (prompt instanceof TextDefinitionInterface) {
            return true;
        }
        if (prompt instanceof DoubleDefinitionInterface) {
            return true;
        }
        if (prompt instanceof IntegerDefinitionInterface) {
            return true;
        }
        if (prompt instanceof DateDefinitionInterface) {
            return true;
        }
        if (prompt instanceof DataSourceColumnInterface) {
            return true;
        }
        return prompt instanceof OLAPMemberNameInterface;
    }

    public static boolean promptTypeSupportsDynamicValues(String promptType) {
        if (promptType.equals("Text")) {
            return true;
        }
        if (promptType.equals("Numeric")) {
            return true;
        }
        return promptType.equals("Date");
    }

    public static boolean isValidPathUrl(String pathUrl) {
        if (pathUrl == null || pathUrl.trim().length() == 0) {
            return false;
        }
        return pathUrl.equals(BRIEF_INFORMATION_MAP) || pathUrl.equals(PHYSICAL_TABLE);
    }

    public static boolean isUserContextAvailable(PropertiesCommunicator communicator) {
        return communicator != null && communicator.getUserContext() != null;
    }

    public static DefaultTreeModel createTreeModel(DefaultMutableTreeNode parentNode, PromptGroupInterface pgi, Locale locale) {
        PromptGroupInterface rootPromptGroup = (PromptGroupInterface)parentNode.getUserObject();
        Object[] rootRowOjects = new Object[]{parentNode.getUserObject(), "", PromptUtility.getTypeLabelForPromptObject(rootPromptGroup), rootPromptGroup.getPromptGroupDescription(locale)};
        TreeTableRow rootRow = new TreeTableRow(null, rootRowOjects);
        DefaultTreeModel treeStructure = new DefaultTreeModel((TreeNode)rootRow);
        DefaultMutableTreeNode treeStructureParentNode = (DefaultMutableTreeNode)treeStructure.getRoot();
        PromptGroupInterface treeStructureParentPromptGroup = (PromptGroupInterface)treeStructureParentNode.getUserObject();
        PromptUtility.addTreeStructureNodes(treeStructureParentNode, treeStructureParentPromptGroup, locale);
        return treeStructure;
    }

    static DefaultTreeModel createTreeModel2(DefaultMutableTreeNode parentNode, PromptGroupInterface pgi, Locale locale, Object currentObject) {
        PromptGroupInterface rootPromptGroup = (PromptGroupInterface)parentNode.getUserObject();
        Object[] rootRowOjects = new Object[]{parentNode.getUserObject(), "", PromptUtility.getTypeLabelForPromptObject(rootPromptGroup), rootPromptGroup.getPromptGroupDescription(locale)};
        TreeTableRow rootRow = new TreeTableRow(null, rootRowOjects);
        DefaultTreeModel treeStructure = new DefaultTreeModel((TreeNode)rootRow);
        DefaultMutableTreeNode treeStructureParentNode = (DefaultMutableTreeNode)treeStructure.getRoot();
        PromptGroupInterface treeStructureParentPromptGroup = (PromptGroupInterface)treeStructureParentNode.getUserObject();
        PromptUtility.addSubgroupAsNode(treeStructureParentNode, rootPromptGroup, currentObject);
        return treeStructure;
    }

    static List createListModel(PromptGroupInterface pgi, Object selectedObject, Locale locale) {
        ArrayList<ValueItem> arrayList = new ArrayList<ValueItem>();
        if (!(selectedObject instanceof ModalChoiceGroupInterface)) {
            arrayList.add(new ValueItem((Object)pgi.getPromptGroupLabel(locale), (Object)pgi));
        }
        PromptUtility.addToList(arrayList, pgi, selectedObject, locale);
        List prunedList = PromptUtility.pruneList(arrayList, selectedObject);
        return prunedList;
    }

    static void addSubgroupAsNode(DefaultMutableTreeNode parentNode, PromptGroupInterface rootPromptGroup, Object selectedObject) {
        TreeTableRow childRow;
        Object[] groupRowOjects;
        Object promptObject;
        List prompts = rootPromptGroup.getPromptSubgroups(false);
        int promptListSize = prompts.size();
        for (int j = 0; j < promptListSize; ++j) {
            promptObject = prompts.get(j);
            if (promptObject == selectedObject || promptObject instanceof SharedPromptGroupInterface || !(promptObject instanceof TransparentGroupInterface)) continue;
            groupRowOjects = new Object[]{promptObject};
            childRow = new TreeTableRow(groupRowOjects);
            parentNode.add((MutableTreeNode)childRow);
            PromptUtility.addSubgroupAsNode((DefaultMutableTreeNode)childRow, (PromptGroupInterface)promptObject, selectedObject);
        }
        for (int k = 0; k < promptListSize; ++k) {
            promptObject = prompts.get(k);
            if (promptObject == selectedObject || promptObject instanceof SharedPromptGroupInterface || !(promptObject instanceof PromptGroupInterface) || promptObject instanceof TransparentGroupInterface) continue;
            groupRowOjects = new Object[]{(PromptGroupInterface)promptObject};
            childRow = new TreeTableRow(groupRowOjects);
            parentNode.add((MutableTreeNode)childRow);
            PromptUtility.addSubgroupAsNode((DefaultMutableTreeNode)childRow, (PromptGroupInterface)promptObject, selectedObject);
        }
    }

    static void addToList(List groupList, PromptGroupInterface pgi, Object selectedObject, Locale locale) {
        if (pgi != null) {
            Object promptObject;
            PromptGroupInterface parentPromptGroup = pgi;
            List prompts = parentPromptGroup.getPromptSubgroups(false);
            int promptListSize = prompts.size();
            for (int j = 0; j < promptListSize; ++j) {
                promptObject = prompts.get(j);
                if (promptObject == selectedObject || promptObject instanceof SharedPromptGroupInterface || !(promptObject instanceof TransparentGroupInterface)) continue;
                groupList.add(new ValueItem((Object)((PromptGroupInterface)promptObject).getPromptGroupLabel(locale), promptObject));
                PromptUtility.addToList(groupList, (PromptGroupInterface)promptObject, selectedObject, locale);
            }
            for (int k = 0; k < promptListSize; ++k) {
                promptObject = prompts.get(k);
                if (promptObject == selectedObject || !(promptObject instanceof PromptGroupInterface) || promptObject instanceof SharedPromptGroupInterface || promptObject instanceof TransparentGroupInterface) continue;
                PromptGroupInterface group = (PromptGroupInterface)promptObject;
                ValueItem item = new ValueItem((Object)group.getPromptGroupLabel(locale), (Object)group);
                if (group.isPromptGroupHidden()) {
                    item.setAttribute("hidden", (Object)Boolean.TRUE);
                }
                groupList.add(item);
                PromptUtility.addToList(groupList, group, selectedObject, locale);
            }
        }
    }

    static List pruneList(List groupList, Object editObject) {
        ArrayList<ValueItem> prunedList = new ArrayList<ValueItem>();
        for (ValueItem valueItem : groupList) {
            PromptGroupInterface promptGroup = (PromptGroupInterface)valueItem.getValue();
            if (editObject instanceof PromptDefinitionInterface) {
                if (promptGroup instanceof ModalGroupInterface) continue;
                prunedList.add(valueItem);
                continue;
            }
            if (PromptUtility.isStandardGroup((PromptGroupInterface)editObject)) {
                if (promptGroup instanceof TransparentGroupInterface) continue;
                prunedList.add(valueItem);
                continue;
            }
            if (!(editObject instanceof TransparentGroupInterface)) continue;
            if (editObject instanceof ModalChoiceGroupInterface) {
                if (!(promptGroup instanceof ModalGroupInterface)) continue;
                prunedList.add(valueItem);
                continue;
            }
            if (editObject instanceof ModalGroupInterface) {
                if (promptGroup instanceof ModalGroupInterface) continue;
                prunedList.add(valueItem);
                continue;
            }
            if (promptGroup instanceof ModalGroupInterface) continue;
            prunedList.add(valueItem);
        }
        return prunedList;
    }

    static List pruneListForGroupType(List groupList, String groupType) {
        ArrayList<ValueItem> prunedList = new ArrayList<ValueItem>();
        for (ValueItem valueItem : groupList) {
            PromptGroupInterface promptGroup = (PromptGroupInterface)valueItem.getValue();
            if (groupType != null && groupType.equals("PromptGroup") && !(promptGroup instanceof TransparentGroupInterface)) {
                prunedList.add(valueItem);
            }
            if (groupType == null || !groupType.equals("TransparentGroup") || !(promptGroup instanceof ModalChoiceGroupInterface) && !PromptUtility.isStandardGroup(promptGroup)) continue;
            prunedList.add(valueItem);
        }
        return prunedList;
    }

    static boolean hasAncestorSharedGroup(PromptGroupInterface rootPromptGroup, PromptGroupInterface promptGroup) {
        boolean isInSharedGroup = false;
        if (promptGroup instanceof SharedPromptGroupInterface) {
            return true;
        }
        List groups = PromptUtil.getPathToPromptGroup((PromptGroupInterface)rootPromptGroup, (PromptGroupInterface)promptGroup);
        for (PromptGroupInterface pgi : groups) {
            if (!(pgi instanceof SharedPromptGroup)) continue;
            isInSharedGroup = true;
            break;
        }
        return isInSharedGroup;
    }

    static boolean isPromptNotInSharedGroup(PromptGroupInterface rootPromptGroup, PromptGroupInterface promptParentGroup) {
        boolean isNotInSharedGroup = true;
        List groups = PromptUtil.getPathToPromptGroup((PromptGroupInterface)rootPromptGroup, (PromptGroupInterface)promptParentGroup);
        for (PromptGroupInterface pgi : groups) {
            if (!(pgi instanceof SharedPromptGroup) || pgi == promptParentGroup) continue;
            isNotInSharedGroup = false;
            break;
        }
        return isNotInSharedGroup;
    }

    private static void addTreeStructureNodes(DefaultMutableTreeNode parentNode, PromptGroupInterface pgi, Locale locale) {
        if (parentNode != null) {
            TreeTableRow childRow;
            Object[] groupRowObjects;
            Object promptObject;
            PromptGroupInterface parentPromptGroup = (PromptGroupInterface)parentNode.getUserObject();
            List prompts = parentPromptGroup.getPromptSubgroups(false);
            int promptListSize = prompts.size();
            for (int j = 0; j < promptListSize; ++j) {
                promptObject = prompts.get(j);
                if (!(promptObject instanceof TransparentGroupInterface)) continue;
                groupRowObjects = new Object[]{(PromptGroupInterface)promptObject, "", PromptUtility.getTypeLabelForPromptObject(promptObject), ((PromptGroupInterface)promptObject).getPromptGroupDescription(locale)};
                childRow = new TreeTableRow(groupRowObjects);
                parentNode.add((MutableTreeNode)childRow);
                PromptUtility.addTreeStructureNodes((DefaultMutableTreeNode)childRow, (PromptGroupInterface)promptObject, locale);
            }
            for (int k = 0; k < promptListSize; ++k) {
                promptObject = prompts.get(k);
                if (!(promptObject instanceof PromptGroupInterface) || promptObject instanceof SharedPromptGroupInterface || promptObject instanceof TransparentGroupInterface) continue;
                groupRowObjects = new Object[]{(PromptGroupInterface)promptObject, "", PromptUtility.getTypeLabelForPromptObject(promptObject), ((PromptGroupInterface)promptObject).getPromptGroupDescription(locale)};
                childRow = new TreeTableRow(groupRowObjects);
                parentNode.add((MutableTreeNode)childRow);
                PromptUtility.addTreeStructureNodes((DefaultMutableTreeNode)childRow, (PromptGroupInterface)promptObject, locale);
            }
        }
    }

    public static int getSQLType(long columnType) {
        if (columnType == -1L) {
            return 12;
        }
        if (columnType == 1L) {
            return 12;
        }
        if (columnType == 2L) {
            return 8;
        }
        if (columnType == 4L) {
            return 91;
        }
        if (columnType == 8L) {
            return 92;
        }
        if (columnType == 16L) {
            return 93;
        }
        return 12;
    }

    public static int getSQLType(DataItem dataItem) {
        if (dataItem != null) {
            int type = dataItem.getExpressionTypeIgnoringFormattingForced();
            if (type == 2) {
                return 2;
            }
            if (type == 1) {
                return 12;
            }
            if (type == 9) {
                return 16;
            }
            if (type == 3) {
                return 1;
            }
            if (type == 4) {
                return 91;
            }
            if (type == 10) {
                return 2000;
            }
            if (type == 8) {
                return 91;
            }
            if (type == 7) {
                return 91;
            }
            if (type == 0) {
                return 1111;
            }
            if (type == 5) {
                return 92;
            }
            if (type == 6) {
                return 93;
            }
            if (type == 11) {
                return 12;
            }
        }
        return 8;
    }

    static DefaultComboBoxModel newComboModel(PropertiesCommunicator communicator) {
        DefaultComboBoxModel<ValueItem> promptTypeModel = new DefaultComboBoxModel<ValueItem>();
        promptTypeModel.addElement(new ValueItem((Object)TEXT_PROMPT, (Object)"Text"));
        promptTypeModel.addElement(new ValueItem((Object)TEXT_RANGE_PROMPT, (Object)"Text Range"));
        promptTypeModel.addElement(new ValueItem((Object)NUMERIC_PROMPT, (Object)"Numeric"));
        promptTypeModel.addElement(new ValueItem((Object)NUMERIC_RANGE_PROMPT, (Object)"Numeric Range"));
        promptTypeModel.addElement(new ValueItem((Object)DATE_PROMPT, (Object)"Date"));
        promptTypeModel.addElement(new ValueItem((Object)DATE_RANGE_PROMPT, (Object)"Date Range"));
        promptTypeModel.addElement(new ValueItem((Object)TIME_PROMPT, (Object)"Time"));
        promptTypeModel.addElement(new ValueItem((Object)TIME_RANGE_PROMPT, (Object)"Time Range"));
        promptTypeModel.addElement(new ValueItem((Object)TIMESTAMP_PROMPT, (Object)"Timestamp"));
        promptTypeModel.addElement(new ValueItem((Object)TIMESTAMP_RANGE_PROMPT, (Object)"Timestamp Range"));
        promptTypeModel.addElement(new ValueItem((Object)COLOR_PROMPT, (Object)"Color"));
        if (null != communicator && PromptUtility.isUserContextAvailable(communicator) && PromptUtility.isUserContextAvailable(communicator)) {
            promptTypeModel.addElement(new ValueItem((Object)DATASOURCE_PROMPT, (Object)"Data Source"));
            promptTypeModel.addElement(new ValueItem((Object)DATASOURCE_COLUMN_PROMPT, (Object)"Data Source Column"));
            promptTypeModel.addElement(new ValueItem((Object)FILENAME_PROMPT, (Object)"File Name"));
            promptTypeModel.addElement(new ValueItem((Object)OLAP_MEMBER_NAME_PROMPT, (Object)"OLAP member"));
            promptTypeModel.addElement(new ValueItem((Object)SAS_LIBRARY_PROMPT, (Object)"SAS Library"));
        }
        return promptTypeModel;
    }

    static ValueItem newDayValueItem() {
        return new ValueItem((Object)RB.getStringResource("day.txt"), (Object)"Date");
    }

    static ValueItem newWeekValueItem() {
        return new ValueItem((Object)RB.getStringResource("week.txt"), (Object)"Week");
    }

    static ValueItem newMonthValueItem() {
        return new ValueItem((Object)RB.getStringResource("month.txt"), (Object)"Month");
    }

    static ValueItem newQuarterValueItem() {
        return new ValueItem((Object)RB.getStringResource("quarter.txt"), (Object)"Quarter");
    }

    static ValueItem newYearValueItem() {
        return new ValueItem((Object)RB.getStringResource("year.txt"), (Object)"Year");
    }

    static ValueItem newSingleValueItem() {
        return new ValueItem((Object)SINGLE_VALUE, (Object)"Single value");
    }

    static ValueItem newAllSpecialValuesValueItem(Locale locale) {
        return new ValueItem((Object)SpecialValues.toDisplayString((SpecialValues)SpecialValues.ALL, (Locale)locale), (Object)SpecialValues.ALL);
    }

    static ValueItem newOtherSpecialValuesValueItem(Locale locale) {
        return new ValueItem((Object)SpecialValues.toDisplayString((SpecialValues)SpecialValues.OTHER, (Locale)locale), (Object)SpecialValues.OTHER);
    }

    static ValueItem newNoneValueItem() {
        return new ValueItem((Object)RB.getStringResource("noneValueItem.txt"), new Object());
    }

    static ValueItem newNoDataItemsValueItem() {
        return new ValueItem((Object)RB.getStringResource("noDataItems.txt"), (Object)RB.getStringResource("noDataItems.txt"));
    }

    static ValueItem newNoColumnsValueItem() {
        return new ValueItem((Object)RB.getStringResource("noColumns.txt"), (Object)RB.getStringResource("noColumns.txt"));
    }

    static ValueItem newMissingValuesValueItem(Locale locale) {
        return new ValueItem((Object)MissingValues.toDisplayString((MissingValues)MissingValues.Dot, (Locale)locale), (Object)MissingValues.Dot);
    }

    static ValueItem newUnknownPromptValueItem() {
        return new ValueItem((Object)UNKNOWN_PROMPT_TYPE, (Object)"Unknown Prompt Type");
    }

    static ValueItem newModalGroupValueItem() {
        return new ValueItem((Object)MODAL_GROUP, (Object)"ModalGroup");
    }

    static ValueItem newModalChoiceGroupValueItem() {
        return new ValueItem((Object)MODAL_CHOICE_GROUP, (Object)"ModalChoiceGroup");
    }

    static ValueItem newTransparentGroupValueItem() {
        return new ValueItem((Object)TRANSPARENT_GROUP, (Object)"TransparentGroup");
    }

    static ValueItem newStandardGroupValueItem() {
        return new ValueItem((Object)STANDARD_GROUP, (Object)"PromptGroup");
    }

    static boolean isTransparentGroup(PromptGroupInterface promptGroup) {
        return promptGroup instanceof TransparentGroupInterface && !(promptGroup instanceof ModalChoiceGroupInterface) && !(promptGroup instanceof ModalGroupInterface);
    }

    static boolean isStandardGroup(PromptGroupInterface promptGroup) {
        return !(promptGroup instanceof TransparentGroupInterface);
    }

    static int convertSelectionType(String selectionType) {
        if (selectionType == "Multiple values") {
            return 302;
        }
        if (selectionType.equals("Multiple ordered values")) {
            return 302;
        }
        return 300;
    }

    static boolean hasNameConflict(String value, String promptName) {
        if (value == null || value.trim().length() == 0) {
            return false;
        }
        if (promptName == null || promptName.trim().length() == 0) {
            return false;
        }
        return value.equals(promptName);
    }

    static boolean isPromptTypeValidForPromptValueOperand(PromptDefinitionInterface promptDefinition) {
        return promptDefinition instanceof TextDefinitionInterface || promptDefinition instanceof IntegerDefinitionInterface || promptDefinition instanceof DoubleDefinitionInterface || promptDefinition instanceof DateDefinitionInterface || promptDefinition instanceof IntegerRangeDefinitionInterface || promptDefinition instanceof DoubleRangeDefinitionInterface || promptDefinition instanceof StringRangeDefinitionInterface || promptDefinition instanceof DateRangeDefinitionInterface;
    }

    static final PromptDefinitionInterface copyPromptProperties(MutablePromptDefinitionInterface toPrompt, PromptDefinitionInterface fromPrompt, Locale locale, boolean mustClone, PropertiesCommunicator communicator) {
        List keys;
        UserInfoInterface currentUserInfo;
        toPrompt.setPromptLabel(fromPrompt.getPromptLabel(locale), locale);
        toPrompt.setPromptDescription(fromPrompt.getPromptDescription(locale), locale);
        toPrompt.setPromptName(fromPrompt.getPromptName());
        toPrompt.setHidden(fromPrompt.isHidden());
        toPrompt.setStickyDefaultAllowed(fromPrompt.isStickyDefaultAllowed());
        toPrompt.setFixed(fromPrompt.isFixed());
        LoggerFactoryInterface loggerFactory = null;
        if (fromPrompt instanceof ComponentLogFactoryInterface && toPrompt instanceof ComponentLogFactoryInterface) {
            loggerFactory = ((ComponentLogFactoryInterface)fromPrompt).getLoggerFactory();
            ((ComponentLogFactoryInterface)toPrompt).setLoggerFactory(loggerFactory);
        }
        if (toPrompt instanceof MutableMacroVariableOptionInterface) {
            toPrompt.setMacroVariableOutputLevel(fromPrompt.getMacroVariableOutputLevel());
        }
        if (toPrompt instanceof MacroVariableListOptionInterface) {
            ((MutableMacroVariableListOptionInterface)toPrompt).setMacroVariableListFormat(((MacroVariableListOptionInterface)fromPrompt).getMacroVariableListFormat());
            ((MutableMacroVariableListOptionInterface)toPrompt).setMacroVariableQuote(((MacroVariableListOptionInterface)fromPrompt).getMacroVariableQuote());
            ((MutableMacroVariableListOptionInterface)toPrompt).setMacroVariableListDelimiter(((MacroVariableListOptionInterface)fromPrompt).getMacroVariableListDelimiter());
        }
        if (toPrompt instanceof MutableSelectableDefinitionInterface) {
            ((MutableSelectableDefinitionInterface)toPrompt).setMinimumValueCount(((MutableSelectableDefinitionInterface)fromPrompt).getMinimumValueCount());
            ((MutableSelectableDefinitionInterface)toPrompt).setMaximumValueCount(((MutableSelectableDefinitionInterface)fromPrompt).getMaximumValueCount());
            ((MutableSelectableDefinitionInterface)toPrompt).setSelectionOrdered(((MutableSelectableDefinitionInterface)fromPrompt).isSelectionOrdered());
        } else if (toPrompt instanceof MutableRequiredDefinitionInterface) {
            ((MutableRequiredDefinitionInterface)toPrompt).setRequired(fromPrompt.isRequired());
        }
        if (toPrompt instanceof MutableValueProviderDefinitionInterface) {
            ((MutableValueProviderDefinitionInterface)toPrompt).setAllowUserValues(((ValueProviderDefinitionInterface)fromPrompt).isAllowUserValues());
            ((MutableValueProviderDefinitionInterface)toPrompt).setPageSize(((ValueProviderDefinitionInterface)fromPrompt).getPageSize());
            ValueProviderInterface vp = ((ValueProviderDefinitionInterface)fromPrompt).getValueProvider();
            if (mustClone) {
                ((MutableValueProviderDefinitionInterface)toPrompt).setValueProvider(vp);
            } else if (null != vp && vp instanceof StaticValueProvider && null != ((ValueProviderDefinitionInterface)toPrompt).getValueProvider() && ((ValueProviderDefinitionInterface)toPrompt).getValueProvider() instanceof StaticValueProvider) {
                StaticValueProvider svp = (StaticValueProvider)vp;
                Collection col = svp.getLocales();
                if (col.contains(locale)) {
                    StaticValueProvider toSVP = (StaticValueProvider)((ValueProviderDefinitionInterface)toPrompt).getValueProvider();
                    try {
                        toSVP.setValues((List)svp.getValues(locale), locale);
                        toSVP.setValueDisplayed(svp.isValueDisplayed());
                    }
                    catch (ValueProviderException e) {
                        LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)loggerFactory).warn(e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            } else {
                ((MutableValueProviderDefinitionInterface)toPrompt).setValueProvider(vp);
            }
        }
        if (toPrompt instanceof SupportedSpecialValuesInterface) {
            SupportedSpecialValues specialValues = ((SupportedSpecialValuesInterface)fromPrompt).getSupportedSpecialValues();
            ((MutableSupportedSpecialValuesInterface)toPrompt).setSupportedSpecialValues(specialValues);
        }
        toPrompt.setUserInfo(fromPrompt.getUserInfo());
        UserInfoInterface fromUserInfo = fromPrompt.getUserInfo();
        if (fromUserInfo.isEmpty() && (currentUserInfo = toPrompt.getUserInfo()) != null && (keys = currentUserInfo.getKeys()) != null) {
            int keySize = keys.size();
            for (int i = keySize - 1; i >= 0; --i) {
                String key = (String)keys.get(i);
                if (key == null) continue;
                toPrompt.removeUserInfo(key);
            }
        }
        if (toPrompt instanceof MutableTextDefinitionInterface) {
            ((MutableTextDefinitionInterface)toPrompt).setMinimumLength(((MutableTextDefinitionInterface)fromPrompt).getMinimumLength());
            ((MutableTextDefinitionInterface)toPrompt).setMaximumLength(((MutableTextDefinitionInterface)fromPrompt).getMaximumLength());
            ((MutableTextDefinitionInterface)toPrompt).setAllowMultipleLines(((MutableTextDefinitionInterface)fromPrompt).isAllowMultipleLines());
            ((MutableTextDefinitionInterface)toPrompt).setMaximumLines(((MutableTextDefinitionInterface)fromPrompt).getMaximumLines());
            ((MutableTextDefinitionInterface)toPrompt).setDisplayedLines(((MutableTextDefinitionInterface)fromPrompt).getDisplayedLines());
            ((MutableTextDefinitionInterface)toPrompt).setMasked(((MutableTextDefinitionInterface)fromPrompt).isMasked());
            ((MutableTextDefinitionInterface)toPrompt).setMaskedTextEncoding(((MutableTextDefinitionInterface)fromPrompt).getMaskedTextEncoding());
            ((MutableTextDefinitionInterface)toPrompt).setHint(((MutableTextDefinitionInterface)fromPrompt).getHint(locale), locale);
        } else if (toPrompt instanceof MutableDoubleDefinitionInterface) {
            ((MutableDoubleDefinitionInterface)toPrompt).setMinimum(((MutableDoubleDefinitionInterface)fromPrompt).getMinimum());
            ((MutableDoubleDefinitionInterface)toPrompt).setMaximum(((MutableDoubleDefinitionInterface)fromPrompt).getMaximum());
            ((MutableDoubleDefinitionInterface)toPrompt).setMinimumDecimalPlaces(((MutableDoubleDefinitionInterface)fromPrompt).getMinimumDecimalPlaces());
            ((MutableDoubleDefinitionInterface)toPrompt).setMaximumDecimalPlaces(((MutableDoubleDefinitionInterface)fromPrompt).getMaximumDecimalPlaces());
        } else if (toPrompt instanceof MutableIntegerDefinitionInterface) {
            ((MutableIntegerDefinitionInterface)toPrompt).setMinimum(((MutableIntegerDefinitionInterface)fromPrompt).getMinimum());
            ((MutableIntegerDefinitionInterface)toPrompt).setMaximum(((MutableIntegerDefinitionInterface)fromPrompt).getMaximum());
        } else if (toPrompt instanceof MutableDoubleRangeDefinitionInterface) {
            ((MutableDoubleRangeDefinitionInterface)toPrompt).setMinimum(((MutableDoubleRangeDefinitionInterface)fromPrompt).getMinimum());
            ((MutableDoubleRangeDefinitionInterface)toPrompt).setMaximum(((MutableDoubleRangeDefinitionInterface)fromPrompt).getMaximum());
            ((MutableDoubleRangeDefinitionInterface)toPrompt).setMinimumDecimalPlaces(((MutableDoubleRangeDefinitionInterface)fromPrompt).getMinimumDecimalPlaces());
            ((MutableDoubleRangeDefinitionInterface)toPrompt).setMaximumDecimalPlaces(((MutableDoubleRangeDefinitionInterface)fromPrompt).getMaximumDecimalPlaces());
        } else if (toPrompt instanceof MutableIntegerRangeDefinitionInterface) {
            ((MutableIntegerRangeDefinitionInterface)toPrompt).setMinimum(((MutableIntegerRangeDefinitionInterface)fromPrompt).getMinimum());
            ((MutableIntegerRangeDefinitionInterface)toPrompt).setMaximum(((MutableIntegerRangeDefinitionInterface)fromPrompt).getMaximum());
        } else if (toPrompt instanceof MutableStringRangeDefinitionInterface) {
            ((MutableStringRangeDefinitionInterface)toPrompt).setMinimum(((MutableStringRangeDefinitionInterface)fromPrompt).getMinimum());
            ((MutableStringRangeDefinitionInterface)toPrompt).setMaximum(((MutableStringRangeDefinitionInterface)fromPrompt).getMaximum());
            ((MutableStringRangeDefinitionInterface)toPrompt).setMinimumLength(((MutableStringRangeDefinitionInterface)fromPrompt).getMinimumLength());
            ((MutableStringRangeDefinitionInterface)toPrompt).setMaximumLength(((MutableStringRangeDefinitionInterface)fromPrompt).getMaximumLength());
        } else if (toPrompt instanceof MutableDateDefinitionInterface) {
            ((MutableDateDefinitionInterface)toPrompt).setDateType(((MutableDateDefinitionInterface)fromPrompt).getDateType());
            ((MutableDateDefinitionInterface)toPrompt).setMinimum(((MutableDateDefinitionInterface)fromPrompt).getMinimum());
            ((MutableDateDefinitionInterface)toPrompt).setMaximum(((MutableDateDefinitionInterface)fromPrompt).getMaximum());
        } else if (toPrompt instanceof MutableDateRangeDefinitionInterface) {
            ((MutableDateRangeDefinitionInterface)toPrompt).setDateType(((MutableDateRangeDefinitionInterface)fromPrompt).getDateType());
            ((MutableDateRangeDefinitionInterface)toPrompt).setMinimum(((MutableDateRangeDefinitionInterface)fromPrompt).getMinimum());
            ((MutableDateRangeDefinitionInterface)toPrompt).setMaximum(((MutableDateRangeDefinitionInterface)fromPrompt).getMaximum());
        } else if (toPrompt instanceof MutableDataSourceDefinitionInterface) {
            ((MutableDataSourceDefinitionInterface)toPrompt).setAllowedDataSourceTypes(((MutableDataSourceDefinitionInterface)fromPrompt).getAllowedDataSourceTypes());
        } else if (toPrompt instanceof MutableDataSourceColumnDefinitionInterface) {
            ((MutableDataSourceColumnDefinitionInterface)toPrompt).setAllowedDataSourceTypes(((MutableDataSourceColumnDefinitionInterface)fromPrompt).getAllowedDataSourceTypes());
            ((MutableDataSourceColumnDefinitionInterface)toPrompt).setAllowedColumnTypes(((MutableDataSourceColumnDefinitionInterface)fromPrompt).getAllowedColumnTypes());
            ((MutableDataSourceColumnDefinitionInterface)toPrompt).setDataSources(((MutableDataSourceColumnDefinitionInterface)fromPrompt).getDataSources());
            ((MutableDataSourceColumnDefinitionInterface)toPrompt).setAllowMultipleDataSources(((MutableDataSourceColumnDefinitionInterface)fromPrompt).isAllowMultipleDataSources());
        } else if (toPrompt instanceof MutableOLAPMemberNameDefinitionInterface) {
            if (((MutableOLAPMemberNameDefinitionInterface)fromPrompt).getDataItem() != null) {
                ((MutableOLAPMemberNameDefinitionInterface)toPrompt).setDataItem(((MutableOLAPMemberNameDefinitionInterface)fromPrompt).getDataItem());
            }
            if (((MutableOLAPMemberNameDefinitionInterface)fromPrompt).isDefaultValueSet()) {
                ((MutableOLAPMemberNameDefinitionInterface)toPrompt).setDefaultValue(((MutableOLAPMemberNameDefinitionInterface)fromPrompt).getDefaultValue());
            }
            ((MutableOLAPMemberNameDefinitionInterface)toPrompt).setDataSource(((MutableOLAPMemberNameDefinitionInterface)fromPrompt).getDataSource());
        } else if (toPrompt instanceof MutableFileSelectionInterface) {
            ((MutableFileSelectionInterface)toPrompt).setLogicalServerName(((FileSelectionInterface)fromPrompt).getLogicalServerName());
            ((MutableFileSelectionInterface)toPrompt).setFileTypes(((FileSelectionInterface)fromPrompt).getFileTypes());
            ((MutableFileSelectionInterface)toPrompt).setFileSelectionMode(((FileSelectionInterface)fromPrompt).getFileSelectionMode());
        }
        if (fromPrompt.isDefaultValueSet()) {
            toPrompt.setDefaultValue(fromPrompt.getDefaultValue());
        } else {
            toPrompt.clearDefaultValue();
        }
        return toPrompt;
    }

    static String getDatePromptTypeForDataType(DateTypes dateType) {
        if (dateType.equals(DateTypes.WEEKDAY)) {
            return "Date";
        }
        if (dateType.equals(DateTypes.WEEK)) {
            return "Week";
        }
        if (dateType.equals(DateTypes.MONTH)) {
            return "Month";
        }
        if (dateType.equals(DateTypes.QUARTER)) {
            return "Quarter";
        }
        if (dateType.equals(DateTypes.YEAR)) {
            return "Year";
        }
        if (dateType.equals(DateTypes.TIME)) {
            return "Time";
        }
        if (dateType.equals(DateTypes.TIMESTAMP)) {
            return "Timestamp";
        }
        return "Date";
    }

    static DataTypeInterface getDataType(String promptType) {
        StringType dataType = null;
        if (promptType != null) {
            if (promptType.equals("Text")) {
                dataType = StringType.DEFAULT_INSTANCE;
            } else if (promptType.equals("Integer")) {
                dataType = IntegerType.DEFAULT_INSTANCE;
            } else if (promptType.equals("Numeric")) {
                dataType = DoubleType.DEFAULT_INSTANCE;
            } else if (promptType.equals("Date")) {
                dataType = DateType.DEFAULT_INSTANCE;
            } else if (promptType.equals("Time")) {
                dataType = TimeType.DEFAULT_INSTANCE;
            } else if (promptType.equals("Timestamp")) {
                dataType = TimeStampType.DEFAULT_INSTANCE;
            } else if (promptType.equals(PromptPanelConstantsInterface.DAY)) {
                dataType = WeekdayType.DEFAULT_INSTANCE;
            } else if (promptType.equals("Week")) {
                dataType = WeekType.DEFAULT_INSTANCE;
            } else if (promptType.equals("Month")) {
                dataType = MonthType.DEFAULT_INSTANCE;
            } else if (promptType.equals("Quarter")) {
                dataType = QuarterType.DEFAULT_INSTANCE;
            } else if (promptType.equals("Year")) {
                dataType = YearType.DEFAULT_INSTANCE;
            }
        }
        return dataType;
    }

    static DataTypeInterface getCollectionDataType(String promptType) {
        CollectionType dataType = null;
        if (promptType != null) {
            if (promptType.equals("Text")) {
                dataType = CollectionType.DEFAULT_INSTANCE_STRING;
            } else if (promptType.equals("Integer")) {
                dataType = CollectionType.DEFAULT_INSTANCE_INTEGER;
            } else if (promptType.equals("Numeric")) {
                dataType = CollectionType.DEFAULT_INSTANCE_DOUBLE;
            } else if (promptType.equals("Date")) {
                dataType = CollectionType.DEFAULT_INSTANCE_DATE;
            } else if (promptType.equals("Time")) {
                dataType = CollectionType.DEFAULT_INSTANCE_TIME;
            } else if (promptType.equals("Timestamp")) {
                dataType = CollectionType.DEFAULT_INSTANCE_TIMESTAMP;
            } else if (promptType.equals(PromptPanelConstantsInterface.DAY)) {
                dataType = CollectionType.DEFAULT_INSTANCE_WEEKDAY;
            } else if (promptType.equals("Week")) {
                dataType = CollectionType.DEFAULT_INSTANCE_WEEK;
            } else if (promptType.equals("Month")) {
                dataType = CollectionType.DEFAULT_INSTANCE_MONTH;
            } else if (promptType.equals("Quarter")) {
                dataType = CollectionType.DEFAULT_INSTANCE_QUARTER;
            } else if (promptType.equals("Year")) {
                dataType = CollectionType.DEFAULT_INSTANCE_YEAR;
            }
        }
        return dataType;
    }

    static int getSpecialValuesConstant(DataItem dataItem) {
        if (dataItem != null) {
            Lookup lookUpType = dataItem.getLookupType();
            if (lookUpType instanceof LookupByDataItem) {
                return 1;
            }
            return 0;
        }
        return 1;
    }

    static int countOccurences(List list, Object of) {
        if (list == null) {
            return 0;
        }
        int count = 0;
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            Object o = list.get(i);
            if (o == null && of == null) {
                ++count;
                continue;
            }
            if (o == null || of == null || !of.equals(o)) continue;
            ++count;
        }
        return count;
    }

    static void configurePropertiesPanel(PromptPropertiesPanel promptPropertiesPanel) {
        promptPropertiesPanel.setShowRequiredCheckBox(false);
        promptPropertiesPanel.setShowRequiredLabel(false);
        promptPropertiesPanel.setShowSeparators(false);
        promptPropertiesPanel.setVisualsIndented(false);
        promptPropertiesPanel.applyStyle("GROUP_PANEL_BORDER", null);
        promptPropertiesPanel.removeStyleValue("GROUP_PANEL_BACKGROUND_COLOR");
        promptPropertiesPanel.applyStyle("GROUP_PANEL_SCROLLER_BORDER", null);
    }

    static List createStaticValues(DefaultTableModel tableModel, MutableSelectableDefinitionInterface prompt, Locale locale) {
        return PromptUtility.createStaticValues(tableModel, prompt.getPromptDataType(), prompt.getSelectionType(), locale);
    }

    static List createStaticValues(DefaultTableModel tableModel, DataTypeInterface promptType, int selectionType, Locale locale) {
        LinkedList<ValueItem> staticValues = new LinkedList<ValueItem>();
        ArrayList<Object> defaultValue = new ArrayList<Object>();
        ArrayList<AbstractList> combinedList = new ArrayList<AbstractList>();
        String unformattedValue = RB.getStringResource("useUnformattedValue.txt");
        int tableSize = tableModel.getRowCount();
        for (int i = 0; i < tableSize; ++i) {
            Object o;
            Object oValue = tableModel.getValueAt(i, 0);
            if (oValue != SpecialValues.ALL && oValue != SpecialValues.OTHER && oValue != MissingValues.Dot && oValue != MissingValues._BLANK_) {
                Object obj;
                o = tableModel.getValueAt(i, 2);
                if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
                    defaultValue.add(tableModel.getValueAt(i, 0));
                }
                if (unformattedValue == (obj = tableModel.getValueAt(i, 1))) {
                    String label = null;
                    if (selectionType == 300) {
                        label = promptType.getDisplayString(tableModel.getValueAt(i, 0), locale);
                    } else {
                        ArrayList<Object> values = new ArrayList<Object>();
                        values.add(tableModel.getValueAt(i, 0));
                        label = promptType.getDisplayString(values, locale);
                    }
                    staticValues.add(new ValueItem((Object)label, tableModel.getValueAt(i, 0)));
                    continue;
                }
                staticValues.add(new ValueItem(tableModel.getValueAt(i, 1), tableModel.getValueAt(i, 0)));
                continue;
            }
            o = (Boolean)tableModel.getValueAt(i, 2);
            if (!((Boolean)o).booleanValue()) continue;
            defaultValue.add(tableModel.getValueAt(i, 0));
        }
        combinedList.add(staticValues);
        combinedList.add(defaultValue);
        return combinedList;
    }

    static boolean hasDuplicateLabels(List staticValues) {
        boolean containsDuplicateLabels = false;
        boolean foundDupLabel = false;
        ArrayList<String> labelsList = new ArrayList<String>();
        ArrayList<Object> valuesList = new ArrayList<Object>();
        int listSize = staticValues.size();
        for (int i = 0; i < listSize; ++i) {
            ValueItem valueItem = (ValueItem)staticValues.get(i);
            labelsList.add(valueItem.getLabel().trim());
            valuesList.add(valueItem.getValue());
        }
        int labelsSize = labelsList.size();
        for (int j = 0; j < labelsSize; ++j) {
            String newLabel;
            int lastIndex = labelsList.lastIndexOf(labelsList.get(j));
            if (lastIndex != j) {
                if (valuesList.get(j) == null) continue;
                if (valuesList.get(j).equals(valuesList.get(lastIndex))) {
                    containsDuplicateLabels = true;
                    break;
                }
                newLabel = labelsList.get(j).toString() + " [" + valuesList.get(j).toString() + "]";
                ((ValueItem)staticValues.get(j)).setLabel(newLabel);
                foundDupLabel = true;
                continue;
            }
            if (lastIndex == -1 || !foundDupLabel || labelsList.get(j) == null || labelsList.indexOf(labelsList.get(j)) == lastIndex) continue;
            newLabel = labelsList.get(j).toString() + " [" + valuesList.get(j).toString() + "]";
            ((ValueItem)staticValues.get(j)).setLabel(newLabel);
        }
        return containsDuplicateLabels;
    }

    static String getPromptType(PromptDefinitionInterface prompt) {
        if (prompt instanceof TextDefinitionInterface) {
            return "Text";
        }
        if (prompt instanceof IntegerDefinitionInterface) {
            return "Integer";
        }
        if (prompt instanceof DoubleDefinitionInterface) {
            return "Numeric";
        }
        if (prompt instanceof DateDefinitionInterface) {
            DateTypes dateType = ((DateDefinitionInterface)prompt).getDateType();
            if (dateType != null) {
                if (dateType.equals(DateTypes.DATE)) {
                    return "Date";
                }
                if (dateType.equals(DateTypes.WEEK)) {
                    return WEEK;
                }
                if (dateType.equals(DateTypes.MONTH)) {
                    return MONTH;
                }
                if (dateType.equals(DateTypes.QUARTER)) {
                    return QUARTER;
                }
                if (dateType.equals(DateTypes.YEAR)) {
                    return YEAR;
                }
                if (dateType == DateTypes.TIME) {
                    return "Time";
                }
                if (dateType == DateTypes.TIMESTAMP) {
                    return "Timestamp";
                }
                return "Date";
            }
            return "Text";
        }
        return "Text";
    }

    static String getDataTypeLabel(PromptDefinitionInterface prompt) {
        String label = "";
        if (prompt == null) {
            return label;
        }
        if (prompt instanceof TextDefinitionInterface) {
            label = RB.getStringResource("text.txt");
        } else if (prompt instanceof IntegerDefinitionInterface) {
            label = RB.getStringResource("numericInteger.txt");
        } else if (prompt instanceof DoubleDefinitionInterface) {
            label = RB.getStringResource("numericDouble.txt");
        } else if (prompt instanceof DateDefinitionInterface) {
            label = RB.getStringResource("date.txt");
        }
        return label;
    }

    static String getLabelForVector(DataTypeInterface dataType, String label, String testLabel, Object value, Locale locale) {
        if (label != null && testLabel != null) {
            if (label.trim().equals(testLabel.trim())) {
                return RB.getStringResource("useUnformattedValue.txt");
            }
            try {
                Object obj = dataType.coerceValue(value, locale);
                if (obj instanceof MissingValues) {
                    return MissingValues.toDisplayString((MissingValues)MissingValues.Dot, (Locale)Locale.getDefault());
                }
                String coercedLabel = dataType.getValueAsString(obj, locale);
                if (coercedLabel != null && coercedLabel.equals(label)) {
                    return RB.getStringResource("useUnformattedValue.txt");
                }
                return label;
            }
            catch (IllegalArgumentException iae) {
                return label;
            }
        }
        if (label == null && testLabel == null) {
            return RB.getStringResource("useUnformattedValue.txt");
        }
        return label;
    }

    static void configurePromptValuesForDates(PromptValues promptValuesMinMax, PromptDefinitionInterface prompt, DateDefinitionInterface promptMinValue, DateDefinitionInterface promptMaxValue, PropertiesCommunicator communicator, DateTypes dateType, Locale locale) {
        block27: {
            Map savedProperties = communicator.getPromptProperties();
            if (!savedProperties.isEmpty()) {
                try {
                    Date maxValue;
                    DataTypeInterface promptDataType;
                    DateTypes oDateType;
                    Object o;
                    if (savedProperties.containsKey("min") && (o = savedProperties.get("min")) instanceof Date) {
                        Date minValue;
                        if (o instanceof DatePeriod) {
                            oDateType = ((DatePeriod)o).getPeriodType();
                            if (oDateType == dateType && (minValue = (Date)o) != null && !minValue.equals(DateDefinition.minimumMinimum)) {
                                promptValuesMinMax.setPromptValue((PromptDefinitionInterface)promptMinValue, minValue);
                            }
                        } else if ((Date)o != null && !((Date)o).equals(DateDefinition.minimumMinimum)) {
                            try {
                                promptDataType = PromptUtility.getDataTypeForDateType(dateType);
                                o = promptDataType.coerceValue(o, locale);
                                minValue = (Date)o;
                                if (minValue != null && !minValue.equals(DateDefinition.minimumMinimum)) {
                                    promptValuesMinMax.setPromptValue((PromptDefinitionInterface)promptMinValue, minValue);
                                }
                            }
                            catch (IllegalArgumentException iae) {
                                LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(iae.getMessage(), (Throwable)iae);
                            }
                        }
                    }
                    if (!savedProperties.containsKey("max") || !((o = savedProperties.get("max")) instanceof Date)) break block27;
                    if (o instanceof DatePeriod) {
                        oDateType = ((DatePeriod)o).getPeriodType();
                        if (oDateType == dateType && (maxValue = (Date)o) != null && !maxValue.equals(DateDefinition.maximumMaximum)) {
                            promptValuesMinMax.setPromptValue((PromptDefinitionInterface)promptMaxValue, maxValue);
                        }
                        break block27;
                    }
                    if ((Date)o == null || ((Date)o).equals(DateDefinition.maximumMaximum)) break block27;
                    try {
                        promptDataType = PromptUtility.getDataTypeForDateType(dateType);
                        o = promptDataType.coerceValue(o, locale);
                        maxValue = (Date)o;
                        if (maxValue != null && !maxValue.equals(DateDefinition.maximumMaximum)) {
                            promptValuesMinMax.setPromptValue((PromptDefinitionInterface)promptMaxValue, maxValue);
                        }
                    }
                    catch (IllegalArgumentException iae) {
                        LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(iae.getMessage(), (Throwable)iae);
                    }
                }
                catch (InvalidPromptValueException ipve) {
                    LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
                }
            } else if (prompt != null) {
                try {
                    if (prompt instanceof DateDefinitionInterface) {
                        Date maxValue;
                        Date minValue = ((DateDefinitionInterface)prompt).getMinimum();
                        if (minValue != null && !minValue.equals(DateDefinition.minimumMinimum)) {
                            promptValuesMinMax.setPromptValue((PromptDefinitionInterface)promptMinValue, minValue);
                        }
                        if ((maxValue = ((DateDefinitionInterface)prompt).getMaximum()) != null && !maxValue.equals(DateDefinition.maximumMaximum)) {
                            promptValuesMinMax.setPromptValue((PromptDefinitionInterface)promptMaxValue, maxValue);
                        }
                    } else if (prompt instanceof DateRangeDefinitionInterface) {
                        Date maxValue;
                        Date minValue = ((DateRangeDefinitionInterface)prompt).getMinimum();
                        if (minValue != null && !minValue.equals(DateDefinition.minimumMinimum)) {
                            promptValuesMinMax.setPromptValue((PromptDefinitionInterface)promptMinValue, minValue);
                        }
                        if ((maxValue = ((DateRangeDefinitionInterface)prompt).getMaximum()) != null && !maxValue.equals(DateDefinition.maximumMaximum)) {
                            promptValuesMinMax.setPromptValue((PromptDefinitionInterface)promptMaxValue, maxValue);
                        }
                    }
                }
                catch (InvalidPromptValueException ipve) {
                    LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
                }
            }
        }
    }

    static void configurePromptValuesForMaximumDisplayValue(PromptValues promptValuesMaxDisplay, PromptDefinitionInterface prompt, IntegerDefinitionInterface promptMaxDisplay, PropertiesCommunicator communicator) {
        Map savedProperties = communicator.getPromptProperties();
        if (!savedProperties.isEmpty()) {
            try {
                int pageSize;
                PromptDefinitionInterface definition;
                if (savedProperties.containsKey("PromptDefinition") && (definition = (PromptDefinitionInterface)savedProperties.get("PromptDefinition")) instanceof MutableValueProviderDefinitionInterface && (pageSize = ((MutableValueProviderDefinitionInterface)definition).getPageSize()) != 100) {
                    promptValuesMaxDisplay.setPromptValue((PromptDefinitionInterface)promptMaxDisplay, (Object)new Integer(pageSize));
                }
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
            }
        } else if (prompt != null && prompt instanceof MutableValueProviderDefinitionInterface) {
            try {
                int pageSize = ((MutableValueProviderDefinitionInterface)prompt).getPageSize();
                if (pageSize != 100) {
                    promptValuesMaxDisplay.setPromptValue((PromptDefinitionInterface)promptMaxDisplay, (Object)new Integer(pageSize));
                }
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
            }
        }
    }

    static void configurePromptValuesForHint(PromptValues promptValuesHint, PromptDefinitionInterface prompt, TextDefinitionInterface promptHint, PropertiesCommunicator communicator, Locale locale) {
        Map savedProperties = communicator.getPromptProperties();
        if (!savedProperties.isEmpty()) {
            try {
                String hint;
                if (savedProperties.containsKey("Hint") && (hint = (String)savedProperties.get("Hint")) != null) {
                    promptValuesHint.setPromptValue((PromptDefinitionInterface)promptHint, hint);
                }
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
            }
        } else if (prompt != null) {
            try {
                promptValuesHint.setPromptValue((PromptDefinitionInterface)promptHint, ((TextDefinitionInterface)prompt).getHint(locale));
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
            }
        }
    }

    static void configurePromptValuesForMinMaxCount(PromptValues promptValuesValueCount, PromptDefinitionInterface prompt, IntegerDefinitionInterface promptMinValueCount, IntegerDefinitionInterface promptMaxValueCount, PropertiesCommunicator communicator) {
        Map savedProperties = communicator.getPromptProperties();
        if (!savedProperties.isEmpty()) {
            try {
                int maxValueCount;
                int minValueCount;
                if (savedProperties.containsKey("minValueCount") && (minValueCount = ((Integer)savedProperties.get("minValueCount")).intValue()) != -1) {
                    promptValuesValueCount.setPromptValue((PromptDefinitionInterface)promptMinValueCount, (Object)new Integer(minValueCount));
                }
                if (savedProperties.containsKey("maxValueCount") && (maxValueCount = ((Integer)savedProperties.get("maxValueCount")).intValue()) != Integer.MAX_VALUE && maxValueCount != 1) {
                    promptValuesValueCount.setPromptValue((PromptDefinitionInterface)promptMaxValueCount, (Object)new Integer(maxValueCount));
                }
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
            }
        } else if (prompt != null) {
            try {
                int maxValueCount;
                int minValueCount = ((SelectableDefinitionInterface)prompt).getMinimumValueCount();
                if (minValueCount != -1) {
                    promptValuesValueCount.setPromptValue((PromptDefinitionInterface)promptMinValueCount, (Object)new Integer(minValueCount));
                }
                if ((maxValueCount = ((SelectableDefinitionInterface)prompt).getMaximumValueCount()) != Integer.MAX_VALUE && maxValueCount != -1) {
                    promptValuesValueCount.setPromptValue((PromptDefinitionInterface)promptMaxValueCount, (Object)new Integer(maxValueCount));
                }
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
            }
        }
    }

    static void configurePromptValuesForMinMaxLength(PromptValues promptValuesMinMaxLength, PromptDefinitionInterface prompt, IntegerDefinitionInterface promptMinLength, IntegerDefinitionInterface promptMaxLength, PropertiesCommunicator communicator) {
        Map savedProperties = communicator.getPromptProperties();
        if (!savedProperties.isEmpty()) {
            try {
                int maxValue;
                int minValue;
                if (savedProperties.containsKey("minLength") && (minValue = ((Integer)savedProperties.get("minLength")).intValue()) != -1) {
                    promptValuesMinMaxLength.setPromptValue((PromptDefinitionInterface)promptMinLength, (Object)new Integer(minValue));
                }
                if (savedProperties.containsKey("maxLength") && (maxValue = ((Integer)savedProperties.get("maxLength")).intValue()) != -1) {
                    promptValuesMinMaxLength.setPromptValue((PromptDefinitionInterface)promptMaxLength, (Object)new Integer(maxValue));
                }
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
            }
        } else if (prompt != null) {
            try {
                if (prompt instanceof TextDefinitionInterface) {
                    int maxValue;
                    int minValue = ((TextDefinitionInterface)prompt).getMinimumLength();
                    if (minValue > 0) {
                        promptValuesMinMaxLength.setPromptValue((PromptDefinitionInterface)promptMinLength, (Object)new Integer(minValue));
                    }
                    if ((maxValue = ((TextDefinitionInterface)prompt).getMaximumLength()) != -1) {
                        promptValuesMinMaxLength.setPromptValue((PromptDefinitionInterface)promptMaxLength, (Object)new Integer(maxValue));
                    }
                } else if (prompt instanceof StringRangeDefinitionInterface) {
                    int maxValue;
                    int minValue = ((StringRangeDefinitionInterface)prompt).getMinimumLength();
                    if (minValue > 0) {
                        promptValuesMinMaxLength.setPromptValue((PromptDefinitionInterface)promptMinLength, (Object)new Integer(minValue));
                    }
                    if ((maxValue = ((StringRangeDefinitionInterface)prompt).getMaximumLength()) != -1) {
                        promptValuesMinMaxLength.setPromptValue((PromptDefinitionInterface)promptMaxLength, (Object)new Integer(maxValue));
                    }
                }
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
            }
        }
    }

    static void configurePromptValuesForMinMaxDecimalPlaces(PromptValues promptValuesDecimalPlaces, PromptDefinitionInterface prompt, IntegerDefinitionInterface promptMinDecimalPlaces, IntegerDefinitionInterface promptMaxDecimalPlaces, PropertiesCommunicator communicator) {
        Map savedProperties = communicator.getPromptProperties();
        if (!savedProperties.isEmpty()) {
            try {
                int maxValue;
                int minValue;
                if (savedProperties.containsKey("minDecimalPlaces") && (minValue = ((Integer)savedProperties.get("minDecimalPlaces")).intValue()) > 0) {
                    promptValuesDecimalPlaces.setPromptValue((PromptDefinitionInterface)promptMinDecimalPlaces, (Object)new Integer(minValue));
                }
                if (savedProperties.containsKey("maxDecimalPlaces") && (maxValue = ((Integer)savedProperties.get("maxDecimalPlaces")).intValue()) != -1) {
                    promptValuesDecimalPlaces.setPromptValue((PromptDefinitionInterface)promptMaxDecimalPlaces, (Object)new Integer(maxValue));
                }
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
            }
        } else if (prompt != null) {
            try {
                if (prompt instanceof DoubleDefinitionInterface) {
                    int maxValue;
                    int minValue = ((DoubleDefinitionInterface)prompt).getMinimumDecimalPlaces();
                    if (minValue != 0) {
                        promptValuesDecimalPlaces.setPromptValue((PromptDefinitionInterface)promptMinDecimalPlaces, (Object)new Integer(minValue));
                    }
                    if ((maxValue = ((DoubleDefinitionInterface)prompt).getMaximumDecimalPlaces()) != -1) {
                        promptValuesDecimalPlaces.setPromptValue((PromptDefinitionInterface)promptMaxDecimalPlaces, (Object)new Integer(maxValue));
                    }
                } else if (prompt instanceof DoubleRangeDefinitionInterface) {
                    int maxValue;
                    int minValue = ((DoubleRangeDefinitionInterface)prompt).getMinimumDecimalPlaces();
                    if (minValue != 0) {
                        promptValuesDecimalPlaces.setPromptValue((PromptDefinitionInterface)promptMinDecimalPlaces, (Object)new Integer(minValue));
                    }
                    if ((maxValue = ((DoubleRangeDefinitionInterface)prompt).getMaximumDecimalPlaces()) != -1) {
                        promptValuesDecimalPlaces.setPromptValue((PromptDefinitionInterface)promptMaxDecimalPlaces, (Object)new Integer(maxValue));
                    }
                }
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
            }
        }
    }

    static void configurePromptValuesForDoubleMinMaxValue(PromptValues promptValuesMinMax, PromptDefinitionInterface prompt, DoubleDefinitionInterface promptMinValue, DoubleDefinitionInterface promptMaxValue, PropertiesCommunicator communicator) {
        Map savedProperties = communicator.getPromptProperties();
        if (!savedProperties.isEmpty()) {
            try {
                Object o;
                if (savedProperties.containsKey("min")) {
                    int intMinValue;
                    o = savedProperties.get("min");
                    if (o instanceof Double) {
                        double minValue = (Double)savedProperties.get("min");
                        if (minValue != -1.7976931348623157E308) {
                            promptValuesMinMax.setPromptValue((PromptDefinitionInterface)promptMinValue, (Object)new Double(minValue));
                        }
                    } else if (o instanceof Integer && (intMinValue = ((Integer)o).intValue()) != Integer.MIN_VALUE) {
                        double minValue = ((Integer)o).doubleValue();
                        promptValuesMinMax.setPromptValue((PromptDefinitionInterface)promptMinValue, (Object)new Double(minValue));
                    }
                }
                if (savedProperties.containsKey("max")) {
                    int intMaxValue;
                    o = savedProperties.get("max");
                    if (o instanceof Double) {
                        double maxValue = (Double)savedProperties.get("max");
                        if (maxValue != Double.MAX_VALUE) {
                            promptValuesMinMax.setPromptValue((PromptDefinitionInterface)promptMaxValue, (Object)new Double(maxValue));
                        }
                    } else if (o instanceof Integer && (intMaxValue = ((Integer)o).intValue()) != Integer.MAX_VALUE) {
                        double maxValue = ((Integer)o).doubleValue();
                        promptValuesMinMax.setPromptValue((PromptDefinitionInterface)promptMaxValue, (Object)new Double(maxValue));
                    }
                }
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
            }
        } else if (prompt != null) {
            try {
                if (prompt instanceof DoubleDefinitionInterface) {
                    double maxValue;
                    double minValue = ((DoubleDefinitionInterface)prompt).getMinimum();
                    if (minValue != -1.7976931348623157E308) {
                        promptValuesMinMax.setPromptValue((PromptDefinitionInterface)promptMinValue, (Object)new Double(minValue));
                    }
                    if ((maxValue = ((DoubleDefinitionInterface)prompt).getMaximum()) != Double.MAX_VALUE) {
                        promptValuesMinMax.setPromptValue((PromptDefinitionInterface)promptMaxValue, (Object)new Double(maxValue));
                    }
                } else if (prompt instanceof DoubleRangeDefinitionInterface) {
                    double maxValue;
                    double minValue = ((DoubleRangeDefinitionInterface)prompt).getMinimum();
                    if (minValue != -1.7976931348623157E308) {
                        promptValuesMinMax.setPromptValue((PromptDefinitionInterface)promptMinValue, (Object)new Double(minValue));
                    }
                    if ((maxValue = ((DoubleRangeDefinitionInterface)prompt).getMaximum()) != Double.MAX_VALUE) {
                        promptValuesMinMax.setPromptValue((PromptDefinitionInterface)promptMaxValue, (Object)new Double(maxValue));
                    }
                }
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
            }
        }
    }

    static void configurePromptValuesForIntegerMinMaxValue(PromptValues promptValuesMinMax, PromptDefinitionInterface prompt, IntegerDefinitionInterface promptMinValue, IntegerDefinitionInterface promptMaxValue, PropertiesCommunicator communicator, Locale locale) {
        block25: {
            Map savedProperties = communicator.getPromptProperties();
            if (!savedProperties.isEmpty()) {
                try {
                    double doubleMaxValue;
                    Object coercedValue;
                    IntegerType integerType;
                    Object o;
                    if (savedProperties.containsKey("min")) {
                        double doubleMinValue;
                        o = savedProperties.get("min");
                        if (o instanceof Integer) {
                            int minValue = (Integer)o;
                            if (minValue != Integer.MIN_VALUE) {
                                promptValuesMinMax.setPromptValue((PromptDefinitionInterface)promptMinValue, (Object)new Integer(minValue));
                            }
                        } else if (o instanceof Double && (doubleMinValue = ((Double)o).doubleValue()) != -1.7976931348623157E308) {
                            try {
                                integerType = new IntegerType();
                                coercedValue = integerType.coerceValue(o, locale);
                                promptValuesMinMax.setPromptValue((PromptDefinitionInterface)promptMinValue, coercedValue);
                            }
                            catch (IllegalArgumentException e) {
                                LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(e.getMessage());
                            }
                        }
                    }
                    if (!savedProperties.containsKey("max")) break block25;
                    o = savedProperties.get("max");
                    if (o instanceof Integer) {
                        int maxValue = (Integer)savedProperties.get("max");
                        if (maxValue != Integer.MAX_VALUE) {
                            promptValuesMinMax.setPromptValue((PromptDefinitionInterface)promptMaxValue, (Object)new Integer(maxValue));
                        }
                        break block25;
                    }
                    if (!(o instanceof Double) || (doubleMaxValue = ((Double)o).doubleValue()) == Double.MAX_VALUE) break block25;
                    try {
                        integerType = new IntegerType();
                        coercedValue = integerType.coerceValue(o, locale);
                        promptValuesMinMax.setPromptValue((PromptDefinitionInterface)promptMaxValue, coercedValue);
                    }
                    catch (IllegalArgumentException e) {
                        LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(e.getMessage());
                    }
                }
                catch (InvalidPromptValueException ipve) {
                    LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(ipve.getMessage());
                }
            } else if (prompt != null) {
                try {
                    if (prompt instanceof IntegerDefinitionInterface) {
                        int maxValue;
                        int minValue = ((IntegerDefinitionInterface)prompt).getMinimum();
                        if (minValue != Integer.MIN_VALUE) {
                            promptValuesMinMax.setPromptValue((PromptDefinitionInterface)promptMinValue, (Object)new Integer(minValue));
                        }
                        if ((maxValue = ((IntegerDefinitionInterface)prompt).getMaximum()) != Integer.MAX_VALUE) {
                            promptValuesMinMax.setPromptValue((PromptDefinitionInterface)promptMaxValue, (Object)new Integer(maxValue));
                        }
                    } else if (prompt instanceof IntegerRangeDefinitionInterface) {
                        int maxValue;
                        int minValue = ((IntegerRangeDefinitionInterface)prompt).getMinimum();
                        if (minValue != Integer.MIN_VALUE) {
                            promptValuesMinMax.setPromptValue((PromptDefinitionInterface)promptMinValue, (Object)new Integer(minValue));
                        }
                        if ((maxValue = ((IntegerRangeDefinitionInterface)prompt).getMaximum()) != Integer.MAX_VALUE) {
                            promptValuesMinMax.setPromptValue((PromptDefinitionInterface)promptMaxValue, (Object)new Integer(maxValue));
                        }
                    }
                }
                catch (InvalidPromptValueException ipve) {
                    LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(ipve.getMessage());
                }
            }
        }
    }

    static void configureCustomValuesCheckBox(PromptDefinitionInterface prompt, JCheckBox allowCustomValuesCheckBox, PropertiesCommunicator communicator) {
        boolean validSetting = false;
        Map savedProperties = communicator.getPromptProperties();
        if (!savedProperties.isEmpty() && savedProperties.containsKey("allowUserValues")) {
            boolean allowUserValues = (Boolean)savedProperties.get("allowUserValues");
            allowCustomValuesCheckBox.setSelected(allowUserValues);
            validSetting = true;
        }
        if (!validSetting && prompt != null) {
            allowCustomValuesCheckBox.setSelected(((ValueProviderDefinitionInterface)prompt).isAllowUserValues());
        }
    }

    static void configureRequiredState(PromptValues promptValuesValueCount, IntegerDefinitionInterface promptMinValueCount, PropertiesCommunicator communicator) {
        boolean requiredState = communicator.isRequired();
        if (requiredState) {
            try {
                Map savedProperties = communicator.getPromptProperties();
                if (!savedProperties.isEmpty() && savedProperties.containsKey("minValueCount")) {
                    int minValueCount = (Integer)savedProperties.get("minValueCount");
                    if (minValueCount != -1) {
                        promptValuesValueCount.setPromptValue((PromptDefinitionInterface)promptMinValueCount, (Object)new Integer(minValueCount));
                    } else {
                        promptValuesValueCount.setPromptValue((PromptDefinitionInterface)promptMinValueCount, (Object)new Integer(1));
                    }
                } else {
                    promptValuesValueCount.setPromptValue((PromptDefinitionInterface)promptMinValueCount, (Object)new Integer(1));
                }
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(ipve.getMessage());
            }
        }
    }

    static void configureTextDefaultValueNoValueProvider(PromptValues promptValues, TextDefinitionInterface promptText, PropertiesCommunicator communicator) {
        block6: {
            ValueProviderInterface valueProvider;
            Map savedProperties = communicator.getPromptProperties();
            if (!savedProperties.isEmpty() && (valueProvider = (ValueProviderInterface)savedProperties.get("ValueProvider")) == null) {
                Object defaultSaved = savedProperties.get("DefaultValue");
                try {
                    if (defaultSaved instanceof List) {
                        for (Object o : (List)defaultSaved) {
                            if (!(o instanceof String) && !(o instanceof SpecialValues)) continue;
                            promptValues.setPromptValue((PromptDefinitionInterface)promptText, o);
                            break block6;
                        }
                        break block6;
                    }
                    if (defaultSaved instanceof String) {
                        promptValues.setPromptValue((PromptDefinitionInterface)promptText, defaultSaved);
                    }
                }
                catch (InvalidPromptValueException ipve) {
                    LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(ipve.getMessage());
                }
            }
        }
    }

    static void configureDefaultValueFromSelectablePrompt(SelectableDefinitionInterface selectablePrompt, MutablePromptDefinitionInterface prompt) {
        if (selectablePrompt instanceof MutableSupportedSpecialValuesInterface) {
            ((MutableSupportedSpecialValuesInterface)prompt).setSupportedSpecialValues(((MutableSupportedSpecialValuesInterface)selectablePrompt).getSupportedSpecialValues());
        }
        if (selectablePrompt != null) {
            if (selectablePrompt.isDefaultValueSet()) {
                prompt.setDefaultValue(selectablePrompt.getDefaultValue());
            } else {
                prompt.clearDefaultValue();
            }
        }
    }

    static void configureIntegerDefaultValueNoValueProvider(PromptValues promptValuesDefaultValue, IntegerDefinitionInterface promptDefaultValue, PropertiesCommunicator communicator, Locale locale) {
        block9: {
            ValueProviderInterface valueProvider;
            Map savedProperties = communicator.getPromptProperties();
            if (!savedProperties.isEmpty() && (valueProvider = (ValueProviderInterface)savedProperties.get("ValueProvider")) == null) {
                Object defaultSaved = savedProperties.get("DefaultValue");
                try {
                    IntegerType integerType = new IntegerType();
                    if (defaultSaved instanceof List) {
                        for (Object o : (List)defaultSaved) {
                            try {
                                Object coercedValue = integerType.coerceValue(o, locale);
                                promptValuesDefaultValue.setPromptValue((PromptDefinitionInterface)promptDefaultValue, coercedValue);
                                break block9;
                            }
                            catch (IllegalArgumentException e) {
                                LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(e.getMessage());
                            }
                        }
                        break block9;
                    }
                    try {
                        Object coercedValue = integerType.coerceValue(defaultSaved, locale);
                        promptValuesDefaultValue.setPromptValue((PromptDefinitionInterface)promptDefaultValue, coercedValue);
                    }
                    catch (IllegalArgumentException e) {
                        LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(e.getMessage());
                    }
                }
                catch (InvalidPromptValueException ipve) {
                    LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(ipve.getMessage());
                }
            }
        }
    }

    static void configureIntegerRangeDefaultValueNoValueProvider(PromptValues promptValuesDefaultValue, IntegerRangeDefinitionInterface promptDefaultValues, PropertiesCommunicator communicator, Locale locale) {
        Object defaultSaved;
        Map savedProperties = communicator.getPromptProperties();
        if (!savedProperties.isEmpty() && savedProperties.containsKey("NumberRangeType") && (defaultSaved = savedProperties.get("DefaultValue")) != null) {
            boolean isValidRange = true;
            ArrayList<Object> defaultValues = new ArrayList<Object>();
            IntegerType integerType = new IntegerType();
            try {
                int arrayLength = ((Object[])defaultSaved).length;
                for (int i = 0; i < arrayLength; ++i) {
                    Object o = ((Object[])defaultSaved)[i];
                    try {
                        Object coercedValue = integerType.coerceValue(o, locale);
                        defaultValues.add(coercedValue);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        isValidRange = false;
                    }
                }
                if (isValidRange) {
                    promptValuesDefaultValue.setPromptValue((PromptDefinitionInterface)promptDefaultValues, (Object)defaultValues.toArray());
                }
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(ipve.getMessage());
            }
        }
    }

    static void configureDoubleDefaultValueNoValueProvider(PromptValues promptValuesDefaultValue, DoubleDefinitionInterface promptDefaultValue, PropertiesCommunicator communicator, Locale locale) {
        block9: {
            ValueProviderInterface valueProvider;
            Map savedProperties = communicator.getPromptProperties();
            if (!savedProperties.isEmpty() && (valueProvider = (ValueProviderInterface)savedProperties.get("ValueProvider")) == null) {
                Object defaultSaved = savedProperties.get("DefaultValue");
                try {
                    DoubleType doubleType = new DoubleType();
                    if (defaultSaved instanceof List) {
                        for (Object o : (List)defaultSaved) {
                            try {
                                Object coercedValue = doubleType.coerceValue(o, locale);
                                promptValuesDefaultValue.setPromptValue((PromptDefinitionInterface)promptDefaultValue, coercedValue);
                                break block9;
                            }
                            catch (IllegalArgumentException e) {
                                LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(e.getMessage());
                            }
                        }
                        break block9;
                    }
                    try {
                        Object coercedValue = doubleType.coerceValue(defaultSaved, locale);
                        promptValuesDefaultValue.setPromptValue((PromptDefinitionInterface)promptDefaultValue, coercedValue);
                    }
                    catch (IllegalArgumentException e) {
                        LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(e.getMessage());
                    }
                }
                catch (InvalidPromptValueException ipve) {
                    LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(ipve.getMessage());
                }
            }
        }
    }

    static void configureDoubleRangeDefaultValueNoValueProvider(PromptValues promptValuesDefaultValue, DoubleRangeDefinitionInterface promptDefaultValues, PropertiesCommunicator communicator, Locale locale) {
        Object defaultSaved;
        Map savedProperties = communicator.getPromptProperties();
        if (!savedProperties.isEmpty() && savedProperties.containsKey("NumberRangeType") && (defaultSaved = savedProperties.get("DefaultValue")) != null) {
            boolean isValidRange = true;
            ArrayList<Object> defaultValues = new ArrayList<Object>();
            DoubleType doubleType = new DoubleType();
            try {
                int arrayLength = ((Object[])defaultSaved).length;
                for (int i = 0; i < arrayLength; ++i) {
                    Object o = ((Object[])defaultSaved)[i];
                    try {
                        Object coercedValue = doubleType.coerceValue(o, locale);
                        defaultValues.add(coercedValue);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        isValidRange = false;
                    }
                }
                if (isValidRange) {
                    promptValuesDefaultValue.setPromptValue((PromptDefinitionInterface)promptDefaultValues, (Object)defaultValues.toArray());
                }
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(ipve.getMessage());
            }
        }
    }

    static void configureDateDefaultValueNoValueProvider(PromptValues promptValuesDefaultValue, DateDefinitionInterface promptDefaultValue, DateTypes dateType, PropertiesCommunicator communicator, Locale locale) {
        block18: {
            ValueProviderInterface valueProvider;
            Map savedProperties = communicator.getPromptProperties();
            if (!savedProperties.isEmpty() && (valueProvider = (ValueProviderInterface)savedProperties.get("ValueProvider")) == null) {
                Object defaultSaved = savedProperties.get("DefaultValue");
                try {
                    DataTypeInterface dataType = PromptUtility.getDataTypeForDateType(dateType);
                    if (defaultSaved instanceof List) {
                        for (Object o : (List)defaultSaved) {
                            if (o instanceof DatePeriod) {
                                DateTypes defaultSavedDateType = ((DatePeriod)o).getPeriodType();
                                if (defaultSavedDateType != dateType) continue;
                                try {
                                    Object coercedValue = dataType.coerceValue(o, locale);
                                    promptValuesDefaultValue.setPromptValue((PromptDefinitionInterface)promptDefaultValue, coercedValue);
                                }
                                catch (IllegalArgumentException e) {
                                    LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(e.getMessage());
                                }
                                continue;
                            }
                            if (o == null) continue;
                            try {
                                Object coercedValue = dataType.coerceValue(o, locale);
                                promptValuesDefaultValue.setPromptValue((PromptDefinitionInterface)promptDefaultValue, coercedValue);
                                break block18;
                            }
                            catch (IllegalArgumentException e) {
                                LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(e.getMessage());
                            }
                        }
                        break block18;
                    }
                    if (defaultSaved instanceof DatePeriod) {
                        DateTypes defaultSavedDateType = ((DatePeriod)defaultSaved).getPeriodType();
                        if (defaultSavedDateType == dateType) {
                            try {
                                Object coercedValue = dataType.coerceValue(defaultSaved, locale);
                                promptValuesDefaultValue.setPromptValue((PromptDefinitionInterface)promptDefaultValue, coercedValue);
                            }
                            catch (IllegalArgumentException e) {
                                LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(e.getMessage());
                            }
                        }
                    } else if (defaultSaved != null) {
                        try {
                            Object coercedValue = dataType.coerceValue(defaultSaved, locale);
                            promptValuesDefaultValue.setPromptValue((PromptDefinitionInterface)promptDefaultValue, coercedValue);
                        }
                        catch (IllegalArgumentException e) {
                            LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).debug(e.getMessage());
                        }
                    }
                }
                catch (InvalidPromptValueException ipve) {
                    LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).debug(ipve.getMessage());
                }
            }
        }
    }

    static void configureDateRangeDefaultValueNoValueProvider(PromptValues promptValuesDefaultValue, DateRangeDefinitionInterface promptDefaultValues, PropertiesCommunicator communicator, Locale locale, DateTypes dateType) {
        Object defaultSaved;
        Map savedProperties = communicator.getPromptProperties();
        if (!savedProperties.isEmpty() && savedProperties.containsKey("DateRangeType") && (defaultSaved = savedProperties.get("DefaultValue")) != null) {
            boolean isValidRange = false;
            ArrayList<Object> defaultValues = new ArrayList<Object>();
            if (defaultSaved instanceof Object[]) {
                try {
                    int arrayLength = ((Object[])defaultSaved).length;
                    for (int i = 0; i < arrayLength; ++i) {
                        DataTypeInterface dataType = PromptUtility.getDataTypeForDateType(dateType);
                        Object o = ((Object[])defaultSaved)[i];
                        if (o instanceof DatePeriod) {
                            DateTypes oSavedDateType = ((DatePeriod)o).getPeriodType();
                            if (oSavedDateType != dateType) continue;
                            try {
                                Object coercedValue = dataType.coerceValue(o, locale);
                                defaultValues.add(coercedValue);
                                isValidRange = true;
                            }
                            catch (IllegalArgumentException e) {
                                LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).error(e.getMessage());
                            }
                            isValidRange = false;
                            break;
                        }
                        try {
                            Object coercedValue = dataType.coerceValue(o, locale);
                            defaultValues.add(coercedValue);
                            isValidRange = true;
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).debug(e.getMessage());
                            isValidRange = false;
                            break;
                        }
                    }
                    if (isValidRange) {
                        promptValuesDefaultValue.setPromptValue((PromptDefinitionInterface)promptDefaultValues, (Object)defaultValues.toArray());
                    }
                }
                catch (InvalidPromptValueException ipve) {
                    LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)communicator.getLoggerFactory()).debug(ipve.getMessage());
                }
            }
        }
    }

    static void copyPropertiesToCommunicator(PropertiesCommunicator communicator, PromptDefinitionInterface prompt) {
        MacroVariableListOptionInterface x;
        Map map = communicator.getPromptProperties();
        if (prompt.isDefaultValueSet()) {
            map.put("DefaultValue", prompt.getDefaultValue());
        } else {
            map.remove("DefaultValue");
        }
        map.put("fixed", prompt.isFixed());
        map.put("hidden", prompt.isHidden());
        if (prompt instanceof MutableRequiredDefinitionInterface) {
            map.put("required", prompt.isRequired());
        }
        map.put("stickyDefault", prompt.isStickyDefaultAllowed());
        map.put("Description", prompt.getPromptDescription(Locale.getDefault()));
        map.put("Label", prompt.getPromptLabel(Locale.getDefault()));
        map.put("name", prompt.getPromptName());
        map.put("macroVarOutputLevel", new Integer(prompt.getMacroVariableOutputLevel()));
        if (prompt instanceof MacroVariableListOptionInterface) {
            x = (MacroVariableListOptionInterface)prompt;
            map.put("macroVarListFormat", new Integer(x.getMacroVariableListFormat()));
            map.put("macroVarListQuote", x.getMacroVariableQuote());
            map.put("macroVarListDelimiter", x.getMacroVariableListDelimiter());
        }
        if (prompt instanceof TextDefinitionInterface) {
            x = (TextDefinitionInterface)prompt;
            map.put("minLength", new Integer(x.getMinimumLength()));
            map.put("maxLength", new Integer(x.getMaximumLength()));
            map.put("allowMultipleLines", x.isAllowMultipleLines());
            map.put("maxLines", new Integer(x.getMaximumLines()));
            map.put("displayedLines", new Integer(x.getDisplayedLines()));
            map.put("masked", x.isMasked());
            map.put("Hint", x.getHint(Locale.getDefault()));
            PromptUtility.handleSelectableDefinition(map, (SelectableDefinitionInterface)x);
            PromptUtility.handleValueProvider(map, (ValueProviderDefinitionInterface)x);
        } else if (prompt instanceof DoubleDefinitionInterface) {
            x = (DoubleDefinitionInterface)prompt;
            map.put("max", new Double(x.getMaximum()));
            map.put("min", new Double(x.getMinimum()));
            map.put("minDecimalPlaces", new Integer(x.getMinimumDecimalPlaces()));
            map.put("maxDecimalPlaces", new Integer(x.getMaximumDecimalPlaces()));
            map.put("INTEGER_CHECKBOX_STATE", Boolean.FALSE);
            PromptUtility.handleSelectableDefinition(map, (SelectableDefinitionInterface)x);
            PromptUtility.handleValueProvider(map, (ValueProviderDefinitionInterface)x);
        } else if (prompt instanceof DoubleRangeDefinitionInterface) {
            x = (DoubleRangeDefinitionInterface)prompt;
            map.put("max", new Double(x.getMaximum()));
            map.put("min", new Double(x.getMinimum()));
            map.put("INTEGER_CHECKBOX_STATE", Boolean.FALSE);
            map.put("NumberRangeType", Boolean.TRUE);
        } else if (prompt instanceof IntegerDefinitionInterface) {
            x = (IntegerDefinitionInterface)prompt;
            map.put("max", new Integer(x.getMaximum()));
            map.put("min", new Integer(x.getMinimum()));
            map.put("INTEGER_CHECKBOX_STATE", Boolean.TRUE);
            PromptUtility.handleSelectableDefinition(map, (SelectableDefinitionInterface)x);
            PromptUtility.handleValueProvider(map, (ValueProviderDefinitionInterface)x);
        } else if (prompt instanceof IntegerRangeDefinitionInterface) {
            x = (IntegerRangeDefinitionInterface)prompt;
            map.put("max", new Integer(x.getMaximum()));
            map.put("min", new Integer(x.getMinimum()));
            map.put("INTEGER_CHECKBOX_STATE", Boolean.TRUE);
            map.put("NumberRangeType", Boolean.TRUE);
        } else if (prompt instanceof DateDefinitionInterface) {
            x = (DateDefinitionInterface)prompt;
            map.put("max", x.getMaximum());
            map.put("min", x.getMinimum());
            map.put("dateType", x.getDateType());
            PromptUtility.handleSelectableDefinition(map, (SelectableDefinitionInterface)x);
            PromptUtility.handleValueProvider(map, (ValueProviderDefinitionInterface)x);
        } else if (prompt instanceof DateRangeDefinitionInterface) {
            x = (DateRangeDefinitionInterface)prompt;
            map.put("max", x.getMaximum());
            map.put("min", x.getMinimum());
            map.put("dateType", x.getDateType());
            map.put("DateRangeType", Boolean.TRUE);
        } else if (prompt instanceof StringRangeDefinitionInterface) {
            x = (StringRangeDefinitionInterface)prompt;
            map.put("minLength", new Integer(x.getMinimumLength()));
            map.put("maxLength", new Integer(x.getMaximumLength()));
            map.put("max", x.getMaximum());
            map.put("min", x.getMinimum());
        } else if (prompt instanceof DataSourceDefinitionInterface) {
            x = (DataSourceDefinitionInterface)prompt;
            map.put("allowedDataSources", new Long(x.getAllowedDataSourceTypes()));
        } else if (prompt instanceof DataSourceColumnDefinitionInterface) {
            x = (DataSourceColumnDefinitionInterface)prompt;
            map.put("allowedDataSources", new Long(x.getAllowedDataSourceTypes()));
            map.put("allowedColumnTypes", new Long(x.getAllowedColumnTypes()));
            map.put("DataSources", x.getDataSources());
            map.put("allowMultipleDataSources", x.isAllowMultipleDataSources());
            PromptUtility.handleSelectableDefinition(map, (SelectableDefinitionInterface)x);
        } else if (prompt instanceof OLAPMemberNameDefinitionInterface) {
            x = (OLAPMemberNameDefinitionInterface)prompt;
            map.put("dataItemId", x.getDataItem());
            map.put("DATA_SOURCE", x.getDataSource());
            PromptUtility.handleSelectableDefinition(map, (SelectableDefinitionInterface)x);
            PromptUtility.handleValueProvider(map, (ValueProviderDefinitionInterface)x);
        } else if (prompt instanceof FileSelectionInterface) {
            x = (FileSelectionInterface)prompt;
            map.put("logicalServerName", x.getLogicalServerName());
            map.put("FileTypes", x.getFileTypes());
            map.put("fileSelectionMode", new Integer(x.getFileSelectionMode()));
        }
    }

    private static void handleSelectableDefinition(Map map, SelectableDefinitionInterface x) {
        map.put("maxValueCount", new Integer(x.getMaximumValueCount()));
        map.put("minValueCount", new Integer(x.getMinimumValueCount()));
        map.put("selectionOrdered", x.isSelectionOrdered());
        if (x instanceof SupportedSpecialValuesInterface) {
            map.put("SupportedSpecialValues", ((SupportedSpecialValuesInterface)x).getSupportedSpecialValues());
        }
    }

    private static void handleValueProvider(Map map, ValueProviderDefinitionInterface x) {
        map.put("allowUserValues", x.isAllowUserValues());
        map.put("ValueProvider", x.getValueProvider());
    }

    static void configureDateCellEditor(DataTypeInterface dataType, AbstractItemListManagerPanel manager, DateTypes type, boolean showSelectionWhenFocusAndEditable) {
        DefaultTableCellRenderer dateRenderer = new DefaultTableCellRenderer();
        dateRenderer.setTransform((TransformInterface)new DataTypeToDisplayStringTransform(dataType, Locale.getDefault()));
        dateRenderer.setShowSelectionWhenFocusAndEditable(showSelectionWhenFocusAndEditable);
        manager.setCellRenderer(-1, 1, (TableCellRenderer)dateRenderer);
        DateEditor cellEditor = new DateEditor(type, true, TimeZone.getTimeZone("GMT"), Locale.getDefault());
        manager.setCellEditor(-1, 1, (TableCellEditor)cellEditor);
    }

    static DateEditor configureDateCellEditorForMultipleValues(DataTypeInterface dataType, AbstractItemListManagerPanel manager, DateTypes type, boolean showSelectionWhenFocusAndEditable) {
        DefaultTableCellRenderer dateRenderer = new DefaultTableCellRenderer();
        dateRenderer.setTransform((TransformInterface)new DataTypeToDisplayStringTransform(dataType, Locale.getDefault()));
        dateRenderer.setShowSelectionWhenFocusAndEditable(showSelectionWhenFocusAndEditable);
        manager.setCellRenderer(-1, 1, (TableCellRenderer)dateRenderer);
        MultipleValuesDateEditor cellEditor = new MultipleValuesDateEditor(type, true, TimeZone.getTimeZone("GMT"), Locale.getDefault());
        manager.setCellEditor(-1, 1, (TableCellEditor)((Object)cellEditor));
        return cellEditor;
    }

    static DataTypeInterface getDataTypeForDateType(DateTypes dateType) {
        if (dateType.equals(DateTypes.DATE)) {
            return DateType.DEFAULT_INSTANCE;
        }
        if (dateType.equals(DateTypes.WEEK)) {
            return WeekType.DEFAULT_INSTANCE;
        }
        if (dateType.equals(DateTypes.MONTH)) {
            return MonthType.DEFAULT_INSTANCE;
        }
        if (dateType.equals(DateTypes.QUARTER)) {
            return QuarterType.DEFAULT_INSTANCE;
        }
        if (dateType.equals(DateTypes.YEAR)) {
            return YearType.DEFAULT_INSTANCE;
        }
        if (dateType.equals(DateTypes.TIME)) {
            return TimeType.DEFAULT_INSTANCE;
        }
        if (dateType.equals(DateTypes.TIMESTAMP)) {
            return TimeStampType.DEFAULT_INSTANCE;
        }
        return DateType.DEFAULT_INSTANCE;
    }

    static WhereClause getWhereClauseForExpressionList(List expressions, PropertiesCommunicator communicator) {
        WhereClause whereClause = null;
        int expressionCount = expressions.size();
        if (expressionCount == 1) {
            whereClause = new WhereClause();
            whereClause.setCondition((OperandInterface)((Expression)expressions.get(0)));
        } else if (expressionCount > 1) {
            whereClause = new WhereClause();
            whereClause.setCondition((OperandInterface)Expression.newAndedExpression((List)expressions, (LoggerFactoryInterface)communicator.getLoggerFactory()));
        }
        return whereClause;
    }

    static void validatePrompt(JPanel panel, ValidatePromptInterface promptValidator, PromptDefinitionInterface prompt, boolean suppressErrors, Locale locale) {
        if (promptValidator != null) {
            Collection errorsName;
            if (panel instanceof GeneralPromptPropertiesPanel) {
                Collection errorsPName;
                if (promptValidator instanceof SingleValidatePromptInterface && (errorsPName = promptValidator.validatePrompt(prompt, locale)) != null && errorsPName.size() > 0) {
                    String errorMessage = PromptUtil.formatErrorMessages((Collection)errorsPName);
                    if (((GeneralPromptPropertiesPanel)panel).getGenericErrorHandler() != null) {
                        ((GeneralPromptPropertiesPanel)panel).getGenericErrorHandler().handleError((Object)panel, new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
                    }
                    ((GeneralPromptPropertiesPanel)panel).setContentsValid(false);
                }
            } else if (panel instanceof BaseCustomListPanel && !suppressErrors && !(promptValidator instanceof SingleValidatePromptInterface) && (errorsName = promptValidator.validatePrompt(prompt, locale)) != null && errorsName.size() > 0) {
                String errorMessage = PromptUtil.formatErrorMessages((Collection)errorsName);
                if (((BaseCustomListPanel)panel).getGenericErrorHandler() != null) {
                    ((BaseCustomListPanel)panel).getGenericErrorHandler().handleError((Object)panel, new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
                }
                ((BaseCustomListPanel)panel).setContentsValid(false);
            }
        }
    }

    static final PersistenceInterface newPrompt(String type, LoggerFactoryInterface loggerFactory) {
        PromptObjectFactory factory = PromptObjectFactory.getInstance();
        PersistenceInterface prompt = null;
        try {
            prompt = factory.newObject(type);
            if (prompt instanceof ComponentLogFactoryInterface) {
                ((ComponentLogFactoryInterface)prompt).setLoggerFactory(loggerFactory);
            }
        }
        catch (ClassNotFoundException e) {
            LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)loggerFactory).error(e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)loggerFactory).error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LoggerRepository2.getLogger((String)PromptUtility.class.getName(), (LoggerFactoryInterface)loggerFactory).error(e.getMessage(), (Throwable)e);
        }
        return prompt;
    }

    public static final PromptDefinitionInterface newConfiguredPrompt(PropertiesCommunicator communicator, String type) {
        PromptDefinitionInterface prompt = null;
        PersistenceInterface retVal = PromptUtility.newPrompt(type, communicator.getLoggerFactory());
        if (retVal instanceof PromptDefinitionInterface && null != (prompt = (PromptDefinitionInterface)retVal) && null != communicator.getGeneralPanel()) {
            communicator.getGeneralPanel().setGeneralPropertiesOnPromptObject((MutablePromptDefinitionInterface)prompt);
            if (prompt instanceof ComponentLogFactoryInterface) {
                ((ComponentLogFactoryInterface)prompt).setLoggerFactory(communicator.getLoggerFactory());
            }
        }
        return prompt;
    }

    public static List getReferencedDataSources(PromptGroupInterface group, long type) {
        ArrayList<Object> sources = new ArrayList<Object>();
        if (group != null) {
            List defs = group.getPromptDefinitions(true);
            for (PromptDefinitionInterface def : defs) {
                ValueProviderInterface vp;
                if (def instanceof ValueProviderDefinitionInterface && (vp = ((ValueProviderDefinitionInterface)def).getValueProvider()) != null) {
                    BaseDataSource ds;
                    String path;
                    if (vp instanceof DataItemValueProvider) {
                        boolean olap;
                        BaseDataSource ds2;
                        String path2;
                        DataItem dataItem = ((DataItemValueProvider)vp).getDataItem();
                        if (dataItem != null && (path2 = DataProvider.getPathUrl((DataItem)((DataItemValueProvider)vp).getDataItem())) != null && DataSourceUtil.isDataSourceTypeAllowed((ds2 = new BaseDataSource((olap = ((DataItemValueProvider)vp).getDataItem().getStructure().isOLAP()) ? 8L : 4L, path2)).getDataSourceType(), type) && !sources.contains(ds2)) {
                            sources.add(ds2);
                        }
                    } else if (vp instanceof PromptColumnValueProvider && (path = ((PromptColumnValueProvider)vp).getTableUrl()) != null && DataSourceUtil.isDataSourceTypeAllowed((ds = new BaseDataSource(1L, path)).getDataSourceType(), type) && !sources.contains(ds)) {
                        sources.add(ds);
                    }
                }
                if (def instanceof DataSourceDefinitionInterface) {
                    DataSourceInterface ds;
                    if (!((DataSourceDefinitionInterface)def).isDefaultValueSet() || (ds = (DataSourceInterface)((DataSourceDefinitionInterface)def).getDefaultValue()) == null || !DataSourceUtil.isDataSourceTypeAllowed(ds.getDataSourceType(), type) || sources.contains(ds)) continue;
                    sources.add(ds);
                    continue;
                }
                if (!(def instanceof DataSourceColumnDefinitionInterface)) continue;
                DataSourceColumnDefinitionInterface dsc = (DataSourceColumnDefinitionInterface)def;
                List potentialDS = dsc.getDataSources();
                if (potentialDS != null) {
                    for (DataSourceInterface ds : potentialDS) {
                        if (ds == null || !DataSourceUtil.isDataSourceTypeAllowed(ds.getDataSourceType(), type) || sources.contains(ds)) continue;
                        sources.add(ds);
                    }
                }
                if (!dsc.isDefaultValueSet()) continue;
                Object defaultValue = dsc.getDefaultValue();
                if (defaultValue instanceof DataSourceColumnInterface) {
                    DataSourceInterface ds = ((DataSourceColumnInterface)defaultValue).getDataSource();
                    if (ds == null || !DataSourceUtil.isDataSourceTypeAllowed(ds.getDataSourceType(), type) || sources.contains(ds)) continue;
                    sources.add(ds);
                    continue;
                }
                if (!(defaultValue instanceof Collection)) continue;
                for (DataSourceColumnInterface c : (Collection)defaultValue) {
                    DataSourceInterface ds = c.getDataSource();
                    if (ds == null || !DataSourceUtil.isDataSourceTypeAllowed(ds.getDataSourceType(), type) || sources.contains(ds)) continue;
                    sources.add(ds);
                }
            }
        }
        return sources;
    }

    /*
     * Unable to fully structure code
     */
    static List getReferencedDataSources(PromptGroupInterface group, long type, UserContextInterface userContext, PromptDataProviderInterface dataProvider) {
        sources = new ArrayList<Object>();
        if (userContext == null) {
            return sources;
        }
        if (group != null) {
            defs = group.getPromptDefinitions(true);
            for (PromptDefinitionInterface def : defs) {
                if (def instanceof ValueProviderDefinitionInterface && (vp = ((ValueProviderDefinitionInterface)def).getValueProvider()) != null) {
                    if (vp instanceof DataItemValueProvider) {
                        dataItem = ((DataItemValueProvider)vp).getDataItem();
                        if (dataItem == null || (path = DataProvider.getPathUrl((DataItem)((DataItemValueProvider)vp).getDataItem())) == null || !DataSourceUtil.isDataSourceTypeAllowed((ds = new BaseDataSource((olap = ((DataItemValueProvider)vp).getDataItem().getStructure().isOLAP()) != false ? 8L : 4L, path)).getDataSourceType(), type) || sources.contains(ds)) ** GOTO lbl40
                        sources.add(ds);
                    } else if (vp instanceof PromptColumnValueProvider && (path = ((PromptColumnValueProvider)vp).getTableUrl()) != null && DataSourceUtil.isDataSourceTypeAllowed((ds = new BaseDataSource(1L, path)).getDataSourceType(), type) && !sources.contains(ds)) {
                        if (dataProvider != null) {
                            try {
                                tableURL = dataProvider.getPhysicalTable(path);
                                if (tableURL != null) {
                                    sources.add(ds);
                                }
                            }
                            catch (ServerConnectionException e) {
                                e.printStackTrace();
                            }
                        } else {
                            try {
                                if (DataSourceUtil.getDataSource(userContext, ds.getDataSourceLocation()) != null) {
                                    sources.add(ds);
                                }
                            }
                            catch (ServiceException e) {
                            }
                            catch (RemoteException e) {
                            }
                            catch (IllegalArgumentException e) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (def instanceof DataSourceDefinitionInterface) {
                    if (!((DataSourceDefinitionInterface)def).isDefaultValueSet() || (ds = (DataSourceInterface)((DataSourceDefinitionInterface)def).getDefaultValue()) == null || !DataSourceUtil.isDataSourceTypeAllowed(ds.getDataSourceType(), type) || sources.contains(ds)) continue;
                    try {
                        if (DataSourceUtil.getDataSource(userContext, ds.getDataSourceLocation()) == null) continue;
                        sources.add(ds);
                    }
                    catch (ServiceException path) {
                    }
                    catch (RemoteException path) {
                    }
                    catch (IllegalArgumentException path) {}
                    continue;
                }
                if (!(def instanceof DataSourceColumnDefinitionInterface)) continue;
                dsc = (DataSourceColumnDefinitionInterface)def;
                potentialDS = dsc.getDataSources();
                if (potentialDS != null) {
                    for (DataSourceInterface ds : potentialDS) {
                        if (ds == null || !DataSourceUtil.isDataSourceTypeAllowed(ds.getDataSourceType(), type) || sources.contains(ds)) continue;
                        try {
                            if (DataSourceUtil.getDataSource(userContext, ds.getDataSourceLocation()) == null) continue;
                            sources.add(ds);
                        }
                        catch (ServiceException ds) {
                        }
                        catch (RemoteException ds) {
                        }
                        catch (IllegalArgumentException ds) {}
                    }
                }
                if (!dsc.isDefaultValueSet()) continue;
                defaultValue = dsc.getDefaultValue();
                if (defaultValue instanceof DataSourceColumnInterface) {
                    ds = ((DataSourceColumnInterface)defaultValue).getDataSource();
                    if (ds == null || !DataSourceUtil.isDataSourceTypeAllowed(ds.getDataSourceType(), type) || sources.contains(ds)) continue;
                    try {
                        if (DataSourceUtil.getDataSource(userContext, ds.getDataSourceLocation()) == null) continue;
                        sources.add(ds);
                    }
                    catch (ServiceException ds) {
                    }
                    catch (RemoteException ds) {
                    }
                    catch (IllegalArgumentException ds) {}
                    continue;
                }
                if (!(defaultValue instanceof Collection)) continue;
                for (DataSourceColumnInterface c : (Collection)defaultValue) {
                    ds = c.getDataSource();
                    if (ds == null || !DataSourceUtil.isDataSourceTypeAllowed(ds.getDataSourceType(), type) || sources.contains(ds)) continue;
                    try {
                        if (DataSourceUtil.getDataSource(userContext, ds.getDataSourceLocation()) != null) {
                            sources.add(ds);
                        }
                    }
                    catch (ServiceException var15_33) {
                    }
                    catch (RemoteException var15_34) {
                    }
                    catch (IllegalArgumentException var15_35) {
                        // empty catch block
                    }
                    sources.add(ds);
                }
            }
        }
        return sources;
    }

    static boolean areDataSourcesValid(PromptGroupInterface group, UserContextInterface userContext, PromptDataProviderInterface dataProvider) {
        List defs = group.getPromptDefinitions(true);
        for (int i = 0; i < defs.size(); ++i) {
            if (PromptUtility.isDataSourceValid((PromptDefinitionInterface)defs.get(i), userContext, dataProvider)) continue;
            return false;
        }
        return true;
    }

    static boolean isDataSourceValid(PromptDefinitionInterface def, UserContextInterface userContext, PromptDataProviderInterface dataProvider) {
        if (userContext == null) {
            return false;
        }
        if (def instanceof ValueProviderDefinitionInterface) {
            ValueProviderInterface vp = ((ValueProviderDefinitionInterface)def).getValueProvider();
            if (vp != null) {
                if (vp instanceof DataItemValueProvider) {
                    DataItem dataItem = ((DataItemValueProvider)vp).getDataItem();
                    if (dataItem != null) {
                        String path = DataProvider.getPathUrl((DataItem)((DataItemValueProvider)vp).getDataItem());
                        return path != null;
                    }
                    return false;
                }
                if (vp instanceof PromptColumnValueProvider) {
                    String path = ((PromptColumnValueProvider)vp).getTableUrl();
                    if (path != null) {
                        BaseDataSource ds = new BaseDataSource(1L, path);
                        if (dataProvider != null) {
                            try {
                                PhysicalTableInterface tableURL = dataProvider.getPhysicalTable(path);
                                if (tableURL != null) {
                                    return true;
                                }
                            }
                            catch (ServerConnectionException e) {
                                return false;
                            }
                            return false;
                        }
                        try {
                            if (DataSourceUtil.getDataSource(userContext, ds.getDataSourceLocation()) != null) {
                                return true;
                            }
                        }
                        catch (ServiceException e) {
                            return false;
                        }
                        catch (RemoteException e) {
                            return false;
                        }
                        catch (IllegalArgumentException e) {
                            return false;
                        }
                        return false;
                    }
                    return false;
                }
            } else {
                return true;
            }
        }
        if (def instanceof DataSourceDefinitionInterface) {
            DataSourceInterface ds;
            if (((DataSourceDefinitionInterface)def).isDefaultValueSet() && (ds = (DataSourceInterface)((DataSourceDefinitionInterface)def).getDefaultValue()) != null) {
                try {
                    if (DataSourceUtil.getDataSource(userContext, ds.getDataSourceLocation()) != null) {
                        return true;
                    }
                }
                catch (ServiceException e) {
                    return false;
                }
                catch (RemoteException e) {
                    return false;
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
                return false;
            }
        } else if (def instanceof DataSourceColumnDefinitionInterface) {
            DataSourceColumnDefinitionInterface dsc = (DataSourceColumnDefinitionInterface)def;
            List potentialDS = dsc.getDataSources();
            if (potentialDS != null) {
                for (DataSourceInterface ds : potentialDS) {
                    if (ds == null) continue;
                    try {
                        if (DataSourceUtil.getDataSource(userContext, ds.getDataSourceLocation()) != null) continue;
                        return false;
                    }
                    catch (ServiceException e) {
                        return false;
                    }
                    catch (RemoteException e) {
                        return false;
                    }
                    catch (IllegalArgumentException e) {
                        return false;
                    }
                }
            }
            if (dsc.isDefaultValueSet()) {
                Object defaultValue = dsc.getDefaultValue();
                if (defaultValue instanceof DataSourceColumnInterface) {
                    DataSourceInterface ds;
                    ds = ((DataSourceColumnInterface)defaultValue).getDataSource();
                    if (ds != null) {
                        try {
                            if (DataSourceUtil.getDataSource(userContext, ds.getDataSourceLocation()) == null) {
                                return false;
                            }
                        }
                        catch (ServiceException e) {
                            return false;
                        }
                        catch (RemoteException e) {
                            return false;
                        }
                        catch (IllegalArgumentException e) {
                            return false;
                        }
                        return true;
                    }
                } else if (defaultValue instanceof Collection) {
                    for (DataSourceColumnInterface c : (Collection)defaultValue) {
                        DataSourceInterface ds = c.getDataSource();
                        if (ds == null) continue;
                        try {
                            if (DataSourceUtil.getDataSource(userContext, ds.getDataSourceLocation()) == null) continue;
                            return false;
                        }
                        catch (ServiceException e) {
                            return false;
                        }
                        catch (RemoteException e) {
                            return false;
                        }
                        catch (IllegalArgumentException e) {
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }

    public static String getMessageDialogTitle(BasePanel panel) {
        String title = ERROR_MESSAGE_DIALOG_TITLE;
        GenericErrorHandlerInterface errorHandler = panel.getGenericErrorHandler();
        if (errorHandler != null && errorHandler instanceof JOptionPaneErrorHandler) {
            title = ((JOptionPaneErrorHandler)errorHandler).getTitle();
        }
        return title;
    }

    static boolean isColumnValidForPromptDataType(long selectedPromptDataType, long colType) {
        boolean isValid = false;
        if (colType == selectedPromptDataType) {
            isValid = true;
        }
        return isValid;
    }

    static String[] getStaticListColumnHeadersForSelectionType(String selectionType) {
        String defaultHeader = RB.getStringResource("default.txt");
        if ("Single value" != selectionType) {
            defaultHeader = RB.getStringResource("defaults.txt");
        }
        String[] columnNames = new String[]{RB.getStringResource("choiceValues.txt"), RB.getStringResource("choiceLabels.txt"), defaultHeader};
        return columnNames;
    }

    static boolean isDataItemValidForPromptDataType(long selectedPromptDataType, long type) {
        boolean isValid = false;
        if ((type == 3L || type == 1L || type == 11L) && selectedPromptDataType == 1L) {
            isValid = true;
        } else {
            if (selectedPromptDataType == 2L && type == 2L) {
                return true;
            }
            if (selectedPromptDataType == 4L && type == 4L) {
                return true;
            }
            if (selectedPromptDataType == 8L && type == 5L) {
                return true;
            }
            if (selectedPromptDataType == 16L && type == 6L) {
                return true;
            }
        }
        return isValid;
    }

    static SupportedSpecialValues refineSpecialValues(SupportedSpecialValues specialValues) {
        SupportedSpecialValues supportedSpecialValues = new SupportedSpecialValues();
        supportedSpecialValues.setAllSupported(specialValues.isAllSupported());
        supportedSpecialValues.setMissingValuesSupported(specialValues.isMissingValuesSupported());
        return supportedSpecialValues;
    }

    static Map getListOfDependentPrompts(PromptDefinitionInterface promptObject, DynamicPromptValueContext dynamicValueContext, PropertiesCommunicator communicator, Locale locale) {
        HashMap<PromptDefinitionInterface, PromptGroupInterface> promptsThatAreDependent = new HashMap<PromptDefinitionInterface, PromptGroupInterface>();
        PromptGroupInterface rootPromptGroup = communicator.getRootPromptGroup();
        List definitionsRootGroup = rootPromptGroup.getPromptDefinitions(false);
        for (PromptDefinitionInterface prompt : definitionsRootGroup) {
            Collection dependencies = PromptUtility.processPromptDefinitions(prompt, dynamicValueContext, locale);
            if (dependencies == null || dependencies.size() <= 0 || !dependencies.contains(promptObject)) continue;
            PromptUtility.parseWhereClauseForOperator(prompt, promptObject, communicator, promptsThatAreDependent);
        }
        List subgroups = rootPromptGroup.getPromptSubgroups(true);
        for (PromptGroupInterface promptGroup : subgroups) {
            List definitions = promptGroup.getPromptDefinitions(false);
            if (promptGroup instanceof SharedPromptGroupInterface) continue;
            for (PromptDefinitionInterface prompt : definitions) {
                Collection dependencies;
                if (PromptUtil.isPromptDefinitionInModalGroup((PromptDefinitionInterface)prompt, (PromptGroupInterface)promptGroup) || (dependencies = PromptUtility.processPromptDefinitions(prompt, dynamicValueContext, locale)) == null || dependencies.size() <= 0 || !dependencies.contains(promptObject)) continue;
                promptsThatAreDependent.put(prompt, promptGroup);
            }
        }
        return promptsThatAreDependent;
    }

    static Collection processPromptDefinitions(PromptDefinitionInterface prompt, DynamicPromptValueContext dynamicValueContext, Locale locale) {
        ValueProviderInterface valueProvider = null;
        if (prompt instanceof ValueProviderDefinitionInterface) {
            valueProvider = ((ValueProviderDefinitionInterface)prompt).getValueProvider();
        }
        if (valueProvider == null || valueProvider != null && !(valueProvider instanceof OLAPDataItemValueProvider)) {
            try {
                if (valueProvider instanceof DataItemValueProvider) {
                    Collection dependentPrompts = ((DynamicValueProviderInterface)valueProvider).getDependentPrompts(locale, (DynamicPromptValueContextInterface)dynamicValueContext);
                    return dependentPrompts;
                }
            }
            catch (ValueProviderException valueProviderException) {
                // empty catch block
            }
        }
        return Collections.EMPTY_LIST;
    }

    static void parseWhereClauseForOperator(PromptDefinitionInterface prompt, PromptDefinitionInterface promptObject, PropertiesCommunicator communicator, Map promptsThatAreDependent) {
        ValueProviderInterface valueProvider = ((ValueProviderDefinitionInterface)prompt).getValueProvider();
        if (valueProvider instanceof RelationalDataItemValueProvider) {
            WhereClause whereClause = ((RelationalDataItemValueProvider)valueProvider).getWhereClause();
            OperandInterface andedExpression = whereClause.getCondition();
            List expressionList = Expression.getListFromAndedExpression((Expression)((Expression)andedExpression), (LoggerFactoryInterface)communicator.getLoggerFactory());
            int expressionListSize = expressionList.size();
            ArrayList<Expression> expresssionsToRemove = new ArrayList<Expression>();
            for (int k = expressionListSize - 1; k >= 0; --k) {
                Expression expression = (Expression)expressionList.get(k);
                List operands = expression.getOperands();
                Object columnOperand = null;
                PromptValueOperand promptOperand = null;
                int operandsSize = operands.size();
                PromptDefinitionInterface promptForOperand = null;
                for (int j = 0; j < operandsSize; ++j) {
                    OperatorInterface operator;
                    Object operand = operands.get(j);
                    if (!(operand instanceof PromptValueOperand) || (promptForOperand = (promptOperand = (PromptValueOperand)operand).getPromptDefinition()) != promptObject || (operator = expression.getOperator()) == MultiValueFormattedOperator.EQUAL_OPERATOR) continue;
                    expresssionsToRemove.add(expression);
                }
            }
            if (expresssionsToRemove.size() > 0) {
                promptsThatAreDependent.put(prompt, expresssionsToRemove);
            }
        }
    }

    static void reworkDependencies(Map dependenciesToClear, PropertiesCommunicator communicator) {
        if (dependenciesToClear != null) {
            Set keys = dependenciesToClear.keySet();
            for (PromptDefinitionInterface prompt : keys) {
                ValueProviderInterface valueProvider;
                if (!(prompt instanceof ValueProviderDefinitionInterface) || !((valueProvider = ((ValueProviderDefinitionInterface)prompt).getValueProvider()) instanceof RelationalDataItemValueProvider)) continue;
                WhereClause whereClause = ((RelationalDataItemValueProvider)valueProvider).getWhereClause();
                OperandInterface andedExpression = whereClause.getCondition();
                List expressionList = Expression.getListFromAndedExpression((Expression)((Expression)andedExpression), (LoggerFactoryInterface)communicator.getLoggerFactory());
                List expressionsToDelete = (List)dependenciesToClear.get(prompt);
                whereClause = PromptUtility.processExpressionList(expressionList, expressionsToDelete, communicator);
                ((RelationalDataItemValueProvider)valueProvider).setWhereClause(whereClause);
            }
        }
    }

    static WhereClause processExpressionList(List expressionList, List expressionToRemove, PropertiesCommunicator communicator) {
        int expressionListSize = expressionList.size();
        for (int k = expressionListSize - 1; k >= 0; --k) {
            Expression expression = (Expression)expressionList.get(k);
            int expressionToRemoveSize = expressionToRemove.size();
            for (int j = 0; j < expressionToRemoveSize; ++j) {
                if (expression != expressionToRemove.get(j)) continue;
                expressionList.remove(expression);
            }
        }
        WhereClause whereClause = new WhereClause();
        int expressionCount = expressionList.size();
        if (expressionCount == 1) {
            whereClause = new WhereClause();
            whereClause.setCondition((OperandInterface)((Expression)expressionList.get(0)));
        } else if (expressionCount > 1) {
            whereClause = new WhereClause();
            whereClause.setCondition((OperandInterface)Expression.newAndedExpression((List)expressionList, (LoggerFactoryInterface)communicator.getLoggerFactory()));
        }
        return whereClause;
    }

    static void setMinRelativeOptions(MutableDateDefinitionInterface dateDefinition) {
        if (dateDefinition.getDateType() == DateTypes.TIME) {
            StringBuffer relOptions = new StringBuffer();
            relOptions.append(501);
            relOptions.append(":").append(705);
            relOptions.append(":").append(707);
            relOptions.append(":").append(708);
            relOptions.append(":").append(706);
            relOptions.append(":").append(709);
            relOptions.append(":").append(710);
            relOptions.append(":").append(507);
            relOptions.append(":").append(508);
            relOptions.append(":").append(509);
            relOptions.append(":").append(510);
            dateDefinition.addUserInfo("_RELATIVE_VALUES", relOptions.toString());
        } else if (dateDefinition.getDateType() == DateTypes.TIMESTAMP) {
            StringBuffer relOptions = new StringBuffer();
            relOptions.append(401);
            relOptions.append(":").append(402);
            relOptions.append(":").append(403);
            relOptions.append(":").append(715);
            relOptions.append(":").append(717);
            relOptions.append(":").append(718);
            relOptions.append(":").append(716);
            relOptions.append(":").append(719);
            relOptions.append(":").append(720);
            relOptions.append(":").append(410);
            relOptions.append(":").append(411);
            relOptions.append(":").append(412);
            relOptions.append(":").append(413);
            dateDefinition.addUserInfo("_RELATIVE_VALUES", relOptions.toString());
        }
    }

    static void setMaxRelativeOptions(MutableDateDefinitionInterface dateDefinition) {
        if (dateDefinition.getDateType() == DateTypes.TIME) {
            StringBuffer relOptions = new StringBuffer();
            relOptions.append(501);
            relOptions.append(":").append(805);
            relOptions.append(":").append(807);
            relOptions.append(":").append(808);
            relOptions.append(":").append(806);
            relOptions.append(":").append(809);
            relOptions.append(":").append(810);
            relOptions.append(":").append(507);
            relOptions.append(":").append(508);
            relOptions.append(":").append(509);
            relOptions.append(":").append(510);
            dateDefinition.addUserInfo("_RELATIVE_VALUES", relOptions.toString());
        } else if (dateDefinition.getDateType() == DateTypes.TIMESTAMP) {
            StringBuffer relOptions = new StringBuffer();
            relOptions.append(401);
            relOptions.append(":").append(402);
            relOptions.append(":").append(403);
            relOptions.append(":").append(815);
            relOptions.append(":").append(817);
            relOptions.append(":").append(818);
            relOptions.append(":").append(816);
            relOptions.append(":").append(819);
            relOptions.append(":").append(820);
            relOptions.append(":").append(410);
            relOptions.append(":").append(411);
            relOptions.append(":").append(412);
            relOptions.append(":").append(413);
            dateDefinition.addUserInfo("_RELATIVE_VALUES", relOptions.toString());
        }
    }

    static Frame getParentFrame(PropertiesCommunicator communicator, Component component) {
        Frame parentFrame = Util.getParentFrame((Component)component);
        if (parentFrame == null) {
            parentFrame = communicator.getDefaultParentFrame();
        }
        return parentFrame;
    }
}

