/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.DynamicPromptValueContext;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.ColorDefinition;
import com.sas.prompts.definitions.ColorDefinitionInterface;
import com.sas.prompts.definitions.DataSourceColumnDefinition;
import com.sas.prompts.definitions.DataSourceColumnDefinitionInterface;
import com.sas.prompts.definitions.DataSourceDefinition;
import com.sas.prompts.definitions.DataSourceDefinitionInterface;
import com.sas.prompts.definitions.DateDefinition;
import com.sas.prompts.definitions.DateDefinitionInterface;
import com.sas.prompts.definitions.DateRangeDefinition;
import com.sas.prompts.definitions.DateRangeDefinitionInterface;
import com.sas.prompts.definitions.DoubleDefinition;
import com.sas.prompts.definitions.DoubleRangeDefinition;
import com.sas.prompts.definitions.InputFileDefinition;
import com.sas.prompts.definitions.IntegerDefinition;
import com.sas.prompts.definitions.IntegerRangeDefinition;
import com.sas.prompts.definitions.MutablePromptDefinitionInterface;
import com.sas.prompts.definitions.MutableValueProviderDefinitionInterface;
import com.sas.prompts.definitions.OutputFileDefinition;
import com.sas.prompts.definitions.PromptDefinitionEnum;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.SASLibraryDefinition;
import com.sas.prompts.definitions.SASLibraryDefinitionInterface;
import com.sas.prompts.definitions.SelectableDefinitionInterface;
import com.sas.prompts.definitions.StringRangeDefinition;
import com.sas.prompts.definitions.StringRangeDefinitionInterface;
import com.sas.prompts.definitions.TextDefinition;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.prompts.definitions.remote.OLAPMemberNameDefinition;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.PromptDataProviderInterface;
import com.sas.prompts.valueprovider.dynamic.iq.OLAPDataItemValueProvider;
import com.sas.prompts.valueprovider.dynamic.iq.RelationalDataItemValueProvider;
import com.sas.prompts.valueprovider.dynamic.workspace.PromptColumnValueProvider;
import com.sas.prompts.visuals.swing.designtime.BaseDatePanel;
import com.sas.prompts.visuals.swing.designtime.BaseDateRangePanel;
import com.sas.prompts.visuals.swing.designtime.BaseNumericPromptPanel;
import com.sas.prompts.visuals.swing.designtime.BaseNumericRangePanel;
import com.sas.prompts.visuals.swing.designtime.BasePromptTypePanel;
import com.sas.prompts.visuals.swing.designtime.BasePromptTypesAndValuesPanel;
import com.sas.prompts.visuals.swing.designtime.ColorPanel;
import com.sas.prompts.visuals.swing.designtime.DataSourceColumnPanel;
import com.sas.prompts.visuals.swing.designtime.DataSourcePanel;
import com.sas.prompts.visuals.swing.designtime.FileNamePanel;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionInterface;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionWithErrorSuppressionOptionInterface;
import com.sas.prompts.visuals.swing.designtime.PromptTypeAndValuesConfigHelper;
import com.sas.prompts.visuals.swing.designtime.PromptTypeInfoFactory;
import com.sas.prompts.visuals.swing.designtime.PromptTypeInfoInterface;
import com.sas.prompts.visuals.swing.designtime.PromptTypesProviderInterface;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.prompts.visuals.swing.designtime.RelativeDateRangePanel;
import com.sas.prompts.visuals.swing.designtime.SASLibraryPanel;
import com.sas.prompts.visuals.swing.designtime.StringRangePanel;
import com.sas.prompts.visuals.swing.designtime.TextTypePanel;
import com.sas.prompts.visuals.swing.designtime.UnknownPromptTypePanel;
import com.sas.prompts.visuals.swing.designtime.UserEntryPanel;
import com.sas.prompts.visuals.swing.designtime.UserInfoCleanupInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.valueprovider.StaticValueProvider;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.swing.visuals.ComboBox;
import com.sas.swing.visuals.Config;
import com.sas.swing.visuals.ConfigStateInterface;
import com.sas.swing.visuals.PanelInterface;
import com.sas.swing.visuals.util.Util;
import com.sas.util.DateTypes;
import com.sas.util.ValueItem;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PromptTypeAndValuesPanel
extends BasePromptTypePanel
implements ActionListener,
PropertyChangeListener,
ConfigStateInterface {
    private boolean contentsValid = true;
    private ComboBox promptTypeCombo;
    private JPanel promptTypePanel;
    private JLabel timeHint;
    private ComboBox listTypeCombo;
    private ComboBox selectionTypeCombo;
    private JPanel customPanel;
    private JPanel panelHolderPanel;
    private PromptDefinitionInterface prompt;
    private String promptTypeSelectedItem;
    private String selectionTypeSelectedItem;
    private String listTypeSelectedItem;
    private DefaultComboBoxModel listTypeModel;
    private DefaultComboBoxModel selectionModeModel;
    private Config config;
    private PromptTypesProviderInterface promptTypesProvider;
    private DefaultComboBoxModel promptTypeModel;
    private JLabel listTypeLabel;
    private JLabel selectionModeLabel;
    private boolean currentAllowUserValuesForList;
    public static int NO_PROMPT_CHANGE = 0;
    public static int PROMPT_TYPE_CHANGED = 1;
    public static int LIST_TYPE_CHANGED = 2;
    public static int SELECTION_TYPE_CHANGED = 3;
    private static final long serialVersionUID = 3257563988660598326L;

    public PromptTypeAndValuesPanel(PropertiesCommunicator communicator) {
        this(communicator, null);
    }

    public PromptTypeAndValuesPanel(PropertiesCommunicator communicator, PromptDefinitionInterface prompt) {
        super(communicator);
        this.prompt = prompt;
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        AutoSizingGridLayout layout = new AutoSizingGridLayout(2, 1, 10, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        this.add(this.createCommonComponentsPromptTypePanel());
        this.panelHolderPanel = new JPanel();
        AutoSizingGridLayout panelHolderLayout = new AutoSizingGridLayout(1, 1, 10, 5, true, false, true);
        this.panelHolderPanel.setLayout((LayoutManager)panelHolderLayout);
        this.customPanel = this.initializeCustomPanel();
        this.panelHolderPanel.add(this.customPanel);
        this.add(this.panelHolderPanel);
        this.customPanel.addPropertyChangeListener(this);
        communicator.addPropertyChangeListener(this);
        this.promptTypeCombo.addActionListener((ActionListener)this);
        this.selectionTypeCombo.addActionListener((ActionListener)this);
        this.listTypeCombo.addActionListener((ActionListener)this);
    }

    private JPanel createCustomPanel() {
        if (this.customPanel != null) {
            this.removePropertyChangeListener(this);
            JPanel promptPanel = this.createPanelFromSelections();
            return promptPanel;
        }
        return null;
    }

    private JPanel initializeCustomPanel() {
        JPanel promptPanel = null;
        if (this.customPanel != null) {
            this.removePropertyChangeListener(this);
        }
        if (this.prompt == null) {
            promptPanel = this.createPanelFromSelections();
        } else if (this.promptTypesProvider != null) {
            PromptTypeInfoInterface promptInfo = this.promptTypesProvider.getPromptType(this.prompt);
            if (promptInfo != null && this.promptTypesProvider.getSupportedTypes().contains(promptInfo)) {
                BasePromptTypesAndValuesPanel customPanel = promptInfo.getCustomPanelForPromptType(this.prompt);
                if (customPanel != null) {
                    String identifier;
                    this.promptTypeSelectedItem = identifier = promptInfo.getIdentifier();
                    ValueItem promptSelectedItem = this.findValueItem(identifier);
                    if (promptSelectedItem != null) {
                        this.promptTypeCombo.setSelectedItem((Object)promptSelectedItem);
                    }
                    promptPanel = customPanel;
                    if (this.prompt instanceof SelectableDefinitionInterface) {
                        this.selectionTypeSelectedItem = PromptUtility.getSelectionTypeForPrompt((SelectableDefinitionInterface)this.prompt);
                        this.selectionTypeCombo.setSelectedItem((Object)this.findValueItemInModel(this.selectionTypeSelectedItem, this.selectionModeModel));
                        this.communicator.setSelectionType(this.selectionTypeSelectedItem);
                        if (!this.communicator.isNumberOfValuesEnabled()) {
                            this.enableSelectionTypeControl(false);
                        }
                    } else {
                        this.selectionTypeCombo.setSelectedItem((Object)this.findValueItemInModel("Single value", this.selectionModeModel));
                        this.communicator.setSelectionType("Single value");
                        if (!this.communicator.isNumberOfValuesEnabled()) {
                            this.enableSelectionTypeControl(false);
                        }
                    }
                    if (this.prompt instanceof MutableValueProviderDefinitionInterface) {
                        this.listTypeSelectedItem = this.getListType();
                        this.listTypeCombo.setSelectedItem((Object)this.findValueItemInModel(this.listTypeSelectedItem, this.listTypeModel));
                        this.communicator.setListType(this.listTypeSelectedItem);
                        boolean supportsDynamicValues = PromptUtility.promptSupportsDynamicValues(this.prompt);
                        this.listTypeCombo.setEnabled(supportsDynamicValues);
                        this.listTypeLabel.setEnabled(supportsDynamicValues);
                    } else {
                        this.listTypeCombo.setSelectedItem((Object)this.findValueItemInModel("User enters values", this.listTypeModel));
                        this.communicator.setListType("User enters values");
                        this.listTypeCombo.setEnabled(false);
                        this.listTypeLabel.setEnabled(false);
                    }
                } else {
                    promptPanel = this.initializePanelForPrompt();
                }
            } else {
                promptPanel = this.initializePanelForPrompt();
            }
        } else {
            promptPanel = this.initializePanelForPrompt();
        }
        return promptPanel;
    }

    private JPanel initializePanelForPrompt() {
        BasePromptTypesAndValuesPanel promptPanel = null;
        PromptDefinitionEnum pdEnum = PromptDefinitionEnum.valueOf((PromptDefinitionInterface)this.prompt);
        if (pdEnum != null) {
            if (this.prompt instanceof ValueProviderDefinitionInterface) {
                String selectionType;
                String listType;
                if ("DoubleDefinition".equals(pdEnum.toString()) || "IntegerDefinition".equals(pdEnum.toString()) || "SharedDoubleDefinition".equals(pdEnum.toString()) || "SharedIntegerDefinition".equals(pdEnum.toString())) {
                    this.promptTypeSelectedItem = "Numeric";
                    this.promptTypeCombo.setSelectedItem((Object)this.findValueItem("Numeric"));
                } else if ("DateDefinition".equals(pdEnum.toString()) || "SharedDateDefinition".equals(pdEnum.toString())) {
                    DateTypes dateType = ((DateDefinitionInterface)this.prompt).getDateType();
                    if (dateType.equals(DateTypes.TIME)) {
                        this.promptTypeSelectedItem = "Time";
                        this.promptTypeCombo.setSelectedItem((Object)this.findValueItem("Time"));
                        this.timeHint = new JLabel(BaseDatePanel.TIME_HINT);
                        this.promptTypePanel.add(this.timeHint);
                    } else if (dateType.equals(DateTypes.TIMESTAMP)) {
                        this.promptTypeSelectedItem = "Timestamp";
                        this.promptTypeCombo.setSelectedItem((Object)this.findValueItem("Timestamp"));
                        this.timeHint = new JLabel(BaseDatePanel.TIMESTAMP_HINT);
                        this.promptTypePanel.add(this.timeHint);
                    } else {
                        this.promptTypeSelectedItem = "Date";
                        this.promptTypeCombo.setSelectedItem((Object)this.findValueItem("Date"));
                    }
                } else if ("TextDefinition".equals(pdEnum.toString()) || "SharedTextDefinition".equals(pdEnum.toString())) {
                    this.promptTypeSelectedItem = "Text";
                    this.promptTypeCombo.setSelectedItem((Object)this.findValueItem("Text"));
                } else if ("OLAPMemberNameDefinition".equals(pdEnum.toString()) || "SharedOLAPMemberNameDefinition".equals(pdEnum.toString())) {
                    this.promptTypeSelectedItem = "OLAP member";
                    this.promptTypeCombo.setSelectedItem((Object)this.findValueItem("OLAP member"));
                }
                this.listTypeSelectedItem = listType = this.getListType();
                this.communicator.setListType(this.listTypeSelectedItem);
                this.listTypeCombo.setSelectedItem((Object)this.findValueItemInModel(listType, this.listTypeModel));
                int selectionMode = ((SelectableDefinitionInterface)this.prompt).getSelectionType();
                this.selectionTypeSelectedItem = selectionType = this.getSelectionType(selectionMode);
                this.communicator.setSelectionType(this.selectionTypeSelectedItem);
                this.selectionTypeCombo.setSelectedItem((Object)this.findValueItemInModel(selectionType, this.selectionModeModel));
                promptPanel = new UserEntryPanel(this.prompt, selectionType, listType, this.communicator);
            } else {
                this.listTypeSelectedItem = "User enters values";
                this.communicator.setListType(this.listTypeSelectedItem);
                this.selectionTypeSelectedItem = "Single value";
                this.communicator.setSelectionType(this.selectionTypeSelectedItem);
                if ("ColorDefinition".equals(pdEnum.toString()) || "SharedColorDefinition".equals(pdEnum.toString())) {
                    promptPanel = new ColorPanel((ColorDefinitionInterface)this.prompt, this.communicator);
                    this.promptTypeSelectedItem = "Color";
                    this.promptTypeCombo.setSelectedItem((Object)this.findValueItem("Color"));
                } else if ("DoubleRangeDefinition".equals(pdEnum.toString()) || "IntegerRangeDefinition".equals(pdEnum.toString()) || "SharedDoubleRangeDefinition".equals(pdEnum.toString()) || "SharedIntegerRangeDefinition".equals(pdEnum.toString())) {
                    promptPanel = new BaseNumericRangePanel(this.prompt, this.communicator);
                    this.promptTypeSelectedItem = "Numeric Range";
                    this.promptTypeCombo.setSelectedItem((Object)this.findValueItem("Numeric Range"));
                } else if ("DateRangeDefinition".equals(pdEnum.toString()) || "SharedDateRangeDefinition".equals(pdEnum.toString())) {
                    DateTypes dateType = ((DateRangeDefinitionInterface)this.prompt).getDateType();
                    if (dateType.equals(DateTypes.TIME)) {
                        this.promptTypeSelectedItem = "Time Range";
                        this.promptTypeCombo.setSelectedItem((Object)this.findValueItem("Time Range"));
                        promptPanel = new RelativeDateRangePanel(this.prompt, dateType, this.communicator);
                        this.timeHint = new JLabel(BaseDatePanel.TIME_HINT);
                        this.promptTypePanel.add(this.timeHint);
                    } else if (dateType.equals(DateTypes.TIMESTAMP)) {
                        this.promptTypeSelectedItem = "Timestamp Range";
                        this.promptTypeCombo.setSelectedItem((Object)this.findValueItem("Timestamp Range"));
                        promptPanel = new RelativeDateRangePanel(this.prompt, dateType, this.communicator);
                        this.timeHint = new JLabel(BaseDatePanel.TIMESTAMP_HINT);
                        this.promptTypePanel.add(this.timeHint);
                    } else {
                        this.promptTypeSelectedItem = "Date Range";
                        this.promptTypeCombo.setSelectedItem((Object)this.findValueItem("Date Range"));
                        promptPanel = new BaseDateRangePanel(this.prompt, this.communicator);
                    }
                } else if ("DataSourceDefinition".equals(pdEnum.toString()) || "SharedDataSourceDefinition".equals(pdEnum.toString())) {
                    this.promptTypeSelectedItem = "Data Source";
                    this.promptTypeCombo.setSelectedItem((Object)this.findValueItem("Data Source"));
                    promptPanel = new DataSourcePanel((DataSourceDefinitionInterface)this.prompt, this.communicator);
                } else if ("DataSourceColumnDefinition".equals(pdEnum.toString()) || "SharedDataSourceColumnDefinition".equals(pdEnum.toString())) {
                    String selectionType;
                    this.promptTypeSelectedItem = "Data Source Column";
                    this.promptTypeCombo.setSelectedItem((Object)this.findValueItem("Data Source Column"));
                    int selectionMode = ((SelectableDefinitionInterface)this.prompt).getSelectionType();
                    this.selectionTypeSelectedItem = selectionType = this.getSelectionType(selectionMode);
                    this.communicator.setSelectionType(this.selectionTypeSelectedItem);
                    this.selectionTypeCombo.setSelectedItem((Object)this.findValueItemInModel(selectionType, this.selectionModeModel));
                    promptPanel = new DataSourceColumnPanel((DataSourceColumnDefinitionInterface)this.prompt, this.communicator);
                } else if ("InputFileDefinition".equals(pdEnum.toString()) || "OutputFileDefinition".equals(pdEnum.toString()) || "SharedInputFileDefinition".equals(pdEnum.toString()) || "SharedOutputFileDefinition".equals(pdEnum.toString())) {
                    this.promptTypeSelectedItem = "File Name";
                    this.promptTypeCombo.setSelectedItem((Object)this.findValueItem("File Name"));
                    promptPanel = new FileNamePanel(this.prompt, this.communicator);
                } else if ("StringRangeDefinition".equals(pdEnum.toString()) || "SharedStringRangeDefinition".equals(pdEnum.toString())) {
                    this.promptTypeSelectedItem = "Text Range";
                    this.promptTypeCombo.setSelectedItem((Object)this.findValueItem("Text Range"));
                    promptPanel = new StringRangePanel((StringRangeDefinitionInterface)this.prompt, this.communicator);
                } else if ("SASLibraryDefinition".equals(pdEnum.toString()) || "SharedSASLibraryDefinition".equals(pdEnum.toString())) {
                    this.promptTypeSelectedItem = "SAS Library";
                    this.promptTypeCombo.setSelectedItem((Object)this.findValueItem("SAS Library"));
                    promptPanel = new SASLibraryPanel((SASLibraryDefinitionInterface)this.prompt, this.communicator);
                } else {
                    this.promptTypeModel.addElement(PromptUtility.newUnknownPromptValueItem());
                    this.promptTypeSelectedItem = "Unknown Prompt Type";
                    this.promptTypeCombo.setSelectedItem((Object)this.findValueItem("Unknown Prompt Type"));
                    promptPanel = new UnknownPromptTypePanel((MutablePromptDefinitionInterface)this.prompt, this.communicator);
                }
            }
        } else {
            this.promptTypeModel.addElement(PromptUtility.newUnknownPromptValueItem());
            this.promptTypeSelectedItem = "Unknown Prompt Type";
            this.promptTypeCombo.setSelectedItem((Object)this.findValueItem("Unknown Prompt Type"));
            promptPanel = new UnknownPromptTypePanel((MutablePromptDefinitionInterface)this.prompt, this.communicator);
        }
        if (this.promptTypeSelectedItem != null) {
            this.validateListAndSelectionCombos(this.promptTypeSelectedItem);
        }
        return promptPanel;
    }

    private JPanel createPanelFromSelections() {
        this.promptTypeSelectedItem = (String)((ValueItem)this.promptTypeCombo.getSelectedItem()).getValue();
        this.selectionTypeSelectedItem = (String)((ValueItem)this.selectionTypeCombo.getSelectedItem()).getValue();
        this.communicator.setSelectionType(this.selectionTypeSelectedItem);
        this.listTypeSelectedItem = (String)((ValueItem)this.listTypeCombo.getSelectedItem()).getValue();
        this.communicator.setListType(this.listTypeSelectedItem);
        this.customPanel = this.listTypeSelectedItem.equals("User selects values from a static list") ? new UserEntryPanel(this.promptTypeSelectedItem, (String)((ValueItem)this.selectionTypeCombo.getSelectedItem()).getValue(), "User selects values from a static list", this.communicator) : (this.listTypeSelectedItem.equals("User selects values from a dynamic list") ? new UserEntryPanel(this.promptTypeSelectedItem, (String)((ValueItem)this.selectionTypeCombo.getSelectedItem()).getValue(), "User selects values from a dynamic list", this.communicator) : new UserEntryPanel(this.promptTypeSelectedItem, (String)((ValueItem)this.selectionTypeCombo.getSelectedItem()).getValue(), "User enters values", this.communicator));
        if (this.timeHint != null && this.promptTypePanel != null) {
            this.promptTypePanel.remove(this.timeHint);
        }
        if (this.promptTypeSelectedItem.equals("Time") || this.promptTypeSelectedItem.equals("Time Range")) {
            this.timeHint = new JLabel(BaseDatePanel.TIME_HINT);
            this.promptTypePanel.add(this.timeHint);
        } else if (this.promptTypeSelectedItem.equals("Timestamp") || this.promptTypeSelectedItem.equals("Timestamp Range")) {
            this.timeHint = new JLabel(BaseDatePanel.TIMESTAMP_HINT);
            this.promptTypePanel.add(this.timeHint);
        }
        return this.customPanel;
    }

    private void removeUnknownPromptType() {
        ValueItem unknownPromptValueItem = this.findValueItem("Unknown Prompt Type");
        if (unknownPromptValueItem != null) {
            this.promptTypeModel.removeElement(unknownPromptValueItem);
        }
    }

    private ValueItem findValueItem(String id) {
        if (id != null) {
            int listSize = this.promptTypeModel.getSize();
            for (int i = 0; i < listSize; ++i) {
                ValueItem valueItem = (ValueItem)this.promptTypeModel.getElementAt(i);
                if (!valueItem.getValue().equals(id)) continue;
                return valueItem;
            }
        }
        return null;
    }

    private ValueItem findValueItemInModel(String id, DefaultComboBoxModel model) {
        if (id != null) {
            int listSize = model.getSize();
            for (int i = 0; i < listSize; ++i) {
                ValueItem valueItem = (ValueItem)model.getElementAt(i);
                if (!valueItem.getValue().equals(id)) continue;
                return valueItem;
            }
        }
        return null;
    }

    private String getSelectionType(int selectionMode) {
        if (selectionMode == 301) {
            return "Multiple values";
        }
        if (selectionMode == 302) {
            return "Multiple ordered values";
        }
        return "Single value";
    }

    public void setSelectionMode(int selectionMode) {
        if (selectionMode == 301) {
            this.selectionTypeCombo.setSelectedItem((Object)this.findValueItemInModel("Multiple values", this.selectionModeModel));
        } else if (selectionMode == 302) {
            this.selectionTypeCombo.setSelectedItem((Object)this.findValueItemInModel("Multiple ordered values", this.selectionModeModel));
        } else {
            this.selectionTypeCombo.setSelectedItem((Object)this.findValueItemInModel("Multiple ordered values", this.selectionModeModel));
        }
    }

    private String getListType() {
        if (this.prompt == null) {
            return "User enters values";
        }
        ValueProviderInterface valueProvider = ((ValueProviderDefinitionInterface)this.prompt).getValueProvider();
        if (valueProvider == null) {
            return "User enters values";
        }
        if (valueProvider instanceof StaticValueProvider) {
            return "User selects values from a static list";
        }
        if (valueProvider instanceof RelationalDataItemValueProvider || valueProvider instanceof OLAPDataItemValueProvider || valueProvider instanceof PromptColumnValueProvider) {
            return "User selects values from a dynamic list";
        }
        return "User enters values";
    }

    public void enableListTypeControl(boolean enable) {
        this.listTypeCombo.setEnabled(enable);
        this.listTypeLabel.setEnabled(enable);
    }

    public void enableSelectionTypeControl(boolean enable) {
        this.selectionTypeCombo.setEnabled(enable);
        this.selectionModeLabel.setEnabled(enable);
    }

    private JPanel createCommonComponentsPromptTypePanel() {
        JPanel commonComponentsPanel = new JPanel();
        AutoSizingGridLayout layout = new AutoSizingGridLayout(2, 1, 10, 5, true, false, true);
        commonComponentsPanel.setLayout((LayoutManager)layout);
        JPanel comboPanel = new JPanel();
        AutoSizingGridLayout comboLayout = new AutoSizingGridLayout(2, 1, 10, 5, true, false, true);
        comboPanel.setLayout((LayoutManager)comboLayout);
        this.promptTypePanel = new JPanel();
        AutoSizingGridLayout promptTypeLayout = new AutoSizingGridLayout(1, 2, 10, 5, true, false, true);
        promptTypeLayout.setRemainderColumn(1);
        this.promptTypePanel.setLayout((LayoutManager)promptTypeLayout);
        JLabel promptTypeLabel = new JLabel(RB.getStringResource("promptType.txt"));
        this.promptTypeCombo = new ComboBox();
        this.promptTypeModel = null;
        this.promptTypesProvider = this.communicator.getPromptTypesProvider();
        if (this.promptTypesProvider == null) {
            this.promptTypeModel = PromptUtility.newComboModel(this.communicator);
            this.promptTypeCombo.setModel((ComboBoxModel)this.promptTypeModel);
            promptTypeLabel.setLabelFor((Component)this.promptTypeCombo);
        } else {
            this.promptTypeModel = new DefaultComboBoxModel();
            List supportedTypes = this.promptTypesProvider.getSupportedTypes();
            for (PromptTypeInfoInterface promptTypeInfo : supportedTypes) {
                if (promptTypeInfo == null) continue;
                String identifier = promptTypeInfo.getIdentifier();
                String customLabel = promptTypeInfo.getLabel(this.getLocale());
                if ("Text".equals(identifier)) {
                    this.promptTypeModel.addElement(new ValueItem((Object)TEXT_PROMPT, (Object)"Text"));
                    continue;
                }
                if ("Numeric".equals(identifier) || "Integer".equals(identifier)) {
                    if (this.findValueItem("Numeric") != null) continue;
                    this.promptTypeModel.addElement(new ValueItem((Object)NUMERIC_PROMPT, (Object)"Numeric"));
                    continue;
                }
                if ("Numeric Range".equals(identifier) || "Integer Range".equals(identifier)) {
                    if (this.findValueItem("Numeric Range") != null) continue;
                    this.promptTypeModel.addElement(new ValueItem((Object)NUMERIC_RANGE_PROMPT, (Object)"Numeric Range"));
                    continue;
                }
                if ("Date".equals(identifier)) {
                    this.promptTypeModel.addElement(new ValueItem((Object)DATE_PROMPT, (Object)"Date"));
                    continue;
                }
                if ("Date Range".equals(identifier)) {
                    this.promptTypeModel.addElement(new ValueItem((Object)DATE_RANGE_PROMPT, (Object)"Date Range"));
                    continue;
                }
                if ("Time".equals(identifier)) {
                    this.promptTypeModel.addElement(new ValueItem((Object)TIME_PROMPT, (Object)"Time"));
                    continue;
                }
                if ("Time Range".equals(identifier)) {
                    this.promptTypeModel.addElement(new ValueItem((Object)TIME_RANGE_PROMPT, (Object)"Time Range"));
                    continue;
                }
                if ("Timestamp".equals(identifier)) {
                    this.promptTypeModel.addElement(new ValueItem((Object)TIMESTAMP_PROMPT, (Object)"Timestamp"));
                    continue;
                }
                if ("Timestamp Range".equals(identifier)) {
                    this.promptTypeModel.addElement(new ValueItem((Object)TIMESTAMP_RANGE_PROMPT, (Object)"Timestamp Range"));
                    continue;
                }
                if ("Color".equals(identifier)) {
                    this.promptTypeModel.addElement(new ValueItem((Object)COLOR_PROMPT, (Object)"Color"));
                    continue;
                }
                if ("Data Source".equals(identifier)) {
                    if (!PromptUtility.isUserContextAvailable(this.communicator)) continue;
                    this.promptTypeModel.addElement(new ValueItem((Object)DATASOURCE_PROMPT, (Object)"Data Source"));
                    continue;
                }
                if ("Data Source Column".equals(identifier)) {
                    if (!PromptUtility.isUserContextAvailable(this.communicator)) continue;
                    this.promptTypeModel.addElement(new ValueItem((Object)DATASOURCE_COLUMN_PROMPT, (Object)"Data Source Column"));
                    continue;
                }
                if ("File Name".equals(identifier) || "File Name".equals(identifier)) {
                    if (!PromptUtility.isUserContextAvailable(this.communicator) || this.findValueItem("File Name") != null) continue;
                    this.promptTypeModel.addElement(new ValueItem((Object)FILENAME_PROMPT, (Object)"File Name"));
                    continue;
                }
                if ("OLAP member".equals(identifier)) {
                    if (!PromptUtility.isUserContextAvailable(this.communicator) || this.findValueItem("OLAP member") != null) continue;
                    this.promptTypeModel.addElement(new ValueItem((Object)OLAP_MEMBER_NAME_PROMPT, (Object)"OLAP member"));
                    continue;
                }
                if ("SAS Library".equals(identifier)) {
                    if (!PromptUtility.isUserContextAvailable(this.communicator) || this.findValueItem("SAS Library") != null) continue;
                    this.promptTypeModel.addElement(new ValueItem((Object)SAS_LIBRARY_PROMPT, (Object)"SAS Library"));
                    continue;
                }
                if ("Text Range".equals(identifier)) {
                    this.promptTypeModel.addElement(new ValueItem((Object)TEXT_RANGE_PROMPT, (Object)"Text Range"));
                    continue;
                }
                if (identifier != null && customLabel != null) {
                    this.promptTypeModel.addElement(new ValueItem((Object)customLabel, (Object)identifier));
                    continue;
                }
                this.promptTypeModel.addElement(this.getDefaultValueItemForPromptInfoTypeClass(promptTypeInfo));
            }
        }
        this.promptTypeCombo.setModel((ComboBoxModel)this.promptTypeModel);
        promptTypeLabel.setLabelFor((Component)this.promptTypeCombo);
        comboPanel.add(promptTypeLabel);
        this.promptTypePanel.add((Component)this.promptTypeCombo);
        comboPanel.add(this.promptTypePanel);
        JPanel outerValuesPanel = new JPanel();
        AutoSizingGridLayout outerValuesLayout = new AutoSizingGridLayout(1, 2, 10, 5, true, false, true);
        outerValuesPanel.setLayout((LayoutManager)outerValuesLayout);
        JPanel listTypePanel = new JPanel();
        AutoSizingGridLayout listTypeLayout = new AutoSizingGridLayout(2, 1, 10, 5, true, false, true);
        listTypePanel.setLayout((LayoutManager)listTypeLayout);
        this.listTypeLabel = new JLabel(RB.getStringResource("populatingPromptMethod.txt"));
        this.listTypeCombo = new ComboBox();
        this.listTypeModel = new DefaultComboBoxModel();
        this.listTypeModel.addElement(new ValueItem((Object)NO_LIST, (Object)"User enters values"));
        this.listTypeModel.addElement(new ValueItem((Object)STATIC_LIST, (Object)"User selects values from a static list"));
        if (PromptUtility.isUserContextAvailable(this.communicator)) {
            this.listTypeModel.addElement(new ValueItem((Object)DYNAMIC_LIST, (Object)"User selects values from a dynamic list"));
        }
        this.listTypeCombo.setModel((ComboBoxModel)this.listTypeModel);
        this.listTypeLabel.setLabelFor((Component)this.listTypeCombo);
        listTypePanel.add(this.listTypeLabel);
        listTypePanel.add((Component)this.listTypeCombo);
        JPanel selectionModePanel = new JPanel();
        AutoSizingGridLayout selectionModeLayout = new AutoSizingGridLayout(2, 1, 10, 5, true, false, true);
        selectionModePanel.setLayout((LayoutManager)selectionModeLayout);
        this.selectionModeLabel = new JLabel(RB.getStringResource("selectionMode.txt"));
        this.selectionTypeCombo = new ComboBox();
        this.selectionModeModel = new DefaultComboBoxModel();
        this.selectionModeModel.addElement(new ValueItem((Object)SINGLE_VALUE, (Object)"Single value"));
        this.selectionModeModel.addElement(new ValueItem((Object)MULTIPLE_VALUES, (Object)"Multiple values"));
        this.selectionModeModel.addElement(new ValueItem((Object)MULTIPLE_ORDERED_VALUES, (Object)"Multiple ordered values"));
        this.selectionTypeCombo.setModel((ComboBoxModel)this.selectionModeModel);
        this.selectionTypeCombo.setEnabled(this.promptTypeSupportsMultipleValues((String)((ValueItem)this.promptTypeCombo.getSelectedItem()).getValue()));
        this.selectionModeLabel.setEnabled(this.selectionTypeCombo.isEnabled());
        this.selectionModeLabel.setLabelFor((Component)this.selectionTypeCombo);
        selectionModePanel.add(this.selectionModeLabel);
        selectionModePanel.add((Component)this.selectionTypeCombo);
        outerValuesPanel.add(listTypePanel);
        outerValuesPanel.add(selectionModePanel);
        commonComponentsPanel.add(comboPanel);
        commonComponentsPanel.add(outerValuesPanel);
        return commonComponentsPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.promptTypeCombo.removeActionListener((ActionListener)this);
        this.listTypeCombo.removeActionListener((ActionListener)this);
        this.selectionTypeCombo.removeActionListener((ActionListener)this);
        int selectionChange = this.selectionHasChanged();
        if (selectionChange > NO_PROMPT_CHANGE) {
            if (!this.communicator.isCurrentMapSelectorEnabled() && this.prompt != null && PromptUtility.isPromptTypeValidForPromptValueOperand(this.prompt) && selectionChange == SELECTION_TYPE_CHANGED) {
                String currentSelType = (String)((ValueItem)this.selectionTypeCombo.getSelectedItem()).getValue();
                if (!"Single value".equals(currentSelType)) {
                    PromptDataProviderInterface userDataProvider = this.communicator.getDataProvider();
                    PromptDataProviderInterface dataProvider = null;
                    boolean userDefinedDataProvider = false;
                    UserContextInterface userContext = this.communicator.getUserContext();
                    if (userDataProvider != null) {
                        dataProvider = userDataProvider;
                        userDefinedDataProvider = true;
                    } else if (userContext != null) {
                        dataProvider = new DataProvider(userContext);
                    }
                    PromptGroupInterface rootPromptGroup = this.communicator.getRootPromptGroup();
                    if (rootPromptGroup != null) {
                        Map dependentPrompts;
                        PromptValues promptValues = new PromptValues(rootPromptGroup, null);
                        DynamicPromptValueContext dynamicValueContext = new DynamicPromptValueContext((PromptValuesInterface)promptValues, rootPromptGroup, null, (DataProviderInterface)dataProvider);
                        PromptDefinitionInterface originalPrompt = this.communicator.getOriginalPrompt();
                        if (originalPrompt != null && (dependentPrompts = PromptUtility.getListOfDependentPrompts(originalPrompt, dynamicValueContext, this.communicator, this.getLocale())) != null && dependentPrompts.size() > 0) {
                            JFrame frame = Util.getParentFrame((Component)this);
                            int option = JOptionPane.showOptionDialog(frame, RB.getStringResource("multiValuedPromptChange.txt"), RB.getStringResource("changeNumberOfValues.txt"), -1, 2, null, CONFIRM_MESSAGE_DIALOG_OPTIONS, CONFIRM_MESSAGE_DIALOG_OPTIONS[0]);
                            if (option == 0) {
                                this.communicator.setDependentPrompts(dependentPrompts);
                            } else {
                                this.selectionTypeCombo.removeActionListener((ActionListener)this);
                                this.selectionTypeCombo.setSelectedItem((Object)this.findValueItemInModel("Single value", this.selectionModeModel));
                                this.selectionTypeSelectedItem = "Single value";
                                this.selectionTypeCombo.addActionListener((ActionListener)this);
                            }
                        }
                    }
                    try {
                        if (dataProvider != null && !userDefinedDataProvider) {
                            ((DataProvider)dataProvider).close();
                        }
                    }
                    catch (ServerConnectionException serverConnectionException) {}
                } else {
                    this.communicator.clearDependentPrompts();
                }
            }
            PromptDefinitionInterface promptFromPanel = this.getPromptDefinition(true);
            UserInfoCleanupInterface userInfoValidator = this.communicator.getUserInfoCleanup();
            if (selectionChange == PROMPT_TYPE_CHANGED && userInfoValidator != null && promptFromPanel instanceof MutablePromptDefinitionInterface) {
                userInfoValidator.cleanupUserInfo((MutablePromptDefinitionInterface)promptFromPanel, 1);
                if (promptFromPanel != null && promptFromPanel.getUserInfo() != null && promptFromPanel.isDefaultValueSet()) {
                    promptFromPanel.clearDefaultValue();
                }
            }
            PromptUtility.copyPropertiesToCommunicator(this.communicator, promptFromPanel);
            Object listType = ((ValueItem)this.listTypeCombo.getSelectedItem()).getValue();
            if (e.getSource() == this.listTypeCombo && (listType == "User selects values from a static list" || listType == "User selects values from a dynamic list")) {
                Map map = this.communicator.getPromptProperties();
                map.put("allowUserValues", this.currentAllowUserValuesForList ? Boolean.TRUE : Boolean.FALSE);
            }
            this.panelHolderPanel.removeAll();
            this.createCustomPanel();
            this.customPanel.addPropertyChangeListener(this);
            this.panelHolderPanel.add(this.customPanel);
            this.customPanel.revalidate();
            this.setContentsValid(true);
        }
        this.promptTypeCombo.addActionListener((ActionListener)this);
        this.listTypeCombo.addActionListener((ActionListener)this);
        this.selectionTypeCombo.addActionListener((ActionListener)this);
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return ((GetPromptDefinitionInterface)((Object)this.customPanel)).getPromptDefinition();
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        if (this.customPanel instanceof GetPromptDefinitionWithErrorSuppressionOptionInterface) {
            return ((GetPromptDefinitionWithErrorSuppressionOptionInterface)((Object)this.customPanel)).getPromptDefinition(suppressErrors);
        }
        return ((GetPromptDefinitionInterface)((Object)this.customPanel)).getPromptDefinition();
    }

    private int selectionHasChanged() {
        String currentPromptType = (String)((ValueItem)this.promptTypeCombo.getSelectedItem()).getValue();
        if (!this.promptTypeSelectedItem.equals(currentPromptType)) {
            this.removeUnknownPromptType();
            this.firePropertyChange("selectedItem", this.promptTypeSelectedItem, currentPromptType);
            this.validateListAndSelectionCombos(currentPromptType);
            return PROMPT_TYPE_CHANGED;
        }
        if (!this.selectionTypeSelectedItem.equals(((ValueItem)this.selectionTypeCombo.getSelectedItem()).getValue())) {
            this.enableSelectionTypeControl(true);
            return SELECTION_TYPE_CHANGED;
        }
        if (!this.listTypeSelectedItem.equals(((ValueItem)this.listTypeCombo.getSelectedItem()).getValue())) {
            if (this.listTypeSelectedItem.equals("User selects values from a static list") || this.listTypeSelectedItem.equals("User selects values from a dynamic list")) {
                PromptUtility.copyPropertiesToCommunicator(this.communicator, this.getPromptDefinition(true));
                Map map = this.communicator.getPromptProperties();
                this.currentAllowUserValuesForList = (Boolean)map.get("allowUserValues");
            }
            this.firePropertyChange("listType", this.listTypeSelectedItem, ((ValueItem)this.listTypeCombo.getSelectedItem()).getValue());
            return LIST_TYPE_CHANGED;
        }
        return NO_PROMPT_CHANGE;
    }

    private void validateListAndSelectionCombos(String currentPromptType) {
        boolean supportsDynamicValues = PromptUtility.promptTypeSupportsDynamicValues(currentPromptType);
        if (!supportsDynamicValues) {
            this.listTypeCombo.removeActionListener((ActionListener)this);
            this.listTypeCombo.setSelectedItem((Object)this.findValueItemInModel("User enters values", this.listTypeModel));
            this.listTypeCombo.setEnabled(false);
            this.listTypeLabel.setEnabled(false);
            this.listTypeCombo.addActionListener((ActionListener)this);
        } else {
            this.listTypeCombo.setEnabled(true);
            this.listTypeLabel.setEnabled(true);
        }
        if (this.promptTypesProvider == null) {
            boolean supportsMutipleValuesOptions = PromptUtility.promptSupportsMultipleValues(currentPromptType);
            if (!supportsMutipleValuesOptions) {
                this.selectionTypeCombo.removeActionListener((ActionListener)this);
                this.selectionTypeCombo.setSelectedItem((Object)this.findValueItemInModel("Single value", this.selectionModeModel));
                this.selectionTypeCombo.addActionListener((ActionListener)this);
            }
            this.listTypeCombo.setEnabled(supportsDynamicValues);
            this.listTypeLabel.setEnabled(supportsDynamicValues);
            this.enableSelectionTypeControl(supportsMutipleValuesOptions);
        } else if (!this.promptTypeSupportsMultipleValues(currentPromptType)) {
            this.selectionTypeCombo.removeActionListener((ActionListener)this);
            this.selectionTypeCombo.setSelectedItem((Object)this.findValueItemInModel("Single value", this.selectionModeModel));
            this.selectionTypeCombo.addActionListener((ActionListener)this);
            this.enableSelectionTypeControl(false);
        } else {
            this.enableSelectionTypeControl(true);
        }
    }

    private boolean promptTypeSupportsMultipleValues(String currentPromptType) {
        if (this.promptTypesProvider != null) {
            List supportedTypes = this.promptTypesProvider.getSupportedTypes();
            boolean supportsMultipleValues = true;
            int promptTypeInfoIndex = -1;
            if ("Text".equals(currentPromptType)) {
                promptTypeInfoIndex = supportedTypes.indexOf(PromptTypeInfoFactory.TEXT_PROMPT_TYPE_INFO);
            } else {
                if ("Text Range".equals(currentPromptType)) {
                    return false;
                }
                if ("Numeric".equals(currentPromptType)) {
                    promptTypeInfoIndex = supportedTypes.indexOf(PromptTypeInfoFactory.DOUBLE_PROMPT_TYPE_INFO);
                } else {
                    if ("Numeric Range".equals(currentPromptType)) {
                        return false;
                    }
                    if ("Date".equals(currentPromptType)) {
                        promptTypeInfoIndex = supportedTypes.indexOf(PromptTypeInfoFactory.DATE_PROMPT_TYPE_INFO);
                    } else {
                        if ("Date Range".equals(currentPromptType)) {
                            return false;
                        }
                        if ("Time".equals(currentPromptType)) {
                            return false;
                        }
                        if ("Time Range".equals(currentPromptType)) {
                            return false;
                        }
                        if ("Timestamp".equals(currentPromptType)) {
                            return false;
                        }
                        if ("Timestamp Range".equals(currentPromptType)) {
                            return false;
                        }
                        if ("Color".equals(currentPromptType)) {
                            return false;
                        }
                        if ("Data Source".equals(currentPromptType)) {
                            return false;
                        }
                        if ("Data Source Column".equals(currentPromptType)) {
                            promptTypeInfoIndex = supportedTypes.indexOf(PromptTypeInfoFactory.DATASOURCE_COLUMN_PROMPT_TYPE_INFO);
                        } else {
                            if ("File Name".equals(currentPromptType)) {
                                return false;
                            }
                            if ("Text Range".equals(currentPromptType)) {
                                return false;
                            }
                            if ("OLAP member".equals(currentPromptType)) {
                                promptTypeInfoIndex = supportedTypes.indexOf(PromptTypeInfoFactory.OLAP_MEMBER_NAME_PROMPT_INFO);
                            } else {
                                for (PromptTypeInfoInterface promptTypeInfo : supportedTypes) {
                                    String id;
                                    if (promptTypeInfo == null || (id = promptTypeInfo.getIdentifier()) == null || !id.equals(currentPromptType)) continue;
                                    supportsMultipleValues = promptTypeInfo.supportMultipleValues();
                                    return supportsMultipleValues;
                                }
                                return true;
                            }
                        }
                    }
                }
            }
            supportsMultipleValues = promptTypeInfoIndex != -1 ? ((PromptTypeInfoInterface)supportedTypes.get(promptTypeInfoIndex)).supportMultipleValues() : false;
            return supportsMultipleValues;
        }
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("contentsValid".equals(evt.getPropertyName())) {
            this.setContentsValid((Boolean)evt.getNewValue());
        } else if ("dataSourceValid".equals(evt.getPropertyName())) {
            this.firePropertyChange("dataSourceValid", evt.getOldValue(), evt.getNewValue());
        } else if ("dataSourceChanged".equals(evt.getPropertyName())) {
            this.firePropertyChange("dataSourceChanged", evt.getOldValue(), evt.getNewValue());
        } else if ("valueProviderUpdateNeeded".equals(evt.getPropertyName())) {
            this.firePropertyChange("valueProviderUpdateNeeded", evt.getOldValue(), evt.getNewValue());
        } else if ("dataItemChanged".equals(evt.getPropertyName())) {
            this.firePropertyChange("dataItemChanged", evt.getOldValue(), evt.getNewValue());
        } else if ("disableSelectionTypeControl".equals(evt.getPropertyName())) {
            this.selectionTypeCombo.removeActionListener((ActionListener)this);
            this.selectionTypeCombo.setEnabled((Boolean)evt.getNewValue() == false);
            this.selectionTypeCombo.addActionListener((ActionListener)this);
        } else if ("errorPanel".equals(evt.getPropertyName())) {
            this.firePropertyChange("errorPanel", evt.getOldValue(), evt.getNewValue());
        }
    }

    JPanel getCustomPanel() {
        return this.customPanel;
    }

    @Override
    public boolean isContentsValid() {
        if (this.customPanel != null && this.customPanel instanceof PanelInterface) {
            return ((PanelInterface)this.customPanel).isContentsValid();
        }
        return true;
    }

    @Override
    public void setContentsValid(boolean newValue) {
        if (newValue != this.contentsValid) {
            this.contentsValid = newValue;
            this.firePropertyChange("contentsValid", !this.contentsValid, this.contentsValid);
        }
    }

    @Override
    public String getHelpID() {
        Config.Element stateElement = this.getState();
        if (stateElement == null) {
            return super.getHelpID();
        }
        String defaultHelpTopicId = PromptTypeAndValuesConfigHelper.getDefaultHelpKey(stateElement);
        if (defaultHelpTopicId == null) {
            Map defaultHelpKeys = this.communicator.getDefaultHelpKeys();
            return (String)defaultHelpKeys.get(stateElement);
        }
        if (this.config == null) {
            return defaultHelpTopicId;
        }
        return this.config.getHelpID(stateElement, defaultHelpTopicId);
    }

    @Override
    public String getHelpProduct() {
        Config.Element stateElement = this.getState();
        if (stateElement == null) {
            return super.getHelpProduct();
        }
        if (this.config == null) {
            return super.getHelpProduct();
        }
        return this.config.getHelpProduct(stateElement, super.getHelpProduct());
    }

    public Config.Element getState() {
        if (this.promptTypeSelectedItem.equals(TEXT_PROMPT)) {
            if (this.listTypeSelectedItem == "User selects values from a static list") {
                if (this.selectionTypeSelectedItem == "Single value") {
                    return PromptTypeAndValuesConfigHelper.TEXT_STATIC_SINGLE;
                }
                if (this.selectionTypeSelectedItem == "Multiple values") {
                    return PromptTypeAndValuesConfigHelper.TEXT_STATIC_MULTI;
                }
                if (this.selectionTypeSelectedItem == "Multiple ordered values") {
                    return PromptTypeAndValuesConfigHelper.TEXT_STATIC_MULTIORDERED;
                }
            } else if (this.listTypeSelectedItem == "User selects values from a dynamic list") {
                if (this.selectionTypeSelectedItem == "Single value") {
                    return PromptTypeAndValuesConfigHelper.TEXT_DYNAMIC_SINGLE;
                }
                if (this.selectionTypeSelectedItem == "Multiple values") {
                    return PromptTypeAndValuesConfigHelper.TEXT_DYNAMIC_MULTI;
                }
                if (this.selectionTypeSelectedItem == "Multiple ordered values") {
                    return PromptTypeAndValuesConfigHelper.TEXT_DYNAMIC_MULTIORDERED;
                }
            } else {
                if (this.selectionTypeSelectedItem == "Single value") {
                    Object selectedTextType = ((TextTypePanel)((UserEntryPanel)this.customPanel).getPromptTypePanel()).getTextTypeCombo().getSelectedItem();
                    if (selectedTextType == TextTypePanel.MULTI_LINE) {
                        return PromptTypeAndValuesConfigHelper.TEXT_ENTER_SINGLE_MULTILINE;
                    }
                    if (selectedTextType == TextTypePanel.MASKED_SINGLE_LINE) {
                        return PromptTypeAndValuesConfigHelper.TEXT_ENTER_SINGLE_MASKED;
                    }
                    return PromptTypeAndValuesConfigHelper.TEXT_ENTER_SINGLE_SINGLELINE;
                }
                if (this.selectionTypeSelectedItem == "Multiple values") {
                    return PromptTypeAndValuesConfigHelper.TEXT_ENTER_MULTI;
                }
                if (this.selectionTypeSelectedItem == "Multiple ordered values") {
                    return PromptTypeAndValuesConfigHelper.TEXT_ENTER_MULTIORDERED;
                }
            }
        } else if (this.promptTypeSelectedItem.equals("Numeric")) {
            if (this.listTypeSelectedItem == "User selects values from a static list") {
                if (this.selectionTypeSelectedItem == "Single value") {
                    if (this.isIntegersOnly()) {
                        return PromptTypeAndValuesConfigHelper.NUMERIC_STATIC_SINGLE_INTEGERONLY;
                    }
                    return PromptTypeAndValuesConfigHelper.NUMERIC_STATIC_SINGLE;
                }
                if (this.selectionTypeSelectedItem == "Multiple values") {
                    if (this.isIntegersOnly()) {
                        return PromptTypeAndValuesConfigHelper.NUMERIC_STATIC_MULTI_INTEGERONLY;
                    }
                    return PromptTypeAndValuesConfigHelper.NUMERIC_STATIC_MULTI;
                }
                if (this.selectionTypeSelectedItem == "Multiple ordered values") {
                    if (this.isIntegersOnly()) {
                        return PromptTypeAndValuesConfigHelper.NUMERIC_STATIC_MULTIORDERED_INTEGERONLY;
                    }
                    return PromptTypeAndValuesConfigHelper.NUMERIC_STATIC_MULTIORDERED;
                }
            } else if (this.listTypeSelectedItem == "User selects values from a dynamic list") {
                if (this.selectionTypeSelectedItem == "Single value") {
                    if (this.isIntegersOnly()) {
                        return PromptTypeAndValuesConfigHelper.NUMERIC_DYNAMIC_SINGLE_INTEGERONLY;
                    }
                    return PromptTypeAndValuesConfigHelper.NUMERIC_DYNAMIC_SINGLE;
                }
                if (this.selectionTypeSelectedItem == "Multiple values") {
                    if (this.isIntegersOnly()) {
                        return PromptTypeAndValuesConfigHelper.NUMERIC_DYNAMIC_MULTI_INTEGERONLY;
                    }
                    return PromptTypeAndValuesConfigHelper.NUMERIC_DYNAMIC_MULTI;
                }
                if (this.selectionTypeSelectedItem == "Multiple ordered values") {
                    if (this.isIntegersOnly()) {
                        return PromptTypeAndValuesConfigHelper.NUMERIC_DYNAMIC_MULTIORDERED_INTEGERONLY;
                    }
                    return PromptTypeAndValuesConfigHelper.NUMERIC_DYNAMIC_MULTIORDERED;
                }
            } else {
                if (this.selectionTypeSelectedItem == "Single value") {
                    if (this.isIntegersOnly()) {
                        return PromptTypeAndValuesConfigHelper.NUMERIC_ENTER_SINGLE_INTEGERONLY;
                    }
                    return PromptTypeAndValuesConfigHelper.NUMERIC_ENTER_SINGLE;
                }
                if (this.selectionTypeSelectedItem == "Multiple values") {
                    if (this.isIntegersOnly()) {
                        return PromptTypeAndValuesConfigHelper.NUMERIC_ENTER_MULTI_INTEGERONLY;
                    }
                    return PromptTypeAndValuesConfigHelper.NUMERIC_ENTER_MULTI;
                }
                if (this.selectionTypeSelectedItem == "Multiple ordered values") {
                    if (this.isIntegersOnly()) {
                        return PromptTypeAndValuesConfigHelper.NUMERIC_ENTER_MULTI_INTEGERONLY;
                    }
                    return PromptTypeAndValuesConfigHelper.NUMERIC_ENTER_MULTIORDERED;
                }
            }
        } else {
            if (this.promptTypeSelectedItem.equals("Numeric Range")) {
                if (this.isIntegersOnly()) {
                    return PromptTypeAndValuesConfigHelper.NUMERICRANGE_INTEGERONLY;
                }
                return PromptTypeAndValuesConfigHelper.NUMERICRANGE;
            }
            if (this.promptTypeSelectedItem.equals("Date")) {
                if (this.listTypeSelectedItem == "User selects values from a static list") {
                    if (this.selectionTypeSelectedItem == "Single value") {
                        return PromptTypeAndValuesConfigHelper.DATE_STATIC_SINGLE;
                    }
                    if (this.selectionTypeSelectedItem == "Multiple values") {
                        return PromptTypeAndValuesConfigHelper.DATE_STATIC_MULTI;
                    }
                    if (this.selectionTypeSelectedItem == "Multiple ordered values") {
                        return PromptTypeAndValuesConfigHelper.DATE_STATIC_MULTIORDERED;
                    }
                } else if (this.listTypeSelectedItem == "User selects values from a dynamic list") {
                    if (this.selectionTypeSelectedItem == "Single value") {
                        return PromptTypeAndValuesConfigHelper.DATE_DYNAMIC_SINGLE;
                    }
                    if (this.selectionTypeSelectedItem == "Multiple values") {
                        return PromptTypeAndValuesConfigHelper.DATE_DYNAMIC_MULTI;
                    }
                    if (this.selectionTypeSelectedItem == "Multiple ordered values") {
                        return PromptTypeAndValuesConfigHelper.DATE_DYNAMIC_MULTIORDERED;
                    }
                } else {
                    if (this.selectionTypeSelectedItem == "Single value") {
                        return PromptTypeAndValuesConfigHelper.DATE_ENTER_SINGLE;
                    }
                    if (this.selectionTypeSelectedItem == "Multiple values") {
                        return PromptTypeAndValuesConfigHelper.DATE_ENTER_MULTI;
                    }
                    if (this.selectionTypeSelectedItem == "Multiple ordered values") {
                        return PromptTypeAndValuesConfigHelper.DATE_ENTER_MULTIORDERED;
                    }
                }
            } else if (this.promptTypeSelectedItem.equals("Data Source Column")) {
                if (this.selectionTypeSelectedItem == "Single value") {
                    return PromptTypeAndValuesConfigHelper.DATASOURCEITEM;
                }
                if (this.selectionTypeSelectedItem == "Multiple values") {
                    return PromptTypeAndValuesConfigHelper.DATASOURCEITEM_MULTI;
                }
                if (this.selectionTypeSelectedItem == "Multiple ordered values") {
                    return PromptTypeAndValuesConfigHelper.DATASOURCEITEM_MULTIORDERED;
                }
            } else {
                if (this.promptTypeSelectedItem.equals("OLAP member")) {
                    if (this.selectionTypeSelectedItem == "Single value") {
                        return PromptTypeAndValuesConfigHelper.OLAP_MEMBER_STANDARD;
                    }
                    return PromptTypeAndValuesConfigHelper.OLAP_MEMBER_MULTI;
                }
                if (this.promptTypeSelectedItem.equals("Date Range")) {
                    return PromptTypeAndValuesConfigHelper.DATERANGE;
                }
                if (this.promptTypeSelectedItem.equals("Time")) {
                    return PromptTypeAndValuesConfigHelper.TIME;
                }
                if (this.promptTypeSelectedItem.equals("Time Range")) {
                    return PromptTypeAndValuesConfigHelper.TIMERANGE;
                }
                if (this.promptTypeSelectedItem.equals("Timestamp")) {
                    return PromptTypeAndValuesConfigHelper.TIMESTAMP;
                }
                if (this.promptTypeSelectedItem.equals("Timestamp Range")) {
                    return PromptTypeAndValuesConfigHelper.TIMESTAMPRANGE;
                }
                if (this.promptTypeSelectedItem.equals("Color")) {
                    return PromptTypeAndValuesConfigHelper.COLOR;
                }
                if (this.promptTypeSelectedItem.equals("Data Source")) {
                    return PromptTypeAndValuesConfigHelper.DATASOURCE;
                }
                if (this.promptTypeSelectedItem.equals("Text Range")) {
                    return PromptTypeAndValuesConfigHelper.TEXTRANGE;
                }
                if (this.promptTypeSelectedItem.equals("File Name")) {
                    return PromptTypeAndValuesConfigHelper.INPUT_FILENAME;
                }
                if (this.promptTypeSelectedItem.equals("File Name")) {
                    return PromptTypeAndValuesConfigHelper.OUTPUT_FILENAME;
                }
                if (this.promptTypeSelectedItem.equals("SAS Library")) {
                    return PromptTypeAndValuesConfigHelper.DATA_LIBRARY;
                }
                if (this.promptTypeSelectedItem.equals("Unknown Prompt Type")) {
                    return PromptTypeAndValuesConfigHelper.UNKNOWN_PROMPT;
                }
            }
        }
        Map stateElements = this.communicator.getConfigStateElements();
        return (Config.Element)stateElements.get(this.promptTypeSelectedItem);
    }

    private boolean isIntegersOnly() {
        if (this.customPanel instanceof BaseNumericRangePanel) {
            BaseNumericRangePanel userEntrycustomPanel = (BaseNumericRangePanel)this.customPanel;
            return userEntrycustomPanel.getIntegersOnlyCheckBox().isSelected();
        }
        if (this.customPanel instanceof UserEntryPanel) {
            UserEntryPanel userEntrycustomPanel = (UserEntryPanel)this.customPanel;
            JPanel numericPromptPanel = userEntrycustomPanel.getPromptTypePanel();
            if (numericPromptPanel instanceof BaseNumericPromptPanel) {
                return ((BaseNumericPromptPanel)userEntrycustomPanel.getPromptTypePanel()).getIntegersOnlyCheckBox().isSelected();
            }
            if (numericPromptPanel instanceof BaseNumericRangePanel) {
                return ((BaseNumericRangePanel)userEntrycustomPanel.getPromptTypePanel()).getIntegersOnlyCheckBox().isSelected();
            }
        }
        return false;
    }

    private ValueItem getDefaultValueItemForPromptInfoTypeClass(PromptTypeInfoInterface promptTypeInfo) {
        Class c = promptTypeInfo.getPromptDefinitionType();
        if (c == TextDefinition.class) {
            return new ValueItem((Object)TEXT_PROMPT, (Object)"Text");
        }
        if (c == IntegerDefinition.class || c == DoubleDefinition.class) {
            return new ValueItem((Object)NUMERIC_PROMPT, (Object)"Numeric");
        }
        if (c == IntegerRangeDefinition.class || c == DoubleRangeDefinition.class) {
            return new ValueItem((Object)NUMERIC_RANGE_PROMPT, (Object)"Numeric Range");
        }
        if (c == DateDefinition.class) {
            return new ValueItem((Object)DATE_PROMPT, (Object)"Date");
        }
        if (c == DateRangeDefinition.class) {
            return new ValueItem((Object)DATE_RANGE_PROMPT, (Object)"Date Range");
        }
        if (c == DataSourceDefinition.class) {
            return new ValueItem((Object)DATASOURCE_PROMPT, (Object)"Data Source");
        }
        if (c == DataSourceColumnDefinition.class) {
            return new ValueItem((Object)DATASOURCE_COLUMN_PROMPT, (Object)"Data Source Column");
        }
        if (c == InputFileDefinition.class || c == OutputFileDefinition.class) {
            return new ValueItem((Object)FILENAME_PROMPT, (Object)"File Name");
        }
        if (c == ColorDefinition.class) {
            return new ValueItem((Object)COLOR_PROMPT, (Object)"Color");
        }
        if (c == StringRangeDefinition.class) {
            return new ValueItem((Object)TEXT_RANGE_PROMPT, (Object)"Text Range");
        }
        if (c == OLAPMemberNameDefinition.class) {
            return new ValueItem((Object)OLAP_MEMBER_NAME_PROMPT, (Object)"OLAP member");
        }
        if (c == SASLibraryDefinition.class) {
            return new ValueItem((Object)SAS_LIBRARY_PROMPT, (Object)"SAS Library");
        }
        return new ValueItem((Object)TEXT_PROMPT, (Object)"Text");
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }
}

