/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.shared.SharedPromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.shared.SharedPromptGroup;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.swing.visuals.treetable.TreeTableRow;
import com.sas.visuals.Resources;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class PromptObjectRenderer
extends DefaultTreeCellRenderer {
    private ImageIcon promptIcon = new ImageIcon(Resources.getImage((String)"GIF_16/Prompt"));
    private ImageIcon sharedPromptIcon = new ImageIcon(Resources.getImage((String)"GIF_16/Prompt_shared"));
    private ImageIcon groupIcon = new ImageIcon(Resources.getImage((String)"GIF_16/PromptGroup"));
    private ImageIcon sharedGroupIcon = new ImageIcon(Resources.getImage((String)"GIF_16/PromptGroup_shared"));
    private String promptIconToolTipText = RB.getStringResource("promptIconToolTipText.txt");
    private String sharedPromptIconToolTipText = RB.getStringResource("sharedPromptIconToolTipText.txt");
    private String groupIconToolTipText = RB.getStringResource("groupIconToolTipText.txt");
    private String sharedGroupIconToolTipText = RB.getStringResource("sharedGroupIconToolTipText.txt");
    private static final long serialVersionUID = 3257563988660598326L;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        this.setToolTipText(null);
        if (value instanceof TreeTableRow) {
            Object userObject = ((TreeTableRow)value).getUserObject();
            if (userObject instanceof PromptGroupInterface) {
                if (userObject instanceof SharedPromptGroup) {
                    this.setIcon(this.sharedGroupIcon);
                    this.setToolTipText(this.sharedGroupIconToolTipText);
                } else {
                    this.setIcon(this.groupIcon);
                    this.setToolTipText(this.groupIconToolTipText);
                }
                this.setText(((PromptGroupInterface)userObject).getPromptGroupLabel(Locale.getDefault()));
            } else if (userObject instanceof PromptDefinitionInterface) {
                if (userObject instanceof SharedPromptDefinitionInterface) {
                    this.setIcon(this.sharedPromptIcon);
                    this.setToolTipText(this.sharedPromptIconToolTipText);
                } else {
                    this.setIcon(this.promptIcon);
                    this.setToolTipText(this.promptIconToolTipText);
                }
                String label = ((PromptDefinitionInterface)userObject).getPromptLabel(Locale.getDefault());
                if (label != null && label.length() > 0) {
                    this.setText(label);
                } else {
                    this.setText(((PromptDefinitionInterface)userObject).getPromptName());
                }
            }
            return this;
        }
        return this;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        int x = e.getX();
        Icon icon = this.getIcon();
        if (icon != null && x > -2 && x < icon.getIconWidth()) {
            return this.getToolTipText();
        }
        return null;
    }
}

