/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.shared.SharedPromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.shared.SharedPromptGroup;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.prompts.visuals.swing.designtime.ValidatePromptNameInterface;
import com.sas.swing.visuals.treetable.TreeTableModel;
import com.sas.swing.visuals.treetable.TreeTableRow;
import com.sas.swing.visuals.util.Util;
import com.sas.visuals.Resources;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class PromptObjectNameValidatorRenderer
extends DefaultTreeCellRenderer {
    private ImageIcon promptIcon = new ImageIcon(Resources.getImage((String)"GIF_16/Prompt"));
    private ImageIcon sharedPromptIcon = new ImageIcon(Resources.getImage((String)"GIF_16/Prompt_shared"));
    private ImageIcon groupIcon = new ImageIcon(Resources.getImage((String)"GIF_16/PromptGroup"));
    private ImageIcon sharedGroupIcon = new ImageIcon(Resources.getImage((String)"GIF_16/PromptGroup_shared"));
    private String promptIconToolTipText;
    private String sharedPromptIconToolTipText;
    private String groupIconToolTipText;
    private String sharedGroupIconToolTipText;
    private String groupErrorIconToolTipText;
    private String sharedGroupErrorIconToolTipText;
    private String promptMissingResourceIconToolTipText;
    private String groupMissingResourceIconToolTipText;
    private ValidatePromptNameInterface validator;
    private Map missingResources;
    private ImageIcon promptWarningIcon = new ImageIcon(Resources.getImage((String)"Error_overlay.gif", (int)16));
    private PropertiesCommunicator communicator;
    private PromptGroupInterface rootPromptGroup;
    private static final long serialVersionUID = 3257563988660598326L;

    public PromptObjectNameValidatorRenderer() {
        this.promptIconToolTipText = RB.getStringResource("promptIconToolTipText.txt");
        this.sharedPromptIconToolTipText = RB.getStringResource("sharedPromptIconToolTipText.txt");
        this.groupIconToolTipText = RB.getStringResource("groupIconToolTipText.txt");
        this.sharedGroupIconToolTipText = RB.getStringResource("sharedGroupIconToolTipText.txt");
        this.groupErrorIconToolTipText = RB.getStringResource("groupErrorIconToolTipText.txt");
        this.sharedGroupErrorIconToolTipText = RB.getStringResource("sharedGroupErrorIconToolTipText.txt");
        this.promptMissingResourceIconToolTipText = RB.getStringResource("unavailableResourcesForPrompt.txt");
        this.groupMissingResourceIconToolTipText = RB.getStringResource("unavailableResourcesForGroup.txt");
    }

    public PromptObjectNameValidatorRenderer(ValidatePromptNameInterface validator, Map missingResources) {
        this();
        this.validator = validator;
        this.missingResources = missingResources;
    }

    public PromptObjectNameValidatorRenderer(PropertiesCommunicator communicator, Map missingResources) {
        this();
        this.communicator = communicator;
        this.missingResources = missingResources;
        if (communicator != null) {
            this.rootPromptGroup = communicator.getRootPromptGroup();
            this.validator = communicator.getNameValidator();
        }
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        this.setToolTipText(null);
        if (value instanceof TreeTableRow) {
            Object userObject = ((TreeTableRow)value).getUserObject();
            if (userObject instanceof PromptGroupInterface) {
                if (userObject instanceof SharedPromptGroup) {
                    this.setIcon(this.sharedGroupIcon);
                    this.setToolTipText(this.sharedGroupIconToolTipText);
                } else {
                    this.setIcon(this.groupIcon);
                    this.setToolTipText(this.groupIconToolTipText);
                }
                this.setText(((PromptGroupInterface)userObject).getPromptGroupLabel(Locale.getDefault()));
            } else if (userObject instanceof PromptDefinitionInterface) {
                if (userObject instanceof SharedPromptDefinitionInterface) {
                    this.setIcon(this.sharedPromptIcon);
                    this.setToolTipText(this.sharedPromptIconToolTipText);
                } else {
                    this.setIcon(this.promptIcon);
                    this.setToolTipText(this.promptIconToolTipText);
                }
                String label = ((PromptDefinitionInterface)userObject).getPromptLabel(Locale.getDefault());
                if (label != null && label.length() > 0) {
                    this.setText(label);
                } else {
                    this.setText(((PromptDefinitionInterface)userObject).getPromptName());
                }
            }
            this.checkNames(userObject, (TreeTableRow)value, row, hasFocus);
            return this;
        }
        return this;
    }

    private void checkNames(Object value, TreeTableRow table, int row, boolean hasFocus) {
        if (table == null) {
            return;
        }
        TreeTableModel model = table.getTreeModel();
        if (model == null) {
            return;
        }
        String toolTipText = null;
        if (value instanceof PromptGroupInterface) {
            if (this.missingResources != null && this.missingResources.containsKey(value)) {
                Icon compIcon;
                if (value instanceof SharedPromptGroup) {
                    compIcon = Util.getCompoundIcon((Icon)this.sharedGroupIcon, (Icon)this.promptWarningIcon);
                    toolTipText = this.groupMissingResourceIconToolTipText;
                } else {
                    compIcon = Util.getCompoundIcon((Icon)this.groupIcon, (Icon)this.promptWarningIcon);
                    toolTipText = this.groupMissingResourceIconToolTipText;
                }
                this.setIcon(compIcon);
            }
            List prompts = ((PromptGroupInterface)value).getPromptDefinitions(true);
            for (PromptDefinitionInterface prompt : prompts) {
                Icon compIcon;
                String name = prompt.getPromptName();
                Collection errors = null;
                boolean hasGroupInError = false;
                boolean hasMissingResources = false;
                if (this.missingResources != null && this.missingResources.containsKey(prompt)) {
                    hasMissingResources = true;
                }
                if (name != null && this.validator != null && (errors = this.communicator.getInvalidPromptsAndGroups()).contains(value)) {
                    hasGroupInError = true;
                }
                if (!hasGroupInError && !hasMissingResources) continue;
                if (value instanceof SharedPromptGroup) {
                    compIcon = Util.getCompoundIcon((Icon)this.sharedGroupIcon, (Icon)this.promptWarningIcon);
                    toolTipText = this.sharedGroupErrorIconToolTipText;
                } else {
                    compIcon = Util.getCompoundIcon((Icon)this.groupIcon, (Icon)this.promptWarningIcon);
                    toolTipText = this.groupErrorIconToolTipText;
                }
                this.setIcon(compIcon);
                break;
            }
        } else if (value instanceof PromptDefinitionInterface) {
            int rowCount = model.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                if (i == row) continue;
                PromptDefinitionInterface prompt = (PromptDefinitionInterface)value;
                String name = prompt.getPromptName();
                Collection errors = null;
                boolean hasMissingResources = false;
                boolean hasPromptInError = false;
                List invalidDataItemPrompts = new ArrayList();
                if (this.communicator != null && (invalidDataItemPrompts = this.communicator.getInvalidDataItemPrompts()) == null) {
                    invalidDataItemPrompts = new ArrayList();
                }
                if (this.missingResources != null && this.missingResources.containsKey(prompt)) {
                    hasMissingResources = true;
                }
                if (name != null && this.validator != null) {
                    errors = this.communicator.getInvalidPromptsAndGroups();
                    if (errors.contains(value)) {
                        hasPromptInError = true;
                    }
                } else if (invalidDataItemPrompts.contains(prompt)) {
                    hasMissingResources = true;
                }
                if (!hasPromptInError && !hasMissingResources) continue;
                Icon compIcon = value instanceof SharedPromptDefinitionInterface ? Util.getCompoundIcon((Icon)this.sharedPromptIcon, (Icon)this.promptWarningIcon) : Util.getCompoundIcon((Icon)this.promptIcon, (Icon)this.promptWarningIcon);
                this.setIcon(compIcon);
                toolTipText = hasMissingResources ? this.promptMissingResourceIconToolTipText : this.communicator.getPromptToolTipText((PromptDefinitionInterface)value);
                break;
            }
        }
        if (toolTipText != null) {
            this.setToolTipText(toolTipText);
        }
    }
}

