/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.PromptUtil;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.util.ValueItem;
import com.sas.visuals.Resources;
import java.awt.Component;
import java.util.List;
import java.util.Locale;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;

class PromptObjectComboBoxRenderer
extends DefaultListCellRenderer {
    private ImageIcon directoryIcon = new ImageIcon(Resources.getImage((String)"Folder"));
    private ImageIcon fileIcon = new ImageIcon(Resources.getImage((String)"File"));
    private ImageIcon promptIcon = new ImageIcon(Resources.getImage((String)"Prompt", (int)16));
    private PromptGroupInterface rootPromptGroup;
    private Object editObject;
    private Locale locale;
    private int indentLevel;
    private boolean needsSpecialIndenting;
    private static final long serialVersionUID = 1L;

    public PromptObjectComboBoxRenderer() {
    }

    public PromptObjectComboBoxRenderer(PromptGroupInterface rootPromptGroup, Object editObject) {
        this.rootPromptGroup = rootPromptGroup;
        this.editObject = editObject;
    }

    PromptObjectComboBoxRenderer(PromptGroupInterface rootPromptGroup, Object editObject, Locale locale) {
        this.rootPromptGroup = rootPromptGroup;
        this.editObject = editObject;
        this.locale = locale;
    }

    int getIndentLevel() {
        return this.indentLevel;
    }

    void setIndentLevel(int indentLevel) {
        this.indentLevel = indentLevel;
    }

    boolean hasSpecialIndenting() {
        return this.needsSpecialIndenting;
    }

    void setSpecialIndenting() {
        this.needsSpecialIndenting = this.needsSpecialIndenting;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        this.setIcon(this.directoryIcon);
        if (value instanceof ValueItem) {
            Object promptObject = ((ValueItem)value).getValue();
            List groups = null;
            if (promptObject instanceof PromptGroupInterface) {
                groups = PromptUtil.getPathToPromptGroup((PromptGroupInterface)this.rootPromptGroup, (PromptGroupInterface)((PromptGroupInterface)promptObject));
            } else if (promptObject instanceof PromptDefinitionInterface) {
                PromptGroupInterface parentPromptGroup = this.rootPromptGroup.findPromptSubgroup((PromptDefinitionInterface)promptObject);
                groups = PromptUtil.getPathToPromptGroup((PromptGroupInterface)this.rootPromptGroup, (PromptGroupInterface)parentPromptGroup);
            }
            int listSize = groups.size();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < listSize; ++i) {
                String label = ((PromptGroupInterface)groups.get(i)).getPromptGroupLabel(this.locale);
                if (label != null) {
                    sb.append(label);
                }
                if (i == listSize - 1) continue;
                sb.append(System.getProperty("file.separator"));
            }
            this.setText(sb.toString());
        }
        return this;
    }
}

