/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.SpecialValues;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DoubleType;
import com.sas.datatypes.IntegerType;
import com.sas.datatypes.StringType;
import com.sas.prompts.visuals.swing.designtime.PromptPanelConstantsInterface;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.swing.visuals.DoubleEditor;
import com.sas.swing.visuals.EditorListener;
import com.sas.swing.visuals.IntegerEditor;
import com.sas.swing.visuals.TextEditor;
import com.sas.swing.visuals.tableview.DefaultTableCellEditor;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.ValueItem;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.errorhandlers.SupportsGenericErrorHandlerInterface;
import com.sas.util.transforms.DataTypeToObjectTransform;
import com.sas.util.transforms.DataTypeToValueStringTransform;
import com.sas.util.transforms.TransformInterface;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.util.Locale;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableModel;

class MultipleValuesEditor
extends DefaultTableCellEditor
implements EditorListener,
CellEditorListener,
Serializable {
    protected SupportedSpecialValues specialValues;
    protected TableView tableForEditor;
    protected JComponent editor;
    private Object lastValue;
    private GenericErrorHandlerInterface viewerErrorHandler;
    private int minLength;
    private int maxLength;
    private int maxValue;
    private int minValue;
    private double minDoubleValue;
    private double maxDoubleValue;
    private int minDecimalPlaces;
    private int maxDecimalPlaces;
    private static final long serialVersionUID = 3257563988660598326L;

    public MultipleValuesEditor(JComponent editor, Locale locale) {
        this.setLocale(locale);
        this.editor = editor;
        this.minLength = 0;
        this.maxLength = Integer.MAX_VALUE;
        this.minValue = Integer.MIN_VALUE;
        this.maxValue = Integer.MAX_VALUE;
        this.minDoubleValue = -1.7976931348623157E308;
        this.maxDoubleValue = Double.MAX_VALUE;
        this.minDecimalPlaces = 0;
        this.maxDecimalPlaces = Integer.MAX_VALUE;
        if (editor instanceof DoubleEditor) {
            this.setTransform((TransformInterface)new DataTypeToValueStringTransform((DataTypeInterface)DoubleType.DEFAULT_INSTANCE, locale));
            this.setOutputTransform((TransformInterface)new DataTypeToObjectTransform((DataTypeInterface)DoubleType.DEFAULT_INSTANCE, locale));
        } else if (editor instanceof IntegerEditor) {
            this.setTransform((TransformInterface)new DataTypeToValueStringTransform((DataTypeInterface)IntegerType.DEFAULT_INSTANCE, locale));
            this.setOutputTransform((TransformInterface)new DataTypeToObjectTransform((DataTypeInterface)IntegerType.DEFAULT_INSTANCE, locale));
        } else if (editor instanceof TextEditor) {
            this.setTransform((TransformInterface)new DataTypeToValueStringTransform((DataTypeInterface)StringType.DEFAULT_INSTANCE, locale));
            this.setOutputTransform((TransformInterface)new DataTypeToObjectTransform((DataTypeInterface)StringType.DEFAULT_INSTANCE, locale));
        }
        this.editorComponent = editor;
        final JComponent MultiplesValueEditorF = this.editor;
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object value) {
                try {
                    if (MultiplesValueEditorF instanceof DoubleEditor) {
                        value = DoubleType.DEFAULT_INSTANCE.coerceValue(value, MultipleValuesEditor.this.getLocale());
                        ((DoubleEditor)MultiplesValueEditorF).setValue(value);
                    } else if (MultiplesValueEditorF instanceof IntegerEditor) {
                        value = IntegerType.DEFAULT_INSTANCE.coerceValue(value, MultipleValuesEditor.this.getLocale());
                        ((IntegerEditor)MultiplesValueEditorF).setValue(value);
                    }
                    if (MultiplesValueEditorF instanceof TextEditor) {
                        value = StringType.DEFAULT_INSTANCE.coerceValue(value, MultipleValuesEditor.this.getLocale());
                        ((TextEditor)MultiplesValueEditorF).setValue(value);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                super.setValue(value);
            }

            @Override
            public Object getCellEditorValue() {
                return ((TextEditor)MultiplesValueEditorF).getValue();
            }
        };
        if (MultiplesValueEditorF instanceof DoubleEditor) {
            ((DoubleEditor)MultiplesValueEditorF).addEditorListener((EditorListener)this);
        } else if (MultiplesValueEditorF instanceof IntegerEditor) {
            ((IntegerEditor)MultiplesValueEditorF).addEditorListener((EditorListener)this);
        } else if (MultiplesValueEditorF instanceof TextEditor) {
            ((TextEditor)MultiplesValueEditorF).addEditorListener((EditorListener)this);
        }
    }

    public boolean stopCellEditing() {
        Object s = null;
        if (this.editor instanceof DoubleEditor) {
            s = ((DoubleEditor)this.editor).getValue();
        } else if (this.editor instanceof IntegerEditor) {
            s = ((IntegerEditor)this.editor).getValue();
        } else if (this.editor instanceof TextEditor) {
            s = ((TextEditor)this.editor).getValue();
        }
        if (this.tableForEditor != null) {
            DefaultTableModel tableModel = (DefaultTableModel)this.tableForEditor.getModel();
            int tableSize = tableModel.getRowCount();
            Object o = s;
            if (tableSize > 1) {
                int option;
                if (s == SpecialValues.ALL || s == SpecialValues.OTHER) {
                    option = this.getMessageDialogReturnCode((SpecialValues)s);
                    if (option == 1) {
                        this.clearSpecialValuesRow();
                    } else {
                        this.clearRowsExceptSpecialValues();
                    }
                } else if (s instanceof ValueItem && ((o = ((ValueItem)s).getValue()) == SpecialValues.ALL || o == SpecialValues.OTHER)) {
                    option = this.getMessageDialogReturnCode((SpecialValues)o);
                    if (option == 1) {
                        this.clearSpecialValuesRow();
                    } else {
                        this.clearRowsExceptSpecialValues();
                    }
                }
            }
            if (o instanceof String) {
                if (((String)o).length() < this.getMinLength()) {
                    this.displayMinMaxError(new Message(RB.getStringResource("lengthBelowMin.fmt.txt"), (Object)String.valueOf(this.getMinLength())), s);
                } else if (((String)o).length() > this.getMaxLength()) {
                    this.displayMinMaxError(new Message(RB.getStringResource("lengthAboveMax.fmt.txt"), (Object)String.valueOf(this.getMaxLength())), s);
                }
            } else if (o instanceof Integer) {
                if ((Integer)o < this.getMinValue()) {
                    this.displayMinMaxError(new Message(RB.getStringResource("valueBelowMin.fmt.txt"), (Object)String.valueOf(this.getMinValue())), s);
                } else if ((Integer)o > this.getMaxValue()) {
                    this.displayMinMaxError(new Message(RB.getStringResource("valueAboveMax.fmt.txt"), (Object)String.valueOf(this.getMaxValue())), s);
                }
            } else if (o instanceof Double) {
                String stringVal = o.toString();
                int decPlaces = stringVal.substring(stringVal.indexOf(".") + 1).length();
                if ((Double)o < this.getMinDoubleValue()) {
                    this.displayMinMaxError(new Message(RB.getStringResource("valueBelowMin.fmt.txt"), (Object)String.valueOf(this.getMinDoubleValue())), s);
                } else if ((Double)o > this.getMaxDoubleValue()) {
                    this.displayMinMaxError(new Message(RB.getStringResource("valueAboveMax.fmt.txt"), (Object)String.valueOf(this.getMaxDoubleValue())), s);
                } else if (decPlaces > this.getMaxDecimalPlaces()) {
                    this.displayMinMaxError(new Message(RB.getStringResource("decimalPlacesAboveMax.fmt.txt"), (Object)String.valueOf(this.getMaxDecimalPlaces())), s);
                }
            }
        }
        this.lastValue = s;
        return super.stopCellEditing();
    }

    public void setSupportedSpecialValues(SupportedSpecialValues specialValues) {
        if (this.specialValues != specialValues) {
            SupportedSpecialValues oldValue = this.specialValues;
            this.specialValues = specialValues;
            if (this.editor instanceof DoubleEditor) {
                ((DoubleEditor)this.editor).setSupportedSpecialValues(specialValues);
            } else if (this.editor instanceof IntegerEditor) {
                ((IntegerEditor)this.editor).setSupportedSpecialValues(specialValues);
            } else if (this.editor instanceof TextEditor) {
                ((TextEditor)this.editor).setSupportedSpecialValues(specialValues);
            }
        }
    }

    public SupportedSpecialValues getSupportedSpecialValues() {
        return this.specialValues;
    }

    public void flagError(Message message, Object s) {
        ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
        if (this.getGenericErrorHandler() != null) {
            this.viewerErrorHandler = this.getGenericErrorHandler();
        }
        if (!(this.viewerErrorHandler == null || s != null && s.equals(this.lastValue))) {
            this.lastValue = s;
            this.viewerErrorHandler.handleError((Object)this.getComponent(), message, null);
        }
        this.lastValue = s;
    }

    public void displayMinMaxError(Message message, Object s) {
        if (this.getGenericErrorHandler() != null) {
            this.viewerErrorHandler = this.getGenericErrorHandler();
        }
        if (!(this.viewerErrorHandler == null || s != null && s.equals(this.lastValue))) {
            this.lastValue = s;
            this.viewerErrorHandler.handleError((Object)this.getComponent(), message, null);
        }
        this.lastValue = s;
    }

    public void setMinLength(int length) {
        this.minLength = length;
    }

    public void setMaxLength(int length) {
        this.maxLength = length;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        if (this.maxLength == 0) {
            return Integer.MAX_VALUE;
        }
        return this.maxLength;
    }

    public void setMinValue(int value) {
        this.minValue = value;
    }

    public void setMaxValue(int value) {
        this.maxValue = value;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        if (this.maxValue == 0) {
            return Integer.MAX_VALUE;
        }
        return this.maxValue;
    }

    public void setMinDecimalPlaces(int value) {
        this.minDecimalPlaces = value;
    }

    public void setMaxDecimalPlaces(int value) {
        this.maxDecimalPlaces = value;
    }

    public int getMinDecimalPlaces() {
        return this.minDecimalPlaces;
    }

    public int getMaxDecimalPlaces() {
        if (this.maxDecimalPlaces == 0) {
            return Integer.MAX_VALUE;
        }
        return this.maxDecimalPlaces;
    }

    public void setMinDoubleValue(double value) {
        this.minDoubleValue = value;
    }

    public void setMaxDoubleValue(double value) {
        this.maxDoubleValue = value;
    }

    public double getMinDoubleValue() {
        return this.minDoubleValue;
    }

    public double getMaxDoubleValue() {
        if (this.maxDoubleValue == 0.0) {
            return Double.MAX_VALUE;
        }
        return this.maxDoubleValue;
    }

    public void valueChanged(ChangeEvent e) {
        this.stopCellEditing();
    }

    public void editingStarted(ChangeEvent e) {
    }

    public void valueModified(ChangeEvent e) {
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        this.cancelCellEditing();
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        this.stopCellEditing();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.tableForEditor = (TableView)table;
        if (this.getGenericErrorHandler() == null && table instanceof SupportsGenericErrorHandlerInterface) {
            SupportsGenericErrorHandlerInterface viewer = (SupportsGenericErrorHandlerInterface)table;
            this.viewerErrorHandler = viewer.getGenericErrorHandler();
        }
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    protected int getMessageDialogReturnCode(SpecialValues sp) {
        String errMsg = Message.format((String)RB.getStringResource("specialValuesError.fmt.txt"), (Object)sp);
        int option = JOptionPane.showOptionDialog(Util.getParentFrame((Component)this.tableForEditor), errMsg, RB.getStringResource("editList.txt"), -1, 2, null, PromptPanelConstantsInterface.CONFIRM_MESSAGE_DIALOG_OPTIONS, PromptPanelConstantsInterface.CONFIRM_MESSAGE_DIALOG_OPTIONS[0]);
        return option;
    }

    protected void clearSpecialValuesRow() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultTableModel tableModel = (DefaultTableModel)MultipleValuesEditor.this.tableForEditor.getModel();
                int tableSize = tableModel.getRowCount();
                for (int i = tableSize - 1; i >= 0; --i) {
                    Object o = tableModel.getValueAt(i, 0);
                    if (o != SpecialValues.ALL && o != SpecialValues.OTHER) continue;
                    tableModel.removeRow(i);
                }
            }
        });
    }

    protected void clearRowsExceptSpecialValues() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultTableModel tableModel = (DefaultTableModel)MultipleValuesEditor.this.tableForEditor.getModel();
                int tableSize = tableModel.getRowCount();
                for (int i = tableSize - 1; i >= 0; --i) {
                    Object o = tableModel.getValueAt(i, 0);
                    if (o == SpecialValues.ALL || o == SpecialValues.OTHER) continue;
                    tableModel.removeRow(i);
                }
            }
        });
    }
}

