/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.IntegerDefinition;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.TextDefinition;
import com.sas.prompts.definitions.TextDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.prompts.groups.TransparentGroupInterface;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BasePromptTypePanel;
import com.sas.prompts.visuals.swing.designtime.PromptGroupUtility;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.LayoutManager;
import java.util.Collection;

class MultiLineTextPanel
extends BasePromptTypePanel
implements PromptValueChangeListener {
    private IntegerDefinition promptMinLength;
    private IntegerDefinition promptMaxLength;
    private IntegerDefinition promptMaxLines;
    private IntegerDefinition promptDisplayedLines;
    private PromptPropertiesPanel promptPropertiesPanel;
    private PromptValues promptValuesMinMaxLength;
    private PromptValues promptValuesMaxLines;
    private PromptPropertiesPanel promptPropertiesPanelMinMaxLength;
    private PromptPropertiesPanel promptPropertiesPanelMaxLineCount;
    private PromptValues promptValues;
    private TextDefinition promptText;
    private TextDefinition textPrompt;
    private static final long serialVersionUID = 3257563988660598326L;

    public MultiLineTextPanel(TextDefinitionInterface prompt, PropertiesCommunicator communicator) {
        super(communicator);
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 0, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        TransparentGroup promptGroupMaxLines = new TransparentGroup();
        this.promptMaxLines = new IntegerDefinition("");
        this.promptMaxLines.setPromptLabel(RB.getStringResource("maxLines.txt"), this.getLocale());
        promptGroupMaxLines.addPromptDefinition((PromptDefinitionInterface)this.promptMaxLines);
        this.promptValuesMaxLines = new PromptValues((PromptGroupInterface)promptGroupMaxLines, null);
        if (prompt != null) {
            try {
                int maxLinesLength = prompt.getMaximumLines();
                if (maxLinesLength > 0) {
                    this.promptValuesMaxLines.setPromptValue((PromptDefinitionInterface)this.promptMaxLines, (Object)new Integer(maxLinesLength));
                }
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
            }
        }
        this.promptValuesMaxLines.addPromptValueChangeListener((PromptValueChangeListener)this);
        this.promptPropertiesPanelMaxLineCount = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesMaxLines, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelMaxLineCount);
        TransparentGroupInterface promptGroupMinMaxLength = PromptGroupUtility.newGroupForMinMaxLength(this.getLocale(), this.getLoggerFactory());
        this.promptMinLength = (IntegerDefinition)promptGroupMinMaxLength.getPromptDefinition(PromptGroupUtility.MIN_LENGTH, true);
        this.promptMaxLength = (IntegerDefinition)promptGroupMinMaxLength.getPromptDefinition(PromptGroupUtility.MAX_LENGTH, true);
        this.promptValuesMinMaxLength = new PromptValues((PromptGroupInterface)promptGroupMinMaxLength, null);
        if (prompt != null) {
            try {
                int maxValue;
                int minValue = prompt.getMinimumLength();
                if (minValue > 0) {
                    this.promptValuesMinMaxLength.setPromptValue((PromptDefinitionInterface)this.promptMinLength, (Object)new Integer(minValue));
                }
                if ((maxValue = prompt.getMaximumLength()) != -1) {
                    this.promptValuesMinMaxLength.setPromptValue((PromptDefinitionInterface)this.promptMaxLength, (Object)new Integer(maxValue));
                }
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
            }
        }
        this.promptValuesMinMaxLength.addPromptValueChangeListener((PromptValueChangeListener)this);
        this.promptPropertiesPanelMinMaxLength = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesMinMaxLength, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelMinMaxLength);
        TransparentGroup promptGroup = new TransparentGroup();
        this.promptDisplayedLines = new IntegerDefinition("");
        this.promptDisplayedLines.setPromptLabel(RB.getStringResource("displayedLines.txt"), this.getLocale());
        promptGroup.addPromptDefinition((PromptDefinitionInterface)this.promptDisplayedLines);
        this.promptText = new TextDefinition("");
        this.promptText.setAllowMultipleLines(true);
        SupportedSpecialValues supportedSpecialValues = new SupportedSpecialValues();
        supportedSpecialValues.setMissingValuesSupported(false);
        this.promptText.setSupportedSpecialValues(supportedSpecialValues);
        this.promptText.setPromptLabel(RB.getStringResource("defaultValue.txt"), this.getLocale());
        promptGroup.addPromptDefinition((PromptDefinitionInterface)this.promptText);
        this.promptValues = new PromptValues((PromptGroupInterface)promptGroup, null);
        if (prompt != null) {
            try {
                boolean defaultValueSet;
                int displayedLinesLength = prompt.getDisplayedLines();
                if (displayedLinesLength > 0) {
                    this.promptValues.setPromptValue((PromptDefinitionInterface)this.promptDisplayedLines, (Object)new Integer(displayedLinesLength));
                }
                if (defaultValueSet = prompt.isDefaultValueSet()) {
                    this.promptValues.setPromptValue((PromptDefinitionInterface)this.promptText, prompt.getDefaultValue());
                }
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
            }
        } else {
            PromptUtility.configureTextDefaultValueNoValueProvider(this.promptValues, (TextDefinitionInterface)this.promptText, communicator);
        }
        this.promptPropertiesPanel = new PromptPropertiesPanel((PromptValuesInterface)this.promptValues, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanel);
        this.add(this.promptPropertiesPanelMaxLineCount);
        this.add(this.promptPropertiesPanelMinMaxLength);
        this.add(this.promptPropertiesPanel);
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        this.setContentsValid(true);
        this.promptValues.removePromptValueChangeListener((PromptValueChangeListener)this);
        this.textPrompt = (TextDefinition)PromptUtility.newConfiguredPrompt(this.communicator, "TextDefinition");
        this.textPrompt.setAllowMultipleLines(true);
        try {
            Object defaultValue;
            Integer displayedLines;
            Integer maxLines;
            Integer maxLength;
            Integer minLength;
            if (this.promptValuesMinMaxLength.isPromptValueAvailable((PromptDefinitionInterface)this.promptMinLength) && (minLength = (Integer)this.promptValuesMinMaxLength.getPromptValue((PromptDefinitionInterface)this.promptMinLength)) != null) {
                this.textPrompt.setMinimumLength(minLength.intValue());
            }
            if (this.promptValuesMinMaxLength.isPromptValueAvailable((PromptDefinitionInterface)this.promptMaxLength) && (maxLength = (Integer)this.promptValuesMinMaxLength.getPromptValue((PromptDefinitionInterface)this.promptMaxLength)) != null) {
                this.textPrompt.setMaximumLength(maxLength.intValue());
            }
            if (this.promptValuesMaxLines.isPromptValueAvailable((PromptDefinitionInterface)this.promptMaxLines) && (maxLines = (Integer)this.promptValuesMaxLines.getPromptValue((PromptDefinitionInterface)this.promptMaxLines)) != null) {
                this.textPrompt.setMaximumLines(maxLines.intValue());
            }
            if (this.promptValues.isPromptValueAvailable((PromptDefinitionInterface)this.promptDisplayedLines) && (displayedLines = (Integer)this.promptValues.getPromptValue((PromptDefinitionInterface)this.promptDisplayedLines)) != null) {
                this.textPrompt.setDisplayedLines(displayedLines.intValue());
            }
            if (this.promptValues.isPromptValueAvailable((PromptDefinitionInterface)this.promptText) && (defaultValue = this.promptValues.getPromptValue((PromptDefinitionInterface)this.promptText)) != null) {
                this.textPrompt.setDefaultValue(defaultValue);
            }
        }
        catch (IllegalArgumentException exception) {
            if (!suppressErrors) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(exception.getMessage());
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)exception.getMessage())), null);
                }
                this.setContentsValid(false);
                this.promptValues.addPromptValueChangeListener((PromptValueChangeListener)this);
            }
            return this.textPrompt;
        }
        catch (PromptValueNotFoundException pvnf) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
        }
        Collection errors = this.textPrompt.validateDefinition(this.getLocale());
        if (errors.size() > 0 && !suppressErrors) {
            String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
            }
            this.setContentsValid(false);
            this.promptValues.addPromptValueChangeListener((PromptValueChangeListener)this);
            return this.textPrompt;
        }
        return this.textPrompt;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.getPromptDefinition(false);
    }

    public void promptValueChanged(PromptValueChangeEventInterface event) {
        boolean isValid = this.promptPropertiesPanel.isContentsValid();
        this.setContentsValid(isValid);
    }
}

