/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.PromptUtil;
import com.sas.prompts.definitions.SelectableDefinitionInterface;
import com.sas.prompts.groups.ModalChoiceGroupInterface;
import com.sas.prompts.groups.ModalGroupInterface;
import com.sas.prompts.groups.PromptGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.visuals.swing.designtime.ChoiceGroupListEditor;
import com.sas.prompts.visuals.swing.designtime.ModalChoiceTableModel;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.swing.visuals.PanelInterface;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.DefaultTableModel;

class ModalChoiceGroupsPanel
extends JPanel
implements PanelInterface {
    private PromptGroupInterface originalPromptGroup;
    private PropertiesCommunicator communicator;
    private ChoiceGroupListEditor listEditor;
    private int subGroupSize;
    private String dialogTitle;
    private String tabTitle;
    private String helpID;
    private static final long serialVersionUID = 3257563988660598326L;
    public static final String DEFAULT_HELP_ID = "seldepgroupstab";

    public ModalChoiceGroupsPanel(PromptGroupInterface promptGroup, PropertiesCommunicator communicator) {
        this.communicator = communicator;
        this.originalPromptGroup = promptGroup;
        this.subGroupSize = 0;
        if (this.originalPromptGroup != null) {
            this.subGroupSize = this.originalPromptGroup.getPromptSubgroups(false).size();
        }
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 5, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        this.setBorder(BorderFactory.createEmptyBorder(30, 10, 0, 0));
        JLabel choiceGroupLabel = new JLabel(RB.getStringResource("choiceGroups.txt"));
        if (this.subGroupSize > 0) {
            PromptGroup copyPromptGroup = new PromptGroup();
            PromptUtil.copyDefinitionsAndSubgroups((PromptGroupInterface)copyPromptGroup, (PromptGroupInterface)this.originalPromptGroup, (boolean)false);
            Vector dataVector = new Vector();
            List choiceGroups = copyPromptGroup.getPromptSubgroups(false);
            SelectableDefinitionInterface promptDefinition = (SelectableDefinitionInterface)((ModalGroupInterface)promptGroup).getChoiceDefinition();
            Object defaultValue = null;
            if (promptDefinition.isDefaultValueSet()) {
                defaultValue = promptDefinition.getDefaultValue();
            }
            int listSize = choiceGroups.size();
            boolean foundDefault = false;
            ModalChoiceGroupInterface modalChoiceDefaultGroup = null;
            try {
                for (int i = 0; i < listSize; ++i) {
                    Vector v = new Vector();
                    ModalChoiceGroupInterface modalChoiceGroup = (ModalChoiceGroupInterface)choiceGroups.get(i);
                    v.add(choiceGroups.get(i));
                    if (!foundDefault && defaultValue != null && defaultValue.equals(modalChoiceGroup.getValue())) {
                        foundDefault = true;
                        modalChoiceDefaultGroup = modalChoiceGroup;
                    } else {
                        v.add(Boolean.FALSE);
                    }
                    dataVector.add(v);
                }
            }
            catch (Exception e) {
                System.out.println("got exception" + e);
            }
            Vector<String> columnNames = new Vector<String>(1);
            columnNames.add(RB.getStringResource("modalChoiceGroup.txt"));
            columnNames.add(RB.getStringResource("modalDefault.txt"));
            this.listEditor = new ChoiceGroupListEditor(new ModalChoiceTableModel(dataVector, (Vector)columnNames), modalChoiceDefaultGroup, communicator);
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.listEditor.getModel();
        } else {
            this.listEditor = new ChoiceGroupListEditor(communicator);
        }
        this.setHelpID(DEFAULT_HELP_ID);
        this.add(choiceGroupLabel);
        this.add((Component)((Object)this.listEditor));
    }

    public List getListOfModalChoiceGroups() {
        return this.updateListofModalChoiceGroups();
    }

    private List updateListofModalChoiceGroups() {
        DefaultTableModel tableModel = (DefaultTableModel)this.listEditor.getModel();
        int rowCount = tableModel.getRowCount();
        ArrayList<Object> modalChoiceGroupsList = new ArrayList<Object>();
        for (int i = 0; i < rowCount; ++i) {
            modalChoiceGroupsList.add(tableModel.getValueAt(i, 0));
        }
        return modalChoiceGroupsList;
    }

    public ModalChoiceGroupInterface getDefaultModalChoiceGroup() {
        DefaultTableModel tableModel = (DefaultTableModel)this.listEditor.getModel();
        int rowCount = tableModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (!((Boolean)tableModel.getValueAt(i, 1)).booleanValue()) continue;
            return (ModalChoiceGroupInterface)tableModel.getValueAt(i, 0);
        }
        return null;
    }

    public void onApply() {
        this.updateListofModalChoiceGroups();
    }

    public void onCancel() {
    }

    public void onClose() {
    }

    public String getDialogTitle() {
        return this.dialogTitle == null ? "" : this.dialogTitle;
    }

    public String getTabTitle() {
        return this.tabTitle == null ? "" : this.tabTitle;
    }

    public JComponent getPanel() {
        return this;
    }

    public String getHelpID() {
        return this.helpID;
    }

    public void setHelpID(String helpID) {
        this.helpID = helpID;
    }

    public boolean isYesNo() {
        return false;
    }

    public boolean isContentsValid() {
        return true;
    }

    public void setContentsValid(boolean newValue) {
    }
}

