/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.swing.visuals.ComboBox;
import com.sas.swing.visuals.PanelInterface;
import com.sas.util.Util;
import com.sas.util.ValueItem;
import com.sas.util.macrovar.BaseMacroInfoSource;
import com.sas.util.macrovar.MacroVariableListOptionInterface;
import com.sas.util.macrovar.MacroVariableOptionInterface;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class MacroVariableOptionsPanel
implements PanelInterface,
ActionListener {
    private MacroVariableOptionInterface macroInfo;
    private PropertiesCommunicator communicator;
    private ComboBox delimiterCombo;
    private DefaultComboBoxModel delimiterModel;
    private ComboBox quoteCombo;
    private DefaultComboBoxModel quoteModel;
    private JRadioButton noDetailsButton;
    private JRadioButton detailsButton;
    private JRadioButton separateButton;
    private JRadioButton singleButton;
    private JLabel delimiterLabel;
    private JLabel quoteLabel;
    private JPanel panel;
    private JLabel singleSeparateLabel;
    private String helpID;
    public static final String DEFAULT_HELP_ID = "variablesdialog";

    public MacroVariableOptionsPanel(MacroVariableOptionInterface macroInfo, PropertiesCommunicator communicator) {
        this.communicator = communicator;
        this.macroInfo = macroInfo;
        this.setHelpID(DEFAULT_HELP_ID);
    }

    public void onApply() {
    }

    public void onCancel() {
    }

    public void onClose() {
    }

    public String getDialogTitle() {
        return RB.getStringResource("variablesTitle.txt");
    }

    public String getTabTitle() {
        return null;
    }

    public synchronized JComponent getPanel() {
        if (this.panel != null) {
            return this.panel;
        }
        JPanel container = new JPanel();
        container.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(-1, 1, 10, 10);
        container.setLayout((LayoutManager)mainLayout);
        JPanel detailsContainer = new JPanel();
        AutoSizingGridLayout detailsLayout = new AutoSizingGridLayout(-1, 1);
        detailsContainer.setLayout((LayoutManager)detailsLayout);
        JLabel label = new JLabel(RB.getStringResource("variablesLabel.txt"));
        detailsContainer.add(label);
        this.noDetailsButton = new JRadioButton(RB.getStringResource("noDetailsRadio.txt"));
        detailsContainer.add(this.noDetailsButton);
        this.detailsButton = new JRadioButton(RB.getStringResource("detailsRadio.txt"));
        detailsContainer.add(this.detailsButton);
        ButtonGroup group = new ButtonGroup();
        group.add(this.noDetailsButton);
        group.add(this.detailsButton);
        container.add(detailsContainer);
        JPanel listOptionsContainer = new JPanel();
        AutoSizingGridLayout listOptionsLayout = new AutoSizingGridLayout(-1, 1);
        listOptionsContainer.setLayout((LayoutManager)listOptionsLayout);
        this.singleSeparateLabel = new JLabel(RB.getStringResource("variablesListLabel.txt"));
        listOptionsContainer.add(this.singleSeparateLabel);
        this.separateButton = new JRadioButton(RB.getStringResource("separateVariablesRadio.txt"));
        listOptionsContainer.add(this.separateButton);
        this.singleButton = new JRadioButton(RB.getStringResource("singleVariablesRadio.txt"));
        listOptionsContainer.add(this.singleButton);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.separateButton);
        group2.add(this.singleButton);
        JPanel singleListOptionContainer = new JPanel();
        singleListOptionContainer.setBorder(BorderFactory.createEmptyBorder(2, 30, 2, 0));
        AutoSizingGridLayout singleListOptionLayout = new AutoSizingGridLayout(2, 2, 7, 7);
        singleListOptionLayout.setFillCell(true);
        singleListOptionLayout.setFillCell(true);
        singleListOptionContainer.setLayout((LayoutManager)singleListOptionLayout);
        this.delimiterLabel = new JLabel(RB.getStringResource("delimiterLabel.txt"));
        singleListOptionContainer.add(this.delimiterLabel);
        this.delimiterCombo = new ComboBox();
        this.delimiterModel = new DefaultComboBoxModel();
        this.delimiterModel.addElement(new ValueItem((Object)RB.getStringResource("delimiterComma.txt"), (Object)","));
        this.delimiterModel.addElement(new ValueItem((Object)RB.getStringResource("delimiterTab.txt"), (Object)"\t"));
        this.delimiterModel.addElement(new ValueItem((Object)RB.getStringResource("delimiterSpace.txt"), (Object)" "));
        this.delimiterModel.addElement(new ValueItem((Object)RB.getStringResource("delimiterSemiColon.txt"), (Object)";"));
        this.delimiterModel.addElement(new ValueItem((Object)RB.getStringResource("delimiterColon.txt"), (Object)":"));
        this.delimiterModel.addElement(new ValueItem((Object)RB.getStringResource("delimiterPipe.txt"), (Object)"|"));
        this.delimiterModel.addElement(new ValueItem((Object)RB.getStringResource("delimiterAmpersand.txt"), (Object)"&"));
        this.delimiterCombo.setModel((ComboBoxModel)this.delimiterModel);
        this.delimiterLabel.setLabelFor((Component)this.delimiterCombo);
        singleListOptionContainer.add((Component)this.delimiterCombo);
        this.quoteLabel = new JLabel(RB.getStringResource("quoteLabel.txt"));
        singleListOptionContainer.add(this.quoteLabel);
        this.quoteCombo = new ComboBox();
        this.quoteModel = new DefaultComboBoxModel();
        this.quoteModel.addElement(new ValueItem((Object)RB.getStringResource("quoteNone.txt"), null));
        this.quoteModel.addElement(new ValueItem((Object)RB.getStringResource("quoteDoubleQuote.txt"), (Object)"\""));
        this.quoteModel.addElement(new ValueItem((Object)RB.getStringResource("quoteSingleQuote.txt"), (Object)"'"));
        this.quoteCombo.setModel((ComboBoxModel)this.quoteModel);
        this.quoteLabel.setLabelFor((Component)this.quoteCombo);
        singleListOptionContainer.add((Component)this.quoteCombo);
        listOptionsContainer.add(singleListOptionContainer);
        container.add(listOptionsContainer);
        this.separateButton.addActionListener(this);
        this.singleButton.addActionListener(this);
        boolean details = this.macroInfo.getMacroVariableOutputLevel() == 2;
        this.detailsButton.setSelected(details);
        this.noDetailsButton.setSelected(!details);
        if (this.macroInfo instanceof MacroVariableListOptionInterface) {
            boolean single = ((MacroVariableListOptionInterface)this.macroInfo).getMacroVariableListFormat() == 1;
            this.singleButton.setSelected(single);
            this.separateButton.setSelected(!single);
            this.selectValueItemInCombo(this.quoteCombo, ((MacroVariableListOptionInterface)this.macroInfo).getMacroVariableQuote());
            this.selectValueItemInCombo(this.delimiterCombo, ((MacroVariableListOptionInterface)this.macroInfo).getMacroVariableListDelimiter());
        } else {
            this.singleSeparateLabel.setEnabled(false);
            this.singleButton.setEnabled(false);
            this.separateButton.setEnabled(false);
        }
        this.enableDelimterAndQuoteCombos();
        this.panel = container;
        return container;
    }

    public String getHelpID() {
        return this.helpID;
    }

    public void setHelpID(String helpID) {
        this.helpID = helpID;
    }

    public boolean isYesNo() {
        return false;
    }

    public boolean isContentsValid() {
        return true;
    }

    public void setContentsValid(boolean newValue) {
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.enableDelimterAndQuoteCombos();
    }

    private void enableDelimterAndQuoteCombos() {
        boolean enable = this.singleButton.isSelected();
        this.quoteLabel.setEnabled(enable);
        this.quoteCombo.setEnabled(enable);
        this.delimiterLabel.setEnabled(enable);
        this.delimiterCombo.setEnabled(enable);
    }

    private void selectValueItemInCombo(ComboBox combo, Object value) {
        ComboBoxModel model = combo.getModel();
        int n = model.getSize();
        for (int i = 0; i < n; ++i) {
            ValueItem possibleValueItem;
            Object possibleValue = model.getElementAt(i);
            if (!(possibleValue instanceof ValueItem) || !Util.equal((Object)(possibleValueItem = (ValueItem)possibleValue).getValue(), (Object)value)) continue;
            combo.setSelectedItem((Object)possibleValueItem);
        }
    }

    private String getQuote() {
        Object selected = this.quoteCombo.getSelectedItem();
        if (selected != null) {
            return (String)((ValueItem)selected).getValue();
        }
        return null;
    }

    private String getDelimiter() {
        Object selected = this.delimiterCombo.getSelectedItem();
        if (selected != null) {
            return (String)((ValueItem)selected).getValue();
        }
        return null;
    }

    public MacroVariableOptionInterface getMacroVariableInfo() {
        BaseMacroInfoSource newMacroInfo = new BaseMacroInfoSource(null);
        if (this.detailsButton.isSelected()) {
            newMacroInfo.setMacroVariableOutputLevel(2);
        } else {
            newMacroInfo.setMacroVariableOutputLevel(1);
        }
        if (this.singleButton.isSelected()) {
            newMacroInfo.setMacroVariableListFormat(1);
            newMacroInfo.setMacroVariableQuote(this.getQuote());
            newMacroInfo.setMacroVariableListDelimiter(this.getDelimiter());
        } else {
            newMacroInfo.setMacroVariableListFormat(2);
        }
        return newMacroInfo;
    }
}

