/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.datatypes.DateType;
import com.sas.datatypes.DoubleType;
import com.sas.datatypes.IntegerType;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.DateDefinition;
import com.sas.prompts.definitions.DateDefinitionInterface;
import com.sas.prompts.definitions.DoubleDefinition;
import com.sas.prompts.definitions.DoubleDefinitionInterface;
import com.sas.prompts.definitions.IntegerDefinition;
import com.sas.prompts.definitions.IntegerDefinitionInterface;
import com.sas.prompts.definitions.MutablePromptDefinitionInterface;
import com.sas.prompts.definitions.MutableSelectableDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.TextDefinition;
import com.sas.prompts.definitions.TextDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.iq.DataItemValueProvider;
import com.sas.prompts.valueprovider.dynamic.workspace.PromptColumnValueProvider;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BaseSpecialValuesPanel;
import com.sas.prompts.visuals.swing.designtime.DefaultValuesListEditor;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.swing.visuals.ComboBox;
import com.sas.util.MutableSupportedSpecialValuesInterface;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.SupportedSpecialValuesInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

class LookUpSingleValuePanel
extends BaseSpecialValuesPanel
implements ItemListener,
SupportedSpecialValuesInterface {
    private boolean contentsValid = true;
    protected JPanel customPanel;
    protected JPanel holderPanel;
    private ComboBox defaultValueCombo;
    protected DataProvider dataProvider;
    protected PromptValues promptValuesValueCount;
    protected IntegerDefinition promptMinValueCount;
    protected IntegerDefinition promptMaxValueCount;
    protected DefaultValuesListEditor listEditor;
    private PromptValues promptValuesDefaultValue;
    private MutableSelectableDefinitionInterface promptObject;
    private PromptPropertiesPanel promptPropertiesPanelDefaultValue;
    private static final long serialVersionUID = 3257563988660598326L;

    public LookUpSingleValuePanel(MutableSelectableDefinitionInterface prompt, PropertiesCommunicator communicator) {
        super((PromptDefinitionInterface)prompt, communicator, 0);
        this.createPromptPanel();
    }

    public LookUpSingleValuePanel(MutableSelectableDefinitionInterface prompt, PropertiesCommunicator communicator, SupportedSpecialValues initialSupportedValues) {
        super((PromptDefinitionInterface)prompt, communicator, 0, initialSupportedValues);
        this.createPromptPanel();
    }

    private void createPromptPanel() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 0, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        this.holderPanel = new JPanel();
        AutoSizingGridLayout holderPanelLayout = new AutoSizingGridLayout(-1, 1, 10, 5, true, false, true);
        this.holderPanel.setLayout((LayoutManager)holderPanelLayout);
        this.add(this.createSpecialValuesFields());
        if (this.prompt instanceof MutableSupportedSpecialValuesInterface) {
            SupportedSpecialValues supportedSpecialValues = ((MutableSupportedSpecialValuesInterface)this.prompt).getSupportedSpecialValues();
            supportedSpecialValues.setAllSupported(this.allCheckBox.isSelected());
            supportedSpecialValues.setOtherSupported(this.noneCheckBox.isSelected());
            ((MutableSupportedSpecialValuesInterface)this.prompt).setSupportedSpecialValues(supportedSpecialValues);
            if (this.allCheckBox.isSelected() || this.noneCheckBox.isSelected() || this.missingCheckBox.isSelected()) {
                if (supportedSpecialValues.isAllSupported()) {
                    this.allCheckBox.setSelected(true);
                }
                if (supportedSpecialValues.isOtherSupported()) {
                    this.noneCheckBox.setSelected(true);
                }
                if (supportedSpecialValues.isMissingValuesSupported()) {
                    this.missingCheckBox.setSelected(true);
                }
            }
        }
        this.createDefaultValuePanel();
        this.holderPanel.add(this.customPanel);
        this.add(this.holderPanel);
    }

    private void createDefaultValuePanel() {
        if (this.prompt instanceof TextDefinitionInterface) {
            TextDefinition promptText = new TextDefinition("");
            this.customPanel = this.createPromptPropertiesPanel((MutableSelectableDefinitionInterface)promptText);
        } else if (this.prompt instanceof IntegerDefinitionInterface) {
            IntegerDefinition promptInteger = new IntegerDefinition("");
            this.customPanel = this.createPromptPropertiesPanel((MutableSelectableDefinitionInterface)promptInteger);
        } else if (this.prompt instanceof DoubleDefinitionInterface) {
            DoubleDefinition promptDouble = new DoubleDefinition("");
            this.customPanel = this.createPromptPropertiesPanel((MutableSelectableDefinitionInterface)promptDouble);
        } else if (this.prompt instanceof DateDefinitionInterface) {
            DateDefinition promptDate = new DateDefinition("");
            promptDate.setDateType(((DateDefinitionInterface)this.prompt).getDateType());
            this.customPanel = this.createPromptPropertiesPanel((MutableSelectableDefinitionInterface)promptDate);
        }
    }

    private JPanel createPromptPropertiesPanel(MutableSelectableDefinitionInterface promptObject) {
        this.promptObject = promptObject;
        TransparentGroup promptGroup = new TransparentGroup();
        SupportedSpecialValues supportedSpecialValues = new SupportedSpecialValues();
        supportedSpecialValues.setMissingValuesSupported(false);
        if (promptObject instanceof MutableSupportedSpecialValuesInterface) {
            ((MutableSupportedSpecialValuesInterface)promptObject).setSupportedSpecialValues(supportedSpecialValues);
        }
        promptObject.setPromptLabel(RB.getStringResource("defaultValue.txt"), this.locale);
        promptGroup.addPromptDefinition((PromptDefinitionInterface)promptObject);
        this.promptValuesDefaultValue = new PromptValues((PromptGroupInterface)promptGroup, null);
        if (this.prompt != null && this.prompt.isDefaultValueSet()) {
            try {
                this.promptValuesDefaultValue.setPromptValue((PromptDefinitionInterface)promptObject, this.prompt.getDefaultValue());
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
            }
        } else {
            ValueProviderInterface valueProvider;
            Map savedProperties = this.communicator.getPromptProperties();
            ArrayList defaultValues = new ArrayList();
            if (!savedProperties.isEmpty() && ((valueProvider = (ValueProviderInterface)savedProperties.get("ValueProvider")) instanceof DataItemValueProvider || valueProvider instanceof PromptColumnValueProvider)) {
                Object defaultSaved = savedProperties.get("DefaultValue");
                if (this.prompt instanceof TextDefinitionInterface) {
                    if (defaultSaved instanceof List) {
                        for (Object o : (List)defaultSaved) {
                            if (o == null) continue;
                            try {
                                this.promptValuesDefaultValue.setPromptValue((PromptDefinitionInterface)promptObject, o);
                                break;
                            }
                            catch (InvalidPromptValueException ipve) {
                                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ipve.getMessage());
                            }
                        }
                    } else if (defaultSaved != null && defaultSaved instanceof String) {
                        try {
                            this.promptValuesDefaultValue.setPromptValue((PromptDefinitionInterface)promptObject, defaultSaved);
                        }
                        catch (InvalidPromptValueException ipve) {
                            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ipve.getMessage());
                        }
                    }
                } else {
                    IntegerType dataType = null;
                    if (this.prompt instanceof IntegerDefinitionInterface) {
                        dataType = new IntegerType();
                    } else if (this.prompt instanceof DoubleDefinitionInterface) {
                        dataType = new DoubleType();
                    } else if (this.prompt instanceof DateDefinitionInterface) {
                        dataType = new DateType();
                    }
                    if (dataType != null) {
                        if (defaultSaved instanceof List) {
                            for (Object o : (List)defaultSaved) {
                                if (o == null) continue;
                                try {
                                    Object coercedValue = dataType.coerceValue(o, this.locale);
                                    this.promptValuesDefaultValue.setPromptValue((PromptDefinitionInterface)promptObject, coercedValue);
                                    break;
                                }
                                catch (IllegalArgumentException e) {
                                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(e.getMessage());
                                }
                                catch (InvalidPromptValueException ipve) {
                                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ipve.getMessage());
                                }
                            }
                        } else if (defaultSaved != null) {
                            try {
                                Object coercedValue = dataType.coerceValue(defaultSaved, this.locale);
                                this.promptValuesDefaultValue.setPromptValue((PromptDefinitionInterface)promptObject, coercedValue);
                            }
                            catch (IllegalArgumentException e) {
                                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(e.getMessage());
                            }
                            catch (InvalidPromptValueException ipve) {
                                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ipve.getMessage());
                            }
                        }
                    }
                }
            }
        }
        PromptPropertiesPanel promptPropertiesPanelDefaultValue = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesDefaultValue, this.locale);
        PromptUtility.configurePropertiesPanel(promptPropertiesPanelDefaultValue);
        return promptPropertiesPanelDefaultValue;
    }

    public SupportedSpecialValues getSupportedSpecialValues() {
        SupportedSpecialValues supportedSpecialValues = new SupportedSpecialValues();
        if (this.prompt instanceof MutableSupportedSpecialValuesInterface) {
            supportedSpecialValues.setAllSupported(this.allCheckBox.isSelected());
            supportedSpecialValues.setOtherSupported(this.noneCheckBox.isSelected());
            supportedSpecialValues.setMissingValuesSupported(this.missingCheckBox.isSelected());
        }
        return supportedSpecialValues;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        try {
            if (this.promptValuesDefaultValue.isPromptValueAvailable((PromptDefinitionInterface)this.promptObject)) {
                Object defaultValue = this.promptValuesDefaultValue.getPromptValue((PromptDefinitionInterface)this.promptObject);
                ((MutablePromptDefinitionInterface)this.prompt).setDefaultValue(defaultValue);
            }
        }
        catch (IllegalArgumentException exception) {
            if (!suppressErrors) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(exception.getMessage());
                JOptionPane.showOptionDialog(this, exception.getMessage(), ERROR_MESSAGE_DIALOG_TITLE, -1, 0, null, ERROR_MESSAGE_DIALOG_OPTIONS, ERROR_MESSAGE_DIALOG_OPTIONS[0]);
                this.setContentsValid(false);
            }
            return this.prompt;
        }
        catch (PromptValueNotFoundException pvnf) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
        }
        return this.prompt;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.getPromptDefinition(false);
    }

    @Override
    public boolean isContentsValid() {
        return this.contentsValid;
    }

    @Override
    public void setContentsValid(boolean newValue) {
        if (newValue != this.contentsValid) {
            this.contentsValid = newValue;
            this.firePropertyChange("contentsValid", !this.contentsValid, this.contentsValid);
        }
    }
}

