/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.visuals.swing.designtime.ValidatePromptNameInterface;
import com.sas.visuals.Resources;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

class InvalidPromptTableCellRenderer
extends DefaultTableCellRenderer {
    private ImageIcon promptWarningIcon = new ImageIcon(Resources.getImage((String)"MessageError.gif", (int)16));
    private ValidatePromptNameInterface validator;
    private static final long serialVersionUID = 3257563988660598326L;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        TableModel model = table.getModel();
        int rowCount = model.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (i == row) continue;
            String promptName = (String)model.getValueAt(i, 1);
            if (this.hasNameConflict((String)value, promptName)) {
                this.setIcon(this.promptWarningIcon);
                this.setText((String)value);
                break;
            }
            this.setIcon(null);
            this.setText((String)value);
        }
        return this;
    }

    private boolean hasNameConflict(String value, String promptName) {
        if (value == null || value.trim().length() == 0) {
            return false;
        }
        if (promptName == null || promptName.trim().length() == 0) {
            return false;
        }
        return value.equals(promptName);
    }
}

