/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.SpecialValues;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.IntegerDefinition;
import com.sas.prompts.definitions.IntegerDefinitionInterface;
import com.sas.prompts.definitions.MutableIntegerDefinitionInterface;
import com.sas.prompts.definitions.MutablePromptDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.HorizontalGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BaseSpecialValuesPanel;
import com.sas.prompts.visuals.swing.designtime.PromptGroupUtility;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.SupportedSpecialValuesInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import javax.swing.JPanel;

class IntegerSingleValuePanel
extends BaseSpecialValuesPanel
implements PromptValueChangeListener,
ItemListener {
    private PromptValues promptValuesMinMax;
    private PromptValues promptValuesDefaultValue;
    private PromptPropertiesPanel promptPropertiesPanelMinMax;
    private PromptPropertiesPanel promptPropertiesPanelDefaultValue;
    private IntegerDefinition integerPrompt;
    private IntegerDefinition promptMaxValue;
    private IntegerDefinition promptMinValue;
    private IntegerDefinition promptDefaultValue;
    private static final long serialVersionUID = 3257563988660598326L;

    public IntegerSingleValuePanel(PropertiesCommunicator communicator) {
        this(null, communicator);
    }

    public IntegerSingleValuePanel(IntegerDefinitionInterface prompt, PropertiesCommunicator communicator) {
        super((PromptDefinitionInterface)prompt, communicator, 0);
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 5, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        TransparentGroup promptGroupMinMax = new TransparentGroup();
        HorizontalGroup horizGroupMinMax = new HorizontalGroup();
        this.promptMinValue = new IntegerDefinition("");
        this.promptMinValue.setPromptLabel(RB.getStringResource("minValue.txt"), this.getLocale());
        horizGroupMinMax.addPromptDefinition((PromptDefinitionInterface)this.promptMinValue);
        this.promptMaxValue = new IntegerDefinition("");
        this.promptMaxValue.setPromptLabel(RB.getStringResource("maxValue.txt"), this.getLocale());
        horizGroupMinMax.addPromptDefinition((PromptDefinitionInterface)this.promptMaxValue);
        promptGroupMinMax.addPromptSubgroup((PromptGroupInterface)horizGroupMinMax);
        this.promptValuesMinMax = new PromptValues((PromptGroupInterface)promptGroupMinMax, null);
        PromptUtility.configurePromptValuesForIntegerMinMaxValue(this.promptValuesMinMax, (PromptDefinitionInterface)prompt, (IntegerDefinitionInterface)this.promptMinValue, (IntegerDefinitionInterface)this.promptMaxValue, communicator, this.getLocale());
        this.promptPropertiesPanelMinMax = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesMinMax, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelMinMax);
        JPanel specialValuesPanel = this.createSpecialValuesFields();
        TransparentGroup promptDefaultGroup = new TransparentGroup();
        this.promptDefaultValue = new IntegerDefinition("");
        this.promptDefaultValue.setPromptLabel(RB.getStringResource("defaultValue.txt"), this.getLocale());
        promptDefaultGroup.addPromptDefinition((PromptDefinitionInterface)this.promptDefaultValue);
        this.promptValuesDefaultValue = new PromptValues((PromptGroupInterface)promptDefaultGroup, null);
        if (prompt != null) {
            try {
                Object defaultValue;
                SupportedSpecialValues supportedSpecialValues = prompt.getSupportedSpecialValues();
                this.promptDefaultValue.setSupportedSpecialValues(PromptUtility.refineSpecialValues(supportedSpecialValues));
                boolean defaultValueSet = prompt.isDefaultValueSet();
                if (defaultValueSet && (defaultValue = prompt.getDefaultValue()) != SpecialValues.OTHER) {
                    this.promptValuesDefaultValue.setPromptValue((PromptDefinitionInterface)this.promptDefaultValue, prompt.getDefaultValue());
                }
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
            }
        } else {
            SupportedSpecialValues supportedSpecialValues = new SupportedSpecialValues();
            supportedSpecialValues.setAllSupported(this.allCheckBox.isSelected());
            supportedSpecialValues.setMissingValuesSupported(this.missingCheckBox.isSelected());
            if (this.promptDefaultValue instanceof SupportedSpecialValuesInterface) {
                this.promptDefaultValue.setSupportedSpecialValues(supportedSpecialValues);
            }
            PromptUtility.configureIntegerDefaultValueNoValueProvider(this.promptValuesDefaultValue, (IntegerDefinitionInterface)this.promptDefaultValue, communicator, this.getLocale());
        }
        this.promptPropertiesPanelDefaultValue = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesDefaultValue, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelDefaultValue);
        this.add(this.promptPropertiesPanelMinMax);
        this.add(specialValuesPanel);
        this.add(this.promptPropertiesPanelDefaultValue);
        this.allCheckBox.addItemListener(this);
        this.noneCheckBox.addItemListener(this);
        this.missingCheckBox.addItemListener(this);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        SupportedSpecialValues supportedSpecialValues = new SupportedSpecialValues();
        supportedSpecialValues.setAllSupported(this.allCheckBox.isSelected());
        supportedSpecialValues.setMissingValuesSupported(this.missingCheckBox.isSelected());
        if (this.promptDefaultValue instanceof SupportedSpecialValuesInterface) {
            this.promptDefaultValue.setSupportedSpecialValues(supportedSpecialValues);
        }
        if (this.promptValuesDefaultValue.isPromptValueAvailable((PromptDefinitionInterface)this.promptDefaultValue)) {
            try {
                Object obj = this.promptValuesDefaultValue.getPromptValue((PromptDefinitionInterface)this.promptDefaultValue);
                if (!PromptUtil.isValueAllowedIfSpecial((SupportedSpecialValues)supportedSpecialValues, (Object)obj)) {
                    this.promptValuesDefaultValue.clearPromptValue((PromptDefinitionInterface)this.promptDefaultValue);
                }
            }
            catch (PromptValueNotFoundException pvnf) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
            }
        }
        this.promptPropertiesPanelDefaultValue.refresh((PromptDefinitionInterface)this.promptDefaultValue);
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        this.setContentsValid(true);
        this.promptValuesMinMax.removePromptValueChangeListener((PromptValueChangeListener)this);
        this.promptValuesDefaultValue.removePromptValueChangeListener((PromptValueChangeListener)this);
        this.integerPrompt = (IntegerDefinition)PromptUtility.newConfiguredPrompt(this.communicator, "IntegerDefinition");
        try {
            PromptGroupUtility.setMinValueIntegerFromPromptValue((PromptValuesInterface)this.promptValuesMinMax, (PromptDefinitionInterface)this.promptMinValue, (MutableIntegerDefinitionInterface)this.integerPrompt);
            PromptGroupUtility.setMaxValueIntegerFromPromptValue((PromptValuesInterface)this.promptValuesMinMax, (PromptDefinitionInterface)this.promptMaxValue, (MutableIntegerDefinitionInterface)this.integerPrompt);
            SupportedSpecialValues supportedSpecialValues = new SupportedSpecialValues();
            supportedSpecialValues.setMissingValuesSupported(this.missingCheckBox.isSelected());
            supportedSpecialValues.setAllSupported(this.allCheckBox.isSelected());
            this.integerPrompt.setSupportedSpecialValues(supportedSpecialValues);
            PromptGroupUtility.setDefaultValueFromPromptValue((PromptValuesInterface)this.promptValuesDefaultValue, (PromptDefinitionInterface)this.promptDefaultValue, (MutablePromptDefinitionInterface)this.integerPrompt);
        }
        catch (IllegalArgumentException exception) {
            if (!suppressErrors) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(exception.getMessage(), (Throwable)exception);
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)exception.getMessage())), null);
                }
                this.setContentsValid(false);
                this.promptValuesDefaultValue.addPromptValueChangeListener((PromptValueChangeListener)this);
                this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
            }
            return this.integerPrompt;
        }
        catch (PromptValueNotFoundException pvnf) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage(), (Throwable)pvnf);
        }
        Collection errors = this.integerPrompt.validateDefinition(this.getLocale());
        if (errors.size() > 0 && !suppressErrors) {
            String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
            }
            this.setContentsValid(false);
            this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
            this.promptValuesDefaultValue.addPromptValueChangeListener((PromptValueChangeListener)this);
        }
        return this.integerPrompt;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.getPromptDefinition(false);
    }

    public void promptValueChanged(PromptValueChangeEventInterface event) {
        boolean isValid = this.promptPropertiesPanelMinMax.isContentsValid();
        this.setContentsValid(isValid);
    }
}

