/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.IntegerDefinition;
import com.sas.prompts.definitions.IntegerDefinitionInterface;
import com.sas.prompts.definitions.MutableIntegerDefinitionInterface;
import com.sas.prompts.definitions.MutableSelectableDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.prompts.groups.HorizontalGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BaseDynamicListPanel;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionInterface;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionWithErrorSuppressionOptionInterface;
import com.sas.prompts.visuals.swing.designtime.PromptGroupUtility;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.text.Message;
import com.sas.util.MutableSupportedSpecialValuesInterface;
import com.sas.util.Strings;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.JPanel;

class IntegerDynamicListPanel
extends BaseDynamicListPanel {
    private PromptValues promptValuesMinMax;
    private PromptPropertiesPanel promptPropertiesPanelMinMax;
    private IntegerDefinition integerPrompt;
    private IntegerDefinition promptMaxValue;
    private IntegerDefinition promptMinValue;
    private static final long serialVersionUID = 3257563988660598326L;

    public IntegerDynamicListPanel(String selectionType, PropertiesCommunicator communicator) {
        this((IntegerDefinitionInterface)null, selectionType, communicator);
    }

    public IntegerDynamicListPanel(IntegerDefinitionInterface prompt, String selectionType, PropertiesCommunicator communicator) {
        super((PromptDefinitionInterface)prompt, selectionType, communicator);
        this.createPromptPanel();
    }

    @Override
    protected void createPromptPanel() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 0, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        TransparentGroup promptGroupMinMax = new TransparentGroup();
        HorizontalGroup horizontalGroupMinMax = new HorizontalGroup();
        this.promptMinValue = new IntegerDefinition("");
        this.promptMinValue.setPromptLabel(RB.getStringResource("minValue.txt"), this.getLocale());
        horizontalGroupMinMax.addPromptDefinition((PromptDefinitionInterface)this.promptMinValue);
        this.promptMaxValue = new IntegerDefinition("");
        this.promptMaxValue.setPromptLabel(RB.getStringResource("maxValue.txt"), this.getLocale());
        horizontalGroupMinMax.addPromptDefinition((PromptDefinitionInterface)this.promptMaxValue);
        promptGroupMinMax.addPromptSubgroup((PromptGroupInterface)horizontalGroupMinMax);
        this.promptValuesMinMax = new PromptValues((PromptGroupInterface)promptGroupMinMax, null);
        PromptUtility.configurePromptValuesForIntegerMinMaxValue(this.promptValuesMinMax, this.prompt, (IntegerDefinitionInterface)this.promptMinValue, (IntegerDefinitionInterface)this.promptMaxValue, this.communicator, this.getLocale());
        this.promptPropertiesPanelMinMax = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesMinMax, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelMinMax);
        JPanel outerDatasourcePanel = this.createDatasourcePanel();
        this.createCustomPanel();
        this.customPanel.addPropertyChangeListener(this);
        this.communicator.addPropertyChangeListener(this);
        if (this.promptValuesValueCount != null) {
            this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
        }
        if (this.selectionType != "Single value") {
            this.add(this.promptPropertiesPanelValueCount);
        }
        this.add(this.promptPropertiesPanelMinMax);
        this.add(this.createMaximumDisplayValues());
        this.add(outerDatasourcePanel);
        this.createHolderPanel().add(this.customPanel);
        this.add(this.holderPanel);
        this.add(this.createAllowCustomValuesCheckBox());
    }

    @Override
    protected PromptDefinitionInterface intializePrompt() {
        if (this.prompt == null) {
            IntegerDefinition integerDefinitionPrompt = new IntegerDefinition();
            integerDefinitionPrompt.setAllowUserValues(false);
            if (this.selectionType != "Single value") {
                integerDefinitionPrompt.setMaximumValueCount(Integer.MAX_VALUE);
            }
            if (this.selectionType.equals("Multiple ordered values")) {
                integerDefinitionPrompt.setSelectionOrdered(true);
            }
            return integerDefinitionPrompt;
        }
        if (this.prompt instanceof MutableIntegerDefinitionInterface) {
            return (MutableIntegerDefinitionInterface)this.prompt;
        }
        return (IntegerDefinitionInterface)this.prompt;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        this.setContentsValid(true);
        this.promptValuesMinMax.removePromptValueChangeListener((PromptValueChangeListener)this);
        if (this.promptValuesValueCount != null) {
            this.promptValuesValueCount.removePromptValueChangeListener((PromptValueChangeListener)this);
        }
        this.setContentsValid(true);
        ValueProviderDefinitionInterface selectablePrompt = null;
        selectablePrompt = this.customPanel instanceof GetPromptDefinitionWithErrorSuppressionOptionInterface ? (ValueProviderDefinitionInterface)((GetPromptDefinitionWithErrorSuppressionOptionInterface)((Object)this.customPanel)).getPromptDefinition(suppressErrors) : (ValueProviderDefinitionInterface)((GetPromptDefinitionInterface)((Object)this.customPanel)).getPromptDefinition();
        ValueProviderInterface valueProvider = null;
        this.integerPrompt = (IntegerDefinition)PromptUtility.newConfiguredPrompt(this.communicator, "IntegerDefinition");
        if (this.customPanel != null) {
            valueProvider = selectablePrompt.getValueProvider();
            try {
                Integer pageSize;
                if (this.promptValuesMaxDisplay != null && this.promptValuesMaxDisplay.isPromptValueAvailable((PromptDefinitionInterface)this.promptMaxDisplay) && (pageSize = (Integer)this.promptValuesMaxDisplay.getPromptValue((PromptDefinitionInterface)this.promptMaxDisplay)) != null) {
                    this.integerPrompt.setPageSize(pageSize.intValue());
                }
            }
            catch (PromptValueNotFoundException pvnf) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
            }
        }
        if (this.selectionType != "Single value") {
            this.integerPrompt.setMaximumValueCount(Integer.MAX_VALUE);
        }
        if (this.selectionType.equals("Multiple ordered values")) {
            this.integerPrompt.setSelectionOrdered(true);
        }
        if (valueProvider != null) {
            this.integerPrompt.setValueProvider(valueProvider);
        }
        this.integerPrompt.setAllowUserValues(selectablePrompt.isAllowUserValues());
        try {
            Integer maxValue;
            Integer minValue;
            if (this.promptValuesMinMax.isPromptValueAvailable((PromptDefinitionInterface)this.promptMinValue) && (minValue = (Integer)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMinValue)) != null) {
                this.integerPrompt.setMinimum(minValue.intValue());
            }
            if (this.promptValuesMinMax.isPromptValueAvailable((PromptDefinitionInterface)this.promptMaxValue) && (maxValue = (Integer)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMaxValue)) != null) {
                this.integerPrompt.setMaximum(maxValue.intValue());
            }
            if (this.selectionType != "Single value") {
                PromptGroupUtility.setMinValueCountFromPromptValue((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMinValueCount, (MutableSelectableDefinitionInterface)this.integerPrompt);
                PromptGroupUtility.setMaxValueCountFromPromptValue((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMaxValueCount, (MutableSelectableDefinitionInterface)this.integerPrompt);
            }
            if (selectablePrompt instanceof MutableSupportedSpecialValuesInterface) {
                SupportedSpecialValues supportedSpecialValues = ((MutableSupportedSpecialValuesInterface)selectablePrompt).getSupportedSpecialValues();
                this.integerPrompt.setSupportedSpecialValues(supportedSpecialValues);
            }
            if (((PromptDefinitionInterface)selectablePrompt).isDefaultValueSet()) {
                this.integerPrompt.setDefaultValue(((PromptDefinitionInterface)selectablePrompt).getDefaultValue());
            } else {
                this.integerPrompt.clearDefaultValue();
            }
            this.integerPrompt.setAllowUserValues(this.allowCustomValuesCheckBox.isSelected());
        }
        catch (IllegalArgumentException exception) {
            if (!suppressErrors) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(exception.getMessage());
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)exception.getMessage())), null);
                }
                this.setContentsValid(false);
                this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
                if (this.promptValuesValueCount != null) {
                    this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
                }
            }
            try {
                if (!this.isUserDefinedDataProvider()) {
                    ((DataProvider)this.dataProvider).close();
                }
            }
            catch (ServerConnectionException sce) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(sce.getMessage());
            }
            return this.integerPrompt;
        }
        catch (PromptValueNotFoundException pvnf) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
        }
        Collection errors = this.integerPrompt.validateDefinition(this.getLocale());
        if (errors.size() > 0 && !suppressErrors) {
            String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
            }
            this.setContentsValid(false);
            if (this.promptValuesValueCount != null) {
                this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
            }
            this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
        }
        try {
            if (!this.isUserDefinedDataProvider()) {
                ((DataProvider)this.dataProvider).close();
            }
        }
        catch (ServerConnectionException sce) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(sce.getMessage());
        }
        return this.integerPrompt;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.getPromptDefinition(false);
    }

    @Override
    protected void verifyContentsValid() {
        boolean isValid = false;
        isValid = this.promptValuesValueCount != null ? this.promptPropertiesPanelMinMax.isContentsValid() && this.promptPropertiesPanelValueCount.isContentsValid() : this.promptPropertiesPanelMinMax.isContentsValid();
        this.setContentsValid(isValid);
    }
}

