/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.IntegerType;
import com.sas.models.MutableThresholdInterface;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.IntegerDefinition;
import com.sas.prompts.definitions.IntegerDefinitionInterface;
import com.sas.prompts.definitions.MutableSelectableDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.HorizontalGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.DataProviderUtil;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BaseCustomListPanel;
import com.sas.prompts.visuals.swing.designtime.PromptGroupUtility;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.prompts.visuals.swing.designtime.ValidatePromptInterface;
import com.sas.storage.valueprovider.StaticValueProvider;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.table.DefaultTableModel;

class IntegerCustomListPanel
extends BaseCustomListPanel {
    private PromptValues promptValuesMinMax;
    private PromptPropertiesPanel promptPropertiesPanelMinMax;
    private IntegerDefinition integerPrompt;
    private IntegerDefinition promptMaxValue;
    private IntegerDefinition promptMinValue;
    private static final long serialVersionUID = 3257563988660598326L;

    public IntegerCustomListPanel(String selectionType, PropertiesCommunicator communicator) {
        this((IntegerDefinitionInterface)null, selectionType, communicator);
    }

    public IntegerCustomListPanel(IntegerDefinitionInterface prompt, String selectionType, PropertiesCommunicator communicator) {
        super((PromptDefinitionInterface)prompt, selectionType, communicator);
        this.createPromptPanel();
    }

    @Override
    protected void createPromptPanel() {
        AutoSizingGridLayout layout = null;
        layout = new AutoSizingGridLayout(-1, 1, 5, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        TransparentGroup promptGroupMinMax = new TransparentGroup();
        HorizontalGroup horizontalGroupMinMax = new HorizontalGroup();
        this.promptMinValue = new IntegerDefinition("");
        this.promptMinValue.setPromptLabel(RB.getStringResource("minValue.txt"), this.getLocale());
        this.promptMinValue.setPromptName(PromptGroupUtility.MIN_VALUE);
        horizontalGroupMinMax.addPromptDefinition((PromptDefinitionInterface)this.promptMinValue);
        this.promptMaxValue = new IntegerDefinition("");
        this.promptMaxValue.setPromptLabel(RB.getStringResource("maxValue.txt"), this.getLocale());
        this.promptMaxValue.setPromptName(PromptGroupUtility.MAX_VALUE);
        horizontalGroupMinMax.addPromptDefinition((PromptDefinitionInterface)this.promptMaxValue);
        promptGroupMinMax.addPromptSubgroup((PromptGroupInterface)horizontalGroupMinMax);
        this.promptValuesMinMax = new PromptValues((PromptGroupInterface)promptGroupMinMax, null);
        PromptUtility.configurePromptValuesForIntegerMinMaxValue(this.promptValuesMinMax, this.prompt, (IntegerDefinitionInterface)this.promptMinValue, (IntegerDefinitionInterface)this.promptMaxValue, this.communicator, this.getLocale());
        this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
        this.promptPropertiesPanelMinMax = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesMinMax, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelMinMax);
        JLabel listOfChoices = new JLabel(RB.getStringResource("listOfChoices.txt"));
        this.createListEditor("Integer");
        this.communicator.addPropertyChangeListener(this);
        if (this.promptValuesValueCount != null) {
            this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
        }
        StaticValueProvider testProvider = new StaticValueProvider();
        if (this.listEditor != null) {
            try {
                if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesMinMax, (PromptDefinitionInterface)this.promptMinValue)) {
                    Integer minValue = (Integer)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMinValue);
                    this.listEditor.setMinValue(minValue);
                }
                if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesMinMax, (PromptDefinitionInterface)this.promptMaxValue)) {
                    Integer maxValue = (Integer)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMaxValue);
                    this.listEditor.setMaxValue(maxValue);
                }
            }
            catch (PromptValueNotFoundException pvnf) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
            }
        }
        if (this.selectionType != "Single value") {
            this.add(this.promptPropertiesPanelValueCount);
        }
        this.add(this.promptPropertiesPanelMinMax);
        if (testProvider instanceof MutableThresholdInterface) {
            this.add(this.createMaximumDisplayValues());
        }
        this.add(this.createAppendCheckBox());
        this.add(this.createSpecialValuesFields());
        this.add(listOfChoices);
        this.add((Component)((Object)this.listEditor));
        this.add(this.allowCustomPanel);
        this.addSpecialValuesListeners();
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        this.setContentsValid(true);
        if (this.promptValuesMinMax != null) {
            this.promptValuesMinMax.removePromptValueChangeListener((PromptValueChangeListener)this);
        }
        if (this.promptValuesValueCount != null) {
            this.promptValuesValueCount.removePromptValueChangeListener((PromptValueChangeListener)this);
        }
        this.promptValuesMinMax.removePromptValueChangeListener((PromptValueChangeListener)this);
        this.integerPrompt = (IntegerDefinition)PromptUtility.newConfiguredPrompt(this.communicator, "IntegerDefinition");
        this.integerPrompt.setAllowUserValues(this.allowCustomValuesCheckBox.isSelected());
        if (this.selectionType != "Single value") {
            this.integerPrompt.setMaximumValueCount(Integer.MAX_VALUE);
        }
        if (this.selectionType.equals("Multiple ordered values")) {
            this.integerPrompt.setSelectionOrdered(true);
        }
        try {
            Integer pageSize;
            Integer maxValue;
            Integer minValue;
            if (this.promptValuesMinMax.isPromptValueAvailable((PromptDefinitionInterface)this.promptMinValue) && (minValue = (Integer)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMinValue)) != null) {
                this.integerPrompt.setMinimum(minValue.intValue());
            }
            if (this.promptValuesMinMax.isPromptValueAvailable((PromptDefinitionInterface)this.promptMaxValue) && (maxValue = (Integer)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMaxValue)) != null) {
                this.integerPrompt.setMaximum(maxValue.intValue());
            }
            if (this.selectionType != "Single value") {
                PromptGroupUtility.setMinValueCountFromPromptValue((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMinValueCount, (MutableSelectableDefinitionInterface)this.integerPrompt);
                PromptGroupUtility.setMaxValueCountFromPromptValue((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMaxValueCount, (MutableSelectableDefinitionInterface)this.integerPrompt);
            }
            SupportedSpecialValues supportedSpecialValues = new SupportedSpecialValues();
            supportedSpecialValues.setMissingValuesSupported(this.missingCheckBox.isSelected());
            supportedSpecialValues.setAllSupported(this.allCheckBox.isSelected());
            supportedSpecialValues.setOtherSupported(this.noneCheckBox.isSelected());
            this.integerPrompt.setSupportedSpecialValues(supportedSpecialValues);
            DefaultTableModel tableModel = (DefaultTableModel)this.listEditor.getModel();
            List staticAndDefaultValueList = PromptUtility.createStaticValues(tableModel, (MutableSelectableDefinitionInterface)this.integerPrompt, this.getLocale());
            List staticValues = (List)staticAndDefaultValueList.get(0);
            List defaultValue = (List)staticAndDefaultValueList.get(1);
            if (!suppressErrors) {
                DataProvider provider = (DataProvider)this.communicator.getDataProvider();
                int staticThreshold = DataProviderUtil.DEFAULT_STATIC_THRESHOLD;
                if (provider != null) {
                    HashMap thresholdMap = (HashMap)provider.getThresholdMap();
                    staticThreshold = (Integer)thresholdMap.get(DataProviderUtil.STATIC_LIST_THRESHOLD);
                }
                int staticValuesSize = staticValues.size();
                if (this.missingCheckBox.isSelected()) {
                    ++staticValuesSize;
                }
                if (this.allCheckBox.isSelected()) {
                    ++staticValuesSize;
                }
                if (this.noneCheckBox.isSelected()) {
                    ++staticValuesSize;
                }
                if (staticValuesSize > staticThreshold) {
                    this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                    if (this.getGenericErrorHandler() != null) {
                        this.getGenericErrorHandler().handleError((Object)this, new Message(RB.getStringResource("tooManyValues.txt"), (Object)String.valueOf(staticValuesSize), (Object)String.valueOf(staticThreshold)), null);
                    }
                    this.setContentsValid(false);
                }
            }
            if (PromptUtility.hasDuplicateLabels(staticValues)) {
                String errorMessage = RB.getStringResource("nonUniqueLabels.txt");
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)this, new Message(errorMessage), null);
                }
                this.setContentsValid(false);
            }
            StaticValueProvider staticProvider = new StaticValueProvider();
            staticProvider.setDataType((DataTypeInterface)IntegerType.DEFAULT_INSTANCE);
            staticProvider.setValues(staticValues, this.getLocale());
            staticProvider.setValueDisplayed(this.appendCheckBox.isSelected());
            if (this.promptValuesMaxDisplay != null && this.promptValuesMaxDisplay.isPromptValueAvailable((PromptDefinitionInterface)this.promptMaxDisplay) && (pageSize = (Integer)this.promptValuesMaxDisplay.getPromptValue((PromptDefinitionInterface)this.promptMaxDisplay)) != null) {
                this.integerPrompt.setPageSize(pageSize.intValue());
            }
            this.integerPrompt.setValueProvider((ValueProviderInterface)staticProvider);
            if (defaultValue.size() > 0) {
                if (this.selectionType != "Single value") {
                    this.integerPrompt.setDefaultValue((Object)defaultValue);
                } else {
                    this.integerPrompt.setDefaultValue(defaultValue.get(0));
                }
            }
        }
        catch (IllegalArgumentException exception) {
            if (!suppressErrors) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(exception.getMessage());
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)exception.getMessage())), null);
                }
                this.setContentsValid(false);
                this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
                if (this.promptValuesValueCount != null) {
                    this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
                }
            }
            return this.integerPrompt;
        }
        catch (PromptValueNotFoundException pvnf) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
        }
        Collection errors = this.integerPrompt.validateDefinition(this.getLocale());
        if (errors.size() > 0 && !suppressErrors) {
            String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
            }
            this.setContentsValid(false);
            this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
            if (this.promptValuesValueCount != null) {
                this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
            }
        }
        ValidatePromptInterface promptValidator = this.communicator.getPromptValidator();
        PromptUtility.validatePrompt(this, promptValidator, (PromptDefinitionInterface)this.integerPrompt, suppressErrors, this.getLocale());
        return this.integerPrompt;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.getPromptDefinition(false);
    }

    @Override
    protected void verifyContentsValid() {
        boolean isValid = false;
        isValid = this.promptValuesValueCount != null ? this.promptPropertiesPanelMinMax.isContentsValid() && this.promptPropertiesPanelValueCount.isContentsValid() : this.promptPropertiesPanelMinMax.isContentsValid();
        this.setContentsValid(isValid);
    }

    @Override
    public void promptValueChanged(PromptValueChangeEventInterface event) {
        block10: {
            PromptDefinitionInterface promptDefinition = event.getPromptDefinition();
            if (promptDefinition.getPromptName().equals(PromptGroupUtility.MIN_VALUE)) {
                try {
                    if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesMinMax, (PromptDefinitionInterface)this.promptMinValue)) {
                        Integer minValue = (Integer)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMinValue);
                        this.listEditor.setMinValue(minValue);
                        break block10;
                    }
                    this.listEditor.setMinValue(Integer.MIN_VALUE);
                }
                catch (PromptValueNotFoundException pvnf) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
                }
            } else if (promptDefinition.getPromptName().equals(PromptGroupUtility.MAX_VALUE)) {
                try {
                    if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesMinMax, (PromptDefinitionInterface)this.promptMaxValue)) {
                        Integer maxValue = (Integer)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMaxValue);
                        this.listEditor.setMaxValue(maxValue);
                    } else {
                        this.listEditor.setMaxValue(Integer.MAX_VALUE);
                    }
                }
                catch (PromptValueNotFoundException pvnf) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
                }
            }
        }
        this.verifyContentsValid();
        super.promptValueChanged(event);
    }
}

