/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.MissingValues;
import com.sas.datatypes.DataTypeInterface;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.visuals.swing.designtime.BasePromptTypesAndValuesPanel;
import com.sas.prompts.visuals.swing.designtime.DefaultValuesTableModel;
import com.sas.prompts.visuals.swing.designtime.DynamicValuesRelationalPanel;
import com.sas.prompts.visuals.swing.designtime.GetTableModelInterface;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.swing.visuals.DataSourcePicker;
import com.sas.swing.visuals.EditorListener;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.ValueItem;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableModel;

class GetChoicesPanel
extends BasePromptTypesAndValuesPanel
implements EditorListener,
GetTableModelInterface,
ActionListener {
    private boolean contentsValid = true;
    private String selectionType;
    private String promptType;
    private DataSourcePicker datasourcePicker;
    private JPanel holderPanel;
    private DynamicValuesRelationalPanel relationalPanel;
    private JRadioButton currentMapRadio;
    private JRadioButton selectRadio;
    private DataSourceInterface currentIMSMap;
    private List selectedItems;
    private static final long serialVersionUID = 3257563988660598326L;
    private static final String DEFAULT_HELP_ID = "getvaluesdialog";

    public GetChoicesPanel(String promptType, String selectionType, PropertiesCommunicator communicator) {
        super(communicator);
        this.promptType = promptType;
        this.selectionType = selectionType;
        this.createPanel();
        this.setHelpID(DEFAULT_HELP_ID);
    }

    public void setSelectedItems(List selectedItems) {
        this.selectedItems = selectedItems;
        if (this.relationalPanel != null) {
            this.relationalPanel.setInitialSelectedItems(selectedItems);
        }
    }

    public List getSelectedItems() {
        return this.selectedItems;
    }

    private void createPanel() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 0, 5, true, true, true);
        this.setLayout((LayoutManager)layout);
        JPanel datasourcePanel = new JPanel();
        AutoSizingGridLayout datasourceLayout = new AutoSizingGridLayout(2, 1, 10, 5, true, false, true);
        datasourcePanel.setLayout((LayoutManager)datasourceLayout);
        JLabel datasourceLabel = new JLabel(RB.getStringResource("datasource.txt"));
        this.currentIMSMap = this.communicator.getDataSource();
        this.datasourcePicker = new DataSourcePicker(this.communicator.getUserContext());
        this.datasourcePicker.setAllowedDataSources(5L);
        try {
            this.datasourcePicker.setInitialPossibleValues(PromptUtility.getReferencedDataSources(this.communicator.getRootPromptGroup(), -1L, this.communicator.getUserContext(), null));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.datasourcePicker.addEditorListener(this);
        if (this.communicator.isCurrentMapSelectorEnabled()) {
            datasourceLabel = new JLabel(RB.getStringResource("dataSource.txt"));
            JPanel IMSHolderPanel = new JPanel();
            AutoSizingGridLayout IMSHolderPanelLayout = new AutoSizingGridLayout(2, 1, 10, 5, true, false, true);
            IMSHolderPanel.setLayout((LayoutManager)IMSHolderPanelLayout);
            JPanel currentMapPanel = new JPanel();
            AutoSizingGridLayout currentMapPanelLayout = new AutoSizingGridLayout(1, 1, 10, 5, true, false, true);
            currentMapPanel.setLayout((LayoutManager)currentMapPanelLayout);
            this.currentMapRadio = new JRadioButton(RB.getStringResource("useCurrentMap.txt"));
            this.currentMapRadio.addActionListener(this);
            currentMapPanel.add(this.currentMapRadio);
            JPanel dataSourcePickerPanel = new JPanel();
            AutoSizingGridLayout dataSourcePickerPanelLayout = new AutoSizingGridLayout(1, 2, 10, 5, true, false, true);
            dataSourcePickerPanel.setLayout((LayoutManager)dataSourcePickerPanelLayout);
            this.selectRadio = new JRadioButton(RB.getStringResource("specifyDataSource.txt"));
            this.selectRadio.addActionListener(this);
            dataSourcePickerPanel.add(this.selectRadio);
            dataSourcePickerPanel.add(this.datasourcePicker);
            IMSHolderPanel.add(currentMapPanel);
            IMSHolderPanel.add(dataSourcePickerPanel);
            Border emptyBorder = BorderFactory.createEmptyBorder(0, 5, 2, 5);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(RB.getStringResource("dataSource.txt"));
            datasourcePanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, emptyBorder));
            this.datasourcePicker.setEnabled(false);
            this.currentMapRadio.setSelected(true);
            this.selectRadio.setSelected(false);
            datasourcePanel.add(IMSHolderPanel);
        } else {
            datasourcePanel.add(datasourceLabel);
            datasourcePanel.add(this.datasourcePicker);
        }
        this.datasourcePicker.setName("datasourcePicker");
        this.holderPanel = new JPanel();
        AutoSizingGridLayout holderPanelLayout = new AutoSizingGridLayout(1, 1, 10, 5, true, true, true);
        this.holderPanel.setLayout((LayoutManager)holderPanelLayout);
        DataSourceInterface dataSource = null;
        if (this.communicator.getDataSourceColumn() != null) {
            dataSource = this.communicator.getDataSourceColumn().getDataSource();
        } else if (this.communicator.getDataSource() != null) {
            dataSource = this.communicator.getDataSource();
        }
        if (dataSource != null) {
            long dataSourceType = dataSource.getDataSourceType();
            if (dataSourceType == 4L || dataSourceType == 1L) {
                if (dataSource != this.currentIMSMap) {
                    this.datasourcePicker.setValue(dataSource);
                }
                if (!this.communicator.isDataSourceChangeable()) {
                    this.datasourcePicker.setEnabled(false);
                }
            } else {
                dataSource = null;
            }
        }
        if (this.relationalPanel == null) {
            this.relationalPanel = this.selectionType.equals("Single value") ? new DynamicValuesRelationalPanel(this.promptType, null, "Multiple values", dataSource, this.communicator, false) : new DynamicValuesRelationalPanel(this.promptType, null, this.selectionType, dataSource, this.communicator, false);
        }
        this.relationalPanel.setInitialSelectedItems(this.getSelectedItems());
        this.holderPanel.add(this.relationalPanel);
        this.add(datasourcePanel);
        this.add(this.holderPanel);
        this.setPreferredSize(new Dimension(580, 500));
    }

    public void valueChanged(ChangeEvent e) {
        if (e.getSource() == this.datasourcePicker) {
            this.dataSourceChanged();
        } else {
            this.setContentsValid(true);
        }
    }

    public void editingStopped(ChangeEvent e) {
    }

    public void editingStarted(ChangeEvent e) {
    }

    public void valueModified(ChangeEvent e) {
    }

    @Override
    public boolean isContentsValid() {
        return this.contentsValid;
    }

    @Override
    public void setContentsValid(boolean newValue) {
        if (newValue != this.contentsValid) {
            this.contentsValid = newValue;
            this.firePropertyChange("contentsValid", !this.contentsValid, this.contentsValid);
        }
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return null;
    }

    @Override
    public DefaultValuesTableModel getTableModel() {
        DefaultValuesTableModel tableModel = null;
        if (this.relationalPanel != null) {
            List items = this.relationalPanel.getSelectedItems();
            JTable table = new JTable();
            Object[] columnNames = new String[]{RB.getStringResource("choiceLabels.txt"), RB.getStringResource("choiceValues.txt"), RB.getStringResource("default.txt")};
            tableModel = this.promptType.equals("Numeric") ? new DefaultValuesTableModel("Numeric", this.selectionType) : (this.promptType.equals("Integer") ? new DefaultValuesTableModel("Integer", this.selectionType) : (this.promptType.equals("Date") ? new DefaultValuesTableModel("Date", this.selectionType) : new DefaultValuesTableModel("Text", this.selectionType)));
            tableModel.setColumnIdentifiers(columnNames);
            table.setModel((TableModel)((Object)tableModel));
            DataTypeInterface dataType = PromptUtility.getDataType(this.promptType);
            ValueItem labelValueItem = (ValueItem)this.relationalPanel.getLabelDataItem();
            if (dataType != null) {
                int listSize = items.size();
                for (int i = 0; i < listSize; ++i) {
                    Vector<Object> v = new Vector<Object>();
                    ValueItem valueItem = (ValueItem)items.get(i);
                    Object value = valueItem.getValue();
                    Object coercedValueItemValue = dataType.coerceValue(value, this.getLocale());
                    v.add(coercedValueItemValue);
                    try {
                        String testLabel;
                        if (coercedValueItemValue == null || coercedValueItemValue instanceof MissingValues) continue;
                        String labelForFormattedValueItem = labelValueItem.getLabel();
                        String label = valueItem.getLabel();
                        String returnedLabel = PromptUtility.getLabelForVector(dataType, label, testLabel = dataType.getDisplayString(coercedValueItemValue, this.getLocale()), value, this.getLocale());
                        if (returnedLabel != null && !returnedLabel.equals("null")) {
                            v.add(returnedLabel);
                        }
                        v.add(Boolean.FALSE);
                        tableModel.addRow(v);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }
        return tableModel;
    }

    @Override
    public void onApply() {
        this.setContentsValid(true);
        Object dataType = null;
        if (!this.relationalPanel.isValidValues(this.promptType)) {
            this.contentsValid = false;
            return;
        }
        if (this.relationalPanel.getErrorMessage() != null) {
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)Util.getParentFrame((Component)this), new Message(Strings.padSingleQuotesForMessage((String)this.relationalPanel.getErrorMessage())), null);
            }
            this.setContentsValid(false);
            return;
        }
        super.onApply();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.selectRadio) {
            this.selectRadio.setSelected(true);
            this.currentMapRadio.setSelected(false);
            this.datasourcePicker.setEnabled(true);
            this.dataSourceChanged();
        } else if (e.getSource() == this.currentMapRadio) {
            this.selectRadio.setSelected(false);
            this.currentMapRadio.setSelected(true);
            this.datasourcePicker.setEnabled(false);
            this.dataSourceChanged();
        }
    }

    private void dataSourceChanged() {
        DataSourceInterface dataSource = this.communicator.isCurrentMapSelectorEnabled() && !this.selectRadio.isSelected() ? this.currentIMSMap : (DataSourceInterface)this.datasourcePicker.getValue();
        this.setSelectedItems(this.relationalPanel.getSelectedItems());
        this.holderPanel.removeAll();
        this.relationalPanel = this.selectionType.equals("Single value") ? new DynamicValuesRelationalPanel(this.promptType, null, "Multiple values", dataSource, this.communicator, false) : new DynamicValuesRelationalPanel(this.promptType, null, this.selectionType, dataSource, this.communicator, false);
        this.relationalPanel.setInitialSelectedItems(this.getSelectedItems());
        this.holderPanel.add(this.relationalPanel);
        this.updateUI();
        this.setContentsValid(true);
    }
}

