/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.PromptUtil;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.definitions.MutablePromptDefinitionInterface;
import com.sas.prompts.definitions.MutableRequiredDefinitionInterface;
import com.sas.prompts.definitions.MutableSelectableDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.shared.SharedPromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.visuals.swing.designtime.BasePanel;
import com.sas.prompts.visuals.swing.designtime.GetLocationForPromptInterface;
import com.sas.prompts.visuals.swing.designtime.MacroVariableOptionsPanel;
import com.sas.prompts.visuals.swing.designtime.PromptObjectComboBoxRenderer;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.prompts.visuals.swing.designtime.ValidatePromptInterface;
import com.sas.prompts.visuals.swing.designtime.ValidatePromptNameInterface;
import com.sas.swing.util.SASJavaHelp;
import com.sas.swing.visuals.OptionsDialog;
import com.sas.swing.visuals.PanelInterface;
import com.sas.swing.visuals.PanelInterfaceV2;
import com.sas.swing.visuals.WideComboBox;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.ValueItem;
import com.sas.util.macrovar.BaseMacroInfoSource;
import com.sas.util.macrovar.MacroVariableListOptionInterface;
import com.sas.util.macrovar.MacroVariableOptionInterface;
import com.sas.util.macrovar.MutableMacroVariableListOptionInterface;
import com.sas.util.macrovar.MutableMacroVariableOptionInterface;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class GeneralPromptPropertiesPanel
extends BasePanel
implements ItemListener,
PropertyChangeListener,
DocumentListener,
GetLocationForPromptInterface,
PanelInterfaceV2,
ActionListener,
FocusListener {
    private MacroVariableOptionInterface macroInfo;
    private boolean contentsValid = true;
    private boolean isEditing;
    private JTextField nameTextField;
    private JTextField userPromptTextField;
    private JTextArea descriptionTextArea;
    private JCheckBox hiddenCheckBox;
    private JCheckBox fixedValueCheckBox;
    private JCheckBox requiredCheckBox;
    private JPanel optionsPanel;
    private WideComboBox locationCombo;
    private String helpID;
    private String helpProduct;
    private String originalName;
    private static final String GENERAL_PROMPT_PROPERTIES_PANEL = "GeneralPromptPropertiesPanel";
    private static final int NAME_FIELD = 1;
    private static final int LABEL_FIELD = 2;
    private static final int ALL_FIELDS = 3;
    private static final long serialVersionUID = 3257563988660598326L;
    public static final String DEFAULT_HELP_ID = "promptgentab";
    private boolean promptIsShared;
    private PromptGroupInterface parentPromptGroup;
    private boolean showErrorsUponValidation;

    public GeneralPromptPropertiesPanel(PropertiesCommunicator communicator) {
        this(communicator, null);
    }

    public GeneralPromptPropertiesPanel(PropertiesCommunicator communicator, PromptDefinitionInterface promptObject) {
        this(communicator, promptObject, true);
    }

    public GeneralPromptPropertiesPanel(PropertiesCommunicator communicator, PromptDefinitionInterface promptObject, boolean enableLocationSelector) {
        super(communicator);
        if (null != promptObject && promptObject instanceof SharedPromptDefinitionInterface) {
            this.promptIsShared = true;
        }
        this.contentsValid = true;
        this.showErrorsUponValidation = true;
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.optionsPanel = new JPanel();
        this.isEditing = promptObject != null;
        this.parentPromptGroup = communicator.getParentPromptGroup();
        this.makeLabelsPanel(promptObject, communicator.getParentPromptGroup());
        if (promptObject != null) {
            this.setProperties(promptObject);
            if (promptObject instanceof MacroVariableOptionInterface) {
                this.macroInfo = promptObject;
            }
        } else {
            this.isEditing = false;
        }
        if (this.macroInfo == null) {
            this.macroInfo = new BaseMacroInfoSource(null);
        }
        if (communicator.isPromptRequired()) {
            this.requiredCheckBox.setEnabled(false);
        }
        this.requiredCheckBox.addItemListener(this);
        this.communicator.addPropertyChangeListener(this);
        this.setHelpID(DEFAULT_HELP_ID);
        this.setPreferredSize(new Dimension(500, 375));
    }

    protected void makeLabelsPanel(PromptDefinitionInterface promptObject, PromptGroupInterface parentPromptGroup) {
        boolean hasSharedAncestors = false;
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(-1, 1, 5, 5, true, false, true);
        this.setLayout((LayoutManager)mainLayout);
        JLabel nameLabel = new JLabel(RB.getStringResource("name.txt"));
        this.nameTextField = new JTextField();
        this.nameTextField.addFocusListener(this);
        nameLabel.setLabelFor(this.nameTextField);
        JPanel nameVariablePanel = new JPanel();
        AutoSizingGridLayout nameVariableLayout = null;
        nameVariableLayout = new AutoSizingGridLayout(1, 1, 5, 5, false, false, true);
        nameVariablePanel.setLayout((LayoutManager)nameVariableLayout);
        nameVariablePanel.add(this.nameTextField);
        JLabel userPromptLabel = new JLabel(RB.getStringResource("userLabel.txt"));
        this.userPromptTextField = new JTextField();
        userPromptLabel.setLabelFor(this.userPromptTextField);
        JLabel descriptionLabel = new JLabel(RB.getStringResource("description.txt"));
        this.descriptionTextArea = new JTextArea();
        this.descriptionTextArea.setRows(5);
        this.descriptionTextArea.setFont(UIManager.getFont("TextField.font"));
        JScrollPane scrollPane = new JScrollPane(this.descriptionTextArea);
        descriptionLabel.setLabelFor(scrollPane);
        descriptionLabel.setLabelFor(this.descriptionTextArea);
        JLabel locationLabel = new JLabel(RB.getStringResource("location.txt"));
        this.locationCombo = new WideComboBox();
        this.locationCombo.setPopupStyle(5);
        boolean enableLocationSelector = this.communicator.isLocationSelectorEnabled();
        PromptGroupInterface rootPromptGroup = this.communicator.getRootPromptGroup();
        if (enableLocationSelector && rootPromptGroup != null && null != parentPromptGroup) {
            PromptObjectComboBoxRenderer renderer = new PromptObjectComboBoxRenderer(rootPromptGroup, promptObject, this.locale);
            this.locationCombo.setRenderer((ListCellRenderer)renderer);
            hasSharedAncestors = PromptUtility.hasAncestorSharedGroup(rootPromptGroup, parentPromptGroup);
            if (!hasSharedAncestors) {
                List things = this.communicator.getGroupListModel();
                DefaultComboBoxModel model = new DefaultComboBoxModel();
                if (null != things) {
                    for (int i = 0; i < things.size(); ++i) {
                        model.addElement(things.get(i));
                    }
                }
                this.locationCombo.setModel(model);
                locationLabel.setLabelFor((Component)this.locationCombo);
            }
        }
        this.makeOptionsPanel(true);
        this.add(nameLabel);
        this.add(nameVariablePanel);
        this.add(userPromptLabel);
        this.add(this.userPromptTextField);
        this.add(descriptionLabel);
        this.add(scrollPane);
        if (!this.communicator.isCurrentMapSelectorEnabled()) {
            this.add(locationLabel);
            this.add((Component)this.locationCombo);
        }
        locationLabel.setEnabled(false);
        this.locationCombo.setEnabled(false);
        if (enableLocationSelector && rootPromptGroup != null && parentPromptGroup != null) {
            boolean found = false;
            int modelSize = this.locationCombo.getModel().getSize();
            for (int i = 0; i < modelSize; ++i) {
                Object currentObject = ((ValueItem)this.locationCombo.getItemAt(i)).getValue();
                if (!parentPromptGroup.equals(currentObject)) continue;
                found = true;
                this.locationCombo.setSelectedIndex(i);
                break;
            }
            if (found && !hasSharedAncestors) {
                locationLabel.setEnabled(true);
                this.locationCombo.setEnabled(true);
            } else {
                ValueItem selectedItem = new ValueItem((Object)parentPromptGroup.getPromptGroupLabel(this.locale), (Object)parentPromptGroup);
                ((DefaultComboBoxModel)this.locationCombo.getModel()).addElement(selectedItem);
                this.locationCombo.setSelectedItem((Object)selectedItem);
                locationLabel.setEnabled(false);
                this.locationCombo.setEnabled(false);
            }
        }
        this.add(this.optionsPanel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GeneralPromptPropertiesPanel.this.nameTextField.requestFocus();
            }
        });
        if (this.promptIsShared) {
            this.enableOptionsPanel(false, promptObject);
        }
    }

    private void setProperties(PromptDefinitionInterface promptObject) {
        this.userPromptTextField.setText(promptObject.getPromptLabel(this.locale));
        this.descriptionTextArea.setText(promptObject.getPromptDescription(this.locale));
        this.nameTextField.setText(promptObject.getPromptName());
        this.communicator.setPromptName(this.nameTextField.getText());
        this.originalName = promptObject.getPromptName();
        this.hiddenCheckBox.setSelected(promptObject.isHidden());
        this.requiredCheckBox.setSelected(promptObject.isRequired());
        this.fixedValueCheckBox.setSelected(promptObject.isFixed());
    }

    private void makeOptionsPanel(boolean showRequired) {
        AutoSizingGridLayout optionsLayout = new AutoSizingGridLayout(2, 2, 5, 10, true, false, false);
        this.optionsPanel.setLayout((LayoutManager)optionsLayout);
        this.optionsPanel.setBorder(BorderFactory.createTitledBorder(RB.getStringResource("options.txt")));
        this.hiddenCheckBox = new JCheckBox(RB.getStringResource("hidden.txt"));
        this.optionsPanel.add(this.hiddenCheckBox);
        this.requiredCheckBox = new JCheckBox(RB.getStringResource("required.txt"));
        if (showRequired) {
            this.optionsPanel.add(this.requiredCheckBox);
        }
        this.fixedValueCheckBox = new JCheckBox(RB.getStringResource("fixedValue.txt"));
        this.optionsPanel.add(this.fixedValueCheckBox);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.communicator.setRequired(this.requiredCheckBox.isSelected());
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource() == this.communicator) {
            if (e.getPropertyName().equals("requiredState")) {
                this.requiredCheckBox.removeItemListener(this);
                boolean newValue = (Boolean)e.getNewValue();
                this.requiredCheckBox.setSelected(newValue);
                this.requiredCheckBox.addItemListener(this);
            } else if (e.getPropertyName().equals("name")) {
                this.nameTextField.setText((String)e.getNewValue());
                this.communicator.setPromptName(this.nameTextField.getText());
            }
        } else if ("contentsValid".equals(e.getPropertyName())) {
            this.setContentsValid((Boolean)e.getNewValue());
        }
    }

    public MutablePromptDefinitionInterface setGeneralPropertiesOnPromptObject(MutablePromptDefinitionInterface prompt) {
        int minValueCount;
        String newPromptName;
        String promptName;
        if (this.communicator.getPromptNameCasingStyle() == 1) {
            promptName = this.nameTextField.getText();
            if (promptName != null && promptName.trim().length() > 0) {
                newPromptName = promptName.toLowerCase();
                this.nameTextField.setText(newPromptName.trim());
                this.communicator.setPromptName(this.nameTextField.getText());
            }
        } else if (this.communicator.getPromptNameCasingStyle() == 2 && (promptName = this.nameTextField.getText()) != null && promptName.trim().length() > 0) {
            newPromptName = promptName.toUpperCase();
            this.nameTextField.setText(newPromptName.trim());
            this.communicator.setPromptName(this.nameTextField.getText());
        }
        String promptLabel = this.userPromptTextField.getText();
        Collection errorsLabel = this.validatePromptLabel(promptLabel);
        if (errorsLabel.size() == 0) {
            prompt.setPromptLabel(promptLabel.trim(), this.locale);
        }
        if (prompt instanceof MutableRequiredDefinitionInterface) {
            ((MutableRequiredDefinitionInterface)prompt).setRequired(this.requiredCheckBox.isSelected());
        } else if (prompt instanceof MutableSelectableDefinitionInterface && (minValueCount = ((MutableSelectableDefinitionInterface)prompt).getMinimumValueCount()) <= 0) {
            ((MutableSelectableDefinitionInterface)prompt).setMinimumValueCount(this.requiredCheckBox.isSelected() ? 1 : -1);
        }
        prompt.setPromptName(this.nameTextField.getText());
        prompt.setPromptDescription(this.descriptionTextArea.getText(), this.locale);
        prompt.setHidden(this.hiddenCheckBox.isSelected());
        if (this.macroInfo != null) {
            if (prompt instanceof MutableMacroVariableOptionInterface) {
                prompt.setMacroVariableOutputLevel(this.macroInfo.getMacroVariableOutputLevel());
            }
            if (prompt instanceof MutableMacroVariableListOptionInterface && this.macroInfo instanceof MacroVariableListOptionInterface) {
                ((MutableMacroVariableListOptionInterface)prompt).setMacroVariableListFormat(((MacroVariableListOptionInterface)this.macroInfo).getMacroVariableListFormat());
                ((MutableMacroVariableListOptionInterface)prompt).setMacroVariableQuote(((MacroVariableListOptionInterface)this.macroInfo).getMacroVariableQuote());
                ((MutableMacroVariableListOptionInterface)prompt).setMacroVariableListDelimiter(((MacroVariableListOptionInterface)this.macroInfo).getMacroVariableListDelimiter());
            }
        }
        prompt.setFixed(this.fixedValueCheckBox.isSelected());
        return prompt;
    }

    void setShowErrorsUponValidation(boolean show) {
        this.showErrorsUponValidation = show;
    }

    boolean runValidators(MutablePromptDefinitionInterface prompt) {
        boolean isValid = true;
        if (null != prompt) {
            String errorMessage;
            this.setContentsValid(true);
            Collection errorsLabel = this.validatePromptLabel(this.userPromptTextField.getText());
            Collection errorsName = this.validatePromptName((PromptDefinitionInterface)prompt);
            ValidatePromptInterface promptValidator = this.communicator.getPromptValidator();
            PromptUtility.validatePrompt(this, promptValidator, (PromptDefinitionInterface)prompt, false, this.locale);
            if (this.communicator.isParentGroupHidden() && prompt.isRequired() && !prompt.isDefaultValueSet()) {
                errorMessage = Message.format((String)RB.getStringResource("hiddenRequiredEmptyPrompt.fmt.txt"), (Object)prompt.getPromptLabel(this.getLocale()));
                if (this.showErrorsUponValidation && this.getGenericErrorHandler() != null) {
                    this.firePropertyChange("errorPanel", null, GENERAL_PROMPT_PROPERTIES_PANEL);
                    this.getGenericErrorHandler().handleError((Object)this, new Message(errorMessage), null);
                }
                this.setContentsValid(false);
                this.enableListener(true);
                isValid = false;
            }
            if (errorsLabel.size() > 0) {
                if (errorsName != null && errorsName.size() > 0) {
                    Iterator iter = errorsName.iterator();
                    while (iter.hasNext()) {
                        errorsLabel.add(iter.next());
                    }
                }
                errorMessage = PromptUtil.formatErrorMessages((Collection)errorsLabel);
                if (this.showErrorsUponValidation && this.getGenericErrorHandler() != null) {
                    this.firePropertyChange("errorPanel", null, GENERAL_PROMPT_PROPERTIES_PANEL);
                    this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
                }
                this.setContentsValid(false);
                this.enableListener(true);
                isValid = false;
            } else {
                if (prompt.getPromptLabel(this.locale) == null) {
                    prompt.setPromptLabel(this.userPromptTextField.getText(), this.locale);
                }
                if (errorsName != null && errorsName.size() > 0) {
                    this.firePropertyChange("errorPanel", null, GENERAL_PROMPT_PROPERTIES_PANEL);
                    errorMessage = PromptUtil.formatErrorMessages((Collection)errorsName);
                    if (this.showErrorsUponValidation && this.getGenericErrorHandler() != null) {
                        this.firePropertyChange("errorPanel", null, GENERAL_PROMPT_PROPERTIES_PANEL);
                        this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
                    }
                    this.setContentsValid(false);
                    this.enableListener(true);
                    isValid = false;
                } else if (prompt.getPromptName() == null) {
                    prompt.setPromptName(this.nameTextField.getText());
                }
            }
        }
        return isValid;
    }

    private boolean promptNameHasChanged() {
        String currentName = this.nameTextField.getText();
        if (this.originalName == null && currentName == null) {
            return false;
        }
        if (this.originalName == null || currentName == null) {
            return true;
        }
        return !this.originalName.equals(currentName);
    }

    public Collection validatePromptLabel(String promptLabel) {
        ArrayList<ValidationEntry> errors = new ArrayList<ValidationEntry>();
        if (promptLabel == null || promptLabel.trim().length() == 0) {
            int rc = -1;
            String errMsg = Message.format((String)RB.getStringResource("noBlankPromptText.fmt.txt"), (Object)RB.getStringResource("promptTextNoColon.txt"));
            errors.add(new ValidationEntry((long)rc, errMsg));
        }
        return errors;
    }

    Collection validatePromptName(PromptDefinitionInterface prompt) {
        Collection errorsName = null;
        ValidatePromptNameInterface nameValidator = this.communicator.getNameValidator();
        if (nameValidator != null) {
            PromptDefinitionInterface originalPrompt;
            PromptGroupInterface promptGroup = null;
            if (this.communicator != null && this.parentPromptGroup != null) {
                promptGroup = this.parentPromptGroup;
            }
            String originalPromptName = (originalPrompt = this.communicator.getOriginalPrompt()) == null ? null : originalPrompt.getPromptName();
            int mode = originalPrompt == null ? 0 : 1;
            errorsName = nameValidator.validatePromptName(mode, prompt, promptGroup);
        }
        return errorsName;
    }

    @Override
    public Object getLocationForPrompt() {
        Object selectedItem;
        Object o = null;
        if (this.locationCombo != null && (selectedItem = this.locationCombo.getSelectedItem()) != null && selectedItem instanceof ValueItem) {
            o = ((ValueItem)selectedItem).getValue();
        }
        return o;
    }

    private void enableOptionsPanel(boolean enabled, PromptDefinitionInterface promptObject) {
        this.requiredCheckBox.setEnabled(enabled);
        this.fixedValueCheckBox.setEnabled(enabled);
        this.hiddenCheckBox.setEnabled(enabled);
        if (!enabled && promptObject instanceof SharedPromptDefinitionInterface) {
            this.requiredCheckBox.setText("<html>" + RB.getStringResource("required.txt") + "<html>");
            this.fixedValueCheckBox.setText("<html>" + RB.getStringResource("fixedValue.txt") + "<html>");
            this.hiddenCheckBox.setText("<html>" + RB.getStringResource("hidden.txt") + "<html>");
            this.requiredCheckBox.setForeground(SystemColor.textText);
            this.fixedValueCheckBox.setForeground(SystemColor.textText);
            this.hiddenCheckBox.setForeground(SystemColor.textText);
        }
    }

    public void clearOptionsPanel() {
        this.requiredCheckBox.setSelected(false);
        this.fixedValueCheckBox.setSelected(false);
        this.hiddenCheckBox.setSelected(false);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (!this.isContentsValid()) {
            this.setContentsValid(true);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (!this.isContentsValid()) {
            this.setContentsValid(true);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (!this.isContentsValid()) {
            this.setContentsValid(true);
        }
    }

    public void enableListener(boolean enable) {
        this.enableListener(enable, 3);
        this.nameTextField.getDocument().removeDocumentListener(this);
        if (enable) {
            this.nameTextField.getDocument().addDocumentListener(this);
        }
        this.userPromptTextField.getDocument().removeDocumentListener(this);
        if (enable) {
            this.userPromptTextField.getDocument().addDocumentListener(this);
        }
    }

    private void enableListener(boolean enable, int textField) {
        if (textField == 1) {
            this.nameTextField.getDocument().removeDocumentListener(this);
            if (enable) {
                this.nameTextField.getDocument().addDocumentListener(this);
            }
        } else if (textField == 2) {
            this.userPromptTextField.getDocument().removeDocumentListener(this);
            if (enable) {
                this.userPromptTextField.getDocument().addDocumentListener(this);
            }
        } else {
            this.nameTextField.getDocument().removeDocumentListener(this);
            this.userPromptTextField.getDocument().removeDocumentListener(this);
            if (enable) {
                this.nameTextField.getDocument().addDocumentListener(this);
                this.userPromptTextField.getDocument().addDocumentListener(this);
            }
        }
    }

    public boolean isContentsValid() {
        return this.contentsValid;
    }

    public void setContentsValid(boolean newValue) {
        if (newValue != this.contentsValid) {
            this.contentsValid = newValue;
            this.firePropertyChange("contentsValid", !this.contentsValid, this.contentsValid);
        }
    }

    public void onApply() {
    }

    public void onCancel() {
    }

    public void onClose() {
    }

    public String getDialogTitle() {
        return null;
    }

    public String getTabTitle() {
        return null;
    }

    public JComponent getPanel() {
        return this;
    }

    public String getHelpID() {
        return this.helpID;
    }

    public void setHelpID(String helpID) {
        this.helpID = helpID;
    }

    public boolean isYesNo() {
        return false;
    }

    public String getHelpProduct() {
        if (this.helpProduct != null) {
            return this.helpProduct;
        }
        return "dtprompt";
    }

    public void setHelpProduct(String helpProduct) {
        this.helpProduct = helpProduct;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.nameTextField) {
            this.communicator.setPromptName(this.nameTextField.getText());
        }
    }

    private void showMacroVariableOptions() {
        MacroVariableOptionsPanel macroOptionsPanel = new MacroVariableOptionsPanel(this.macroInfo, this.communicator);
        if (this.promptIsShared) {
            Util.setEnabledOnContainer((Container)macroOptionsPanel.getPanel(), (boolean)false);
        }
        OptionsDialog dialog = null;
        Container owner = SwingUtilities.getAncestorOfClass(Dialog.class, this);
        dialog = owner != null ? new OptionsDialog((Dialog)owner, RB.getStringResource("variablesTitle.txt"), true, 11, 4, this.getJavaHelp()) : new OptionsDialog((Frame)Util.getParentFrame((Component)this), RB.getStringResource("variablesTitle.txt"), true, 11, 4, this.getJavaHelp());
        dialog.setPanel((PanelInterface)macroOptionsPanel);
        dialog.setTitle(RB.getStringResource("variablesTitle.txt"));
        dialog.pack();
        Util.centerOver((Window)dialog, (Component)owner);
        dialog.setVisible(true);
        if (!dialog.wasCancelled()) {
            this.macroInfo = macroOptionsPanel.getMacroVariableInfo();
        }
    }

    public SASJavaHelp getJavaHelp() {
        if (this.communicator != null && this.communicator.getJavaHelp() != null) {
            return this.communicator.getJavaHelp();
        }
        return null;
    }
}

