/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.PromptUtil;
import com.sas.prompts.definitions.MutableSelectableDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.SelectableDefinitionInterface;
import com.sas.prompts.definitions.TextDefinition;
import com.sas.prompts.groups.ModalChoiceGroup;
import com.sas.prompts.groups.ModalChoiceGroupInterface;
import com.sas.prompts.groups.ModalGroupInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroupInterface;
import com.sas.prompts.groups.shared.SharedPromptGroup;
import com.sas.prompts.groups.shared.SharedPromptGroupInterface;
import com.sas.prompts.visuals.swing.designtime.BasePanel;
import com.sas.prompts.visuals.swing.designtime.GeneralGroupPropertiesConfigHelper;
import com.sas.prompts.visuals.swing.designtime.GetLocationForPromptInterface;
import com.sas.prompts.visuals.swing.designtime.PromptGroupPanelsInterface;
import com.sas.prompts.visuals.swing.designtime.PromptGroupUtility;
import com.sas.prompts.visuals.swing.designtime.PromptObjectComboBoxRenderer;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.prompts.visuals.swing.designtime.ValidatePromptNameInterface;
import com.sas.swing.visuals.ComboBox;
import com.sas.swing.visuals.Config;
import com.sas.swing.visuals.ConfigStateInterface;
import com.sas.swing.visuals.LimitedTextField;
import com.sas.swing.visuals.PanelInterface;
import com.sas.swing.visuals.WideComboBox;
import com.sas.swing.visuals.treetable.TreeTableRow;
import com.sas.text.Message;
import com.sas.util.ValueItem;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.xmlpersist.impl.PromptObjectFactory;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;

class GeneralGroupPropertiesPanel
extends BasePanel
implements PromptGroupPanelsInterface,
ActionListener,
PanelInterface,
ValidatePromptNameInterface,
DocumentListener,
GetLocationForPromptInterface,
ConfigStateInterface {
    private boolean isEditing;
    private boolean canChangeGroupType;
    protected boolean contentsValid = true;
    protected DefaultComboBoxModel model;
    protected DefaultComboBoxModel locationModel;
    protected LimitedTextField labelTextField;
    private JTextField parameterTextField;
    private JTextArea descriptionTextArea;
    protected PromptGroupInterface promptGroup;
    private PromptGroupInterface parentPromptGroup;
    private PromptGroupInterface rootPromptGroup;
    protected ComboBox groupTypeCombo;
    private WideComboBox locationCombo;
    private JCheckBox hiddenCheckBox;
    private JCheckBox requiredCheckBox;
    private String groupTypeSelectedItem;
    private String originalParameterLabel;
    private JPanel optionsPanel;
    private JPanel descriptionPanel;
    private Config config;
    private String parentPromptGroupString;
    protected DefaultTableModel tableModel;
    private ValueItem modalChoiceGroupValueItem;
    private static final long serialVersionUID = 3257563988660598326L;
    protected static final String RB_KEY = "General Group Properties.";

    public GeneralGroupPropertiesPanel(PromptGroupInterface promptGroup, PropertiesCommunicator communicator) {
        super(communicator);
        this.promptGroup = promptGroup;
        this.canChangeGroupType = false;
        this.initializeValues();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GeneralGroupPropertiesPanel.this.labelTextField.requestFocus();
            }
        });
    }

    public GeneralGroupPropertiesPanel(PromptGroupInterface promptGroup, PropertiesCommunicator communicator, boolean canChangeGroupType) {
        super(communicator);
        this.promptGroup = promptGroup;
        this.canChangeGroupType = canChangeGroupType;
        this.initializeValues();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GeneralGroupPropertiesPanel.this.labelTextField.requestFocus();
            }
        });
    }

    public GeneralGroupPropertiesPanel(String parentPromptGroupString, PropertiesCommunicator communicator) {
        super(communicator);
        this.parentPromptGroupString = parentPromptGroupString;
        this.canChangeGroupType = !"ModalGroup".equals(parentPromptGroupString);
        this.initializeValues();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GeneralGroupPropertiesPanel.this.labelTextField.requestFocus();
            }
        });
        if (this.isEditing && (this.promptGroup instanceof ModalChoiceGroupInterface || this.promptGroup instanceof ModalGroupInterface)) {
            this.groupTypeCombo.setEnabled(false);
        }
    }

    public GeneralGroupPropertiesPanel(boolean isModalChoiceGroup, PropertiesCommunicator communicator) {
        super(communicator);
        this.initializeValues();
    }

    GeneralGroupPropertiesPanel(PropertiesCommunicator communicator) {
        super(communicator);
        this.initializeValues();
        this.canChangeGroupType = false;
    }

    GeneralGroupPropertiesPanel(PropertiesCommunicator communicator, DefaultTableModel tableModel) {
        super(communicator);
        this.initializeValues();
        this.canChangeGroupType = false;
    }

    private void initializeValues() {
        this.contentsValid = true;
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.isEditing = this.promptGroup != null;
        this.rootPromptGroup = this.communicator.getRootPromptGroup();
        this.createGroupPanel();
        this.setPreferredSize(new Dimension(500, 400));
    }

    protected void createGroupPanel() {
        boolean enableLocationSelector = this.communicator.isLocationSelectorEnabled();
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(-1, 1, 5, 10, true, false, true);
        this.setLayout((LayoutManager)mainLayout);
        this.createGroupTypeComboBox();
        JLabel groupTypeLabel = new JLabel(RB.getStringResource("groupType.txt"));
        this.groupTypeSelectedItem = (String)((ValueItem)this.groupTypeCombo.getSelectedItem()).getValue();
        groupTypeLabel.setLabelFor((Component)this.groupTypeCombo);
        JLabel userLabel = new JLabel(RB.getStringResource("userLabel.txt"));
        this.labelTextField = new LimitedTextField();
        this.labelTextField.setMaxCharacters(60);
        userLabel.setLabelFor((Component)this.labelTextField);
        this.descriptionPanel = new JPanel();
        if (this.promptGroup != null) {
            if (this.promptGroup instanceof ModalGroupInterface) {
                this.makeDescriptionPanel("ModalGroup");
            } else if (this.promptGroup instanceof ModalChoiceGroupInterface) {
                this.makeDescriptionPanel("ModalChoiceGroup");
            } else {
                this.makeDescriptionPanel("PromptGroup");
            }
        } else if (this.getGroupType().equals("ModalGroup")) {
            this.makeDescriptionPanel("ModalGroup");
        } else if (this.getGroupType().equals("ModalChoiceGroup")) {
            this.makeDescriptionPanel("ModalChoiceGroup");
        } else {
            this.makeDescriptionPanel("PromptGroup");
        }
        JLabel locationLabel = new JLabel(RB.getStringResource("location.txt"));
        this.locationCombo = new WideComboBox();
        this.locationCombo.setPopupStyle(5);
        locationLabel.setLabelFor((Component)this.locationCombo);
        this.parentPromptGroup = null;
        Object parentObject = null;
        if (this.isEditing && this.rootPromptGroup != null && this.promptGroup != this.rootPromptGroup) {
            List ancestors = this.communicator.getPathToPrompt();
            int ancestorsSize = ancestors.size();
            if (ancestorsSize >= 2) {
                parentObject = ancestors.get(ancestorsSize - 2);
            }
            if (enableLocationSelector && parentObject != null && parentObject instanceof PromptGroupInterface) {
                PromptObjectComboBoxRenderer renderer = new PromptObjectComboBoxRenderer(this.rootPromptGroup, this.promptGroup, this.locale);
                this.locationCombo.setRenderer((ListCellRenderer)renderer);
                this.parentPromptGroup = parentObject;
                this.initializeLocationCombo(null);
                locationLabel.setLabelFor((Component)this.locationCombo);
            }
        }
        this.optionsPanel = new JPanel();
        if (this.promptGroup != null) {
            if (this.promptGroup instanceof ModalGroupInterface) {
                this.makeOptionsPanel(true);
            } else {
                this.makeOptionsPanel(false);
            }
        } else if ("ModalGroup".equals(this.getGroupType())) {
            this.makeOptionsPanel(true);
        } else {
            this.makeOptionsPanel(false);
        }
        this.add(groupTypeLabel);
        this.add((Component)this.groupTypeCombo);
        this.add(userLabel);
        this.add((Component)this.labelTextField);
        this.add(this.descriptionPanel);
        this.add(locationLabel);
        locationLabel.setEnabled(false);
        this.add((Component)this.locationCombo);
        this.locationCombo.setEnabled(false);
        if (enableLocationSelector && this.rootPromptGroup != null && this.parentPromptGroup != null && !this.communicator.hasAncestorSharedGroup() && (this.setLocationComboSelectedItem() || !this.locationCombo.isEnabled())) {
            locationLabel.setEnabled(true);
            this.locationCombo.setEnabled(true);
        }
        this.add(this.optionsPanel);
        this.initializeFields();
        this.groupTypeSelectedItem = (String)((ValueItem)this.groupTypeCombo.getSelectedItem()).getValue();
        this.groupTypeCombo.addActionListener((ActionListener)this);
    }

    private void initializeLocationCombo(String groupType) {
        if (this.locationModel == null) {
            this.locationModel = new DefaultComboBoxModel();
        } else {
            this.locationModel.removeAllElements();
        }
        this.locationCombo.setModel((ComboBoxModel)this.locationModel);
        if (!this.communicator.hasAncestorSharedGroup()) {
            List prunedList = null;
            List things = this.communicator.getGroupListModel();
            if (null != things) {
                prunedList = groupType != null ? PromptUtility.pruneListForGroupType(things, groupType) : PromptUtility.pruneList(things, this.promptGroup);
                for (int i = 0; i < prunedList.size(); ++i) {
                    this.locationModel.addElement(prunedList.get(i));
                }
            }
        } else {
            this.locationModel.addElement(new ValueItem((Object)this.parentPromptGroup.getPromptGroupLabel(this.locale), (Object)this.parentPromptGroup));
            this.locationCombo.setEnabled(false);
        }
    }

    List getPrunedList(String groupType) {
        List things = PromptUtility.createListModel(this.rootPromptGroup, this.promptGroup, this.locale);
        List prunedList = null;
        prunedList = groupType != null ? PromptUtility.pruneListForGroupType(things, groupType) : PromptUtility.pruneList(things, this.promptGroup);
        return prunedList;
    }

    private boolean setLocationComboSelectedItem() {
        int modelSize = this.locationModel.getSize();
        boolean found = false;
        for (int i = 0; i < modelSize; ++i) {
            Object currentObject = ((ValueItem)this.locationCombo.getItemAt(i)).getValue();
            if (!this.parentPromptGroup.equals(currentObject)) continue;
            this.locationCombo.setSelectedIndex(i);
            found = true;
            break;
        }
        return found;
    }

    protected void createGroupTypeComboBox() {
        this.groupTypeCombo = new ComboBox();
        this.model = new DefaultComboBoxModel();
        this.modalChoiceGroupValueItem = PromptUtility.newModalChoiceGroupValueItem();
        if (this.promptGroup != null) {
            if (this.promptGroup instanceof ModalChoiceGroupInterface) {
                this.model.addElement(this.modalChoiceGroupValueItem);
            } else if (this.promptGroup instanceof ModalGroupInterface) {
                this.model.addElement(PromptUtility.newModalGroupValueItem());
            } else if (this.promptGroup instanceof TransparentGroupInterface) {
                if (this.canChangeGroupType) {
                    this.model.addElement(PromptUtility.newStandardGroupValueItem());
                }
                this.model.addElement(PromptUtility.newTransparentGroupValueItem());
            } else {
                this.model.addElement(PromptUtility.newStandardGroupValueItem());
                if (this.canChangeGroupType) {
                    this.model.addElement(PromptUtility.newTransparentGroupValueItem());
                }
            }
        } else if (this.parentPromptGroupString != null) {
            if ("TransparentGroup".equals(this.parentPromptGroupString)) {
                this.model.addElement(PromptUtility.newTransparentGroupValueItem());
                this.model.addElement(PromptUtility.newModalGroupValueItem());
            } else if ("ModalGroup".equals(this.parentPromptGroupString)) {
                this.model.addElement(this.modalChoiceGroupValueItem);
            } else if (this.isEditing) {
                this.model.addElement(PromptUtility.newStandardGroupValueItem());
                this.model.addElement(PromptUtility.newTransparentGroupValueItem());
                this.model.addElement(PromptUtility.newModalGroupValueItem());
            } else if ("ModalChoiceGroup".equals(this.parentPromptGroupString)) {
                this.model.addElement(PromptUtility.newTransparentGroupValueItem());
                this.model.addElement(PromptUtility.newModalGroupValueItem());
            } else {
                this.model.addElement(PromptUtility.newStandardGroupValueItem());
                this.model.addElement(PromptUtility.newTransparentGroupValueItem());
                this.model.addElement(PromptUtility.newModalGroupValueItem());
            }
        }
        this.groupTypeCombo.setModel((ComboBoxModel)this.model);
        if (this.promptGroup instanceof SharedPromptGroupInterface) {
            this.groupTypeCombo.setEnabled(false);
        }
    }

    private void makeDescriptionPanel(String groupType) {
        boolean preserveText = this.descriptionTextArea != null;
        String previousDescription = null;
        if (preserveText) {
            previousDescription = this.descriptionTextArea.getText();
        }
        this.descriptionPanel.removeAll();
        AutoSizingGridLayout descriptionLayout = new AutoSizingGridLayout(-1, 1, 5, 10, true, false, true);
        this.descriptionPanel.setLayout((LayoutManager)descriptionLayout);
        JLabel descriptionLabel = new JLabel(RB.getStringResource("description.txt"));
        this.descriptionTextArea = new JTextArea();
        this.descriptionTextArea.setRows(5);
        this.descriptionTextArea.setFont(UIManager.getFont("TextField.font"));
        JScrollPane scrollPane = new JScrollPane(this.descriptionTextArea);
        descriptionLabel.setLabelFor(scrollPane);
        if (preserveText) {
            this.descriptionTextArea.setText(previousDescription);
        }
        if ("ModalGroup".equals(groupType)) {
            JLabel parameterLabel = new JLabel(RB.getStringResource("name.txt"));
            this.parameterTextField = new JTextField();
            parameterLabel.setLabelFor(this.parameterTextField);
            this.descriptionPanel.add(parameterLabel);
            this.descriptionPanel.add(this.parameterTextField);
        } else if ("ModalChoiceGroup".equals(groupType)) {
            JLabel parameterLabel = new JLabel(RB.getStringResource("value.txt"));
            this.parameterTextField = new JTextField();
            parameterLabel.setLabelFor(this.parameterTextField);
            this.descriptionPanel.add(parameterLabel);
            this.descriptionPanel.add(this.parameterTextField);
        }
        this.descriptionPanel.add(descriptionLabel);
        this.descriptionPanel.add(scrollPane);
        this.revalidate();
    }

    private void makeOptionsPanel(boolean showRequired) {
        boolean preserveHidden = this.hiddenCheckBox != null;
        boolean hiddenValue = false;
        if (preserveHidden) {
            hiddenValue = this.hiddenCheckBox.isSelected();
        }
        this.optionsPanel.removeAll();
        AutoSizingGridLayout optionsLayout = new AutoSizingGridLayout(1, -1, 5, 10, true, false, false);
        this.optionsPanel.setLayout((LayoutManager)optionsLayout);
        this.optionsPanel.setBorder(BorderFactory.createTitledBorder(RB.getStringResource("options.txt")));
        this.hiddenCheckBox = new JCheckBox(RB.getStringResource("hidden.txt"));
        this.optionsPanel.add(this.hiddenCheckBox);
        if (preserveHidden) {
            this.hiddenCheckBox.setSelected(hiddenValue);
        }
        if (showRequired) {
            this.requiredCheckBox = new JCheckBox(RB.getStringResource("required.txt"));
            this.optionsPanel.add(this.requiredCheckBox);
        }
        if (this.promptGroup instanceof SharedPromptGroupInterface) {
            this.enableOptionsPanel(false);
        }
    }

    private String getGroupType() {
        return (String)((ValueItem)this.groupTypeCombo.getSelectedItem()).getValue();
    }

    private void setGroupType(ValueItem groupType) {
        this.groupTypeCombo.setSelectedItem((Object)groupType);
    }

    @Override
    public PromptGroupInterface getPromptGroup() {
        PromptObjectFactory factory = PromptObjectFactory.getInstance();
        LoggerFactoryInterface logFactory = this.communicator.getLoggerFactory();
        String type = null;
        type = !this.canChangeGroupType && null != this.promptGroup ? this.promptGroup.getDefinitionElementName() : this.getGroupType();
        if (!(this.promptGroup instanceof SharedPromptGroup)) {
            try {
                this.promptGroup = (PromptGroupInterface)factory.newObject(type);
            }
            catch (ClassNotFoundException e) {
                LoggerRepository2.getLogger((String)PromptGroupUtility.class.getName(), (LoggerFactoryInterface)logFactory).error(e.getMessage(), (Throwable)e);
            }
            catch (InstantiationException e) {
                LoggerRepository2.getLogger((String)PromptGroupUtility.class.getName(), (LoggerFactoryInterface)logFactory).error(e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LoggerRepository2.getLogger((String)PromptGroupUtility.class.getName(), (LoggerFactoryInterface)logFactory).error(e.getMessage(), (Throwable)e);
            }
        }
        if (this.promptGroup.getDefinitionElementName().equals("ModalGroup")) {
            MutableSelectableDefinitionInterface promptDefinition = (MutableSelectableDefinitionInterface)((ModalGroupInterface)this.promptGroup).getChoiceDefinition();
            promptDefinition.setMinimumValueCount(this.requiredCheckBox.isSelected() ? 1 : -1);
            promptDefinition.setPromptName(this.parameterTextField.getText());
        } else if (this.promptGroup.getDefinitionElementName().equals("ModalChoiceGroup")) {
            ((ModalChoiceGroup)this.promptGroup).setValue(this.parameterTextField.getText());
        }
        this.promptGroup.setPromptGroupLabel(this.labelTextField.getText(), this.locale);
        this.promptGroup.setPromptGroupDescription(this.descriptionTextArea.getText(), this.locale);
        this.promptGroup.setPromptGroupHidden(this.hiddenCheckBox.isSelected());
        return this.promptGroup;
    }

    public void initializeFields() {
        if (this.promptGroup != null) {
            this.setGroupType(this.findValueItem(PromptUtility.getGroupTypeID(this.promptGroup)));
            this.labelTextField.setText(this.promptGroup.getPromptGroupLabel(this.locale));
            this.descriptionTextArea.setText(this.promptGroup.getPromptGroupDescription(this.locale));
            this.hiddenCheckBox.setSelected(this.promptGroup.isPromptGroupHidden());
            if (this.promptGroup instanceof ModalChoiceGroupInterface) {
                this.parameterTextField.setText(((ModalChoiceGroupInterface)this.promptGroup).getValue());
                if (this.promptGroup instanceof SharedPromptGroup) {
                    this.parameterTextField.setEnabled(false);
                }
            } else if (this.promptGroup instanceof ModalGroupInterface) {
                SelectableDefinitionInterface promptDefinition = (SelectableDefinitionInterface)((ModalGroupInterface)this.promptGroup).getChoiceDefinition();
                if (promptDefinition.getMinimumValueCount() > 0) {
                    this.requiredCheckBox.setSelected(true);
                }
                this.parameterTextField.setText(promptDefinition.getPromptName());
                this.originalParameterLabel = promptDefinition.getPromptName();
                if (this.promptGroup instanceof SharedPromptGroup) {
                    this.parameterTextField.setEnabled(false);
                }
            }
        }
    }

    private void enableOptionsPanel(boolean enabled) {
        this.hiddenCheckBox.setEnabled(enabled);
        if (this.requiredCheckBox != null) {
            this.requiredCheckBox.setEnabled(enabled);
        }
        if (!enabled && this.promptGroup instanceof SharedPromptGroupInterface) {
            if (this.requiredCheckBox != null) {
                this.requiredCheckBox.setText("<html>" + RB.getStringResource("required.txt") + "<html>");
                this.requiredCheckBox.setForeground(SystemColor.textText);
            }
            this.hiddenCheckBox.setText("<html>" + RB.getStringResource("hidden.txt") + "<html>");
            this.hiddenCheckBox.setForeground(SystemColor.textText);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String currentGroupType = (String)((ValueItem)this.groupTypeCombo.getSelectedItem()).getValue();
        if (!this.groupTypeSelectedItem.equals(currentGroupType)) {
            this.optionsPanel.removeAll();
            if ("ModalGroup".equals(currentGroupType)) {
                this.makeDescriptionPanel("ModalGroup");
                this.makeOptionsPanel(true);
            } else if ("ModalChoiceGroup".equals(currentGroupType)) {
                this.makeDescriptionPanel("ModalChoiceGroup");
                this.makeOptionsPanel(false);
            } else {
                this.makeDescriptionPanel("PromptGroup");
                this.makeOptionsPanel(false);
            }
            if (this.isEditing && this.rootPromptGroup != null && this.parentPromptGroup != null) {
                this.initializeLocationCombo(currentGroupType);
                this.setLocationComboSelectedItem();
            }
            this.firePropertyChange("groupType", this.groupTypeSelectedItem, currentGroupType);
            this.groupTypeSelectedItem = currentGroupType;
            this.updateUI();
        }
    }

    @Override
    public Object getLocationForPrompt() {
        if (this.locationCombo != null) {
            Object selectedItem = this.locationCombo.getSelectedItem();
            if (selectedItem != null && selectedItem instanceof ValueItem) {
                Object o = ((ValueItem)selectedItem).getValue();
                return o;
            }
            return null;
        }
        return null;
    }

    private ValueItem findValueItem(String id) {
        if (id != null) {
            int listSize = this.model.getSize();
            for (int i = 0; i < listSize; ++i) {
                ValueItem valueItem = (ValueItem)this.model.getElementAt(i);
                if (!valueItem.getValue().equals(id)) continue;
                return valueItem;
            }
        }
        return null;
    }

    @Override
    public Collection validatePromptName(int mode, PromptDefinitionInterface prompt, PromptGroupInterface promptGroup) {
        return null;
    }

    public Collection validatePromptName(String promptName, boolean isEditing) {
        ArrayList errors = new ArrayList();
        return errors;
    }

    boolean hasValidFields() {
        String labelValue = this.labelTextField.getText();
        if (labelValue == null || labelValue.trim().length() == 0) {
            return false;
        }
        if (this.shouldValidateName()) {
            ValidatePromptNameInterface nameValidator = this.communicator.getNameValidator();
            TextDefinition prompt = new TextDefinition();
            prompt.setPromptName(this.parameterTextField.getText());
            return true;
        }
        return true;
    }

    public void enableListener(boolean enable) {
        this.labelTextField.getDocument().removeDocumentListener(this);
        if (enable) {
            this.labelTextField.getDocument().addDocumentListener(this);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (!this.isContentsValid()) {
            this.setContentsValid(true);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (!this.isContentsValid()) {
            this.setContentsValid(true);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (!this.isContentsValid()) {
            this.setContentsValid(true);
        }
    }

    private boolean shouldValidateName() {
        if (this.parameterTextField == null) {
            return false;
        }
        if (this.groupTypeSelectedItem != "ModalGroup") {
            return false;
        }
        ValidatePromptNameInterface nameValidator = this.communicator.getNameValidator();
        if (nameValidator != null) {
            if (!this.isEditing) {
                return true;
            }
            String currentParameterLabel = this.parameterTextField.getText();
            if (this.originalParameterLabel == null && currentParameterLabel == null) {
                return false;
            }
            if (this.originalParameterLabel == null || currentParameterLabel == null) {
                return true;
            }
            return !this.originalParameterLabel.equals(currentParameterLabel);
        }
        return false;
    }

    public void onApply() {
        PromptDefinitionInterface promptForValidation;
        int mode;
        ValidatePromptNameInterface nameValidator;
        Collection errors;
        this.setContentsValid(true);
        boolean continueValidating = true;
        String labelValue = this.labelTextField.getText();
        if (labelValue == null || labelValue.trim().length() == 0) {
            continueValidating = false;
            String errMsg = Message.format((String)RB.getStringResource("noBlankPromptText.fmt.txt"), (Object)RB.getStringResource("promptTextNoColon.txt"));
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(errMsg), null);
            }
            this.labelTextField.requestFocus();
            this.setContentsValid(false);
        } else if (this.shouldValidateName() && (errors = (nameValidator = this.communicator.getNameValidator()).validatePromptName(mode = this.originalParameterLabel == null ? 0 : 1, promptForValidation = ((ModalGroupInterface)this.promptGroup).getChoiceDefinition(), this.promptGroup)).size() > 0) {
            continueValidating = false;
            this.firePropertyChange("errorPanel", null, "GeneralPromptPropertiesPanel");
            String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(errorMessage), null);
            }
            this.parameterTextField.requestFocus();
            this.setContentsValid(false);
        }
        Object comboValue = ((ValueItem)this.groupTypeCombo.getSelectedItem()).getValue();
        if (continueValidating && "ModalChoiceGroup" == comboValue) {
            String errorMessage;
            if (this.tableModel != null) {
                int tableSize = this.tableModel.getRowCount();
                String currentValue = this.parameterTextField.getText();
                ArrayList<String> valuesMap = new ArrayList<String>();
                for (int i = 0; i < tableSize; ++i) {
                    Object choiceGroup = this.tableModel.getValueAt(i, 0);
                    if (!(choiceGroup instanceof ModalChoiceGroupInterface)) continue;
                    ModalChoiceGroupInterface mcg = (ModalChoiceGroupInterface)choiceGroup;
                    String value = ((ModalChoiceGroupInterface)choiceGroup).getValue();
                    valuesMap.add(value);
                }
                if (valuesMap.contains(currentValue)) {
                    this.firePropertyChange("errorPanel", null, "GeneralPromptPropertiesPanel");
                    String errorMessage2 = RB.getStringResource("duplicateModalChoiceValuesValidate.txt");
                    if (this.getGenericErrorHandler() != null) {
                        this.getGenericErrorHandler().handleError((Object)this, new Message(errorMessage2), null);
                        this.setContentsValid(false);
                    }
                }
            } else if (this.promptGroup != null && this.parentPromptGroup != null && this.parentPromptGroup instanceof ModalGroupInterface) {
                errorMessage = RB.getStringResource("duplicateModalChoiceValuesValidate.txt");
                Collection badValues = PromptUtil.validatePromptGroup((PromptGroupInterface)this.parentPromptGroup, (Locale)this.locale);
                if (badValues.size() > 0 && this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)this, new Message(errorMessage), null);
                    this.setContentsValid(false);
                }
            } else {
                errorMessage = RB.getStringResource("duplicateModalChoiceValuesValidate.txt");
                Object communicatorObject = this.communicator.getSelectedObjectOnMainPanel();
                ModalGroupInterface modalParent = null;
                if (communicatorObject instanceof ModalGroupInterface) {
                    modalParent = (ModalGroupInterface)communicatorObject;
                } else if (communicatorObject instanceof TreeTableRow && ((TreeTableRow)communicatorObject).getUserObject() instanceof ModalGroupInterface) {
                    modalParent = (ModalGroupInterface)((TreeTableRow)communicatorObject).getUserObject();
                }
                if (modalParent != null && modalParent.getModalChoiceGroupForValue((Object)this.parameterTextField.getText()) != null && this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)this, new Message(errorMessage), null);
                    this.setContentsValid(false);
                }
            }
        }
        if (this.promptGroup != null && this.promptGroup.isPromptGroupHidden()) {
            Object selectedObject = this.communicator.getSelectedObjectOnMainPanel();
            PromptGroupInterface selectedGroup = null;
            if (selectedObject instanceof PromptGroupInterface) {
                selectedGroup = (PromptGroupInterface)selectedObject;
            } else if (selectedObject instanceof TreeTableRow && ((TreeTableRow)selectedObject).getUserObject() instanceof PromptGroupInterface) {
                selectedGroup = (PromptGroupInterface)((TreeTableRow)selectedObject).getUserObject();
            }
            if (selectedGroup != null) {
                List promptsInGroup = selectedGroup.getPromptDefinitions(true);
                for (Object nextItem : promptsInGroup) {
                    PromptDefinitionInterface nextPrompt;
                    if (!(nextItem instanceof PromptDefinitionInterface) || !(nextPrompt = (PromptDefinitionInterface)nextItem).isRequired() || nextPrompt.isDefaultValueSet() || this.getGenericErrorHandler() == null) continue;
                    this.getGenericErrorHandler().handleError((Object)this, new Message(Message.format((String)RB.getStringResource("hiddenRequiredEmptyPrompt.fmt.txt"), (Object)nextPrompt.getPromptLabel(this.locale))), null);
                    this.setContentsValid(false);
                }
            }
        }
    }

    public void onCancel() {
    }

    public void onClose() {
    }

    public String getDialogTitle() {
        return "";
    }

    public String getTabTitle() {
        return "";
    }

    public JComponent getPanel() {
        return this;
    }

    public boolean isYesNo() {
        return false;
    }

    public boolean isContentsValid() {
        return this.contentsValid;
    }

    public void setContentsValid(boolean newValue) {
        if (newValue != this.contentsValid) {
            this.contentsValid = newValue;
            this.firePropertyChange("contentsValid", !this.contentsValid, this.contentsValid);
        }
    }

    public String getHelpID() {
        Config.Element stateElement = this.getState();
        String defaultHelpTopicId = GeneralGroupPropertiesConfigHelper.getDefaultHelpKey(stateElement);
        if (this.config == null) {
            return defaultHelpTopicId;
        }
        return this.config.getHelpID(stateElement, defaultHelpTopicId);
    }

    public Config.Element getState() {
        if (this.groupTypeSelectedItem == "PromptGroup") {
            return GeneralGroupPropertiesConfigHelper.STANDARD;
        }
        if (this.groupTypeSelectedItem == "TransparentGroup") {
            return GeneralGroupPropertiesConfigHelper.TRANSPARENT;
        }
        if (this.groupTypeSelectedItem == "ModalGroup") {
            return GeneralGroupPropertiesConfigHelper.SELECTION;
        }
        return GeneralGroupPropertiesConfigHelper.SELECTION_DEPENDENT;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    void checkForGroupTypeDisabling() {
        if (this.isEditing && (this.promptGroup instanceof ModalChoiceGroupInterface || this.promptGroup instanceof ModalGroupInterface)) {
            this.groupTypeCombo.setEnabled(false);
        } else if (!this.canChangeGroupType) {
            this.groupTypeCombo.setEnabled(false);
        } else {
            Object comboValue = ((ValueItem)this.groupTypeCombo.getSelectedItem()).getValue();
            if ("ModalChoiceGroup" == comboValue) {
                this.groupTypeCombo.setEnabled(false);
            }
        }
    }
}

