/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.models.FileLocationInterface;
import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.DefaultPromptPropertiesPanelModel;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.FileSelectionInterface;
import com.sas.prompts.definitions.InputFileDefinition;
import com.sas.prompts.definitions.OutputFileDefinition;
import com.sas.prompts.definitions.OutputFileDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.DataProviderUtil;
import com.sas.prompts.valueprovider.dynamic.PromptDataProviderInterface;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BasePromptTypesAndValuesPanel;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionWithErrorSuppressionOptionInterface;
import com.sas.prompts.visuals.swing.designtime.MultipleValuesListEditor;
import com.sas.prompts.visuals.swing.designtime.MultipleValuesTextEditor;
import com.sas.prompts.visuals.swing.designtime.PromptPanelConstantsInterface;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.swing.visuals.ComboBox;
import com.sas.swing.visuals.TextEditor;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

class FileNamePanel
extends BasePromptTypesAndValuesPanel
implements ItemListener,
ActionListener,
TableModelListener,
GetPromptDefinitionWithErrorSuppressionOptionInterface {
    private PromptDefinitionInterface prompt;
    private boolean userDefinedDataProvider = false;
    private PromptValues promptValuesDefaultFile;
    private InputFileDefinition promptDefaultFileInput;
    private OutputFileDefinition promptDefaultFileOutput;
    private PromptPropertiesPanel promptPropertiesPanel;
    private ComboBox fileTypeCombo;
    private JRadioButton fileSelectionRadio;
    private JRadioButton directorySelectionRadio;
    private JRadioButton bothSelectionRadio;
    private ComboBox serverCombo;
    private PromptDataProviderInterface dataProvider;
    private MultipleValuesListEditor listEditor;
    private JPanel listEditorPanel;
    private int selectionType;
    private static final int FILES_ONLY_SELECTION_TYPE = 0;
    private static final int DIRECTORIES_ONLY_SELECTION_TYPE = 1;
    private static final int FILES_AND_DIRECTORIES_SELECTION_TYPE = 2;
    private static final long serialVersionUID = 3257563988660598326L;

    public FileNamePanel(PromptDefinitionInterface prompt, PropertiesCommunicator communicator) {
        super(communicator);
        this.prompt = prompt;
        PromptDataProviderInterface userDataProvider = communicator.getDataProvider();
        if (userDataProvider != null) {
            this.dataProvider = userDataProvider;
            this.userDefinedDataProvider = true;
        } else {
            this.dataProvider = new DataProvider(communicator.getUserContext());
        }
        this.listEditor = null;
        this.createPanel();
    }

    private void createPanel() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 0, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        JPanel listPanel = new JPanel();
        AutoSizingGridLayout listPanelLayout = new AutoSizingGridLayout(2, 1, 0, 5, true, false, true);
        listPanel.setLayout((LayoutManager)listPanelLayout);
        JLabel fileTypeLabel = new JLabel(RB.getStringResource("fileType.txt"));
        this.fileTypeCombo = new ComboBox();
        DefaultComboBoxModel<String> fileTypeComboModel = new DefaultComboBoxModel<String>();
        fileTypeComboModel.addElement(INPUT_FILE);
        fileTypeComboModel.addElement(OUTPUT_FILE);
        this.fileTypeCombo.setModel(fileTypeComboModel);
        listPanel.add(fileTypeLabel);
        listPanel.add((Component)this.fileTypeCombo);
        if (this.prompt != null && this.prompt instanceof OutputFileDefinitionInterface) {
            this.fileTypeCombo.setSelectedIndex(1);
        }
        JPanel serverPanel = new JPanel();
        AutoSizingGridLayout serverPanelLayout = new AutoSizingGridLayout(2, 1, 0, 5, true, false, true);
        serverPanel.setLayout((LayoutManager)serverPanelLayout);
        JLabel serverLabel = new JLabel(RB.getStringResource("server.txt"));
        this.serverCombo = new ComboBox();
        try {
            String logicalServerName = null;
            List serverList = this.dataProvider.getLogicalServers();
            DefaultComboBoxModel<String> serverComboModel = new DefaultComboBoxModel<String>();
            for (LogicalServerInterface logicalServer : serverList) {
                if (!DataProviderUtil.isWorkspaceServer((LogicalServerInterface)logicalServer)) continue;
                serverComboModel.addElement(logicalServer.getName());
            }
            this.serverCombo.setModel(serverComboModel);
            boolean foundServer = false;
            if (this.prompt != null) {
                if (this.prompt instanceof FileSelectionInterface) {
                    logicalServerName = ((FileSelectionInterface)this.prompt).getLogicalServerName();
                }
                if (logicalServerName != null) {
                    for (LogicalServerInterface logicalServer : serverList) {
                        if (!logicalServer.getName().equals(logicalServerName)) continue;
                        this.serverCombo.setSelectedItem((Object)logicalServerName);
                        foundServer = true;
                    }
                } else {
                    foundServer = true;
                }
            } else {
                foundServer = true;
            }
            String serverName = logicalServerName;
            final FileNamePanel comp = this;
            final Message errMsg = new Message(RB.getStringResource("serverNotAvailable.txt"), (Object)serverName);
            logicalServerName = (String)serverComboModel.getSelectedItem();
            if (logicalServerName == null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FileNamePanel.this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                        if (FileNamePanel.this.getGenericErrorHandler() != null) {
                            FileNamePanel.this.getGenericErrorHandler().handleError((Object)this, new Message(RB.getStringResource("noServers.txt")), null);
                        }
                    }
                });
                foundServer = false;
            } else if (!foundServer) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FileNamePanel.this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                        JOptionPane.showOptionDialog(comp, errMsg, RB.getStringResource("information.txt"), -1, 1, null, PromptPanelConstantsInterface.ERROR_MESSAGE_DIALOG_OPTIONS, PromptPanelConstantsInterface.ERROR_MESSAGE_DIALOG_OPTIONS[0]);
                    }
                });
            }
            serverPanel.add(serverLabel);
            serverPanel.add((Component)this.serverCombo);
            if (this.prompt != null) {
                Vector dataVector = new Vector();
                List fileTypes = null;
                fileTypes = ((FileSelectionInterface)this.prompt).getFileTypes();
                if (fileTypes != null) {
                    int listSize = fileTypes.size();
                    for (int i = 0; i < listSize; ++i) {
                        Vector v = new Vector();
                        v.add(fileTypes.get(i));
                        dataVector.add(v);
                    }
                }
                Vector<String> columnNames = new Vector<String>(1);
                columnNames.add(RB.getStringResource("choiceLabels.txt"));
                DefaultTableModel model = new DefaultTableModel(dataVector, columnNames);
                this.listEditor = new MultipleValuesListEditor("Text", model);
            } else {
                this.listEditor = new MultipleValuesListEditor("Text");
            }
            this.listEditor.setCellEditor(-1, 1, (TableCellEditor)((Object)new FileNameTableCellEditor(this.getLocale())));
            Border emptyBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(RB.getStringResource("fileExtensions.txt"));
            this.listEditor.setBorder(BorderFactory.createCompoundBorder(titledBorder, emptyBorder));
            TableView listTable = this.listEditor.getTableView();
            listTable.getModel().addTableModelListener(this);
            JPanel selectionTypePanel = new JPanel();
            AutoSizingGridLayout selectionTypePanelLayout = new AutoSizingGridLayout(1, 4, 10, 5, true, false, true);
            selectionTypePanel.setLayout((LayoutManager)selectionTypePanelLayout);
            JLabel selectionTypeLabel = new JLabel(RB.getStringResource("selectionType.txt"));
            this.fileSelectionRadio = new JRadioButton(RB.getStringResource("files.txt"));
            this.directorySelectionRadio = new JRadioButton(RB.getStringResource("directories.txt"));
            this.bothSelectionRadio = new JRadioButton(RB.getStringResource("filesAndDirectories.txt"));
            selectionTypePanel.add(selectionTypeLabel);
            selectionTypePanel.add(this.fileSelectionRadio);
            selectionTypePanel.add(this.directorySelectionRadio);
            this.selectionType = 0;
            if (this.prompt != null && this.prompt instanceof FileSelectionInterface) {
                int selectionMode = ((FileSelectionInterface)this.prompt).getFileSelectionMode();
                if (selectionMode == 2) {
                    this.selectionType = 1;
                    this.directorySelectionRadio.setSelected(true);
                } else if (selectionMode == 0) {
                    this.selectionType = 2;
                    this.bothSelectionRadio.setSelected(true);
                } else {
                    this.fileSelectionRadio.setSelected(true);
                }
            } else {
                this.fileSelectionRadio.setSelected(true);
            }
            this.fileSelectionRadio.addActionListener(this);
            this.directorySelectionRadio.addActionListener(this);
            this.bothSelectionRadio.addActionListener(this);
            this.listEditorPanel = new JPanel();
            AutoSizingGridLayout listEditorPanelLayout = new AutoSizingGridLayout(1, 1, 10, 5, true, false, true);
            this.listEditorPanel.setLayout((LayoutManager)listEditorPanelLayout);
            TransparentGroup promptGroup = new TransparentGroup();
            this.promptValuesDefaultFile = new PromptValues((PromptGroupInterface)promptGroup, null);
            if (this.prompt instanceof OutputFileDefinition) {
                this.promptDefaultFileOutput = new OutputFileDefinition("");
                this.promptDefaultFileOutput.setPromptLabel(RB.getStringResource("defaultValue.txt"), this.getLocale());
                this.promptDefaultFileOutput.setLogicalServerName(logicalServerName);
                if (this.selectionType == 1) {
                    this.promptDefaultFileOutput.setFileSelectionMode(2);
                    this.listEditorPanel.remove((Component)((Object)this.listEditor));
                } else if (this.selectionType == 2) {
                    this.promptDefaultFileOutput.setFileSelectionMode(0);
                    this.listEditorPanel.add((Component)((Object)this.listEditor));
                } else {
                    this.promptDefaultFileOutput.setFileSelectionMode(1);
                    this.listEditorPanel.add((Component)((Object)this.listEditor));
                }
                this.promptDefaultFileOutput.setFileTypes(this.getNonNullFileTypes());
                promptGroup.addPromptDefinition((PromptDefinitionInterface)this.promptDefaultFileOutput);
                if (this.prompt != null && this.prompt.isDefaultValueSet()) {
                    this.promptValuesDefaultFile.setPromptValue((PromptDefinitionInterface)this.promptDefaultFileOutput, this.prompt.getDefaultValue());
                }
            } else {
                this.promptDefaultFileInput = new InputFileDefinition("");
                this.promptDefaultFileInput.setPromptLabel(RB.getStringResource("defaultValue.txt"), this.getLocale());
                this.promptDefaultFileInput.setLogicalServerName(logicalServerName);
                if (this.selectionType == 1) {
                    this.promptDefaultFileInput.setFileSelectionMode(2);
                    this.listEditorPanel.remove((Component)((Object)this.listEditor));
                } else if (this.selectionType == 2) {
                    this.promptDefaultFileInput.setFileSelectionMode(0);
                    this.listEditorPanel.add((Component)((Object)this.listEditor));
                } else {
                    this.promptDefaultFileInput.setFileSelectionMode(1);
                    this.listEditorPanel.add((Component)((Object)this.listEditor));
                }
                this.promptDefaultFileInput.setFileTypes(this.getNonNullFileTypes());
                promptGroup.addPromptDefinition((PromptDefinitionInterface)this.promptDefaultFileInput);
                if (this.prompt != null && this.prompt.isDefaultValueSet() && foundServer) {
                    this.promptValuesDefaultFile.setPromptValue((PromptDefinitionInterface)this.promptDefaultFileInput, this.prompt.getDefaultValue());
                }
            }
            this.promptPropertiesPanel = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesDefaultFile, (DataProviderInterface)this.dataProvider, this.getLocale());
            PromptUtility.configurePropertiesPanel(this.promptPropertiesPanel);
            this.add(listPanel);
            this.add(serverPanel);
            this.add(selectionTypePanel);
            this.add(this.listEditorPanel);
            this.add(this.promptPropertiesPanel);
            this.fileTypeCombo.addActionListener((ActionListener)this);
            this.serverCombo.addItemListener((ItemListener)this);
        }
        catch (ServerConnectionException sce) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(sce.getMessage(), (Throwable)sce);
        }
        catch (RemoteException re) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(re.getMessage(), (Throwable)re);
        }
        catch (InvalidPromptValueException ipve) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
        }
        catch (ServiceException se) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(se.getMessage(), (Throwable)se);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.fileSelectionRadio) {
            this.fileSelectionRadio.setSelected(true);
            this.directorySelectionRadio.setSelected(false);
            this.bothSelectionRadio.setSelected(false);
            this.selectionType = 0;
        } else if (e.getSource() == this.directorySelectionRadio) {
            this.fileSelectionRadio.setSelected(false);
            this.directorySelectionRadio.setSelected(true);
            this.bothSelectionRadio.setSelected(false);
            this.selectionType = 1;
        } else if (e.getSource() == this.bothSelectionRadio) {
            this.fileSelectionRadio.setSelected(false);
            this.directorySelectionRadio.setSelected(false);
            this.bothSelectionRadio.setSelected(true);
            this.selectionType = 2;
        } else if (e.getSource() == this.fileTypeCombo) {
            this.updateDefaultValuePanelForFileTypeChange();
        }
        this.updateDefaultValuePanel(true);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.serverCombo) {
            this.updateDefaultValuePanelForFileTypeChange();
        }
    }

    private void updateDefaultValuePanelForFileTypeChange() {
        String selectedItem = (String)this.fileTypeCombo.getSelectedItem();
        if (INPUT_FILE.equals(selectedItem)) {
            if (this.promptDefaultFileOutput != null) {
                this.promptValuesDefaultFile.clearPromptValue((PromptDefinitionInterface)this.promptDefaultFileOutput);
            }
            this.promptDefaultFileOutput = null;
            this.createPromptDefaultFile(INPUT_FILE);
            this.updateDefaultValuePanel(false);
        } else if (OUTPUT_FILE.equals(selectedItem)) {
            if (this.promptDefaultFileInput != null) {
                this.promptValuesDefaultFile.clearPromptValue((PromptDefinitionInterface)this.promptDefaultFileInput);
            }
            this.promptDefaultFileInput = null;
            this.createPromptDefaultFile(OUTPUT_FILE);
            this.updateDefaultValuePanel(false);
        }
    }

    private void createPromptDefaultFile(String fileType) {
        this.promptValuesDefaultFile.getPromptGroup().removeAll();
        String logicalServerName = (String)this.serverCombo.getSelectedItem();
        List filetypes = this.getNonNullFileTypes();
        if (INPUT_FILE.equals(fileType)) {
            this.promptDefaultFileInput = new InputFileDefinition("");
            this.promptDefaultFileInput.setPromptLabel(RB.getStringResource("defaultValue.txt"), this.getLocale());
            this.promptDefaultFileInput.setLogicalServerName(logicalServerName);
            if (this.selectionType == 1) {
                this.promptDefaultFileInput.setFileSelectionMode(2);
            } else if (this.selectionType == 2) {
                this.promptDefaultFileInput.setFileSelectionMode(0);
            } else {
                this.promptDefaultFileInput.setFileSelectionMode(1);
            }
            if (filetypes.size() > 0) {
                this.promptDefaultFileInput.setFileTypes(filetypes);
            } else {
                this.promptDefaultFileInput.setFileTypes(null);
            }
            this.promptValuesDefaultFile.getPromptGroup().addPromptDefinition((PromptDefinitionInterface)this.promptDefaultFileInput);
        } else if (OUTPUT_FILE.equals(fileType)) {
            this.promptDefaultFileOutput = new OutputFileDefinition("");
            this.promptDefaultFileOutput.setPromptLabel(RB.getStringResource("defaultValue.txt"), this.getLocale());
            this.promptDefaultFileOutput.setLogicalServerName(logicalServerName);
            if (this.selectionType == 1) {
                this.promptDefaultFileOutput.setFileSelectionMode(2);
            } else if (this.selectionType == 2) {
                this.promptDefaultFileOutput.setFileSelectionMode(0);
            } else {
                this.promptDefaultFileOutput.setFileSelectionMode(1);
            }
            if (filetypes.size() > 0) {
                this.promptDefaultFileOutput.setFileTypes(filetypes);
            } else {
                this.promptDefaultFileOutput.setFileTypes(null);
            }
            this.promptValuesDefaultFile.getPromptGroup().addPromptDefinition((PromptDefinitionInterface)this.promptDefaultFileOutput);
        }
    }

    private void updateDefaultValuePanel(boolean refresh) {
        Object defaultValue = null;
        if (this.selectionType == 1) {
            this.listEditorPanel.remove((Component)((Object)this.listEditor));
            if (this.promptDefaultFileInput != null) {
                try {
                    if (this.promptValuesDefaultFile.isPromptValueAvailable((PromptDefinitionInterface)this.promptDefaultFileInput)) {
                        defaultValue = this.promptValuesDefaultFile.getPromptValue((PromptDefinitionInterface)this.promptDefaultFileInput);
                    }
                    if (defaultValue != null && ((FileLocationInterface)defaultValue).isFile()) {
                        this.promptValuesDefaultFile.clearPromptValue((PromptDefinitionInterface)this.promptDefaultFileInput);
                    }
                }
                catch (PromptValueNotFoundException e) {
                    this.promptValuesDefaultFile.clearPromptValue((PromptDefinitionInterface)this.promptDefaultFileInput);
                }
                this.promptDefaultFileInput.setFileSelectionMode(2);
            } else if (this.promptDefaultFileOutput != null) {
                try {
                    if (this.promptValuesDefaultFile.isPromptValueAvailable((PromptDefinitionInterface)this.promptDefaultFileOutput)) {
                        defaultValue = this.promptValuesDefaultFile.getPromptValue((PromptDefinitionInterface)this.promptDefaultFileOutput);
                    }
                    if (defaultValue != null && ((FileLocationInterface)defaultValue).isFile()) {
                        this.promptValuesDefaultFile.clearPromptValue((PromptDefinitionInterface)this.promptDefaultFileOutput);
                    }
                }
                catch (PromptValueNotFoundException e) {
                    this.promptValuesDefaultFile.clearPromptValue((PromptDefinitionInterface)this.promptDefaultFileOutput);
                }
                this.promptDefaultFileOutput.setFileSelectionMode(2);
            }
        } else if (this.selectionType == 2) {
            this.listEditorPanel.add((Component)((Object)this.listEditor));
            if (this.promptDefaultFileInput != null) {
                this.promptDefaultFileInput.setFileSelectionMode(0);
            } else {
                this.promptDefaultFileOutput.setFileSelectionMode(0);
            }
        } else {
            this.listEditorPanel.add((Component)((Object)this.listEditor));
            if (this.promptDefaultFileInput != null) {
                try {
                    if (this.promptValuesDefaultFile.isPromptValueAvailable((PromptDefinitionInterface)this.promptDefaultFileInput)) {
                        defaultValue = this.promptValuesDefaultFile.getPromptValue((PromptDefinitionInterface)this.promptDefaultFileInput);
                    }
                    if (defaultValue != null && ((FileLocationInterface)defaultValue).isDirectory()) {
                        this.promptValuesDefaultFile.clearPromptValue((PromptDefinitionInterface)this.promptDefaultFileInput);
                    }
                }
                catch (PromptValueNotFoundException e) {
                    this.promptValuesDefaultFile.clearPromptValue((PromptDefinitionInterface)this.promptDefaultFileInput);
                }
                this.promptDefaultFileInput.setFileSelectionMode(1);
            } else if (this.promptDefaultFileOutput != null) {
                try {
                    if (this.promptValuesDefaultFile.isPromptValueAvailable((PromptDefinitionInterface)this.promptDefaultFileOutput)) {
                        defaultValue = this.promptValuesDefaultFile.getPromptValue((PromptDefinitionInterface)this.promptDefaultFileOutput);
                    }
                    if (defaultValue != null && ((FileLocationInterface)defaultValue).isFile()) {
                        this.promptValuesDefaultFile.clearPromptValue((PromptDefinitionInterface)this.promptDefaultFileOutput);
                    }
                }
                catch (PromptValueNotFoundException e) {
                    this.promptValuesDefaultFile.clearPromptValue((PromptDefinitionInterface)this.promptDefaultFileOutput);
                }
                this.promptDefaultFileOutput.setFileSelectionMode(1);
            }
        }
        if (refresh) {
            if (this.promptDefaultFileInput != null) {
                this.promptPropertiesPanel.refresh((PromptDefinitionInterface)this.promptDefaultFileInput);
            } else {
                this.promptPropertiesPanel.refresh((PromptDefinitionInterface)this.promptDefaultFileOutput);
            }
        } else {
            this.remove(this.promptPropertiesPanel);
            this.promptPropertiesPanel = null;
            this.promptPropertiesPanel = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesDefaultFile, (DataProviderInterface)this.dataProvider, this.getLocale());
            PromptUtility.configurePropertiesPanel(this.promptPropertiesPanel);
            this.add((Component)this.promptPropertiesPanel, -1);
        }
        this.updateUI();
    }

    private List getFileTypes() {
        ArrayList<Object> filetypes = new ArrayList<Object>();
        DefaultTableModel tableModel = (DefaultTableModel)this.listEditor.getModel();
        int tableSize = this.listEditor.getModel().getRowCount();
        if (tableSize > 0) {
            for (int i = 0; i < tableSize; ++i) {
                filetypes.add(tableModel.getValueAt(i, 0));
            }
        }
        return filetypes;
    }

    private List getNonNullFileTypes() {
        List fileTypes = this.getFileTypes();
        if (fileTypes.size() == 0) {
            return fileTypes;
        }
        for (int i = fileTypes.size() - 1; i >= 0; --i) {
            if (fileTypes.get(i) != null && fileTypes.get(i).toString().length() != 0) continue;
            fileTypes.remove(i);
        }
        return fileTypes;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.getPromptDefinition(false);
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        this.setContentsValid(true);
        InputFileDefinition inputFileDefinitionPrompt = null;
        OutputFileDefinition outputFileDefinitionPrompt = null;
        if (INPUT_FILE.equals(this.fileTypeCombo.getSelectedItem())) {
            inputFileDefinitionPrompt = (InputFileDefinition)PromptUtility.newConfiguredPrompt(this.communicator, "InputFileDefinition");
        } else if (OUTPUT_FILE.equals(this.fileTypeCombo.getSelectedItem())) {
            outputFileDefinitionPrompt = (OutputFileDefinition)PromptUtility.newConfiguredPrompt(this.communicator, "OutputFileDefinition");
        } else {
            return null;
        }
        try {
            Object defaultValue;
            String promptlogicalServerName = (String)this.serverCombo.getSelectedItem();
            if (inputFileDefinitionPrompt != null) {
                inputFileDefinitionPrompt.setLogicalServerName(promptlogicalServerName);
            } else {
                outputFileDefinitionPrompt.setLogicalServerName(promptlogicalServerName);
            }
            if (this.selectionType != 1) {
                List filetypes = this.getNonNullFileTypes();
                if (inputFileDefinitionPrompt != null) {
                    inputFileDefinitionPrompt.setFileTypes(filetypes);
                } else {
                    outputFileDefinitionPrompt.setFileTypes(filetypes);
                }
            }
            PromptUtil.validateDynamicPromptValues((PromptValuesInterface)this.promptValuesDefaultFile, (DynamicPromptValueContextInterface)((DefaultPromptPropertiesPanelModel)this.promptPropertiesPanel.getModel()).getDynamicPromptValueContext(), (Locale)this.locale);
            if (inputFileDefinitionPrompt != null) {
                if (this.promptValuesDefaultFile.isPromptValueAvailable((PromptDefinitionInterface)this.promptDefaultFileInput)) {
                    defaultValue = this.promptValuesDefaultFile.getPromptValue((PromptDefinitionInterface)this.promptDefaultFileInput);
                    inputFileDefinitionPrompt.setDefaultValue(defaultValue);
                }
            } else if (this.promptValuesDefaultFile.isPromptValueAvailable((PromptDefinitionInterface)this.promptDefaultFileOutput)) {
                defaultValue = this.promptValuesDefaultFile.getPromptValue((PromptDefinitionInterface)this.promptDefaultFileOutput);
                outputFileDefinitionPrompt.setDefaultValue(defaultValue);
            }
            if (this.selectionType == 1) {
                if (outputFileDefinitionPrompt != null) {
                    outputFileDefinitionPrompt.setFileSelectionMode(2);
                } else if (inputFileDefinitionPrompt != null) {
                    inputFileDefinitionPrompt.setFileSelectionMode(2);
                }
            } else if (this.selectionType == 2) {
                if (outputFileDefinitionPrompt != null) {
                    outputFileDefinitionPrompt.setFileSelectionMode(0);
                } else if (inputFileDefinitionPrompt != null) {
                    inputFileDefinitionPrompt.setFileSelectionMode(0);
                }
            } else if (outputFileDefinitionPrompt != null) {
                outputFileDefinitionPrompt.setFileSelectionMode(1);
            } else if (inputFileDefinitionPrompt != null) {
                inputFileDefinitionPrompt.setFileSelectionMode(1);
            }
        }
        catch (IllegalArgumentException exception) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(exception.getMessage(), (Throwable)exception);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)exception.getMessage())), null);
            }
            this.setContentsValid(false);
            if (inputFileDefinitionPrompt != null) {
                return inputFileDefinitionPrompt;
            }
            return outputFileDefinitionPrompt;
        }
        catch (PromptValueNotFoundException pvnf) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage(), (Throwable)pvnf);
        }
        catch (InvalidPromptValueException pvnf) {
            // empty catch block
        }
        Collection errors = null;
        errors = inputFileDefinitionPrompt != null ? inputFileDefinitionPrompt.validateDefinition(this.getLocale()) : outputFileDefinitionPrompt.validateDefinition(this.getLocale());
        if (errors.size() > 0 && !suppressErrors) {
            String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
            }
            this.setContentsValid(false);
        }
        if (inputFileDefinitionPrompt != null) {
            return inputFileDefinitionPrompt;
        }
        return outputFileDefinitionPrompt;
    }

    @Override
    public void tableChanged(TableModelEvent tme) {
        String selectedItem = (String)this.fileTypeCombo.getSelectedItem();
        int eventType = tme.getType();
        if (this.promptDefaultFileInput != null) {
            this.promptDefaultFileInput.setFileTypes(this.getNonNullFileTypes());
            this.promptPropertiesPanel.refresh((PromptDefinitionInterface)this.promptDefaultFileInput);
            if (eventType == 0) {
                this.checkTableEntriesForInvalidFileTypes();
            }
        } else if (this.promptDefaultFileOutput != null) {
            this.promptDefaultFileOutput.setFileTypes(this.getNonNullFileTypes());
            this.promptPropertiesPanel.refresh((PromptDefinitionInterface)this.promptDefaultFileOutput);
            if (eventType == 0) {
                this.checkTableEntriesForInvalidFileTypes();
            }
        }
    }

    private void checkTableEntriesForInvalidFileTypes() {
        DefaultTableModel tableModel = (DefaultTableModel)this.listEditor.getTableView().getModel();
        int tableSize = tableModel.getRowCount();
        for (int i = tableSize - 1; i >= 0; --i) {
            Object o = tableModel.getValueAt(i, 0);
            if (o != null && (!(o instanceof String) || ((String)o).trim().length() != 0)) continue;
            tableModel.removeRow(i);
        }
    }

    protected class FileNameTableCellEditor
    extends MultipleValuesTextEditor {
        public FileNameTableCellEditor(Locale locale) {
            super(locale);
        }

        @Override
        public boolean stopCellEditing() {
            Object value = null;
            if (this.editor instanceof TextEditor) {
                value = ((TextEditor)this.editor).getValue();
            }
            if (value instanceof String) {
                if (((String)value).startsWith("*", 0)) {
                    int length = ((String)value).length();
                    boolean strippedString = false;
                    for (int i = 0; i < length; ++i) {
                        if (((String)value).charAt(i) == '*') continue;
                        value = ((String)value).substring(i);
                        strippedString = true;
                        break;
                    }
                    if (strippedString) {
                        ((TextEditor)this.editor).setValue(value);
                    } else {
                        value = ((String)value).replaceAll("\\*", "");
                        ((TextEditor)this.editor).setValue((Object)"");
                    }
                }
                if (((String)value).length() > 0 && !((String)value).startsWith(".", 0)) {
                    value = "." + (String)value;
                    ((TextEditor)this.editor).setValue(value);
                }
            }
            return super.stopCellEditing();
        }
    }
}

