/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.datatypes.DoubleType;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.swing.visuals.tableview.DefaultTableCellRenderer;
import com.sas.text.Message;
import com.sas.util.DatePeriod;
import com.sas.util.transforms.TransformException;
import com.sas.visuals.Resources;
import java.awt.Component;
import java.util.Date;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;

public class EnhancedDefaultTableCellRenderer
extends DefaultTableCellRenderer {
    private ImageIcon valueWarningIcon = new ImageIcon(Resources.getImage((String)"MessageError.gif", (int)16));
    private int maxLength;
    private int minLength;
    private int maxValue;
    private int minValue;
    private double minDoubleValue;
    private double maxDoubleValue;
    private int minDecimalPlaces;
    private int maxDecimalPlaces;
    private long minDateValue;
    private long maxDateValue;
    private boolean minDateRelative;
    private boolean maxDateRelative;
    private boolean coerceSpecialAndMissingValues;

    public EnhancedDefaultTableCellRenderer() {
        this.initLocalVars();
        this.coerceSpecialAndMissingValues = false;
    }

    public EnhancedDefaultTableCellRenderer(Character splitCharacter) {
        super(splitCharacter);
        this.initLocalVars();
        this.coerceSpecialAndMissingValues = false;
    }

    public EnhancedDefaultTableCellRenderer(boolean coerceSpecialAndMissingValues) {
        this.initLocalVars();
        this.coerceSpecialAndMissingValues = coerceSpecialAndMissingValues;
    }

    private void initLocalVars() {
        this.minLength = 0;
        this.maxLength = Integer.MAX_VALUE;
        this.minValue = Integer.MIN_VALUE;
        this.maxValue = Integer.MAX_VALUE;
        this.minDoubleValue = -1.7976931348623157E308;
        this.maxDoubleValue = Double.MAX_VALUE;
        this.minDecimalPlaces = 0;
        this.maxDecimalPlaces = Integer.MAX_VALUE;
        this.minDateValue = Long.MIN_VALUE;
        this.maxDateValue = Long.MAX_VALUE;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String toolTipText = null;
        ImageIcon icon = null;
        boolean padDecimals = false;
        if (value instanceof String) {
            if (((String)value).length() < this.getMinLength()) {
                icon = this.valueWarningIcon;
                Message message = new Message(RB.getStringResource("lengthBelowMin.fmt.txt"), (Object)String.valueOf(this.getMinLength()), null);
                toolTipText = message.toString();
            } else if (((String)value).length() > this.getMaxLength()) {
                icon = this.valueWarningIcon;
                Message message = new Message(RB.getStringResource("lengthAboveMax.fmt.txt"), (Object)String.valueOf(this.getMaxLength()), null);
                toolTipText = message.toString();
            }
        } else if (value instanceof Integer) {
            if ((Integer)value < this.getMinValue()) {
                icon = this.valueWarningIcon;
                Message message = new Message(RB.getStringResource("valueBelowMin.fmt.txt"), (Object)String.valueOf(this.getMinValue()), null);
                toolTipText = message.toString();
            } else if ((Integer)value > this.getMaxValue()) {
                icon = this.valueWarningIcon;
                Message message = new Message(RB.getStringResource("valueAboveMax.fmt.txt"), (Object)String.valueOf(this.getMaxValue()), null);
                toolTipText = message.toString();
            }
        } else if (value instanceof Double) {
            String stringVal = value.toString();
            int decPlaces = stringVal.substring(stringVal.indexOf(".") + 1).length();
            if ((Double)value < this.getMinDoubleValue()) {
                icon = this.valueWarningIcon;
                Message message = new Message(RB.getStringResource("valueBelowMin.fmt.txt"), (Object)String.valueOf(this.getMinDoubleValue()), null);
                toolTipText = message.toString();
            } else if ((Double)value > this.getMaxDoubleValue()) {
                icon = this.valueWarningIcon;
                Message message = new Message(RB.getStringResource("valueAboveMax.fmt.txt"), (Object)String.valueOf(this.getMaxDoubleValue()), null);
                toolTipText = message.toString();
            } else if (decPlaces < this.getMinDecimalPlaces()) {
                padDecimals = true;
            } else if (decPlaces > this.getMaxDecimalPlaces()) {
                icon = this.valueWarningIcon;
                Message message = new Message(RB.getStringResource("decimalPlacesAboveMax.fmt.txt"), (Object)String.valueOf(this.getMaxDecimalPlaces()), null);
                toolTipText = message.toString();
            }
        } else if (value instanceof Date && value != null) {
            try {
                if (value instanceof DatePeriod) {
                    Message message;
                    boolean bothRelativeOrAbsolute = false;
                    if (((DatePeriod)value).isRelativeDate() && this.minDateRelative) {
                        bothRelativeOrAbsolute = true;
                    } else if (!((DatePeriod)value).isRelativeDate() && !this.minDateRelative) {
                        bothRelativeOrAbsolute = true;
                    }
                    if (bothRelativeOrAbsolute && ((DatePeriod)value).getStartOfPeriod().getTime() < this.getMinDateValue().getTime()) {
                        icon = this.valueWarningIcon;
                        message = new Message(RB.getStringResource("valueBelowMin.fmt.txt"), this.getTransform().transform((Object)this.getMinDateValue()), null);
                        toolTipText = message.toString();
                    } else {
                        bothRelativeOrAbsolute = false;
                        if (((DatePeriod)value).isRelativeDate() && this.maxDateRelative) {
                            bothRelativeOrAbsolute = true;
                        } else if (!((DatePeriod)value).isRelativeDate() && !this.maxDateRelative) {
                            bothRelativeOrAbsolute = true;
                        }
                        if (bothRelativeOrAbsolute && ((DatePeriod)value).getStartOfPeriod().getTime() > this.getMaxDateValue().getTime()) {
                            icon = this.valueWarningIcon;
                            message = new Message(RB.getStringResource("valueAboveMax.fmt.txt"), this.getTransform().transform((Object)this.getMaxDateValue()), null);
                            toolTipText = message.toString();
                        }
                    }
                } else if (!this.minDateRelative && ((Date)value).getTime() < this.getMinDateValue().getTime()) {
                    icon = this.valueWarningIcon;
                    Message message = new Message(RB.getStringResource("valueBelowMin.fmt.txt"), this.getTransform().transform((Object)this.getMinDateValue()), null);
                    toolTipText = message.toString();
                } else if (!this.maxDateRelative && ((Date)value).getTime() > this.getMaxDateValue().getTime()) {
                    icon = this.valueWarningIcon;
                    Message message = new Message(RB.getStringResource("valueAboveMax.fmt.txt"), this.getTransform().transform((Object)this.getMaxDateValue()), null);
                    toolTipText = message.toString();
                }
            }
            catch (TransformException message) {
                // empty catch block
            }
        }
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (this.coerceSpecialAndMissingValues) {
            if (value instanceof MissingValues) {
                if (value == MissingValues._BLANK_) {
                    this.setText(MissingValues.toDisplayString((MissingValues)MissingValues._BLANK_, (Locale)this.getLocale()));
                } else if (value == MissingValues.Dot) {
                    this.setText(MissingValues.toDisplayString((MissingValues)MissingValues.Dot, (Locale)this.getLocale()));
                }
            }
            if (value instanceof SpecialValues) {
                if (value == SpecialValues.ALL) {
                    this.setText(SpecialValues.toDisplayString((SpecialValues)SpecialValues.ALL, (Locale)this.getLocale()));
                } else if (value == SpecialValues.OTHER) {
                    this.setText(SpecialValues.toDisplayString((SpecialValues)SpecialValues.OTHER, (Locale)this.getLocale()));
                }
            }
        }
        if (padDecimals && value instanceof Double) {
            System.out.println("doing padding");
            String displayString = DoubleType.DEFAULT_INSTANCE.getDisplayString(value, Locale.getDefault(), this.getMinDecimalPlaces());
            if (displayString != null) {
                this.setText(displayString);
            }
        }
        ((DefaultTableCellRenderer)comp).setIcon((Icon)icon);
        ((DefaultTableCellRenderer)comp).setToolTipText(toolTipText);
        return comp;
    }

    public void setMinLength(int length) {
        this.minLength = length;
    }

    public void setMaxLength(int length) {
        this.maxLength = length;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        if (this.maxLength == 0) {
            return Integer.MAX_VALUE;
        }
        return this.maxLength;
    }

    public void setMinValue(int value) {
        this.minValue = value;
    }

    public void setMaxValue(int value) {
        this.maxValue = value;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        if (this.maxValue == 0) {
            return Integer.MAX_VALUE;
        }
        return this.maxValue;
    }

    public void setMinDecimalPlaces(int value) {
        this.minDecimalPlaces = Math.min(value, 100);
    }

    public void setMaxDecimalPlaces(int value) {
        this.maxDecimalPlaces = Math.min(value, 15);
    }

    public int getMinDecimalPlaces() {
        return this.minDecimalPlaces;
    }

    public int getMaxDecimalPlaces() {
        if (this.maxDecimalPlaces == 0) {
            return 15;
        }
        return this.maxDecimalPlaces;
    }

    public void setMinDoubleValue(double value) {
        this.minDoubleValue = value;
    }

    public void setMaxDoubleValue(double value) {
        this.maxDoubleValue = value;
    }

    public double getMinDoubleValue() {
        return this.minDoubleValue;
    }

    public double getMaxDoubleValue() {
        if (this.maxDoubleValue == 0.0) {
            return Double.MAX_VALUE;
        }
        return this.maxDoubleValue;
    }

    public void setMinDateValue(Date value) {
        this.minDateRelative = false;
        if (value instanceof DatePeriod) {
            if (((DatePeriod)value).isRelativeDate()) {
                this.minDateRelative = true;
            }
            this.minDateValue = ((DatePeriod)value).getStartOfPeriod().getTime();
        } else if (value != null) {
            this.minDateValue = value.getTime();
        }
    }

    public void setMaxDateValue(Date value) {
        this.maxDateRelative = false;
        if (value instanceof DatePeriod) {
            if (((DatePeriod)value).isRelativeDate()) {
                this.maxDateRelative = true;
            }
            this.maxDateValue = ((DatePeriod)value).getStartOfPeriod().getTime();
        } else if (value != null) {
            this.maxDateValue = value.getTime();
        }
    }

    public Date getMinDateValue() {
        return new Date(this.minDateValue);
    }

    public Date getMaxDateValue() {
        return new Date(this.maxDateValue);
    }
}

