/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.MissingValues;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.text.Message;
import com.sas.util.DatePeriod;
import com.sas.util.Strings;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.errorhandlers.SupportsGenericErrorHandlerInterface;
import com.sas.util.transforms.BaseTransforms;
import com.sas.util.transforms.ObjectToStringTransform;
import com.sas.util.transforms.StringToDateTransform;
import com.sas.util.transforms.StringToDoubleTransform;
import com.sas.util.transforms.StringToFloatTransform;
import com.sas.util.transforms.StringToSQLDateTransform;
import com.sas.util.transforms.StringToSQLTimeTransform;
import com.sas.util.transforms.StringToSQLTimestampTransform;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import com.sas.util.validators.ValidationInterface;
import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.Locale;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

public class EnhancedDefaultTableCellEditor
extends DefaultCellEditor
implements SupportsGenericErrorHandlerInterface {
    public static final String RB_KEY = "DefaultTableCellEditor.";
    private Class[] argTypes;
    private Constructor constructor;
    private Class type;
    private Object value;
    private TransformInterface transform;
    private TransformInterface outputTransform;
    private GenericErrorHandlerInterface genericErrorHandler;
    private GenericErrorHandlerInterface viewerErrorHandler;
    private ValidationInterface validator;
    private Locale locale;
    private Object lastValue;
    private boolean valid;
    private boolean defaultTransform;
    private SupportedSpecialValues specialValues;
    private int minLength;
    private int maxLength;
    private int maxValue;
    private int minValue;
    private double minDoubleValue;
    private double maxDoubleValue;
    private int minDecimalPlaces;
    private int maxDecimalPlaces;
    private long minDateValue;
    private long maxDateValue;
    private boolean minDateRelative;
    private boolean maxDateRelative;

    public EnhancedDefaultTableCellEditor() {
        this(new JTextField());
    }

    public EnhancedDefaultTableCellEditor(JCheckBox checkBox) {
        super(checkBox);
        this.initLocalVars();
        this.argTypes = new Class[]{Boolean.TYPE};
    }

    public EnhancedDefaultTableCellEditor(JComboBox comboBox) {
        super(comboBox);
        this.initLocalVars();
        this.argTypes = new Class[]{String.class};
    }

    public EnhancedDefaultTableCellEditor(JTextField textField) {
        super(textField);
        this.initLocalVars();
        this.argTypes = new Class[]{String.class};
        this.maxLength = Integer.MAX_VALUE;
    }

    private void initLocalVars() {
        this.locale = null;
        this.defaultTransform = true;
        this.transform = new ObjectToStringTransform();
        ((ObjectToStringTransform)this.transform).setNullString("");
        this.valid = true;
        this.minLength = 0;
        this.maxLength = Integer.MAX_VALUE;
        this.minValue = Integer.MIN_VALUE;
        this.maxValue = Integer.MAX_VALUE;
        this.minDoubleValue = -1.7976931348623157E308;
        this.maxDoubleValue = Double.MAX_VALUE;
        this.minDecimalPlaces = 0;
        this.maxDecimalPlaces = Integer.MAX_VALUE;
        this.minDateValue = Long.MIN_VALUE;
        this.maxDateValue = Long.MAX_VALUE;
    }

    public void setLocale(Locale newLocale) {
        this.locale = newLocale;
        if (this.defaultTransform && this.locale != null) {
            this.transform = new ObjectToStringTransform(this.locale);
            ((ObjectToStringTransform)this.transform).setNullString("");
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setTransform(TransformInterface newTransform) {
        this.transform = newTransform;
        this.defaultTransform = false;
    }

    public TransformInterface getTransform() {
        return this.transform;
    }

    public void setOutputTransform(TransformInterface newTransform) {
        this.outputTransform = newTransform;
    }

    public TransformInterface getOutputTransform() {
        return this.outputTransform;
    }

    public GenericErrorHandlerInterface getGenericErrorHandler() {
        return this.genericErrorHandler;
    }

    public void setGenericErrorHandler(GenericErrorHandlerInterface errorHandler) {
        this.genericErrorHandler = errorHandler;
    }

    public ValidationInterface getValidator() {
        return this.validator;
    }

    public void setValidator(ValidationInterface newValidator) {
        this.validator = newValidator;
    }

    @Override
    public boolean stopCellEditing() {
        Object s;
        block67: {
            s = super.getCellEditorValue();
            if (this.getValidator() != null) {
                if (s == null || !s.equals(this.lastValue)) {
                    if (!this.getValidator().validateValue((Object)this.getComponent(), s)) {
                        this.valid = false;
                        ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
                        if (this.getGenericErrorHandler() != null) {
                            this.getGenericErrorHandler().handleError((Object)this.getComponent(), this.getValidator().getValidationMessage(), this.getValidator().getValidationMessageCode());
                        }
                        this.lastValue = s;
                        return false;
                    }
                } else if (!this.valid) {
                    ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
                    return false;
                }
            }
            if ("".equals(s)) {
                try {
                    Constructor constructor = this.type.getConstructor(this.argTypes);
                    if (constructor != null && constructor.getDeclaringClass() == String.class) {
                        this.value = s;
                    }
                }
                catch (Exception constructor) {
                    // empty catch block
                }
                return super.stopCellEditing();
            }
            this.valid = true;
            try {
                TransformInterface editTransform = null;
                if (this.getOutputTransform() != null) {
                    editTransform = this.getOutputTransform();
                } else {
                    editTransform = s != null ? BaseTransforms.defaultInstance.lookupTransform(s.getClass(), this.type) : BaseTransforms.defaultInstance.lookupTransform(String.class, this.type);
                    if (this.locale != null) {
                        if (editTransform instanceof StringToDoubleTransform) {
                            editTransform = new StringToDoubleTransform(this.locale);
                        } else if (editTransform instanceof StringToFloatTransform) {
                            editTransform = new StringToFloatTransform(this.locale);
                        } else if (editTransform instanceof StringToSQLDateTransform) {
                            editTransform = new StringToSQLDateTransform(this.locale);
                        } else if (editTransform instanceof StringToSQLTimestampTransform) {
                            editTransform = new StringToSQLTimestampTransform(this.locale);
                        } else if (editTransform instanceof StringToSQLTimeTransform) {
                            editTransform = new StringToSQLTimeTransform(this.locale);
                        } else if (editTransform instanceof StringToDateTransform) {
                            editTransform = new StringToDateTransform(this.locale);
                        }
                    }
                }
                if (editTransform != null) {
                    this.value = this.value instanceof MissingValues ? editTransform.transform(this.value) : editTransform.transform(s);
                    break block67;
                }
                try {
                    this.constructor = this.type.getConstructor(this.argTypes);
                    this.value = this.constructor.newInstance(s);
                }
                catch (Exception e) {
                    return false;
                }
            }
            catch (Exception e) {
                this.flagError(new Message(Strings.padSingleQuotesForMessage((String)e.getMessage())), s);
                return false;
            }
        }
        if (this.value instanceof MissingValues) {
            boolean missingValuesError = true;
            if (!this.value.equals(MissingValues.Dot) && !this.value.equals(MissingValues._BLANK_) && this.getSupportedSpecialValues() != null && this.getSupportedSpecialValues().isMissingValuesSupported()) {
                missingValuesError = false;
            }
            if (missingValuesError) {
                this.flagError(new Message(RB.getStringResource("errorSettingValue.fmt.txt"), s), s);
                return false;
            }
        } else if (this.value instanceof String) {
            if (((String)this.value).length() < this.getMinLength()) {
                this.displayMinMaxError(new Message(RB.getStringResource("lengthBelowMin.fmt.txt"), (Object)String.valueOf(this.getMinLength())), s);
            } else if (((String)this.value).length() > this.getMaxLength()) {
                this.displayMinMaxError(new Message(RB.getStringResource("lengthAboveMax.fmt.txt"), (Object)String.valueOf(this.getMaxLength())), s);
            }
        } else if (this.value instanceof Integer) {
            if ((Integer)this.value < this.getMinValue()) {
                this.displayMinMaxError(new Message(RB.getStringResource("valueBelowMin.fmt.txt"), (Object)String.valueOf(this.getMinValue())), s);
            } else if ((Integer)this.value > this.getMaxValue()) {
                this.displayMinMaxError(new Message(RB.getStringResource("valueAboveMax.fmt.txt"), (Object)String.valueOf(this.getMaxValue())), s);
            }
        } else if (this.value instanceof Double) {
            String stringVal = this.value.toString();
            int decPlaces = stringVal.substring(stringVal.indexOf(".") + 1).length();
            if ((Double)this.value < this.getMinDoubleValue()) {
                this.displayMinMaxError(new Message(RB.getStringResource("valueBelowMin.fmt.txt"), (Object)String.valueOf(this.getMinDoubleValue())), s);
            } else if ((Double)this.value > this.getMaxDoubleValue()) {
                this.displayMinMaxError(new Message(RB.getStringResource("valueAboveMax.fmt.txt"), (Object)String.valueOf(this.getMaxDoubleValue())), s);
            } else if (decPlaces > this.getMaxDecimalPlaces()) {
                this.displayMinMaxError(new Message(RB.getStringResource("decimalPlacesAboveMax.fmt.txt"), (Object)String.valueOf(this.getMaxDecimalPlaces())), s);
            }
        } else if (this.value instanceof Date && this.value != null) {
            try {
                if (this.value instanceof DatePeriod) {
                    boolean bothRelativeOrAbsolute = false;
                    if (((DatePeriod)this.value).isRelativeDate() && this.minDateRelative) {
                        bothRelativeOrAbsolute = true;
                    } else if (!((DatePeriod)this.value).isRelativeDate() && !this.minDateRelative) {
                        bothRelativeOrAbsolute = true;
                    }
                    if (bothRelativeOrAbsolute && ((DatePeriod)this.value).getStartOfPeriod().getTime() < this.getMinDateValue().getTime()) {
                        this.displayMinMaxError(new Message(RB.getStringResource("valueBelowMin.fmt.txt"), this.transform.transform((Object)this.getMinDateValue())), s);
                    } else {
                        bothRelativeOrAbsolute = false;
                        if (((DatePeriod)this.value).isRelativeDate() && this.maxDateRelative) {
                            bothRelativeOrAbsolute = true;
                        } else if (!((DatePeriod)this.value).isRelativeDate() && !this.maxDateRelative) {
                            bothRelativeOrAbsolute = true;
                        }
                        if (bothRelativeOrAbsolute && ((DatePeriod)this.value).getStartOfPeriod().getTime() > this.getMaxDateValue().getTime()) {
                            this.displayMinMaxError(new Message(RB.getStringResource("valueAboveMax.fmt.txt"), this.transform.transform((Object)this.getMaxDateValue())), s);
                        }
                    }
                } else if (!this.minDateRelative && ((Date)this.value).getTime() < this.getMinDateValue().getTime()) {
                    this.displayMinMaxError(new Message(RB.getStringResource("valueBelowMin.fmt.txt"), this.transform.transform((Object)this.getMinDateValue())), s);
                } else if (!this.maxDateRelative && ((Date)this.value).getTime() > this.getMaxDateValue().getTime()) {
                    this.displayMinMaxError(new Message(RB.getStringResource("valueAboveMax.fmt.txt"), this.transform.transform((Object)this.getMaxDateValue())), s);
                }
            }
            catch (TransformException transformException) {
                // empty catch block
            }
        }
        this.lastValue = s;
        return super.stopCellEditing();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.value = null;
        this.lastValue = value;
        this.type = null;
        ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
        this.type = table instanceof TableView ? ((TableView)table).getUnformattedColumnClass(column) : table.getColumnClass(column);
        if (this.type == Object.class) {
            this.type = String.class;
        }
        if (this.transform != null) {
            try {
                value = this.transform.transform(value);
            }
            catch (TransformException transformException) {
                // empty catch block
            }
        }
        if (this.getGenericErrorHandler() == null && table instanceof SupportsGenericErrorHandlerInterface) {
            SupportsGenericErrorHandlerInterface viewer = (SupportsGenericErrorHandlerInterface)table;
            this.viewerErrorHandler = viewer.getGenericErrorHandler();
        }
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    public void flagError(Message message, Object s) {
        ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
        if (this.getGenericErrorHandler() != null) {
            this.viewerErrorHandler = this.getGenericErrorHandler();
        }
        if (!(this.viewerErrorHandler == null || s != null && s.equals(this.lastValue))) {
            this.lastValue = s;
            this.viewerErrorHandler.handleError((Object)this.getComponent(), message, null);
        }
        this.lastValue = s;
    }

    public void displayMinMaxError(Message message, Object s) {
        if (this.getGenericErrorHandler() != null) {
            this.viewerErrorHandler = this.getGenericErrorHandler();
        }
        if (!(this.viewerErrorHandler == null || s != null && s.equals(this.lastValue))) {
            this.lastValue = s;
            this.viewerErrorHandler.handleError((Object)this.getComponent(), message, null);
        }
        this.lastValue = s;
    }

    public void setSupportedSpecialValues(SupportedSpecialValues specialValues) {
        this.specialValues = specialValues;
    }

    public SupportedSpecialValues getSupportedSpecialValues() {
        return this.specialValues;
    }

    public void setMinLength(int length) {
        this.minLength = length;
    }

    public void setMaxLength(int length) {
        this.maxLength = length;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        if (this.maxLength == 0) {
            return Integer.MAX_VALUE;
        }
        return this.maxLength;
    }

    public void setMinValue(int value) {
        this.minValue = value;
    }

    public void setMaxValue(int value) {
        this.maxValue = value;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        if (this.maxValue == 0) {
            return Integer.MAX_VALUE;
        }
        return this.maxValue;
    }

    public void setMinDecimalPlaces(int value) {
        this.minDecimalPlaces = value;
    }

    public void setMaxDecimalPlaces(int value) {
        this.maxDecimalPlaces = value;
    }

    public int getMinDecimalPlaces() {
        return this.minDecimalPlaces;
    }

    public int getMaxDecimalPlaces() {
        if (this.maxDecimalPlaces == 0) {
            return 15;
        }
        return this.maxDecimalPlaces;
    }

    public void setMinDoubleValue(double value) {
        this.minDoubleValue = value;
    }

    public void setMaxDoubleValue(double value) {
        this.maxDoubleValue = value;
    }

    public double getMinDoubleValue() {
        return this.minDoubleValue;
    }

    public double getMaxDoubleValue() {
        if (this.maxDoubleValue == 0.0) {
            return Double.MAX_VALUE;
        }
        return this.maxDoubleValue;
    }

    public void setMinDateValue(Date value) {
        this.minDateRelative = false;
        if (value instanceof DatePeriod) {
            if (((DatePeriod)value).isRelativeDate()) {
                this.minDateRelative = true;
            }
            this.minDateValue = ((DatePeriod)value).getStartOfPeriod().getTime();
        } else if (value != null) {
            this.minDateValue = value.getTime();
        }
    }

    public void setMaxDateValue(Date value) {
        this.maxDateRelative = false;
        if (value instanceof DatePeriod) {
            if (((DatePeriod)value).isRelativeDate()) {
                this.maxDateRelative = true;
            }
            this.maxDateValue = ((DatePeriod)value).getStartOfPeriod().getTime();
        } else if (value != null) {
            this.maxDateValue = value.getTime();
        }
    }

    public Date getMinDateValue() {
        return new Date(this.minDateValue);
    }

    public Date getMaxDateValue() {
        return new Date(this.maxDateValue);
    }

    public Object getValue() {
        return this.value;
    }
}

