/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.dataselectors.format.DataItemFormatAdapter;
import com.sas.dataselectors.format.SASUserDefinedFormatModel;
import com.sas.datatypes.CollectionType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DataTypeUtil;
import com.sas.datatypes.DateType;
import com.sas.datatypes.DoubleType;
import com.sas.datatypes.IntegerType;
import com.sas.datatypes.MonthType;
import com.sas.datatypes.QuarterType;
import com.sas.datatypes.StringType;
import com.sas.datatypes.TimeStampType;
import com.sas.datatypes.TimeType;
import com.sas.datatypes.WeekType;
import com.sas.datatypes.WeekdayType;
import com.sas.datatypes.YearType;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.physical.Column;
import com.sas.models.datasources.DataSourceColumnInterface;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.models.formats.SASFormatModel;
import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.DynamicPromptValueContext;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.DynamicValueProviderInterface;
import com.sas.prompts.PromptDynamicValueProviderWrapper;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.DateDefinitionInterface;
import com.sas.prompts.definitions.DoubleDefinitionInterface;
import com.sas.prompts.definitions.IntegerDefinitionInterface;
import com.sas.prompts.definitions.MutableSelectableDefinitionInterface;
import com.sas.prompts.definitions.MutableValueProviderDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionEnum;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.TextDefinitionInterface;
import com.sas.prompts.groups.PromptGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.PromptDataProviderInterface;
import com.sas.prompts.valueprovider.dynamic.iq.DataItemValueProvider;
import com.sas.prompts.valueprovider.dynamic.iq.InfoMapItemsValueProvider;
import com.sas.prompts.valueprovider.dynamic.iq.RelationalDataItemValueProvider;
import com.sas.prompts.valueprovider.dynamic.workspace.ColumnNamesValueProvider;
import com.sas.prompts.valueprovider.dynamic.workspace.DataSourceColumnWithFormat;
import com.sas.prompts.valueprovider.dynamic.workspace.PromptColumnValueProvider;
import com.sas.prompts.visuals.swing.designtime.BaseSpecialValuesPanel;
import com.sas.prompts.visuals.swing.designtime.GetSelectedItemsInterface;
import com.sas.prompts.visuals.swing.designtime.OkEnabledOptionsDialog;
import com.sas.prompts.visuals.swing.designtime.PromptPanelConstantsInterface;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.services.information.metadata.PhysicalTableInterface;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.simplesqlmodel.ColumnInfo;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.valueprovider.ValueType;
import com.sas.storage.valueprovider.workspace.ColumnValueProvider;
import com.sas.swing.models.ValueProviderModelAdapter;
import com.sas.swing.util.SASJavaHelp;
import com.sas.swing.visuals.ComboBox;
import com.sas.swing.visuals.PanelInterface;
import com.sas.swing.visuals.ValueListEditor;
import com.sas.swing.visuals.ValuePicker;
import com.sas.swing.visuals.ValuePickerRendererHandler;
import com.sas.swing.visuals.WideComboBox;
import com.sas.swing.visuals.dataselectors.format.FormatAdapterInterface;
import com.sas.swing.visuals.dataselectors.format.FormatSelector;
import com.sas.swing.visuals.util.Util;
import com.sas.table.MutableTableColumnsInterface;
import com.sas.text.Message;
import com.sas.util.MutableSupportedSpecialValuesInterface;
import com.sas.util.Strings;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.ValueItem;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.errorhandlers.JOptionPaneErrorHandler;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.adapters.ProportionalSpacePartitioner;
import com.sas.visuals.adapters.SpacePartitionerInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

class DynamicValuesRelationalPanel
extends BaseSpecialValuesPanel
implements ActionListener,
GetSelectedItemsInterface,
ItemListener {
    private boolean showSortOrderPanel;
    private boolean userDefinedDataProvider;
    public boolean showMeasureWarning;
    private long dataSourceType;
    private ValueItem unformattedValueValueItem;
    private ValueItem formattedValueValueItem;
    private PromptDataProviderInterface dataProvider;
    private DefaultComboBoxModel choiceLabelModel;
    DefaultComboBoxModel choiceValueModel;
    private DefaultComboBoxModel defaultValueModel;
    private DynamicValueProviderInterface valueProvider;
    private JButton choiceLabelFormatButton;
    private JButton defaultValueButton;
    private JCheckBox appendCheckBox;
    private ComboBox choiceLabelCombo;
    private ComboBox choiceValueCombo;
    private ComboBox sortOrderCombo;
    private JLabel choiceLabelFormatField;
    private JLabel choiceValueColumnLabel;
    private JLabel choiceLabelColumnLabel;
    private JPanel outerChoicePanel;
    private JPanel appendCheckBoxPanel;
    private List defaultValues;
    private String url;
    private String selectionType;
    private ValuePicker valuePicker;
    private ValueItem allValueItem;
    private ValueItem otherValueItem;
    private ValueItem missingValueItem;
    private ValueItem noneValueItem;
    private SASJavaHelp javaHelp;
    private String helpDocProduct;
    private WideComboBox defaultValueCombo;
    private boolean allowUserValues;
    private boolean defaultLabelFormat;
    private String currentLabelFormat;
    private ValueItem noItemsValueItem;
    private static ValueItem useUnformattedValueItem;
    private static Object useUnformattedObject;
    private String errors;
    private static String LABEL_COLUMN;
    private static String LABEL_DATA_ITEM;
    private static final long serialVersionUID = 3257563988660598326L;
    private CommonLoggerInterface logger = null;
    private String promptType;
    private List selectedItems;
    private DefaultComboBoxModel sortOrderModel;
    private JCheckBox distinctCheckBox;
    private String DEFAULT_SORT_ORDER = RB.getStringResource("useDefaultSortOrder.txt");
    private String ASCENDING_FORMATTED_SORT_ORDER = RB.getStringResource("ascendingLabel.txt");
    private String DESCENDING_FORMATTED_SORT_ORDER = RB.getStringResource("descendingLabel.txt");
    private String ASCENDING_UNFORMATTED_SORT_ORDER = RB.getStringResource("ascendingValue.txt");
    private String DESCENDING_UNFORMATTED_SORT_ORDER = RB.getStringResource("descendingValue.txt");

    public DynamicValuesRelationalPanel(PromptDefinitionInterface prompt, String selectionType, DataSourceInterface dataSource, PropertiesCommunicator communicator) {
        this(prompt, selectionType, dataSource, communicator, true);
    }

    public DynamicValuesRelationalPanel(String promptType, PromptDefinitionInterface prompt, String selectionType, DataSourceInterface dataSource, PropertiesCommunicator communicator, boolean showSortOrderPanel) {
        super(prompt, communicator, 1);
        this.promptType = promptType;
        this.setContentsValid(true);
        this.showSortOrderPanel = showSortOrderPanel;
        this.url = null;
        if (dataSource != null) {
            this.url = dataSource.getDataSourceLocation();
            this.dataSourceType = dataSource.getDataSourceType();
            this.showMeasureWarning = true;
        } else {
            this.showMeasureWarning = false;
        }
        this.valueProvider = null;
        this.selectionType = selectionType;
        this.createPanel();
    }

    public DynamicValuesRelationalPanel(PromptDefinitionInterface prompt, String selectionType, DataSourceInterface dataSource, PropertiesCommunicator communicator, boolean showSortOrderPanel) {
        this(null, prompt, selectionType, dataSource, communicator, showSortOrderPanel);
    }

    public DynamicValuesRelationalPanel(PromptDefinitionInterface prompt, String selectionType, DataSourceInterface dataSource, DynamicValueProviderInterface valueProvider, PropertiesCommunicator communicator) {
        super(prompt, communicator, 1);
        this.setContentsValid(true);
        this.url = null;
        if (dataSource != null) {
            this.url = dataSource.getDataSourceLocation();
            this.dataSourceType = dataSource.getDataSourceType();
            this.showMeasureWarning = true;
        } else {
            this.showMeasureWarning = false;
        }
        this.valueProvider = valueProvider;
        this.selectionType = selectionType;
        this.showSortOrderPanel = true;
        this.createPanel();
    }

    private void createPanel() {
        PromptDataProviderInterface userDataProvider = this.communicator.getDataProvider();
        this.allValueItem = PromptUtility.newAllSpecialValuesValueItem(this.getLocale());
        this.otherValueItem = PromptUtility.newOtherSpecialValuesValueItem(this.getLocale());
        String promptType = this.getDataTypeLabel(this.prompt);
        if (promptType == null || promptType.equals("")) {
            promptType = this.promptType;
        }
        this.missingValueItem = promptType.equals("Text") ? new ValueItem((Object)MissingValues.toDisplayString((MissingValues)MissingValues._BLANK_, (Locale)this.getLocale()), (Object)MissingValues._BLANK_) : new ValueItem((Object)MissingValues.toDisplayString((MissingValues)MissingValues.Dot, (Locale)this.getLocale()), (Object)MissingValues.Dot);
        this.noneValueItem = PromptUtility.newNoneValueItem();
        this.noItemsValueItem = PromptUtility.newNoColumnsValueItem();
        if (userDataProvider != null) {
            this.dataProvider = userDataProvider;
            this.userDefinedDataProvider = true;
        } else {
            this.dataProvider = new DataProvider(this.communicator.getUserContext());
        }
        Border emptyBorder = BorderFactory.createEmptyBorder(0, 5, 2, 5);
        AutoSizingGridLayout layout = null;
        if (this.showSortOrderPanel) {
            layout = new AutoSizingGridLayout(-1, 1, 0, 5, true, false, true);
        } else {
            layout = new AutoSizingGridLayout(3, 1, 0, 5, true, true, true);
            layout.setRemainderRow(3);
        }
        this.setLayout((LayoutManager)layout);
        JPanel outerValuePanel = new JPanel();
        AutoSizingGridLayout outerValueLayout = new AutoSizingGridLayout(1, 2, 10, 5, true, false, true);
        outerValueLayout.setRemainderColumn(1);
        outerValuePanel.setLayout((LayoutManager)outerValueLayout);
        JPanel choiceValuePanel = new JPanel();
        AutoSizingGridLayout choiceValueLayout = new AutoSizingGridLayout(2, 2, 10, 5, true, false, false);
        choiceValuePanel.setLayout((LayoutManager)choiceValueLayout);
        this.choiceValueColumnLabel = new JLabel(RB.getStringResource("column.txt"));
        this.choiceValueCombo = new ComboBox();
        this.choiceValueModel = new DefaultComboBoxModel();
        this.choiceValueCombo.setModel((ComboBoxModel)this.choiceValueModel);
        this.choiceValueCombo.getAccessibleContext().setAccessibleName("choiceValueCombo");
        this.distinctCheckBox = new JCheckBox(RB.getStringResource("distinct.txt"));
        this.distinctCheckBox.getAccessibleContext().setAccessibleName("distinctCheckbox");
        choiceValuePanel.add(this.choiceValueColumnLabel);
        choiceValuePanel.add(new JLabel(""));
        choiceValuePanel.add((Component)this.choiceValueCombo);
        choiceValuePanel.add(this.distinctCheckBox);
        JPanel choiceValueFormatPanel = new JPanel();
        AutoSizingGridLayout choiceValueFormatPanelLayout = new AutoSizingGridLayout(2, 1, 10, 5, true, false, true);
        choiceValueFormatPanel.setLayout((LayoutManager)choiceValueFormatPanelLayout);
        outerValuePanel.add(choiceValuePanel);
        outerValuePanel.add(choiceValueFormatPanel);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(RB.getStringResource("resolveTo.txt"));
        outerValuePanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, emptyBorder));
        JPanel outerLabelPanel = new JPanel();
        AutoSizingGridLayout outerLabelPanelLayout = new AutoSizingGridLayout(1, 2, 10, 5, true, false, true);
        outerLabelPanelLayout.setRemainderColumn(1);
        outerLabelPanel.setLayout((LayoutManager)outerLabelPanelLayout);
        JPanel choiceLabelPanel = new JPanel();
        AutoSizingGridLayout choiceLabelLayout = new AutoSizingGridLayout(2, 1, 10, 5, true, false, true);
        choiceLabelPanel.setLayout((LayoutManager)choiceLabelLayout);
        this.choiceLabelColumnLabel = new JLabel(RB.getStringResource("column.txt"));
        this.choiceLabelCombo = new ComboBox();
        this.choiceLabelModel = new DefaultComboBoxModel();
        this.choiceLabelCombo.setModel((ComboBoxModel)this.choiceLabelModel);
        this.choiceLabelCombo.getAccessibleContext().setAccessibleName("choiceLabelCombo");
        choiceLabelPanel.add(this.choiceLabelColumnLabel);
        choiceLabelPanel.add((Component)this.choiceLabelCombo);
        JPanel choiceLabelFormatPanel = new JPanel();
        AutoSizingGridLayout choiceLabelFormatPanelLayout = new AutoSizingGridLayout(2, 1, 10, 5, true, false, true);
        choiceLabelFormatPanel.setLayout((LayoutManager)choiceLabelFormatPanelLayout);
        JLabel choiceLabelFormatLabel = new JLabel(RB.getStringResource("format.txt"));
        JPanel choiceLabelFormatButtonPanel = new JPanel();
        AutoSizingGridLayout choiceLabelFormatButtonPanelLayout = new AutoSizingGridLayout(1, 2, 5, 5, true, false, true);
        choiceLabelFormatButtonPanelLayout.setRemainderColumn(1);
        choiceLabelFormatButtonPanel.setLayout((LayoutManager)choiceLabelFormatButtonPanelLayout);
        this.choiceLabelFormatField = new JLabel("                      ");
        this.choiceLabelFormatField.setPreferredSize(new Dimension(200, 21));
        this.choiceLabelFormatField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(0, 2, 0, 2)));
        this.choiceLabelFormatButton = new JButton(RB.getStringResource("set.txt"));
        this.choiceLabelFormatButton.setEnabled(false);
        this.choiceLabelFormatButton.addActionListener(this);
        choiceLabelFormatButtonPanel.add(this.choiceLabelFormatField);
        choiceLabelFormatButtonPanel.add(this.choiceLabelFormatButton);
        choiceLabelFormatButtonPanel.add(this.choiceLabelFormatField);
        choiceLabelFormatButtonPanel.add(this.choiceLabelFormatButton);
        choiceLabelFormatPanel.add(choiceLabelFormatLabel);
        choiceLabelFormatPanel.add(choiceLabelFormatButtonPanel);
        outerLabelPanel.add(choiceLabelPanel);
        outerLabelPanel.add(choiceLabelFormatPanel);
        TitledBorder titledBorderLabel = BorderFactory.createTitledBorder(RB.getStringResource("displayAs.txt"));
        outerLabelPanel.setBorder(BorderFactory.createCompoundBorder(titledBorderLabel, emptyBorder));
        AutoSizingGridLayout outerChoicePanelLayout = null;
        this.outerChoicePanel = new JPanel();
        if (this.showSortOrderPanel) {
            outerChoicePanelLayout = new AutoSizingGridLayout(1, 2, 10, 5, true, false, true);
            outerChoicePanelLayout.setRemainderRow(1);
        } else {
            outerChoicePanelLayout = new AutoSizingGridLayout(1, 1, 10, 5, true, true, true);
        }
        this.outerChoicePanel.setLayout((LayoutManager)outerChoicePanelLayout);
        if (this.showSortOrderPanel) {
            JPanel sortOrderPanel = new JPanel();
            AutoSizingGridLayout sortOrderLayout = new AutoSizingGridLayout(2, 1, 10, 5, true, false, true);
            sortOrderPanel.setLayout((LayoutManager)sortOrderLayout);
            JLabel sortOrderColumnLabel = new JLabel(RB.getStringResource("sortOrder.txt"));
            this.sortOrderCombo = new ComboBox();
            this.sortOrderModel = new DefaultComboBoxModel();
            this.sortOrderModel.addElement(this.DEFAULT_SORT_ORDER);
            this.sortOrderModel.addElement(this.ASCENDING_FORMATTED_SORT_ORDER);
            this.sortOrderModel.addElement(this.DESCENDING_FORMATTED_SORT_ORDER);
            this.sortOrderModel.addElement(this.ASCENDING_UNFORMATTED_SORT_ORDER);
            this.sortOrderModel.addElement(this.DESCENDING_UNFORMATTED_SORT_ORDER);
            this.sortOrderCombo.setModel((ComboBoxModel)this.sortOrderModel);
            sortOrderPanel.add(sortOrderColumnLabel);
            sortOrderPanel.add((Component)this.sortOrderCombo);
            JPanel defaultValuePanel = new JPanel();
            AutoSizingGridLayout defaultValuePanelLayout = new AutoSizingGridLayout(2, 1, 10, 5, true, false, true);
            defaultValuePanel.setLayout((LayoutManager)defaultValuePanelLayout);
            JLabel defaultValueFormatLabel = new JLabel(RB.getStringResource("defaultValue.txt"));
            if (!"Single value".equals(this.selectionType)) {
                defaultValueFormatLabel.setText(RB.getStringResource("defaultValuesColon.txt"));
            }
            this.defaultValueCombo = new WideComboBox();
            this.defaultValueModel = new DefaultComboBoxModel();
            this.defaultValueModel.addElement(this.noneValueItem);
            this.defaultValueCombo.setModel((ComboBoxModel)this.defaultValueModel);
            this.defaultValueButton = new JButton(RB.getStringResource("specify.txt"));
            this.defaultValueButton.setEnabled(false);
            this.defaultValueButton.addActionListener(this);
            JPanel defaultValueCombinedPanel = new JPanel();
            AutoSizingGridLayout defaultValueCombinedPanelLayout = new AutoSizingGridLayout(1, 2, 5, 5, true, false, true);
            defaultValueCombinedPanelLayout.setRemainderColumn(1);
            ProportionalSpacePartitioner partitioner = new ProportionalSpacePartitioner(new double[]{1.0, -2.0}, null, null, false);
            defaultValueCombinedPanelLayout.setColumnSpacePartitioner((SpacePartitionerInterface)partitioner);
            defaultValueCombinedPanel.setLayout((LayoutManager)defaultValueCombinedPanelLayout);
            defaultValueCombinedPanel.add((Component)this.defaultValueCombo);
            defaultValueCombinedPanel.add(this.defaultValueButton);
            defaultValuePanel.add(defaultValueFormatLabel);
            defaultValuePanel.add(defaultValueCombinedPanel);
            this.outerChoicePanel.add(sortOrderPanel);
            this.outerChoicePanel.add(defaultValuePanel);
            this.appendCheckBoxPanel = new JPanel();
            AutoSizingGridLayout appendCheckBoxLayout = new AutoSizingGridLayout(2, 1, 10, 5, true, false, false);
            this.appendCheckBoxPanel.setLayout((LayoutManager)appendCheckBoxLayout);
            this.appendCheckBox = new JCheckBox(RB.getStringResource("appendDisplayAs.txt"));
            this.appendCheckBoxPanel.add(this.appendCheckBox);
            if (this.prompt != null && this.valueProvider != null) {
                if (this.valueProvider instanceof RelationalDataItemValueProvider) {
                    this.appendCheckBox.setSelected(((RelationalDataItemValueProvider)this.valueProvider).isValueDisplayed());
                } else if (this.valueProvider instanceof PromptColumnValueProvider) {
                    this.appendCheckBox.setSelected(((PromptColumnValueProvider)this.valueProvider).isValueDisplayed());
                }
            }
        } else {
            this.valuePicker = new ValuePicker(null, 403, 302, false, null, this.getDataType(promptType), this.getLocale());
            this.valuePicker.setRendererHandler((ValuePickerRendererHandler)new ValueRendererHandler(this.getDataType(promptType)));
            this.valuePicker.setSourceLabel(RB.getStringResource("availableValues.txt"));
            this.valuePicker.setTargetLabel(RB.getStringResource("selectedValues.txt"));
            if (this.valuePicker != null) {
                ValueListEditor vle = (ValueListEditor)this.valuePicker.getTargetComponent();
                vle.addItems((Collection)this.getInitialSelectedItems());
            }
            MutableTableColumnsInterface tm = (MutableTableColumnsInterface)this.valuePicker.getTargetModel();
            ArrayList<String> columns = new ArrayList<String>();
            columns.add("VALUE");
            columns.add("LABEL");
            tm.setColumnName(RB.getStringResource("choiceValues.txt"), 0);
            tm.setColumnName(RB.getStringResource("choiceLabels.txt"), 1);
            tm.setColumns(columns);
            ((ValueListEditor)this.valuePicker.getTargetComponent()).getTable().setColumnHeaderVisible(true);
            this.outerChoicePanel.add((Component)this.valuePicker);
        }
        this.add(outerValuePanel);
        this.add(outerLabelPanel);
        if (this.showSortOrderPanel) {
            this.add(this.appendCheckBoxPanel);
            this.add(this.createSpecialValuesFields());
        }
        this.add(this.outerChoicePanel);
        outerLabelPanelLayout.setInterlockedColumnContainers(new Container[]{outerLabelPanel, choiceValuePanel});
        choiceValueLayout.setInterlockedColumnContainers(new Container[]{choiceValuePanel, outerLabelPanel});
        if (this.url != null && this.url.trim().length() > 0) {
            this.intializeFields();
        } else {
            this.setFieldsToDefaultSettings();
        }
        this.choiceLabelCombo.addActionListener((ActionListener)this);
        this.choiceValueCombo.addActionListener((ActionListener)this);
        if (this.showSortOrderPanel) {
            this.allCheckBox.addItemListener(this);
            this.noneCheckBox.addItemListener(this);
            this.missingCheckBox.addItemListener(this);
        }
    }

    private void setFieldsToDefaultSettings() {
        this.choiceLabelCombo.removeActionListener((ActionListener)this);
        this.choiceValueCombo.removeActionListener((ActionListener)this);
        this.choiceLabelModel.removeAllElements();
        this.choiceValueModel.removeAllElements();
        this.choiceLabelModel.addElement(this.noItemsValueItem);
        this.choiceValueModel.addElement(this.noItemsValueItem);
        this.choiceLabelFormatField.setText("");
        if (this.showSortOrderPanel) {
            this.sortOrderCombo.setSelectedIndex(0);
            this.appendCheckBox.setSelected(false);
            if (this.allCheckBox.isSelected()) {
                this.defaultValueCombo.addItem((Object)this.allValueItem);
            }
            if (this.noneCheckBox.isSelected()) {
                this.defaultValueCombo.addItem((Object)this.otherValueItem);
            }
            if (this.missingCheckBox.isSelected()) {
                this.defaultValueCombo.addItem((Object)this.missingValueItem);
            }
        }
        this.initializeDefaultValue();
        this.toggleButtonsEnabled(false);
        this.choiceLabelCombo.addActionListener((ActionListener)this);
        this.choiceValueCombo.addActionListener((ActionListener)this);
    }

    private void intializeFields() {
        Map savedProperties;
        this.distinctCheckBox.setEnabled(false);
        this.distinctCheckBox.setSelected(true);
        try {
            Map savedProperties2;
            DataItem dataItem;
            boolean accept;
            List listValues = null;
            List labelValues = null;
            String labelUnformatted = RB.getStringResource("useUnformattedColumn.txt");
            useUnformattedObject = new Object();
            long selectedPromptDataType = 0L;
            selectedPromptDataType = this.prompt != null ? PromptDefinitionEnum.getDataType((PromptDefinitionInterface)this.prompt) : ("Text".equals(this.promptType) ? 1L : ("Date".equals(this.promptType) || "Week".equals(this.promptType) || "Month".equals(this.promptType) || "Quarter".equals(this.promptType) || "Year".equals(this.promptType) ? 4L : 2L));
            if (this.dataSourceType == 4L) {
                InfoMapItemsValueProvider infoMapLabelItemsValueProvider = new InfoMapItemsValueProvider();
                InfoMapItemsValueProvider infoMapValueItemsValueProvider = new InfoMapItemsValueProvider();
                infoMapLabelItemsValueProvider.setInfoMapUrl(this.url);
                infoMapLabelItemsValueProvider.setDataProvider((DataProviderInterface)this.dataProvider);
                infoMapValueItemsValueProvider.setInfoMapUrl(this.url);
                infoMapValueItemsValueProvider.setDataProvider((DataProviderInterface)this.dataProvider);
                listValues = (List)infoMapLabelItemsValueProvider.getValues(this.getLocale(), ValueType.LIST, 0, -1);
                labelValues = (List)infoMapLabelItemsValueProvider.getValues(this.getLocale(), ValueType.LIST, 0, -1);
                int listSize = listValues.size();
                for (int i = listSize - 1; i >= 0; --i) {
                    ValueItem vItem = (ValueItem)listValues.get(i);
                    String dataItemId = ((DataSourceColumnInterface)vItem.getValue()).getColumnName();
                    DataItem candidate = ((DataProvider)this.dataProvider).getDataItemFromId(this.url, dataItemId);
                    accept = false;
                    long type = candidate.getExpressionTypeIgnoringFormattingForced();
                    ExpressionInterface expression = candidate.getExpression();
                    if (expression instanceof Column) {
                        type = ((Column)expression).getExpressionType();
                    }
                    if (accept = PromptUtility.isDataItemValidForPromptDataType(selectedPromptDataType, type)) continue;
                    listValues.remove(i);
                }
                this.choiceLabelColumnLabel.setText(LABEL_DATA_ITEM);
                this.choiceValueColumnLabel.setText(LABEL_DATA_ITEM);
                labelUnformatted = RB.getStringResource("useUnformattedDataItem.txt");
                this.noItemsValueItem = PromptUtility.newNoDataItemsValueItem();
            } else if (this.dataSourceType == 1L) {
                ColumnNamesValueProvider columnNamesValueProvider = new ColumnNamesValueProvider(this.url);
                PromptGroup promptGroup = new PromptGroup();
                PromptValues promptValues = new PromptValues((PromptGroupInterface)promptGroup);
                DynamicPromptValueContext dynamicValueContext = new DynamicPromptValueContext((PromptValuesInterface)promptValues, (PromptGroupInterface)promptGroup, null, (DataProviderInterface)this.dataProvider);
                listValues = (List)columnNamesValueProvider.getValues(this.getLocale(), (DynamicPromptValueContextInterface)dynamicValueContext, ValueType.LIST);
                labelValues = (List)columnNamesValueProvider.getValues(this.getLocale(), (DynamicPromptValueContextInterface)dynamicValueContext, ValueType.LIST);
                int listSize = listValues.size();
                for (int i = listSize - 1; i >= 0; --i) {
                    ValueItem vItem = (ValueItem)listValues.get(i);
                    accept = false;
                    long colType = ((DataSourceColumnInterface)vItem.getValue()).getColumnType();
                    accept = PromptUtility.isColumnValidForPromptDataType(selectedPromptDataType, colType);
                    if (accept) continue;
                    listValues.remove(i);
                }
                this.choiceLabelColumnLabel.setText(LABEL_COLUMN);
                this.choiceValueColumnLabel.setText(LABEL_COLUMN);
                this.noItemsValueItem = PromptUtility.newNoColumnsValueItem();
                this.distinctCheckBox.setEnabled(true);
            }
            this.choiceLabelModel.removeAllElements();
            this.choiceValueModel.removeAllElements();
            String labelName = null;
            String valueName = null;
            ValueItem labelSelectedItem = null;
            ValueItem valueSelectedItem = null;
            ColumnInfo labelColumnInfo = null;
            ColumnInfo valueColumnInfo = null;
            DataSourceColumnInterface dataSourceColumn = this.communicator.getDataSourceColumn();
            if (this.valueProvider instanceof RelationalDataItemValueProvider) {
                DataItem label = ((RelationalDataItemValueProvider)this.valueProvider).getLabelDataItem();
                if (null != label) {
                    labelName = label.getID();
                }
                DataItem dataItem2 = null;
                try {
                    dataItem2 = ((RelationalDataItemValueProvider)this.valueProvider).getDataItem();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                if (null != dataItem2) {
                    valueName = dataItem2.getID();
                }
            } else if (this.valueProvider instanceof PromptColumnValueProvider) {
                labelColumnInfo = ((PromptColumnValueProvider)this.valueProvider).getLabelColumn();
                valueColumnInfo = ((PromptColumnValueProvider)this.valueProvider).getValueColumn();
                if (labelColumnInfo != null) {
                    labelName = labelColumnInfo.getName();
                }
                valueName = valueColumnInfo.getName();
                this.distinctCheckBox.setSelected(((PromptColumnValueProvider)this.valueProvider).isDistinct());
                this.distinctCheckBox.setEnabled(true);
            } else if (dataSourceColumn != null) {
                valueName = dataSourceColumn.getColumnName();
                labelName = dataSourceColumn.getColumnName();
            } else if (this.valueProvider instanceof DataItemValueProvider && null != (dataItem = ((DataItemValueProvider)this.valueProvider).getDataItem())) {
                labelName = valueName = dataItem.getID();
            }
            if (listValues.size() == 0) {
                this.errors = RB.getStringResource("noDataItemsSelectMap.txt", this.getLocale());
                this.choiceLabelModel.addElement(this.noItemsValueItem);
                this.choiceValueModel.addElement(this.noItemsValueItem);
            } else {
                for (ValueItem valueItem : labelValues) {
                    String valueItemValue = ((DataSourceColumnInterface)valueItem.getValue()).getColumnName();
                    if (valueItemValue != null) {
                        if (labelName != null && labelName.equals(valueItemValue)) {
                            labelSelectedItem = valueItem;
                        }
                        if (valueName != null && valueName.equals(valueItemValue)) {
                            valueSelectedItem = valueItem;
                        }
                    }
                    this.choiceLabelModel.addElement(valueItem);
                }
            }
            boolean foundValue = false;
            for (ValueItem valueItem : listValues) {
                String valueItemValue = ((DataSourceColumnInterface)valueItem.getValue()).getColumnName();
                if (valueItemValue != null && valueItemValue instanceof String) {
                    if (labelName != null && labelName.equalsIgnoreCase(valueItemValue)) {
                        labelSelectedItem = valueItem;
                    }
                    if (valueName != null && valueName.equalsIgnoreCase(valueItemValue)) {
                        valueSelectedItem = valueItem;
                        foundValue = true;
                    }
                }
                this.choiceValueModel.addElement(valueItem);
            }
            if (valueName != null && !foundValue && this.showSortOrderPanel && (savedProperties2 = this.communicator.getPromptProperties()).isEmpty()) {
                String message = RB.getStringResource("dataItemDeleted.txt");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)PromptUtility.getParentFrame(this.communicator, this), new Message(message), null);
                }
                this.getLogger().error(message);
                if (this.prompt != null) {
                    this.prompt.clearDefaultValue();
                }
            }
            if (valueSelectedItem != null) {
                this.choiceValueCombo.setSelectedItem(valueSelectedItem);
            }
            if (labelSelectedItem != null) {
                this.choiceLabelCombo.setSelectedItem(labelSelectedItem);
            } else {
                this.choiceLabelCombo.setSelectedItem(this.choiceValueCombo.getSelectedItem());
            }
            useUnformattedValueItem = new ValueItem((Object)labelUnformatted, (Object)labelUnformatted);
            if (this.choiceLabelModel.getIndexOf(useUnformattedValueItem) == -1) {
                this.choiceLabelModel.insertElementAt(useUnformattedValueItem, 0);
            }
            if (listValues.size() > 0 && (valueSelectedItem == null || labelSelectedItem == null)) {
                this.choiceLabelCombo.setSelectedItem((Object)useUnformattedValueItem);
                if (this.showSortOrderPanel) {
                    this.updateSortSelection(useUnformattedValueItem);
                }
            }
            this.choiceLabelCombo.setModel((ComboBoxModel)this.choiceLabelModel);
            this.choiceValueCombo.setModel((ComboBoxModel)this.choiceValueModel);
            this.unformattedValueValueItem = (ValueItem)this.choiceValueCombo.getSelectedItem();
            this.formattedValueValueItem = (ValueItem)this.choiceLabelCombo.getSelectedItem();
            if (listValues.size() == 0) {
                this.toggleButtonsEnabled(true);
                this.clearLabelFormatField(true);
            }
            if (this.unformattedValueValueItem != null && this.unformattedValueValueItem.getValue() instanceof DataSourceColumnInterface) {
                this.toggleButtonsEnabled(true);
            } else {
                this.toggleButtonsEnabled(false);
            }
            this.populateLabelFormatField();
            if (!this.showSortOrderPanel && listValues.size() > 0) {
                ValueProviderInterface valuePickerProvider = this.createValuePickerValueProvider();
                this.valuePicker = new ValuePicker(valuePickerProvider, 403, 302, false, null, this.getDataType(this.promptType), this.getLocale());
                this.valuePicker.setRendererHandler((ValuePickerRendererHandler)new ValueRendererHandler(this.getDataType(this.promptType)));
                this.valuePicker.setSourceLabel(RB.getStringResource("availableValues.txt"));
                this.valuePicker.setTargetLabel(RB.getStringResource("selectedValues.txt"));
                MutableTableColumnsInterface tm = (MutableTableColumnsInterface)this.valuePicker.getTargetModel();
                ArrayList<String> columns = new ArrayList<String>();
                columns.add("VALUE");
                columns.add("LABEL");
                tm.setColumnName(RB.getStringResource("choiceValues.txt"), 0);
                tm.setColumnName(RB.getStringResource("choiceLabels.txt"), 1);
                tm.setColumns(columns);
                ((ValueListEditor)this.valuePicker.getTargetComponent()).getTable().setColumnHeaderVisible(true);
                this.outerChoicePanel.removeAll();
                this.outerChoicePanel.add((Component)this.valuePicker);
            }
            if (this.showSortOrderPanel) {
                String sortFirst;
                if (this.valueProvider instanceof RelationalDataItemValueProvider) {
                    String sortOrder;
                    sortFirst = ((RelationalDataItemValueProvider)this.valueProvider).getSortFirst();
                    if (this.isSortSet(sortFirst, sortOrder = ((RelationalDataItemValueProvider)this.valueProvider).getSortOrder())) {
                        if ("Label_Value".equals(sortFirst)) {
                            if ("Ascending".equals(sortOrder)) {
                                this.sortOrderCombo.setSelectedItem((Object)this.ASCENDING_FORMATTED_SORT_ORDER);
                            } else {
                                this.sortOrderCombo.setSelectedItem((Object)this.DESCENDING_FORMATTED_SORT_ORDER);
                            }
                        } else if ("Value_Label".equals(sortFirst)) {
                            if ("Ascending".equals(sortOrder)) {
                                this.sortOrderCombo.setSelectedItem((Object)this.ASCENDING_UNFORMATTED_SORT_ORDER);
                            } else {
                                this.sortOrderCombo.setSelectedItem((Object)this.DESCENDING_UNFORMATTED_SORT_ORDER);
                            }
                        }
                    }
                    this.appendCheckBox.setSelected(((RelationalDataItemValueProvider)this.valueProvider).isValueDisplayed());
                } else if (this.valueProvider instanceof PromptColumnValueProvider) {
                    sortFirst = ((PromptColumnValueProvider)this.valueProvider).getSortFirst();
                    this.getLogger().debug("sort first =", sortFirst);
                    if ("SortLabel".equals(sortFirst)) {
                        if (labelColumnInfo != null) {
                            String labelSortOrder = labelColumnInfo.getSortOrder();
                            if ("ASCENDING".equals(labelSortOrder)) {
                                this.sortOrderCombo.setSelectedItem((Object)this.ASCENDING_FORMATTED_SORT_ORDER);
                            } else {
                                this.sortOrderCombo.setSelectedItem((Object)this.DESCENDING_FORMATTED_SORT_ORDER);
                            }
                        }
                    } else if ("SortValue".equals(sortFirst) && valueColumnInfo != null) {
                        String valueSortOrder = valueColumnInfo.getSortOrder();
                        if ("ASCENDING".equals(valueSortOrder)) {
                            this.sortOrderCombo.setSelectedItem((Object)this.ASCENDING_UNFORMATTED_SORT_ORDER);
                        } else {
                            this.sortOrderCombo.setSelectedItem((Object)this.DESCENDING_UNFORMATTED_SORT_ORDER);
                        }
                    }
                    this.appendCheckBox.setSelected(((PromptColumnValueProvider)this.valueProvider).isQualifyLabelWithValue());
                } else {
                    this.sortOrderCombo.setSelectedIndex(0);
                }
                this.getLogger().debug("sortCombo selected index is ", Integer.toString(this.sortOrderCombo.getSelectedIndex()));
                if (this.prompt instanceof MutableSupportedSpecialValuesInterface) {
                    SupportedSpecialValues supportedSpecialValues = new SupportedSpecialValues();
                    supportedSpecialValues.setAllSupported(this.allCheckBox.isSelected());
                    supportedSpecialValues.setOtherSupported(this.noneCheckBox.isSelected());
                    supportedSpecialValues.setMissingValuesSupported(this.missingCheckBox.isSelected());
                    ((MutableSupportedSpecialValuesInterface)this.prompt).setSupportedSpecialValues(supportedSpecialValues);
                    if (this.allCheckBox.isSelected()) {
                        this.defaultValueCombo.addItem((Object)this.allValueItem);
                    }
                    if (this.noneCheckBox.isSelected()) {
                        this.defaultValueCombo.addItem((Object)this.otherValueItem);
                    }
                    if (this.missingCheckBox.isSelected()) {
                        this.defaultValueCombo.addItem((Object)this.missingValueItem);
                    }
                }
            }
        }
        catch (ValueProviderException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
        catch (InvalidIDException ie) {
            this.getLogger().error(ie.getMessage(), (Throwable)ie);
        }
        catch (ServerConnectionException sce) {
            this.getLogger().error(sce.getMessage(), (Throwable)sce);
        }
        if (this.prompt != null && this.prompt.isDefaultValueSet()) {
            Object promptDefaultValue = this.prompt.getDefaultValue();
            if (promptDefaultValue != null) {
                this.processDefaultValue(promptDefaultValue);
            }
        } else if (this.prompt != null && this.showSortOrderPanel && !(savedProperties = this.communicator.getPromptProperties()).isEmpty()) {
            this.initializeDefaultValue();
        }
    }

    private void populateLabelFormatField() {
        if (this.valueProvider instanceof RelationalDataItemValueProvider) {
            if (((RelationalDataItemValueProvider)this.valueProvider).getLabelDataItem() != null) {
                String labelFormat = ((RelationalDataItemValueProvider)this.valueProvider).getLabelFormatString();
                this.getLogger().debug("initFields(),labelFormat is:", labelFormat);
                this.setLabelFormatField(labelFormat);
            } else {
                this.clearLabelFormatField(true);
            }
        } else if (this.valueProvider instanceof PromptColumnValueProvider) {
            if (((PromptColumnValueProvider)this.valueProvider).getLabelColumn() != null) {
                String labelFormat = ((PromptColumnValueProvider)this.valueProvider).getLabelColumn().getFormat();
                this.getLogger().debug("initFields(),labelFormat is:", labelFormat);
                this.setLabelFormatField(labelFormat);
            } else {
                this.clearLabelFormatField(true);
            }
        } else if (this.choiceLabelModel.getSelectedItem() instanceof ValueItem && ((ValueItem)this.choiceLabelModel.getSelectedItem()).getValue() instanceof DataSourceColumnWithFormat) {
            DataSourceColumnWithFormat dscf = (DataSourceColumnWithFormat)((ValueItem)this.choiceLabelModel.getSelectedItem()).getValue();
            this.setLabelFormatField(dscf.getFormat());
            this.getLogger().debug("initFields(), format from dscf is:", dscf.getFormat());
        } else if (this.choiceLabelModel.getSelectedItem() == useUnformattedValueItem || this.choiceLabelModel.getSelectedItem() == this.noItemsValueItem) {
            this.clearLabelFormatField(true);
        } else {
            this.clearLabelFormatField(false);
        }
    }

    private void initializeDefaultValue() {
        Map savedProperties = this.communicator.getPromptProperties();
        if (!savedProperties.isEmpty()) {
            ArrayList<Object> defaultValues = new ArrayList<Object>();
            Object defaultSaved = savedProperties.get("DefaultValue");
            if (defaultSaved == null || this.url == null) {
                return;
            }
            if (this.prompt instanceof TextDefinitionInterface) {
                if (defaultSaved instanceof List) {
                    for (Object o : (List)defaultSaved) {
                        if (o == null) continue;
                        if ("Single value".equals(this.selectionType)) {
                            this.processDefaultValue(o);
                            break;
                        }
                        defaultValues.add(o);
                    }
                    if (!"Single value".equals(this.selectionType)) {
                        this.processDefaultValue(defaultValues);
                    }
                } else if (defaultSaved != null && defaultSaved instanceof String) {
                    if ("Single value".equals(this.selectionType)) {
                        this.processDefaultValue(defaultSaved);
                    } else if (!"Single value".equals(this.selectionType)) {
                        defaultValues.add(defaultSaved);
                        this.processDefaultValue(defaultValues);
                    }
                } else if (defaultSaved == SpecialValues.ALL || defaultSaved == SpecialValues.OTHER || defaultSaved.equals(MissingValues.Dot) || defaultSaved.equals(MissingValues._BLANK_)) {
                    this.processDefaultValue(defaultSaved);
                }
            } else {
                IntegerType dataType = null;
                if (this.prompt instanceof IntegerDefinitionInterface) {
                    dataType = new IntegerType();
                } else if (this.prompt instanceof DoubleDefinitionInterface) {
                    dataType = new DoubleType();
                } else if (this.prompt instanceof DateDefinitionInterface) {
                    dataType = new DateType();
                }
                if (dataType != null) {
                    if (defaultSaved instanceof List) {
                        for (Object o : (List)defaultSaved) {
                            if (o == null) continue;
                            try {
                                Object coercedValue = dataType.coerceValue(o, this.getLocale());
                                if ("Single value".equals(this.selectionType)) {
                                    this.processDefaultValue(coercedValue);
                                    break;
                                }
                                defaultValues.add(coercedValue);
                            }
                            catch (IllegalArgumentException e) {
                                this.getLogger().error(e.getMessage(), (Throwable)e);
                            }
                        }
                        if (!"Single value".equals(this.selectionType)) {
                            this.processDefaultValue(defaultValues);
                        }
                    } else if (defaultSaved != null) {
                        if (defaultSaved == SpecialValues.ALL || defaultSaved == SpecialValues.OTHER) {
                            this.processDefaultValue(defaultSaved);
                        } else {
                            try {
                                Object coercedValue = dataType.coerceValue(defaultSaved, this.getLocale());
                                if ("Single value".equals(this.selectionType)) {
                                    this.processDefaultValue(coercedValue);
                                } else {
                                    defaultValues.add(coercedValue);
                                    this.processDefaultValue(defaultValues);
                                }
                            }
                            catch (IllegalArgumentException e) {
                                this.getLogger().error(e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                }
            }
        }
    }

    private void processDefaultValue(Object promptDefaultValue) {
        if (promptDefaultValue == SpecialValues.OTHER) {
            this.defaultValueCombo.setSelectedItem((Object)this.noneValueItem);
        } else if (promptDefaultValue == SpecialValues.ALL) {
            this.defaultValueCombo.setSelectedItem((Object)this.allValueItem);
        } else if (promptDefaultValue instanceof MissingValues) {
            this.defaultValueCombo.addItem((Object)this.missingValueItem);
            this.defaultValueCombo.setSelectedItem((Object)this.missingValueItem);
        } else {
            ValueItem valueItem = null;
            if (this.selectionType != "Single value" && promptDefaultValue instanceof List) {
                if (((List)promptDefaultValue).size() == 1) {
                    Object obj = ((List)promptDefaultValue).get(0);
                    if (obj instanceof ValueItem) {
                        Object value = ((ValueItem)obj).getValue();
                        if (value != SpecialValues.ALL && value != SpecialValues.OTHER) {
                            valueItem = this.getMultipleValueDefaultValue((List)promptDefaultValue);
                        }
                    } else if (obj == SpecialValues.ALL) {
                        this.defaultValueCombo.setSelectedItem((Object)this.allValueItem);
                    } else if (obj instanceof MissingValues) {
                        this.defaultValueCombo.addItem((Object)this.missingValueItem);
                        this.defaultValueCombo.setSelectedItem((Object)this.missingValueItem);
                    } else {
                        valueItem = this.getMultipleValueDefaultValue((List)promptDefaultValue);
                    }
                } else {
                    valueItem = this.getMultipleValueDefaultValue((List)promptDefaultValue);
                }
            } else if (promptDefaultValue == SpecialValues.ALL) {
                this.defaultValueCombo.setSelectedItem((Object)this.allValueItem);
            } else {
                valueItem = new ValueItem((Object)this.prompt.getPromptDataType().getValueAsString(promptDefaultValue, this.getLocale()), promptDefaultValue);
            }
            if (valueItem != null) {
                this.defaultValueCombo.addItem((Object)valueItem);
                this.defaultValueCombo.setSelectedItem((Object)valueItem);
            }
        }
    }

    private FormatAdapterInterface getFormatAdapter(DataItem dataItem) {
        if (dataItem != null) {
            return new DataItemFormatAdapter(dataItem);
        }
        if (this.unformattedValueValueItem != null) {
            try {
                PhysicalTableInterface table = this.dataProvider.getPhysicalTable(((DataSourceColumnInterface)this.unformattedValueValueItem.getValue()).getDataSource().getDataSourceLocation());
                return new SASUserDefinedFormatModel(((DataProvider)this.dataProvider).getLogicalServerForPathUrl(table), this.communicator.getUserContext());
            }
            catch (ServerConnectionException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
        }
        return new SASFormatModel();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.choiceLabelFormatButton) {
            DataSourceColumnWithFormat dscf;
            String loadedFormat;
            ValueItem item;
            String currentFormat = this.getCurrentLabelFormat();
            ComboBox columnCombo = this.choiceLabelCombo;
            DataItem di = this.getDataItem(columnCombo);
            String defaultFormatString = null;
            if (this.defaultLabelFormat) {
                currentFormat = null;
            }
            if (this.choiceLabelCombo != null && null != (item = (ValueItem)this.choiceLabelCombo.getSelectedItem()) && item.getValue() instanceof DataSourceColumnWithFormat && (loadedFormat = (dscf = (DataSourceColumnWithFormat)item.getValue()).getFormat()) != null && loadedFormat.startsWith(ColumnInfo.DEFAULT_FORMAT) && (defaultFormatString = loadedFormat.substring(ColumnInfo.DEFAULT_FORMAT.length())) != null && defaultFormatString.trim().length() == 0) {
                defaultFormatString = RB.getStringResource("none.txt");
            }
            FormatSelector formatSelector = new FormatSelector((Component)source, this.getFormatAdapter(di), this.getSQLTypeForColumn(columnCombo), currentFormat, defaultFormatString, this.getJavaHelp());
            formatSelector.setHelpID("selectformatdialog");
            JFrame frame = Util.getParentFrame((Component)this);
            Util.centerOver((Window)formatSelector, (Component)frame);
            formatSelector.setVisible(true);
            if (!formatSelector.wasCancelled()) {
                String format = formatSelector.getFormatString();
                boolean change = false;
                if (format == null) {
                    this.setLabelFormatField(ColumnInfo.DEFAULT_FORMAT);
                    format = this.getCurrentLabelFormat();
                    change = true;
                }
                if (!change && !Strings.equal((String)currentFormat, (String)format, (boolean)true, (boolean)false)) {
                    this.setLabelFormatField(format);
                    change = true;
                }
                if (change) {
                    if (!this.showSortOrderPanel) {
                        this.updateValuePicker();
                    } else {
                        Object valueItem = this.defaultValueCombo.getSelectedItem();
                        this.clearInvalidValuesFromDefaultValue();
                        if (this.defaultValueModel.getIndexOf(valueItem) != -1) {
                            this.defaultValueCombo.setSelectedItem(valueItem);
                        }
                    }
                }
            }
        } else if (source == this.choiceLabelCombo) {
            DataItem dataItem;
            if ((ValueItem)this.choiceLabelCombo.getSelectedItem() == this.noItemsValueItem) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).debug("Data source contains no data items.");
                return;
            }
            ValueItem item = (ValueItem)this.choiceLabelCombo.getSelectedItem();
            if (this.showSortOrderPanel && this.formattedValueValueItem != item && (dataItem = this.getDataItem(this.choiceLabelCombo)) != null && dataItem.getUsage() == DataItemActionType.USAGE_AGGREGATE) {
                this.showMeasureWarning = false;
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                JOptionPane.showOptionDialog(Util.getParentFrame((Component)this), RB.getStringResource("measureDataItem.txt"), RB.getStringResource("information.txt"), -1, 1, null, ERROR_MESSAGE_DIALOG_OPTIONS, ERROR_MESSAGE_DIALOG_OPTIONS[0]);
            }
            String format = "";
            if (null != item && item.getValue() instanceof DataSourceColumnWithFormat) {
                DataSourceColumnWithFormat dscf = (DataSourceColumnWithFormat)item.getValue();
                format = dscf.getFormat();
            }
            if (item == useUnformattedValueItem || item == this.noItemsValueItem) {
                this.clearLabelFormatField(true);
            } else {
                this.setLabelFormatField(format);
                this.getLogger().debug("actionPerformed(),dscf format is:", format);
            }
            if (!this.showSortOrderPanel) {
                this.updateValuePicker();
            } else {
                this.updateSortSelection(item);
            }
            this.formattedValueValueItem = item;
        } else if (source == this.choiceValueCombo) {
            ValueItem selectedUnformattedValue = (ValueItem)this.choiceValueCombo.getSelectedItem();
            if (selectedUnformattedValue == this.noItemsValueItem) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).debug("Data source contains no data items.");
                return;
            }
            if (selectedUnformattedValue != this.unformattedValueValueItem) {
                DataItem dataItem;
                if (this.showSortOrderPanel && (dataItem = this.getDataItem(this.choiceValueCombo)) != null && dataItem.getUsage() == DataItemActionType.USAGE_AGGREGATE) {
                    this.showMeasureWarning = false;
                    this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                    JOptionPane.showOptionDialog(Util.getParentFrame((Component)this), RB.getStringResource("measureDataItem.txt"), RB.getStringResource("information.txt"), -1, 1, null, ERROR_MESSAGE_DIALOG_OPTIONS, ERROR_MESSAGE_DIALOG_OPTIONS[0]);
                }
                this.firePropertyChange("dataItemChanged", Boolean.FALSE, Boolean.TRUE);
                if (this.communicator.hasWhereClause()) {
                    String errMsg = null;
                    String title = null;
                    if (this.valueProvider instanceof PromptColumnValueProvider) {
                        errMsg = RB.getStringResource("dependencyChangeColumnError.txt");
                        title = RB.getStringResource("changeColumn.txt");
                    } else {
                        errMsg = RB.getStringResource("dependencyChangeDataItemError.txt");
                        title = RB.getStringResource("changeDataItem.txt");
                    }
                    this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                    int option = JOptionPane.showOptionDialog(Util.getParentFrame((Component)this), errMsg, title, -1, 2, null, CONFIRM_MESSAGE_DIALOG_OPTIONS, CONFIRM_MESSAGE_DIALOG_OPTIONS[0]);
                    if (option == 1) {
                        this.choiceValueCombo.removeActionListener((ActionListener)this);
                        this.choiceValueCombo.setSelectedItem((Object)this.unformattedValueValueItem);
                    } else {
                        this.clearInvalidValuesFromDefaultValue();
                        this.firePropertyChange("valueProviderUpdateNeeded", Boolean.TRUE, Boolean.FALSE);
                        this.setContentsValid(true);
                    }
                    this.processValueComboChange();
                } else {
                    this.clearInvalidValuesFromDefaultValue();
                    this.firePropertyChange("valueProviderUpdateNeeded", Boolean.TRUE, Boolean.FALSE);
                    this.processValueComboChange();
                }
                this.unformattedValueValueItem = selectedUnformattedValue;
            }
        } else if (source == this.defaultValueButton) {
            this.setContentsValid(true);
            ValueProviderInterface valuePickerProvider = this.createValuePickerValueProvider();
            if (valuePickerProvider != null) {
                String dialogTitle = RB.getStringResource("defaultValueBorder.txt");
                if (!this.showSortOrderPanel) {
                    dialogTitle = RB.getStringResource("listOfChoices.txt");
                }
                JFrame frame = Util.getParentFrame((Component)this);
                ValuePicker valuepicker = new ValuePicker(valuePickerProvider, 403, this.convertSelectionType(this.selectionType), this.allowUserValues, (GenericErrorHandlerInterface)new JOptionPaneErrorHandler((Component)this), DataTypeUtil.getContainedDataType((DataTypeInterface)this.prompt.getPromptDataType()), this.getLocale());
                valuepicker.setRendererHandler((ValuePickerRendererHandler)new ValueRendererHandler(DataTypeUtil.getContainedDataType((DataTypeInterface)this.prompt.getPromptDataType())));
                SupportedSpecialValues supportedSpecialValues = new SupportedSpecialValues();
                supportedSpecialValues.setMissingValuesSupported(this.missingCheckBox.isSelected());
                supportedSpecialValues.setOtherSupported(this.noneCheckBox.isSelected());
                supportedSpecialValues.setAllSupported(this.allCheckBox.isSelected());
                valuepicker.setSupportedSpecialValues(supportedSpecialValues);
                valuepicker.setSourceLabel(RB.getStringResource("availableValues.txt"));
                valuepicker.setTargetLabel(RB.getStringResource("selectedValues.txt"));
                Object o = this.getDefaultValue();
                valuepicker.setValue(o);
                OkEnabledOptionsDialog dialog = new OkEnabledOptionsDialog((Frame)frame, dialogTitle, true);
                dialog.setPanel((PanelInterface)valuepicker);
                dialog.setTitle(dialogTitle);
                dialog.setIgnoreContentsValid(true);
                dialog.pack();
                Util.centerOver((Window)((Object)dialog), (Component)frame);
                dialog.setVisible(true);
                List selectedItems = ((ValuePicker)dialog.getPanel()).getSelectedItems();
                if (!dialog.wasCancelled()) {
                    if (selectedItems != null && selectedItems.size() > 0) {
                        if (this.selectionType != "Single value") {
                            if (selectedItems.size() == 1) {
                                Object item = selectedItems.get(0);
                                if (item == SpecialValues.ALL || item instanceof ValueItem && ((ValueItem)item).getValue() == SpecialValues.ALL) {
                                    for (int i = this.defaultValueModel.getSize() - 1; i >= 0; --i) {
                                        ValueItem valItem = (ValueItem)this.defaultValueModel.getElementAt(i);
                                        if (valItem == this.missingValueItem || !this.shouldRemove(valItem, false)) continue;
                                        this.defaultValueModel.removeElementAt(i);
                                    }
                                    this.defaultValueCombo.setSelectedItem((Object)this.allValueItem);
                                } else if (item instanceof MissingValues || item instanceof ValueItem && ((ValueItem)item).getValue() instanceof MissingValues && (this.missingCheckBox.isSelected() || this.showSortOrderPanel)) {
                                    for (int i = this.defaultValueModel.getSize() - 1; i >= 0; --i) {
                                        ValueItem valItem = (ValueItem)this.defaultValueModel.getElementAt(i);
                                        if (valItem == this.missingValueItem || !this.shouldRemove(valItem, false)) continue;
                                        this.defaultValueModel.removeElementAt(i);
                                    }
                                    this.defaultValueCombo.addItem((Object)this.missingValueItem);
                                    this.defaultValueCombo.setSelectedItem((Object)this.missingValueItem);
                                } else {
                                    ValueItem valueItem = this.getMultipleValueDefaultValue(selectedItems);
                                    if (valueItem != null) {
                                        for (int i = this.defaultValueModel.getSize() - 1; i >= 0; --i) {
                                            ValueItem valItem = (ValueItem)this.defaultValueModel.getElementAt(i);
                                            if (valItem == this.missingValueItem || !this.shouldRemove(valItem, false)) continue;
                                            this.defaultValueModel.removeElementAt(i);
                                        }
                                        this.defaultValueCombo.addItem((Object)valueItem);
                                        this.defaultValueCombo.setSelectedItem((Object)valueItem);
                                    }
                                }
                            } else {
                                ValueItem valueItem = this.getMultipleValueDefaultValue(selectedItems);
                                if (valueItem != null) {
                                    for (int i = this.defaultValueModel.getSize() - 1; i >= 0; --i) {
                                        ValueItem valItem = (ValueItem)this.defaultValueModel.getElementAt(i);
                                        if (valItem == this.missingValueItem || !this.shouldRemove(valItem, false)) continue;
                                        this.defaultValueModel.removeElementAt(i);
                                    }
                                    this.defaultValueCombo.addItem((Object)valueItem);
                                    this.defaultValueCombo.setSelectedItem((Object)valueItem);
                                }
                            }
                        } else {
                            ValueItem defaultValueValueItem;
                            Object obj = selectedItems.get(0);
                            if (obj == SpecialValues.ALL || obj instanceof ValueItem && ((ValueItem)obj).getValue() == SpecialValues.ALL) {
                                defaultValueValueItem = this.allValueItem;
                            } else if (obj instanceof MissingValues || obj instanceof ValueItem && ((ValueItem)obj).getValue() instanceof MissingValues && (this.missingCheckBox.isSelected() || this.showSortOrderPanel)) {
                                defaultValueValueItem = this.missingValueItem;
                            } else if (obj instanceof ValueItem) {
                                if (this.prompt != null && this.prompt.getPromptDataType() instanceof IntegerType) {
                                    if (IntegerType.isInteger((Number)((Number)((ValueItem)obj).getValue()))) {
                                        defaultValueValueItem = (ValueItem)obj;
                                    } else {
                                        defaultValueValueItem = null;
                                        String message = RB.getStringResource("invalidValueForInteger.txt");
                                        if (this.getGenericErrorHandler() != null) {
                                            this.getGenericErrorHandler().handleError((Object)Util.getParentFrame((Component)this), new Message(message), null);
                                        }
                                        this.getLogger().error(message);
                                    }
                                } else {
                                    defaultValueValueItem = (ValueItem)obj;
                                }
                            } else {
                                defaultValueValueItem = new ValueItem(null, obj);
                            }
                            if (defaultValueValueItem != null) {
                                for (int i = this.defaultValueModel.getSize() - 1; i >= 0; --i) {
                                    ValueItem valueItem = (ValueItem)this.defaultValueModel.getElementAt(i);
                                    if (valueItem == this.missingValueItem || !this.shouldRemove(valueItem, false)) continue;
                                    this.defaultValueModel.removeElementAt(i);
                                }
                                if (defaultValueValueItem != this.allValueItem && defaultValueValueItem != this.otherValueItem) {
                                    this.defaultValueCombo.addItem((Object)defaultValueValueItem);
                                }
                                this.defaultValueCombo.setSelectedItem((Object)defaultValueValueItem);
                            }
                        }
                    } else {
                        DefaultComboBoxModel<ValueItem> newModel = new DefaultComboBoxModel<ValueItem>();
                        int listSize = this.defaultValueModel.getSize();
                        for (int i = 0; i < listSize; ++i) {
                            ValueItem valueItem = (ValueItem)this.defaultValueModel.getElementAt(i);
                            if (valueItem != this.missingValueItem && valueItem != this.allValueItem && valueItem != this.otherValueItem && valueItem != this.noneValueItem) continue;
                            newModel.addElement(valueItem);
                        }
                        this.defaultValueModel.removeAllElements();
                        int comboSize = newModel.getSize();
                        for (int i = 0; i < comboSize; ++i) {
                            this.defaultValueModel.addElement(newModel.getElementAt(i));
                        }
                        this.defaultValueCombo.setSelectedItem((Object)this.noneValueItem);
                    }
                    this.setContentsValid(true);
                }
            }
        }
    }

    private boolean shouldRemove(ValueItem valueItem, boolean shouldCoerce) {
        if (valueItem == this.noneValueItem) {
            return false;
        }
        if (valueItem == this.missingValueItem) {
            return false;
        }
        Object value = valueItem.getValue();
        if (value == SpecialValues.ALL) {
            return false;
        }
        if (value == SpecialValues.OTHER) {
            return false;
        }
        if (this.prompt == null) {
            return true;
        }
        if (!shouldCoerce) {
            return true;
        }
        DataTypeInterface dataType = this.prompt.getPromptDataType();
        if (dataType != null) {
            try {
                dataType.coerceValue(value, this.getLocale());
                return false;
            }
            catch (IllegalArgumentException e) {
                return true;
            }
        }
        return false;
    }

    private void processValueComboChange() {
        if (!this.showSortOrderPanel) {
            this.updateValuePicker();
        }
        this.setContentsValid(true);
    }

    private ValueProviderInterface createValuePickerValueProvider() {
        RelationalDataItemValueProvider valuePickerProvider = null;
        String labelFormat = null;
        if (this.dataSourceType == 4L) {
            DataItem valueDataItem = this.getDataItem(this.choiceValueCombo);
            valuePickerProvider = new RelationalDataItemValueProvider(valueDataItem);
            if (this.choiceLabelCombo.getSelectedItem() == useUnformattedValueItem) {
                valuePickerProvider.setValueDisplayed(false);
                String format = DataTypeUtil.getDefaultPatternNameForDataType((DataTypeInterface)this.getDataType(this.promptType));
                if (format != null && format.length() > 0) {
                    valuePickerProvider.setLabelDataItem(valueDataItem);
                    valuePickerProvider.setFormattedLabels(true);
                    valuePickerProvider.setLabelFormatString(format);
                    valuePickerProvider.setTrimLabels(true);
                }
            } else {
                DataItem labelDataItem = this.getDataItem(this.choiceLabelCombo);
                valuePickerProvider.setLabelDataItem(labelDataItem);
                valuePickerProvider.setValueDisplayed(true);
                labelFormat = this.getCurrentLabelFormat();
                if (labelFormat != null && labelFormat.trim().length() > 0) {
                    if (labelFormat != null && labelFormat.startsWith(ColumnInfo.DEFAULT_FORMAT) && (labelFormat = labelFormat.substring(ColumnInfo.DEFAULT_FORMAT.length() + 1)) != null && labelFormat.trim().length() == 0) {
                        labelFormat = RB.getStringResource("none.txt");
                    }
                    valuePickerProvider.setFormattedLabels(true);
                    valuePickerProvider.setLabelFormatString(labelFormat);
                }
            }
            if (this.showSortOrderPanel) {
                valuePickerProvider.setFormattedLabels(true);
                this.setSortOrderForInfoMap(valuePickerProvider);
            }
        } else if (this.dataSourceType == 1L) {
            PromptColumnValueProvider defaultValueColumnValueProvider = new PromptColumnValueProvider(this.url);
            defaultValueColumnValueProvider.setValueDisplayed(true);
            defaultValueColumnValueProvider.setDistinct(this.distinctCheckBox.isSelected());
            ValueItem valueValueItem = (ValueItem)this.choiceValueCombo.getSelectedItem();
            if (valueValueItem == this.noItemsValueItem) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).debug("Data source contains no data items.");
                this.errors = RB.getStringResource("noDataItemsSelectMap.txt", this.getLocale());
                return null;
            }
            String valueColumnName = ((DataSourceColumnInterface)valueValueItem.getValue()).getColumnName();
            ColumnInfo valueColumn = new ColumnInfo(valueColumnName);
            defaultValueColumnValueProvider.setValueColumn(valueColumn);
            ValueItem labelValueItem = (ValueItem)this.choiceLabelCombo.getSelectedItem();
            if (labelValueItem == this.noItemsValueItem) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).debug("Data source contains no data items.");
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)PromptUtility.getParentFrame(this.communicator, this), new Message(RB.getStringResource("noDataItemsSelectMap.txt")), null);
                }
                this.setContentsValid(false);
                return null;
            }
            if (labelValueItem == useUnformattedValueItem) {
                defaultValueColumnValueProvider.setValueDisplayed(false);
                defaultValueColumnValueProvider.setFormatLabels(false);
                String format = DataTypeUtil.getDefaultPatternNameForDataType((DataTypeInterface)this.getDataType(this.promptType));
                if (format != null && format.length() > 0) {
                    ColumnInfo labelColumn = new ColumnInfo(valueColumnName);
                    labelColumn.setFormat(format);
                    defaultValueColumnValueProvider.setLabelColumn(labelColumn);
                    defaultValueColumnValueProvider.setFormatLabels(true);
                    defaultValueColumnValueProvider.setTrimLabels(true);
                    if (this.showSortOrderPanel) {
                        this.setSortOrderForTable(defaultValueColumnValueProvider, labelColumn, valueColumn);
                    }
                } else if (this.showSortOrderPanel) {
                    ColumnInfo labelColumn = new ColumnInfo(valueColumnName);
                    this.setSortOrderForTable(defaultValueColumnValueProvider, labelColumn, valueColumn);
                }
            } else {
                String labelColumnName = ((DataSourceColumnInterface)labelValueItem.getValue()).getColumnName();
                ColumnInfo labelColumn = new ColumnInfo(labelColumnName);
                defaultValueColumnValueProvider.setLabelColumn(labelColumn);
                labelFormat = this.getCurrentLabelFormat();
                if (labelFormat != null && labelFormat.trim().length() > 0) {
                    labelColumn.setFormat(labelFormat);
                } else {
                    labelColumn.setFormat(ColumnInfo.DEFAULT_FORMAT);
                }
                if (this.showSortOrderPanel) {
                    this.setSortOrderForTable(defaultValueColumnValueProvider, labelColumn, valueColumn);
                }
            }
            valuePickerProvider = defaultValueColumnValueProvider;
        }
        if (!this.showSortOrderPanel) {
            if (valuePickerProvider instanceof RelationalDataItemValueProvider) {
                valuePickerProvider.setRemoveMissingValues(true);
            } else if (valuePickerProvider instanceof ColumnValueProvider) {
                ((ColumnValueProvider)valuePickerProvider).setRemoveMissingValues(true);
            }
        }
        PromptValues promptValues = new PromptValues((PromptGroupInterface)new PromptGroup(), null);
        DynamicPromptValueContext dynamicPromptContext = new DynamicPromptValueContext((PromptValuesInterface)promptValues, null, null, (DataProviderInterface)this.dataProvider);
        valuePickerProvider = new PromptDynamicValueProviderWrapper((ValueProviderInterface)valuePickerProvider, (DynamicPromptValueContextInterface)dynamicPromptContext);
        return valuePickerProvider;
    }

    private String getCurrentLabelFormat() {
        return this.currentLabelFormat;
    }

    private void clearLabelFormatField(boolean disable) {
        this.defaultLabelFormat = true;
        this.currentLabelFormat = "";
        this.choiceLabelFormatField.setText("");
        this.choiceLabelFormatField.setEnabled(!disable);
        this.choiceLabelFormatButton.setEnabled(!disable);
    }

    private void setLabelFormatField(String format) {
        DataSourceColumnWithFormat dscf;
        String loadedFormat;
        ValueItem item;
        this.defaultLabelFormat = false;
        this.currentLabelFormat = format;
        this.choiceLabelFormatField.setEnabled(true);
        this.choiceLabelFormatButton.setEnabled(true);
        if (format != null && format.startsWith(ColumnInfo.DEFAULT_FORMAT)) {
            this.defaultLabelFormat = true;
            this.currentLabelFormat = "";
            this.currentLabelFormat = format = format.substring(ColumnInfo.DEFAULT_FORMAT.length());
        }
        if ((format == null || format.trim().length() == 0) && this.choiceLabelCombo != null && null != (item = (ValueItem)this.choiceLabelCombo.getSelectedItem()) && item.getValue() instanceof DataSourceColumnWithFormat && (loadedFormat = (dscf = (DataSourceColumnWithFormat)item.getValue()).getFormat()) != null && loadedFormat.startsWith(ColumnInfo.DEFAULT_FORMAT)) {
            this.defaultLabelFormat = true;
            this.currentLabelFormat = "";
            this.currentLabelFormat = format = loadedFormat.substring(ColumnInfo.DEFAULT_FORMAT.length());
        }
        if (format == null || format.trim().length() == 0) {
            format = RB.getStringResource("none.txt");
        }
        if (this.defaultLabelFormat) {
            this.choiceLabelFormatField.setText(Message.format((String)RB.getStringResource("defaultFormat.fmt.txt"), (Object)format));
        } else {
            this.choiceLabelFormatField.setText(format);
        }
    }

    private boolean isSortSet(String sortFirst, String sortOrder) {
        return sortFirst != null && sortFirst.trim().length() > 0 && sortFirst != "SortNone" && sortOrder != null && sortOrder.trim().length() > 0 && sortOrder != "SortNone";
    }

    private int convertSelectionType(String selectionType) {
        if (selectionType == "Multiple values") {
            return 302;
        }
        if (selectionType.equals("Multiple ordered values")) {
            return 302;
        }
        return 300;
    }

    private void toggleButtonsEnabled(boolean enabled) {
        this.choiceLabelFormatButton.setEnabled(enabled);
        if (this.showSortOrderPanel) {
            this.defaultValueButton.setEnabled(enabled);
        }
    }

    private void updateSortSelection(ValueItem valueItem) {
        String selectedItem = (String)this.sortOrderCombo.getSelectedItem();
        if (valueItem == useUnformattedValueItem) {
            this.sortOrderModel.removeElement(this.ASCENDING_FORMATTED_SORT_ORDER);
            this.sortOrderModel.removeElement(this.DESCENDING_FORMATTED_SORT_ORDER);
            this.sortOrderCombo.setSelectedItem((Object)this.DEFAULT_SORT_ORDER);
        } else if (this.sortOrderModel.getIndexOf(this.ASCENDING_FORMATTED_SORT_ORDER) == -1) {
            this.sortOrderModel.removeAllElements();
            this.sortOrderModel.addElement(this.DEFAULT_SORT_ORDER);
            this.sortOrderModel.addElement(this.ASCENDING_FORMATTED_SORT_ORDER);
            this.sortOrderModel.addElement(this.DESCENDING_FORMATTED_SORT_ORDER);
            this.sortOrderModel.addElement(this.ASCENDING_UNFORMATTED_SORT_ORDER);
            this.sortOrderModel.addElement(this.DESCENDING_UNFORMATTED_SORT_ORDER);
            this.sortOrderCombo.setSelectedItem((Object)selectedItem);
        }
    }

    private void updateValuePicker() {
        ValueProviderInterface valuePickerProvider = this.createValuePickerValueProvider();
        DataTypeInterface dataType = this.getDataType(this.promptType);
        List selectedItems = null;
        if (this.valuePicker != null) {
            selectedItems = this.valuePicker.getSelectedItems();
        }
        this.valuePicker = new ValuePicker(valuePickerProvider, 403, 302, false, null, dataType, 100, this.getLocale());
        this.valuePicker.setRendererHandler((ValuePickerRendererHandler)new ValueRendererHandler(this.getDataType(this.promptType)));
        this.valuePicker.setSourceLabel(RB.getStringResource("availableValues.txt"));
        this.valuePicker.setTargetLabel(RB.getStringResource("selectedValues.txt"));
        if (this.valuePicker != null && selectedItems != null) {
            ValueListEditor vle = (ValueListEditor)this.valuePicker.getTargetComponent();
            vle.addItems((Collection)selectedItems);
        }
        MutableTableColumnsInterface tm = (MutableTableColumnsInterface)this.valuePicker.getTargetModel();
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("VALUE");
        columns.add("LABEL");
        tm.setColumnName(RB.getStringResource("choiceValues.txt"), 0);
        tm.setColumnName(RB.getStringResource("choiceLabels.txt"), 1);
        tm.setColumns(columns);
        ((ValueListEditor)this.valuePicker.getTargetComponent()).getTable().setColumnHeaderVisible(true);
        this.outerChoicePanel.removeAll();
        this.outerChoicePanel.add((Component)this.valuePicker);
        this.updateUI();
    }

    private DataItem getDataItem(ComboBox combo) {
        DataItem dataItem = null;
        if (combo != null && combo.getSelectedItem() instanceof ValueItem) {
            try {
                DataSourceColumnInterface column;
                ValueItem valueItem = (ValueItem)combo.getSelectedItem();
                if (valueItem == this.noItemsValueItem) {
                    return null;
                }
                if (valueItem == useUnformattedValueItem) {
                    valueItem = this.unformattedValueValueItem;
                }
                if (valueItem != null && (column = (DataSourceColumnInterface)valueItem.getValue()).getDataSource().getDataSourceType() == 4L) {
                    dataItem = ((DataProvider)this.dataProvider).getDataItemFromId(this.url, column.getColumnName());
                }
            }
            catch (ServerConnectionException sce) {
                this.getLogger().error(sce.getMessage(), (Throwable)sce);
            }
            return dataItem;
        }
        return dataItem;
    }

    private int getSQLTypeForColumn(ComboBox columnCombo) {
        DataItem dataItem = null;
        if (columnCombo != null && columnCombo.getSelectedItem() instanceof ValueItem) {
            try {
                ValueItem valueItem = (ValueItem)columnCombo.getSelectedItem();
                if (valueItem == useUnformattedValueItem) {
                    valueItem = this.unformattedValueValueItem;
                }
                if (valueItem != null && valueItem.getValue() instanceof DataSourceColumnInterface) {
                    DataSourceColumnInterface column = (DataSourceColumnInterface)valueItem.getValue();
                    if (column.getDataSource().getDataSourceType() == 4L) {
                        dataItem = ((DataProvider)this.dataProvider).getDataItemFromId(this.url, column.getColumnName());
                        return PromptUtility.getSQLType(dataItem);
                    }
                    return PromptUtility.getSQLType(column.getColumnType());
                }
            }
            catch (ServerConnectionException sce) {
                this.getLogger().error(sce.getMessage(), (Throwable)sce);
            }
        }
        return PromptUtility.getSQLType(dataItem);
    }

    private void clearInvalidValuesFromDefaultValue() {
        if (this.showSortOrderPanel) {
            ValueItem selectedItem = (ValueItem)this.defaultValueCombo.getSelectedItem();
            for (int i = this.defaultValueModel.getSize() - 1; i >= 0; --i) {
                ValueItem valueItem = (ValueItem)this.defaultValueModel.getElementAt(i);
                if (!this.shouldRemove(valueItem, false)) continue;
                this.defaultValueModel.removeElementAt(i);
            }
            Object value = selectedItem.getValue();
            if (value == SpecialValues.ALL) {
                this.defaultValueCombo.setSelectedItem((Object)this.allValueItem);
            } else if (value == SpecialValues.OTHER) {
                this.defaultValueCombo.setSelectedItem((Object)this.otherValueItem);
            } else if (value instanceof MissingValues) {
                this.defaultValueCombo.setSelectedItem((Object)this.missingValueItem);
            } else {
                this.defaultValueCombo.setSelectedItem((Object)this.noneValueItem);
            }
        }
    }

    @Override
    public List getSelectedItems() {
        List returnItems = null;
        if (this.valuePicker != null) {
            returnItems = this.valuePicker.getSelectedItems();
        }
        DataTypeInterface dataType = this.getDataType(this.promptType);
        boolean dataTypeIsInteger = dataType instanceof IntegerType;
        if (returnItems == null) {
            return new ArrayList();
        }
        return returnItems;
    }

    public boolean isValidValues(String promptType) {
        boolean isValidValues = true;
        DataTypeInterface dataType = this.getDataType(promptType);
        if (dataType != null) {
            List items = this.getSelectedItems();
            for (Object value : items) {
                try {
                    dataType.coerceValue(value, this.getLocale());
                }
                catch (IllegalArgumentException e) {
                    isValidValues = false;
                    break;
                }
            }
            if (!isValidValues) {
                String errMsg = Message.format((String)RB.getStringResource("invalidValueForPromptType.fmt.txt"), (Object)this.getDataTypeLabel(promptType));
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)Util.getParentFrame((Component)this), new Message(errMsg), null);
                }
            }
        }
        return isValidValues;
    }

    private String getDataTypeLabel(String promptType) {
        String label = "";
        if (promptType == null) {
            return label;
        }
        if (promptType.equals("Text")) {
            label = RB.getStringResource("text.txt");
        } else if (promptType.equals("Integer")) {
            label = RB.getStringResource("numericInteger.txt");
        } else if (promptType.equals("Numeric")) {
            label = RB.getStringResource("numericDouble.txt");
        } else if (promptType.equals("Time")) {
            label = RB.getStringResource("time.txt");
        } else if (promptType.equals("Timestamp")) {
            label = RB.getStringResource("timestamp.txt");
        } else if (promptType.equals("Date") || promptType.equals(PromptPanelConstantsInterface.DAY) || promptType.equals(PromptPanelConstantsInterface.WEEK) || promptType.equals(PromptPanelConstantsInterface.MONTH) || promptType.equals(PromptPanelConstantsInterface.QUARTER) || promptType.equals(PromptPanelConstantsInterface.YEAR)) {
            label = RB.getStringResource("date.txt");
        }
        return label;
    }

    private String getDataTypeLabel(PromptDefinitionInterface dataType) {
        String label = "";
        if (this.prompt == null) {
            return label;
        }
        if (this.prompt instanceof TextDefinitionInterface) {
            label = RB.getStringResource("text.txt");
        } else if (this.prompt instanceof IntegerDefinitionInterface) {
            label = RB.getStringResource("numericInteger.txt");
        } else if (this.prompt instanceof DoubleDefinitionInterface) {
            label = RB.getStringResource("numericDouble.txt");
        } else if (this.prompt instanceof DateDefinitionInterface) {
            label = RB.getStringResource("date.txt");
        }
        return label;
    }

    private DataTypeInterface getDataType(String promptType) {
        StringType dataType = null;
        if (promptType != null) {
            if (promptType.equals("Text")) {
                dataType = StringType.DEFAULT_INSTANCE;
            } else if (promptType.equals("Integer")) {
                dataType = IntegerType.DEFAULT_INSTANCE;
            } else if (promptType.equals("Numeric")) {
                dataType = DoubleType.DEFAULT_INSTANCE;
            } else if (promptType.equals("Date")) {
                dataType = DateType.DEFAULT_INSTANCE;
            } else if (promptType.equals("Time")) {
                dataType = TimeType.DEFAULT_INSTANCE;
            } else if (promptType.equals("Timestamp")) {
                dataType = TimeStampType.DEFAULT_INSTANCE;
            } else if (promptType.equals("Date")) {
                dataType = WeekdayType.DEFAULT_INSTANCE;
            } else if (promptType.equals("Week")) {
                dataType = WeekType.DEFAULT_INSTANCE;
            } else if (promptType.equals("Month")) {
                dataType = MonthType.DEFAULT_INSTANCE;
            } else if (promptType.equals("Quarter")) {
                dataType = QuarterType.DEFAULT_INSTANCE;
            } else if (promptType.equals("Year")) {
                dataType = YearType.DEFAULT_INSTANCE;
            }
        }
        return dataType;
    }

    void setSortOrderForInfoMap(RelationalDataItemValueProvider promptRelationalDataItemValueProvider) {
        String selectedItem = (String)this.sortOrderCombo.getSelectedItem();
        if (this.ASCENDING_FORMATTED_SORT_ORDER.equals(selectedItem) || this.ASCENDING_UNFORMATTED_SORT_ORDER.equals(selectedItem)) {
            if (this.ASCENDING_FORMATTED_SORT_ORDER.equals(selectedItem)) {
                promptRelationalDataItemValueProvider.setSortFirst("Label_Value");
            } else {
                promptRelationalDataItemValueProvider.setSortFirst("Value_Label");
            }
            promptRelationalDataItemValueProvider.setSortOrder("Ascending");
        } else if (this.DESCENDING_FORMATTED_SORT_ORDER.equals(selectedItem) || this.DESCENDING_UNFORMATTED_SORT_ORDER.equals(selectedItem)) {
            if (this.DESCENDING_FORMATTED_SORT_ORDER.equals(selectedItem)) {
                promptRelationalDataItemValueProvider.setSortFirst("Label_Value");
            } else {
                promptRelationalDataItemValueProvider.setSortFirst("Value_Label");
            }
            promptRelationalDataItemValueProvider.setSortOrder("Descending");
        } else {
            promptRelationalDataItemValueProvider.setSortFirst("None");
        }
    }

    void setSortOrderForTable(PromptColumnValueProvider promptColumnValueProvider, ColumnInfo labelColumn, ColumnInfo valueColumn) {
        String selectedItem = (String)this.sortOrderCombo.getSelectedItem();
        if (this.ASCENDING_FORMATTED_SORT_ORDER.equals(selectedItem) || this.ASCENDING_UNFORMATTED_SORT_ORDER.equals(selectedItem)) {
            if (this.ASCENDING_FORMATTED_SORT_ORDER.equals(selectedItem)) {
                promptColumnValueProvider.setSortFirst("SortLabel");
                labelColumn.setSortOrder("ASCENDING");
            } else {
                promptColumnValueProvider.setSortFirst("SortValue");
                valueColumn.setSortOrder("ASCENDING");
            }
        } else if (this.DESCENDING_FORMATTED_SORT_ORDER.equals(selectedItem) || this.DESCENDING_UNFORMATTED_SORT_ORDER.equals(selectedItem)) {
            if (this.DESCENDING_FORMATTED_SORT_ORDER.equals(selectedItem)) {
                promptColumnValueProvider.setSortFirst("SortLabel");
                labelColumn.setSortOrder("DESCENDING");
            } else {
                promptColumnValueProvider.setSortFirst("SortValue");
                valueColumn.setSortOrder("DESCENDING");
            }
        } else {
            promptColumnValueProvider.setSortFirst("SortNone");
        }
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        block45: {
            try {
                ValueItem valueItem;
                this.setContentsValid(true);
                if (this.dataSourceType == 4L) {
                    RelationalDataItemValueProvider promptRelationalDataItemValueProvider = null;
                    ValueItem valueValueItem = (ValueItem)this.choiceValueCombo.getSelectedItem();
                    if (valueValueItem == this.noItemsValueItem && !suppressErrors) {
                        this.getLogger().debug("Unknown type of data source or none selected.");
                        this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                        if (this.getGenericErrorHandler() != null) {
                            this.getGenericErrorHandler().handleError((Object)Util.getParentFrame((Component)this), new Message(RB.getStringResource("noDataItemsSelectMap.txt")), null);
                        }
                        this.setContentsValid(false);
                        return this.prompt;
                    }
                    try {
                        String labelFormat;
                        DataItem labelDataItem;
                        DataItem dataItem = ((DataProvider)this.dataProvider).getDataItemFromId(this.url, ((DataSourceColumnInterface)valueValueItem.getValue()).getColumnName());
                        promptRelationalDataItemValueProvider = new RelationalDataItemValueProvider(dataItem);
                        ValueItem labelValueItem = (ValueItem)this.choiceLabelCombo.getSelectedItem();
                        if (this.choiceLabelCombo.getSelectedItem() == useUnformattedValueItem) {
                            labelDataItem = dataItem;
                        } else {
                            labelDataItem = ((DataProvider)this.dataProvider).getDataItemFromId(this.url, ((DataSourceColumnInterface)labelValueItem.getValue()).getColumnName());
                            promptRelationalDataItemValueProvider.setLabelDataItem(labelDataItem);
                        }
                        promptRelationalDataItemValueProvider.setFormattedLabels(true);
                        if (this.showSortOrderPanel && !suppressErrors) {
                            if (dataItem != null && dataItem.getUsage() == DataItemActionType.USAGE_AGGREGATE) {
                                if (this.showMeasureWarning) {
                                    this.showMeasureWarning = false;
                                    this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                                    JOptionPane.showOptionDialog(Util.getParentFrame((Component)this), RB.getStringResource("measureDataItem.txt"), RB.getStringResource("information.txt"), -1, 1, null, ERROR_MESSAGE_DIALOG_OPTIONS, ERROR_MESSAGE_DIALOG_OPTIONS[0]);
                                    this.setContentsValid(false);
                                } else {
                                    this.setContentsValid(true);
                                }
                            } else if (labelDataItem != null && labelDataItem.getUsage() == DataItemActionType.USAGE_AGGREGATE) {
                                if (this.showMeasureWarning) {
                                    this.showMeasureWarning = false;
                                    this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                                    JOptionPane.showOptionDialog(Util.getParentFrame((Component)this), RB.getStringResource("measureDataItem.txt"), RB.getStringResource("information.txt"), -1, 1, null, ERROR_MESSAGE_DIALOG_OPTIONS, ERROR_MESSAGE_DIALOG_OPTIONS[0]);
                                    this.setContentsValid(false);
                                } else {
                                    this.setContentsValid(true);
                                }
                            }
                        }
                        if ((labelFormat = this.getCurrentLabelFormat()) != null && labelFormat.trim().length() > 0) {
                            promptRelationalDataItemValueProvider.setLabelFormatString(labelFormat);
                        }
                        if (this.showSortOrderPanel) {
                            this.setSortOrderForInfoMap(promptRelationalDataItemValueProvider);
                            promptRelationalDataItemValueProvider.setValueDisplayed(this.appendCheckBox.isSelected());
                        }
                        ((MutableValueProviderDefinitionInterface)this.prompt).setValueProvider((ValueProviderInterface)promptRelationalDataItemValueProvider);
                    }
                    catch (ServerConnectionException e) {
                        this.getLogger().error(e.getMessage());
                    }
                } else if (this.dataSourceType == 1L) {
                    PromptColumnValueProvider promptColumnValueProvider = new PromptColumnValueProvider(this.url);
                    promptColumnValueProvider.setDistinct(this.distinctCheckBox.isSelected());
                    ValueItem valueValueItem = (ValueItem)this.choiceValueCombo.getSelectedItem();
                    if (valueValueItem == this.noItemsValueItem && !suppressErrors) {
                        this.getLogger().debug("Unknown type of data source or none selected.");
                        this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                        if (this.getGenericErrorHandler() != null) {
                            this.getGenericErrorHandler().handleError((Object)Util.getParentFrame((Component)this), new Message(RB.getStringResource("noDataItemsSelectMap.txt")), null);
                        }
                        this.setContentsValid(false);
                        return this.prompt;
                    }
                    String valueColumnName = ((DataSourceColumnInterface)valueValueItem.getValue()).getColumnName();
                    ColumnInfo valueColumn = new ColumnInfo(valueColumnName);
                    promptColumnValueProvider.setValueColumn(valueColumn);
                    ValueItem labelValueItem = (ValueItem)this.choiceLabelCombo.getSelectedItem();
                    String labelColumnName = labelValueItem == useUnformattedValueItem ? valueColumnName : ((DataSourceColumnInterface)labelValueItem.getValue()).getColumnName();
                    ColumnInfo labelColumn = new ColumnInfo(labelColumnName);
                    String labelFormat = this.getCurrentLabelFormat();
                    if (labelFormat != null && labelFormat.trim().length() > 0) {
                        labelColumn.setFormat(labelFormat);
                    } else {
                        labelColumn.setFormat(ColumnInfo.DEFAULT_FORMAT);
                    }
                    if (labelValueItem != useUnformattedValueItem) {
                        promptColumnValueProvider.setLabelColumn(labelColumn);
                    }
                    if (this.showSortOrderPanel) {
                        this.setSortOrderForTable(promptColumnValueProvider, labelColumn, valueColumn);
                        promptColumnValueProvider.setValueDisplayed(this.appendCheckBox.isSelected());
                    }
                    ((MutableValueProviderDefinitionInterface)this.prompt).setValueProvider((ValueProviderInterface)promptColumnValueProvider);
                } else if (this.dataSourceType == 0L) {
                    if (!suppressErrors) {
                        this.getLogger().debug("Unknown type of data source or none selected.");
                        this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                        if (this.getGenericErrorHandler() != null) {
                            this.getGenericErrorHandler().handleError((Object)Util.getParentFrame((Component)this), new Message(RB.getStringResource("noDataSource.txt")), null);
                        }
                        this.setContentsValid(false);
                        return this.prompt;
                    }
                } else if (!suppressErrors) {
                    this.getLogger().debug("Unknown type of data source or none selected.");
                    this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                    if (this.getGenericErrorHandler() != null) {
                        this.getGenericErrorHandler().handleError((Object)Util.getParentFrame((Component)this), new Message(RB.getStringResource("errorCreatingValueProvider.txt")), null);
                    }
                    this.setContentsValid(false);
                }
                if (this.prompt instanceof MutableSupportedSpecialValuesInterface) {
                    SupportedSpecialValues supportedSpecialValues = new SupportedSpecialValues();
                    supportedSpecialValues.setAllSupported(this.allCheckBox.isSelected());
                    supportedSpecialValues.setOtherSupported(this.noneCheckBox.isSelected());
                    supportedSpecialValues.setMissingValuesSupported(this.missingCheckBox.isSelected());
                    ((MutableSupportedSpecialValuesInterface)this.prompt).setSupportedSpecialValues(supportedSpecialValues);
                }
                if (this.selectionType != "Single value" && this.defaultValues != null) {
                    ((MutableSelectableDefinitionInterface)this.prompt).setMaximumValueCount(Integer.MAX_VALUE);
                }
                if ((valueItem = (ValueItem)this.defaultValueCombo.getSelectedItem()) != null && valueItem != this.noneValueItem) {
                    ((MutableSelectableDefinitionInterface)this.prompt).setDefaultValue(valueItem.getValue());
                } else {
                    ((MutableSelectableDefinitionInterface)this.prompt).clearDefaultValue();
                }
            }
            catch (IllegalArgumentException iae) {
                if (!suppressErrors) {
                    this.getLogger().debug(iae.getMessage());
                    String errMsg = Message.format((String)RB.getStringResource("invalidDefaultValue.fmt.txt"), (Object)this.getDataTypeLabel(this.prompt));
                    this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                    if (this.getGenericErrorHandler() != null) {
                        this.getGenericErrorHandler().handleError((Object)Util.getParentFrame((Component)this), new Message(errMsg), null);
                    }
                    this.setContentsValid(false);
                }
            }
            catch (Exception e) {
                if (suppressErrors) break block45;
                this.getLogger().error(e.getMessage());
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)Util.getParentFrame((Component)this), new Message(RB.getStringResource("errorCreatingValueProvider.txt")), null);
                }
                this.setContentsValid(false);
            }
        }
        try {
            if (!this.userDefinedDataProvider) {
                ((DataProvider)this.dataProvider).close();
            }
        }
        catch (ServerConnectionException sce) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).debug(sce.getMessage(), (Throwable)sce);
        }
        return this.prompt;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.getPromptDefinition(false);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.allCheckBox) {
            int allTextPosition = this.defaultValueModel.getIndexOf(this.allValueItem);
            if (e.getStateChange() == 1 && allTextPosition == -1) {
                this.defaultValueModel.addElement(PromptUtility.newAllSpecialValuesValueItem(this.getLocale()));
            } else if (e.getStateChange() == 2 && allTextPosition != -1) {
                ValueItem selectedItem = (ValueItem)this.defaultValueCombo.getSelectedItem();
                this.defaultValueModel.removeElement(this.allValueItem);
                if (selectedItem.getValue() == SpecialValues.ALL) {
                    this.defaultValueCombo.setSelectedItem((Object)this.noneValueItem);
                }
            }
        } else if (e.getSource() == this.noneCheckBox) {
            int otherTextPosition = this.defaultValueModel.getIndexOf(this.otherValueItem);
            if (e.getStateChange() == 1 && otherTextPosition == -1) {
                this.defaultValueModel.addElement(PromptUtility.newOtherSpecialValuesValueItem(this.getLocale()));
            } else if (e.getStateChange() == 2 && otherTextPosition != -1) {
                ValueItem selectedItem = (ValueItem)this.defaultValueCombo.getSelectedItem();
                this.defaultValueModel.removeElement(this.otherValueItem);
                if (selectedItem.getValue() == SpecialValues.OTHER) {
                    this.defaultValueCombo.setSelectedItem((Object)this.noneValueItem);
                }
            }
        } else if (e.getSource() == this.missingCheckBox) {
            int missingTextPosition = this.defaultValueModel.getIndexOf(this.missingValueItem);
            if (e.getStateChange() == 1 && missingTextPosition == -1) {
                this.defaultValueModel.addElement(this.missingValueItem);
            } else if (e.getStateChange() == 2 && missingTextPosition != -1) {
                ValueItem selectedItem = (ValueItem)this.defaultValueCombo.getSelectedItem();
                this.defaultValueModel.removeElement(this.missingValueItem);
                if (selectedItem == this.missingValueItem) {
                    this.defaultValueCombo.setSelectedItem((Object)this.noneValueItem);
                }
            }
        }
    }

    private Object getDefaultValue() {
        ValueItem valueItem = (ValueItem)this.defaultValueCombo.getSelectedItem();
        if (valueItem == this.noneValueItem) {
            return null;
        }
        return valueItem.getValue();
    }

    private ValueItem getMultipleValueDefaultValue(List defaultValueList) {
        ArrayList<Object> valuesList = new ArrayList<Object>();
        ArrayList<String> labelsList = new ArrayList<String>();
        for (Object obj : defaultValueList) {
            if (obj instanceof ValueItem) {
                ValueItem valueItem = (ValueItem)obj;
                Object value = valueItem.getValue();
                if (value instanceof MissingValues) {
                    valuesList.add(this.missingValueItem.getValue());
                    labelsList.add(this.missingValueItem.getLabel());
                    continue;
                }
                if (this.prompt != null && this.prompt.getPromptDataType().equals(CollectionType.DEFAULT_INSTANCE_INTEGER) && !IntegerType.isInteger((Number)((Number)value))) {
                    String message = RB.getStringResource("invalidValueForInteger.txt");
                    if (this.getGenericErrorHandler() != null) {
                        this.getGenericErrorHandler().handleError((Object)Util.getParentFrame((Component)this), new Message(message), null);
                    }
                    this.getLogger().error(message);
                    break;
                }
                valuesList.add(value);
                labelsList.add(valueItem.getLabel());
                continue;
            }
            if (obj instanceof MissingValues) {
                valuesList.add(this.missingValueItem.getValue());
                labelsList.add(this.missingValueItem.getLabel());
                continue;
            }
            if (obj == SpecialValues.ALL || obj == SpecialValues.OTHER) continue;
            ArrayList list = new ArrayList();
            list.add(obj);
            labelsList.add(this.prompt.getPromptDataType().getValueAsString(list, this.getLocale()));
            valuesList.add(obj);
        }
        StringBuffer sb = new StringBuffer();
        int listSize = labelsList.size();
        for (int i = 0; i < listSize; ++i) {
            String label = (String)labelsList.get(i);
            if (label != null) {
                sb.append(label);
            }
            if (i == listSize - 1) continue;
            sb.append(";");
        }
        if (valuesList.size() > 0) {
            ValueItem valueItem = new ValueItem((Object)sb.toString(), valuesList);
            return valueItem;
        }
        return null;
    }

    public void setAllowUserValues(boolean allowUserValues) {
        this.allowUserValues = allowUserValues;
        if (!this.allowUserValues) {
            this.missingCheckBox.setSelected(false);
        }
        this.missingCheckBox.setVisible(allowUserValues);
    }

    public String getErrorMessage() {
        return this.errors;
    }

    public SASJavaHelp getJavaHelp() {
        if (this.communicator != null && this.communicator.getJavaHelp() != null) {
            return this.communicator.getJavaHelp();
        }
        try {
            if (this.javaHelp == null) {
                this.javaHelp = new SASJavaHelp(this.getHelpDocProduct(), this.getLocale());
            }
            if (this.communicator != null) {
                this.communicator.setJavaHelp(this.javaHelp);
            }
        }
        catch (Error e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
        return this.javaHelp;
    }

    public void setJavaHelp(SASJavaHelp javaHelp) {
        this.javaHelp = javaHelp;
    }

    public String getHelpDocProduct() {
        if (this.helpDocProduct != null) {
            return this.helpDocProduct;
        }
        return "dtprompt";
    }

    public void setHelpDocProduct(String helpDocProduct) {
        this.helpDocProduct = helpDocProduct;
    }

    private CommonLoggerInterface getLogger() {
        if (null == this.logger) {
            this.logger = LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory());
        }
        return this.logger;
    }

    public void setInitialSelectedItems(List items) {
        this.selectedItems = items;
        if (this.valuePicker != null) {
            ValueListEditor vle = (ValueListEditor)this.valuePicker.getTargetComponent();
            vle.addItems((Collection)items);
        }
    }

    public List getInitialSelectedItems() {
        return this.selectedItems;
    }

    Object getLabelDataItem() {
        if (this.choiceLabelCombo == null) {
            return null;
        }
        return this.choiceLabelCombo.getSelectedItem();
    }

    static {
        LABEL_COLUMN = RB.getStringResource("column.txt");
        LABEL_DATA_ITEM = RB.getStringResource("dataItem.txt");
    }

    class ValueRendererHandler
    extends ValuePickerRendererHandler {
        private DataTypeInterface dataType;
        private boolean dataTypeIsInteger;

        public ValueRendererHandler(DataTypeInterface dataType) {
            this.dataType = dataType;
            this.dataTypeIsInteger = dataType instanceof IntegerType;
        }

        public void configureLabelFor(JLabel label, Object value, JComponent visual, boolean isSelected, boolean hasFocus, Object cellType) {
            Object formattedValueItem;
            super.configureLabelFor(label, value, visual, isSelected, hasFocus, cellType);
            if (value instanceof ValueItem) {
                if (((ValueItem)value).getValue() instanceof MissingValues) {
                    label.setText(DynamicValuesRelationalPanel.this.missingValueItem.getLabel());
                    return;
                }
                label.setText(((ValueItem)value).getLabel());
                return;
            }
            if (ValueProviderModelAdapter.NO_RESULTS_FOUND.equals(value)) {
                label.setText(ValueProviderModelAdapter.NO_RESULTS_FOUND.getLabel());
            } else if (this.dataType != null && ((formattedValueItem = DynamicValuesRelationalPanel.this.choiceLabelCombo.getSelectedItem()) == useUnformattedValueItem && "LABEL".equals(cellType) || "VALUE".equals(cellType) || formattedValueItem == DynamicValuesRelationalPanel.this.noItemsValueItem || cellType == null)) {
                try {
                    label.setText(this.dataType.getDisplayString(this.dataType.coerceValue(value, DynamicValuesRelationalPanel.this.getLocale()), DynamicValuesRelationalPanel.this.getLocale()));
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            super.configureLabelFor(label, value, visual, isSelected, hasFocus, cellType);
        }
    }
}

