/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.definitions.MutableSelectableDefinitionInterface;
import com.sas.prompts.definitions.MutableValueProviderDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.PromptDataProviderInterface;
import com.sas.prompts.valueprovider.dynamic.iq.InfoMapItemsValueProvider;
import com.sas.prompts.valueprovider.dynamic.iq.OLAPDataItemValueProvider;
import com.sas.prompts.visuals.swing.designtime.BasePromptTypesAndValuesPanel;
import com.sas.prompts.visuals.swing.designtime.ConvertToTreeModelUtil;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.valueprovider.ValueType;
import com.sas.swing.visuals.ComboBox;
import com.sas.swing.visuals.OptionsDialog;
import com.sas.swing.visuals.PanelInterface;
import com.sas.swing.visuals.ValuePicker;
import com.sas.swing.visuals.util.Util;
import com.sas.util.ValueItem;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class DynamicValuesOLAPPanel
extends BasePromptTypesAndValuesPanel
implements ActionListener {
    private boolean contentsValid = true;
    private boolean userDefinedDataProvider;
    private long dataSourceType;
    private DataSourceInterface dataSource;
    private JButton defaultValueButton;
    private JCheckBox allowCustomValuesCheckBox;
    private ComboBox hierarchyCombo;
    private JTextField defaultValueField;
    private String infoMapUrl;
    private String selectionType;
    private PromptDefinitionInterface prompt;
    private DefaultComboBoxModel hierarchyModel;
    private PromptDataProviderInterface dataProvider;
    private OLAPDataItemValueProvider valueProvider;
    private Object defaultValue;
    private static final long serialVersionUID = 3257563988660598326L;

    public DynamicValuesOLAPPanel(PromptDefinitionInterface prompt, String selectionType, PromptDataProviderInterface dataProvider, String infoMapUrl, OLAPDataItemValueProvider valueProvider, PropertiesCommunicator communicator) {
        super(communicator);
        this.prompt = prompt;
        this.infoMapUrl = infoMapUrl;
        this.valueProvider = valueProvider;
        this.selectionType = selectionType;
        if (dataProvider == null) {
            dataProvider = new DataProvider(communicator.getUserContext());
        } else {
            this.dataProvider = dataProvider;
        }
    }

    public DynamicValuesOLAPPanel(PromptDefinitionInterface prompt, String selectionType, DataSourceInterface dataSource, OLAPDataItemValueProvider valueProvider, PropertiesCommunicator communicator) {
        super(communicator);
        this.userDefinedDataProvider = false;
        this.prompt = prompt;
        this.dataSource = dataSource;
        if (dataSource != null) {
            this.infoMapUrl = dataSource.getDataSourceLocation();
            this.dataSourceType = dataSource.getDataSourceType();
        }
        this.valueProvider = valueProvider;
        this.selectionType = selectionType;
        PromptDataProviderInterface userDataProvider = communicator.getDataProvider();
        if (userDataProvider != null) {
            this.dataProvider = userDataProvider;
            this.userDefinedDataProvider = true;
        } else {
            this.dataProvider = new DataProvider(communicator.getUserContext());
        }
        this.createPanel();
    }

    private void createPanel() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 0, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        JPanel outerChoicePanel = new JPanel();
        AutoSizingGridLayout outerChoicePanelLayout = new AutoSizingGridLayout(1, 2, 10, 5, true, false, true);
        outerChoicePanel.setLayout((LayoutManager)outerChoicePanelLayout);
        JPanel hierarchyPanel = new JPanel();
        AutoSizingGridLayout hierarchyPanelLayout = new AutoSizingGridLayout(2, 1, 10, 5, true, false, true);
        hierarchyPanel.setLayout((LayoutManager)hierarchyPanelLayout);
        JLabel hierarchyLabel = new JLabel(RB.getStringResource("hierarchy.txt"));
        this.hierarchyCombo = new ComboBox();
        this.hierarchyModel = new DefaultComboBoxModel();
        this.hierarchyModel.addElement("     ");
        this.hierarchyCombo.setModel((ComboBoxModel)this.hierarchyModel);
        hierarchyPanel.add(hierarchyLabel);
        hierarchyPanel.add((Component)this.hierarchyCombo);
        JPanel defaultValuePanel = new JPanel();
        AutoSizingGridLayout defaultValuePanelLayout = new AutoSizingGridLayout(2, 1, 10, 5, true, false, true);
        defaultValuePanel.setLayout((LayoutManager)defaultValuePanelLayout);
        JLabel defaultValueFormatLabel = new JLabel(RB.getStringResource("defaultValue.txt"));
        JPanel defaultValueButtonPanel = new JPanel();
        AutoSizingGridLayout defaultValueButtonPanelLayout = new AutoSizingGridLayout(1, 2, 5, 5, true, false, true);
        defaultValueButtonPanelLayout.setRemainderColumn(1);
        defaultValueButtonPanel.setLayout((LayoutManager)defaultValueButtonPanelLayout);
        this.defaultValueField = new JTextField();
        this.defaultValueButton = new JButton("...");
        this.defaultValueButton.addActionListener(this);
        defaultValueButtonPanel.add(this.defaultValueField);
        defaultValueButtonPanel.add(this.defaultValueButton);
        defaultValuePanel.add(defaultValueFormatLabel);
        defaultValuePanel.add(defaultValueButtonPanel);
        this.allowCustomValuesCheckBox = new JCheckBox(RB.getStringResource("allowCustomValues.txt"));
        outerChoicePanel.add(hierarchyPanel);
        outerChoicePanel.add(defaultValuePanel);
        this.initializeFields();
        if (this.valueProvider != null) {
            this.setDataItemValues();
        }
        this.add(outerChoicePanel);
        this.add(this.allowCustomValuesCheckBox);
    }

    private void initializeFields() {
        try {
            if (this.infoMapUrl != null) {
                InfoMapItemsValueProvider infoMapValueItemsValueProvider = new InfoMapItemsValueProvider();
                infoMapValueItemsValueProvider.setInfoMapUrl(this.infoMapUrl);
                infoMapValueItemsValueProvider.setDataProvider((DataProviderInterface)this.dataProvider);
                List values = (List)infoMapValueItemsValueProvider.getValues(this.locale, ValueType.LIST, 0, -1);
                int valuesListSize = values.size();
                this.hierarchyModel.removeAllElements();
                for (int j = 0; j < valuesListSize; ++j) {
                    ValueItem valueItem = (ValueItem)values.get(j);
                    this.hierarchyModel.addElement(valueItem);
                }
                this.hierarchyCombo.setModel((ComboBoxModel)this.hierarchyModel);
            }
        }
        catch (ValueProviderException e) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(e.getMessage(), (Throwable)e);
        }
        if (this.prompt != null) {
            this.allowCustomValuesCheckBox.setSelected(((ValueProviderDefinitionInterface)this.prompt).isAllowUserValues());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.defaultValueButton) {
            OLAPDataItemValueProvider olapDataItemProvider = new OLAPDataItemValueProvider(this.getValueDataItem());
            JFrame frame = Util.getParentFrame((Component)this);
            ValuePicker valuepicker = new ValuePicker((ValueProviderInterface)olapDataItemProvider, 402, this.convertSelectionType(this.selectionType), false, this.locale);
            OptionsDialog dialog = new OptionsDialog((Frame)frame, RB.getStringResource("newGroup.txt"), true);
            ConvertToTreeModelUtil.quarterOver((Window)dialog, this);
            dialog.setPanel((PanelInterface)valuepicker);
            dialog.setTitle(RB.getStringResource("newPrompt.txt"));
            dialog.pack();
            dialog.setVisible(true);
            List selectedItems = ((ValuePicker)dialog.getPanel()).getSelectedItems();
            if (!dialog.wasCancelled() && selectedItems != null && selectedItems.size() > 0) {
                if (this.selectionType != "Single value") {
                    this.defaultValueField.setText("");
                } else {
                    ValueItem valueItem = (ValueItem)selectedItems.get(0);
                    this.defaultValue = valueItem.getValue();
                    this.defaultValueField.setText(valueItem.getLabel());
                }
            }
        }
    }

    private int convertSelectionType(String selectionType) {
        if (selectionType == "Multiple values") {
            return 301;
        }
        if (selectionType.equals("Multiple ordered values")) {
            return 302;
        }
        return 300;
    }

    private DataItem getValueDataItem() {
        DataItem valueDataItem = null;
        try {
            valueDataItem = ((DataProvider)this.dataProvider).getDataItemFromId(this.infoMapUrl, (String)((ValueItem)this.hierarchyCombo.getSelectedItem()).getValue());
        }
        catch (ServerConnectionException sce) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(sce.getMessage(), (Throwable)sce);
        }
        return valueDataItem;
    }

    private void setDataItemValues() {
        String valueDataItemID = null;
        try {
            valueDataItemID = this.valueProvider.getDataItem().getID();
        }
        catch (InvalidIDException e) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(e.getMessage(), (Throwable)e);
        }
        int valuesListSize = this.hierarchyModel.getSize();
        if (valueDataItemID != null) {
            for (int i = 0; i < valuesListSize; ++i) {
                ValueItem valueItem = (ValueItem)this.hierarchyModel.getElementAt(i);
                if (!valueDataItemID.equals(valueItem.getValue())) continue;
                this.hierarchyCombo.setSelectedIndex(i);
                break;
            }
        }
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        OLAPDataItemValueProvider promptRelationalDataItemValueProvider = new OLAPDataItemValueProvider();
        promptRelationalDataItemValueProvider.setDataItem(this.getValueDataItem());
        ((MutableValueProviderDefinitionInterface)this.prompt).setValueProvider((ValueProviderInterface)promptRelationalDataItemValueProvider);
        ((MutableValueProviderDefinitionInterface)this.prompt).setAllowUserValues(this.allowCustomValuesCheckBox.isSelected());
        if (this.defaultValue != null) {
            ((MutableSelectableDefinitionInterface)this.prompt).setDefaultValue(this.defaultValue);
        }
        return this.prompt;
    }

    @Override
    public boolean isContentsValid() {
        return this.contentsValid;
    }

    @Override
    public void setContentsValid(boolean newValue) {
        if (newValue != this.contentsValid) {
            this.contentsValid = newValue;
            this.firePropertyChange("contentsValid", !this.contentsValid, this.contentsValid);
        }
    }
}

