/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.models.datasources.DataSourceColumnInterface;
import com.sas.models.itemlistmanager.ItemListManagerViewerInterface;
import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.DynamicPromptValueContext;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.DynamicValueProviderInterface;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.BaseDefinitionRangeInterface;
import com.sas.prompts.definitions.DateDefinitionInterface;
import com.sas.prompts.definitions.OLAPMemberNameDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionEnum;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.SelectableDefinitionInterface;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.prompts.definitions.shared.SharedPromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.shared.SharedPromptGroupInterface;
import com.sas.prompts.simplesqlmodel.PromptValueOperand;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.PromptDataProviderInterface;
import com.sas.prompts.valueprovider.dynamic.iq.InfoMapItemsValueProvider;
import com.sas.prompts.valueprovider.dynamic.iq.OLAPDataItemValueProvider;
import com.sas.prompts.valueprovider.dynamic.iq.RelationalDataItemValueProvider;
import com.sas.prompts.valueprovider.dynamic.workspace.ColumnNamesValueProvider;
import com.sas.prompts.valueprovider.dynamic.workspace.PromptColumnValueProvider;
import com.sas.prompts.visuals.swing.designtime.BasePromptTypesAndValuesPanel;
import com.sas.prompts.visuals.swing.designtime.DependenciesPanelTableModel;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.services.information.metadata.PhysicalTableInterface;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.simplesqlmodel.ColumnOperand;
import com.sas.storage.simplesqlmodel.Expression;
import com.sas.storage.simplesqlmodel.FormattedOperator;
import com.sas.storage.simplesqlmodel.MultiValueFormattedOperator;
import com.sas.storage.simplesqlmodel.OperandInterface;
import com.sas.storage.simplesqlmodel.OperatorInterface;
import com.sas.storage.simplesqlmodel.WhereClause;
import com.sas.storage.valueprovider.StaticValueProvider;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.valueprovider.ValueType;
import com.sas.swing.visuals.ComboBox;
import com.sas.swing.visuals.itemlistmanager.CustomTableItemListManagerPanel;
import com.sas.swing.visuals.itemlistmanager.ItemListManagerTableView;
import com.sas.swing.visuals.tableview.DefaultTableCellRenderer;
import com.sas.swing.visuals.tableview.editors.ComboBoxEditor;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.SupportedSpecialValuesInterface;
import com.sas.util.ValueItem;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

class DependenciesPanel
extends BasePromptTypesAndValuesPanel
implements ListSelectionListener,
ItemListener {
    private boolean userDefinedDataProvider = false;
    private boolean tableViewEmpty;
    private CustomTableItemListManagerPanel tablePanel;
    private CustomTableItemListManagerPanel tableDependentPanel;
    private DynamicPromptValueContext dynamicValueContext;
    private ItemListManagerTableView tableView;
    private ItemListManagerTableView tableViewDependent;
    private ComboBox promptCombo;
    private ComboBox columnCombo;
    private ComboBox operandCombo;
    private DefaultComboBoxModel operandComboModel;
    private JLabel promptLabel;
    private JLabel columnLabel;
    private JLabel operandLabel;
    private DefaultComboBoxModel columnComboModel;
    public DefaultComboBoxModel promptComboModel;
    private PromptDefinitionInterface currentPrompt;
    private PromptDataProviderInterface dataProvider;
    private PromptGroupInterface rootPromptGroup;
    private String url;
    private String columnOperandName;
    private PromptDefinitionInterface promptForExpression;
    private static String VALUE_OF_KEY = RB.getStringResource("dependencies.valueOf.fmt.txt");
    private DependenciesPanelTableModel tableModel;
    private ValueProviderInterface currentPromptValueProvider;
    private Collection dependentPrompts;
    private ListSelectionModel rowSM;
    private CommonLoggerInterface logger = null;
    private DefaultTableModel dependenciesModel;
    private List valueProviderList;
    private List invalidDataItems;
    private static final long serialVersionUID = 3257563988660598326L;
    public static final String DEFAULT_HELP_ID = "promptdependtab";

    public DependenciesPanel(PropertiesCommunicator communicator) {
        this(communicator, null);
    }

    public DependenciesPanel(PropertiesCommunicator communicator, ValueProviderDefinitionInterface currentPrompt) {
        this(communicator, null, null);
    }

    public DependenciesPanel(PropertiesCommunicator communicator, ValueProviderDefinitionInterface currentPrompt, List valueProviderList) {
        super(communicator);
        this.currentPrompt = (PromptDefinitionInterface)currentPrompt;
        this.currentPromptValueProvider = currentPrompt.getValueProvider();
        this.valueProviderList = valueProviderList;
        this.invalidDataItems = new ArrayList();
        this.logger = LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)communicator.getLoggerFactory());
        PromptDataProviderInterface userDataProvider = communicator.getDataProvider();
        if (userDataProvider != null) {
            this.dataProvider = userDataProvider;
            this.userDefinedDataProvider = true;
        } else {
            this.dataProvider = new DataProvider(communicator.getUserContext());
        }
        this.promptForExpression = null;
        this.rootPromptGroup = communicator.getRootPromptGroup();
        PromptValues promptValues = new PromptValues(this.rootPromptGroup, null);
        this.dynamicValueContext = new DynamicPromptValueContext((PromptValuesInterface)promptValues, this.rootPromptGroup, null, (DataProviderInterface)this.dataProvider);
        this.setHelpID(DEFAULT_HELP_ID);
        this.createPromptPanel();
        this.initializeTables();
        if (this.promptComboModel == null || this.promptComboModel.getSize() == 0) {
            if (this.dependenciesModel != null && this.dependenciesModel.getRowCount() > 0) {
                this.dependenciesModel.removeRow(0);
                this.dependenciesModel.addRow(new Object[]{"   ", RB.getStringResource("noPromptsAvailableforDependency.txt")});
                this.tableViewEmpty = true;
            }
            Util.setEnabledOnContainer((Container)this.tablePanel, (boolean)false);
        }
    }

    protected void createPromptPanel() {
        this.communicator.addPropertyChangeListener(this);
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 10, 10, true, false, true);
        this.setLayout((LayoutManager)layout);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel promptsPanel = new JPanel();
        AutoSizingGridLayout promptsPanellayout = new AutoSizingGridLayout(-1, 1, 10, 5, true, false, true);
        promptsPanel.setLayout((LayoutManager)promptsPanellayout);
        Border emptyBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(RB.getStringResource("valueDependsOn.txt"));
        promptsPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, emptyBorder));
        this.promptCombo = new ComboBox();
        this.promptComboModel = new DefaultComboBoxModel();
        this.tableView = new ItemListManagerTableView();
        this.tableView.setAutoResizeMode(4);
        this.tableView.getColumnHeader().setReorderingAllowed(false);
        this.tableView.setRowHeaderVisible(false);
        this.tableView.setCellSelectionEnabled(false);
        this.tableView.setRowSelectionAllowed(true);
        this.tableView.setCellEditor(-1, 1, (TableCellEditor)new ComboBoxEditor((JComboBox)this.promptCombo));
        this.tableView.setPopupMenuEnabled(false);
        this.rowSM = this.tableView.getRowModel().getSelectionModel();
        this.rowSM.addListSelectionListener(this);
        this.tableModel = new DependenciesPanelTableModel(true);
        this.tableModel.addColumn(RB.getStringResource("prompt.txt"));
        this.tableModel.addColumn(RB.getStringResource("dependencyDescription.txt"));
        this.tablePanel = new CustomTableItemListManagerPanel(this.tableView);
        this.tablePanel.setModel((TableModel)((Object)this.tableModel));
        ((DefaultTableCellRenderer)this.tableView.getCellRenderer(-1, 1)).setShowSelectionWhenFocusAndEditable(true);
        this.tablePanel.removeButton(ItemListManagerViewerInterface.BUTTON_MOVE_UP);
        this.tablePanel.removeButton(ItemListManagerViewerInterface.BUTTON_MOVE_DOWN);
        DependenciesPanel dependP = this;
        this.tablePanel.setPreferredSize(new Dimension(300, 150));
        this.tablePanel.addActionListener(ItemListManagerViewerInterface.BUTTON_ADD, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (DependenciesPanel.this.tableViewEmpty) {
                            ((DefaultTableModel)DependenciesPanel.this.tableView.getModel()).removeRow(0);
                            ((DefaultTableCellRenderer)DependenciesPanel.this.tableView.getCellRenderer(-1, 1)).setShowSelectionWhenFocusAndEditable(true);
                            DependenciesPanel.this.tableView.setShowVerticalLines(true);
                            DependenciesPanel.this.tableView.setEnabled(true);
                            DependenciesPanel.this.tableViewEmpty = false;
                        }
                        DependenciesPanel.this.tableView.editCellAt(DependenciesPanel.this.tableView.getRowCount() - 1, 0);
                        Component editorComponent = DependenciesPanel.this.tableView.getEditorComponent();
                        if (editorComponent != null) {
                            editorComponent.requestFocus();
                            DependenciesPanel.this.tableView.setRowSelectionInterval(DependenciesPanel.this.tableView.getRowCount() - 1, DependenciesPanel.this.tableView.getRowCount() - 1);
                        }
                    }
                });
            }
        });
        this.tablePanel.addActionListener(ItemListManagerViewerInterface.BUTTON_DELETE, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DependenciesPanel.this.tableView.getCellEditor(DependenciesPanel.this.tableView.getRowCount() - 1, 0).cancelCellEditing();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (DependenciesPanel.this.tableView.getRowCount() == 0) {
                            DependenciesPanel.this.enableColumnAndOperandListeners(false);
                            DependenciesPanel.this.operandComboModel.removeAllElements();
                            DependenciesPanel.this.columnComboModel.removeAllElements();
                            DependenciesPanel.this.enableColumnAndOperandCombos(false);
                            DependenciesPanel.this.promptLabel.setText("");
                        }
                    }
                });
            }
        });
        promptsPanel.add((Component)this.tablePanel);
        JPanel columnsPanel = new JPanel();
        AutoSizingGridLayout columnsPanellayout = new AutoSizingGridLayout(2, 3, 10, 5, true, false, true);
        columnsPanel.setLayout((LayoutManager)columnsPanellayout);
        TitledBorder titledColumnPanelBorder = BorderFactory.createTitledBorder(RB.getStringResource("dependency.txt"));
        columnsPanel.setBorder(BorderFactory.createCompoundBorder(titledColumnPanelBorder, emptyBorder));
        this.columnLabel = new JLabel(RB.getStringResource("column.txt"));
        this.columnCombo = new ComboBox();
        this.columnComboModel = new DefaultComboBoxModel();
        this.columnCombo.setModel((ComboBoxModel)this.columnComboModel);
        this.operandLabel = new JLabel(RB.getStringResource("operation.txt"));
        this.operandCombo = new ComboBox();
        this.operandComboModel = new DefaultComboBoxModel();
        this.operandCombo.setModel((ComboBoxModel)this.operandComboModel);
        this.enableColumnAndOperandCombos(false);
        JLabel promptValueLabel = new JLabel(RB.getStringResource("valueOfPrompt.txt"));
        this.promptLabel = new JLabel("      ");
        columnsPanel.add(this.columnLabel);
        columnsPanel.add(this.operandLabel);
        columnsPanel.add(promptValueLabel);
        columnsPanel.add((Component)this.columnCombo);
        columnsPanel.add((Component)this.operandCombo);
        columnsPanel.add(this.promptLabel);
        promptsPanel.add(columnsPanel);
        JLabel dependentPromptsLabel = new JLabel(RB.getStringResource("dependentPrompts.txt"));
        this.tableViewDependent = new ItemListManagerTableView();
        this.tableViewDependent.setAutoResizeMode(4);
        this.tableViewDependent.getColumnHeader().setReorderingAllowed(false);
        this.tableViewDependent.setRowHeaderVisible(false);
        this.tableViewDependent.setCellSelectionEnabled(false);
        this.tableViewDependent.setRowSelectionAllowed(false);
        this.tableViewDependent.setPopupMenuEnabled(false);
        DependenciesPanelTableModel tableDependentModel = new DependenciesPanelTableModel(false);
        tableDependentModel.addColumn(RB.getStringResource("prompt.txt"));
        tableDependentModel.addColumn(RB.getStringResource("dependencyDescription.txt"));
        this.tableDependentPanel = new CustomTableItemListManagerPanel(this.tableViewDependent);
        this.tableDependentPanel.setModel((TableModel)((Object)tableDependentModel));
        this.tableDependentPanel.removeButton(ItemListManagerViewerInterface.BUTTON_ADD);
        this.tableDependentPanel.removeButton(ItemListManagerViewerInterface.BUTTON_DELETE);
        this.tableDependentPanel.removeButton(ItemListManagerViewerInterface.BUTTON_MOVE_UP);
        this.tableDependentPanel.removeButton(ItemListManagerViewerInterface.BUTTON_MOVE_DOWN);
        this.tableDependentPanel.setPreferredSize(new Dimension(300, 150));
        try {
            WhereClause whereClause;
            if (this.currentPromptValueProvider != null && (whereClause = this.communicator.getWhereClauseForOriginalPrompt()) != null) {
                OperandInterface andedExpression = whereClause.getCondition();
                List expressionList = Expression.getListFromAndedExpression((Expression)((Expression)andedExpression), (LoggerFactoryInterface)this.communicator.getLoggerFactory());
                int expressionListSize = expressionList.size();
                for (int k = 0; k < expressionListSize; ++k) {
                    Expression expression = (Expression)expressionList.get(k);
                    ValueItem valueItem = null;
                    if (this.currentPromptValueProvider instanceof RelationalDataItemValueProvider) {
                        valueItem = this.createDependencyInfoMapExpressionValueItem(expression, (RelationalDataItemValueProvider)this.currentPromptValueProvider, true);
                    } else if (this.currentPromptValueProvider instanceof PromptColumnValueProvider) {
                        valueItem = this.createDependencyPhysicalTableExpressionValueItem(expression, (PromptColumnValueProvider)this.currentPromptValueProvider, true);
                    }
                    if (valueItem == null) continue;
                    List operands = expression.getOperands();
                    int operandsSize = operands.size();
                    PromptValueOperand promptOperand = null;
                    for (int j = 0; j < operandsSize; ++j) {
                        Object o = operands.get(j);
                        if (!(o instanceof PromptValueOperand)) continue;
                        promptOperand = (PromptValueOperand)o;
                    }
                    if (promptOperand == null) continue;
                    PromptDefinitionInterface prompt = promptOperand.getPromptDefinition();
                    ValueItem promptValueItem = new ValueItem((Object)prompt.getPromptLabel(this.getLocale()), (Object)prompt);
                    Vector<ValueItem> v = new Vector<ValueItem>();
                    v.add(promptValueItem);
                    v.add(new ValueItem(valueItem.getValue(), (Object)expression));
                    ((DefaultTableModel)this.tablePanel.getModel()).addRow(v);
                }
            }
            PromptGroupInterface rootPromptGroup = this.communicator.getRootPromptGroup();
            List definitionsRootGroup = rootPromptGroup.getPromptDefinitions(false);
            for (PromptDefinitionInterface prompt : definitionsRootGroup) {
                this.processPromptDefinitions(prompt);
            }
            List subgroups = rootPromptGroup.getPromptSubgroups(true);
            for (PromptGroupInterface promptGroup : subgroups) {
                List definitions = promptGroup.getPromptDefinitions(false);
                if (promptGroup instanceof SharedPromptGroupInterface) continue;
                for (PromptDefinitionInterface prompt : definitions) {
                    if (PromptUtil.isPromptDefinitionInModalGroup((PromptDefinitionInterface)prompt, (PromptGroupInterface)promptGroup)) continue;
                    this.processPromptDefinitions(prompt);
                }
            }
            this.promptCombo.setModel((ComboBoxModel)this.promptComboModel);
        }
        catch (ServerConnectionException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
        }
        this.add(promptsPanel);
        this.add(dependentPromptsLabel);
        this.add((Component)this.tableDependentPanel);
        this.promptCombo.addItemListener((ItemListener)this);
        this.columnCombo.setPreferredSize(new Dimension(150, 21));
        final DependenciesPanel dependPP = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object o;
                if (((DefaultTableModel)DependenciesPanel.this.tablePanel.getModel()).getRowCount() > 0 && (o = DependenciesPanel.this.tableView.getValueAt(0, 1)) instanceof ValueItem) {
                    DependenciesPanel.this.tablePanel.setSelectedRow(0);
                }
                if (!DependenciesPanel.this.communicator.isComponentsEnabled()) {
                    Util.setEnabledOnContainer((Container)dependPP, (boolean)false);
                } else if (DependenciesPanel.this.currentPrompt instanceof SharedPromptDefinitionInterface) {
                    Util.setEnabledOnContainer((Container)dependPP, (boolean)false);
                } else {
                    Object parentGroup = DependenciesPanel.this.communicator.getSelectedParentObjectOnMainPanel();
                    if (parentGroup != null && parentGroup instanceof PromptGroupInterface && (parentGroup instanceof SharedPromptGroupInterface || PromptUtility.hasAncestorSharedGroup(DependenciesPanel.this.rootPromptGroup, (PromptGroupInterface)parentGroup))) {
                        Util.setEnabledOnContainer((Container)dependPP, (boolean)false);
                    }
                }
            }
        });
        if (this.invalidDataItems.size() > 0 && this.getGenericErrorHandler() != null) {
            this.firePropertyChange("errorPanel", null, "DependenciesPanel");
            Object[] argsArray = new String[1];
            String argString = "";
            for (int i = 0; i < this.invalidDataItems.size(); ++i) {
                argString = argString + "\n{" + i + "}";
            }
            argsArray[0] = argString;
            String tempMessage = MessageFormat.format(RB.getStringResource("invalidDataItemDependency.fmt.txt"), argsArray);
            String messageString = MessageFormat.format(tempMessage, this.invalidDataItems.toArray());
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)PromptUtility.getParentFrame(this.communicator, this), new Message(messageString), null);
            }
        }
    }

    private void initializeTables() {
        int i;
        TableColumn column;
        DefaultTableModel dependentTableModel = (DefaultTableModel)this.tableDependentPanel.getModel();
        if (dependentTableModel != null && dependentTableModel.getRowCount() == 0) {
            column = null;
            for (i = 0; i < 2; ++i) {
                column = this.tableViewDependent.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setPreferredWidth(75);
                    continue;
                }
                column.setPreferredWidth(350);
            }
            ((DefaultTableModel)this.tableDependentPanel.getModel()).addRow(new Object[]{"   ", RB.getStringResource("noDependendents.txt")});
            this.tableViewDependent.setShowVerticalLines(false);
        }
        this.dependenciesModel = (DefaultTableModel)this.tableView.getModel();
        if (this.dependenciesModel != null && this.dependenciesModel.getRowCount() == 0) {
            column = null;
            for (i = 0; i < 2; ++i) {
                column = this.tableView.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setPreferredWidth(125);
                    continue;
                }
                column.setPreferredWidth(325);
            }
            this.dependenciesModel.addRow(new Object[]{"   ", RB.getStringResource("clickAddForNewDependency.txt")});
            this.tableView.setShowVerticalLines(false);
            ((DefaultTableCellRenderer)this.tableView.getCellRenderer(-1, 1)).setShowSelectionWhenFocusAndEditable(false);
            this.tableView.clearSelection();
            this.tableView.setEnabled(false);
            this.tableViewEmpty = true;
        }
    }

    private void processPromptDefinitions(PromptDefinitionInterface prompt) throws ServerConnectionException {
        block23: {
            ValueProviderInterface valueProvider = null;
            if (prompt instanceof ValueProviderDefinitionInterface) {
                valueProvider = ((ValueProviderDefinitionInterface)prompt).getValueProvider();
            }
            if (valueProvider == null || valueProvider != null && !(valueProvider instanceof OLAPDataItemValueProvider)) {
                try {
                    if (valueProvider instanceof DynamicValueProviderInterface) {
                        boolean isValidDataSource = true;
                        if (valueProvider instanceof RelationalDataItemValueProvider) {
                            try {
                                isValidDataSource = ((RelationalDataItemValueProvider)valueProvider).getDataItem() != null;
                            }
                            catch (IllegalStateException e) {
                                isValidDataSource = false;
                            }
                        } else if (valueProvider instanceof PromptColumnValueProvider) {
                            String sbipUrl = ((PromptColumnValueProvider)valueProvider).getTableUrl();
                            boolean bl = isValidDataSource = this.dataProvider.getPhysicalTable(sbipUrl) != null;
                        }
                        if (!isValidDataSource) break block23;
                        try {
                            this.dependentPrompts = ((DynamicValueProviderInterface)valueProvider).getDependentPrompts(this.getLocale(), (DynamicPromptValueContextInterface)this.dynamicValueContext);
                            if (prompt != this.communicator.getOriginalPrompt() && this.dependentPrompts.contains(this.communicator.getOriginalPrompt())) {
                                WhereClause whereClause = null;
                                if (valueProvider instanceof RelationalDataItemValueProvider) {
                                    whereClause = ((RelationalDataItemValueProvider)valueProvider).getWhereClause();
                                } else if (valueProvider instanceof PromptColumnValueProvider) {
                                    whereClause = ((PromptColumnValueProvider)valueProvider).getWhereClause();
                                }
                                if (whereClause != null) {
                                    this.parseWhereClause(prompt, whereClause, (DynamicValueProviderInterface)valueProvider, this.tableDependentPanel, false);
                                }
                                break block23;
                            }
                            if (prompt == this.communicator.getOriginalPrompt() || !PromptUtility.isPromptTypeValidForPromptValueOperand(prompt) || !this.isCompatiblePrompt(prompt)) break block23;
                            if (this.currentPromptValueProvider instanceof RelationalDataItemValueProvider) {
                                SupportedSpecialValues support;
                                boolean addToCombo = true;
                                if (prompt instanceof SelectableDefinitionInterface && ((SelectableDefinitionInterface)prompt).getSelectionType() == 300 && prompt instanceof SupportedSpecialValuesInterface && (support = ((SupportedSpecialValuesInterface)prompt).getSupportedSpecialValues()).isAllSupported()) {
                                    addToCombo = false;
                                }
                                if (addToCombo) {
                                    this.addItemToPromptComboBox(prompt);
                                }
                                break block23;
                            }
                            this.addItemToPromptComboBox(prompt);
                        }
                        catch (IllegalStateException addToCombo) {}
                        break block23;
                    }
                    if (PromptUtility.isPromptTypeValidForPromptValueOperand(prompt) && this.isCompatiblePrompt(prompt)) {
                        SupportedSpecialValues support;
                        boolean addToCombo = true;
                        if (prompt instanceof SelectableDefinitionInterface && ((SelectableDefinitionInterface)prompt).getSelectionType() == 300 && prompt instanceof SupportedSpecialValuesInterface && (support = ((SupportedSpecialValuesInterface)prompt).getSupportedSpecialValues()).isAllSupported()) {
                            addToCombo = false;
                        }
                        if (addToCombo) {
                            this.addItemToPromptComboBox(prompt);
                        }
                    }
                }
                catch (ValueProviderException ipve) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
                }
            }
        }
    }

    private boolean isCompatiblePrompt(PromptDefinitionInterface selectedPrompt) {
        if (selectedPrompt != null && !(selectedPrompt instanceof OLAPMemberNameDefinitionInterface) && this.currentPrompt != null) {
            List dataSourceInfo;
            ValueProviderInterface selectedValueProvider = null;
            if (selectedPrompt instanceof ValueProviderDefinitionInterface) {
                selectedValueProvider = ((ValueProviderDefinitionInterface)selectedPrompt).getValueProvider();
            }
            if ((dataSourceInfo = this.getDataSource(selectedValueProvider, this.currentPromptValueProvider)) == null || dataSourceInfo.size() == 0) {
                return false;
            }
            ValueProviderInterface valueProvider = (ValueProviderInterface)dataSourceInfo.get(1);
            boolean sameDataSource = (Boolean)dataSourceInfo.get(2);
            if (!sameDataSource) {
                long selectedPromptDataType = PromptDefinitionEnum.getDataType((PromptDefinitionInterface)selectedPrompt);
                List values = null;
                if (valueProvider instanceof RelationalDataItemValueProvider) {
                    try {
                        this.url = (String)dataSourceInfo.get(0);
                        this.logger.debug("itemStateChanged(), handling relational data item.");
                        if (this.valueProviderList != null && this.valueProviderList.size() > 0) {
                            values = this.valueProviderList;
                        } else {
                            InfoMapItemsValueProvider infoMapValueItemsValueProvider = new InfoMapItemsValueProvider();
                            infoMapValueItemsValueProvider.setInfoMapUrl(this.url);
                            infoMapValueItemsValueProvider.setDataProvider((DataProviderInterface)this.dataProvider);
                            values = (List)infoMapValueItemsValueProvider.getValues(this.getLocale(), ValueType.LIST, 0, -1);
                        }
                        for (ValueItem vItem : values) {
                            boolean accept = false;
                            String dataItemId = ((DataSourceColumnInterface)vItem.getValue()).getColumnName();
                            DataItem candidate = ((DataProvider)this.dataProvider).getDataItemFromId(this.url, dataItemId);
                            long type = candidate.getExpressionTypeIgnoringFormattingForced();
                            accept = PromptUtility.isDataItemValidForPromptDataType(selectedPromptDataType, type);
                            if (!accept) continue;
                            return true;
                        }
                        return false;
                    }
                    catch (ServerConnectionException sce) {
                        LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(sce.getMessage(), (Throwable)sce);
                        return false;
                    }
                    catch (ValueProviderException vpe) {
                        LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(vpe.getMessage(), (Throwable)vpe);
                        return false;
                    }
                }
                if (valueProvider instanceof PromptColumnValueProvider) {
                    try {
                        if (this.valueProviderList != null && this.valueProviderList.size() > 0) {
                            values = this.valueProviderList;
                        } else {
                            this.url = (String)dataSourceInfo.get(0);
                            ColumnNamesValueProvider columnNamesValueProvider = new ColumnNamesValueProvider(this.url);
                            PromptGroup promptGroup = new PromptGroup();
                            PromptValues promptValues = new PromptValues((PromptGroupInterface)promptGroup);
                            DynamicPromptValueContext dynamicValueContext = new DynamicPromptValueContext((PromptValuesInterface)promptValues, (PromptGroupInterface)promptGroup, null, (DataProviderInterface)this.dataProvider);
                            values = (List)columnNamesValueProvider.getValues(this.getLocale(), (DynamicPromptValueContextInterface)dynamicValueContext, ValueType.LIST);
                        }
                        for (ValueItem vItem : values) {
                            boolean accept = false;
                            long colType = ((DataSourceColumnInterface)vItem.getValue()).getColumnType();
                            accept = PromptUtility.isColumnValidForPromptDataType(selectedPromptDataType, colType);
                            if (!accept) continue;
                            return true;
                        }
                        return false;
                    }
                    catch (ValueProviderException vpe) {
                        LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(vpe.getMessage(), (Throwable)vpe);
                        return false;
                    }
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private void addItemToPromptComboBox(PromptDefinitionInterface prompt) {
        ValueItem valueItem = new ValueItem();
        String promptLabel = prompt.getPromptLabel(this.getLocale());
        if (promptLabel == null || promptLabel.trim().length() == 0) {
            promptLabel = prompt.getPromptName();
        }
        valueItem.setLabel(prompt.getPromptLabel(this.getLocale()));
        valueItem.setValue((Object)prompt);
        this.promptComboModel.addElement(valueItem);
    }

    private void parseWhereClause(PromptDefinitionInterface prompt, WhereClause whereClause, DynamicValueProviderInterface valueProvider, CustomTableItemListManagerPanel panel, boolean includeCurrentPrompt) throws ServerConnectionException {
        OperandInterface andedExpression = whereClause.getCondition();
        List expressionList = Expression.getListFromAndedExpression((Expression)((Expression)andedExpression), (LoggerFactoryInterface)this.communicator.getLoggerFactory());
        int expressionListSize = expressionList.size();
        for (int k = 0; k < expressionListSize; ++k) {
            Expression expression = (Expression)expressionList.get(k);
            ValueItem valueItem = null;
            if (valueProvider instanceof RelationalDataItemValueProvider) {
                valueItem = this.createDependencyInfoMapExpressionValueItem(expression, (RelationalDataItemValueProvider)valueProvider, includeCurrentPrompt);
            } else if (valueProvider instanceof PromptColumnValueProvider) {
                valueItem = this.createDependencyPhysicalTableExpressionValueItem(expression, (PromptColumnValueProvider)valueProvider, includeCurrentPrompt);
            }
            if (valueItem == null) continue;
            Vector<Object> v = new Vector<Object>();
            if (prompt != null) {
                v.add(prompt.getPromptLabel(this.getLocale()));
            } else {
                v.add(valueItem.getLabel());
            }
            v.add(valueItem.getValue());
            ((DefaultTableModel)this.tableDependentPanel.getModel()).addRow(v);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        int selectedRow = this.tableView.getSelectedRow();
        if (e.getStateChange() == 1 && selectedRow != -1) {
            Object o = (ValueItem)this.tableView.getValueAt(selectedRow, 0);
            if (o == null || e.getSource() == this.promptCombo) {
                o = this.promptCombo.getSelectedItem();
            }
            PromptDefinitionInterface selectedPrompt = null;
            if (e.getSource() == this.promptCombo) {
                o = this.promptCombo.getSelectedItem();
                this.columnCombo.setEnabled(true);
            }
            if (o instanceof ValueItem) {
                selectedPrompt = (PromptDefinitionInterface)o.getValue();
            }
            if (selectedPrompt != null && !(selectedPrompt instanceof OLAPMemberNameDefinitionInterface) && this.currentPrompt != null) {
                ValueProviderInterface selectedValueProvider = null;
                if (selectedPrompt instanceof ValueProviderDefinitionInterface) {
                    selectedValueProvider = ((ValueProviderDefinitionInterface)selectedPrompt).getValueProvider();
                }
                List dataSourceInfo = this.getDataSource(selectedValueProvider, this.currentPromptValueProvider);
                ValueProviderInterface valueProvider = (ValueProviderInterface)dataSourceInfo.get(1);
                boolean sameDataSource = (Boolean)dataSourceInfo.get(2);
                if (e.getSource() == this.promptCombo) {
                    this.enableColumnAndOperandListeners(false);
                    this.enableColumnAndOperandCombos(true);
                    this.columnComboModel.removeAllElements();
                    this.operandComboModel.removeAllElements();
                    this.promptForExpression = selectedPrompt;
                    if (valueProvider instanceof RelationalDataItemValueProvider) {
                        try {
                            ValueItem valueValueItem;
                            DataItem dataItem = null;
                            this.url = (String)dataSourceInfo.get(0);
                            this.logger.debug("itemStateChanged(), handling relational data item.");
                            InfoMapItemsValueProvider infoMapValueItemsValueProvider = new InfoMapItemsValueProvider();
                            infoMapValueItemsValueProvider.setInfoMapUrl(this.url);
                            infoMapValueItemsValueProvider.setDataProvider((DataProviderInterface)this.dataProvider);
                            List values = (List)infoMapValueItemsValueProvider.getValues(this.getLocale(), ValueType.LIST, 0, -1);
                            dataItem = sameDataSource ? ((RelationalDataItemValueProvider)valueProvider).getDataItem() : ((RelationalDataItemValueProvider)this.currentPromptValueProvider).getDataItem();
                            String currentDataItemId = dataItem.getID();
                            Object vItem = null;
                            this.logger.debug("current dataItem=", dataItem.getLabel());
                            ValueItem selectedItem = null;
                            selectedItem = this.pruneRelationalListForCompatiblePrompts(selectedPrompt, values, currentDataItemId);
                            if (selectedItem != null) {
                                this.columnComboModel.setSelectedItem(selectedItem);
                            }
                            if (null != (valueValueItem = (ValueItem)this.columnCombo.getSelectedItem())) {
                                this.columnOperandName = ((DataSourceColumnInterface)valueValueItem.getValue()).getColumnName();
                                this.populateOperandComboForInfoMap(this.getValueDataItem(this.columnOperandName), selectedPrompt);
                            }
                            this.promptLabel.setText(selectedPrompt.getPromptLabel(this.getLocale()));
                            ValueItem operand = (ValueItem)this.operandCombo.getSelectedItem();
                            Expression modelExpression = new Expression((OperatorInterface)operand.getValue(), (OperandInterface)new ColumnOperand(this.columnOperandName), (OperandInterface)new PromptValueOperand(this.promptForExpression));
                            this.tableView.getModel().setValueAt(this.createInfoMapExpressionValueItem(modelExpression), selectedRow, 1);
                        }
                        catch (ValueProviderException vpe) {
                            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(vpe.getMessage());
                        }
                        catch (InvalidIDException ie) {
                            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ie.getMessage());
                        }
                    } else if (valueProvider instanceof PromptColumnValueProvider) {
                        try {
                            String columnName = ((PromptColumnValueProvider)valueProvider).getValueColumn().getName();
                            this.populateColumnModelFromTable(columnName, selectedPrompt, dataSourceInfo, sameDataSource);
                        }
                        catch (ValueProviderException vpe) {
                            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(vpe.getMessage(), (Throwable)vpe);
                        }
                        ValueItem operand = (ValueItem)this.operandCombo.getSelectedItem();
                        if (null != operand) {
                            Expression modelExpression = new Expression((OperatorInterface)operand.getValue(), (OperandInterface)new ColumnOperand(this.columnOperandName), (OperandInterface)new PromptValueOperand(this.promptForExpression));
                            this.tableView.getModel().setValueAt(this.createPhysicalTableExpressionValueItem(modelExpression), selectedRow, 1);
                        } else {
                            this.logger.debug("There was no selected item from the operandCombo");
                            this.enableColumnAndOperandCombos(false);
                        }
                    }
                    this.enableColumnAndOperandListeners(true);
                } else if (e.getSource() == this.operandCombo || e.getSource() == this.columnCombo) {
                    ValueItem valueValueItem = (ValueItem)this.columnCombo.getSelectedItem();
                    DataSourceColumnInterface item = (DataSourceColumnInterface)valueValueItem.getValue();
                    String columnOperand = item.getColumnName();
                    this.enableColumnAndOperandListeners(false);
                    if (valueProvider instanceof RelationalDataItemValueProvider) {
                        this.columnOperandName = ((DataSourceColumnInterface)valueValueItem.getValue()).getColumnName();
                        if (e.getSource() == this.columnCombo) {
                            this.populateOperandComboForInfoMap(this.getValueDataItem(this.columnOperandName), selectedPrompt);
                        }
                    } else if (valueProvider instanceof PromptColumnValueProvider) {
                        long columnType = item.getColumnType();
                        if (e.getSource() == this.columnCombo) {
                            this.populateOperandComboForPhysicalTable(columnType, selectedPrompt);
                        }
                    }
                    ValueItem operand = (ValueItem)this.operandCombo.getSelectedItem();
                    Expression modelExpression = new Expression((OperatorInterface)operand.getValue(), (OperandInterface)new ColumnOperand(columnOperand), (OperandInterface)new PromptValueOperand(selectedPrompt));
                    if (valueProvider instanceof RelationalDataItemValueProvider) {
                        this.tableView.getModel().setValueAt(this.createInfoMapExpressionValueItem(modelExpression), selectedRow, 1);
                    } else if (valueProvider instanceof PromptColumnValueProvider) {
                        this.tableView.getModel().setValueAt(this.createPhysicalTableExpressionValueItem(modelExpression), selectedRow, 1);
                    }
                    this.enableColumnAndOperandListeners(true);
                }
            }
        }
    }

    private void populateColumnModelFromTable(String columnName, PromptDefinitionInterface selectedPrompt, List dataSourceInfo, boolean sameDataSource) throws ValueProviderException {
        ValueItem item;
        this.url = (String)dataSourceInfo.get(0);
        ColumnNamesValueProvider columnNamesValueProvider = new ColumnNamesValueProvider(this.url);
        PromptGroup promptGroup = new PromptGroup();
        PromptValues promptValues = new PromptValues((PromptGroupInterface)promptGroup);
        DynamicPromptValueContext dynamicValueContext = new DynamicPromptValueContext((PromptValuesInterface)promptValues, (PromptGroupInterface)promptGroup, null, (DataProviderInterface)this.dataProvider);
        List values = (List)columnNamesValueProvider.getValues(this.getLocale(), (DynamicPromptValueContextInterface)dynamicValueContext, ValueType.LIST);
        this.logger.debug("populateColumnModelFromTable() columnName=", columnName);
        Object vItem = null;
        ValueItem selectedItem = null;
        long selectedPromptDataType = PromptDefinitionEnum.getDataType((PromptDefinitionInterface)selectedPrompt);
        selectedItem = this.prunePromptColumnListForCompatiblePrompts(selectedPrompt, values, columnName);
        if (selectedItem != null) {
            this.columnComboModel.setSelectedItem(selectedItem);
        }
        if (null != (item = (ValueItem)this.columnCombo.getSelectedItem())) {
            this.columnOperandName = ((DataSourceColumnInterface)item.getValue()).getColumnName();
            this.populateOperandComboForPhysicalTable(selectedPromptDataType, selectedPrompt);
            this.promptLabel.setText(selectedPrompt.getPromptLabel(this.getLocale()));
        } else {
            this.logger.debug("No column name is available for this data source.");
        }
    }

    private void enableColumnAndOperandListeners(boolean enabled) {
        this.columnCombo.removeItemListener((ItemListener)this);
        this.operandCombo.removeItemListener((ItemListener)this);
        if (enabled) {
            this.columnCombo.addItemListener((ItemListener)this);
            this.operandCombo.addItemListener((ItemListener)this);
        }
    }

    private void enableColumnAndOperandCombos(boolean enabled) {
        this.columnCombo.setEnabled(enabled);
        this.operandCombo.setEnabled(enabled);
        this.columnLabel.setEnabled(enabled);
        this.operandLabel.setEnabled(enabled);
    }

    private List getOperatorsForDataItem(DataItem dataItem, PromptDefinitionInterface prompt) {
        int selectionType;
        if (dataItem == null) {
            return null;
        }
        int expressionType = dataItem.getExpressionType();
        List operands = null;
        operands = prompt instanceof BaseDefinitionRangeInterface ? FormattedOperator.getIQSupportedRangeOperators() : (prompt instanceof DateDefinitionInterface ? MultiValueFormattedOperator.getDateComparisonOperators() : (expressionType != 3 ? MultiValueFormattedOperator.getNumericComparisonOperators() : MultiValueFormattedOperator.getCharComparisonOperators()));
        if (prompt instanceof SelectableDefinitionInterface && ((selectionType = ((SelectableDefinitionInterface)prompt).getSelectionType()) == 301 || selectionType == 302)) {
            int operandsSize = operands.size();
            for (int i = operandsSize - 1; i >= 0; --i) {
                ValueItem operand = (ValueItem)operands.get(i);
                if (operand.getValue() == MultiValueFormattedOperator.EQUAL_OPERATOR || operand.getValue() == MultiValueFormattedOperator.DATE_EQUAL_OPERATOR) continue;
                operands.remove(operand);
            }
        }
        return operands;
    }

    private void populateOperandComboForInfoMap(DataItem dataItem, PromptDefinitionInterface prompt) {
        block5: {
            int listSize;
            List operands;
            block4: {
                int i;
                operands = this.getOperatorsForDataItem(dataItem, prompt);
                if (operands == null) {
                    return;
                }
                listSize = operands.size();
                if (this.operandComboModel == null) break block4;
                boolean hasOperand = false;
                for (i = 0; i < listSize; ++i) {
                    hasOperand = this.operandComboModel.getIndexOf(operands.get(i)) != -1;
                }
                if (hasOperand) break block5;
                this.operandComboModel.removeAllElements();
                for (i = 0; i < listSize; ++i) {
                    this.operandComboModel.addElement(operands.get(i));
                }
                break block5;
            }
            for (int i = 0; i < listSize; ++i) {
                this.operandComboModel.addElement(operands.get(i));
            }
        }
    }

    private DataItem getValueDataItem(String dataItemId) {
        DataItem valueDataItem = null;
        if (this.columnComboModel.getSize() > 0 && this.columnCombo.getSelectedItem() instanceof ValueItem) {
            try {
                valueDataItem = ((DataProvider)this.dataProvider).getDataItemFromId(this.url, dataItemId);
            }
            catch (ServerConnectionException sce) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(sce.getMessage(), (Throwable)sce);
            }
            return valueDataItem;
        }
        return valueDataItem;
    }

    private ValueItem createInfoMapExpressionValueItem(Expression modelExpression) {
        ValueItem expressionValueItem = new ValueItem();
        try {
            ValueItem operand = (ValueItem)this.operandCombo.getSelectedItem();
            InformationMap informationMap = this.dataProvider.getInformationMap(this.url);
            String infoMapName = informationMap.getLabel();
            if (infoMapName != null) {
                String dataItemLabel = ((ValueItem)this.columnCombo.getSelectedItem()).getLabel();
                String tableDisplayName = infoMapName + "." + dataItemLabel + "  " + operand.getLabel() + " " + Message.format((String)VALUE_OF_KEY, (Object)this.promptLabel.getText());
                expressionValueItem.setLabel(tableDisplayName);
                expressionValueItem.setValue((Object)modelExpression);
            }
        }
        catch (ServerConnectionException sce) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(sce.getMessage(), (Throwable)sce);
        }
        return expressionValueItem;
    }

    private ValueItem createDependencyInfoMapExpressionValueItem(Expression modelExpression, RelationalDataItemValueProvider valueProvider, boolean includeCurrentPrompt) throws ServerConnectionException {
        ValueItem expressionValueItem = null;
        ColumnOperand columnOperand = null;
        PromptValueOperand promptOperand = null;
        List operands = modelExpression.getOperands();
        int operandsSize = operands.size();
        for (int j = 0; j < operandsSize; ++j) {
            Object o = operands.get(j);
            if (o instanceof PromptValueOperand) {
                promptOperand = (PromptValueOperand)o;
                continue;
            }
            if (!(o instanceof ColumnOperand)) continue;
            columnOperand = (ColumnOperand)o;
        }
        if (columnOperand != null && promptOperand != null) {
            PromptDefinitionInterface promptOperandDefinition = promptOperand.getPromptDefinition();
            if (includeCurrentPrompt || !includeCurrentPrompt && promptOperandDefinition == this.communicator.getOriginalPrompt()) {
                String dataItemId = columnOperand.getColumnName();
                String url = DataProvider.getPathUrl((DataItem)valueProvider.getDataItem());
                DataItem dataItem = ((DataProvider)this.dataProvider).getDataItemFromId(url, dataItemId);
                String promptLabel = promptOperandDefinition.getPromptLabel(this.getLocale());
                if (this.rootPromptGroup.hasPromptDefinition(promptOperandDefinition)) {
                    OperatorInterface operator = modelExpression.getOperator();
                    List comparisonOperators = this.getOperatorsForDataItem(dataItem, promptOperandDefinition);
                    if (comparisonOperators == null) {
                        this.invalidDataItems.add(dataItemId);
                        return null;
                    }
                    String operatorLabel = this.getLabelFromFormattedOperator(comparisonOperators, operator);
                    InformationMap informationMap = this.dataProvider.getInformationMap(url);
                    String infoMapName = informationMap.getLabel();
                    if (infoMapName != null) {
                        expressionValueItem = new ValueItem();
                        String dataItemLabel = dataItem.getLabel();
                        String tableDisplayName = infoMapName + "." + dataItemLabel + "  " + operatorLabel + " " + Message.format((String)VALUE_OF_KEY, (Object)promptLabel);
                        expressionValueItem.setLabel(promptLabel);
                        expressionValueItem.setValue((Object)tableDisplayName);
                    }
                }
            }
        }
        return expressionValueItem;
    }

    private List getOperatorsForPhysicalColumn(long columnType, PromptDefinitionInterface prompt) {
        List operands = null;
        operands = prompt instanceof BaseDefinitionRangeInterface ? FormattedOperator.getRangeOperators() : (prompt instanceof DateDefinitionInterface ? MultiValueFormattedOperator.getDateComparisonOperators() : (columnType == 1L ? MultiValueFormattedOperator.getCharComparisonOperators() : MultiValueFormattedOperator.getNumericComparisonOperators()));
        return operands;
    }

    private void populateOperandComboForPhysicalTable(long columnType, PromptDefinitionInterface prompt) {
        block4: {
            int listSize;
            List operands;
            block3: {
                int i;
                operands = this.getOperatorsForPhysicalColumn(columnType, prompt);
                listSize = operands.size();
                if (this.operandComboModel == null) break block3;
                boolean hasOperand = false;
                for (i = 0; i < listSize; ++i) {
                    hasOperand = this.operandComboModel.getIndexOf(operands.get(i)) != -1;
                }
                if (hasOperand) break block4;
                this.operandComboModel.removeAllElements();
                for (i = 0; i < listSize; ++i) {
                    this.operandComboModel.addElement(operands.get(i));
                }
                break block4;
            }
            for (int i = 0; i < listSize; ++i) {
                this.operandComboModel.addElement(operands.get(i));
            }
        }
    }

    private List getDataSource(ValueProviderInterface selectedValueProvider, ValueProviderInterface promptValueProvider) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (promptValueProvider != null && selectedValueProvider == null || selectedValueProvider instanceof StaticValueProvider || promptValueProvider.getClass() != selectedValueProvider.getClass()) {
            String promptUrl = null;
            promptUrl = promptValueProvider instanceof RelationalDataItemValueProvider ? DataProvider.getPathUrl((DataItem)((RelationalDataItemValueProvider)promptValueProvider).getDataItem()) : ((PromptColumnValueProvider)promptValueProvider).getTableUrl();
            this.logger.debug("data source URL=", promptUrl);
            list.add(promptUrl);
            list.add(promptValueProvider);
            list.add(Boolean.FALSE);
        } else if (promptValueProvider instanceof RelationalDataItemValueProvider) {
            DataItem dataItem = ((RelationalDataItemValueProvider)selectedValueProvider).getDataItem();
            if (dataItem != null) {
                String selectedInfoMapUrl = DataProvider.getPathUrl((DataItem)dataItem);
                String promptInfoMapUrl = DataProvider.getPathUrl((DataItem)((RelationalDataItemValueProvider)promptValueProvider).getDataItem());
                if (selectedInfoMapUrl != null && promptInfoMapUrl != null) {
                    if (!selectedInfoMapUrl.equals(promptInfoMapUrl)) {
                        list.add(promptInfoMapUrl);
                        list.add(promptValueProvider);
                        list.add(Boolean.FALSE);
                    } else {
                        list.add(selectedInfoMapUrl);
                        list.add(selectedValueProvider);
                        list.add(Boolean.TRUE);
                    }
                }
            }
        } else if (promptValueProvider instanceof PromptColumnValueProvider) {
            String selectedTableUrl = ((PromptColumnValueProvider)selectedValueProvider).getTableUrl();
            String promptTableUrl = ((PromptColumnValueProvider)promptValueProvider).getTableUrl();
            try {
                PhysicalTableInterface tableURL = this.dataProvider.getPhysicalTable(promptTableUrl);
                if (tableURL != null && selectedTableUrl != null && promptTableUrl != null) {
                    if (!selectedTableUrl.equals(promptTableUrl)) {
                        list.add(promptTableUrl);
                        list.add(promptValueProvider);
                        list.add(Boolean.FALSE);
                    } else {
                        list.add(selectedTableUrl);
                        list.add(selectedValueProvider);
                        list.add(Boolean.TRUE);
                    }
                }
            }
            catch (ServerConnectionException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    private ValueItem createPhysicalTableExpressionValueItem(Expression modelExpression) {
        ValueItem expressionValueItem = new ValueItem();
        try {
            ValueItem operand = (ValueItem)this.operandCombo.getSelectedItem();
            PhysicalTableInterface table = this.dataProvider.getPhysicalTable(this.url);
            ColumnNamesValueProvider columnNamesValueProvider = new ColumnNamesValueProvider(this.url);
            PromptGroup promptGroup = new PromptGroup();
            PromptValues promptValues = new PromptValues((PromptGroupInterface)promptGroup);
            DynamicPromptValueContext dynamicValueContext = new DynamicPromptValueContext((PromptValuesInterface)promptValues, (PromptGroupInterface)promptGroup, null, (DataProviderInterface)this.dataProvider);
            List listValues = (List)columnNamesValueProvider.getValues(this.getLocale(), (DynamicPromptValueContextInterface)dynamicValueContext, ValueType.LIST);
            long selectedPromptDataType = 0L;
            if (this.currentPrompt != null) {
                selectedPromptDataType = PromptDefinitionEnum.getDataType((PromptDefinitionInterface)this.currentPrompt);
            }
            int listSize = listValues.size();
            for (int i = listSize - 1; i >= 0; --i) {
                ValueItem vItem = (ValueItem)listValues.get(i);
                boolean accept = false;
                long colType = ((DataSourceColumnInterface)vItem.getValue()).getColumnType();
                accept = PromptUtility.isColumnValidForPromptDataType(selectedPromptDataType, colType);
                if (accept) continue;
                listValues.remove(i);
            }
            if (listValues.size() > 0) {
                String tableName = table.getName();
                if (tableName != null && null != this.columnCombo.getSelectedItem()) {
                    String columnLabel = ((ValueItem)this.columnCombo.getSelectedItem()).getLabel();
                    String tableDisplayName = tableName + "." + columnLabel + "  " + operand.getLabel() + " " + Message.format((String)VALUE_OF_KEY, (Object)this.promptLabel.getText());
                    this.logger.debug("createPhysicalTableExpr(),tableDisplayName=", tableDisplayName);
                    expressionValueItem.setLabel(tableDisplayName);
                    expressionValueItem.setValue((Object)modelExpression);
                } else {
                    this.logger.warn("createPhysicalTableExpr(), tableName or selectedItem was null.");
                }
            } else {
                this.logger.warn("invalid dependency removed.");
            }
        }
        catch (ServerConnectionException sce) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(sce.getMessage(), (Throwable)sce);
        }
        catch (RemoteException re) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(re.getMessage(), (Throwable)re);
        }
        catch (ValueProviderException e) {
            e.printStackTrace();
        }
        return expressionValueItem;
    }

    private ValueItem createDependencyPhysicalTableExpressionValueItem(Expression modelExpression, PromptColumnValueProvider valueProvider, boolean includeCurrentPrompt) {
        ValueItem expressionValueItem = null;
        try {
            ColumnOperand columnOperand = null;
            PromptValueOperand promptOperand = null;
            List operands = modelExpression.getOperands();
            for (Object o : operands) {
                if (o instanceof PromptValueOperand) {
                    promptOperand = (PromptValueOperand)o;
                    continue;
                }
                if (!(o instanceof ColumnOperand)) continue;
                columnOperand = (ColumnOperand)o;
            }
            if (columnOperand != null && promptOperand != null) {
                PromptDefinitionInterface promptOperandDefinition = promptOperand.getPromptDefinition();
                if (includeCurrentPrompt || !includeCurrentPrompt && promptOperandDefinition == this.communicator.getOriginalPrompt()) {
                    String url = valueProvider.getTableUrl();
                    PhysicalTableInterface table = this.dataProvider.getPhysicalTable(url);
                    String tableName = "";
                    if (table != null) {
                        tableName = table.getName();
                    }
                    if (this.rootPromptGroup.hasPromptDefinition(promptOperandDefinition)) {
                        ColumnNamesValueProvider columnNamesValueProvider = new ColumnNamesValueProvider(url);
                        PromptGroup promptGroup = new PromptGroup();
                        PromptValues promptValues = new PromptValues((PromptGroupInterface)promptGroup);
                        DynamicPromptValueContext dynamicValueContext = new DynamicPromptValueContext((PromptValuesInterface)promptValues, (PromptGroupInterface)promptGroup, null, (DataProviderInterface)this.dataProvider);
                        String columnName = columnOperand.getColumnName();
                        List listValues = (List)columnNamesValueProvider.getValues(this.getLocale(), (DynamicPromptValueContextInterface)dynamicValueContext, ValueType.LIST);
                        long selectedPromptDataType = 0L;
                        if (this.currentPrompt != null) {
                            selectedPromptDataType = PromptDefinitionEnum.getDataType((PromptDefinitionInterface)this.currentPrompt);
                        }
                        if (listValues.size() > 0) {
                            long columnType = 0L;
                            boolean found = false;
                            for (ValueItem item : listValues) {
                                String valueColumnName = ((DataSourceColumnInterface)item.getValue()).getColumnName();
                                if (!columnName.equalsIgnoreCase(valueColumnName)) continue;
                                columnType = ((DataSourceColumnInterface)item.getValue()).getColumnType();
                                found = true;
                            }
                            if (!found) {
                                this.invalidDataItems.add(columnName);
                                return null;
                            }
                            String promptLabel = promptOperand.getPromptDefinition().getPromptLabel(this.getLocale());
                            OperatorInterface operator = modelExpression.getOperator();
                            List comparisonOperators = this.getOperatorsForPhysicalColumn(columnType, promptOperand.getPromptDefinition());
                            String operatorLabel = this.getLabelFromFormattedOperator(comparisonOperators, operator);
                            if (tableName != null) {
                                expressionValueItem = new ValueItem();
                                String tableDisplayName = tableName + "." + columnName + "  " + operatorLabel + " " + Message.format((String)VALUE_OF_KEY, (Object)promptLabel);
                                expressionValueItem.setLabel(promptLabel);
                                expressionValueItem.setValue((Object)tableDisplayName);
                            }
                        }
                    }
                }
            }
        }
        catch (ServerConnectionException sce) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(sce.getMessage(), (Throwable)sce);
        }
        catch (ValueProviderException vpe) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(vpe.getMessage(), (Throwable)vpe);
        }
        catch (RemoteException re) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(re.getMessage(), (Throwable)re);
        }
        return expressionValueItem;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return null;
    }

    private String getLabelFromFormattedOperator(List operators, OperatorInterface operator) {
        for (ValueItem valueItem : operators) {
            if (operator != valueItem.getValue()) continue;
            return valueItem.getLabel();
        }
        return "";
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int selectedRow;
        Object o;
        if (e.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (!lsm.isSelectionEmpty() && (o = this.tableView.getValueAt(selectedRow = this.rowSM.getMinSelectionIndex(), 1)) != null && o instanceof ValueItem) {
            Expression expression = (Expression)((ValueItem)o).getValue();
            ColumnOperand columnOperand = null;
            PromptValueOperand promptOperand = null;
            List operands = expression.getOperands();
            int operandsSize = operands.size();
            for (int j = 0; j < operandsSize; ++j) {
                Object operand = operands.get(j);
                if (operand instanceof PromptValueOperand) {
                    promptOperand = (PromptValueOperand)operand;
                    continue;
                }
                if (!(operand instanceof ColumnOperand)) continue;
                columnOperand = (ColumnOperand)operand;
            }
            PromptDefinitionInterface selectedPrompt = promptOperand.getPromptDefinition();
            OperatorInterface operator = expression.getOperator();
            if (selectedPrompt != null && this.currentPrompt != null && selectedPrompt instanceof ValueProviderDefinitionInterface) {
                ValueProviderInterface selectedValueProvider = ((ValueProviderDefinitionInterface)selectedPrompt).getValueProvider();
                List dataSourceInfo = this.getDataSource(selectedValueProvider, this.currentPromptValueProvider);
                ValueProviderInterface valueProvider = (ValueProviderInterface)dataSourceInfo.get(1);
                boolean sameDataSource = (Boolean)dataSourceInfo.get(2);
                this.enableColumnAndOperandListeners(false);
                this.enableColumnAndOperandCombos(true);
                this.columnComboModel.removeAllElements();
                this.operandComboModel.removeAllElements();
                this.promptForExpression = selectedPrompt;
                if (valueProvider instanceof RelationalDataItemValueProvider) {
                    try {
                        ValueItem selectedItem;
                        DataItem dataItem = null;
                        this.url = (String)dataSourceInfo.get(0);
                        InfoMapItemsValueProvider infoMapValueItemsValueProvider = new InfoMapItemsValueProvider();
                        infoMapValueItemsValueProvider.setInfoMapUrl(this.url);
                        infoMapValueItemsValueProvider.setDataProvider((DataProviderInterface)this.dataProvider);
                        List values = (List)infoMapValueItemsValueProvider.getValues(this.getLocale(), ValueType.LIST, 0, -1);
                        String currentDataItemId = columnOperand.getColumnName();
                        if (sameDataSource) {
                            selectedItem = this.pruneRelationalListForCompatiblePrompts(selectedPrompt, values, currentDataItemId);
                            if (selectedItem != null) {
                                this.columnComboModel.setSelectedItem(selectedItem);
                            }
                            dataItem = ((DataProvider)this.dataProvider).getDataItemFromId(this.url, currentDataItemId);
                            this.populateOperandComboForInfoMap(dataItem, selectedPrompt);
                        } else {
                            selectedItem = this.pruneRelationalListForCompatiblePrompts(selectedPrompt, values, currentDataItemId);
                            if (selectedItem != null) {
                                this.columnComboModel.setSelectedItem(selectedItem);
                            }
                            this.populateOperandComboForInfoMap(this.getValueDataItem(currentDataItemId), selectedPrompt);
                        }
                        this.promptLabel.setText(selectedPrompt.getPromptLabel(this.getLocale()));
                    }
                    catch (ValueProviderException vpe) {
                        LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(vpe.getMessage());
                    }
                    catch (ServerConnectionException sce) {
                        LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(sce.getMessage());
                    }
                } else if (valueProvider instanceof PromptColumnValueProvider) {
                    try {
                        String columnName = columnOperand.getColumnName();
                        this.populateColumnModelFromTable(columnName, selectedPrompt, dataSourceInfo, sameDataSource);
                    }
                    catch (ValueProviderException vpe) {
                        LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(vpe.getMessage(), (Throwable)vpe);
                    }
                }
                for (int i = 0; i <= this.operandComboModel.getSize(); ++i) {
                    ValueItem operandValueItem = (ValueItem)this.operandComboModel.getElementAt(i);
                    if (operandValueItem == null || operandValueItem.getValue() != operator) continue;
                    this.operandCombo.setSelectedItem((Object)operandValueItem);
                    break;
                }
                this.enableColumnAndOperandListeners(true);
            }
        }
    }

    public WhereClause getWhereClause() {
        int expressionCount;
        WhereClause whereClause = null;
        this.setContentsValid(true);
        ArrayList<Object> expressions = new ArrayList<Object>();
        ArrayList<String> promptsInError = new ArrayList<String>();
        boolean showAllMessage = false;
        int tableSize = this.tableView.getModel().getRowCount();
        for (int i = 0; i < tableSize; ++i) {
            Object o = this.tableView.getValueAt(i, 1);
            if (o == null || !(o instanceof ValueItem)) continue;
            if (this.currentPromptValueProvider instanceof RelationalDataItemValueProvider) {
                Object exprObj = ((ValueItem)o).getValue();
                if (!(exprObj instanceof Expression)) continue;
                List operands = ((Expression)exprObj).getOperands();
                int operandsSize = operands.size();
                PromptValueOperand promptOperand = null;
                for (int j = 0; j < operandsSize; ++j) {
                    Object operandsObj = operands.get(j);
                    if (!(operandsObj instanceof PromptValueOperand)) continue;
                    promptOperand = (PromptValueOperand)operandsObj;
                }
                if (promptOperand == null) continue;
                PromptDefinitionInterface prompt = promptOperand.getPromptDefinition();
                if (prompt instanceof SupportedSpecialValuesInterface) {
                    SupportedSpecialValues support = ((SupportedSpecialValuesInterface)prompt).getSupportedSpecialValues();
                    if (support.isAllSupported()) {
                        showAllMessage = true;
                        promptsInError.add(prompt.getPromptLabel(this.locale));
                        continue;
                    }
                    expressions.add(((ValueItem)o).getValue());
                    continue;
                }
                expressions.add(((ValueItem)o).getValue());
                continue;
            }
            expressions.add(((ValueItem)o).getValue());
        }
        if (showAllMessage) {
            this.setContentsValid(false);
            this.firePropertyChange("errorPanel", null, "DependenciesPanel");
            Object[] argsArray = new String[2];
            argsArray[0] = this.currentPrompt.getPromptLabel(this.locale);
            String argString = "";
            for (int i = 0; i < promptsInError.size(); ++i) {
                argString = argString + "{" + i + "}\n";
            }
            argsArray[1] = argString;
            String tempMessage = MessageFormat.format(RB.getStringResource("invalidAllDependency.fmt.txt"), argsArray);
            String messageString = MessageFormat.format(tempMessage, promptsInError.toArray());
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)PromptUtility.getParentFrame(this.communicator, this), new Message(messageString), null);
            }
        }
        if ((expressionCount = expressions.size()) == 1) {
            whereClause = new WhereClause();
            whereClause.setCondition((OperandInterface)((Expression)expressions.get(0)));
        } else if (expressionCount > 1) {
            whereClause = new WhereClause();
            whereClause.setCondition((OperandInterface)Expression.newAndedExpression(expressions, (LoggerFactoryInterface)this.communicator.getLoggerFactory()));
        }
        try {
            if (!this.userDefinedDataProvider) {
                ((DataProvider)this.dataProvider).close();
            }
        }
        catch (ServerConnectionException sce) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(sce.getMessage(), (Throwable)sce);
        }
        return whereClause;
    }

    ValueItem pruneRelationalListForCompatiblePrompts(PromptDefinitionInterface selectedPrompt, List values, String currentDataItemId) {
        ValueItem selectedItem = null;
        long selectedPromptDataType = PromptDefinitionEnum.getDataType((PromptDefinitionInterface)selectedPrompt);
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            boolean accept = false;
            ValueItem vItem = (ValueItem)iter.next();
            String dataItemId = ((DataSourceColumnInterface)vItem.getValue()).getColumnName();
            try {
                DataItem candidate = ((DataProvider)this.dataProvider).getDataItemFromId(this.url, dataItemId);
                long type = candidate.getExpressionTypeIgnoringFormattingForced();
                accept = PromptUtility.isDataItemValidForPromptDataType(selectedPromptDataType, type);
            }
            catch (ServerConnectionException e) {
                e.printStackTrace();
            }
            if (!accept) continue;
            if (currentDataItemId != null && currentDataItemId.equals(dataItemId)) {
                selectedItem = vItem;
            }
            this.logger.debug("!sameDataSource, added candidate=", vItem.getLabel());
            this.columnComboModel.addElement(vItem);
        }
        return selectedItem;
    }

    ValueItem prunePromptColumnListForCompatiblePrompts(PromptDefinitionInterface selectedPrompt, List values, String columnName) {
        long selectedPromptDataType = PromptDefinitionEnum.getDataType((PromptDefinitionInterface)selectedPrompt);
        ValueItem selectedItem = null;
        this.logger.debug("name=", selectedPrompt.getPromptName());
        for (ValueItem vItem : values) {
            String valueColumnName = ((DataSourceColumnInterface)vItem.getValue()).getColumnName();
            boolean accept = false;
            long colType = ((DataSourceColumnInterface)vItem.getValue()).getColumnType();
            accept = PromptUtility.isColumnValidForPromptDataType(selectedPromptDataType, colType);
            if (!accept) continue;
            if (columnName != null && columnName.equals(valueColumnName)) {
                selectedItem = vItem;
            }
            this.logger.debug("added column name=", valueColumnName);
            this.columnComboModel.addElement(vItem);
        }
        return selectedItem;
    }
}

