/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.models.itemlistmanager.ILMTableModel;
import com.sas.prompts.visuals.swing.designtime.PromptPanelConstantsInterface;
import java.util.Date;

public class DefaultValuesTableModel
extends ILMTableModel
implements PromptPanelConstantsInterface {
    private String modelType;
    private String selectionType;
    private boolean disableRendering;
    private static final long serialVersionUID = 3257563988660598326L;

    public DefaultValuesTableModel(String modelType, String selectionType) {
        this.modelType = modelType;
        this.selectionType = selectionType;
        this.disableRendering = false;
    }

    public void disableBooleanRendering(boolean disableRendering) {
        this.disableRendering = disableRendering;
    }

    public Class getColumnClass(int c) {
        if (c == 0) {
            if (this.modelType.equals("Text")) {
                return String.class;
            }
            if (this.modelType.equals("Integer")) {
                return Integer.class;
            }
            if (this.modelType.equals("Numeric")) {
                return Double.class;
            }
            if (this.modelType.equals("Date")) {
                return Date.class;
            }
            return super.getColumnClass(c);
        }
        if (c == 2) {
            return Boolean.class;
        }
        return super.getColumnClass(c);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return super.getValueAt(rowIndex, columnIndex);
    }

    public void setValueAt(Object value, int row, int col) {
        if (col == 2 && this.selectionType.equals("Single value") && Boolean.TRUE.equals(value)) {
            int rowCount = this.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                Object isSelected = this.getValueAt(i, 2);
                if (!Boolean.TRUE.equals(isSelected)) continue;
                super.setValueAt((Object)Boolean.FALSE, i, 2);
                break;
            }
        }
        super.setValueAt(value, row, col);
    }

    public boolean isCellEditable(int row, int column) {
        if (column == 0 || column == 1) {
            Object o = this.getValueAt(row, 0);
            return o != SpecialValues.ALL && o != SpecialValues.OTHER && o != MissingValues.Dot && o != MissingValues._BLANK_;
        }
        return true;
    }
}

