/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.DateDefinition;
import com.sas.prompts.definitions.DateDefinitionInterface;
import com.sas.prompts.definitions.MutableDateDefinitionInterface;
import com.sas.prompts.definitions.MutableSelectableDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.prompts.groups.HorizontalGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BaseDynamicListPanel;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionInterface;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionWithErrorSuppressionOptionInterface;
import com.sas.prompts.visuals.swing.designtime.PromptGroupUtility;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.text.Message;
import com.sas.util.DateTypes;
import com.sas.util.MutableSupportedSpecialValuesInterface;
import com.sas.util.Strings;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Date;
import javax.swing.JPanel;

class DateDynamicListPanel
extends BaseDynamicListPanel {
    private PromptValues promptValuesMinMax;
    private PromptPropertiesPanel promptPropertiesPanelMinMax;
    private DateDefinition datePrompt;
    private DateDefinition promptMaxValue;
    private DateDefinition promptMinValue;
    private DateTypes dateType;
    private static final long serialVersionUID = 3257563988660598326L;

    public DateDynamicListPanel(DateDefinitionInterface prompt, String selectionType, DateTypes dateType, PropertiesCommunicator communicator) {
        super((PromptDefinitionInterface)prompt, selectionType, communicator);
        this.dateType = dateType;
        this.createPromptPanel();
    }

    @Override
    protected void createPromptPanel() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 0, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        TransparentGroup promptGroupMinMax = new TransparentGroup();
        HorizontalGroup horizontalGroupMinMax = new HorizontalGroup();
        this.promptMinValue = new DateDefinition("");
        this.promptMinValue.setPromptLabel(RB.getStringResource("minValue.txt"), this.getLocale());
        this.promptMinValue.setDateType(this.dateType);
        PromptUtility.setMinRelativeOptions((MutableDateDefinitionInterface)this.promptMinValue);
        horizontalGroupMinMax.addPromptDefinition((PromptDefinitionInterface)this.promptMinValue);
        this.promptMaxValue = new DateDefinition("");
        this.promptMaxValue.setPromptLabel(RB.getStringResource("maxValue.txt"), this.getLocale());
        this.promptMaxValue.setDateType(this.dateType);
        PromptUtility.setMaxRelativeOptions((MutableDateDefinitionInterface)this.promptMaxValue);
        horizontalGroupMinMax.addPromptDefinition((PromptDefinitionInterface)this.promptMaxValue);
        promptGroupMinMax.addPromptSubgroup((PromptGroupInterface)horizontalGroupMinMax);
        this.promptValuesMinMax = new PromptValues((PromptGroupInterface)promptGroupMinMax, null);
        PromptUtility.configurePromptValuesForDates(this.promptValuesMinMax, this.prompt, (DateDefinitionInterface)this.promptMinValue, (DateDefinitionInterface)this.promptMaxValue, this.communicator, this.dateType, this.getLocale());
        this.promptPropertiesPanelMinMax = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesMinMax, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelMinMax);
        JPanel outerDatasourcePanel = this.createDatasourcePanel();
        this.createCustomPanel();
        this.customPanel.addPropertyChangeListener(this);
        this.communicator.addPropertyChangeListener(this);
        if (this.promptValuesValueCount != null) {
            this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
        }
        if (this.selectionType != "Single value") {
            this.add(this.promptPropertiesPanelValueCount);
        }
        this.add(this.promptPropertiesPanelMinMax);
        this.add(this.createMaximumDisplayValues());
        this.add(outerDatasourcePanel);
        this.createHolderPanel().add(this.customPanel);
        this.add(this.holderPanel);
        this.add(this.createAllowCustomValuesCheckBox());
    }

    @Override
    protected PromptDefinitionInterface intializePrompt() {
        if (this.prompt == null) {
            DateDefinition dateDefinitionPrompt = new DateDefinition();
            dateDefinitionPrompt.setAllowUserValues(false);
            dateDefinitionPrompt.setDateType(this.dateType);
            if (this.selectionType != "Single value") {
                dateDefinitionPrompt.setMaximumValueCount(Integer.MAX_VALUE);
            }
            if (this.selectionType.equals("Multiple ordered values")) {
                dateDefinitionPrompt.setSelectionOrdered(true);
            }
            return dateDefinitionPrompt;
        }
        if (this.prompt instanceof MutableDateDefinitionInterface) {
            return (MutableDateDefinitionInterface)this.prompt;
        }
        return (DateDefinitionInterface)this.prompt;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        this.setContentsValid(true);
        this.promptValuesMinMax.removePromptValueChangeListener((PromptValueChangeListener)this);
        if (this.promptValuesValueCount != null) {
            this.promptValuesValueCount.removePromptValueChangeListener((PromptValueChangeListener)this);
        }
        this.datePrompt = (DateDefinition)PromptUtility.newConfiguredPrompt(this.communicator, "DateDefinition");
        this.datePrompt.setDateType(this.dateType);
        ValueProviderDefinitionInterface selectablePrompt = null;
        selectablePrompt = this.customPanel instanceof GetPromptDefinitionWithErrorSuppressionOptionInterface ? (ValueProviderDefinitionInterface)((GetPromptDefinitionWithErrorSuppressionOptionInterface)((Object)this.customPanel)).getPromptDefinition(suppressErrors) : (ValueProviderDefinitionInterface)((GetPromptDefinitionInterface)((Object)this.customPanel)).getPromptDefinition();
        ValueProviderInterface valueProvider = null;
        if (this.selectionType != "Single value") {
            this.datePrompt.setMaximumValueCount(Integer.MAX_VALUE);
        }
        if (this.selectionType.equals("Multiple ordered values")) {
            this.datePrompt.setSelectionOrdered(true);
        }
        valueProvider = selectablePrompt.getValueProvider();
        try {
            Integer pageSize;
            if (this.promptValuesMaxDisplay != null && this.promptValuesMaxDisplay.isPromptValueAvailable((PromptDefinitionInterface)this.promptMaxDisplay) && (pageSize = (Integer)this.promptValuesMaxDisplay.getPromptValue((PromptDefinitionInterface)this.promptMaxDisplay)) != null) {
                this.datePrompt.setPageSize(pageSize.intValue());
            }
        }
        catch (PromptValueNotFoundException pvnf) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
        }
        if (valueProvider != null) {
            this.datePrompt.setValueProvider(valueProvider);
        }
        try {
            if (this.promptValuesMinMax.isPromptValueAvailable((PromptDefinitionInterface)this.promptMinValue)) {
                Date minValue = (Date)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMinValue);
                this.datePrompt.setMinimum(minValue);
            }
            if (this.promptValuesMinMax.isPromptValueAvailable((PromptDefinitionInterface)this.promptMaxValue)) {
                Date maxValue = (Date)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMaxValue);
                this.datePrompt.setMaximum(maxValue);
            }
            if (this.selectionType != "Single value") {
                PromptGroupUtility.setMinValueCountFromPromptValue((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMinValueCount, (MutableSelectableDefinitionInterface)this.datePrompt);
                PromptGroupUtility.setMaxValueCountFromPromptValue((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMaxValueCount, (MutableSelectableDefinitionInterface)this.datePrompt);
            }
            if (selectablePrompt instanceof MutableSupportedSpecialValuesInterface) {
                SupportedSpecialValues supportedSpecialValues = ((MutableSupportedSpecialValuesInterface)selectablePrompt).getSupportedSpecialValues();
                this.datePrompt.setSupportedSpecialValues(supportedSpecialValues);
            }
            if (((PromptDefinitionInterface)selectablePrompt).isDefaultValueSet()) {
                this.datePrompt.setDefaultValue(((PromptDefinitionInterface)selectablePrompt).getDefaultValue());
            } else {
                this.datePrompt.clearDefaultValue();
            }
            this.datePrompt.setAllowUserValues(this.allowCustomValuesCheckBox.isSelected());
        }
        catch (IllegalArgumentException exception) {
            if (!suppressErrors) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(exception.getMessage());
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)exception.getMessage())), null);
                }
                this.setContentsValid(false);
                this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
                if (this.promptValuesValueCount != null) {
                    this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
                }
            }
            try {
                if (!this.isUserDefinedDataProvider()) {
                    ((DataProvider)this.dataProvider).close();
                }
            }
            catch (ServerConnectionException sce) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(sce.getMessage());
            }
            return this.datePrompt;
        }
        catch (PromptValueNotFoundException pvnf) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
        }
        Collection errors = this.datePrompt.validateDefinition(this.getLocale());
        if (errors.size() > 0 && !suppressErrors) {
            String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
            }
            this.setContentsValid(false);
            if (this.promptValuesValueCount != null) {
                this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
            }
            this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
        }
        try {
            if (!this.isUserDefinedDataProvider()) {
                ((DataProvider)this.dataProvider).close();
            }
        }
        catch (ServerConnectionException sce) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(sce.getMessage());
        }
        return this.datePrompt;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.getPromptDefinition(false);
    }

    @Override
    protected void verifyContentsValid() {
        boolean isValid = false;
        isValid = this.promptValuesValueCount != null ? this.promptPropertiesPanelMinMax.isContentsValid() && this.promptPropertiesPanelValueCount.isContentsValid() : this.promptPropertiesPanelMinMax.isContentsValid();
        this.setContentsValid(isValid);
    }
}

