/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.datatypes.DataSourceType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.models.datasources.DataSourceColumnInterface;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.models.itemlistmanager.ItemListManagerViewerInterface;
import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.DynamicPromptValueContext;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.DataSourceColumnDefinition;
import com.sas.prompts.definitions.DataSourceColumnDefinitionInterface;
import com.sas.prompts.definitions.IntegerDefinition;
import com.sas.prompts.definitions.IntegerDefinitionInterface;
import com.sas.prompts.definitions.MutableSelectableDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.prompts.groups.TransparentGroupInterface;
import com.sas.prompts.util.remote.DynamicPromptValueValidator;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.PromptDataProviderInterface;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BasePromptTypesAndValuesPanel;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionWithErrorSuppressionOptionInterface;
import com.sas.prompts.visuals.swing.designtime.PromptGroupUtility;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.swing.visuals.DataSourcePicker;
import com.sas.swing.visuals.DataSourceUtil;
import com.sas.swing.visuals.EditorInterface;
import com.sas.swing.visuals.EditorListener;
import com.sas.swing.visuals.ValueListEditor;
import com.sas.swing.visuals.tableview.DefaultTableCellRenderer;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.transforms.DataTypeToDisplayStringTransform;
import com.sas.util.transforms.TransformInterface;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellRenderer;

class DataSourceColumnPanel
extends BasePromptTypesAndValuesPanel
implements ItemListener,
EditorListener,
PropertyChangeListener,
PromptValueChangeListener,
GetPromptDefinitionWithErrorSuppressionOptionInterface {
    private boolean userDefinedDataProvider = false;
    private String selectionType;
    protected PromptValues promptValuesValueCount;
    protected PromptPropertiesPanel promptPropertiesPanelValueCount;
    protected IntegerDefinition promptMinValueCount;
    protected IntegerDefinition promptMaxValueCount;
    private PromptValues promptValuesDefaultValue;
    private DataSourceColumnDefinitionInterface prompt;
    private DataSourceColumnDefinition promptDefaultValue;
    private DataSourceColumnDefinition dataSourceColumnDefinition;
    private PromptPropertiesPanel promptPropertiesPanelDefaultValue;
    private JCheckBox allowColumnsFromMultipleDataSources;
    private JCheckBox characterColumnTypeCheckBox;
    private JCheckBox numericColumnTypeCheckBox;
    private JCheckBox dateColumnTypeCheckBox;
    private JCheckBox timeColumnTypeCheckBox;
    private JCheckBox timestampColumnTypeCheckBox;
    private JCheckBox tablesCheckBox;
    private JCheckBox infoMapCheckBox;
    private List dataSources;
    private PromptDataProviderInterface dataProvider;
    private ValueListEditor valueListEditor;
    private DataSourcePicker datasourcePicker;
    private static final long serialVersionUID = 3257563988660598326L;

    public DataSourceColumnPanel(DataSourceColumnDefinitionInterface prompt, PropertiesCommunicator communicator) {
        this(prompt, null, communicator);
    }

    public DataSourceColumnPanel(String selectionType, PropertiesCommunicator communicator) {
        this(null, selectionType, communicator);
    }

    DataSourceColumnPanel(DataSourceColumnDefinitionInterface prompt, String selectionType, PropertiesCommunicator communicator) {
        super(communicator);
        this.prompt = prompt;
        this.selectionType = prompt != null ? this.convertSelectionType(prompt.getSelectionType()) : (selectionType != null ? selectionType : "Single value");
        this.dataSources = new ArrayList();
        this.initializePanel();
        communicator.addPropertyChangeListener(this);
        if (this.promptValuesValueCount != null) {
            this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
        }
    }

    private void initializePanel() {
        Object o;
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 0, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        JPanel listPanel = new JPanel();
        AutoSizingGridLayout listPanelLayout = new AutoSizingGridLayout(2, 1, 0, 5, true, false, true);
        listPanel.setLayout((LayoutManager)listPanelLayout);
        boolean defaultValueValid = true;
        if (this.selectionType != "Single value") {
            TransparentGroupInterface promptGroupValueCount = PromptGroupUtility.newGroupForMinMaxValueCount(this.getLocale(), this.getLoggerFactory());
            this.promptMinValueCount = (IntegerDefinition)promptGroupValueCount.getPromptDefinition(PromptGroupUtility.MIN_VALUE_COUNT, true);
            this.promptMaxValueCount = (IntegerDefinition)promptGroupValueCount.getPromptDefinition(PromptGroupUtility.MAX_VALUE_COUNT, true);
            this.promptValuesValueCount = new PromptValues((PromptGroupInterface)promptGroupValueCount, null);
            PromptUtility.configurePromptValuesForMinMaxCount(this.promptValuesValueCount, (PromptDefinitionInterface)this.prompt, (IntegerDefinitionInterface)this.promptMinValueCount, (IntegerDefinitionInterface)this.promptMaxValueCount, this.communicator);
            this.promptPropertiesPanelValueCount = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesValueCount, this.getLocale());
            PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelValueCount);
        }
        JPanel dataSourceTypesPanel = new JPanel();
        AutoSizingGridLayout dataSourceTypesLayout = new AutoSizingGridLayout(1, 2, 0, 5, true, false, false);
        dataSourceTypesPanel.setLayout((LayoutManager)dataSourceTypesLayout);
        TitledBorder titledBorder1 = BorderFactory.createTitledBorder(RB.getStringResource("dataSourceTypes.txt"));
        dataSourceTypesPanel.setBorder(titledBorder1);
        this.tablesCheckBox = new JCheckBox(RB.getStringResource("physicalTables.txt"));
        this.infoMapCheckBox = new JCheckBox(RB.getStringResource("relationalMaps.txt"));
        this.tablesCheckBox.setSelected(true);
        this.infoMapCheckBox.setSelected(true);
        dataSourceTypesPanel.add(this.tablesCheckBox);
        dataSourceTypesPanel.add(this.infoMapCheckBox);
        JLabel datasourcesLabel = new JLabel(RB.getStringResource("dataSources.txt"));
        PromptDataProviderInterface userDataProvider = this.communicator.getDataProvider();
        if (userDataProvider != null) {
            this.dataProvider = userDataProvider;
            this.userDefinedDataProvider = true;
        } else {
            this.dataProvider = new DataProvider(this.communicator.getUserContext());
        }
        this.datasourcePicker = new DataSourcePicker(this.communicator.getUserContext());
        this.datasourcePicker.setAllowedDataSources(5L);
        try {
            this.datasourcePicker.setInitialPossibleValues(PromptUtility.getReferencedDataSources(this.communicator.getRootPromptGroup(), -1L, this.communicator.getUserContext(), this.dataProvider));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setShowSelectionWhenFocusAndEditable(true);
        DataTypeToDisplayStringTransform transform = new DataTypeToDisplayStringTransform((DataTypeInterface)DataSourceType.DEFAULT_INSTANCE, this.getLocale());
        renderer.setTransform((TransformInterface)transform);
        this.valueListEditor = new ValueListEditor((EditorInterface)this.datasourcePicker);
        this.valueListEditor.setAllowDuplicates(false);
        this.valueListEditor.removeButton(ValueListEditor.BUTTON_EDIT);
        JButton addButton = (JButton)this.valueListEditor.getPredefinedButton(ItemListManagerViewerInterface.BUTTON_ADD, 0);
        addButton.setText(RB.getStringResource("addToList.txt"));
        addButton.setIcon(null);
        addButton.setMargin(null);
        JButton deleteButton = (JButton)this.valueListEditor.getPredefinedButton(ItemListManagerViewerInterface.BUTTON_DELETE, 0);
        deleteButton.setText(RB.getStringResource("delete.txt"));
        deleteButton.setIcon(null);
        deleteButton.setMargin(null);
        JButton moveUpButton = (JButton)this.valueListEditor.getPredefinedButton(ItemListManagerViewerInterface.BUTTON_MOVE_UP, 0);
        moveUpButton.setText(RB.getStringResource("moveUp.txt"));
        moveUpButton.setIcon(null);
        moveUpButton.setMargin(null);
        JButton moveDownButton = (JButton)this.valueListEditor.getPredefinedButton(ItemListManagerViewerInterface.BUTTON_MOVE_DOWN, 0);
        moveDownButton.setText(RB.getStringResource("moveDown.txt"));
        moveDownButton.setIcon(null);
        moveDownButton.setMargin(null);
        this.valueListEditor.getTable().setCellRenderer(-1, -1, (TableCellRenderer)renderer);
        this.valueListEditor.getTable().getClipboardAdapter().setTransform((TransformInterface)transform);
        JPanel columnTypePanel = new JPanel();
        AutoSizingGridLayout columnTypePanelLayout = new AutoSizingGridLayout(1, 2, 0, 5, true, false, false);
        columnTypePanel.setLayout((LayoutManager)columnTypePanelLayout);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(RB.getStringResource("columnTypes.txt"));
        columnTypePanel.setBorder(titledBorder);
        this.characterColumnTypeCheckBox = new JCheckBox(RB.getStringResource("character.txt"));
        this.numericColumnTypeCheckBox = new JCheckBox(RB.getStringResource("numeric.txt"));
        this.dateColumnTypeCheckBox = new JCheckBox(RB.getStringResource("date.txt"));
        this.timeColumnTypeCheckBox = new JCheckBox(RB.getStringResource("time.txt"));
        this.timestampColumnTypeCheckBox = new JCheckBox(RB.getStringResource("timestamp.txt"));
        columnTypePanel.add(this.characterColumnTypeCheckBox);
        columnTypePanel.add(this.numericColumnTypeCheckBox);
        columnTypePanel.add(this.dateColumnTypeCheckBox);
        columnTypePanel.add(this.timeColumnTypeCheckBox);
        columnTypePanel.add(this.timestampColumnTypeCheckBox);
        this.characterColumnTypeCheckBox.setSelected(true);
        Map savedProperties = this.communicator.getPromptProperties();
        JPanel allowColumnsPanel = new JPanel();
        AutoSizingGridLayout allowColumnsLayout = new AutoSizingGridLayout(1, 1, 0, 0, true, false, false);
        allowColumnsPanel.setLayout((LayoutManager)allowColumnsLayout);
        this.allowColumnsFromMultipleDataSources = new JCheckBox(RB.getStringResource("allowMultipleDataSource.txt"));
        if (this.selectionType != "Single value") {
            allowColumnsPanel.add(this.allowColumnsFromMultipleDataSources);
            if (!savedProperties.isEmpty() && savedProperties.containsKey("allowMultipleDataSources")) {
                Object o2 = savedProperties.get("allowMultipleDataSources");
                if (o2 != null) {
                    this.allowColumnsFromMultipleDataSources.setSelected((Boolean)o2);
                }
            } else if (this.prompt != null) {
                this.allowColumnsFromMultipleDataSources.setSelected(this.prompt.isAllowMultipleDataSources());
            }
        }
        TransparentGroup promptGroup = new TransparentGroup();
        this.promptDefaultValue = new DataSourceColumnDefinition("");
        if (this.selectionType != "Single value") {
            this.promptDefaultValue.setMaximumValueCount(Integer.MAX_VALUE);
            this.promptDefaultValue.setAllowMultipleDataSources(this.allowColumnsFromMultipleDataSources.isSelected());
            this.promptDefaultValue.setSelectionOrdered(true);
        }
        this.promptDefaultValue.setPromptLabel(RB.getStringResource("defaultValue.txt"), this.getLocale());
        this.promptDefaultValue.setAllowedColumnTypes(1L);
        promptGroup.addPromptDefinition((PromptDefinitionInterface)this.promptDefaultValue);
        this.promptValuesDefaultValue = new PromptValues((PromptGroupInterface)promptGroup, null);
        boolean dataSourcesSet = false;
        List promptDataSources = null;
        if (!savedProperties.isEmpty() && savedProperties.containsKey("DataSources")) {
            Object o3 = savedProperties.get("DataSources");
            if (o3 != null) {
                promptDataSources = (List)o3;
                dataSourcesSet = true;
            }
        } else if (this.prompt != null) {
            promptDataSources = this.prompt.getDataSources();
            boolean haveRemovedDataSources = false;
            if (promptDataSources != null) {
                int listSize = promptDataSources.size();
                for (int i = listSize - 1; i >= 0; --i) {
                    DataSourceInterface ds = (DataSourceInterface)promptDataSources.get(i);
                    try {
                        if (DataSourceUtil.getDataSource(this.communicator.getUserContext(), ds.getDataSourceLocation()) != null) continue;
                        promptDataSources.remove(i);
                        haveRemovedDataSources = true;
                        continue;
                    }
                    catch (ServiceException e) {
                        promptDataSources.remove(i);
                        continue;
                    }
                    catch (RemoteException e) {
                        promptDataSources.remove(i);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        promptDataSources.remove(i);
                    }
                }
            }
            if (haveRemovedDataSources) {
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)PromptUtility.getParentFrame(this.communicator, this), new Message(RB.getStringResource("removedDataSource.txt")), null);
                }
            }
            if (promptDataSources != null && promptDataSources.size() > 0) {
                dataSourcesSet = true;
            }
        }
        if (dataSourcesSet && promptDataSources != null) {
            this.dataSources = promptDataSources;
            this.valueListEditor.setValue((Object)this.dataSources);
        }
        boolean allowedDataSourcesSet = false;
        long allowedDataSourceTypes = -2L;
        if (!savedProperties.isEmpty() && savedProperties.containsKey("allowedDataSources")) {
            Object o4 = savedProperties.get("allowedDataSources");
            if (o4 != null) {
                allowedDataSourceTypes = (Long)o4;
            }
        } else if (this.prompt != null) {
            allowedDataSourceTypes = this.prompt.getAllowedDataSourceTypes();
        }
        if (allowedDataSourceTypes != -2L) {
            long finalAllowedDataSourceTypes = 0L;
            if ((allowedDataSourceTypes & 1L) == 1L) {
                finalAllowedDataSourceTypes |= 1L;
            }
            if ((allowedDataSourceTypes & 4L) == 4L) {
                finalAllowedDataSourceTypes |= 4L;
            }
            this.datasourcePicker.setAllowedDataSources(finalAllowedDataSourceTypes);
            allowedDataSourcesSet = true;
        }
        if (allowedDataSourcesSet) {
            this.tablesCheckBox.setSelected(this.isDataSourceAllowed(1L));
            this.infoMapCheckBox.setSelected(this.isDataSourceAllowed(4L));
        }
        boolean allowedColumnTypesSet = false;
        long allowedColumnTypes = 0L;
        if (!savedProperties.isEmpty() && savedProperties.containsKey("allowedColumnTypes")) {
            o = savedProperties.get("allowedColumnTypes");
            if (o != null) {
                allowedColumnTypes = (Long)o;
                allowedColumnTypesSet = true;
            }
        } else if (this.prompt != null) {
            allowedColumnTypes = this.prompt.getAllowedColumnTypes();
            allowedColumnTypesSet = true;
        }
        if (allowedColumnTypesSet) {
            this.characterColumnTypeCheckBox.setSelected(this.isColumnTypeAllowed(allowedColumnTypes, 1L));
            this.numericColumnTypeCheckBox.setSelected(this.isColumnTypeAllowed(allowedColumnTypes, 2L));
            this.dateColumnTypeCheckBox.setSelected(this.isColumnTypeAllowed(allowedColumnTypes, 4L));
            this.timeColumnTypeCheckBox.setSelected(this.isColumnTypeAllowed(allowedColumnTypes, 8L));
            this.timestampColumnTypeCheckBox.setSelected(this.isColumnTypeAllowed(allowedColumnTypes, 16L));
        } else {
            this.characterColumnTypeCheckBox.setSelected(true);
            this.numericColumnTypeCheckBox.setSelected(true);
            this.dateColumnTypeCheckBox.setSelected(true);
            this.timeColumnTypeCheckBox.setSelected(true);
            this.timestampColumnTypeCheckBox.setSelected(true);
        }
        if (allowedColumnTypesSet) {
            if (!savedProperties.isEmpty() && savedProperties.containsKey("DefaultValue")) {
                o = savedProperties.get("DefaultValue");
                if (o != null) {
                    if ("Single value".equals(this.selectionType)) {
                        Object defaultValue = null;
                        defaultValue = o instanceof List && ((List)o).size() > 0 ? ((List)o).get(0) : o;
                        if (defaultValue != null) {
                            this.processDefaultValue(defaultValue);
                        }
                    } else {
                        ArrayList defaultValues = null;
                        if (o instanceof List) {
                            this.processDefaultValue((List)o);
                        } else {
                            defaultValues = new ArrayList();
                            defaultValues.add(o);
                            this.processDefaultValue(defaultValues);
                        }
                    }
                }
            } else if (this.prompt != null) {
                try {
                    boolean defaultValueSet;
                    block66: {
                        this.promptDefaultValue.setAllowedDataSourceTypes(this.updateDataSourceTypes());
                        this.promptDefaultValue.setAllowedColumnTypes(this.updateColumnTypes());
                        this.promptDefaultValue.setDataSources(this.dataSources);
                        defaultValueSet = this.prompt.isDefaultValueSet();
                        if (this.prompt instanceof DataSourceColumnDefinition && defaultValueSet) {
                            Object defaultValue = this.prompt.getDefaultValue();
                            try {
                                DynamicPromptValueContext context = new DynamicPromptValueContext((PromptValuesInterface)this.promptValuesDefaultValue, (PromptGroupInterface)promptGroup, null, (DataProviderInterface)this.dataProvider);
                                DynamicPromptValueValidator validator = new DynamicPromptValueValidator((DynamicPromptValueContextInterface)context, this.getLocale());
                                validator.validateValue((PromptDefinitionInterface)this.prompt, defaultValue);
                            }
                            catch (InvalidPromptValueException e) {
                                defaultValueValid = false;
                                String message = RB.getStringResource("defaultValueDataItemDeleted.txt");
                                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(message);
                                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                                if (this.getGenericErrorHandler() == null) break block66;
                                this.getGenericErrorHandler().handleError((Object)PromptUtility.getParentFrame(this.communicator, this), new Message(message), null);
                            }
                        }
                    }
                    DataSourceColumnDefinitionInterface dataSourceColumnDefinitionInterface = this.prompt;
                    if (defaultValueSet && defaultValueValid) {
                        Object defaultValue = dataSourceColumnDefinitionInterface.getDefaultValue();
                        if (defaultValue instanceof List) {
                            int listSize = ((List)defaultValue).size();
                            ArrayList<DataSourceColumnInterface> savedDefaults = new ArrayList<DataSourceColumnInterface>();
                            for (int i = 0; i < listSize; ++i) {
                                DataSourceColumnInterface defaultValueDataSource = (DataSourceColumnInterface)((List)defaultValue).get(i);
                                long defaultValueColumnType = defaultValueDataSource.getColumnType();
                                DataSourceInterface dataSourceValue = defaultValueDataSource.getDataSource();
                                if (this.dataSources != null && this.dataSources.size() > 0) {
                                    if (!this.dataSources.contains(defaultValueDataSource.getDataSource()) || !this.isColumnTypeAllowed((DataSourceColumnDefinitionInterface)this.promptDefaultValue, defaultValueColumnType)) continue;
                                    savedDefaults.add(defaultValueDataSource);
                                    continue;
                                }
                                if (!this.isColumnTypeAllowed((DataSourceColumnDefinitionInterface)this.promptDefaultValue, defaultValueColumnType) || !this.isDataSourceAllowed(dataSourceValue.getDataSourceType())) continue;
                                savedDefaults.add(defaultValueDataSource);
                            }
                            if (savedDefaults.size() > 0) {
                                this.promptValuesDefaultValue.clearPromptValue((PromptDefinitionInterface)this.promptDefaultValue);
                                this.promptValuesDefaultValue.setPromptValue((PromptDefinitionInterface)this.promptDefaultValue, savedDefaults);
                            }
                        } else if (defaultValueValid) {
                            this.promptValuesDefaultValue.setPromptValue((PromptDefinitionInterface)this.promptDefaultValue, dataSourceColumnDefinitionInterface.getDefaultValue());
                        }
                    }
                }
                catch (InvalidPromptValueException ipve) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
                }
            }
        } else if (this.promptDefaultValue != null) {
            this.promptDefaultValue.setAllowedColumnTypes(this.updateColumnTypes());
        }
        this.promptPropertiesPanelDefaultValue = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesDefaultValue, (DataProviderInterface)this.dataProvider, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelDefaultValue);
        if (dataSourcesSet) {
            this.updateDefaultValuePanel(false);
        }
        this.tablesCheckBox.addItemListener(this);
        this.infoMapCheckBox.addItemListener(this);
        this.characterColumnTypeCheckBox.addItemListener(this);
        this.numericColumnTypeCheckBox.addItemListener(this);
        this.dateColumnTypeCheckBox.addItemListener(this);
        this.timeColumnTypeCheckBox.addItemListener(this);
        this.timestampColumnTypeCheckBox.addItemListener(this);
        this.valueListEditor.addEditorListener((EditorListener)this);
        this.datasourcePicker.addPropertyChangeListener(this);
        if (this.selectionType != "Single value") {
            this.add(this.promptPropertiesPanelValueCount);
        }
        this.add(dataSourceTypesPanel);
        this.add(datasourcesLabel);
        this.add((Component)this.valueListEditor);
        this.add(columnTypePanel);
        this.add(this.promptPropertiesPanelDefaultValue);
        if (this.selectionType != "Single value") {
            this.add(allowColumnsPanel);
            this.allowColumnsFromMultipleDataSources.addItemListener(this);
        }
    }

    private void processDefaultValue(Object defaultValue) {
        try {
            this.promptDefaultValue.setAllowedColumnTypes(this.updateColumnTypes());
            this.promptDefaultValue.setAllowedDataSourceTypes(this.updateDataSourceTypes());
            this.promptDefaultValue.setDataSources(this.dataSources);
            DataSourceColumnDefinition dataSourceColumnDefinitionInterface = new DataSourceColumnDefinition();
            this.promptValuesDefaultValue.setPromptValue((PromptDefinitionInterface)this.promptDefaultValue, defaultValue);
        }
        catch (InvalidPromptValueException ipve) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
        }
    }

    private void updateDefaultValuePanel(boolean clearCurrentValue) {
        if (clearCurrentValue) {
            this.promptValuesDefaultValue.clearPromptValue((PromptDefinitionInterface)this.promptDefaultValue);
        } else {
            try {
                if (this.promptValuesDefaultValue.isPromptValueAvailable((PromptDefinitionInterface)this.promptDefaultValue)) {
                    Object defaultValue = null;
                    defaultValue = this.promptValuesDefaultValue.getPromptValue((PromptDefinitionInterface)this.promptDefaultValue);
                    ArrayList<DataSourceColumnInterface> savedDefaults = new ArrayList<DataSourceColumnInterface>();
                    if (defaultValue != null) {
                        if (defaultValue instanceof List) {
                            int listSize = ((List)defaultValue).size();
                            for (int i = 0; i < listSize; ++i) {
                                DataSourceColumnInterface defaultValueDataSource = (DataSourceColumnInterface)((List)defaultValue).get(i);
                                long defaultValueColumnType = defaultValueDataSource.getColumnType();
                                DataSourceInterface dataSourceValue = defaultValueDataSource.getDataSource();
                                if (this.dataSources != null && this.dataSources.size() > 0) {
                                    if (!this.dataSources.contains(defaultValueDataSource.getDataSource()) || !this.isColumnTypeAllowed((DataSourceColumnDefinitionInterface)this.promptDefaultValue, defaultValueColumnType)) continue;
                                    savedDefaults.add(defaultValueDataSource);
                                    continue;
                                }
                                if (!this.isColumnTypeAllowed((DataSourceColumnDefinitionInterface)this.promptDefaultValue, defaultValueColumnType) || !this.isDataSourceAllowed(dataSourceValue.getDataSourceType())) continue;
                                savedDefaults.add(defaultValueDataSource);
                            }
                            if (savedDefaults.size() != listSize) {
                                this.promptValuesDefaultValue.clearPromptValue((PromptDefinitionInterface)this.promptDefaultValue);
                                this.promptValuesDefaultValue.setPromptValue((PromptDefinitionInterface)this.promptDefaultValue, savedDefaults);
                            }
                        }
                        if (defaultValue instanceof DataSourceColumnInterface) {
                            long defaultValueColumnType = ((DataSourceColumnInterface)defaultValue).getColumnType();
                            DataSourceInterface dataSourceValue = ((DataSourceColumnInterface)defaultValue).getDataSource();
                            if (this.dataSources != null && this.dataSources.size() > 0) {
                                if (this.dataSources.contains(((DataSourceColumnInterface)defaultValue).getDataSource())) {
                                    if (!this.isColumnTypeAllowed((DataSourceColumnDefinitionInterface)this.promptDefaultValue, defaultValueColumnType)) {
                                        this.promptValuesDefaultValue.clearPromptValue((PromptDefinitionInterface)this.promptDefaultValue);
                                    }
                                } else {
                                    this.promptValuesDefaultValue.clearPromptValue((PromptDefinitionInterface)this.promptDefaultValue);
                                }
                            } else if (!this.isColumnTypeAllowed((DataSourceColumnDefinitionInterface)this.promptDefaultValue, defaultValueColumnType) || !this.isDataSourceAllowed(dataSourceValue.getDataSourceType())) {
                                this.promptValuesDefaultValue.clearPromptValue((PromptDefinitionInterface)this.promptDefaultValue);
                            }
                        }
                    }
                }
            }
            catch (PromptValueNotFoundException pvnf) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).debug(pvnf.getMessage(), (Throwable)pvnf);
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).debug(ipve.getMessage(), (Throwable)ipve);
            }
        }
        this.promptDefaultValue.setAllowedDataSourceTypes(this.datasourcePicker.getAllowedDataSources());
        this.promptDefaultValue.setAllowedColumnTypes(this.updateColumnTypes());
        if (this.selectionType != "Single value") {
            this.promptDefaultValue.setAllowMultipleDataSources(this.allowColumnsFromMultipleDataSources.isSelected());
        }
        this.dataSources = (List)this.valueListEditor.getValue();
        this.promptDefaultValue.setDataSources(this.dataSources);
        this.promptPropertiesPanelDefaultValue.refresh((PromptDefinitionInterface)this.promptDefaultValue);
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelDefaultValue);
    }

    private boolean isColumnTypeAllowed(long allowedColumnTypes, long columnType) {
        if (allowedColumnTypes == -1L) {
            return true;
        }
        return (allowedColumnTypes & columnType) == columnType;
    }

    private boolean isColumnTypeAllowed(DataSourceColumnDefinitionInterface dscPrompt, long columnType) {
        long allowedColumnTypes = dscPrompt.getAllowedColumnTypes();
        if (allowedColumnTypes == -1L) {
            return true;
        }
        return (allowedColumnTypes & columnType) == columnType;
    }

    private boolean isDataSourceAllowed(long dataType) {
        long allowedDataTypes = this.datasourcePicker.getAllowedDataSources();
        if (allowedDataTypes == -1L) {
            return true;
        }
        return (allowedDataTypes & dataType) == dataType;
    }

    private long updateDataSourceTypes() {
        long dataSourceTypes = 0L;
        if (this.tablesCheckBox.isSelected() && this.infoMapCheckBox.isSelected()) {
            dataSourceTypes = 5L;
        } else if (this.tablesCheckBox.isSelected()) {
            dataSourceTypes = 1L;
        } else if (this.infoMapCheckBox.isSelected()) {
            dataSourceTypes = 4L;
        }
        return dataSourceTypes;
    }

    private long updateColumnTypes() {
        long columnTypes = 0L;
        if (this.characterColumnTypeCheckBox.isSelected()) {
            columnTypes |= 1L;
        }
        if (this.numericColumnTypeCheckBox.isSelected()) {
            columnTypes |= 2L;
        }
        if (this.dateColumnTypeCheckBox.isSelected()) {
            columnTypes |= 4L;
        }
        if (this.timeColumnTypeCheckBox.isSelected()) {
            columnTypes |= 8L;
        }
        if (this.timestampColumnTypeCheckBox.isSelected()) {
            columnTypes |= 0x10L;
        }
        return columnTypes;
    }

    private void enabledCheckBoxListeners(boolean enable) {
        this.characterColumnTypeCheckBox.removeItemListener(this);
        this.numericColumnTypeCheckBox.removeItemListener(this);
        this.dateColumnTypeCheckBox.removeItemListener(this);
        this.timeColumnTypeCheckBox.removeItemListener(this);
        this.timestampColumnTypeCheckBox.removeItemListener(this);
        if (enable) {
            this.characterColumnTypeCheckBox.addItemListener(this);
            this.numericColumnTypeCheckBox.addItemListener(this);
            this.dateColumnTypeCheckBox.addItemListener(this);
            this.timeColumnTypeCheckBox.addItemListener(this);
            this.timestampColumnTypeCheckBox.addItemListener(this);
        }
    }

    private String convertSelectionType(int selectionType) {
        if (selectionType == 301) {
            return "Multiple values";
        }
        if (selectionType == 302) {
            return "Multiple ordered values";
        }
        return "Single value";
    }

    private void updateDataSources() {
        if (this.dataSources != null) {
            for (int i = this.dataSources.size() - 1; i >= 0; --i) {
                boolean keepDataSource = this.isDataSourceAllowed(((DataSourceInterface)this.dataSources.get(i)).getDataSourceType());
                if (keepDataSource) continue;
                this.valueListEditor.removeEditorListener((EditorListener)this);
                this.valueListEditor.deleteRow(i);
                this.dataSources.remove(i);
                this.valueListEditor.addEditorListener((EditorListener)this);
            }
        }
    }

    private void updateCheckBoxState() {
        if (this.tablesCheckBox.isSelected() && this.infoMapCheckBox.isSelected()) {
            this.datasourcePicker.setAllowedDataSources(5L);
        } else if (this.tablesCheckBox.isSelected()) {
            this.datasourcePicker.setAllowedDataSources(1L);
        } else if (this.infoMapCheckBox.isSelected()) {
            this.datasourcePicker.setAllowedDataSources(4L);
        }
        long dataSourceTypesAllowed = this.updateDataSourceTypes();
        this.promptDefaultValue.setAllowedDataSourceTypes(dataSourceTypesAllowed);
        this.promptPropertiesPanelDefaultValue.refresh((PromptDefinitionInterface)this.promptDefaultValue);
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelDefaultValue);
        this.updateDataSources();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.tablesCheckBox || e.getSource() == this.infoMapCheckBox) {
            this.enabledCheckBoxListeners(false);
            if (e.getStateChange() == 2) {
                if (!this.infoMapCheckBox.isSelected() && !this.tablesCheckBox.isSelected()) {
                    if (e.getSource() == this.tablesCheckBox) {
                        this.tablesCheckBox.setSelected(true);
                    } else {
                        this.infoMapCheckBox.setSelected(true);
                    }
                }
                this.updateCheckBoxState();
                this.updateDefaultValuePanel(false);
            } else {
                this.updateCheckBoxState();
            }
        } else {
            clearDefaultValue = false;
            if (e.getStateChange() == 2) {
                if (e.getSource() == this.allowColumnsFromMultipleDataSources) {
                    if (this.promptValuesDefaultValue.isPromptValueAvailable((PromptDefinitionInterface)this.promptDefaultValue)) {
                        defaultValue = null;
                        try {
                            defaultValue = this.promptValuesDefaultValue.getPromptValue((PromptDefinitionInterface)this.promptDefaultValue);
                            dataSourceFromDefaultValue = null;
                            dataSourceLocation = null;
                            if (defaultValue == null || !(defaultValue instanceof List)) ** GOTO lbl57
                            listSize = ((List)defaultValue).size();
                            for (i = 0; i < listSize; ++i) {
                                defaultValueDataSource = (DataSourceColumnInterface)((List)defaultValue).get(i);
                                dataSourceValue = defaultValueDataSource.getDataSource();
                                dataSourceValueLocation = dataSourceValue.getDataSourceLocation();
                                if (dataSourceFromDefaultValue == null) {
                                    dataSourceFromDefaultValue = dataSourceValue;
                                    dataSourceLocation = dataSourceFromDefaultValue.getDataSourceLocation();
                                    continue;
                                }
                                if (dataSourceValueLocation == dataSourceLocation) continue;
                                clearDefaultValue = true;
                            }
                        }
                        catch (PromptValueNotFoundException pvnf) {
                            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage(), (Throwable)pvnf);
                        }
                    }
                } else if (!(this.characterColumnTypeCheckBox.isSelected() || this.numericColumnTypeCheckBox.isSelected() || this.dateColumnTypeCheckBox.isSelected() || this.timeColumnTypeCheckBox.isSelected() || this.timestampColumnTypeCheckBox.isSelected())) {
                    if (e.getSource() == this.characterColumnTypeCheckBox) {
                        this.characterColumnTypeCheckBox.setSelected(true);
                    } else if (e.getSource() == this.numericColumnTypeCheckBox) {
                        this.numericColumnTypeCheckBox.setSelected(true);
                    } else if (e.getSource() == this.dateColumnTypeCheckBox) {
                        this.dateColumnTypeCheckBox.setSelected(true);
                    } else if (e.getSource() == this.timeColumnTypeCheckBox) {
                        this.timeColumnTypeCheckBox.setSelected(true);
                    } else if (e.getSource() == this.timestampColumnTypeCheckBox) {
                        this.timestampColumnTypeCheckBox.setSelected(true);
                    } else {
                        this.characterColumnTypeCheckBox.setSelected(true);
                    }
                }
            }
lbl57:
            // 14 sources

            columnTypes = this.updateColumnTypes();
            this.promptDefaultValue.setAllowedColumnTypes(columnTypes);
            this.updateDefaultValuePanel(clearDefaultValue);
        }
        this.enabledCheckBoxListeners(true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("requiredState")) {
            boolean newValue = (Boolean)e.getNewValue();
            try {
                if (this.promptValuesValueCount != null) {
                    if (!newValue) {
                        this.promptValuesValueCount.clearPromptValue((PromptDefinitionInterface)this.promptMinValueCount);
                    } else if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMinValueCount)) {
                        if ((Integer)this.promptValuesValueCount.getPromptValue((PromptDefinitionInterface)this.promptMinValueCount) <= 0) {
                            this.promptValuesValueCount.setPromptValue((PromptDefinitionInterface)this.promptMinValueCount, 1);
                        }
                    } else {
                        this.promptValuesValueCount.setPromptValue((PromptDefinitionInterface)this.promptMinValueCount, 1);
                    }
                }
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
            }
            catch (PromptValueNotFoundException pvnf) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage(), (Throwable)pvnf);
            }
        }
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.getPromptDefinition(false);
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        this.setContentsValid(true);
        this.promptValuesDefaultValue.removePromptValueChangeListener((PromptValueChangeListener)this);
        if (this.selectionType != "Single value") {
            this.promptValuesValueCount.removePromptValueChangeListener((PromptValueChangeListener)this);
        }
        this.dataSourceColumnDefinition = (DataSourceColumnDefinition)PromptUtility.newConfiguredPrompt(this.communicator, "DataSourceColumnDefinition");
        if (this.selectionType != "Single value") {
            this.dataSourceColumnDefinition.setMaximumValueCount(Integer.MAX_VALUE);
            if (this.selectionType.equals("Multiple ordered values")) {
                this.dataSourceColumnDefinition.setSelectionOrdered(true);
            }
        }
        try {
            if (this.selectionType != "Single value") {
                PromptGroupUtility.setMinValueCountFromPromptValue((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMinValueCount, (MutableSelectableDefinitionInterface)this.dataSourceColumnDefinition);
                PromptGroupUtility.setMaxValueCountFromPromptValue((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMaxValueCount, (MutableSelectableDefinitionInterface)this.dataSourceColumnDefinition);
            }
            this.dataSourceColumnDefinition.setDataSources(this.dataSources);
            if (this.tablesCheckBox.isSelected() && this.infoMapCheckBox.isSelected()) {
                this.dataSourceColumnDefinition.setAllowedDataSourceTypes(5L);
            } else if (this.tablesCheckBox.isSelected()) {
                this.dataSourceColumnDefinition.setAllowedDataSourceTypes(1L);
            } else if (this.infoMapCheckBox.isSelected()) {
                this.dataSourceColumnDefinition.setAllowedDataSourceTypes(4L);
            }
            this.dataSourceColumnDefinition.setAllowedColumnTypes(this.updateColumnTypes());
            if (this.promptValuesDefaultValue.isPromptValueAvailable((PromptDefinitionInterface)this.promptDefaultValue)) {
                Object defaultValue = this.promptValuesDefaultValue.getPromptValue((PromptDefinitionInterface)this.promptDefaultValue);
                if (this.selectionType != "Single value") {
                    if (defaultValue instanceof List && ((List)defaultValue).size() > 0) {
                        this.dataSourceColumnDefinition.setDefaultValue(defaultValue);
                    } else {
                        this.dataSourceColumnDefinition.clearDefaultValue();
                    }
                } else if (defaultValue == null) {
                    this.dataSourceColumnDefinition.clearDefaultValue();
                } else {
                    this.dataSourceColumnDefinition.setDefaultValue(defaultValue);
                }
            }
            if (this.selectionType != "Single value") {
                this.dataSourceColumnDefinition.setAllowMultipleDataSources(this.allowColumnsFromMultipleDataSources.isSelected());
            }
        }
        catch (IllegalArgumentException exception) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(exception.getMessage(), (Throwable)exception);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)PromptUtility.getParentFrame(this.communicator, this), new Message(Strings.padSingleQuotesForMessage((String)exception.getMessage())), null);
            }
            this.setContentsValid(false);
            this.promptValuesDefaultValue.addPromptValueChangeListener((PromptValueChangeListener)this);
            if (this.selectionType != "Single value") {
                this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
            }
            return this.dataSourceColumnDefinition;
        }
        catch (PromptValueNotFoundException pvnf) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage(), (Throwable)pvnf);
        }
        Collection errors = this.dataSourceColumnDefinition.validateDefinition(this.getLocale());
        if (errors.size() > 0 && !suppressErrors) {
            String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)PromptUtility.getParentFrame(this.communicator, this), new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
            }
            this.setContentsValid(false);
            this.promptValuesDefaultValue.addPromptValueChangeListener((PromptValueChangeListener)this);
            if (this.selectionType != "Single value") {
                this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
            }
        }
        try {
            if (!this.userDefinedDataProvider) {
                ((DataProvider)this.dataProvider).close();
            }
        }
        catch (ServerConnectionException sce) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(sce.getMessage(), (Throwable)sce);
        }
        return this.dataSourceColumnDefinition;
    }

    public void promptValueChanged(PromptValueChangeEventInterface event) {
        Collection errors;
        PromptDefinitionInterface promptDefinition = event.getPromptDefinition();
        if (promptDefinition.getPromptName().equals(PromptGroupUtility.MIN_VALUE_COUNT)) {
            try {
                if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMinValueCount)) {
                    Integer minValueCount = (Integer)this.promptValuesValueCount.getPromptValue((PromptDefinitionInterface)this.promptMinValueCount);
                    this.communicator.setRequired(minValueCount > 0);
                } else {
                    this.communicator.setRequired(false);
                }
            }
            catch (PromptValueNotFoundException pvnf) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage(), (Throwable)pvnf);
            }
        }
        if (this.dataSourceColumnDefinition != null && (errors = this.dataSourceColumnDefinition.validateDefinition(this.getLocale())).size() > 0) {
            this.setContentsValid(true);
        }
    }

    public void editingStopped(ChangeEvent e) {
    }

    public void editingStarted(ChangeEvent e) {
    }

    public void valueModified(ChangeEvent e) {
    }

    public void valueChanged(ChangeEvent e) {
        boolean clearDefault = false;
        this.dataSources.clear();
        Object value = this.valueListEditor.getValue();
        if (value == null) {
            this.updateDefaultValuePanel(true);
        } else if (value instanceof List) {
            if (((List)value).size() == 0) {
                clearDefault = true;
            } else {
                this.dataSources.addAll((List)value);
            }
        }
        this.updateDefaultValuePanel(clearDefault);
    }
}

