/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JFrame;

public class ConvertToTreeModelUtil {
    public static void tileDialog(Window window, Component component) {
        JFrame frame = Util.getParentFrame((Component)component);
        if (frame != null) {
            Point frameLocation = frame.getLocationOnScreen();
            Insets insets = frame.getInsets();
            int top = insets.top;
            int left = insets.left;
            window.setLocation(frameLocation.x + left, frameLocation.y + top);
        }
    }

    public static void quarterOver(Window window, Component component) {
        int amountOver;
        if (component == null || !component.isShowing()) {
            Dimension size = window.getSize();
            Dimension screenSize = window.getToolkit().getScreenSize();
            window.setLocation(screenSize.width / 2 - size.width / 2, screenSize.height / 2 - size.height / 2);
            return;
        }
        Point location = component.getLocationOnScreen();
        Dimension componentSize = component.getSize();
        location.x += componentSize.width / 4;
        location.y += componentSize.height / 4;
        Dimension size = window.getSize();
        int x = location.x - size.width / 2;
        int y = location.y - size.height / 2;
        Dimension screenSize = window.getToolkit().getScreenSize();
        if (x + size.width > screenSize.width && (amountOver = x + size.width - screenSize.width) > 0 && x - amountOver > 0) {
            x -= amountOver;
        }
        if (y + size.height > screenSize.height && (amountOver = y + size.height - screenSize.height) > 0 && y - amountOver > 0) {
            y -= amountOver;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        window.setLocation(0, 25);
    }
}

