/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.models.itemlistmanager.ItemListManagerViewerInterface;
import com.sas.prompts.groups.ModalChoiceGroupInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.visuals.swing.designtime.ConvertToTreeModelUtil;
import com.sas.prompts.visuals.swing.designtime.ModalChoiceGroupPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.ModalChoiceTableModel;
import com.sas.prompts.visuals.swing.designtime.ModalGroupEditorTabbedPanel;
import com.sas.prompts.visuals.swing.designtime.PromptGroupTableCellRenderer;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.swing.util.SASJavaHelp;
import com.sas.swing.visuals.OptionsDialog;
import com.sas.swing.visuals.PanelInterface;
import com.sas.swing.visuals.itemlistmanager.TableItemListManagerPanel;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

class ChoiceGroupListEditor
extends TableItemListManagerPanel {
    private DefaultTableModel tableModel;
    private JButton clearDefaultsButton;
    private JButton addGroupButton;
    private AbstractAction clearDefaultsAction;
    private AbstractAction addGroupAction;
    private PropertiesCommunicator communicator;
    private SASJavaHelp javaHelp = null;
    private static final long serialVersionUID = 3257563988660598326L;

    public ChoiceGroupListEditor(PropertiesCommunicator communicator) {
        this(null, null, communicator);
    }

    public ChoiceGroupListEditor(DefaultTableModel model, Object defaultValue, PropertiesCommunicator communicator) {
        this.communicator = communicator;
        this.createTableModel(model);
        this.setCellRenderer(-1, 1, new PromptGroupTableCellRenderer());
        this.setCellRenderer(-1, 2, new RadioButtonRenderer());
        this.setCellEditor(-1, 2, new RadioButtonEditor());
        this.removeAllButtons(0);
        this.removeAllButtons(1);
        this.defineButtons();
        this.addButtons();
        this.setDefaultValue(defaultValue);
        this.setPreferredSize(new Dimension(375, 175));
    }

    private void setDefaultValue(Object defaultValue) {
        if (defaultValue instanceof ModalChoiceGroupInterface) {
            int rowCount = this.tableModel.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                if (!((ModalChoiceGroupInterface)this.tableModel.getValueAt(i, 0)).equals(defaultValue)) continue;
                this.tableModel.setValueAt(Boolean.TRUE, i, 1);
            }
        }
    }

    private void createTableModel(DefaultTableModel model) {
        if (model == null) {
            Object[] columnNames = new String[]{RB.getStringResource("choiceGroup.txt"), RB.getStringResource("default.txt")};
            this.tableModel = new ModalChoiceTableModel();
            this.tableModel.setColumnIdentifiers(columnNames);
        } else {
            this.tableModel = model;
        }
        this.tableView.setAutoResizeMode(4);
        this.setModel(this.tableModel);
    }

    private void defineButtons() {
        this.clearDefaultsButton = new JButton();
        this.addGroupButton = new JButton();
    }

    private void addButtons() {
        this.addButton(this.addGroupButton, 0, -1);
        this.addButton(this.clearDefaultsButton, 0, -1);
        this.addButton(ItemListManagerViewerInterface.BUTTON_DELETE, 0, -1);
        this.clearDefaultsAction = new clearDefaultsAction();
        this.clearDefaultsButton.setAction(this.clearDefaultsAction);
        this.addGroupAction = new addGroupAction();
        this.addGroupButton.setAction(this.addGroupAction);
    }

    protected boolean addRow() {
        return true;
    }

    protected void displayGeneralDialog() {
        ModalChoiceGroupPropertiesPanel groupPanel = new ModalChoiceGroupPropertiesPanel(this.communicator, this.tableModel);
        ModalGroupEditorTabbedPanel tabbedPanel = new ModalGroupEditorTabbedPanel(this.communicator, this.tableModel);
        OptionsDialog dialog = new OptionsDialog((Frame)Util.getParentFrame((Component)((Object)this)), RB.getStringResource("newGroup.txt"), true, 11, 4, this.getJavaHelp());
        ConvertToTreeModelUtil.quarterOver((Window)dialog, (Component)((Object)this));
        dialog.setPanel((PanelInterface)tabbedPanel);
        dialog.setTitle(RB.getStringResource("newGroup.txt"));
        dialog.pack();
        dialog.setVisible(true);
        PromptGroupInterface promptGroup = tabbedPanel.getPromptGroup();
        if (!dialog.wasCancelled()) {
            this.tableModel.addRow(new Object[]{promptGroup, Boolean.FALSE});
        }
    }

    public SASJavaHelp getJavaHelp() {
        if (this.communicator != null && this.communicator.getJavaHelp() != null) {
            return this.communicator.getJavaHelp();
        }
        try {
            if (this.javaHelp == null) {
                this.javaHelp = new SASJavaHelp("dtpgrp", this.getLocale());
            }
            if (this.communicator != null) {
                this.communicator.setJavaHelp(this.javaHelp);
            }
        }
        catch (Error error) {
            // empty catch block
        }
        return this.javaHelp;
    }

    public void setJavaHelp(SASJavaHelp javaHelp) {
        this.javaHelp = javaHelp;
    }

    protected class addGroupAction
    extends AbstractAction {
        private static final long serialVersionUID = 509214592342109920L;

        public addGroupAction() {
            this.putValue("Name", RB.getStringResource("addGroup.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ChoiceGroupListEditor.this.displayGeneralDialog();
        }
    }

    protected class clearDefaultsAction
    extends AbstractAction {
        private static final long serialVersionUID = 509214592342109920L;

        public clearDefaultsAction() {
            this.putValue("Name", RB.getStringResource("clearDefault.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int tableSize = ChoiceGroupListEditor.this.tableModel.getRowCount();
            for (int i = 0; i < tableSize; ++i) {
                ChoiceGroupListEditor.this.tableModel.setValueAt(Boolean.FALSE, i, 1);
            }
        }
    }

    private static class RadioButtonRenderer
    extends JRadioButton
    implements TableCellRenderer {
        private RadioButtonRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            if (value == null) {
                this.setSelected(false);
            }
            Boolean ValueAsBoolean = (Boolean)value;
            this.setSelected(ValueAsBoolean);
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    private static class RadioButtonEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JRadioButton radioButton = new JRadioButton();

        public RadioButtonEditor() {
            this.radioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    this.fireEditingStopped();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object obj, boolean isSelected, int row, int col) {
            this.radioButton.setHorizontalAlignment(0);
            Boolean lValueAsBoolean = (Boolean)obj;
            this.radioButton.setSelected(lValueAsBoolean);
            return this.radioButton;
        }

        @Override
        public Object getCellEditorValue() {
            return new Boolean(this.radioButton.isSelected());
        }
    }
}

