/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.SelectableDefinitionInterface;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.prompts.visuals.swing.designtime.BasePromptTypePanel;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.SupportedSpecialValuesInterface;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.LayoutManager;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

abstract class BaseSpecialValuesPanel
extends BasePromptTypePanel {
    protected int types;
    protected JCheckBox allCheckBox;
    protected JCheckBox noneCheckBox;
    protected JCheckBox missingCheckBox;
    protected PromptDefinitionInterface prompt;
    private SupportedSpecialValues initialSpecialValues;
    private boolean showAllCheckBox;

    public BaseSpecialValuesPanel(PromptDefinitionInterface prompt, PropertiesCommunicator communicator, int types) {
        this(prompt, communicator, types, null);
    }

    public BaseSpecialValuesPanel(PromptDefinitionInterface prompt, PropertiesCommunicator communicator, int types, SupportedSpecialValues initialSpecialValues) {
        super(communicator);
        this.prompt = prompt;
        this.types = types;
        this.initialSpecialValues = initialSpecialValues;
        this.showAllCheckBox();
    }

    protected JPanel createSpecialValuesFields() {
        JPanel specialValuesPanel = new JPanel();
        int x = 3;
        if (this.types == 1) {
            x = 2;
        }
        AutoSizingGridLayout specialValuesPanelLayout = new AutoSizingGridLayout(1, x, 0, 5, true, false, false);
        specialValuesPanelLayout.setIgnoreSizeOfNonVisibleComponents(true);
        specialValuesPanel.setLayout((LayoutManager)specialValuesPanelLayout);
        this.allCheckBox = new JCheckBox(RB.getStringResource("all.txt"));
        this.noneCheckBox = new JCheckBox(RB.getStringResource("other.txt"));
        this.missingCheckBox = new JCheckBox(RB.getStringResource("missing.txt"));
        specialValuesPanel.add(this.allCheckBox);
        specialValuesPanel.add(this.noneCheckBox);
        this.noneCheckBox.setVisible(false);
        specialValuesPanel.add(this.missingCheckBox);
        if (this.types != 0) {
            this.missingCheckBox.setVisible(false);
        }
        if (!this.showAllCheckBox) {
            this.allCheckBox.setSelected(false);
            this.allCheckBox.setVisible(false);
            if (this.prompt instanceof SupportedSpecialValues) {
                ((SupportedSpecialValues)this.prompt).setAllSupported(false);
            }
            if (!this.missingCheckBox.isVisible() && !this.noneCheckBox.isVisible()) {
                specialValuesPanel.setVisible(false);
            }
        }
        SupportedSpecialValues specialValues = null;
        Map savedProperties = this.communicator.getPromptProperties();
        if (this.initialSpecialValues != null) {
            specialValues = this.initialSpecialValues;
        } else if (!savedProperties.isEmpty() && savedProperties.containsKey("SupportedSpecialValues")) {
            specialValues = (SupportedSpecialValues)savedProperties.get("SupportedSpecialValues");
        } else if (this.prompt != null && this.prompt instanceof SupportedSpecialValuesInterface) {
            specialValues = ((SupportedSpecialValuesInterface)this.prompt).getSupportedSpecialValues();
        }
        if (specialValues != null) {
            if (this.showAllCheckBox) {
                this.allCheckBox.setSelected(specialValues.isAllSupported());
            }
            this.noneCheckBox.setSelected(false);
            this.missingCheckBox.setSelected(specialValues.isMissingValuesSupported());
        }
        specialValuesPanel.setBorder(BorderFactory.createTitledBorder(RB.getStringResource("includeSpecialValues.txt")));
        return specialValuesPanel;
    }

    public void showAllCheckBox() {
        this.showAllCheckBox = true;
        if (this.communicator.isCurrentMapSelectorEnabled()) {
            if (this.communicator.getSelectionType() != null) {
                if (this.communicator.getSelectionType().equals("Single value")) {
                    this.showAllCheckBox = false;
                    return;
                }
                if (this.communicator.getListType().equals("User enters values")) {
                    this.showAllCheckBox = false;
                    return;
                }
            } else if (this.prompt != null) {
                if (this.prompt instanceof SelectableDefinitionInterface) {
                    if (((SelectableDefinitionInterface)this.prompt).getSelectionType() == 300) {
                        this.showAllCheckBox = false;
                        return;
                    }
                    if (!(this.prompt instanceof ValueProviderDefinitionInterface)) {
                        this.showAllCheckBox = false;
                        return;
                    }
                    ValueProviderInterface valueProvider = ((ValueProviderDefinitionInterface)this.prompt).getValueProvider();
                    if (!(valueProvider instanceof ValueProviderInterface)) {
                        this.showAllCheckBox = false;
                        return;
                    }
                }
            } else {
                this.showAllCheckBox = false;
            }
        }
    }
}

