/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.definitions.DoubleRangeDefinitionInterface;
import com.sas.prompts.definitions.IntegerRangeDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.visuals.swing.designtime.BasePromptTypesAndValuesPanel;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionInterface;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionWithErrorSuppressionOptionInterface;
import com.sas.prompts.visuals.swing.designtime.IntegerRangePanel;
import com.sas.prompts.visuals.swing.designtime.NumericRangePanel;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.swing.visuals.PanelInterface;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

class BaseNumericRangePanel
extends BasePromptTypesAndValuesPanel
implements ActionListener {
    private boolean contentsValid = true;
    private JCheckBox integersOnlyCheckBox;
    private JPanel numericPromptPanel;
    private JPanel customPanel;
    private PromptDefinitionInterface prompt;
    static final String INTEGER_CHECKBOX_STATE = "INTEGER_CHECKBOX_STATE";
    private static final long serialVersionUID = 3257563988660598326L;

    public BaseNumericRangePanel(PromptDefinitionInterface prompt, PropertiesCommunicator communicator) {
        super(communicator);
        this.prompt = prompt;
        AutoSizingGridLayout layout = new AutoSizingGridLayout(2, 1, 5, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        this.numericPromptPanel = new JPanel();
        AutoSizingGridLayout numericPromptLayout = new AutoSizingGridLayout(1, 1, 5, 10, true, false, false);
        this.numericPromptPanel.setLayout((LayoutManager)numericPromptLayout);
        this.integersOnlyCheckBox = new JCheckBox(RB.getStringResource("integersOnly.txt"));
        if (prompt == null || prompt != null && prompt instanceof IntegerRangeDefinitionInterface) {
            this.integersOnlyCheckBox.setSelected(true);
        }
        this.numericPromptPanel.add(this.integersOnlyCheckBox);
        this.createCustomPanel();
        this.add(this.numericPromptPanel);
        this.add(this.customPanel);
        this.integersOnlyCheckBox.addActionListener(this);
        this.customPanel.addPropertyChangeListener(this);
    }

    private void createCustomPanel() {
        Map map = this.communicator.getPromptProperties();
        if (map.containsKey(INTEGER_CHECKBOX_STATE)) {
            boolean state = (Boolean)map.get(INTEGER_CHECKBOX_STATE);
            this.integersOnlyCheckBox.setSelected(state);
        }
        if (this.customPanel != null) {
            this.removePropertyChangeListener(this);
        }
        if (this.prompt == null) {
            this.customPanel = this.integersOnlyCheckBox.isSelected() ? new IntegerRangePanel((IntegerRangeDefinitionInterface)this.prompt, this.communicator) : new NumericRangePanel((DoubleRangeDefinitionInterface)this.prompt, this.communicator);
        } else if (this.prompt instanceof DoubleRangeDefinitionInterface) {
            this.customPanel = new NumericRangePanel((DoubleRangeDefinitionInterface)this.prompt, this.communicator);
        } else if (this.prompt instanceof IntegerRangeDefinitionInterface) {
            this.customPanel = new IntegerRangePanel((IntegerRangeDefinitionInterface)this.prompt, this.communicator);
        }
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return ((GetPromptDefinitionInterface)((Object)this.customPanel)).getPromptDefinition();
    }

    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        if (this.customPanel instanceof GetPromptDefinitionWithErrorSuppressionOptionInterface) {
            return ((GetPromptDefinitionWithErrorSuppressionOptionInterface)((Object)this.customPanel)).getPromptDefinition(suppressErrors);
        }
        return ((GetPromptDefinitionInterface)((Object)this.customPanel)).getPromptDefinition();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.contentsValid = true;
        if (this.customPanel != null) {
            this.customPanel.removePropertyChangeListener(this);
            this.communicator.clearPromptProperties();
            PromptUtility.copyPropertiesToCommunicator(this.communicator, this.getPromptDefinition(true));
            this.remove(this.customPanel);
        }
        this.prompt = null;
        Map map = this.communicator.getPromptProperties();
        boolean state = this.getIntegersOnlyCheckBox().isSelected();
        map.put(INTEGER_CHECKBOX_STATE, state);
        this.createCustomPanel();
        this.customPanel.addPropertyChangeListener(this);
        this.add((Component)this.customPanel, 1);
        this.setContentsValid(true);
        this.revalidate();
    }

    public JCheckBox getIntegersOnlyCheckBox() {
        return this.integersOnlyCheckBox;
    }

    @Override
    public boolean isContentsValid() {
        if (this.customPanel != null && this.customPanel instanceof PanelInterface) {
            return ((PanelInterface)this.customPanel).isContentsValid();
        }
        return true;
    }

    @Override
    public void setContentsValid(boolean newValue) {
        if (newValue != this.contentsValid) {
            this.contentsValid = newValue;
            this.firePropertyChange("contentsValid", !this.contentsValid, this.contentsValid);
        }
    }
}

