/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.definitions.DoubleDefinitionInterface;
import com.sas.prompts.definitions.IntegerDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.visuals.swing.designtime.BasePromptTypePanel;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionInterface;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionWithErrorSuppressionOptionInterface;
import com.sas.prompts.visuals.swing.designtime.IntegerCustomListPanel;
import com.sas.prompts.visuals.swing.designtime.IntegerDynamicListPanel;
import com.sas.prompts.visuals.swing.designtime.IntegerMultipleValuesPanel;
import com.sas.prompts.visuals.swing.designtime.IntegerSingleValuePanel;
import com.sas.prompts.visuals.swing.designtime.NumericCustomListPanel;
import com.sas.prompts.visuals.swing.designtime.NumericDynamicListPanel;
import com.sas.prompts.visuals.swing.designtime.NumericMultipleValuesPanel;
import com.sas.prompts.visuals.swing.designtime.NumericSingleValuePanel;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.swing.visuals.PanelInterface;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

class BaseNumericPromptPanel
extends BasePromptTypePanel
implements ActionListener,
PropertyChangeListener {
    private boolean contentsValid = true;
    private JCheckBox integersOnlyCheckBox;
    private JPanel numericPromptPanel;
    private JPanel customPanel;
    private PromptDefinitionInterface prompt;
    protected String selectionType;
    protected String listType;
    private static final long serialVersionUID = 3257563988660598326L;

    public BaseNumericPromptPanel(String selectionType, String listType, PropertiesCommunicator communicator) {
        this(null, selectionType, listType, communicator);
    }

    public BaseNumericPromptPanel(PromptDefinitionInterface prompt, String selectionType, String listType, PropertiesCommunicator communicator) {
        super(communicator);
        this.selectionType = selectionType;
        this.listType = listType;
        this.prompt = prompt;
        AutoSizingGridLayout layout = new AutoSizingGridLayout(2, 1, 5, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        this.numericPromptPanel = new JPanel();
        AutoSizingGridLayout numericPromptLayout = new AutoSizingGridLayout(1, 1, 5, 10, true, false, false);
        this.numericPromptPanel.setLayout((LayoutManager)numericPromptLayout);
        this.integersOnlyCheckBox = new JCheckBox(RB.getStringResource("integersOnly.txt"));
        if (prompt == null || prompt != null && prompt instanceof IntegerDefinitionInterface) {
            this.integersOnlyCheckBox.setSelected(true);
        }
        this.numericPromptPanel.add(this.integersOnlyCheckBox);
        this.createCustomPanel();
        this.add(this.numericPromptPanel);
        this.add(this.customPanel);
        this.integersOnlyCheckBox.addActionListener(this);
        this.customPanel.addPropertyChangeListener(this);
    }

    private void createCustomPanel() {
        Map map = this.communicator.getPromptProperties();
        if (map.containsKey("INTEGER_CHECKBOX_STATE")) {
            boolean state = (Boolean)map.get("INTEGER_CHECKBOX_STATE");
            this.integersOnlyCheckBox.setSelected(state);
        }
        if (this.customPanel != null) {
            this.removePropertyChangeListener(this);
        }
        this.customPanel = this.prompt == null ? (this.listType.equals("User selects values from a static list") ? (this.integersOnlyCheckBox.isSelected() ? new IntegerCustomListPanel(this.selectionType, this.communicator) : new NumericCustomListPanel(this.selectionType, this.communicator)) : (this.listType.equals("User selects values from a dynamic list") ? (this.integersOnlyCheckBox.isSelected() ? new IntegerDynamicListPanel(null, this.selectionType, this.communicator) : new NumericDynamicListPanel(null, this.selectionType, this.communicator)) : (this.selectionType.equals("Single value") ? (this.integersOnlyCheckBox.isSelected() ? new IntegerSingleValuePanel(this.communicator) : new NumericSingleValuePanel(this.communicator)) : (this.integersOnlyCheckBox.isSelected() ? new IntegerMultipleValuesPanel(this.selectionType, this.communicator) : new NumericMultipleValuesPanel(this.selectionType, this.communicator))))) : (this.listType.equals("User selects values from a static list") ? (this.integersOnlyCheckBox.isSelected() ? new IntegerCustomListPanel((IntegerDefinitionInterface)this.prompt, this.selectionType, this.communicator) : new NumericCustomListPanel((DoubleDefinitionInterface)this.prompt, this.selectionType, this.communicator)) : (this.listType.equals("User selects values from a dynamic list") ? (this.integersOnlyCheckBox.isSelected() ? new IntegerDynamicListPanel((IntegerDefinitionInterface)this.prompt, this.selectionType, this.communicator) : new NumericDynamicListPanel((DoubleDefinitionInterface)this.prompt, this.selectionType, this.communicator)) : (this.selectionType.equals("Single value") ? (this.integersOnlyCheckBox.isSelected() ? new IntegerSingleValuePanel((IntegerDefinitionInterface)this.prompt, this.communicator) : new NumericSingleValuePanel((DoubleDefinitionInterface)this.prompt, this.communicator)) : (this.integersOnlyCheckBox.isSelected() ? new IntegerMultipleValuesPanel((IntegerDefinitionInterface)this.prompt, this.selectionType, this.communicator) : new NumericMultipleValuesPanel(this.prompt, this.selectionType, this.communicator)))));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("dataSourceValid".equals(evt.getPropertyName())) {
            this.firePropertyChange("dataSourceValid", evt.getOldValue(), evt.getNewValue());
        } else if ("dataSourceChanged".equals(evt.getPropertyName())) {
            this.firePropertyChange("dataSourceChanged", evt.getOldValue(), evt.getNewValue());
        } else if ("valueProviderUpdateNeeded".equals(evt.getPropertyName())) {
            this.firePropertyChange("valueProviderUpdateNeeded", evt.getOldValue(), evt.getNewValue());
        } else if ("dataItemChanged".equals(evt.getPropertyName())) {
            this.firePropertyChange("dataItemChanged", evt.getOldValue(), evt.getNewValue());
        } else if ("contentsValid".equals(evt.getPropertyName())) {
            this.setContentsValid((Boolean)evt.getNewValue());
        } else if ("errorPanel".equals(evt.getPropertyName())) {
            this.firePropertyChange("errorPanel", evt.getOldValue(), evt.getNewValue());
        }
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return ((GetPromptDefinitionInterface)((Object)this.customPanel)).getPromptDefinition();
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        if (this.customPanel instanceof GetPromptDefinitionWithErrorSuppressionOptionInterface) {
            return ((GetPromptDefinitionWithErrorSuppressionOptionInterface)((Object)this.customPanel)).getPromptDefinition(suppressErrors);
        }
        return ((GetPromptDefinitionInterface)((Object)this.customPanel)).getPromptDefinition();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.contentsValid = true;
        if (this.customPanel != null) {
            this.customPanel.removePropertyChangeListener(this);
            this.communicator.clearPromptProperties();
            PromptUtility.copyPropertiesToCommunicator(this.communicator, this.getPromptDefinition(true));
            this.remove(this.customPanel);
        }
        this.prompt = null;
        Map map = this.communicator.getPromptProperties();
        boolean state = this.getIntegersOnlyCheckBox().isSelected();
        map.put("INTEGER_CHECKBOX_STATE", state);
        this.createCustomPanel();
        this.customPanel.addPropertyChangeListener(this);
        this.add((Component)this.customPanel, -1);
        this.setContentsValid(true);
        this.revalidate();
    }

    @Override
    public boolean isContentsValid() {
        if (this.customPanel != null && this.customPanel instanceof PanelInterface) {
            return ((PanelInterface)this.customPanel).isContentsValid();
        }
        return true;
    }

    @Override
    public void setContentsValid(boolean newValue) {
        if (newValue != this.contentsValid) {
            this.contentsValid = newValue;
            this.firePropertyChange("contentsValid", !this.contentsValid, this.contentsValid);
        }
    }

    public JCheckBox getIntegersOnlyCheckBox() {
        return this.integersOnlyCheckBox;
    }
}

