/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.datatypes.DateType;
import com.sas.datatypes.DoubleType;
import com.sas.datatypes.IntegerType;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.IntegerDefinition;
import com.sas.prompts.definitions.IntegerDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroupInterface;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BaseSpecialValuesPanel;
import com.sas.prompts.visuals.swing.designtime.MultipleValuesListEditor;
import com.sas.prompts.visuals.swing.designtime.PromptGroupUtility;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

abstract class BaseMultipleValuesPanel
extends BaseSpecialValuesPanel
implements TableModelListener,
PromptValueChangeListener,
ItemListener {
    protected boolean contentsValid = true;
    protected String selectionType;
    protected PromptValues promptValuesValueCount;
    protected PromptPropertiesPanel promptPropertiesPanelValueCount;
    protected IntegerDefinition promptMinValueCount;
    protected IntegerDefinition promptMaxValueCount;
    protected MultipleValuesListEditor listEditor;

    public BaseMultipleValuesPanel(String selectionType, PropertiesCommunicator communicator) {
        this(null, selectionType, communicator);
    }

    public BaseMultipleValuesPanel(PromptDefinitionInterface prompt, String selectionType, PropertiesCommunicator communicator) {
        super(prompt, communicator, 0);
        this.selectionType = selectionType;
        this.initializeMinMaxValueCountFields();
    }

    protected abstract void createPromptPanel();

    protected abstract void verifyContentsValid();

    protected void initializeMinMaxValueCountFields() {
        TransparentGroupInterface promptGroupValueCount = PromptGroupUtility.newGroupForMinMaxValueCount(this.getLocale(), this.getLoggerFactory());
        this.promptMinValueCount = (IntegerDefinition)promptGroupValueCount.getPromptDefinition(PromptGroupUtility.MIN_VALUE_COUNT, true);
        if (this.communicator.isPromptRequired()) {
            this.promptMinValueCount.setMinimum(1);
        }
        this.promptMaxValueCount = (IntegerDefinition)promptGroupValueCount.getPromptDefinition(PromptGroupUtility.MAX_VALUE_COUNT, true);
        this.promptValuesValueCount = new PromptValues((PromptGroupInterface)promptGroupValueCount, null);
        PromptUtility.configurePromptValuesForMinMaxCount(this.promptValuesValueCount, this.prompt, (IntegerDefinitionInterface)this.promptMinValueCount, (IntegerDefinitionInterface)this.promptMaxValueCount, this.communicator);
        this.promptPropertiesPanelValueCount = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesValueCount, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelValueCount);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createListEditor(String promptType) {
        block17: {
            ArrayList<Object> defaultValues;
            block15: {
                IntegerType dataType;
                Object defaultSaved;
                block20: {
                    block18: {
                        block19: {
                            ValueProviderInterface valueProvider;
                            block16: {
                                if (this.prompt == null || !this.prompt.isDefaultValueSet()) break block16;
                                List defaultValues2 = (List)this.prompt.getDefaultValue();
                                this.createTableRow(promptType, defaultValues2);
                                break block17;
                            }
                            Map savedProperties = this.communicator.getPromptProperties();
                            defaultValues = new ArrayList<Object>();
                            if (savedProperties.isEmpty() || (valueProvider = (ValueProviderInterface)savedProperties.get("ValueProvider")) != null) break block15;
                            defaultSaved = savedProperties.get("DefaultValue");
                            if (!"Text".equals(promptType)) break block18;
                            if (!(defaultSaved instanceof List)) break block19;
                            for (Object o : (List)defaultSaved) {
                                if (!(o instanceof String) && (o == null || o != SpecialValues.ALL && o != SpecialValues.OTHER)) continue;
                                defaultValues.add(o);
                            }
                            break block15;
                        }
                        if (defaultSaved instanceof String || defaultSaved != null && (defaultSaved == MissingValues._BLANK_ || defaultSaved == SpecialValues.ALL || defaultSaved == SpecialValues.OTHER)) {
                            defaultValues.add(defaultSaved);
                        }
                        break block15;
                    }
                    dataType = null;
                    if ("Integer".equals(promptType)) {
                        dataType = new IntegerType();
                    } else if ("Numeric".equals(promptType)) {
                        dataType = new DoubleType();
                    } else if ("Date".equals(promptType) || "Time".equals(promptType) || "Timestamp".equals(promptType) || "Week".equals(promptType) || "Quarter".equals(promptType) || "Month".equals(promptType) || "Year".equals(promptType)) {
                        dataType = new DateType();
                    }
                    if (dataType == null) break block15;
                    if (defaultSaved instanceof List) break block20;
                    if (defaultSaved != null) {
                        try {
                            if (defaultSaved != null && defaultSaved != MissingValues._BLANK_) {
                                Object coercedValue = dataType.coerceValue(defaultSaved, this.getLocale());
                                defaultValues.add(coercedValue);
                            }
                            break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    break block15;
                }
                for (Object o : (List)defaultSaved) {
                    if (o == null || o == MissingValues._BLANK_) continue;
                    try {
                        Object coercedValue = dataType.coerceValue(o, this.getLocale());
                        if (!(coercedValue instanceof MissingValues)) {
                            defaultValues.add(coercedValue);
                            continue;
                        }
                        if (!(o instanceof MissingValues)) continue;
                        defaultValues.add(coercedValue);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
            this.createTableRow(promptType, defaultValues);
        }
        this.listEditor.getModel().addTableModelListener(this);
        Border emptyBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(RB.getStringResource("defaultValues.txt"));
        this.listEditor.setBorder(BorderFactory.createCompoundBorder(titledBorder, emptyBorder));
        this.initMinValueCountFromRequiredField();
    }

    public void addSpecialValuesListeners() {
        this.allCheckBox.addItemListener(this);
        this.noneCheckBox.addItemListener(this);
        this.missingCheckBox.addItemListener(this);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.setSpecialValuesOnListEditor();
    }

    public void setSpecialValuesOnListEditor() {
        this.setContentsValid(true);
        SupportedSpecialValues supportedSpecialValues = new SupportedSpecialValues();
        supportedSpecialValues.setAllSupported(this.allCheckBox.isSelected());
        supportedSpecialValues.setOtherSupported(this.noneCheckBox.isSelected());
        supportedSpecialValues.setMissingValuesSupported(this.missingCheckBox.isSelected());
        this.listEditor.setSpecialValues(supportedSpecialValues);
    }

    private void createTableRow(String promptType, List defaultValues) {
        Vector dataVector = new Vector();
        if (defaultValues != null) {
            int listSize = defaultValues.size();
            for (int i = 0; i < listSize; ++i) {
                Object value = defaultValues.get(i);
                if ((value == null || (value instanceof MissingValues || !promptType.equals("Text")) && MissingValues.getNumericMissingValues((String)value.toString()) != null) && (!(value instanceof MissingValues) || !promptType.equals("Numeric") && !promptType.equals("Integer") && !promptType.equals("Date"))) continue;
                Vector v = new Vector();
                v.add(defaultValues.get(i));
                dataVector.add(v);
            }
            Vector<String> columnNames = new Vector<String>(1);
            columnNames.add(RB.getStringResource("choiceLabels.txt"));
            DefaultTableModel model = new DefaultTableModel(dataVector, columnNames);
            this.listEditor = new MultipleValuesListEditor(promptType, model);
        }
    }

    protected void initMinValueCountFromRequiredField() {
        if (this.prompt == null) {
            PromptUtility.configureRequiredState(this.promptValuesValueCount, (IntegerDefinitionInterface)this.promptMinValueCount, this.communicator);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        block9: {
            if (e.getPropertyName().equals("requiredState")) {
                boolean newValue = (Boolean)e.getNewValue();
                try {
                    if (this.promptValuesValueCount == null) break block9;
                    if (!newValue) {
                        this.promptValuesValueCount.clearPromptValue((PromptDefinitionInterface)this.promptMinValueCount);
                        break block9;
                    }
                    if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMinValueCount)) {
                        if ((Integer)this.promptValuesValueCount.getPromptValue((PromptDefinitionInterface)this.promptMinValueCount) <= 0) {
                            this.promptValuesValueCount.setPromptValue((PromptDefinitionInterface)this.promptMinValueCount, 1);
                        }
                        break block9;
                    }
                    this.promptValuesValueCount.setPromptValue((PromptDefinitionInterface)this.promptMinValueCount, 1);
                }
                catch (InvalidPromptValueException ipve) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ipve.getMessage());
                }
                catch (PromptValueNotFoundException pvnf) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
                }
            } else if (e.getPropertyName().equals("errorPanel")) {
                this.firePropertyChange("errorPanel", e.getOldValue(), e.getNewValue());
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.setContentsValid(true);
    }

    public void removeAllListeners() {
        this.listEditor.getModel().removeTableModelListener(this);
        this.allCheckBox.removeItemListener(this);
        this.noneCheckBox.removeItemListener(this);
        this.missingCheckBox.removeItemListener(this);
    }

    @Override
    public boolean isContentsValid() {
        return this.contentsValid;
    }

    @Override
    public void setContentsValid(boolean newValue) {
        if (newValue != this.contentsValid) {
            this.contentsValid = newValue;
            this.firePropertyChange("contentsValid", !this.contentsValid, this.contentsValid);
        }
    }

    public void promptValueChanged(PromptValueChangeEventInterface event) {
        PromptDefinitionInterface promptDefinition = event.getPromptDefinition();
        if (promptDefinition.getPromptName().equals(PromptGroupUtility.MIN_VALUE_COUNT)) {
            try {
                if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMinValueCount)) {
                    Integer minValueCount = (Integer)this.promptValuesValueCount.getPromptValue((PromptDefinitionInterface)this.promptMinValueCount);
                    this.communicator.setRequired(minValueCount > 0);
                } else {
                    this.communicator.setRequired(false);
                }
            }
            catch (PromptValueNotFoundException pvnf) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
            }
        }
        this.verifyContentsValid();
    }
}

