/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.iquery.metadata.business.DataItem;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.prompts.DynamicValueProviderInterface;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.IntegerDefinition;
import com.sas.prompts.definitions.IntegerDefinitionInterface;
import com.sas.prompts.definitions.MutableSelectableDefinitionInterface;
import com.sas.prompts.definitions.MutableValueProviderDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.prompts.definitions.shared.SharedPromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.prompts.groups.TransparentGroupInterface;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.PromptDataProviderInterface;
import com.sas.prompts.valueprovider.dynamic.iq.DataItemValueProvider;
import com.sas.prompts.valueprovider.dynamic.iq.OLAPDataItemValueProvider;
import com.sas.prompts.valueprovider.dynamic.workspace.PromptColumnValueProvider;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BasePromptTypePanel;
import com.sas.prompts.visuals.swing.designtime.DefaultValuesListEditor;
import com.sas.prompts.visuals.swing.designtime.DynamicValuesOLAPPanel;
import com.sas.prompts.visuals.swing.designtime.DynamicValuesRelationalPanel;
import com.sas.prompts.visuals.swing.designtime.PromptGroupUtility;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.services.information.metadata.PhysicalTableInterface;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.swing.visuals.DataSourcePicker;
import com.sas.swing.visuals.EditorListener;
import com.sas.text.Message;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;

abstract class BaseDynamicListPanel
extends BasePromptTypePanel
implements PromptValueChangeListener,
EditorListener,
PropertyChangeListener,
ActionListener,
ItemListener {
    private boolean panelHasInitialDatasource;
    private boolean userDefinedDataProvider;
    protected JCheckBox allowCustomValuesCheckBox;
    protected JButton browseButton;
    protected JLabel datasourceField;
    protected JPanel customPanel;
    protected JPanel holderPanel;
    protected String infoMapUrl;
    protected String selectionType;
    protected PromptDataProviderInterface dataProvider;
    protected PromptValues promptValuesValueCount;
    protected PromptValues promptValuesDatasource;
    protected PromptValues promptValuesMaxDisplay;
    protected PromptPropertiesPanel promptPropertiesPanelValueCount;
    protected PromptPropertiesPanel promptPropertiesPanelMaxDisplay;
    protected PromptDefinitionInterface promptDatasource;
    protected PromptPropertiesPanel promptPropertiesPanelDataSource;
    protected PromptDefinitionInterface prompt;
    protected IntegerDefinition promptMinValueCount;
    protected IntegerDefinition promptMaxValueCount;
    protected IntegerDefinition promptMaxDisplay;
    protected DefaultValuesListEditor listEditor;
    protected DataSourcePicker datasourcePicker;
    private ValueProviderInterface valueProvider;
    private boolean initialized = false;
    private PromptDefinitionInterface promptObject;
    private DataSourceInterface currentDataSource;
    private JRadioButton currentMapRadio;
    private JRadioButton selectRadio;
    private DataSourceInterface initialMap;
    private DataSourceInterface currentIMSMap;
    private boolean dataSourceIsCurrentMap;

    public BaseDynamicListPanel(String selectionType, PropertiesCommunicator communicator) {
        this(null, selectionType, communicator);
    }

    public BaseDynamicListPanel(PromptDefinitionInterface prompt, String selectionType, PropertiesCommunicator communicator) {
        super(communicator);
        this.selectionType = selectionType;
        this.prompt = prompt;
        this.panelHasInitialDatasource = prompt != null;
        this.initializeMinMaxValueCountFields();
    }

    protected abstract void createPromptPanel();

    protected abstract void verifyContentsValid();

    protected abstract PromptDefinitionInterface intializePrompt();

    protected void initializeMinMaxValueCountFields() {
        if (this.selectionType != "Single value") {
            TransparentGroupInterface promptGroupValueCount = PromptGroupUtility.newGroupForMinMaxValueCount(this.getLocale(), this.getLoggerFactory());
            this.promptMinValueCount = (IntegerDefinition)promptGroupValueCount.getPromptDefinition(PromptGroupUtility.MIN_VALUE_COUNT, true);
            this.promptMaxValueCount = (IntegerDefinition)promptGroupValueCount.getPromptDefinition(PromptGroupUtility.MAX_VALUE_COUNT, true);
            this.promptValuesValueCount = new PromptValues((PromptGroupInterface)promptGroupValueCount, null);
            PromptUtility.configurePromptValuesForMinMaxCount(this.promptValuesValueCount, this.prompt, (IntegerDefinitionInterface)this.promptMinValueCount, (IntegerDefinitionInterface)this.promptMaxValueCount, this.communicator);
            this.promptPropertiesPanelValueCount = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesValueCount, this.getLocale());
            PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelValueCount);
        }
        this.initializeRequiredState();
    }

    protected boolean isUserDefinedDataProvider() {
        return this.userDefinedDataProvider;
    }

    protected void initializeRequiredState() {
        if (this.prompt == null && this.selectionType != "Single value") {
            PromptUtility.configureRequiredState(this.promptValuesValueCount, (IntegerDefinitionInterface)this.promptMinValueCount, this.communicator);
        }
    }

    protected JPanel createAllowCustomValuesCheckBox() {
        JPanel customValuesPanel = new JPanel();
        AutoSizingGridLayout customValuesPanelLayout = new AutoSizingGridLayout(1, 1, 0, 5, true, false, false);
        customValuesPanel.setLayout((LayoutManager)customValuesPanelLayout);
        this.allowCustomValuesCheckBox = new JCheckBox(RB.getStringResource("allowCustomValues.txt"));
        this.allowCustomValuesCheckBox.addItemListener(this);
        PromptUtility.configureCustomValuesCheckBox(this.prompt, this.allowCustomValuesCheckBox, this.communicator);
        customValuesPanel.add(this.allowCustomValuesCheckBox);
        return customValuesPanel;
    }

    protected JPanel createHolderPanel() {
        this.holderPanel = new JPanel();
        AutoSizingGridLayout holderPanelLayout = new AutoSizingGridLayout(1, 1, 0, 5, true, false, true);
        this.holderPanel.setLayout((LayoutManager)holderPanelLayout);
        return this.holderPanel;
    }

    protected JPanel createDatasourcePanel() {
        DataItem valueProviderItem;
        Object o;
        PromptDataProviderInterface userDataProvider = this.communicator.getDataProvider();
        if (userDataProvider != null) {
            this.dataProvider = userDataProvider;
            this.userDefinedDataProvider = true;
        } else {
            this.dataProvider = new DataProvider(this.communicator.getUserContext());
        }
        JPanel outerDatasourcePanel = new JPanel();
        AutoSizingGridLayout outerDatasourcePanelLayout = new AutoSizingGridLayout(2, 1, 5, 5, true, false, true);
        outerDatasourcePanel.setLayout((LayoutManager)outerDatasourcePanelLayout);
        JLabel datasourceLabel = new JLabel(RB.getStringResource("datasource.txt"));
        this.datasourcePicker = new DataSourcePicker(this.communicator.getUserContext());
        this.datasourcePicker.setAllowedDataSources(5L);
        try {
            this.datasourcePicker.setInitialPossibleValues(PromptUtility.getReferencedDataSources(this.communicator.getRootPromptGroup(), -1L, this.communicator.getUserContext(), this.dataProvider));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (this.communicator.isCurrentMapSelectorEnabled()) {
            this.currentIMSMap = this.communicator.getDataSource();
            this.infoMapUrl = this.currentIMSMap.getDataSourceLocation();
            if (!(this.prompt instanceof SharedPromptDefinitionInterface)) {
                this.datasourcePicker.setAllowedDataSources(1L);
            }
            datasourceLabel = new JLabel(RB.getStringResource("dataSource.txt"));
            JPanel IMSHolderPanel = new JPanel();
            AutoSizingGridLayout IMSHolderPanelLayout = new AutoSizingGridLayout(2, 1, 10, 5, true, false, true);
            IMSHolderPanel.setLayout((LayoutManager)IMSHolderPanelLayout);
            JPanel currentMapPanel = new JPanel();
            AutoSizingGridLayout currentMapPanelLayout = new AutoSizingGridLayout(1, 1, 10, 5, true, false, true);
            currentMapPanel.setLayout((LayoutManager)currentMapPanelLayout);
            this.currentMapRadio = new JRadioButton(RB.getStringResource("useCurrentMap.txt"));
            this.currentMapRadio.addActionListener(this);
            currentMapPanel.add(this.currentMapRadio);
            JPanel dataSourcePickerPanel = new JPanel();
            AutoSizingGridLayout dataSourcePickerPanelLayout = new AutoSizingGridLayout(1, 2, 10, 5, true, false, true);
            dataSourcePickerPanel.setLayout((LayoutManager)dataSourcePickerPanelLayout);
            this.selectRadio = new JRadioButton(RB.getStringResource("specifyDataSource.txt"));
            this.selectRadio.addActionListener(this);
            dataSourcePickerPanel.add(this.selectRadio);
            dataSourcePickerPanel.add(this.datasourcePicker);
            IMSHolderPanel.add(currentMapPanel);
            IMSHolderPanel.add(dataSourcePickerPanel);
            Border emptyBorder = BorderFactory.createEmptyBorder(0, 5, 2, 5);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(RB.getStringResource("dataSource.txt"));
            outerDatasourcePanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, emptyBorder));
            outerDatasourcePanel.add(IMSHolderPanel);
        } else {
            outerDatasourcePanel.add(datasourceLabel);
            outerDatasourcePanel.add(this.datasourcePicker);
        }
        this.dataSourceIsCurrentMap = false;
        boolean processValueProvider = true;
        Map savedProperties = this.communicator.getPromptProperties();
        if (!savedProperties.isEmpty() && savedProperties.containsKey("ValueProvider") && (o = savedProperties.get("ValueProvider")) != null && (o instanceof DataItemValueProvider || o instanceof PromptColumnValueProvider)) {
            this.valueProvider = (ValueProviderInterface)o;
            if (this.valueProvider instanceof DataItemValueProvider) {
                if (!this.communicator.isCurrentMapSelectorEnabled()) {
                    valueProviderItem = null;
                    boolean showMapError = false;
                    try {
                        valueProviderItem = ((DataItemValueProvider)this.valueProvider).getDataItem();
                        if (valueProviderItem != null) {
                            this.infoMapUrl = DataProvider.getPathUrl((DataItem)valueProviderItem);
                            if (this.infoMapUrl == null) {
                                showMapError = true;
                            }
                        } else {
                            showMapError = true;
                        }
                        if (showMapError) {
                            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                            if (this.getGenericErrorHandler() != null) {
                                this.getGenericErrorHandler().handleError((Object)PromptUtility.getParentFrame(this.communicator, this), new Message(RB.getStringResource("nonexistantDatasource.txt")), null);
                            }
                            this.setContentsValid(false);
                            this.panelHasInitialDatasource = false;
                        }
                    }
                    catch (IllegalStateException dataSourcePickerPanelLayout) {
                        // empty catch block
                    }
                }
                if (this.communicator.isCurrentMapSelectorEnabled() && !(this.prompt instanceof SharedPromptDefinitionInterface)) {
                    if (this.infoMapUrl != this.currentIMSMap.getDataSourceLocation()) {
                        this.datasourcePicker.setValue(this.infoMapUrl);
                    } else {
                        this.dataSourceIsCurrentMap = true;
                    }
                } else {
                    this.datasourcePicker.setValue(this.infoMapUrl);
                }
            } else if (this.valueProvider instanceof PromptColumnValueProvider) {
                this.infoMapUrl = ((PromptColumnValueProvider)this.valueProvider).getTableUrl();
                if (this.communicator.isCurrentMapSelectorEnabled() && this.infoMapUrl == null) {
                    this.infoMapUrl = this.currentIMSMap.getDataSourceLocation();
                }
                if (this.communicator.isCurrentMapSelectorEnabled()) {
                    if (this.infoMapUrl != this.currentIMSMap.getDataSourceLocation()) {
                        this.datasourcePicker.setValue(this.infoMapUrl);
                    } else {
                        this.dataSourceIsCurrentMap = true;
                    }
                } else {
                    this.datasourcePicker.setValue(this.infoMapUrl);
                }
            }
            if (this.infoMapUrl != null) {
                processValueProvider = false;
            }
        }
        if (processValueProvider) {
            if (this.prompt != null) {
                this.valueProvider = ((ValueProviderDefinitionInterface)this.prompt).getValueProvider();
                if (this.valueProvider instanceof DataItemValueProvider) {
                    boolean showMapError = false;
                    if (this.communicator.isCurrentMapSelectorEnabled() && !(this.prompt instanceof SharedPromptDefinitionInterface)) {
                        this.infoMapUrl = this.currentIMSMap.getDataSourceLocation();
                    } else {
                        valueProviderItem = null;
                        String message = null;
                        try {
                            valueProviderItem = ((DataItemValueProvider)this.valueProvider).getDataItem();
                            if (valueProviderItem != null) {
                                this.infoMapUrl = DataProvider.getPathUrl((DataItem)valueProviderItem);
                                if (this.infoMapUrl == null) {
                                    showMapError = true;
                                    message = RB.getStringResource("nonexistantDatasource.txt");
                                    this.panelHasInitialDatasource = false;
                                }
                            } else {
                                showMapError = true;
                                message = RB.getStringResource("nonexistantDatasource.txt");
                                if (this.prompt != null) {
                                    this.prompt.clearDefaultValue();
                                }
                                this.panelHasInitialDatasource = false;
                            }
                        }
                        catch (IllegalStateException e) {
                            message = RB.getStringResource("dataItemDeleted.txt");
                            this.infoMapUrl = ((DataItemValueProvider)this.valueProvider).getInfoMapUrl();
                            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                            if (this.getGenericErrorHandler() != null) {
                                this.getGenericErrorHandler().handleError((Object)PromptUtility.getParentFrame(this.communicator, this), new Message(message), null);
                            }
                            if (this.prompt != null) {
                                this.prompt.clearDefaultValue();
                            }
                            this.setContentsValid(false);
                        }
                        if (showMapError) {
                            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                            if (this.getGenericErrorHandler() != null) {
                                this.getGenericErrorHandler().handleError((Object)PromptUtility.getParentFrame(this.communicator, this), new Message(message), null);
                            }
                            this.setContentsValid(false);
                        }
                    }
                    if (!showMapError) {
                        if (this.communicator.isCurrentMapSelectorEnabled() && !(this.prompt instanceof SharedPromptDefinitionInterface)) {
                            if (this.infoMapUrl != this.currentIMSMap.getDataSourceLocation()) {
                                this.datasourcePicker.setValue(this.infoMapUrl);
                            } else {
                                this.dataSourceIsCurrentMap = true;
                            }
                        } else {
                            this.datasourcePicker.setValue(this.infoMapUrl);
                        }
                    }
                } else if (this.valueProvider instanceof PromptColumnValueProvider) {
                    this.infoMapUrl = ((PromptColumnValueProvider)this.valueProvider).getTableUrl();
                    boolean validToContinue = true;
                    if (!this.initialized) {
                        try {
                            PhysicalTableInterface tableURL = this.dataProvider.getPhysicalTable(this.infoMapUrl);
                            if (tableURL == null) {
                                validToContinue = false;
                                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                                if (this.getGenericErrorHandler() != null) {
                                    this.getGenericErrorHandler().handleError((Object)PromptUtility.getParentFrame(this.communicator, this), new Message(RB.getStringResource("nonexistantDatasource.txt")), null);
                                }
                                this.firePropertyChange("dataSourceValid", Boolean.TRUE, Boolean.FALSE);
                                this.setContentsValid(false);
                                this.panelHasInitialDatasource = false;
                            }
                        }
                        catch (ServerConnectionException e) {
                            validToContinue = false;
                            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                            if (this.getGenericErrorHandler() != null) {
                                this.getGenericErrorHandler().handleError((Object)PromptUtility.getParentFrame(this.communicator, this), new Message(RB.getStringResource("nonexistantDatasource.txt")), null);
                            }
                            this.firePropertyChange("dataSourceValid", Boolean.TRUE, Boolean.FALSE);
                            this.setContentsValid(false);
                            this.panelHasInitialDatasource = false;
                        }
                    }
                    if (validToContinue) {
                        if (this.communicator.isCurrentMapSelectorEnabled() && !(this.prompt instanceof SharedPromptDefinitionInterface)) {
                            if (this.infoMapUrl != this.currentIMSMap.getDataSourceLocation()) {
                                this.datasourcePicker.setValue(this.infoMapUrl);
                            } else {
                                this.dataSourceIsCurrentMap = true;
                            }
                        } else {
                            this.datasourcePicker.setValue(this.infoMapUrl);
                        }
                    }
                }
                this.currentDataSource = (DataSourceInterface)this.datasourcePicker.getValue();
                if (this.currentDataSource == null && this.dataSourceIsCurrentMap && this.communicator.isCurrentMapSelectorEnabled()) {
                    this.currentDataSource = this.currentIMSMap;
                }
            } else {
                long dataSourceType;
                DataSourceInterface userDataSource = null;
                if (this.communicator.getDataSourceColumn() != null) {
                    userDataSource = this.communicator.getDataSourceColumn().getDataSource();
                } else if (this.communicator.getDataSource() != null) {
                    userDataSource = this.communicator.getDataSource();
                }
                if (userDataSource != null && ((dataSourceType = userDataSource.getDataSourceType()) == 4L || dataSourceType == 1L)) {
                    if (this.communicator.isCurrentMapSelectorEnabled() && !(this.prompt instanceof SharedPromptDefinitionInterface)) {
                        if (userDataSource != this.currentIMSMap) {
                            this.datasourcePicker.setValue(userDataSource);
                        } else {
                            this.dataSourceIsCurrentMap = true;
                        }
                    } else {
                        this.datasourcePicker.setValue(userDataSource);
                    }
                    this.currentDataSource = (DataSourceInterface)this.datasourcePicker.getValue();
                    if (this.currentDataSource == null && this.dataSourceIsCurrentMap && this.communicator.isCurrentMapSelectorEnabled()) {
                        this.currentDataSource = this.currentIMSMap;
                    }
                }
            }
        }
        if (this.communicator.isCurrentMapSelectorEnabled()) {
            if (this.infoMapUrl != null && this.infoMapUrl.startsWith("/")) {
                this.currentMapRadio.setSelected(false);
                this.selectRadio.setSelected(true);
                this.datasourcePicker.setEnabled(true);
            } else {
                this.currentDataSource = this.currentIMSMap;
                this.datasourcePicker.setEnabled(false);
                this.selectRadio.setSelected(false);
                this.currentMapRadio.setSelected(true);
            }
        }
        this.datasourcePicker.addEditorListener(this);
        if (this.datasourcePicker.getValue() != null && !this.communicator.isDataSourceChangeable() && !(this.prompt instanceof SharedPromptDefinitionInterface)) {
            this.datasourcePicker.setEnabled(false);
        }
        return outerDatasourcePanel;
    }

    protected JPanel createMaximumDisplayValues() {
        TransparentGroup promptGroupMaxDisplay = new TransparentGroup();
        this.promptMaxDisplay = new IntegerDefinition("");
        if (this.selectionType == "Single value") {
            this.promptMaxDisplay.setPromptLabel(RB.getStringResource("maxDisplayCount.txt"), this.getLocale());
        } else {
            this.promptMaxDisplay.setPromptLabel(RB.getStringResource("maxDisplayCountPerTime.txt"), this.getLocale());
        }
        promptGroupMaxDisplay.addPromptDefinition((PromptDefinitionInterface)this.promptMaxDisplay);
        this.promptValuesMaxDisplay = new PromptValues((PromptGroupInterface)promptGroupMaxDisplay, null);
        PromptUtility.configurePromptValuesForMaximumDisplayValue(this.promptValuesMaxDisplay, this.prompt, (IntegerDefinitionInterface)this.promptMaxDisplay, this.communicator);
        this.promptPropertiesPanelMaxDisplay = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesMaxDisplay, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelMaxDisplay);
        return this.promptPropertiesPanelMaxDisplay;
    }

    protected void createCustomPanel() {
        if (this.customPanel != null) {
            this.removePropertyChangeListener(this);
        }
        this.promptObject = this.intializePrompt();
        if (this.initialized) {
            ((MutableSelectableDefinitionInterface)this.promptObject).clearDefaultValue();
            ((MutableValueProviderDefinitionInterface)this.promptObject).setValueProvider(null);
        }
        DataSourceInterface dataSource = null;
        dataSource = this.communicator.isCurrentMapSelectorEnabled() && !this.selectRadio.isSelected() ? this.currentIMSMap : (DataSourceInterface)this.datasourcePicker.getValue();
        if (dataSource == null && this.communicator.isCurrentMapSelectorEnabled() && !this.selectRadio.isSelected()) {
            dataSource = this.currentIMSMap;
        }
        String dataSourceLocation = null;
        if (dataSource != null) {
            dataSourceLocation = dataSource.getDataSourceLocation();
        }
        if (dataSource == null || dataSourceLocation == null || dataSourceLocation.trim().length() == 0) {
            this.customPanel = new DynamicValuesRelationalPanel(this.promptObject, this.selectionType, dataSource, (DynamicValueProviderInterface)this.valueProvider, this.communicator);
        } else {
            long dataSourceType = dataSource.getDataSourceType();
            if (dataSourceType == 4L || dataSourceType == 1L) {
                this.customPanel = this.valueProvider == null ? new DynamicValuesRelationalPanel(this.promptObject, this.selectionType, dataSource, this.communicator) : new DynamicValuesRelationalPanel(this.promptObject, this.selectionType, dataSource, (DynamicValueProviderInterface)this.valueProvider, this.communicator);
            } else if (dataSourceType == 8L) {
                this.customPanel = new DynamicValuesOLAPPanel(this.promptObject, this.selectionType, dataSource, (OLAPDataItemValueProvider)this.valueProvider, this.communicator);
            }
        }
        if (this.allowCustomValuesCheckBox != null && this.customPanel instanceof DynamicValuesRelationalPanel) {
            ((DynamicValuesRelationalPanel)this.customPanel).setAllowUserValues(this.allowCustomValuesCheckBox.isSelected());
        }
        this.initialized = true;
        this.customPanel.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        block15: {
            if (e.getPropertyName().equals("requiredState")) {
                boolean newValue = (Boolean)e.getNewValue();
                try {
                    if (this.promptValuesValueCount == null) break block15;
                    if (!newValue) {
                        this.promptValuesValueCount.clearPromptValue((PromptDefinitionInterface)this.promptMinValueCount);
                        break block15;
                    }
                    if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMinValueCount)) {
                        if ((Integer)this.promptValuesValueCount.getPromptValue((PromptDefinitionInterface)this.promptMinValueCount) <= 0) {
                            this.promptValuesValueCount.setPromptValue((PromptDefinitionInterface)this.promptMinValueCount, 1);
                        }
                        break block15;
                    }
                    this.promptValuesValueCount.setPromptValue((PromptDefinitionInterface)this.promptMinValueCount, 1);
                }
                catch (InvalidPromptValueException ipve) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ipve.getMessage());
                }
                catch (PromptValueNotFoundException pvnf) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
                }
            } else if (e.getPropertyName().equals("contentsValid")) {
                this.setContentsValid((Boolean)e.getNewValue());
            } else if (e.getPropertyName().equals("dataItemChanged")) {
                this.firePropertyChange("dataItemChanged", e.getNewValue(), e.getOldValue());
            } else if (e.getPropertyName().equals("valueProviderUpdateNeeded")) {
                this.firePropertyChange("valueProviderUpdateNeeded", e.getNewValue(), e.getOldValue());
            } else if (e.getPropertyName().equals("errorPanel")) {
                this.firePropertyChange("errorPanel", e.getOldValue(), e.getNewValue());
            }
        }
    }

    public void valueChanged(ChangeEvent e) {
        this.dataSourceChanged();
    }

    public void editingStopped(ChangeEvent e) {
    }

    public void editingStarted(ChangeEvent e) {
    }

    public void valueModified(ChangeEvent e) {
    }

    public void promptValueChanged(PromptValueChangeEventInterface event) {
        PromptDefinitionInterface promptDefinition = event.getPromptDefinition();
        if (promptDefinition.getPromptName().equals(PromptGroupUtility.MIN_VALUE_COUNT)) {
            try {
                if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMinValueCount)) {
                    Integer minValueCount = (Integer)this.promptValuesValueCount.getPromptValue((PromptDefinitionInterface)this.promptMinValueCount);
                    this.communicator.setRequired(minValueCount > 0);
                } else {
                    this.communicator.setRequired(false);
                }
            }
            catch (PromptValueNotFoundException pvnf) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
            }
        }
        this.verifyContentsValid();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.allowCustomValuesCheckBox) {
            boolean allowUserValues;
            int state = e.getStateChange();
            boolean bl = allowUserValues = state == 1;
            if (this.customPanel instanceof DynamicValuesRelationalPanel) {
                ((DynamicValuesRelationalPanel)this.customPanel).setAllowUserValues(allowUserValues);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.selectRadio) {
            this.currentMapRadio.setSelected(false);
            this.selectRadio.setSelected(true);
            this.datasourcePicker.setEnabled(true);
            this.dataSourceChanged();
            this.dataSourceIsCurrentMap = false;
            this.holderPanel.remove(this.customPanel);
            this.createCustomPanel();
            this.holderPanel.add((Component)this.customPanel, -1);
            this.customPanel.revalidate();
        } else if (e.getSource() == this.currentMapRadio) {
            this.dataSourceIsCurrentMap = true;
            this.selectRadio.setSelected(false);
            this.currentMapRadio.setSelected(true);
            this.datasourcePicker.setEnabled(false);
            this.currentDataSource = this.currentIMSMap;
            this.dataSourceChanged();
            this.holderPanel.remove(this.customPanel);
            this.createCustomPanel();
            this.holderPanel.add((Component)this.customPanel, -1);
            this.customPanel.revalidate();
        }
    }

    private void dataSourceChanged() {
        DataSourceInterface dataSource;
        if (!this.panelHasInitialDatasource) {
            this.holderPanel.remove(this.customPanel);
            PromptUtility.copyPropertiesToCommunicator(this.communicator, this.getPromptDefinition(true));
            this.createCustomPanel();
            if (this.customPanel != null) {
                this.customPanel.addPropertyChangeListener(this);
                this.holderPanel.add((Component)this.customPanel, -1);
                this.customPanel.updateUI();
            }
        }
        if ((dataSource = this.communicator.isCurrentMapSelectorEnabled() && !this.selectRadio.isSelected() ? this.currentIMSMap : (DataSourceInterface)this.datasourcePicker.getValue()) == null && this.dataSourceIsCurrentMap && this.communicator.isCurrentMapSelectorEnabled()) {
            dataSource = this.currentIMSMap;
        }
        String dataSourceLocation = null;
        if (dataSource != null) {
            dataSourceLocation = dataSource.getDataSourceLocation();
        }
        if (dataSource == null || dataSourceLocation == null || dataSourceLocation.trim().length() == 0) {
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)PromptUtility.getParentFrame(this.communicator, this), new Message(RB.getStringResource("invalidDatasource.txt")), null);
            }
            this.currentDataSource = dataSource;
            this.firePropertyChange("dataSourceValid", Boolean.TRUE, Boolean.FALSE);
        } else if (this.currentDataSource == null) {
            this.firePropertyChange("dataSourceValid", Boolean.FALSE, Boolean.TRUE);
            this.currentDataSource = dataSource;
        } else {
            this.firePropertyChange("dataSourceChanged", Boolean.FALSE, Boolean.TRUE);
            if (this.communicator.hasWhereClause()) {
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                int option = JOptionPane.showOptionDialog(PromptUtility.getParentFrame(this.communicator, this), RB.getStringResource("dependenciesError.txt"), RB.getStringResource("changeDataSource.txt"), -1, 2, null, CONFIRM_MESSAGE_DIALOG_OPTIONS, CONFIRM_MESSAGE_DIALOG_OPTIONS[0]);
                if (option == 0) {
                    this.holderPanel.remove(this.customPanel);
                    this.valueProvider = null;
                    PromptUtility.copyPropertiesToCommunicator(this.communicator, this.getPromptDefinition(true));
                    this.createCustomPanel();
                    if (this.customPanel != null) {
                        this.customPanel.addPropertyChangeListener(this);
                        this.holderPanel.add((Component)this.customPanel, -1);
                        this.customPanel.updateUI();
                    }
                    this.firePropertyChange("valueProviderUpdateNeeded", Boolean.TRUE, Boolean.FALSE);
                    this.currentDataSource = dataSource;
                } else {
                    this.datasourcePicker.removeEditorListener(this);
                    if (this.communicator.isCurrentMapSelectorEnabled()) {
                        if (this.currentDataSource != this.currentIMSMap) {
                            this.datasourcePicker.setValue(this.currentDataSource);
                            this.dataSourceIsCurrentMap = false;
                        } else {
                            this.dataSourceIsCurrentMap = true;
                        }
                    } else {
                        this.datasourcePicker.setValue(this.currentDataSource);
                    }
                    this.datasourcePicker.addEditorListener(this);
                }
            } else {
                this.holderPanel.remove(this.customPanel);
                this.valueProvider = null;
                PromptUtility.copyPropertiesToCommunicator(this.communicator, this.getPromptDefinition(true));
                this.createCustomPanel();
                if (this.customPanel != null) {
                    this.customPanel.addPropertyChangeListener(this);
                    this.holderPanel.add((Component)this.customPanel, -1);
                    this.customPanel.updateUI();
                }
                this.firePropertyChange("valueProviderUpdateNeeded", Boolean.TRUE, Boolean.FALSE);
                this.currentDataSource = dataSource;
            }
        }
        this.panelHasInitialDatasource = true;
        if (this.customPanel instanceof DynamicValuesRelationalPanel) {
            this.setContentsValid(((DynamicValuesRelationalPanel)this.customPanel).isContentsValid());
        } else {
            this.setContentsValid(true);
        }
    }
}

