/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.datatypes.DateType;
import com.sas.datatypes.MonthType;
import com.sas.datatypes.QuarterType;
import com.sas.datatypes.TimeStampType;
import com.sas.datatypes.TimeType;
import com.sas.datatypes.WeekType;
import com.sas.datatypes.YearType;
import com.sas.prompts.definitions.DateDefinition;
import com.sas.prompts.definitions.DateDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.visuals.swing.designtime.BasePromptTypePanel;
import com.sas.prompts.visuals.swing.designtime.DateCustomListPanel;
import com.sas.prompts.visuals.swing.designtime.DateDynamicListPanel;
import com.sas.prompts.visuals.swing.designtime.DateMultipleValuesPanel;
import com.sas.prompts.visuals.swing.designtime.DateSingleValuePanel;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionInterface;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionWithErrorSuppressionOptionInterface;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.swing.visuals.ComboBox;
import com.sas.swing.visuals.PanelInterface;
import com.sas.text.Message;
import com.sas.util.DateTypes;
import com.sas.util.SupportedSpecialValuesInterface;
import com.sas.util.ValueItem;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;

class BaseDatePanel
extends BasePromptTypePanel
implements ActionListener,
PropertyChangeListener {
    private boolean contentsValid;
    protected String selectionType;
    protected String listType;
    protected ComboBox dateTypeCombo;
    private JPanel dateTypePanel;
    protected JPanel customPanel;
    protected PromptDefinitionInterface prompt;
    private JLabel dateHint;
    private ValueItem dayValueItem;
    private ValueItem weekValueItem;
    private ValueItem monthValueItem;
    private ValueItem quarterValueItem;
    private ValueItem yearValueItem;
    private DateTypes dateType;
    static final String DATE_TYPE = "dateType";
    private static String DAY_HINT = Message.format((String)RB.getStringResource("dateHint.fmt.txt"), (Object)DateType.DEFAULT_INSTANCE.getDisplayString((Object)new Date(), Locale.getDefault()));
    private static String WEEK_HINT = Message.format((String)RB.getStringResource("dateHint.fmt.txt"), (Object)WeekType.DEFAULT_INSTANCE.getDisplayString((Object)new Date(), Locale.getDefault()));
    private static String MONTH_HINT = Message.format((String)RB.getStringResource("dateHint.fmt.txt"), (Object)MonthType.DEFAULT_INSTANCE.getDisplayString((Object)new Date(), Locale.getDefault()));
    private static String QUARTER_HINT = Message.format((String)RB.getStringResource("dateHint.fmt.txt"), (Object)QuarterType.DEFAULT_INSTANCE.getDisplayString((Object)new Date(), Locale.getDefault()));
    private static String YEAR_HINT = Message.format((String)RB.getStringResource("dateHint.fmt.txt"), (Object)YearType.DEFAULT_INSTANCE.getDisplayString((Object)new Date(), Locale.getDefault()));
    static String TIME_HINT = Message.format((String)RB.getStringResource("dateHint.fmt.txt"), (Object)TimeType.DEFAULT_INSTANCE.getDisplayString((Object)new Date(), Locale.getDefault()));
    static String TIMESTAMP_HINT = Message.format((String)RB.getStringResource("dateHint.fmt.txt"), (Object)TimeStampType.DEFAULT_INSTANCE.getDisplayString((Object)new Date(), Locale.getDefault()));
    private static final long serialVersionUID = 3257563988660598326L;

    public BaseDatePanel(PromptDefinitionInterface prompt, String selectionType, String listType, PropertiesCommunicator communicator, DateTypes dateType) {
        super(communicator);
        this.dateType = dateType;
        this.contentsValid = true;
        this.prompt = prompt;
        this.selectionType = selectionType;
        this.listType = listType;
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 5, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        this.dateTypePanel = new JPanel();
        AutoSizingGridLayout dateTypeLayout = new AutoSizingGridLayout(2, 1, 10, 5, true, false, true);
        this.dateTypePanel.setLayout((LayoutManager)dateTypeLayout);
        JPanel dateLabelPanel = new JPanel();
        AutoSizingGridLayout dateLabelLayout = new AutoSizingGridLayout(1, 1, 10, 5, true, false, true);
        dateLabelPanel.setLayout((LayoutManager)dateLabelLayout);
        JLabel dateTypeLabel = new JLabel(RB.getStringResource("dateType.txt"));
        dateLabelPanel.add(dateTypeLabel);
        JPanel dateComboPanel = new JPanel();
        AutoSizingGridLayout dateComboLayout = new AutoSizingGridLayout(1, 2, 10, 5, true, false, true);
        dateComboLayout.setRemainderColumn(1);
        dateComboPanel.setLayout((LayoutManager)dateComboLayout);
        this.dateTypeCombo = new ComboBox();
        DefaultComboBoxModel<ValueItem> dateTypeModel = new DefaultComboBoxModel<ValueItem>();
        if (this.shouldDisplayDateSelector()) {
            this.dayValueItem = PromptUtility.newDayValueItem();
            dateTypeModel.addElement(this.dayValueItem);
            this.weekValueItem = PromptUtility.newWeekValueItem();
            dateTypeModel.addElement(this.weekValueItem);
            this.monthValueItem = PromptUtility.newMonthValueItem();
            dateTypeModel.addElement(this.monthValueItem);
            this.quarterValueItem = PromptUtility.newQuarterValueItem();
            dateTypeModel.addElement(this.quarterValueItem);
            this.yearValueItem = PromptUtility.newYearValueItem();
            dateTypeModel.addElement(this.yearValueItem);
            this.dateTypeCombo.setModel(dateTypeModel);
            dateTypeLabel.setLabelFor((Component)this.dateTypeCombo);
            this.dateHint = new JLabel(DAY_HINT);
            dateComboPanel.add((Component)this.dateTypeCombo);
            dateComboPanel.add(this.dateHint);
            this.dateTypePanel.add(dateLabelPanel);
            this.dateTypePanel.add(dateComboPanel);
        }
        if (prompt != null) {
            if (dateType != null) {
                this.setDateFields(dateType);
            } else {
                this.dateTypeCombo.setSelectedItem((Object)DAY);
                this.dateHint.setText(DAY_HINT);
            }
        }
        this.createCustomPanel();
        this.add(this.dateTypePanel);
        this.add(this.customPanel);
        this.dateTypeCombo.addActionListener((ActionListener)this);
        this.customPanel.addPropertyChangeListener(this);
    }

    public BaseDatePanel(PromptDefinitionInterface prompt, String selectionType, String listType, PropertiesCommunicator communicator) {
        this(prompt, selectionType, listType, communicator, DateTypes.DATE);
    }

    protected void createCustomPanel() {
        DateTypes dateType;
        Map map = this.communicator.getPromptProperties();
        if (map.containsKey(DATE_TYPE) && (dateType = (DateTypes)map.get(DATE_TYPE)) != null) {
            this.setDateFields(dateType);
        }
        if (this.customPanel != null) {
            this.removePropertyChangeListener(this);
        }
        if (this.prompt == null) {
            DateTypes selectedItemType;
            if (this.dateTypeCombo.getItemCount() > 0) {
                String selectedItem = (String)((ValueItem)this.dateTypeCombo.getSelectedItem()).getValue();
                selectedItemType = this.convertStringToDateType(selectedItem);
            } else {
                selectedItemType = this.dateType;
            }
            this.customPanel = this.listType.equals("User selects values from a static list") ? new DateCustomListPanel(selectedItemType, this.selectionType, this.communicator) : (this.listType.equals("User selects values from a dynamic list") ? new DateDynamicListPanel((DateDefinitionInterface)this.prompt, this.selectionType, selectedItemType, this.communicator) : (this.selectionType.equals("Single value") ? new DateSingleValuePanel((DateDefinitionInterface)this.prompt, selectedItemType, this.communicator) : new DateMultipleValuesPanel((DateDefinitionInterface)this.prompt, this.selectionType, selectedItemType, this.communicator)));
        } else if (this.prompt instanceof DateDefinitionInterface) {
            this.customPanel = this.listType.equals("User selects values from a static list") ? new DateCustomListPanel((DateDefinitionInterface)this.prompt, this.selectionType, ((DateDefinitionInterface)this.prompt).getDateType(), this.communicator) : (this.listType.equals("User selects values from a dynamic list") ? new DateDynamicListPanel((DateDefinitionInterface)this.prompt, this.selectionType, ((DateDefinitionInterface)this.prompt).getDateType(), this.communicator) : (this.selectionType.equals("Single value") ? new DateSingleValuePanel((DateDefinitionInterface)this.prompt, ((DateDefinitionInterface)this.prompt).getDateType(), this.communicator) : new DateMultipleValuesPanel((DateDefinitionInterface)this.prompt, this.selectionType, ((DateDefinitionInterface)this.prompt).getDateType(), this.communicator)));
        }
    }

    protected DateTypes getDataTypeForPrompt(PromptDefinitionInterface promptObject) {
        if (promptObject instanceof DateDefinitionInterface) {
            return ((DateDefinitionInterface)promptObject).getDateType();
        }
        return null;
    }

    protected DateTypes convertStringToDateType(String dateTypeString) {
        if ("Date".equals(dateTypeString)) {
            return DateTypes.DATE;
        }
        if ("Week".equals(dateTypeString)) {
            return DateTypes.WEEK;
        }
        if ("Month".equals(dateTypeString)) {
            return DateTypes.MONTH;
        }
        if ("Quarter".equals(dateTypeString)) {
            return DateTypes.QUARTER;
        }
        if ("Year".equals(dateTypeString)) {
            return DateTypes.YEAR;
        }
        return DateTypes.DATE;
    }

    protected void setDateFields(DateTypes dateType) {
        if (this.dateTypeCombo != null && this.dateHint != null) {
            if (DateTypes.DATE.equals(dateType)) {
                this.dateTypeCombo.setSelectedItem((Object)this.dayValueItem);
                this.dateHint.setText(DAY_HINT);
            } else if (DateTypes.WEEK.equals(dateType)) {
                this.dateTypeCombo.setSelectedItem((Object)this.weekValueItem);
                this.dateHint.setText(WEEK_HINT);
            } else if (DateTypes.MONTH.equals(dateType)) {
                this.dateTypeCombo.setSelectedItem((Object)this.monthValueItem);
                this.dateHint.setText(MONTH_HINT);
            } else if (DateTypes.QUARTER.equals(dateType)) {
                this.dateTypeCombo.setSelectedItem((Object)this.quarterValueItem);
                this.dateHint.setText(QUARTER_HINT);
            } else if (DateTypes.YEAR.equals(dateType)) {
                this.dateTypeCombo.setSelectedItem((Object)this.yearValueItem);
                this.dateHint.setText(YEAR_HINT);
            }
        }
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        if (this.customPanel instanceof GetPromptDefinitionWithErrorSuppressionOptionInterface) {
            return ((GetPromptDefinitionWithErrorSuppressionOptionInterface)((Object)this.customPanel)).getPromptDefinition(suppressErrors);
        }
        return ((GetPromptDefinitionInterface)((Object)this.customPanel)).getPromptDefinition();
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return ((GetPromptDefinitionInterface)((Object)this.customPanel)).getPromptDefinition();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("dataSourceValid".equals(evt.getPropertyName())) {
            this.firePropertyChange("dataSourceValid", evt.getOldValue(), evt.getNewValue());
        } else if ("dataSourceChanged".equals(evt.getPropertyName())) {
            this.firePropertyChange("dataSourceChanged", evt.getOldValue(), evt.getNewValue());
        } else if ("valueProviderUpdateNeeded".equals(evt.getPropertyName())) {
            this.firePropertyChange("valueProviderUpdateNeeded", evt.getOldValue(), evt.getNewValue());
        } else if ("dataItemChanged".equals(evt.getPropertyName())) {
            this.firePropertyChange("dataItemChanged", evt.getOldValue(), evt.getNewValue());
        } else if ("contentsValid".equals(evt.getPropertyName())) {
            this.setContentsValid((Boolean)evt.getNewValue());
        } else if ("errorPanel".equals(evt.getPropertyName())) {
            this.firePropertyChange("errorPanel", evt.getOldValue(), evt.getNewValue());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DateTypes type;
        this.contentsValid = true;
        this.communicator.clearPromptProperties();
        PromptDefinitionInterface defn = this.getPromptDefinition(true);
        if (defn instanceof SupportedSpecialValuesInterface) {
            DateDefinition input = new DateDefinition();
            input.setSupportedSpecialValues(((SupportedSpecialValuesInterface)defn).getSupportedSpecialValues());
            input.setAllowUserValues(((DateDefinitionInterface)defn).isAllowUserValues());
            PromptUtility.copyPropertiesToCommunicator(this.communicator, (PromptDefinitionInterface)input);
        }
        Map map = this.communicator.getPromptProperties();
        if (this.shouldDisplayDateSelector()) {
            String dateType = (String)((ValueItem)this.dateTypeCombo.getSelectedItem()).getValue();
            type = this.convertStringToDateType(dateType);
        } else {
            type = this.dateType;
        }
        map.put(DATE_TYPE, type);
        this.remove(this.customPanel);
        this.prompt = null;
        this.createCustomPanel();
        this.customPanel.addPropertyChangeListener(this);
        this.add((Component)this.customPanel, -1);
        this.customPanel.revalidate();
        this.setContentsValid(true);
    }

    boolean shouldDisplayDateSelector() {
        if (DateTypes.DATE.equals(this.dateType)) {
            return true;
        }
        if (DateTypes.WEEK.equals(this.dateType)) {
            return true;
        }
        if (DateTypes.MONTH.equals(this.dateType)) {
            return true;
        }
        if (DateTypes.QUARTER.equals(this.dateType)) {
            return true;
        }
        return DateTypes.YEAR.equals(this.dateType);
    }

    @Override
    public boolean isContentsValid() {
        if (this.customPanel != null && this.customPanel instanceof PanelInterface) {
            return ((PanelInterface)this.customPanel).isContentsValid();
        }
        return true;
    }

    @Override
    public void setContentsValid(boolean newValue) {
        if (newValue != this.contentsValid) {
            this.contentsValid = newValue;
            this.firePropertyChange("contentsValid", !this.contentsValid, this.contentsValid);
        }
    }
}

