/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing;

import com.sas.datatypes.ColorType;
import com.sas.prompts.PromptComponentModelInterface;
import com.sas.prompts.PromptGroupPanelModelInterface;
import com.sas.prompts.visuals.swing.PromptListNode;
import com.sas.util.Strings;
import java.awt.Component;
import java.awt.SystemColor;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class PromptGroupListCellRenderer
extends DefaultListCellRenderer {
    private static String highlightColorString = "#" + ColorType.DEFAULT_INSTANCE.getValueAsString((Object)SystemColor.textHighlight, Locale.US).substring(2);
    private static String disabledHTML = "#" + ColorType.DEFAULT_INSTANCE.getValueAsString((Object)SystemColor.textInactiveText, Locale.US).substring(2);
    private static char[] htmlSpecialCharacters = new char[]{'<', '>', ' '};
    private static String[] htmlSpecialCharacterReplacements = new String[]{"&lt;", "&gt;", "&nbsp;"};

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value instanceof PromptListNode) {
            int level = ((PromptListNode)value).getLevel();
            this.setBorder(BorderFactory.createEmptyBorder(0, level * 15 + 2, 0, 2));
            PromptGroupPanelModelInterface group = ((PromptListNode)value).getPromptGroupPanelModel();
            List definitions = group.getObjects(2);
            int totalRequiredCount = 0;
            int emptyRequiredCount = 0;
            for (PromptComponentModelInterface componentModel : definitions) {
                if (!componentModel.getPromptDefinition().isRequired()) continue;
                ++totalRequiredCount;
                if (componentModel.isPromptValueAvailable()) continue;
                ++emptyRequiredCount;
            }
            String text = "<html>";
            String val = value.toString();
            if (val == null) {
                val = "";
            }
            val = this.replaceSpecialCharacters(val);
            if (emptyRequiredCount > 0) {
                val = "<b>" + val + "</b>";
            }
            if (!list.isEnabled()) {
                val = "<font color = " + disabledHTML + ">" + val + "</font>";
            }
            text = text + val;
            if (emptyRequiredCount > 0) {
                text = isSelected ? text + "&nbsp;(" + emptyRequiredCount + ")" : text + "&nbsp;<font color = " + highlightColorString + ">(" + emptyRequiredCount + ")</font>";
            }
            if (totalRequiredCount > 0) {
                text = isSelected ? text + "&nbsp;*" : text + "&nbsp;<b>*</b>";
            }
            text = text + "</html>";
            this.setText(text);
        }
        return component;
    }

    public String replaceSpecialCharacters(String inputString) {
        return Strings.replace((String)inputString, (char[])htmlSpecialCharacters, (String[])htmlSpecialCharacterReplacements);
    }
}

