/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing;

import com.sas.prompts.PromptComponentModelInterface;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.SelectableDefinitionInterface;
import com.sas.prompts.visuals.swing.BasePromptVisualEditor;
import com.sas.prompts.visuals.swing.PromptEditorFactory;
import com.sas.swing.visuals.EditorInterface;
import com.sas.swing.visuals.EditorListener;
import com.sas.swing.visuals.ValueListEditor;
import com.sas.util.errorhandlers.SupportsGenericErrorHandlerInterface;
import java.util.Collection;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;

public class PromptEditorPanel
extends BasePromptVisualEditor
implements EditorListener {
    private EditorInterface editor;
    private Object lastGetValue;
    private boolean valueModified;
    private boolean ignoreEvents;

    @Override
    public EditorInterface createPromptPanel(PromptComponentModelInterface component) {
        this.init(component);
        this.editor = PromptEditorFactory.defaultInstance.getEditor(component);
        if (this.editor instanceof SupportsGenericErrorHandlerInterface) {
            ((SupportsGenericErrorHandlerInterface)this.editor).setGenericErrorHandler(this.getGenericErrorHandler());
        }
        if (this.editor instanceof ValueListEditor && ((ValueListEditor)this.editor).getEditor() instanceof SupportsGenericErrorHandlerInterface) {
            ((SupportsGenericErrorHandlerInterface)((ValueListEditor)this.editor).getEditor()).setGenericErrorHandler(this.getGenericErrorHandler());
        }
        if (component.isPromptValueAvailable()) {
            this.originalValue = component.getPromptValue();
            this.originalSet = true;
            this.editor.setValue(this.originalValue);
        }
        this.editor.addEditorListener((EditorListener)this);
        this.promptVisual = this.editor;
        this.component = component;
        return this.editor;
    }

    @Override
    public Object getPromptValue() {
        this.lastGetValue = this.editor.getValue();
        return this.lastGetValue;
    }

    @Override
    public void dispose() {
        super.dispose();
        PromptEditorFactory.defaultInstance.cleanupEditor(this.editor);
    }

    public void valueChanged(ChangeEvent e) {
        if (this.ignoreEvents) {
            return;
        }
        this.valueModified = false;
        PromptDefinitionInterface def = this.component.getPromptDefinition();
        if (def instanceof SelectableDefinitionInterface) {
            SelectableDefinitionInterface selectable = (SelectableDefinitionInterface)def;
            if (selectable.getSelectionType() == 300 || !def.isRequired() || !def.isDefaultValueSet()) {
                this.updatePromptValue();
            } else {
                Object value = this.getPromptValue();
                if (value != null && value instanceof Collection && !((Collection)value).isEmpty() || !this.editor.isEditing()) {
                    this.updatePromptValue();
                } else {
                    this.valueModified = true;
                }
            }
        } else {
            this.updatePromptValue();
        }
    }

    public void editingStarted(ChangeEvent e) {
    }

    public void valueModified(ChangeEvent e) {
        this.valueModified = true;
    }

    public void editingStopped(ChangeEvent e) {
        if (this.valueModified || !this.isContentsValid()) {
            this.updatePromptValue();
            this.valueModified = false;
        }
    }

    @Override
    public void handlePromptValueChanged() {
        super.handlePromptValueChanged();
        try {
            this.ignoreEvents = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (PromptEditorPanel.this.component.isPromptValueAvailable()) {
                        Object value = PromptEditorPanel.this.component.getPromptValue();
                        if (!PromptUtil.isPromptValuesEqual((Object)value, (Object)PromptEditorPanel.this.lastGetValue)) {
                            PromptEditorPanel.this.lastGetValue = value;
                            PromptEditorPanel.this.editor.setValue(value);
                        }
                    } else {
                        PromptEditorPanel.this.lastGetValue = null;
                        PromptEditorPanel.this.editor.setValue(null);
                    }
                }
            });
        }
        finally {
            this.ignoreEvents = false;
        }
    }
}

