/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing;

import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptComponentModelInterface;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.definitions.HintableDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.PromptVisualEditorInterface;
import com.sas.prompts.visuals.swing.RB;
import com.sas.swing.visuals.EditorInterface;
import com.sas.swing.visuals.EditorListener;
import com.sas.swing.visuals.LabelView;
import com.sas.swing.visuals.UnderlineIcon;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.util.Strings;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class PromptContainer
extends JPanel
implements ChangeListener,
ActionListener {
    private static final long serialVersionUID = -411277273361246703L;
    public static final String RB_KEY = "PromptContainer.";
    protected JPanel rightPanel;
    protected JPanel indentPanel;
    protected LabelView promptLabel;
    protected JPanel requiredPanel;
    protected JLabel requiredLabel;
    protected JPanel labelPanel;
    protected EditorInterface promptComponent;
    protected LabelView descriptionLabel;
    protected LabelView hintLabel;
    protected JLabel errorLabel;
    protected JPanel seperatorPanel;
    protected JButton resetPromptButton;
    protected PromptPropertiesPanel propertiesPanel;
    protected PromptVisualEditorInterface promptPanel;
    protected PromptComponentModelInterface component;
    protected EditorListener editorListener;
    private EventListenerList listenerList = new EventListenerList();
    private transient ChangeEvent changeEvent = null;
    private static final int MIN_WRAP_WIDTH = 400;
    private static char[] htmlSpecialCharacters = new char[]{'<', '>', '\n'};
    private static String[] htmlSpecialCharacterReplacements = new String[]{"&lt;", "&gt;", "<BR>"};

    public PromptContainer(PromptComponentModelInterface component, PromptVisualEditorInterface promptPanel, PromptPropertiesPanel propertiesPanel) {
        this.component = component;
        this.promptPanel = promptPanel;
        this.propertiesPanel = propertiesPanel;
        this.editorListener = new PromptEditorListener();
        PromptDefinitionInterface promptDefinition = component.getPromptDefinition();
        this.setName(promptDefinition.getPromptName());
        this.setOpaque(false);
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(2, 1, 5, 5, true, false, true);
        mainLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this.setLayout((LayoutManager)mainLayout);
        JPanel innerPanel = new JPanel();
        innerPanel.setOpaque(false);
        AutoSizingGridLayout gridLayout = new AutoSizingGridLayout(1, 2, 5, 0, true, false, true);
        gridLayout.setIgnoreSizeOfNonVisibleComponents(true);
        innerPanel.setLayout((LayoutManager)gridLayout);
        String label = promptDefinition.getPromptLabel(component.getLocale());
        boolean isRequired = promptDefinition.isRequired();
        this.promptLabel = new LabelView(label);
        this.promptLabel.setWrapStyleWord(true);
        this.promptLabel.setLineWrap(true);
        this.promptLabel.setPreferredSpanSize(new Dimension(-101, -1));
        this.promptLabel.setName(promptDefinition.getPromptName() + "Label");
        this.promptLabel.setMinimumWrapWidth(400);
        this.errorLabel = new JLabel();
        this.errorLabel.setName(promptDefinition.getPromptName() + "ErrorLabel");
        this.errorLabel.setVisible(false);
        this.resetPromptButton = new JButton(RB.getStringResource(RB_KEY, "reset.txt"));
        this.resetPromptButton.setIcon((Icon)new UnderlineIcon(false));
        this.resetPromptButton.setRolloverIcon((Icon)new UnderlineIcon(true));
        this.resetPromptButton.setMargin(LayoutConstants.EMPTY_INSETS);
        this.resetPromptButton.setBorderPainted(false);
        this.resetPromptButton.setContentAreaFilled(false);
        this.resetPromptButton.setVisible(propertiesPanel.isShowResetPerDefinition() && !promptDefinition.isFixed());
        this.resetPromptButton.setForeground(SystemColor.blue);
        this.resetPromptButton.addActionListener(this);
        this.handleResetButton();
        this.requiredPanel = new JPanel();
        this.requiredPanel.setOpaque(false);
        AutoSizingGridLayout requiredLayout = new AutoSizingGridLayout(-1, 1, 0, 0, false, false, false);
        requiredLayout.setDefaultCellGravity(5);
        requiredLayout.setGridGravity(5);
        this.requiredPanel.setLayout((LayoutManager)requiredLayout);
        this.requiredLabel = new JLabel();
        this.requiredLabel.setFont(this.requiredLabel.getFont().deriveFont(1));
        this.requiredLabel.setText("*");
        if (!isRequired) {
            this.requiredLabel.setVisible(false);
        }
        if (!propertiesPanel.isShowRequiredLabel()) {
            this.requiredPanel.setVisible(false);
        }
        this.requiredPanel.add(this.requiredLabel);
        innerPanel.add(this.requiredPanel);
        this.rightPanel = new JPanel();
        this.rightPanel.setOpaque(false);
        AutoSizingGridLayout rightLayout = new AutoSizingGridLayout(-1, 1, 0, 3, true, false, true);
        rightLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this.rightPanel.setLayout((LayoutManager)rightLayout);
        this.labelPanel = new JPanel();
        this.labelPanel.setOpaque(false);
        AutoSizingGridLayout labelLayout = new AutoSizingGridLayout(1, -1, 5, 0, true, false, true);
        labelLayout.setRemainderColumn(2);
        labelLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this.labelPanel.setLayout((LayoutManager)labelLayout);
        this.labelPanel.add(this.errorLabel);
        this.labelPanel.add((Component)this.promptLabel);
        this.labelPanel.add(this.resetPromptButton);
        this.rightPanel.add(this.labelPanel);
        this.indentPanel = new JPanel();
        this.indentPanel.setOpaque(false);
        if (propertiesPanel.isVisualsIndented()) {
            this.indentPanel.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 0));
        }
        AutoSizingGridLayout indentLayout = new AutoSizingGridLayout(-1, 1, 0, 3, true, false, true);
        indentLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this.indentPanel.setLayout((LayoutManager)indentLayout);
        String description = promptDefinition.getPromptDescription(component.getLocale());
        this.descriptionLabel = new LabelView(description);
        this.descriptionLabel.setWrapStyleWord(true);
        this.descriptionLabel.setLineWrap(true);
        this.descriptionLabel.setPreferredSpanSize(new Dimension(-101, -1));
        this.descriptionLabel.setMinimumWrapWidth(400);
        this.descriptionLabel.setForeground((Color)SystemColor.textInactiveText);
        if (description == null || description.trim().length() == 0) {
            this.descriptionLabel.setVisible(false);
        }
        this.indentPanel.add((Component)this.descriptionLabel);
        String hint = null;
        if (promptDefinition instanceof HintableDefinitionInterface) {
            hint = ((HintableDefinitionInterface)promptDefinition).getHint(component.getLocale());
        }
        this.hintLabel = new LabelView(hint);
        this.hintLabel.setWrapStyleWord(true);
        this.hintLabel.setLineWrap(true);
        this.hintLabel.setForeground((Color)SystemColor.textInactiveText);
        this.hintLabel.setPreferredSpanSize(new Dimension(-101, -1));
        this.hintLabel.setMinimumWrapWidth(400);
        this.hintLabel.setFont(this.hintLabel.getFont().deriveFont(2));
        if (hint == null || hint.trim().length() == 0) {
            this.hintLabel.setVisible(false);
        }
        this.indentPanel.add((Component)this.hintLabel);
        this.rightPanel.add(this.indentPanel);
        innerPanel.add(this.rightPanel);
        this.seperatorPanel = this.createSeparatorPanel();
        this.seperatorPanel.setVisible(propertiesPanel.isShowSeparators());
        this.add(innerPanel);
        this.add(this.seperatorPanel);
        promptPanel.addChangeListener(this);
    }

    protected JPanel createSeparatorPanel() {
        JPanel separatorPanel = null;
        separatorPanel = new JPanel();
        separatorPanel.setName("SeparatorPanel");
        separatorPanel.setOpaque(false);
        separatorPanel.setLayout(new BorderLayout());
        separatorPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        JSeparator separator = new JSeparator();
        separatorPanel.add((Component)separator, "Center");
        return separatorPanel;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && this.promptComponent == null) {
            this.promptComponent = this.promptPanel.createPromptPanel(this.component);
            this.promptComponent.getEditorComponent().setName(this.component.getPromptDefinition().getPromptName() + "Visual");
            this.promptLabel.setLinkedComponent(this.promptComponent.getEditorComponent());
            this.descriptionLabel.setLinkedComponent(this.promptComponent.getEditorComponent());
            this.hintLabel.setLinkedComponent(this.promptComponent.getEditorComponent());
            this.indentPanel.add(this.promptComponent.getEditorComponent(), 1);
            this.promptLabel.setLabelFor(this.promptComponent.getEditorComponent());
            this.promptComponent.addEditorListener(this.editorListener);
        }
        super.setVisible(visible);
    }

    private void showErrorState(boolean state, String errorMessage) {
        if (state) {
            this.errorLabel.setIcon(this.propertiesPanel.getErrorIcon());
            errorMessage = Strings.replace((String)errorMessage, (char[])htmlSpecialCharacters, (String[])htmlSpecialCharacterReplacements);
            this.errorLabel.setToolTipText("<html><font face=\"sansserif\"><table cellpadding=\"2\"><tr><td>" + errorMessage + "</td></tr></table></font></html>");
            this.errorLabel.setVisible(true);
        } else {
            this.errorLabel.setIcon(null);
            this.errorLabel.setToolTipText(null);
            this.errorLabel.setVisible(false);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.promptLabel != null) {
            this.promptLabel.setEnabled(enabled);
        }
        if (this.requiredLabel != null) {
            this.requiredLabel.setEnabled(enabled);
        }
        if (this.requiredPanel != null) {
            this.requiredPanel.setEnabled(enabled);
        }
        if (this.errorLabel != null) {
            this.errorLabel.setEnabled(enabled);
        }
        if (this.descriptionLabel != null) {
            this.descriptionLabel.setEnabled(enabled);
        }
        if (this.hintLabel != null) {
            this.hintLabel.setEnabled(enabled);
        }
        if (this.seperatorPanel != null) {
            this.seperatorPanel.setEnabled(enabled);
        }
        if (this.promptComponent != null && this.promptComponent.getEditorComponent() != null) {
            this.promptComponent.getEditorComponent().setEnabled(enabled);
        }
    }

    private void handleResetButton() {
        if (this.component.getPromptDefinition().isFixed()) {
            this.resetPromptButton.setVisible(false);
        } else if (this.component.getPromptDefinition().isDefaultValueSet()) {
            if (PromptUtil.isPromptValuesEqual((Object)this.component.getPromptDefinition().getDefaultValue(), (Object)this.component.getPromptValue())) {
                this.resetPromptButton.setEnabled(false);
            } else {
                this.resetPromptButton.setEnabled(true);
            }
        } else if (PromptUtil.isPromptValuesEqual(null, (Object)this.component.getPromptValue())) {
            this.resetPromptButton.setEnabled(false);
        } else {
            this.resetPromptButton.setEnabled(true);
        }
    }

    public void setShowRequiredLabel(boolean showRequiredCheckBox) {
        this.requiredPanel.setVisible(showRequiredCheckBox);
    }

    public void setShowResetPerDefinition(boolean showResetPerDefinition) {
        this.resetPromptButton.setVisible(showResetPerDefinition);
        if (showResetPerDefinition) {
            this.handleResetButton();
        }
    }

    public void setSeperatorVisible(boolean b) {
        this.seperatorPanel.setVisible(b);
    }

    public void setVisualsIndented(boolean indentVisuals) {
        if (indentVisuals) {
            this.indentPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        } else {
            this.indentPanel.setBorder(null);
        }
    }

    public PromptComponentModelInterface getPromptComponentModel() {
        return this.component;
    }

    public void addEditorListener(EditorListener listener) {
        this.listenerList.add(EditorListener.class, listener);
    }

    public void removeEditorListener(EditorListener listener) {
        this.listenerList.remove(EditorListener.class, listener);
    }

    public EditorListener[] getEditorListeners() {
        return (EditorListener[])this.listenerList.getListeners(EditorListener.class);
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingStarted() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).editingStarted(this.changeEvent);
        }
    }

    protected void fireValueModified() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).valueModified(this.changeEvent);
        }
    }

    protected void fireValueChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).valueChanged(this.changeEvent);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.showErrorState(!this.promptPanel.isContentsValid(), this.promptPanel.getErrorMessage());
        if (this.propertiesPanel.isShowResetPerDefinition()) {
            this.handleResetButton();
        }
    }

    public PromptVisualEditorInterface getPromptVisualEditor() {
        return this.promptPanel;
    }

    @Override
    public void requestFocus() {
        if (this.promptComponent != null) {
            this.promptComponent.getEditorComponent().requestFocus();
        }
        super.requestFocus();
    }

    @Override
    public boolean requestFocus(boolean temporary) {
        if (this.promptComponent != null && this.promptComponent.getEditorComponent() instanceof JComponent) {
            return ((JComponent)this.promptComponent.getEditorComponent()).requestFocus(temporary);
        }
        return super.requestFocus(temporary);
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.promptComponent != null) {
            return this.promptComponent.getEditorComponent().requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.resetPromptButton) {
            try {
                this.component.resetToDefaultValues();
            }
            catch (InvalidPromptValueException e1) {
                e1.printStackTrace();
            }
        }
    }

    private class PromptEditorListener
    implements EditorListener {
        private PromptEditorListener() {
        }

        public void editingStarted(ChangeEvent e) {
            PromptContainer.this.fireEditingStarted();
        }

        public void editingStopped(ChangeEvent e) {
            PromptContainer.this.fireEditingStopped();
        }

        public void valueChanged(ChangeEvent e) {
            PromptContainer.this.fireValueChanged();
        }

        public void valueModified(ChangeEvent e) {
            PromptContainer.this.fireValueModified();
        }
    }
}

