/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing;

import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DataTypeUtil;
import com.sas.prompts.PromptComponentModelInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.SelectableDefinitionInterface;
import com.sas.prompts.definitions.TextDefinitionInterface;
import com.sas.prompts.visuals.swing.BasePromptVisualEditor;
import com.sas.swing.visuals.EditorInterface;
import com.sas.swing.visuals.EditorListener;
import com.sas.swing.visuals.TextEditor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class FixedPromptPanel
extends BasePromptVisualEditor {
    @Override
    public EditorInterface createPromptPanel(PromptComponentModelInterface component) {
        SelectableDefinitionInterface selectableDef;
        this.init(component);
        Object visualToReturn = null;
        PromptDefinitionInterface promptDefinition = component.getPromptDefinition();
        DataTypeInterface dataType = DataTypeUtil.getContainedDataType((DataTypeInterface)promptDefinition.getPromptDataType());
        if (promptDefinition instanceof SelectableDefinitionInterface && ((selectableDef = (SelectableDefinitionInterface)promptDefinition).getSelectionType() == 301 || selectableDef.getSelectionType() == 302)) {
            JList<Object> list = new JList<Object>();
            if (component.isPromptValueAvailable()) {
                Collection collection = (Collection)component.getPromptValue();
                ArrayList<String> copyOfCollection = new ArrayList<String>();
                for (Object element : collection) {
                    copyOfCollection.add(dataType.getDisplayString(element, component.getLocale()));
                }
                this.originalValue = copyOfCollection;
                list.setListData(copyOfCollection.toArray());
            }
            EditorScrollPane scrollPane = new EditorScrollPane(list);
            scrollPane.setOpaque(false);
            list.setBackground(scrollPane.getBackground());
            visualToReturn = scrollPane;
        }
        if (visualToReturn == null) {
            TextEditor text = new TextEditor();
            if (promptDefinition instanceof TextDefinitionInterface && ((TextDefinitionInterface)promptDefinition).isAllowMultipleLines()) {
                text.setMultiLine(true);
            }
            text.getTextComponent().setEditable(false);
            text.getTextComponent().setOpaque(false);
            text.getTextComponent().setBorder(null);
            if (component.isPromptValueAvailable()) {
                this.originalValue = dataType.getDisplayString(component.getPromptValue(), component.getLocale());
                text.setValue(this.originalValue);
            }
            visualToReturn = text;
        }
        this.promptVisual = visualToReturn;
        this.component = component;
        return visualToReturn;
    }

    @Override
    public Object getPromptValue() {
        if (this.component.isPromptValueAvailable()) {
            return this.component.getPromptValue();
        }
        return null;
    }

    private class EditorScrollPane
    extends JScrollPane
    implements EditorInterface {
        public EditorScrollPane() {
        }

        public EditorScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
            super(view, vsbPolicy, hsbPolicy);
        }

        public EditorScrollPane(Component view) {
            super(view);
        }

        public EditorScrollPane(int vsbPolicy, int hsbPolicy) {
            super(vsbPolicy, hsbPolicy);
        }

        public void addEditorListener(EditorListener listener) {
        }

        public Component getEditorComponent() {
            return this;
        }

        public boolean isEditing() {
            return false;
        }

        public void removeEditorListener(EditorListener listener) {
        }

        public Object getValue() {
            return null;
        }

        public void setValue(Object anObject) {
        }
    }
}

