/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.util.remote;

import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.models.FileLocation;
import com.sas.models.FileLocationInterface;
import com.sas.models.Hyperlink;
import com.sas.models.HyperlinkInterface;
import com.sas.models.OLAPMemberName;
import com.sas.models.OLAPMemberNameInterface;
import com.sas.models.SASLibraryLocation;
import com.sas.models.SASLibraryLocationInterface;
import com.sas.models.datasources.DataSourceColumnInterface;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.PromptComponentModelInterface;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.PromptViewInterface;
import com.sas.prompts.definitions.DataSourceColumnDefinitionInterface;
import com.sas.prompts.definitions.DataSourceDefinitionInterface;
import com.sas.prompts.definitions.FileSelectionInterface;
import com.sas.prompts.definitions.HyperlinkDefinitionInterface;
import com.sas.prompts.definitions.OLAPMemberNameDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.SASLibraryDefinitionInterface;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.storage.exception.ServerConnectionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public final class PromptRemoteUtil {
    private PromptRemoteUtil() {
    }

    public static boolean isAllDependentPromptValuesSet(Collection dependentPrompts, PromptValuesInterface promptValues) {
        if (dependentPrompts != null) {
            try {
                for (Object obj : dependentPrompts) {
                    Prompt dependentPrompt;
                    if (obj instanceof String) {
                        PromptDefinitionInterface pd = promptValues.getPromptDefinition((String)obj, true);
                        if (pd == null || promptValues.isPromptValueAvailable(pd) && promptValues.getPromptValue(pd) != null) continue;
                        return false;
                    }
                    if (obj instanceof Prompt) {
                        dependentPrompt = (Prompt)obj;
                        try {
                            PromptDefinitionInterface pd = promptValues.getPromptDefinition(dependentPrompt.getID(), true);
                            if (pd == null || promptValues.isPromptValueAvailable(pd) && promptValues.getPromptValue(pd) != null) continue;
                            return false;
                        }
                        catch (InvalidIDException ie) {
                            return false;
                        }
                    }
                    dependentPrompt = (PromptDefinitionInterface)obj;
                    if (promptValues.isPromptValueAvailable((PromptDefinitionInterface)dependentPrompt) && promptValues.getPromptValue((PromptDefinitionInterface)dependentPrompt) != null) continue;
                    return false;
                }
            }
            catch (PromptValueNotFoundException e) {
                return false;
            }
        }
        return true;
    }

    public static boolean isAllDependentPromptValuesSet(PromptValuesInterface promptValues, PromptDefinitionInterface promptDefinition, DynamicPromptValueContextInterface dynamicValueContext, Locale locale) {
        return PromptRemoteUtil.isAllDependentPromptValuesSet(PromptRemoteUtil.getDependentPrompts(promptDefinition, dynamicValueContext, locale), promptValues);
    }

    public static boolean isAllDependentPromptValuesSet(Collection dependentViews) {
        if (dependentViews != null) {
            for (PromptComponentModelInterface component : dependentViews) {
                if (component.isPromptValueAvailable() && component.getPromptValue() != null) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAllDependentPromptValuesSet(PromptComponentModelInterface component) {
        boolean ret = PromptRemoteUtil.isAllDependentPromptValuesSet(component.getDynamicPromptValuesContext().getDependentPromptViews((PromptViewInterface)component));
        return ret;
    }

    public static boolean isCascadedPrompt(PromptDefinitionInterface promptDefinition, DynamicPromptValueContextInterface dynamicValueContext, Locale locale) {
        Collection dependentPromptNames = promptDefinition.getDependentPrompts(locale, dynamicValueContext);
        if (dependentPromptNames != null && !dependentPromptNames.isEmpty()) {
            return true;
        }
        Collection dependencies = promptDefinition.getAdditionalCascadeDependencies();
        return dependencies != null && !dependencies.isEmpty();
    }

    public static Collection getDependentPrompts(PromptDefinitionInterface promptDefinition, DynamicPromptValueContextInterface dynamicValueContext, Locale locale) {
        ArrayList returnList = new ArrayList();
        Collection dependentPrompts = promptDefinition.getDependentPrompts(locale, dynamicValueContext);
        Collection additionalDependencies = promptDefinition.getAdditionalCascadeDependencies();
        PromptRemoteUtil.addDependentPrompts(promptDefinition, dynamicValueContext, locale, returnList, dependentPrompts);
        PromptRemoteUtil.addDependentPrompts(promptDefinition, dynamicValueContext, locale, returnList, additionalDependencies);
        return returnList;
    }

    private static void addDependentPrompts(PromptDefinitionInterface promptDefinition, DynamicPromptValueContextInterface dynamicValueContext, Locale locale, List destinationList, Collection source) {
        if (source != null && !source.isEmpty()) {
            for (PromptDefinitionInterface element : source) {
                if (element == promptDefinition || destinationList.contains(element)) continue;
                destinationList.add(element);
                Collection dp = PromptRemoteUtil.getDependentPrompts(element, dynamicValueContext, locale);
                PromptRemoteUtil.addDependentPrompts(element, dynamicValueContext, locale, destinationList, dp);
            }
        }
    }

    public static boolean isCascadedView(PromptComponentModelInterface component) {
        Collection dependencies;
        return component != null && (dependencies = component.getDynamicPromptValuesContext().getDependentPromptViews((PromptViewInterface)component)) != null && !dependencies.isEmpty();
    }

    public static FileLocationInterface constructFileLocationValue(String path, PromptDefinitionInterface prompt, Locale locale) {
        if (prompt instanceof FileSelectionInterface) {
            FileSelectionInterface filePrompt = (FileSelectionInterface)prompt;
            boolean isDirectory = false;
            if (filePrompt.getFileSelectionMode() == 2) {
                isDirectory = true;
            } else if (filePrompt.getFileSelectionMode() == 0) {
                throw new IllegalArgumentException("constructFileLocationValue() cannot be used with FileSelectionInterface.FILES_AND_DIRECTORIES");
            }
            FileLocation fileLocation = new FileLocation(filePrompt.getLogicalServerName(), path, isDirectory);
            return fileLocation;
        }
        throw new IllegalArgumentException("Invalid prompt type");
    }

    public static HyperlinkInterface constructHyperlinkValue(String url, String label, PromptDefinitionInterface prompt, Locale locale) {
        if (prompt instanceof HyperlinkDefinitionInterface) {
            HyperlinkDefinitionInterface hyperlinkPrompt = (HyperlinkDefinitionInterface)prompt;
            Hyperlink hyperlink = new Hyperlink(url, label, locale);
            return hyperlink;
        }
        throw new IllegalArgumentException("Invalid prompt type");
    }

    public static Collection constructOLAPMemberNameValues(String[] uniqueNames, String[] labels, PromptDefinitionInterface prompt, Locale locale) {
        ArrayList<OLAPMemberNameInterface> values = new ArrayList<OLAPMemberNameInterface>(uniqueNames.length);
        if (prompt instanceof OLAPMemberNameDefinitionInterface) {
            for (int i = 0; i < uniqueNames.length; ++i) {
                String label = null;
                if (labels != null) {
                    label = labels[i];
                }
                OLAPMemberNameInterface olapMemberNameValue = PromptRemoteUtil.constructOLAPMemberNameValue(uniqueNames[i], label, prompt, locale);
                values.add(olapMemberNameValue);
            }
            return values;
        }
        throw new IllegalArgumentException("Invalid prompt type");
    }

    public static OLAPMemberNameInterface constructOLAPMemberNameValue(String uniqueName, String label, PromptDefinitionInterface prompt, Locale locale) {
        if (prompt instanceof OLAPMemberNameDefinitionInterface) {
            OLAPMemberNameDefinitionInterface olapPrompt = (OLAPMemberNameDefinitionInterface)prompt;
            if (label == null) {
                // empty if block
            }
            OLAPMemberName memberName = new OLAPMemberName(null, uniqueName, label, locale);
            return memberName;
        }
        throw new IllegalArgumentException("Invalid prompt type");
    }

    public static SASLibraryLocationInterface constructSASLibraryLocationValue(String path, String libref, PromptDefinitionInterface prompt, Locale locale) {
        if (prompt instanceof SASLibraryDefinitionInterface) {
            SASLibraryDefinitionInterface libraryPrompt = (SASLibraryDefinitionInterface)prompt;
            SASLibraryLocation library = new SASLibraryLocation(path, libref);
            return library;
        }
        throw new IllegalArgumentException("Invalid prompt type");
    }

    public static SASLibraryLocationInterface constructSASLibraryLocationValue(String path, DataProviderInterface dataProviderObj, PromptDefinitionInterface prompt, Locale locale) throws ServerConnectionException {
        if (prompt instanceof SASLibraryDefinitionInterface) {
            if (dataProviderObj instanceof DataProvider) {
                DataProvider dataProvider = (DataProvider)dataProviderObj;
                String libref = dataProvider.getLibrefForLibrary(path);
                SASLibraryLocation libLoc = new SASLibraryLocation(path, libref);
                return libLoc;
            }
            throw new IllegalArgumentException("Invalid data provider type");
        }
        throw new IllegalArgumentException("Invalid prompt type");
    }

    public static Collection constructDataSources(String[] dataSourcePaths, DataProviderInterface dataProviderObj, PromptDefinitionInterface prompt, Locale locale) throws ServerConnectionException {
        if (prompt instanceof DataSourceDefinitionInterface && dataProviderObj instanceof DataProvider) {
            DataProvider dataProvider = (DataProvider)dataProviderObj;
            ArrayList<DataSourceInterface> dataSources = new ArrayList<DataSourceInterface>(dataSourcePaths.length);
            for (int i = 0; i < dataSourcePaths.length; ++i) {
                DataSourceInterface dataSource = dataProvider.getDataSourceByPath(dataSourcePaths[i], locale);
                dataSources.add(dataSource);
            }
            return dataSources;
        }
        throw new IllegalArgumentException("Invalid prompt type");
    }

    public static Collection constructDataSourceColumnValues(String[] dataSourcePaths, String[] itemNames, DataProviderInterface dataProviderObj, PromptDefinitionInterface prompt, Locale locale) throws ServerConnectionException {
        if (prompt instanceof DataSourceColumnDefinitionInterface) {
            if (dataSourcePaths.length != itemNames.length) {
                throw new IllegalArgumentException("Length of all array parameters must be equal");
            }
            HashMap dataSourceMap = new HashMap();
            if (dataProviderObj instanceof DataProvider) {
                DataProvider dataProvider = (DataProvider)dataProviderObj;
                ArrayList<DataSourceColumnInterface> dataSourceColumns = new ArrayList<DataSourceColumnInterface>(dataSourcePaths.length);
                for (int i = 0; i < dataSourcePaths.length; ++i) {
                    DataSourceInterface dataSource = null;
                    dataSource = dataSourceMap.containsKey(dataSourcePaths[i]) ? (DataSourceInterface)dataSourceMap.get(dataSourcePaths[i]) : dataProvider.getDataSourceByPath(dataSourcePaths[i], locale);
                    DataSourceColumnInterface dataSourceColumn = dataProvider.getDataSourceColumnForItem(dataSource, itemNames[i], locale);
                    dataSourceColumns.add(dataSourceColumn);
                }
                return dataSourceColumns;
            }
        }
        throw new IllegalArgumentException("Invalid prompt type");
    }
}

